/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.ApplicationContextBean;
import jp.jasminesoft.jfc.gen.CompatibilityManager;
import jp.jasminesoft.jfc.gen.ConfigGenerator;
import jp.jasminesoft.jfc.gen.ControllerGenerator;
import jp.jasminesoft.jfc.gen.ControllerGeneratorFactory;
import jp.jasminesoft.jfc.gen.IGenerateControllerBean;
import jp.jasminesoft.jfc.gen.IGeneratorFactory;
import jp.jasminesoft.jfc.gen.ISourceVariable;
import jp.jasminesoft.jfc.gen.JFCAppGenerator;
import jp.jasminesoft.jfc.gen.ReportListServiceGenerator;
import jp.jasminesoft.jfc.gen.SpringApplicationContextGenerator;
import jp.jasminesoft.jfc.gen.XmlConfigGenerator;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Database;
import jp.jasminesoft.jfc.gen.appschema.Environment;
import jp.jasminesoft.jfc.gen.appschema.Filestore;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.MessageQueue;
import jp.jasminesoft.jfc.gen.appschema.Messagejob;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.QuartzJDBCJobstore;
import jp.jasminesoft.util.FileTemplateManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ControllerXmlGenerator
extends XmlConfigGenerator
implements IGeneratorFactory {
    protected static Logger logger = LogManager.getLogger((String)ControllerGeneratorFactory.class.getName());
    private static final String JfcMessageQueueId = "jfcMessageQueue";
    private boolean isFullBuild;
    private static String[] reserve_action_path = new String[]{"logoff", "autoLogoff", "logon", "menu", "mainMenu", "mobileMenu"};
    private Set<String> reserveActionPath = new HashSet<String>();
    private static final Basecontroller[] BASE_CONTROLLERS = new Basecontroller[]{new Basecontroller("LogonPageController"), new Basecontroller("LogonController"), new Basecontroller("LogoffController"), new Basecontroller("MenuController"), new Basecontroller("SubmenuController"), new Basecontroller("MobileMenuController"), new Basecontroller("RemindPasswordController"), new Basecontroller("SetNewPasswordController"), new Basecontroller("GlobalForwardMenuController"), new Basecontroller("GridSettingController")};
    private static final String[] PKG_BASE_CONTROLLER_NAME = new String[]{"ShowWorkFlowStatusController"};
    private static final String DefaultJobQueue = "wagbyJobQueue";

    public ControllerXmlGenerator(String tmplatefilename, Project project, boolean isFullBuild) {
        super(tmplatefilename, project);
        for (int i = 0; i < reserve_action_path.length; ++i) {
            this.reserveActionPath.add(reserve_action_path[i]);
        }
        this.isFullBuild = isFullBuild;
    }

    @Override
    public String getFileSuffix() {
        return ".xml";
    }

    @Override
    public String getFilename() {
        return "wagby-servlet";
    }

    @Override
    public String getSubpackageName() {
        return "webpage" + File.separator + "WEB-INF";
    }

    @Override
    protected String getCustomizeDirectory() {
        return "wagby-servlet";
    }

    @Override
    public String process0() {
        FileTemplateManager tplman = new FileTemplateManager(this.getTmplateFilename());
        if (!tplman.isValid()) {
            return "";
        }
        String pkgname = this.project.getPackage();
        for (Basecontroller bc : BASE_CONTROLLERS) {
            if (bc.isCustomize(pkgname)) {
                tplman.addContent(bc.getClassname(), bc.getCustomizeClassname(pkgname));
                continue;
            }
            tplman.addContent(bc.getClassname(), bc.getExtendsClassname());
        }
        for (String n : PKG_BASE_CONTROLLER_NAME) {
            Basecontroller bc = new Basecontroller(n, pkgname);
            if (bc.isCustomize(pkgname)) {
                tplman.addContent(bc.getClassname(), bc.getCustomizeClassname(pkgname));
                continue;
            }
            tplman.addContent(bc.getClassname(), bc.getExtendsClassname());
        }
        LinkedHashMap<String, List<ActionNode>> ruleMap = new LinkedHashMap<String, List<ActionNode>>();
        IProjectChoice[] ipc = this.project.getContent();
        if (ipc != null) {
            for (int i = 0; i < ipc.length; ++i) {
                Action action;
                if (!(ipc[i] instanceof Action) || !(action = (Action)ipc[i]).getStrutsclassgen()) continue;
                this.addTask(action, ruleMap);
            }
        }
        this.createRuleDefinition(ruleMap);
        this.addManagerBeans();
        this.createMessageQueueBean();
        this.addCustomizeFile();
        tplman.addContent("packagename", this.project.getPackage());
        tplman.addContent("rulecontent", this.createEntityRef());
        Environment env = this.project.getEnvironment();
        Integer browserCacheMaxAge = null;
        if (env != null) {
            browserCacheMaxAge = env.getBrowserCacheMaxAgeAsInteger();
        }
        if (browserCacheMaxAge != null) {
            tplman.addContent("browserCacheMaxAgeAttr", " cache-period=\"" + browserCacheMaxAge.toString() + "\"");
        } else {
            tplman.addContent("browserCacheMaxAgeAttr", "");
        }
        tplman.addContent("MakeTextIndexInitializer", this.createMakeTextIndexInitializer());
        Database database = AppSchemaUtil.getDatabase(this.project.getEnvironment());
        QuartzJDBCJobstore qjj = database.getQuartzJDBCJobstore();
        tplman.addContent("QuartzJDBCJobstoreProperty", this.createQuartzJDBCJobstoreSchedulerProperty(qjj));
        String manclass = null;
        if (qjj != null) {
            manclass = SpringApplicationContextGenerator.getJFCQuartzJobManagerClassname(qjj);
        }
        tplman.addContent("SchedulerDomain", this.createSchedulerDomainBean(qjj, manclass));
        tplman.addContent("SchedulerRAM", this.createSchedulerRAMBean(qjj, manclass));
        this.saveSeparateConfigFile();
        return tplman.getResult();
    }

    private void addManagerBeans() {
        StringBuilder sb = new StringBuilder();
        sb.append(CR);
        sb.append(new ApplicationContextBean("MailMessageManager", this.packagename + ".app.MyMailMessageManager", true));
        sb.append(CR);
        sb.append(new ApplicationContextBean("JfccspreferenceitemManager", this.packagename + ".app.JfccspreferenceitemManagerImpl", true));
        sb.append(CR);
        sb.append(new ApplicationContextBean("cssFileManager", "jp.jasminesoft.jfc.CssFileManager", true));
        sb.append(CR);
        sb.append(new ApplicationContextBean("fontsizeFileManager", "jp.jasminesoft.jfc.FontsizeFileManager", true));
        sb.append(CR);
        ApplicationContextBean bean = new ApplicationContextBean("pankuzuManager", "jp.jasminesoft.jfc.PankuzuManager");
        bean.setScope("session");
        sb.append(bean);
        sb.append(CR);
        sb.append(new ApplicationContextBean("principalCategoryManager", "jp.jasminesoft.jfc.app.PrincipalCategoryManager", true));
        sb.append(CR);
        this.addFilestoreBean(sb);
        this.putContentPart("__manager", sb.toString());
    }

    private void addFilestoreBean(StringBuilder sb) {
        Filestore filestore = AppSchemaUtil.getFilestore(this.project.getEnvironment());
        String type = filestore == null ? "file" : filestore.getType();
        if (type.equals("file")) {
            String downloadFileObjectFactoryClassname = "jp.jasminesoft.jfc.app.DownloadFileObjectFactoryFileImpl";
            ApplicationContextBean bean = new ApplicationContextBean("DownloadFileObjectFactory", "jp.jasminesoft.jfc.app.DownloadFileObjectFactoryFileImpl", true);
            sb.append(bean);
            sb.append(CR);
        } else if (type.equals("s3")) {
            String downloadFileObjectFactoryClassname = "jp.jasminesoft.jfc.app.DownloadFileObjectFactoryS3Impl";
            ApplicationContextBean bean = new ApplicationContextBean("DownloadFileObjectFactory", downloadFileObjectFactoryClassname, true);
            sb.append(bean);
            sb.append(CR);
            downloadFileObjectFactoryClassname = "jp.jasminesoft.jfc.app.DownloadFileObjectFactoryFileImpl";
            bean = new ApplicationContextBean("DownloadFileObjectFactoryFileImpl", downloadFileObjectFactoryClassname, true);
            sb.append(bean);
            sb.append(CR);
        } else if (type.equals("jfcfilestatus")) {
            Model model = AppSchemaUtil.getModel(this.project, "jfcfilestatus");
            String jfcfilestatusMetaClassname = AppSchemaUtil.getPackagename(model, this.project) + AppSchemaUtil.getClassname(model) + "Meta";
            ApplicationContextBean jfcfilestatusMetaBean = new ApplicationContextBean("JfcfilestatusMeta", jfcfilestatusMetaClassname, true);
            sb.append(jfcfilestatusMetaBean);
            sb.append(CR);
            String downloadFileObjectFactoryClassname = "jp.jasminesoft.jfc.app.DownloadFileObjectFactoryJfcfilestatusImpl";
            ApplicationContextBean bean = new ApplicationContextBean("DownloadFileObjectFactory", downloadFileObjectFactoryClassname, true);
            sb.append(bean);
            sb.append(CR);
            downloadFileObjectFactoryClassname = "jp.jasminesoft.jfc.app.DownloadFileObjectFactoryFileImpl";
            bean = new ApplicationContextBean("DownloadFileObjectFactoryFileImpl", downloadFileObjectFactoryClassname, true);
            sb.append(bean);
            sb.append(CR);
            downloadFileObjectFactoryClassname = "jp.jasminesoft.jfc.app.DownloadFileObjectFactoryS3BaseImpl";
            bean = new ApplicationContextBean("DownloadFileObjectFactoryS3BaseImpl", downloadFileObjectFactoryClassname, true);
            sb.append(bean);
            sb.append(CR);
        } else {
            logger.error("Unknown filestore type " + type);
        }
    }

    private String createMakeTextIndexInitializer() {
        boolean hasTextSearchModel = AppSchemaUtil.hasTextSearchModel(this.project);
        if (JFCAppGenerator.getIsTextSearch() && hasTextSearchModel) {
            ControllerGenerator.ActionNode actionNode = new ControllerGenerator.ActionNode();
            actionNode.setBeanid("MakeTextIndexInitializer");
            actionNode.setBeanclass("jp.jasminesoft.jfc.textsearch.servlet.MakeTextIndexInitializer");
            return actionNode.toString("    ");
        }
        return "";
    }

    private String createQuartzJDBCJobstoreSchedulerProperty(QuartzJDBCJobstore qjj) {
        if (qjj == null) {
            return "";
        }
        String[] property = new String[]{"<prop key=\"org.quartz.scheduler.instanceId\">AUTO</prop>", "<prop key=\"org.quartz.jobStore.isClustered\">true</prop>", "<prop key=\"org.quartz.jobStore.driverDelegateClass\">" + qjj.getDriverDelegateClass() + "</prop>", "<prop key=\"org.quartz.jobStore.class\">org.quartz.impl.jdbcjobstore.JobStoreTX</prop>", "<prop key=\"org.quartz.jobStore.tablePrefix\">QRTZ_</prop>", "<prop key=\"org.quartz.jobStore.dataSource\">myDS</prop>", "<prop key=\"org.quartz.dataSource.myDS.jndiURL\">java:comp/env/jdbc/jfc</prop>"};
        StringBuilder sb = new StringBuilder();
        for (String s : property) {
            sb.append("        ");
            sb.append(s);
            sb.append(CR);
        }
        return sb.toString();
    }

    private String createSchedulerDomainBean(QuartzJDBCJobstore qjj, String manclass) {
        if (qjj == null) {
            return "";
        }
        if (!this.isUseSchedulerDomain(manclass)) {
            return "";
        }
        int domain = this.project.getEnvironment().getDomain();
        String[] property = new String[]{"<bean id=\"schedulerDomain\"", "    class=\"org.springframework.scheduling.quartz.SchedulerFactoryBean\">", "    <property name=\"applicationContextSchedulerContextKey\">", "        <value>__jfcjob_appctx</value>", "    </property>", "    <property name=\"schedulerName\">", "        <value>schedulerDomain_" + domain + "</value>", "    </property>", "    <property name=\"quartzProperties\" ref=\"quartzJDBCJobStoreProps\"/>", "</bean>"};
        StringBuilder sb = new StringBuilder();
        for (String s : property) {
            sb.append("    ");
            sb.append(s);
            sb.append(CR);
        }
        return sb.toString();
    }

    private String createSchedulerRAMBean(QuartzJDBCJobstore qjj, String manclass) {
        if (qjj == null) {
            return "";
        }
        boolean isCommentout = false;
        if (!this.isUseSchedulerRAM(manclass)) {
            isCommentout = true;
        }
        String[] property = new String[]{"<bean id=\"schedulerRAM\"", "    class=\"org.springframework.scheduling.quartz.SchedulerFactoryBean\">", "    <property name=\"applicationContextSchedulerContextKey\">", "        <value>__jfcjob_appctx</value>", "    </property>", "    <property name=\"quartzProperties\">", "      <props>", "        <prop key=\"org.quartz.scheduler.skipUpdateCheck\">true</prop>", "        <prop key=\"org.quartz.threadPool.threadCount\">5</prop>", "      </props>", "    </property>", "</bean>"};
        StringBuilder sb = new StringBuilder();
        if (isCommentout) {
            sb.append("<!--").append(CR);
        }
        for (String s : property) {
            sb.append("    ");
            sb.append(s);
            sb.append(CR);
        }
        if (isCommentout) {
            sb.append("-->").append(CR);
        }
        return sb.toString();
    }

    private boolean isUseSchedulerDomain(String manclass) {
        return SpringApplicationContextGenerator.isUseDomainScheduler(manclass);
    }

    private boolean isUseSchedulerRAM(String manclass) {
        return SpringApplicationContextGenerator.isUseJDBCJobstore(manclass);
    }

    private boolean isUseWagbyJobTopic(String manclass) {
        return SpringApplicationContextGenerator.isUseV2JDBCScheduler(manclass);
    }

    private String getDefaultJobQueue() {
        Integer domainid = this.project.getEnvironment().getDomainAsInteger();
        if (domainid == null) {
            return DefaultJobQueue;
        }
        return "wagbyJobQueue_" + domainid;
    }

    private void createMessageQueueBean() {
        StringBuilder sb = new StringBuilder();
        boolean isEmpty = true;
        List<MessageQueue> messageQueues = AppSchemaUtil.getMessageQueue(this.project.getEnvironment());
        for (MessageQueue messageQueue : messageQueues) {
            if (messageQueue.getType().equals("RabbitMQ")) {
                this.createRabbitMQMessageQueueBean(sb, messageQueue);
                isEmpty = false;
                continue;
            }
            if (messageQueue.getType().equals("ActiveMQ")) {
                this.createActiveMQMessageQueueBean(sb, messageQueue);
                isEmpty = false;
                continue;
            }
            logger.error("Unknown messageQueue type " + messageQueue);
        }
        if (isEmpty) {
            sb.append("    ");
            sb.append("<bean id=\"JfcjobstatusRegistryService\"");
            sb.append(CR);
            sb.append("        ");
            sb.append("class=\"jp.jasminesoft.jfc.job.JfcjobstatusRegistryService\">");
            sb.append(CR);
            sb.append("    ");
            sb.append("</bean>");
            sb.append(CR);
        } else {
            sb.append("    ");
            sb.append("<bean id=\"JobExecutionMessageListener\"");
            sb.append(CR);
            sb.append("        ");
            sb.append("class=\"jp.jasminesoft.jfc.job.JobExecutionMessageListener\">");
            sb.append(CR);
            sb.append("    ");
            sb.append("</bean>");
            sb.append(CR);
            sb.append(CR);
        }
        this.putContentPart(JfcMessageQueueId, sb.toString());
    }

    private void createRabbitMQMessageQueueBean(StringBuilder sb, MessageQueue messageQueue) {
        TreeSet<String> listenqueues = this.getListenqueues(messageQueue);
        TreeSet<String> createqueues = new TreeSet<String>();
        if (StringUtils.isNotBlank((CharSequence)messageQueue.getCreateQueues())) {
            String[] sa = messageQueue.getCreateQueues().split("[ ,]");
            createqueues.addAll(Arrays.asList(sa));
        }
        createqueues.addAll(listenqueues);
        sb.append("    ");
        sb.append("<!-- RabbitMQ Configuration -->");
        sb.append(CR);
        sb.append("    ");
        sb.append("<bean id=\"JfcjobstatusRegistryServiceAmqpImpl\"");
        sb.append(CR);
        sb.append("        ");
        sb.append("class=\"jp.jasminesoft.jfc.job.JfcjobstatusRegistryServiceAmqpImpl\"");
        if (messageQueue.getPrimary()) {
            sb.append(" primary=\"true\"");
        }
        sb.append(">");
        sb.append(CR);
        sb.append("        ");
        sb.append("<property name=\"defaultRoutingKey\"><value>");
        sb.append(this.getDefaultJobQueue());
        sb.append("</value></property>");
        sb.append(CR);
        sb.append("    ");
        sb.append("</bean>");
        sb.append(CR);
        sb.append(CR);
        sb.append("    ");
        sb.append("<rabbit:admin connection-factory=\"rabbitConnectionFactory\"/>");
        sb.append(CR);
        sb.append(CR);
        for (String createqueue : createqueues) {
            sb.append("    ");
            sb.append("<rabbit:queue name=\"" + createqueue + "\"/>");
            sb.append(CR);
        }
        sb.append(CR);
        sb.append("    ");
        sb.append("<rabbit:listener-container connection-factory=\"rabbitConnectionFactory\">");
        sb.append(CR);
        sb.append("        ");
        sb.append("<rabbit:listener queues=\"");
        boolean isFirst = true;
        for (String listenqueue : listenqueues) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(",");
            }
            sb.append(listenqueue);
        }
        sb.append("\" ref=\"JobExecutionMessageListener\" method=\"processQueue\"/>");
        sb.append(CR);
        sb.append("    ");
        sb.append("</rabbit:listener-container>");
        sb.append(CR);
        sb.append(CR);
    }

    private void createActiveMQMessageQueueBean(StringBuilder sb, MessageQueue messageQueue) {
        ArrayList<String> codes = new ArrayList<String>();
        codes.addAll(Arrays.asList("<!-- ActiveMQ Configuration -->", "<bean id=\"JfcjobstatusRegistryServiceJmsImpl\"", "    class=\"jp.jasminesoft.jfc.job.JfcjobstatusRegistryServiceJmsImpl\"" + (messageQueue.getPrimary() ? " primary=\"true\"" : "") + ">", "    <property name=\"jmsTemplate\"><ref bean=\"jmsTemplate\"/></property>", "    <property name=\"defaultDestinationName\"><value>" + this.getDefaultJobQueue() + "</value></property>", "</bean>", "", "<bean id=\"myDefaultJmsListenerContainerFactory\"", "    class=\"org.springframework.jms.config.DefaultJmsListenerContainerFactory\">", "    <property name=\"messageConverter\"><ref bean=\"myJmsMessageConverter\"/></property>", "</bean>", "", "<bean id=\"myJmsMessageConverter\"", "    class=\"jp.jasminesoft.jfc.job.SerializeJmsMessageConverter\">", "</bean>", "", "<jms:listener-container connection-factory=\"jmsConnectionFactory\" message-converter=\"myJmsMessageConverter\">"));
        Environment environment = this.project.getEnvironment();
        Database database = AppSchemaUtil.getDatabase(environment);
        QuartzJDBCJobstore qjj = database.getQuartzJDBCJobstore();
        String manclass = null;
        if (qjj != null) {
            manclass = SpringApplicationContextGenerator.getJFCQuartzJobManagerClassname(qjj);
        }
        List<String> codes2 = this.createJmsListener(messageQueue, environment, manclass);
        for (String code : codes2) {
            codes.add("    " + code);
        }
        codes.addAll(Arrays.asList("</jms:listener-container>", ""));
        if (qjj != null) {
            this.createActiveMQMessageQueueBeanJDBCJobstore(codes, qjj, manclass);
        }
        for (String code : codes) {
            sb.append("    ");
            sb.append(code);
            sb.append(CR);
        }
        sb.append(CR);
    }

    private List<String> createJmsListener(MessageQueue messageQueue, Environment environment, String manclass) {
        ArrayList<String> codes2 = new ArrayList<String>();
        TreeSet<String> listenqueues = this.getListenqueues(messageQueue);
        for (String listenqueue : listenqueues) {
            codes2.addAll(Arrays.asList("<jms:listener destination=\"" + listenqueue + "\"", "    ref=\"JobExecutionMessageListener\" method=\"processQueue\"/>"));
        }
        if (manclass != null && this.isUseSchedulerDomain(manclass)) {
            int myid = environment.getDomain();
            codes2.addAll(Arrays.asList("<jms:listener destination=\"JFCQuartzJobManagerScheduleDomainJobCommandQueue_" + myid + "\"", "    ref=\"JFCQuartzJobManagerMessageListener\" method=\"receiveMessage\"/>", "<jms:listener destination=\"JFCQuartzJobManagerDomainCommandQueue_" + myid + "\"", "    ref=\"JFCQuartzJobManagerMessageListener\" method=\"receiveMessage\"/>"));
        }
        return codes2;
    }

    private void createActiveMQMessageQueueBeanJDBCJobstore(List<String> codes, QuartzJDBCJobstore qjj, String manclass) {
        String[] codes2 = new String[]{"<bean id=\"jmsTemplate\"", "    class=\"org.springframework.jms.core.JmsTemplate\">", "    <property name=\"connectionFactory\"><ref bean=\"jmsConnectionFactory\"/></property>", "    <property name=\"messageConverter\"><ref bean=\"myJmsMessageConverter\"/></property>", "</bean>", "", "<bean id=\"topicJmsTemplate\"", "    class=\"org.springframework.jms.core.JmsTemplate\">", "    <property name=\"connectionFactory\"><ref bean=\"jmsConnectionFactory\"/></property>", "    <property name=\"pubSubDomain\"><value>true</value></property>", "    <property name=\"messageConverter\"><ref bean=\"myJmsMessageConverter\"/></property>", "</bean>", "", "<jms:listener-container connection-factory=\"jmsConnectionFactory\"", "    message-converter=\"myJmsMessageConverter\" destination-type=\"topic\">", "    <jms:listener destination=\"JFCQuartzJobManagerCommandTopic\"", "        ref=\"JFCQuartzJobManagerMessageListener\" method=\"receiveMessage\"/>", "    <jms:listener destination=\"JFCQuartzJobManagerScheduleRAMJobCommandTopic\"", "        ref=\"JFCQuartzJobManagerMessageListener\" method=\"receiveMessage\"/>"};
        String[] codes3 = new String[]{"</jms:listener-container>", "", "<bean id=\"JFCQuartzJobManagerMessageListener\"", "    class=\"jp.jasminesoft.jfc.JFCQuartzJobManagerMessageListener\">", "</bean>"};
        if (this.isUseWagbyJobTopic(manclass)) {
            codes.addAll(Arrays.asList(codes2));
            String topicJmsConnectionFactoryListener = "<jms:listener destination=\"wagbyJobTopic\" ref=\"JobExecutionMessageListener\" method=\"processQueue\"/>";
            codes.add("<jms:listener destination=\"wagbyJobTopic\" ref=\"JobExecutionMessageListener\" method=\"processQueue\"/>");
            codes.addAll(Arrays.asList(codes3));
            codes.addAll(Arrays.asList("", "<bean id=\"JfcjobstatusRegistryServiceJmsImplTopic\"", "    class=\"jp.jasminesoft.jfc.job.JfcjobstatusRegistryServiceJmsImpl\">", "    <property name=\"jmsTemplate\"><ref bean=\"topicJmsTemplate\"/></property>", "    <property name=\"defaultDestinationName\"><value>wagbyJobTopic</value></property>", "</bean>", "", "<bean id=\"SendJobExecutionMessageJob\"", "    class=\"jp.jasminesoft.jfc.job.SendJobExecutionMessageJob\">", "</bean>"));
        } else {
            codes.addAll(Arrays.asList(codes2));
            codes.addAll(Arrays.asList(codes3));
        }
        if (this.isUseSchedulerDomain(manclass)) {
            codes.addAll(Arrays.asList("", "<bean id=\"domainJmsTemplate\"", "    class=\"org.springframework.jms.core.JmsTemplate\">", "    <property name=\"connectionFactory\"><ref bean=\"jmsConnectionFactory\"/></property>", "    <property name=\"messageConverter\"><ref bean=\"myJmsMessageConverter\"/></property>", "    <property name=\"explicitQosEnabled\"><value>true</value></property>", "    <property name=\"timeToLive\"><value>3600000</value></property>", "</bean>"));
        }
    }

    private TreeSet<String> getListenqueues(MessageQueue messageQueue) {
        TreeSet<String> listenqueues = new TreeSet<String>();
        listenqueues.add(this.getDefaultJobQueue());
        if (StringUtils.isNotBlank((CharSequence)messageQueue.getListenJobQueues())) {
            String[] sa = messageQueue.getListenJobQueues().split("[ ,]");
            listenqueues.addAll(Arrays.asList(sa));
        }
        String queuetype = messageQueue.getType();
        boolean primary = messageQueue.getPrimary();
        for (IProjectChoice ipc : this.project.getContent()) {
            String routingKey;
            Messagejob messagejob;
            if (!(ipc instanceof Action) || (messagejob = AppSchemaUtil.getMessagejob((Action)ipc)) == null || (routingKey = messagejob.getRoutingKey()) == null) continue;
            String type = null;
            int idx = routingKey.indexOf(":");
            if (idx > 0) {
                type = routingKey.substring(0, idx);
                if (routingKey.length() > idx + 1) {
                    routingKey = routingKey.substring(idx + 1);
                } else {
                    routingKey = null;
                    continue;
                }
            }
            if (StringUtils.isNotBlank(type) ? (type.equalsIgnoreCase("rabbitmq") ? !queuetype.equalsIgnoreCase("rabbitmq") : (type.equalsIgnoreCase("activemq") ? !queuetype.equalsIgnoreCase("activemq") : !type.equalsIgnoreCase("default") || !primary)) : !primary) continue;
            listenqueues.add(routingKey);
        }
        return listenqueues;
    }

    protected ActionNode createActionNode(String id, Action action) {
        ActionNode node = new ActionNode(action, id);
        return node;
    }

    protected void addTask(Action action, Map<String, List<ActionNode>> ruleMap) {
        ActionNode node;
        List<ActionNode> list;
        String id = action.getIdref();
        if (id == null) {
            id = "jfc";
        }
        if ((list = ruleMap.get(id)) == null) {
            list = new ArrayList<ActionNode>();
            ruleMap.put(id, list);
        }
        if ((node = this.createActionNode(id, action)) == null) {
            return;
        }
        list.add(node);
    }

    protected void createRuleDefinition(Map<String, List<ActionNode>> ruleMap) {
        ReportListServiceGenerator rlsgen = new ReportListServiceGenerator(this.project);
        ArrayList<String> keyList = new ArrayList<String>(ruleMap.keySet());
        Collections.sort(keyList);
        for (int i = 0; i < keyList.size(); ++i) {
            ApplicationContextBean bean;
            String gid = (String)keyList.get(i);
            if (this.isReservedActionPath(gid)) continue;
            List<ActionNode> list = ruleMap.get(gid);
            Collections.sort(list);
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < list.size(); ++j) {
                IGenerateControllerBean[] contgens;
                ActionNode node = list.get(j);
                Action action = node.getAction();
                for (IGenerateControllerBean contgen : contgens = ControllerGeneratorFactory.createGenerateControllerBean(this.project, action)) {
                    String code = contgen.generateControllerBean("    ");
                    if (code == null) continue;
                    sb.append(code);
                }
            }
            Model smodel = AppSchemaUtil.getModel(this.project, gid);
            if (smodel != null) {
                IGenerateControllerBean[] contgens;
                for (IGenerateControllerBean contgen : contgens = ControllerGeneratorFactory.createGenerateControllerBeanForStoreModel(this.project, smodel)) {
                    String code = contgen.generateControllerBean("    ");
                    if (code == null) continue;
                    sb.append(code);
                }
            }
            if ((bean = rlsgen.getApplicationContextBean(gid)) != null) {
                sb.append(bean.makeTextDocument("    "));
                sb.append(CR);
            }
            this.putContentPart(gid, sb.toString());
        }
    }

    protected boolean isReservedActionPath(String key) {
        return this.reserveActionPath.contains(key);
    }

    @Override
    protected void saveSeparateConfigFile0(String id, String content) {
        XmlBlockGenerator scbg = new XmlBlockGenerator(id, content, this.project);
        scbg.process();
    }

    @Override
    protected void createEntityRef0(String gid, StringBuilder sb) {
        sb.append("    ");
        sb.append("<import resource=\"wagby-servlet/");
        sb.append(gid);
        sb.append(".xml\"/>");
        sb.append(CR);
    }

    public static class Basecontroller {
        private String classname;
        private String extendsclassname;

        Basecontroller(String classname) {
            this(classname, "jp.jasminesoft.jfc");
        }

        Basecontroller(String classname, String extendspkgname) {
            this.classname = classname;
            this.extendsclassname = extendspkgname + ".controller." + classname;
        }

        public String getClassname() {
            return this.classname;
        }

        public String getExtendsClassname() {
            return this.extendsclassname;
        }

        public boolean isCustomize(String pkgname) {
            String cclassname = this.getCustomizeClassname(pkgname);
            String cfn = cclassname.replace('.', File.separatorChar) + ".java";
            return ApplicationContextBean.existsCustomizeFile(cfn);
        }

        public String getCustomizeClassname(String pkgname) {
            return pkgname + ".controller.My" + this.classname;
        }
    }

    class ActionNode
    implements Comparable<ActionNode> {
        private Action action;
        private String modelid;

        ActionNode(Action action, String path) {
            this.action = action;
            String modelid = action.getIdref();
            this.modelid = modelid != null && modelid.length() > 0 ? modelid : "system";
        }

        String getModelId() {
            return this.modelid;
        }

        Action getAction() {
            return this.action;
        }

        @Override
        public int compareTo(ActionNode an) {
            return this.modelid.compareTo(an.modelid);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("action=" + this.action.getId() + ISourceVariable.CR);
            sb.append("modelid=" + this.modelid + ISourceVariable.CR);
            return sb.toString();
        }
    }

    class XmlBlockGenerator
    extends ConfigGenerator {
        private String id;
        private String content;

        XmlBlockGenerator(String id, String content, Project project) {
            super(null, project);
            this.id = id;
            this.content = content;
        }

        @Override
        public String getFileSuffix() {
            return ".xml";
        }

        @Override
        public String getFilename() {
            return this.id;
        }

        @Override
        public String getSubpackageName() {
            return "webpage" + File.separator + "WEB-INF" + File.separator + "wagby-servlet";
        }

        @Override
        public String getEncoding() {
            return "UTF-8";
        }

        @Override
        public String process0() {
            StringBuilder sb = new StringBuilder();
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            sb.append(CR);
            sb.append("<beans ");
            if (CompatibilityManager.getInstance().getBooleanValue("jp.jasminesoft.jfc.gen.WebXmlUtils.lazy-initialization") && !ControllerXmlGenerator.this.isFullBuild) {
                sb.append("default-lazy-init=\"true\"").append(CR).append("       ");
            }
            sb.append("xmlns=\"http://www.springframework.org/schema/beans\"").append(CR);
            sb.append("    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
            sb.append(CR);
            sb.append("    xmlns:context=\"http://www.springframework.org/schema/context\"");
            sb.append(CR);
            sb.append("    xmlns:util=\"http://www.springframework.org/schema/util\"");
            sb.append(CR);
            sb.append("    xmlns:mvc=\"http://www.springframework.org/schema/mvc\"");
            sb.append(CR);
            List<MessageQueue> messageQueues = AppSchemaUtil.getMessageQueue(this.project.getEnvironment());
            boolean isRabbitMQ = false;
            boolean isActiveMQ = false;
            for (MessageQueue messageQueue : messageQueues) {
                if (messageQueue.getType().equals("RabbitMQ")) {
                    isRabbitMQ = true;
                    continue;
                }
                if (!messageQueue.getType().equals("ActiveMQ")) continue;
                isActiveMQ = true;
            }
            if (isRabbitMQ) {
                sb.append("    xmlns:rabbit=\"http://www.springframework.org/schema/rabbit\"");
                sb.append(CR);
            }
            if (isActiveMQ) {
                sb.append("    xmlns:jms=\"http://www.springframework.org/schema/jms\"");
                sb.append(CR);
            }
            sb.append("    xsi:schemaLocation=\"");
            sb.append(CR);
            sb.append("        http://www.springframework.org/schema/beans ");
            sb.append(CR);
            sb.append("        http://www.springframework.org/schema/beans/spring-beans.xsd");
            sb.append(CR);
            sb.append("        http://www.springframework.org/schema/context ");
            sb.append(CR);
            sb.append("        http://www.springframework.org/schema/context/spring-context.xsd");
            sb.append(CR);
            sb.append("        http://www.springframework.org/schema/util ");
            sb.append(CR);
            sb.append("        http://www.springframework.org/schema/util/spring-util.xsd");
            sb.append(CR);
            sb.append("        http://www.springframework.org/schema/mvc");
            sb.append(CR);
            sb.append("        http://www.springframework.org/schema/mvc/spring-mvc.xsd");
            if (isRabbitMQ) {
                sb.append(CR);
                sb.append("        http://www.springframework.org/schema/rabbit");
                sb.append(CR);
                sb.append("        http://www.springframework.org/schema/rabbit/spring-rabbit.xsd");
            }
            if (isActiveMQ) {
                sb.append(CR);
                sb.append("        http://www.springframework.org/schema/jms");
                sb.append(CR);
                sb.append("        http://www.springframework.org/schema/jms/spring-jms.xsd");
            }
            sb.append("\">");
            sb.append(CR);
            sb.append(this.content);
            sb.append("</beans>");
            sb.append(CR);
            return sb.toString();
        }
    }
}

