/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.File;
import java.util.Map;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.GoogleMapScriptManager;
import jp.jasminesoft.jfc.gen.IGeneratorFactory;
import jp.jasminesoft.jfc.gen.ISourceVariable;
import jp.jasminesoft.jfc.gen.JFCAppGenerator;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Displaymap;
import jp.jasminesoft.jfc.gen.appschema.Item;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Presentation;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.FileTemplateManager;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.ResourceManagerFactory;
import jp.jasminesoft.util.StringUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Deprecated
public class CyberJapanScriptManager
implements ISourceVariable,
IGeneratorFactory {
    private static CyberJapanScriptManager _instance = null;
    private static GoogleMapScriptManager _gmsm = null;
    private static final String TEMPLATE_DIR_NAME = "template" + File.separator + "cjmap" + File.separator;
    protected static ResourceManager rman;
    protected static Logger logger;
    private static boolean isOutputLicenseErrorMessage;

    private CyberJapanScriptManager(Project project) throws InstantiationException {
        rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
        if (!JFCAppGenerator.getIsGoogleMaps()) {
            if (!isOutputLicenseErrorMessage) {
                logger.error(rman.getValue("gen.limit.googlemaps"));
                isOutputLicenseErrorMessage = true;
            }
            throw new InstantiationException("license error");
        }
        _gmsm = GoogleMapScriptManager.getInstance(project);
    }

    public static CyberJapanScriptManager getInstance(Project project) {
        if (_instance == null) {
            try {
                _instance = new CyberJapanScriptManager(project);
            }
            catch (InstantiationException e) {
                _instance = null;
            }
        }
        return _instance;
    }

    public String getReadyScript() {
        if (_gmsm.getGooglemapKey() == null || _gmsm.getGooglemapKey().length() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<script src=\"system/cjmap.js\" type=\"text/javascript\"></script>");
        sb.append(CR);
        return sb.toString();
    }

    public String getScript(Presentation presentation, Project project) {
        if (presentation == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getReadyScript());
        Action action = AppSchemaUtil.getAction(project, presentation);
        String act_type = action.getType();
        if ("show".equals(act_type)) {
            sb.append(this.getScript_show(presentation, project));
        } else if ("showList".equals(act_type)) {
            String filename = presentation.getFilename();
            if (filename == null || filename.length() == 0) {
                sb.append(this.getScript_showlist(presentation, project));
            } else {
                sb.append(this.getScript_showlist2(presentation, project));
            }
        } else if ("insert".equals(act_type)) {
            sb.append(this.getScript_insert(presentation, project));
        } else if ("update".equals(act_type)) {
            sb.append(this.getScript_insert(presentation, project));
        } else if ("copy".equals(act_type)) {
            sb.append(this.getScript_insert(presentation, project));
        } else if ("download".equals(act_type)) {
            sb.append(this.getScript_showlist(presentation, project));
        } else {
            logger.warn("** unknown type:" + act_type);
        }
        return sb.toString();
    }

    protected String getScript_show(Presentation presentation, Project project) {
        Item[] items;
        String filename = TEMPLATE_DIR_NAME + "show.js";
        FileTemplateManager tplman = new FileTemplateManager(filename);
        if (!tplman.isValid()) {
            return "";
        }
        Model pmodel = AppSchemaUtil.getModel(project, presentation);
        if (pmodel == null) {
            return "";
        }
        tplman.setContent("label", this.createInitialValue());
        tplman.setContent("address", this.createInitialValue());
        tplman.setContent("latitude", this.createInitialValue());
        tplman.setContent("longitude", this.createInitialValue());
        tplman.setContent("mbr", this.createInitialValue());
        tplman.setContent("radius", this.createInitialValue());
        tplman.setContent("scale", this.createInitialValue());
        tplman.setContent("imageurl", this.createInitialValue());
        Displaymap displaymap = AppSchemaUtil.findDisplaymap(presentation);
        for (Item item : items = displaymap.getItem()) {
            Map contentsMap = tplman.getContentMap();
            if (!contentsMap.containsKey(item.getName())) continue;
            String elm_id = AppSchemaUtil.createNameAttribute(project, item.getContent(), pmodel, true, "1");
            tplman.setContent(item.getName(), elm_id);
        }
        return tplman.getResult();
    }

    protected String getScript_showlist(Presentation presentation, Project project) {
        Item[] items;
        String filename = TEMPLATE_DIR_NAME + "showlist.js";
        FileTemplateManager tplman = new FileTemplateManager(filename);
        if (!tplman.isValid()) {
            return "";
        }
        Action action = AppSchemaUtil.getAction(project, presentation);
        Model cpmodel = AppSchemaUtil.getConditionPModel(project, action);
        if (cpmodel == null) {
            return "";
        }
        tplman.setContent("address", this.createInitialValue());
        tplman.setContent("latitude_cond1", this.createInitialValue());
        tplman.setContent("latitude_cond2", this.createInitialValue());
        tplman.setContent("longitude_cond1", this.createInitialValue());
        tplman.setContent("longitude_cond2", this.createInitialValue());
        Displaymap displaymap = AppSchemaUtil.findDisplaymap(presentation);
        for (Item item : items = displaymap.getItem()) {
            Map contentsMap = tplman.getContentMap();
            if (!contentsMap.containsKey(item.getName())) continue;
            String elm_name = AppSchemaUtil.createNameAttribute(project, item.getContent(), cpmodel, true, "1");
            tplman.setContent(item.getName(), elm_name);
        }
        return tplman.getResult();
    }

    protected String getScript_showlist2(Presentation presentation, Project project) {
        Item[] items;
        String filename = TEMPLATE_DIR_NAME + "showlist2.js";
        FileTemplateManager tplman = new FileTemplateManager(filename);
        if (!tplman.isValid()) {
            return "";
        }
        Model lpmodel = AppSchemaUtil.getModel(project, presentation);
        Model lmodel = AppSchemaUtil.getIdrefModel(lpmodel);
        Model smodel = AppSchemaUtil.getIdrefModel(lmodel);
        if (lpmodel == null || smodel == null) {
            return "";
        }
        tplman.setContent("lp_name", lpmodel.getId());
        String pk_name = AppSchemaUtil.getPrimaryKeyName(smodel, project);
        tplman.setContent("id", StringUtil.convertELProperty((String)pk_name));
        tplman.setContent("label", this.createInitialValue());
        tplman.setContent("address", this.createInitialValue());
        tplman.setContent("latitude", this.createInitialValue());
        tplman.setContent("longitude", this.createInitialValue());
        tplman.setContent("mbr", this.createInitialValue());
        tplman.setContent("radius", this.createInitialValue());
        tplman.setContent("scale", this.createInitialValue());
        tplman.setContent("imageurl", this.createInitialValue());
        Displaymap displaymap = AppSchemaUtil.findDisplaymap(presentation);
        for (Item item : items = displaymap.getItem()) {
            Map contentsMap = tplman.getContentMap();
            if (!contentsMap.containsKey(item.getName())) continue;
            String elm_id = StringUtil.convertELProperty((String)item.getContent());
            tplman.setContent(item.getName(), elm_id);
        }
        return tplman.getResult();
    }

    protected String getScript_insert(Presentation presentation, Project project) {
        Item[] items;
        String filename = TEMPLATE_DIR_NAME + "insert.js";
        FileTemplateManager tplman = new FileTemplateManager(filename);
        if (!tplman.isValid()) {
            return "";
        }
        Model pmodel = AppSchemaUtil.getModel(project, presentation);
        if (pmodel == null) {
            return "";
        }
        tplman.setContent("address", this.createInitialValue());
        tplman.setContent("latitude", this.createInitialValue());
        tplman.setContent("longitude", this.createInitialValue());
        tplman.setContent("mbr", this.createInitialValue());
        tplman.setContent("radius", this.createInitialValue());
        tplman.setContent("scale", this.createInitialValue());
        tplman.setContent("imageurl", this.createInitialValue());
        Displaymap displaymap = AppSchemaUtil.findDisplaymap(presentation);
        for (Item item : items = displaymap.getItem()) {
            Map contentsMap = tplman.getContentMap();
            if (!contentsMap.containsKey(item.getName())) continue;
            String elm_name = AppSchemaUtil.createNameAttribute(project, item.getContent(), pmodel, true, "1");
            tplman.setContent(item.getName(), elm_name);
        }
        return tplman.getResult();
    }

    private String createInitialValue() {
        return "__unknown";
    }

    static {
        logger = LogManager.getLogger(CyberJapanScriptManager.class);
    }
}

