/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.ConfigGenerator;
import jp.jasminesoft.jfc.gen.SetClasspathGenerator;
import jp.jasminesoft.jfc.gen.appschema.Environment;
import jp.jasminesoft.jfc.gen.appschema.Initloader;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.JavaVersion;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;

public class DBScriptGenerator
extends ConfigGenerator {
    public static final String[] CROSS_DOMAIN_MODELS = new String[]{"jcategory", "jfcdomain", "jfcjob", "jfcmodel", "jfcmodel4dm", "jprincipal"};
    private String outputfilename;
    private ScriptType type;
    private CommandName commandName;
    private ArchiveType archiveType;
    private String LINE_SEPARATOR = null;

    public DBScriptGenerator(Project project, String outputfilename, ScriptType type, CommandName commandName) {
        this(project, outputfilename, type, commandName, ArchiveType.File);
    }

    public DBScriptGenerator(Project project, String outputfilename, ScriptType type, CommandName commandName, ArchiveType archiveType) {
        super(project);
        this.outputfilename = outputfilename;
        this.type = type;
        this.commandName = commandName;
        this.archiveType = archiveType;
        this.LINE_SEPARATOR = type == ScriptType.WindowsBatch ? "\r\n" : "\n";
    }

    @Override
    public String getFileSuffix() {
        if (this.type == ScriptType.WindowsBatch) {
            return ".bat";
        }
        return ".sh";
    }

    @Override
    public String getFilename() {
        return this.outputfilename;
    }

    @Override
    public String getSubpackageName() {
        return "bin";
    }

    @Override
    public String process0() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.gHeader());
        sb.append(this.gBody());
        return sb.toString();
    }

    public String gHeader() {
        StringBuilder sb = new StringBuilder();
        if (this.type == ScriptType.WindowsBatch) {
            sb.append("@ECHO OFF");
            sb.append(this.LINE_SEPARATOR);
            sb.append("if \"%OS%\" == \"Windows_NT\" setlocal");
            sb.append(this.LINE_SEPARATOR);
        } else {
            sb.append("#!/bin/sh");
        }
        sb.append(this.LINE_SEPARATOR);
        if (this.commandName == CommandName.auto) {
            if (this.type == ScriptType.WindowsBatch) {
                sb.append("ECHO ^<data/^> > jprincipal.xml");
            } else {
                sb.append("echo \"<data/>\" > jprincipal.xml");
            }
            sb.append(this.LINE_SEPARATOR);
        }
        return sb.toString();
    }

    public String gBody() {
        String env_prefix = this.type == ScriptType.WindowsBatch ? "%" : "${";
        String env_suffix = this.type == ScriptType.WindowsBatch ? env_prefix : "}";
        String comment_header = this.type == ScriptType.WindowsBatch ? "rem" : "#";
        String pathSeparator = this.type == ScriptType.WindowsBatch ? ";" : ":";
        String lineSeparatorSC = this.type == ScriptType.WindowsBatch ? "^" + this.LINE_SEPARATOR : "\\" + this.LINE_SEPARATOR;
        String varset_prefix = this.type == ScriptType.WindowsBatch ? "set " : "";
        String varset_space = this.type == ScriptType.WindowsBatch ? " " : "\\ ";
        String deployname = AppSchemaUtil.getWebappName(this.project);
        String basePathLastName = AppSchemaUtil.getInitLoaderBasePathLastName(this.project.getEnvironment());
        String jvmMaxPermSize = this.project.getEnvironment().getJvmMaxPermSize();
        Environment env = this.project.getEnvironment();
        JavaVersion javaver = AppSchemaUtil.getJavaVersion(env);
        String JAVA_CMD = null;
        JAVA_CMD = "\"" + env_prefix + "JAVA_HOME" + env_suffix + "/bin/java\"";
        String command = null;
        switch (this.commandName) {
            case auto: {
                command = CommandName.auto.toString();
                break;
            }
            case drop: {
                command = CommandName.drop.toString();
                break;
            }
            case driver_all: {
                command = CommandName.driver_all.toString();
                break;
            }
            case import_db: {
                command = CommandName.auto.toString();
                break;
            }
            case export_db: {
                command = "export";
                break;
            }
            case update_db: {
                command = "update";
                break;
            }
            case importR6_db: {
                command = "import";
                break;
            }
            case migrate: {
                if (this.type == ScriptType.WindowsBatch) {
                    command = "%CMD%";
                    break;
                }
                command = "${CMD}";
                break;
            }
            case initdomain: {
                command = CommandName.auto.toString();
                break;
            }
            default: {
                command = "";
            }
        }
        SetClasspathGenerator.MemorySetting memsetting = new SetClasspathGenerator.MemorySetting(env);
        StringBuilder sb = new StringBuilder();
        sb.append(varset_prefix);
        sb.append("CATALINA_HOME=..");
        sb.append(this.LINE_SEPARATOR);
        String catalina_home = env_prefix + "CATALINA_HOME" + env_suffix;
        sb.append(varset_prefix);
        sb.append("JAVA_OPTS=");
        sb.append("-Dcatalina.home=\"" + catalina_home + "\"");
        sb.append(varset_space);
        sb.append("-Djava.io.tmpdir=\"" + catalina_home + "/temp\"");
        sb.append(varset_space);
        sb.append("-Dwagby.LockManagerDbImpl.clearThismachineAtPostConstruct=false");
        sb.append(varset_space);
        sb.append(memsetting.getMaxramoption());
        if (this.type == ScriptType.WindowsBatch && javaver.atLeast(JavaVersion.JAVA_21)) {
            sb.append(" -Dfile.encoding=\"COMPAT\"");
        }
        sb.append(this.LINE_SEPARATOR);
        if (StringUtils.isNotBlank((CharSequence)jvmMaxPermSize) && !javaver.atLeast(JavaVersion.JAVA_1_8)) {
            sb.append(varset_prefix);
            sb.append("JAVA_OPTS=");
            sb.append(env_prefix + "JAVA_OPTS" + env_suffix);
            sb.append(varset_space);
            sb.append("-XX:MaxPermSize=" + jvmMaxPermSize + "m");
            sb.append(this.LINE_SEPARATOR);
        }
        sb.append(this.LINE_SEPARATOR);
        String JAVA_OPTS = env_prefix + "JAVA_OPTS" + env_suffix;
        sb.append(varset_prefix);
        sb.append("WEBINF_DIR=" + catalina_home + "/webapps/" + deployname + "/WEB-INF");
        sb.append(this.LINE_SEPARATOR);
        String webinf_dir = env_prefix + "WEBINF_DIR" + env_suffix;
        sb.append(varset_prefix);
        sb.append("INITLOADER_HOME=" + webinf_dir + "/" + basePathLastName);
        sb.append(this.LINE_SEPARATOR);
        String initloader_home = env_prefix + "INITLOADER_HOME" + env_suffix;
        sb.append(varset_prefix);
        sb.append("INITLOADER_OPTS=-check_exists_table");
        sb.append(varset_space);
        sb.append("true");
        sb.append(varset_space);
        sb.append("-c");
        sb.append(varset_space);
        sb.append(initloader_home);
        sb.append("/conf/initdb.xml");
        sb.append(varset_space);
        sb.append("-systempropfile");
        sb.append(varset_space);
        sb.append(catalina_home);
        sb.append("/conf/catalina.properties");
        sb.append(this.LINE_SEPARATOR);
        String initloader_opts = env_prefix + "INITLOADER_OPTS" + env_suffix;
        if (this.commandName == CommandName.auto || this.commandName == CommandName.drop || this.commandName == CommandName.import_db) {
            String argnum = "1";
            if (this.commandName == CommandName.import_db) {
                argnum = "2";
            }
            if (this.type == ScriptType.WindowsBatch) {
                sb.append("set TARGET=-all");
                sb.append(this.LINE_SEPARATOR);
                sb.append("if  \"%~" + argnum + "\"==\"\" goto exec");
                sb.append(this.LINE_SEPARATOR);
                sb.append("set TARGET=-t %~" + argnum);
                sb.append(this.LINE_SEPARATOR);
                sb.append(":exec");
                sb.append(this.LINE_SEPARATOR);
            } else {
                sb.append("TARGET=-all");
                sb.append(this.LINE_SEPARATOR);
                sb.append("if [ \"$" + argnum + "\" != \"\" ]; then");
                sb.append(this.LINE_SEPARATOR);
                sb.append("TARGET=\"-t $" + argnum + "\"");
                sb.append(this.LINE_SEPARATOR);
                sb.append("fi");
                sb.append(this.LINE_SEPARATOR);
            }
        }
        if (this.commandName == CommandName.import_db || this.commandName == CommandName.export_db || this.commandName == CommandName.update_db) {
            sb.append(comment_header);
            sb.append(" check ");
            if (this.type == ScriptType.WindowsBatch) {
                sb.append("%1");
            } else {
                sb.append("$1");
            }
            sb.append(this.LINE_SEPARATOR);
            sb.append(this.LINE_SEPARATOR);
        } else if (this.commandName == CommandName.importR6_db) {
            sb.append(comment_header);
            sb.append(this.LINE_SEPARATOR);
        }
        if (this.commandName == CommandName.import_db) {
            if (this.type == ScriptType.WindowsBatch) {
                sb.append("if \"%1\"==\"\" GOTO ERR1");
                sb.append(this.LINE_SEPARATOR);
                sb.append("GOTO NORMAL");
                sb.append(this.LINE_SEPARATOR);
                sb.append(this.LINE_SEPARATOR);
                sb.append(":ERR1");
                sb.append(this.LINE_SEPARATOR);
                sb.append("echo \"Usage>import_db.bat [export dir] [target]\"");
                sb.append(this.LINE_SEPARATOR);
                sb.append("exit /b");
                sb.append(this.LINE_SEPARATOR);
                sb.append(this.LINE_SEPARATOR);
                sb.append(":NORMAL");
                sb.append(this.LINE_SEPARATOR);
            } else {
                sb.append("if [ \"$1\" = \"\" ]; then");
                sb.append(this.LINE_SEPARATOR);
                sb.append("echo \"Usage> ./import_db.sh [export dir] [target]\"");
                sb.append(this.LINE_SEPARATOR);
                sb.append("exit");
                sb.append(this.LINE_SEPARATOR);
                sb.append("fi");
                sb.append(this.LINE_SEPARATOR);
            }
            sb.append(comment_header);
            sb.append(" create jprincipal.xml ");
            sb.append(this.LINE_SEPARATOR);
            sb.append(varset_prefix);
            sb.append("LIBDIR=" + webinf_dir + "/lib");
            sb.append(this.LINE_SEPARATOR);
            sb.append(varset_prefix);
            sb.append("CLASSDIR=" + webinf_dir + "/classes");
            sb.append(this.LINE_SEPARATOR);
            String lib_dir = env_prefix + "LIBDIR" + env_suffix;
            String class_dir = env_prefix + "CLASSDIR" + env_suffix;
            String[] JARFILES = new String[]{"log4j-api.jar", "log4j-core.jar", "commons-compress.jar", "j_util.jar", "j_jfc.jar", "j_jfc_model.jar", "jaxb-api.jar", "jaxb-runtime.jar", "istack-commons-runtime.jar", "javax.activation-api.jar"};
            sb.append(varset_prefix + "CLSPATH=");
            for (String jarfile : JARFILES) {
                sb.append(lib_dir).append("/");
                sb.append(jarfile).append(lineSeparatorSC);
                sb.append(pathSeparator);
            }
            sb.append(class_dir);
            sb.append(this.LINE_SEPARATOR);
            sb.append(JAVA_CMD);
            sb.append(" ");
            sb.append(JAVA_OPTS);
            sb.append(" -classpath ");
            sb.append(env_prefix + "CLSPATH" + env_suffix);
            sb.append(" jp.jasminesoft.jfc.JprincipalXmlCreator ");
            sb.append(initloader_home);
            sb.append(" ");
            if (this.type == ScriptType.WindowsBatch) {
                sb.append("%1");
            } else {
                sb.append("$1");
            }
            sb.append(this.LINE_SEPARATOR);
            sb.append(this.LINE_SEPARATOR);
        }
        if (this.commandName == CommandName.export_db || this.commandName == CommandName.update_db) {
            Initloader initloader = AppSchemaUtil.getInitloader(this.project.getEnvironment());
            String exportParentPath = null;
            if (initloader != null) {
                exportParentPath = initloader.getExportParentPath();
                if (StringUtils.isBlank((CharSequence)exportParentPath)) {
                    exportParentPath = initloader.getBasePath();
                }
                if (exportParentPath.endsWith("/") || exportParentPath.endsWith("\\")) {
                    exportParentPath = exportParentPath.substring(0, exportParentPath.length() - 1);
                }
                exportParentPath = this.normalizePath(exportParentPath);
            }
            if (exportParentPath == null) {
                if (this.type == ScriptType.WindowsBatch) {
                    sb.append("set EXPDIR=%1");
                    sb.append(this.LINE_SEPARATOR);
                } else {
                    sb.append("EXPDIR=\"$1\"");
                    sb.append(this.LINE_SEPARATOR);
                }
            } else if (this.type == ScriptType.WindowsBatch) {
                sb.append("set EXPDIR=%1");
                sb.append(this.LINE_SEPARATOR);
                sb.append("if not \"\"%1\"\"==\"\"\"\" goto doneSetArgs");
                sb.append(this.LINE_SEPARATOR);
                sb.append("set DESTDIR=\"");
                sb.append(exportParentPath);
                sb.append("\"");
                sb.append(this.LINE_SEPARATOR);
                sb.append("set DT=%date%");
                sb.append(this.LINE_SEPARATOR);
                sb.append("set TM=%time: =0%");
                sb.append(this.LINE_SEPARATOR);
                sb.append("set DNAME=data_%DT:~-10,4%%DT:~-5,2%%DT:~-2,2%%TM:~0,2%%TM:~3,2%%TM:~6,2%");
                sb.append(this.LINE_SEPARATOR);
                sb.append("set EXPDIR=%DESTDIR%\\%DNAME%");
                sb.append(this.LINE_SEPARATOR);
                sb.append(":doneSetArgs");
                sb.append(this.LINE_SEPARATOR);
                sb.append(this.LINE_SEPARATOR);
            } else {
                sb.append("if [ -z \"$1\" ]; then");
                sb.append(this.LINE_SEPARATOR);
                sb.append("  DESTDIR=\"");
                sb.append(exportParentPath);
                sb.append("\"");
                sb.append(this.LINE_SEPARATOR);
                sb.append("  DNAME=data_`date +%Y%m%d%H%M%S`");
                sb.append(this.LINE_SEPARATOR);
                sb.append("  EXPDIR=${DESTDIR}/${DNAME}");
                sb.append(this.LINE_SEPARATOR);
                sb.append("else");
                sb.append(this.LINE_SEPARATOR);
                sb.append("  EXPDIR=\"$1\"");
                sb.append(this.LINE_SEPARATOR);
                sb.append("fi");
                sb.append(this.LINE_SEPARATOR);
                sb.append(this.LINE_SEPARATOR);
            }
        }
        if (this.commandName == CommandName.migrate) {
            if (this.type == ScriptType.WindowsBatch) {
                sb.append("set CMD=migrate");
                sb.append(this.LINE_SEPARATOR);
                sb.append("if  not \"%~1\"==\"clean\" goto exec");
                sb.append(this.LINE_SEPARATOR);
                sb.append("set CMD=clean-migrate");
                sb.append(this.LINE_SEPARATOR);
                sb.append(":exec");
                sb.append(this.LINE_SEPARATOR);
            } else {
                sb.append("CMD=migrate");
                sb.append(this.LINE_SEPARATOR);
                sb.append("if [ \"$1\" = \"clean\" ]; then");
                sb.append(this.LINE_SEPARATOR);
                sb.append("CMD=clean-migrate");
                sb.append(this.LINE_SEPARATOR);
                sb.append("fi");
                sb.append(this.LINE_SEPARATOR);
            }
        }
        if (this.commandName == CommandName.initdomain) {
            String target = "";
            Object postcommand = "";
            if (this.type == ScriptType.WindowsBatch) {
                sb.append("set TARGET=-t " + StringUtils.join((Object[])CROSS_DOMAIN_MODELS, (String)" "));
                target = " %TARGET% ";
                postcommand = "if errorlevel 1 goto end";
            } else {
                sb.append("TARGET=\"-t " + StringUtils.join((Object[])CROSS_DOMAIN_MODELS, (String)" ") + "\"");
                target = " $TARGET ";
                postcommand = "if [ \"$?\" = \"1\" ]; then" + this.LINE_SEPARATOR + "exit 1" + this.LINE_SEPARATOR + "fi";
            }
            sb.append(this.LINE_SEPARATOR).append(this.LINE_SEPARATOR);
            sb.append(JAVA_CMD);
            sb.append(" ");
            sb.append(JAVA_OPTS);
            sb.append(" -jar InitLoader.jar drop");
            sb.append(target);
            sb.append(initloader_opts);
            sb.append(" -d ");
            sb.append(initloader_home);
            sb.append(this.LINE_SEPARATOR).append(this.LINE_SEPARATOR);
            sb.append((String)postcommand);
            sb.append(this.LINE_SEPARATOR).append(this.LINE_SEPARATOR);
        }
        sb.append(JAVA_CMD);
        sb.append(" ");
        sb.append(JAVA_OPTS);
        sb.append(" -jar InitLoader.jar ");
        sb.append(command);
        if (this.commandName == CommandName.auto || this.commandName == CommandName.drop || this.commandName == CommandName.import_db || this.commandName == CommandName.initdomain) {
            if (this.type == ScriptType.WindowsBatch) {
                sb.append(" %TARGET% ");
            } else {
                sb.append(" $TARGET ");
            }
        } else if (this.commandName == CommandName.importR6_db) {
            sb.append(" -t jfcmailtemplate jfcreporttemplate ");
        } else {
            sb.append(" -all ");
        }
        sb.append(initloader_opts);
        if (this.commandName == CommandName.auto || this.commandName == CommandName.initdomain) {
            sb.append(" -d ");
            sb.append(initloader_home);
        }
        if (this.commandName == CommandName.import_db) {
            sb.append(" -d ");
            if (this.type == ScriptType.WindowsBatch) {
                sb.append("%1");
            } else {
                sb.append("$1");
            }
            sb.append(" -init_dir_path ");
            sb.append(initloader_home);
            if (this.archiveType == ArchiveType.Zip) {
                sb.append(" -zip");
            }
        } else if (this.commandName == CommandName.importR6_db) {
            sb.append(" -d ");
            sb.append("../../export/data_R6template");
            sb.append(" -init_dir_path ");
            sb.append(initloader_home);
        } else if (this.commandName == CommandName.export_db || this.commandName == CommandName.update_db) {
            sb.append(" -d ");
            sb.append("\"" + env_prefix);
            sb.append("EXPDIR");
            sb.append(env_suffix + "\"");
            if (this.archiveType == ArchiveType.Zip) {
                sb.append(" -zip");
            }
        }
        if (this.commandName == CommandName.import_db) {
            String targets2varnameref;
            sb.append(this.LINE_SEPARATOR);
            sb.append(this.LINE_SEPARATOR);
            if (this.type == ScriptType.WindowsBatch) {
                sb.append("if errorlevel 1 goto end").append(this.LINE_SEPARATOR);
            } else {
                sb.append("if [ \"$?\" = \"1\" ]; then").append(this.LINE_SEPARATOR);
                sb.append("exit").append(this.LINE_SEPARATOR);
                sb.append("fi").append(this.LINE_SEPARATOR);
            }
            sb.append(this.LINE_SEPARATOR);
            InitLoaderCommand ilc = new InitLoaderCommand(JAVA_CMD, JAVA_OPTS, initloader_home, initloader_opts);
            CharSequence[] models = new String[]{"jprincipal", "jfcmodel", "jfcmodel4dm", "jfclicenseholder", "jfcjob", "jcategory", "jfcdomain"};
            String targets2varname = "TARGETS2";
            if (this.type == ScriptType.WindowsBatch) {
                String tablenames = String.join((CharSequence)" ", models);
                sb.append("SET ").append("TARGETS2").append("=").append(tablenames).append(this.LINE_SEPARATOR);
                targets2varnameref = "%TARGETS2%";
            } else {
                String tablenames = String.join((CharSequence)"\\ ", models);
                sb.append("TARGETS2").append("=").append(tablenames).append(this.LINE_SEPARATOR);
                targets2varnameref = "${TARGETS2}";
            }
            sb.append(ilc.getDropTableCommand(targets2varnameref));
            sb.append(ilc.getCreateTableAndImportCommand(targets2varnameref));
            if (this.type == ScriptType.WindowsBatch) {
                sb.append(this.LINE_SEPARATOR);
                sb.append(":end").append(this.LINE_SEPARATOR);
            }
        }
        if (this.commandName == CommandName.driver_all) {
            sb.append(" > ");
            sb.append(this.outputfilename);
            sb.append(".txt");
        }
        if (this.commandName == CommandName.initdomain && this.type == ScriptType.WindowsBatch) {
            sb.append(this.LINE_SEPARATOR).append(this.LINE_SEPARATOR);
            sb.append(":end").append(this.LINE_SEPARATOR);
        }
        sb.append(this.LINE_SEPARATOR);
        String body_contents = sb.toString();
        if (this.type == ScriptType.WindowsBatch) {
            body_contents = StringUtil.replaceAll((String)body_contents, (String)"/", (String)"\\");
            body_contents = StringUtil.replaceAll((String)body_contents, (String)"\\$", (String)"$");
            body_contents = StringUtil.replaceAll((String)body_contents, (String)"exit \\b", (String)"exit /b");
        }
        return body_contents;
    }

    private String normalizePath(String exportParentPath) {
        exportParentPath = this.type == ScriptType.WindowsBatch ? StringUtil.replaceAll((String)exportParentPath, (String)"/", (String)"\\") : StringUtil.replaceAll((String)exportParentPath, (String)"\\", (String)"/");
        return exportParentPath;
    }

    @Override
    protected String getGeneratorClassName() {
        if (System.getProperty("jfc.output.genclassname") != null) {
            if (this.type == ScriptType.WindowsBatch) {
                return "rem genclassname:" + this.getClass().getName() + this.LINE_SEPARATOR;
            }
            return "# genclassname:" + this.getClass().getName() + this.LINE_SEPARATOR;
        }
        return "";
    }

    static enum ArchiveType {
        File,
        Zip;

    }

    static enum ScriptType {
        UnixSh,
        WindowsBatch;

    }

    static enum CommandName {
        auto,
        drop,
        driver_all,
        import_db,
        export_db,
        update_db,
        importR6_db,
        migrate,
        initdomain;

    }

    class InitLoaderCommand {
        String javaCommand;
        String javaOpts;
        String initLoaderHome;
        String initLoaderOpts;
        String initLoaderCommandPrefix;
        String initLoaderCommandSuffix;

        public InitLoaderCommand(String javaCommand, String javaOpts, String initLoaderHome, String initLoaderOpts) {
            this.javaCommand = javaCommand;
            this.javaOpts = javaOpts;
            this.initLoaderHome = initLoaderHome;
            this.initLoaderOpts = initLoaderOpts;
            this.createInitLoaderCommandPrefix();
            this.createInitLoaderCommandSuffix();
        }

        public void createInitLoaderCommandPrefix() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.javaCommand);
            sb.append(" ");
            sb.append(this.javaOpts);
            sb.append(" -jar InitLoader.jar ");
            this.initLoaderCommandPrefix = sb.toString();
        }

        public void createInitLoaderCommandSuffix() {
            this.initLoaderCommandSuffix = " " + this.initLoaderOpts;
        }

        public String getDropTableCommand(String tableName) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getInitLoaderCommand("drop", tableName));
            sb.append(DBScriptGenerator.this.LINE_SEPARATOR);
            return sb.toString();
        }

        public String getCreateTableAndImportCommand(String tableName) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getInitLoaderCommand("auto", tableName));
            sb.append(" -d ");
            sb.append(this.initLoaderHome);
            sb.append(DBScriptGenerator.this.LINE_SEPARATOR);
            return sb.toString();
        }

        public String getInitLoaderCommand(String command, String tableName) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.initLoaderCommandPrefix);
            sb.append(command);
            sb.append(" -t ").append(tableName);
            sb.append(this.initLoaderCommandSuffix);
            return sb.toString();
        }
    }
}

