/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.IGeneratorFactory;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.SubpackageUtil;
import jp.jasminesoft.jfc.gen.appschema.Format;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IModelitemChoice;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.util.VelocityUtils;

public class DateFormatManagerGenerator
extends JavaSourceGenerator
implements IGeneratorFactory {
    public static final String SUB_PACKAGE_NAME = "app";
    private String templateDir = "template/javasrc/app/";
    private static DateFormatManagerGenerator _instance;
    private Map<String, List<String>> formatPatternMap = Collections.synchronizedMap(new TreeMap());
    private Map<String, String> formatPatternNameMap = Collections.synchronizedMap(new HashMap());

    private DateFormatManagerGenerator(Project project) {
        super(project);
        this.init();
    }

    @Override
    public String getClassname() {
        return "DateFormatManager";
    }

    @Override
    public String getSubpackageName() {
        return SubpackageUtil.createPackageNameDir(SUB_PACKAGE_NAME, null);
    }

    @Override
    public String getSubpackageNameAsJavaRule() {
        return SubpackageUtil.createPackageName(SUB_PACKAGE_NAME, null);
    }

    @Override
    public String getEncoding() {
        return "UTF-8";
    }

    protected String getTemplateFilePath() {
        return this.templateDir + this.getTemplateFile();
    }

    protected String getTemplateFile() {
        return "DateFormatManager.vm";
    }

    public static void createNewInstance(Project project) {
        if (_instance == null) {
            _instance = new DateFormatManagerGenerator(project);
        }
    }

    public static DateFormatManagerGenerator getInstance() {
        if (_instance == null) {
            throw new RuntimeException("DateFormatManager has not been initialized.");
        }
        return _instance;
    }

    private void init() {
        for (IProjectChoice ipc : this.project.getContent()) {
            if (!(ipc instanceof Model)) continue;
            Model model = (Model)ipc;
            for (IModelChoice imc : model.getContent()) {
                Modelitem item;
                String patternName;
                if (!(imc instanceof Modelitem) || (patternName = this.setFormatPattern(this.project, model, item = (Modelitem)imc)) == null) continue;
                String key = this.createFormatPatternNameMapKey(model, item);
                this.formatPatternNameMap.put(key, patternName);
            }
        }
    }

    private String setFormatPattern(Project project, Model model, Modelitem item) {
        IModelitemChoice[] imic;
        Modelitem _item;
        Relation relation;
        ArrayList<String> formatList = new ArrayList<String>();
        if (item.getType().equals("storeref") && (relation = AppSchemaUtil.getRelationTypeIsRef(item)) != null && (_item = AppSchemaUtil.getRelatedLastModelitem(relation)) != null) {
            item = _item;
        }
        if ((imic = item.getContent()) != null) {
            Format format = null;
            for (int i = 0; i < imic.length; ++i) {
                String cnt;
                if (!(imic[i] instanceof Format) || (format = (Format)imic[i]) == null || (cnt = format.getContent()) == null || cnt.length() <= 0 || cnt.startsWith("wa")) continue;
                formatList.add(cnt);
            }
        }
        if (formatList.size() == 0 && model != null && "condition".equals(model.getType())) {
            Modelitem sitem;
            Model smodel;
            String name = item.getName();
            if (name.endsWith("1jshparam") || name.endsWith("2jshparam")) {
                name = name.substring(0, name.length() - "1jshparam".length());
            }
            if ((smodel = AppSchemaUtil.getStoreModel(model)) != null && !smodel.getId().equals(model.getId()) && (sitem = AppSchemaUtil.getModelitem(name, smodel)) != null) {
                return this.setFormatPattern(project, smodel, sitem);
            }
        }
        return this.getKeyByPatternList(formatList);
    }

    private String getKeyByPatternList(List<String> list) {
        if (list.size() == 0) {
            return null;
        }
        String ret = null;
        for (String key : this.formatPatternMap.keySet()) {
            List<String> pattern = this.formatPatternMap.get(key);
            if (!this.isEquals(pattern, list)) continue;
            ret = key;
            break;
        }
        if (ret == null) {
            ret = this.createKey(this.formatPatternMap.size());
            this.formatPatternMap.put(ret, list);
        }
        return ret;
    }

    private String createKey(int count) {
        return "format" + (count + 1);
    }

    private String createFormatPatternNameMapKey(Model model, Modelitem mitem) {
        String mid = model != null ? model.getId() : "";
        String mname = mitem != null ? mitem.getName() : "";
        return mid + ":" + mname;
    }

    private boolean isEquals(List<String> src, List<String> dest) {
        String[] dest_ary;
        int dest_length;
        String[] src_ary = src.toArray(new String[src.size()]);
        int src_length = src_ary.length;
        if (src_length != (dest_length = (dest_ary = dest.toArray(new String[dest.size()])).length)) {
            return false;
        }
        boolean ret = true;
        for (int i = 0; i < src_length; ++i) {
            if (src_ary[i].equals(dest_ary[i])) continue;
            ret = false;
            break;
        }
        return ret;
    }

    public String getKeyByModelIdAndModelitemName(Model model, Modelitem mitem) {
        return this.formatPatternNameMap.get(this.createFormatPatternNameMapKey(model, mitem));
    }

    protected void createVariableMap(Map<String, Object> map) {
        map.put("author", this.project.getAuthor());
        map.put("packageName", this.project.getPackage() + ".app");
        map.put("packageBaseName", this.project.getPackage());
        map.put("className", this.getClassname());
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : this.formatPatternMap.entrySet()) {
            String key = entry.getKey();
            String code = this.generateArrayDefinitionCode(key, entry.getValue());
            sb.append(code).append(CR).append(CR);
        }
        map.put("defarray", sb.toString());
        sb = new StringBuilder();
        sb.append("    ").append("private static Map<String, String[]> map = null;").append(CR);
        sb.append("    ").append("static {").append(CR);
        sb.append("        ").append("map = new HashMap<String, String[]>();").append(CR);
        for (String key : this.formatPatternMap.keySet()) {
            sb.append("        ").append("map.put(\"").append(key).append("\", ").append(key).append(");").append(CR);
        }
        sb.append("    ").append("}").append(CR).append(CR);
        map.put("defmap", sb.toString());
    }

    private String generateArrayDefinitionCode(String key, List<String> patternList) {
        StringBuilder sb = new StringBuilder();
        String[] elements = patternList.toArray(new String[0]);
        int size = elements.length;
        sb.append("    ").append("private static String[] ").append(key).append(" = {");
        for (int i = 0; i < size; ++i) {
            if (i == 0) {
                sb.append(CR);
            }
            sb.append("        ");
            sb.append("\"" + elements[i] + "\"");
            if (i < size - 1) {
                sb.append(",");
                sb.append(CR);
                continue;
            }
            if (i != size - 1) continue;
            sb.append(CR);
            sb.append("    ");
        }
        sb.append("};");
        return sb.toString();
    }

    @Override
    public String process0() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.createVariableMap(map);
        return VelocityUtils.mergeContent((String)this.getTemplateFilePath(), map);
    }

    public static void reset() {
        _instance = null;
    }
}

