/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.IWebSourceVariable;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Project;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class HTMLGenerator
extends SourceGenerator
implements IWebSourceVariable {
    protected Logger logger = LogManager.getLogger((String)HTMLGenerator.class.getName());

    public HTMLGenerator(Project project) {
        super(project);
    }

    @Override
    public String getEncoding() {
        return JavaSourceGenerator.getWebEncoding(this.project);
    }

    @Override
    public String getFileSuffix() {
        return ".html";
    }

    public boolean isOutputPageDirective() {
        return true;
    }

    @Override
    public void process() {
        Object content = this.process0();
        String filename = this.getFilename();
        String tomcatversion = AppSchemaUtil.getTomcatVersion(this.project);
        if (tomcatversion != null && (tomcatversion.startsWith("5") || tomcatversion.startsWith("6")) && this.isOutputPageDirective()) {
            content = "<%@ page pageEncoding=\"" + this.getEncoding() + "\"%>" + CR + (String)content;
        }
        this.createSource(this.getGeneratorClassName() + (String)content, filename, "webpage", false);
    }

    public String getFilename() {
        return "";
    }

    public abstract String process0();

    @Override
    protected String getGeneratorClassName() {
        if (System.getProperty("jfc.output.genclassname") != null) {
            return "<!-- genclassname:" + this.getClass().getName() + " -->" + CR;
        }
        return "";
    }
}

