/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeMap;
import jp.jasminesoft.jfc.PrimaryKeyUtils;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.HelperGenerator_calc_base;
import jp.jasminesoft.jfc.gen.HelperGenerator_calc_parser;
import jp.jasminesoft.jfc.gen.HelperGenerator_calc_parser_handler;
import jp.jasminesoft.jfc.gen.HelperGenerator_s2p_master;
import jp.jasminesoft.jfc.gen.IHelperGenerator_calc;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Conditionlist;
import jp.jasminesoft.jfc.gen.appschema.Dataitem;
import jp.jasminesoft.jfc.gen.appschema.ForeignKey;
import jp.jasminesoft.jfc.gen.appschema.Format;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.util.ClassUtils;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelperGenerator_calc_operation
extends HelperGenerator_calc_base
implements IHelperGenerator_calc,
HelperGenerator_calc_parser_handler {
    private static final Logger logger = LogManager.getLogger((String)HelperGenerator_calc_operation.class.getName());
    private static ResourceManager x2aj_rman = ResourceManager.getInstance((String)"x2aj");
    Map<String, Map<String, Integer>> variableNameMap;
    Modelitem sitem;
    String cnt;
    StringBuilder formula;
    List<String> preformula;
    Map<String, VariableStatus> varMap;
    Set<String> declareVarSet;
    boolean isMust_sitem;
    boolean isMust;
    boolean outputSetProcessedFlag2True;
    Set<String> lpModelAttrNameSet;
    Map<Integer, Block> blockMap = new TreeMap<Integer, Block>();
    private static Map<String, String> funcMap = new HashMap<String, String>();

    private static String selectPriorType(String type1, String type2) {
        String _type1 = type1.toLowerCase();
        String _type2 = type2.toLowerCase();
        if (_type1.equals("float") && _type2.equals("double") || _type1.equals("double") && _type2.equals("float")) {
            return "double";
        }
        if (_type1.equals("int") && _type2.equals("long") || _type1.equals("long") && _type2.equals("int")) {
            return "long";
        }
        if (_type1.equals("byte") && _type2.equals("int") || _type1.equals("int") && _type2.equals("byte")) {
            return "int";
        }
        if (_type1.equals("short") && _type2.equals("int") || _type1.equals("int") && _type2.equals("short")) {
            return "int";
        }
        return type2;
    }

    public HelperGenerator_calc_operation(Project project, Model model, Map<String, Map<String, Integer>> variableNameMap, String id, String pname, String cname, String type, Modelitem sitem, String cnt, boolean callFirstFlag, Set<String> lpModelAttrNameSet, String methodNamePrefix, Map<String, String> replaceFunctionMap) {
        super(project, model, id, pname, cname, type, replaceFunctionMap, methodNamePrefix);
        this.variableNameMap = variableNameMap;
        this.sitem = sitem;
        this.cnt = this.preprocess(cnt, model);
        this.lpModelAttrNameSet = lpModelAttrNameSet;
        this.methodNamePrefix = methodNamePrefix;
        this.setFirstFlag(callFirstFlag);
        this.isMust_sitem = sitem.getMust();
        this.formula = new StringBuilder();
        this.preformula = new ArrayList<String>();
        this.varMap = new TreeMap<String, VariableStatus>();
        this.declareVarSet = new HashSet<String>();
    }

    private String preprocess(String s, Model model) {
        if ((s = this.removeSpace(s)).indexOf("Me()") >= 0) {
            if (AppSchemaUtil.getModelitem(this.sitem.getName(), model) == null) {
                Object[] o = new Object[]{model.getId(), s};
                logger.error(this.rman.getValue("helper.invalid.autocalc.me", o));
            } else {
                s = HelperGenerator_calc_operation.preprocess_replace(s, "Me()", "${" + this.sitem.getName() + "}");
            }
        }
        if (s.indexOf("${cond.") >= 0) {
            this.useConditionModel = true;
        }
        if (s.indexOf("ISNOSELECTION") >= 0) {
            s = this.preprocess_conv(s, "ISNOSELECTION", "isnoselection");
        }
        if (s.indexOf("CHECKIF") >= 0) {
            s = this.preprocess_conv(s, "CHECKIF", "checkif");
        }
        if (s.indexOf("COUNT") >= 0) {
            s = this.preprocess_conv_change_op(s, "COUNT", "count", model);
        }
        if (s.indexOf("SUM") >= 0) {
            s = this.preprocess_conv_change_op(s, "SUM", "sum", model);
        }
        if (s.indexOf("AVERAGE") >= 0) {
            s = this.preprocess_conv_change_op(s, "AVERAGE", "avg", model);
        }
        if (s.indexOf("FIRST") >= 0) {
            s = this.preprocess_conv_change_op(s, "FIRST", "first", model);
        }
        if (s.indexOf("LAST") >= 0) {
            s = this.preprocess_conv_change_op(s, "LAST", "last", model);
        }
        if (s.indexOf("SLICE") >= 0) {
            s = this.preprocess_conv_change_op(s, "SLICE", "slice", model, true);
        }
        if (s.indexOf("DDJOIN") >= 0) {
            s = this.preprocess_conv_change_op(s, "DDJOIN", "ddjoin", model, true);
        }
        if (s.indexOf("DJOIN") >= 0) {
            s = this.preprocess_conv_change_op(s, "DJOIN", "djoin", model, true);
        }
        if (s.indexOf("JOIN") >= 0) {
            s = this.preprocess_conv_change_op(s, "JOIN", "join", model, true);
        }
        if (s.indexOf("MAX") >= 0) {
            s = this.preprocess_conv_change_op(s, "MAX", "max", model);
        }
        if (s.indexOf("MIN") >= 0) {
            s = this.preprocess_conv_change_op(s, "MIN", "min", model);
        }
        if (s.indexOf("LARGE") >= 0) {
            s = this.preprocess_conv_add_op(s, "LARGE", "collect", 0);
        }
        if (s.indexOf("SMALL") >= 0) {
            s = this.preprocess_conv_add_op(s, "SMALL", "collect", 0);
        }
        if (s.indexOf("RANK") >= 0) {
            s = this.preprocess_conv_add_op(s, "RANK", "collect", 1);
        }
        if (s.indexOf("GCD") >= 0) {
            s = this.preprocess_conv_add_op(s, "GCD", "collect", 0);
        }
        if (s.indexOf("LCM") >= 0) {
            s = this.preprocess_conv_add_op(s, "LCM", "collect", 0);
        }
        if (s.indexOf("NPV") >= 0) {
            s = this.preprocess_conv_add_op(s, "NPV", "collect", 2);
        }
        if (s.indexOf("STDEV") >= 0) {
            s = this.preprocess_conv_add_op(s, "STDEV", "collect", 0);
        }
        if (s.indexOf("STDEVP") >= 0) {
            s = this.preprocess_conv_add_op(s, "STDEVP", "collect", 0);
        }
        if (s.indexOf("VAR") >= 0) {
            s = this.preprocess_conv_add_op(s, "VAR", "collect", 0);
        }
        if (s.indexOf("VARP") >= 0) {
            s = this.preprocess_conv_add_op(s, "VARP", "collect", 0);
        }
        if (s.indexOf("MEDIAN") >= 0) {
            s = this.preprocess_conv_add_op(s, "MEDIAN", "collect", 0);
        }
        if (s.indexOf("MODE") >= 0) {
            s = this.preprocess_conv_add_op(s, "MODE", "collect", 0);
        }
        if (s.indexOf("ISCHECKED") >= 0) {
            s = this.preprocess_conv_add_modify(s, "ISCHECKED", "#array");
        }
        if (s.indexOf("CHECKED") >= 0) {
            s = this.preprocess_conv_add_modify(s, "CHECKED", "#array");
        }
        if (s.indexOf("SELECTED") >= 0) {
            s = this.preprocess_func_Selected(s, "SELECTED", "Selected");
        }
        if (s.indexOf("ISNULL") >= 0) {
            s = this.preprocess_conv_old_expr(s, "ISNULL", "isNull");
        }
        if (s.indexOf("REQUEST") >= 0) {
            s = this.preprocess_conv_request(s);
        }
        if (s.indexOf("SESSION") >= 0) {
            s = this.preprocess_conv_session(s);
        }
        if (s.indexOf("FLOWSTATUS") >= 0) {
            s = this.preprocess_conv_flowstatus(s, model);
        }
        if (s.indexOf("ISEMPTY") >= 0) {
            s = HelperGenerator_calc_operation.preprocess_conv_isempty(s, model);
        }
        return s;
    }

    private String removeSpace(String s) {
        StringBuilder sb = new StringBuilder();
        int length = s.length();
        boolean quoteMode = false;
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c == '\"' && i > 0 && s.charAt(i - 1) != '\\') {
                boolean bl = quoteMode = !quoteMode;
            }
            if (quoteMode) {
                sb.append(c);
                continue;
            }
            if (c == '(') {
                char c0;
                int j;
                for (j = i - 1; j >= 0 && ((c0 = s.charAt(j)) == ' ' || c0 == '\t'); --j) {
                }
                if (j < i - 1) {
                    String tmp = sb.toString();
                    tmp = tmp.substring(0, tmp.length() - (i - 1 - j));
                    sb = new StringBuilder(tmp);
                }
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private String preprocess_conv_change_op(String s, String funcname, String op, Model model) {
        return this.preprocess_conv_change_op(s, funcname, op, model, false);
    }

    private String preprocess_conv_change_op(String s, String funcname, String op, Model model, boolean isSliceOrJoinFlag) {
        String n_funcname = funcname + "(";
        int ptr = s.indexOf(n_funcname);
        while (ptr >= 0) {
            int end2;
            int end;
            int endptr = -1;
            int par = 1;
            boolean quoteMode = false;
            for (int i = ptr + n_funcname.length(); i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == '\"' && i > 0 && s.charAt(i - 1) != '\\') {
                    boolean bl = quoteMode = !quoteMode;
                }
                if (!quoteMode && c == '(') {
                    ++par;
                }
                if (quoteMode || c != ')' || --par != 0) continue;
                endptr = i;
                break;
            }
            if (endptr < 0) {
                return s;
            }
            String beforePart = s.substring(0, ptr);
            String targetPart = s.substring(ptr, endptr + 1);
            String afterPart = s.substring(endptr + 1);
            int begin = targetPart.indexOf("(");
            int n = end = begin >= 0 ? targetPart.substring(begin + 1).lastIndexOf(")") + (begin + 1) : -1;
            if (begin < 0 || end < 0) {
                return s;
            }
            String cnt = targetPart.substring(begin, end);
            int begin2 = cnt.indexOf("${");
            int n2 = end2 = begin2 >= 0 ? cnt.substring(begin2 + 1).indexOf("}") + (begin2 + 1) : -1;
            if (begin2 < 0 || end2 < 0) {
                return s;
            }
            String prepart = cnt.substring(0, begin2).trim();
            String itemname = cnt.substring(begin2 + 2, end2);
            String rest = cnt.substring(end2 + 1).trim();
            if ((funcname.equals("MIN") || funcname.equals("MAX") || funcname.equals("JOIN") || funcname.equals("SLICE")) && StringUtils.isNotBlank((CharSequence)prepart) && !prepart.equals("(")) {
                return s;
            }
            String _t_itemname = new String(itemname);
            String type = null;
            String idsuffix = AppSchemaUtil.getIdSuffixPartInExpr(_t_itemname);
            if (idsuffix != null && _t_itemname.endsWith(idsuffix) || _t_itemname.endsWith("#content") || _t_itemname.endsWith("#array")) {
                if (idsuffix != null && _t_itemname.endsWith(idsuffix)) {
                    _t_itemname = _t_itemname.substring(0, _t_itemname.length() - idsuffix.length());
                } else if (_t_itemname.endsWith("#content")) {
                    _t_itemname = _t_itemname.substring(0, _t_itemname.length() - "#content".length());
                } else if (_t_itemname.endsWith("#array")) {
                    _t_itemname = _t_itemname.substring(0, _t_itemname.length() - "#array".length());
                }
            } else if (_t_itemname.endsWith("_lp") || _t_itemname.indexOf("_lp.") > 0) {
                int _ptr = _t_itemname.indexOf("_lp");
                String _f_modelId = _t_itemname.substring(0, _ptr);
                Model _dummy = AppSchemaUtil.getModel(this.project, _f_modelId);
                if (_dummy == null) {
                    Object[] o = new Object[]{this.id, this.name, _f_modelId};
                    logger.error(this.rman.getValue("helper.invalid.autocalc.content.notfound.model", o));
                    return s;
                }
                String fitemname = null;
                fitemname = _t_itemname.endsWith("_lp") ? _t_itemname.substring(_ptr + "_lp".length()) : _t_itemname.substring(_ptr + "_lp.".length());
                Modelitem mitem = AppSchemaUtil.getModelitem(fitemname, _dummy);
                if (mitem != null) {
                    type = AppSchemaUtil.getModelitemType(model.getId(), mitem, "roleid", true);
                }
            }
            if (!_t_itemname.endsWith("_lp") && _t_itemname.indexOf("_lp.") < 0) {
                Modelitem mitem = AppSchemaUtil.getModelitem(_t_itemname, model);
                if (mitem == null && (mitem = AppSchemaUtil.withRefmodelPrimaryKeyName(_t_itemname, model, this.project)) == null) {
                    Object[] o = new Object[]{this.id, this.name, itemname};
                    logger.error(this.rman.getValue("helper.invalid.autocalc.content.notfound", o));
                    return s;
                }
                type = AppSchemaUtil.getModelitemType(model.getId(), mitem, "roleid", true);
                Relation rel = AppSchemaUtil.getRelationTypeExceptRef(mitem);
                if (!(mitem.getMultiple() || AppSchemaUtil.hasChildPart(mitem.getName()) || rel != null && (rel.getType().equals("check") || rel.getType().equals("ref")))) {
                    if (!funcname.equals("MAX") && !funcname.equals("MIN")) {
                        Object[] o = new Object[]{this.id, this.name, s};
                        logger.warn(this.rman.getValue("helper.invalid.autocalc.collect", o));
                    }
                    return s;
                }
            }
            boolean isWrapped = false;
            StringBuilder buf = new StringBuilder();
            if ((funcname.equals("SUM") || funcname.equals("AVERAGE")) && type != null) {
                String wtype = JavaSourceGenerator.b2wc(type).toUpperCase();
                buf.append(wtype).append("(");
                isWrapped = true;
            }
            buf.append("${");
            buf.append(op);
            if (StringUtils.isNotBlank((CharSequence)prepart)) {
                buf.append(prepart);
            }
            buf.append(itemname);
            if (isSliceOrJoinFlag && StringUtils.isNotBlank((CharSequence)rest)) {
                buf.append(rest);
            }
            buf.append(")");
            if (!isSliceOrJoinFlag && StringUtils.isNotBlank((CharSequence)rest)) {
                buf.append(rest);
            }
            buf.append("}");
            if (isWrapped) {
                buf.append(")");
            }
            buf.append(afterPart);
            buf.insert(0, beforePart);
            s = buf.toString();
            ptr = s.indexOf(n_funcname);
        }
        return s;
    }

    private String preprocess_conv_add_op(String s, String funcname, String op, int pos) {
        String n_funcname = funcname + "(";
        StringBuilder buf = new StringBuilder();
        while (s.indexOf(n_funcname) >= 0) {
            String _itemname;
            Object itemname;
            int ptr = s.indexOf(n_funcname);
            String beforePart = s.substring(0, ptr += n_funcname.length());
            String afterPart = s.substring(ptr);
            if (afterPart.length() == 0) break;
            if (pos > 0) {
                boolean isMatch = false;
                int count = 0;
                int length = afterPart.length();
                boolean quoteMode = false;
                for (int i = 0; i < length; ++i) {
                    char c = afterPart.charAt(i);
                    if (c == '\"' && i > 0 && afterPart.charAt(i - 1) != '\\') {
                        boolean bl = quoteMode = !quoteMode;
                    }
                    if (!quoteMode && c == ',') {
                        ++count;
                    }
                    if (count != pos) continue;
                    isMatch = true;
                    beforePart = s.substring(0, (ptr += i) + 1);
                    afterPart = s.substring(ptr + 1);
                    break;
                }
                if (!isMatch) {
                    Object[] o = new Object[]{this.id, this.name, s, funcname};
                    logger.error(this.rman.getValue("helper.invalid.autocalc.content.short.param", o));
                    break;
                }
            }
            StringBuilder ibuf = new StringBuilder();
            int lenOfAfterPart = afterPart.length();
            int beginParenthesis = 0;
            for (int i = 0; i < lenOfAfterPart; ++i) {
                char c = afterPart.charAt(i);
                if (c == '(') {
                    ++beginParenthesis;
                    ibuf.append(c);
                    continue;
                }
                if (c == ')') {
                    if (--beginParenthesis < 0) {
                        afterPart = afterPart.substring(i);
                        break;
                    }
                    ibuf.append(c);
                    continue;
                }
                if (c == ',') {
                    afterPart = afterPart.substring(i);
                    break;
                }
                ibuf.append(c);
            }
            if (((String)(itemname = ibuf.toString().trim())).startsWith("${") && ((String)itemname).endsWith("}") && (!(_itemname = ((String)itemname).substring(2, ((String)itemname).length() - 1)).startsWith("collect(") || !_itemname.endsWith(")"))) {
                itemname = "${collect(" + _itemname + ")}";
            }
            buf.append(beforePart + (String)itemname);
            s = afterPart;
        }
        buf.append(s);
        return buf.toString();
    }

    private String preprocess_conv(String s, String src, String dest) {
        src = (String)src + "(";
        dest = "${" + (String)dest + "(";
        while (s.indexOf((String)src) >= 0) {
            int i;
            int ptr = s.indexOf((String)src);
            String beforePart = s.substring(0, ptr);
            String afterPart = s.substring(ptr + ((String)src).length());
            if (afterPart.length() == 0 || afterPart.indexOf(")") < 0) break;
            StringBuilder sb = new StringBuilder();
            int lenOfAfterPart = afterPart.length();
            int beginParenthesis = 0;
            boolean quoteMode = false;
            for (i = 0; i < lenOfAfterPart; ++i) {
                char c = afterPart.charAt(i);
                if (c == '\"' && i > 0 && afterPart.charAt(i - 1) != '\\') {
                    boolean bl = quoteMode = !quoteMode;
                }
                if (quoteMode) {
                    sb.append(c);
                    continue;
                }
                if (c == '(') {
                    ++beginParenthesis;
                    sb.append(c);
                    continue;
                }
                if (c == ')') {
                    if (--beginParenthesis < 0) break;
                    sb.append(c);
                    continue;
                }
                sb.append(c);
            }
            String t_itemname = sb.toString();
            if ((t_itemname = t_itemname.trim()).startsWith("${") && t_itemname.endsWith("}")) {
                t_itemname = t_itemname.substring("${".length(), t_itemname.length() - 1);
            }
            afterPart = afterPart.substring(i + 1);
            StringBuilder __sb = new StringBuilder();
            __sb.append(beforePart);
            __sb.append((String)dest);
            __sb.append(t_itemname);
            __sb.append(")}");
            __sb.append(afterPart);
            s = __sb.toString();
        }
        return s;
    }

    private String preprocess_conv_add_modify(String s, String funcname, String modifier) {
        String n_funcname = funcname + "(";
        int ptr = s.indexOf(n_funcname);
        while (ptr >= 0) {
            int end2;
            int end;
            int endptr = -1;
            boolean quoteMode = false;
            for (int i = ptr + n_funcname.length(); i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == '\"' && i > 0 && s.charAt(i - 1) != '\\') {
                    boolean bl = quoteMode = !quoteMode;
                }
                if (quoteMode || c != ')') continue;
                endptr = i;
                break;
            }
            if (endptr < 0) {
                return s;
            }
            String beforePart = s.substring(0, ptr);
            String targetPart = s.substring(ptr, endptr + 1);
            String afterPart = s.substring(endptr + 1);
            int begin = targetPart.indexOf("(");
            int n = end = begin >= 0 ? targetPart.substring(begin + 1).lastIndexOf(")") + (begin + 1) : -1;
            if (begin < 0 || end < 0) {
                return s;
            }
            String cnt = targetPart.substring(begin, end);
            int begin2 = cnt.indexOf("${");
            int n2 = end2 = begin2 >= 0 ? cnt.substring(begin2 + 1).indexOf("}") + (begin2 + 1) : -1;
            if (begin2 < 0 || end2 < 0) {
                return s;
            }
            String prepart = cnt.substring(0, begin2).trim();
            String itemname = cnt.substring(begin2 + 2, end2);
            String rest = cnt.substring(end2 + 1).trim();
            String _t_itemname = new String(itemname);
            if (_t_itemname.indexOf("#") > 0) {
                return s;
            }
            if (_t_itemname.endsWith("_lp") || _t_itemname.indexOf("_lp.") > 0) {
                return s;
            }
            Modelitem mitem = AppSchemaUtil.getModelitem(_t_itemname, this.model);
            if (mitem == null && (mitem = AppSchemaUtil.withRefmodelPrimaryKeyName(_t_itemname, this.model, this.project)) == null) {
                Object[] o = new Object[]{this.id, this.name, itemname};
                logger.error(this.rman.getValue("helper.invalid.autocalc.content.notfound", o));
                return s;
            }
            StringBuilder buf = new StringBuilder(beforePart);
            buf.append(funcname);
            if (StringUtils.isNotBlank((CharSequence)prepart)) {
                buf.append(prepart);
            }
            buf.append("${");
            buf.append(itemname);
            buf.append(modifier);
            if (StringUtils.isNotBlank((CharSequence)rest)) {
                buf.append(rest);
            }
            buf.append("}");
            buf.append(")");
            buf.append(afterPart);
            s = buf.toString();
            int n_begin = endptr + modifier.length() + 1;
            int n_ptr = s.substring(n_begin).indexOf(n_funcname);
            if (n_ptr < 0) {
                ptr = -1;
                continue;
            }
            ptr = n_begin + n_ptr;
        }
        return s;
    }

    private String preprocess_func_Selected(String s, String funcname, String rfuncname) {
        String n_funcname = funcname + "(";
        int ptr = s.indexOf(n_funcname);
        while (ptr >= 0) {
            String reltype;
            int end2;
            int end;
            int endptr = -1;
            boolean quoteMode = false;
            for (int i = ptr + n_funcname.length(); i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == '\"' && i > 0 && s.charAt(i - 1) != '\\') {
                    boolean bl = quoteMode = !quoteMode;
                }
                if (quoteMode || c != ')') continue;
                endptr = i;
                break;
            }
            if (endptr < 0) {
                return s;
            }
            String beforePart = s.substring(0, ptr);
            String targetPart = s.substring(ptr, endptr + 1);
            String afterPart = s.substring(endptr + 1);
            int begin = targetPart.indexOf("(");
            int n = end = begin >= 0 ? targetPart.substring(begin + 1).lastIndexOf(")") + (begin + 1) : -1;
            if (begin < 0 || end < 0) {
                return s;
            }
            String cnt = targetPart.substring(begin, end);
            int begin2 = cnt.indexOf("${");
            int n2 = end2 = begin2 >= 0 ? cnt.substring(begin2 + 1).indexOf("}") + (begin2 + 1) : -1;
            if (begin2 < 0 || end2 < 0) {
                return s;
            }
            String prepart = cnt.substring(0, begin2).trim();
            String content = cnt.substring(begin2 + 2, end2);
            String rest = cnt.substring(end2 + 1).trim();
            Object mid = null;
            String itemname = null;
            Model targetModel = this.model;
            boolean useChildModel = false;
            int sep = content.indexOf(".");
            if (sep > 0) {
                mid = content.substring(0, sep);
                itemname = content.substring(sep + 1);
                if (((String)mid).endsWith("_lp")) {
                    mid = ((String)mid).substring(0, ((String)mid).length() - "_lp".length());
                    targetModel = AppSchemaUtil.getModel(this.project, (String)mid);
                    useChildModel = true;
                }
            } else {
                sep = content.indexOf("/");
                if (sep > 0) {
                    mid = "__" + content.substring(0, sep);
                    itemname = content.substring(sep + 1);
                }
            }
            if (mid == null) {
                mid = this.model.getId();
                itemname = content;
            }
            StringBuilder buf = new StringBuilder(beforePart);
            buf.append(rfuncname);
            if (StringUtils.isNotBlank((CharSequence)prepart)) {
                buf.append(prepart);
            }
            buf.append((String)mid);
            if (StringUtils.isNotBlank((CharSequence)rest)) {
                buf.append(rest);
            }
            buf.append(", ");
            Modelitem mitem = AppSchemaUtil.getModelitem(itemname, targetModel);
            if (mitem == null) {
                Object[] o = new Object[]{mid, s, itemname};
                logger.error(this.rman.getValue("helper.invalid.autocalc.Selected.item.notfound", o));
                return s;
            }
            Relation relation = AppSchemaUtil.getRelationTypeExceptRef(mitem);
            String string = reltype = relation != null ? relation.getType() : null;
            if (reltype == null || !"combo".equals(reltype) && !"radio".equals(reltype)) {
                Object[] o = new Object[]{mid, s, itemname};
                logger.error(this.rman.getValue("helper.invalid.autocalc.Selected.item.norelation", o));
                return s;
            }
            Model relmodel = (Model)relation.getIdrefAsIRNode();
            PrimaryKey[] r_pkeys = AppSchemaUtil.getPrimaryKey(relmodel);
            if ("masterref".equals(mitem.getType()) || useChildModel || r_pkeys != null && r_pkeys.length == 1) {
                buf.append("\"").append(itemname).append("\"");
            } else if (r_pkeys != null) {
                for (int i = 0; i < r_pkeys.length; ++i) {
                    String m_itemname = itemname + "_" + r_pkeys[i].getName();
                    buf.append("\"").append(m_itemname).append("\"");
                    if (i >= r_pkeys.length - 1) continue;
                    buf.append(", ");
                }
            }
            buf.append(")");
            buf.append(afterPart);
            s = buf.toString();
            ptr = s.indexOf(n_funcname);
        }
        return s;
    }

    private String preprocess_conv_old_expr(String s, String funcname, String rfuncname) {
        String n_funcname = funcname + "(";
        int ptr = s.indexOf(n_funcname);
        while (ptr >= 0) {
            int end2;
            int end;
            int endptr = -1;
            boolean quoteMode = false;
            for (int i = ptr + n_funcname.length(); i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == '\"' && i > 0 && s.charAt(i - 1) != '\\') {
                    boolean bl = quoteMode = !quoteMode;
                }
                if (quoteMode || c != ')') continue;
                endptr = i;
                break;
            }
            if (endptr < 0) {
                return s;
            }
            String beforePart = s.substring(0, ptr);
            String targetPart = s.substring(ptr, endptr + 1);
            String afterPart = s.substring(endptr + 1);
            int begin = targetPart.indexOf("(");
            int n = end = begin >= 0 ? targetPart.substring(begin + 1).lastIndexOf(")") + (begin + 1) : -1;
            if (begin < 0 || end < 0) {
                return s;
            }
            String cnt = targetPart.substring(begin, end);
            int begin2 = cnt.indexOf("${");
            int n2 = end2 = begin2 >= 0 ? cnt.substring(begin2 + 1).indexOf("}") + (begin2 + 1) : -1;
            if (begin2 < 0 || end2 < 0) {
                return s;
            }
            String prepart = cnt.substring(0, begin2).trim();
            String content = cnt.substring(begin2 + 2, end2);
            String rest = cnt.substring(end2 + 1).trim();
            StringBuilder buf = new StringBuilder(beforePart);
            buf.append("${");
            buf.append(rfuncname);
            if (StringUtils.isNotBlank((CharSequence)prepart)) {
                buf.append(prepart);
            }
            buf.append(content);
            buf.append(")");
            buf.append("}");
            if (StringUtils.isNotBlank((CharSequence)rest)) {
                buf.append(rest);
            }
            buf.append(afterPart);
            s = buf.toString();
            ptr = s.indexOf(n_funcname);
        }
        return s;
    }

    private String preprocess_conv_request(String s) {
        String filtername;
        Model pmodel = AppSchemaUtil.getModel(this.project, this.id, "presentation");
        Modelitem pitem = AppSchemaUtil.getModelitem(this.sitem.getName(), pmodel);
        String string = filtername = pitem != null ? pitem.getFilter() : null;
        if (StringUtils.isBlank((CharSequence)filtername)) {
            filtername = "commonfilter";
        }
        String n_funcname = "REQUEST(";
        int ptr = s.indexOf(n_funcname);
        while (ptr >= 0) {
            int endptr = -1;
            int parnum = 0;
            for (int i = ptr + n_funcname.length(); i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == '(') {
                    ++parnum;
                }
                if (c != ')' || --parnum >= 0) continue;
                endptr = i;
                break;
            }
            if (endptr < 0) {
                return s;
            }
            String beforePart = s.substring(0, ptr);
            String contentPart = s.substring(ptr + n_funcname.length(), endptr);
            String afterPart = s.substring(endptr);
            StringBuilder buf = new StringBuilder(beforePart);
            buf.append("JFCUtils.getRequestParameter(p,");
            if (StringUtils.isNotBlank((CharSequence)contentPart)) {
                buf.append(contentPart);
            } else {
                buf.append("\"").append(this.sitem.getName()).append("\"");
            }
            buf.append(",((jp.jasminesoft.jfc.FilterManager)p.appctx.getBean(\"filterManager\")).getFilter(\"").append(filtername).append("\")");
            buf.append(",").append(this.id);
            buf.append(afterPart);
            s = buf.toString();
            ptr = s.indexOf(n_funcname);
        }
        return s;
    }

    private String preprocess_conv_session(String s) {
        return HelperGenerator_calc_operation.preprocess_conv_session(s, this.sitem.getName());
    }

    protected static String preprocess_conv_session(String s, String itemname) {
        if (itemname == null) {
            itemname = "";
        }
        String n_funcname = "SESSION(";
        int ptr = s.indexOf("SESSION(");
        while (ptr >= 0) {
            int endptr = -1;
            int parnum = 0;
            for (int i = ptr + "SESSION(".length(); i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == '(') {
                    ++parnum;
                }
                if (c != ')' || --parnum >= 0) continue;
                endptr = i;
                break;
            }
            if (endptr < 0) {
                return s;
            }
            String beforePart = s.substring(0, ptr);
            String contentPart = s.substring(ptr + "SESSION(".length(), endptr);
            String afterPart = s.substring(endptr);
            StringBuilder buf = new StringBuilder(beforePart);
            buf.append("JFCUtils.getAttributeInSession(p,");
            if (StringUtils.isNotBlank((CharSequence)contentPart)) {
                buf.append(contentPart);
            } else {
                buf.append("\"").append(itemname).append("\"");
            }
            buf.append(afterPart);
            s = buf.toString();
            ptr = s.indexOf("SESSION(");
        }
        return s;
    }

    private String preprocess_conv_flowstatus(String s, Model model) {
        if (!model.getWorkflow()) {
            return StringUtil.replaceAll((String)s, (String)"FLOWSTATUS(", (String)"PARTICIPANTNODENAME(p, ");
        }
        String n_funcname = "FLOWSTATUS(";
        int ptr = s.indexOf(n_funcname);
        while (ptr >= 0) {
            int endptr = -1;
            int parnum = 0;
            for (int i = ptr + n_funcname.length(); i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == '(') {
                    ++parnum;
                }
                if (c != ')' || --parnum >= 0) continue;
                endptr = i;
                break;
            }
            if (endptr < 0) {
                return s;
            }
            String beforePart = s.substring(0, ptr);
            String contentPart = s.substring(ptr + n_funcname.length(), endptr);
            String afterPart = s.substring(endptr);
            String contentPart1 = null;
            String contentPart2 = null;
            int cptr = contentPart.indexOf(",");
            if (cptr < 0) {
                contentPart1 = contentPart;
                contentPart2 = "\"\"";
            } else {
                contentPart1 = contentPart.substring(0, cptr);
                contentPart2 = contentPart.substring(cptr + 1);
            }
            StringBuilder buf = new StringBuilder(beforePart);
            buf.append("PARTICIPANTNODENAME(p, ");
            buf.append(contentPart1);
            buf.append(", ").append(model.getId()).append(".getJfcWorkflowProcessedLayerId()");
            buf.append(", ").append(contentPart2);
            buf.append(afterPart);
            s = buf.toString();
            ptr = s.indexOf(n_funcname);
        }
        return s;
    }

    public static String preprocess_conv_isempty(String s, Model model) {
        String n_funcname = "ISEMPTY(";
        StringBuilder sb = new StringBuilder();
        while (s.indexOf(n_funcname) >= 0) {
            int ptr = s.indexOf(n_funcname);
            String beforePart = s.substring(0, ptr);
            sb.append(beforePart);
            String afterPart = s.substring(ptr + n_funcname.length());
            int ptr2 = afterPart.indexOf(")");
            if (afterPart.length() == 0 || ptr2 < 0) {
                sb.append(n_funcname);
                sb.append(afterPart);
                break;
            }
            Object t_itemname = afterPart.substring(0, ptr2);
            if (((String)(t_itemname = ((String)t_itemname).trim())).startsWith("${") && ((String)t_itemname).endsWith("}")) {
                Modelitem _t_item;
                Relation _relation;
                t_itemname = ((String)t_itemname).substring("${".length(), ((String)t_itemname).length() - 1);
                Object id = model.getId();
                String suffix = null;
                int _ptr = ((String)t_itemname).indexOf("#id");
                if (_ptr > 0) {
                    suffix = ((String)t_itemname).substring(_ptr + 1);
                    t_itemname = ((String)t_itemname).substring(0, _ptr);
                    int sindex = 0;
                    if (suffix.length() > "id".length()) {
                        sindex = StringUtil.intValue((String)suffix.substring("id".length()));
                    }
                    Modelitem mitem = AppSchemaUtil.getModelitem((String)t_itemname, model);
                    PrimaryKey[] _pkeys = null;
                    if (mitem != null) {
                        Relation rel_mitem = AppSchemaUtil.getRelationTypeIsRef(mitem);
                        if (rel_mitem != null) {
                            Modelitem mitem2 = AppSchemaUtil.getModelitem(rel_mitem.getName(), model);
                            Relation rel_mitem2 = AppSchemaUtil.getRelation(mitem2);
                            if (rel_mitem2 != null) {
                                _pkeys = AppSchemaUtil.getPrimaryKey((Model)rel_mitem2.getIdrefAsIRNode());
                            }
                        } else {
                            rel_mitem = AppSchemaUtil.getRelationTypeExceptRef(mitem);
                            if (rel_mitem != null) {
                                _pkeys = AppSchemaUtil.getPrimaryKey((Model)rel_mitem.getIdrefAsIRNode());
                            }
                        }
                    }
                    if (_pkeys != null && sindex <= _pkeys.length) {
                        void _pkey = sindex == 0 ? _pkeys[0] : _pkeys[sindex - 1];
                        t_itemname = (String)t_itemname + "_" + _pkey.getName();
                    }
                }
                if (AppSchemaUtil.hasChildPart((String)t_itemname)) {
                    id = "__" + AppSchemaUtil.getParentPart((String)t_itemname);
                    t_itemname = AppSchemaUtil.getChildPart((String)t_itemname);
                } else if (((String)t_itemname).startsWith("cond.")) {
                    t_itemname = ((String)t_itemname).substring("cond.".length());
                    id = (String)id + "_c";
                }
                ArrayList<CallSite> clist = null;
                if (suffix == null && (_relation = AppSchemaUtil.getRelationTypeExceptRef(_t_item = AppSchemaUtil.getModelitem((String)t_itemname, model))) != null) {
                    clist = new ArrayList<CallSite>();
                    Model _refmodel = (Model)_relation.getIdrefAsIRNode();
                    PrimaryKey[] _ref_pkeys = AppSchemaUtil.getPrimaryKey(_refmodel);
                    if (_ref_pkeys != null && _ref_pkeys.length > 1) {
                        for (PrimaryKey _ref_pkey : _ref_pkeys) {
                            String _target = AppSchemaUtil.getChildPart((String)t_itemname) + "_" + _ref_pkey.getName();
                            clist.add((CallSite)((Object)("\"" + _target + "\"")));
                        }
                    }
                }
                StringBuilder __sb = new StringBuilder();
                __sb.append(n_funcname);
                __sb.append((String)id);
                __sb.append(",");
                if (clist == null || clist.size() == 0) {
                    __sb.append("\"");
                    __sb.append((String)t_itemname);
                    __sb.append("\"");
                } else {
                    __sb.append("new String[] {");
                    __sb.append(String.join((CharSequence)",", clist));
                    __sb.append("}");
                }
                sb.append(__sb.toString());
            } else {
                sb.append(n_funcname);
                sb.append((String)t_itemname);
            }
            s = s.substring(ptr + n_funcname.length() + ptr2);
        }
        sb.append(s);
        return sb.toString();
    }

    public static String preprocess_replace(String s, String src, String dest) {
        StringBuilder sb = new StringBuilder();
        boolean quoteMode = false;
        for (int i = 0; i < s.length(); ++i) {
            String token;
            char c = s.charAt(i);
            if (c == '\"' && i > 0 && s.charAt(i - 1) != '\\') {
                boolean bl = quoteMode = !quoteMode;
            }
            if (quoteMode) {
                sb.append(c);
                continue;
            }
            if (i + src.length() < s.length() && (token = s.substring(i, i + src.length())).equals(src)) {
                sb.append(dest);
                i = i + src.length() - 1;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public void comment() {
        this.sb.append("        ");
        this.sb.append("// " + this.rman.getValue("helper.comment.autocalc.operation"));
        this.sb.append(CR);
    }

    @Override
    public boolean preprocess() {
        HelperGenerator_calc_parser parser = new HelperGenerator_calc_parser();
        parser.setHandler(this);
        return parser.process(this.cnt);
    }

    @Override
    public int process_var_set(String var) {
        if (var.length() == 0) {
            return 2;
        }
        int status = this.gVarExpand(var);
        return status;
    }

    @Override
    public void process_parse_error(int status, String var) {
        if (status == 2) {
            Object[] o = new Object[]{this.id, this.name, var};
            logger.error(this.rman.getValue("helper.invalid.autocalc.content.notfound", o));
        }
        this.setError();
    }

    @Override
    public void process_formula_set(char c) {
        this.formula.append(c);
        String cnv = HelperGenerator_calc_parser.convertFunctionNames(this.formula.toString(), this.replaceFunctionMap, this.sitem.getName(), this.model);
        if (cnv != null) {
            this.formula = new StringBuilder(cnv);
        }
    }

    @Override
    public void process_parse_error_whole(String cnt) {
        Object[] o = new Object[]{this.id, this.name, cnt};
        logger.error(this.rman.getValue("helper.invalid.autocalc.parse", o));
        this.setError();
    }

    @Override
    public void process_finish() {
        String s = this.formula.toString();
        boolean hasIFfunction = false;
        boolean quoteMode = false;
        StringBuilder buf = new StringBuilder();
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            buf.append(c);
            if (c == '\"') {
                boolean bl = quoteMode = !quoteMode;
            }
            if (quoteMode || c != 'I' || i + 1 >= length || s.charAt(i + 1) != 'F' || i + 2 >= length || s.charAt(i + 2) != '(' || i - 1 >= 0 && s.charAt(i - 1) >= 'A' && s.charAt(i - 1) <= 'Z') continue;
            hasIFfunction = true;
            break;
        }
        if (!hasIFfunction) {
            return;
        }
        this.process_if_block0(s);
        this.process_adjust_type();
    }

    private void process_if_block0(String s) {
        s = StringUtil.removePreAndPostWhitespaceWithoutInside((String)s);
        Stack<Block> stack = new Stack<Block>();
        int count = 0;
        boolean quoteMode = false;
        Block block = new Block(count);
        block.type = this.type;
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c == '\"') {
                quoteMode = !quoteMode;
            }
            block.sb.append(c);
            if (quoteMode) continue;
            if (c == 'I' && i + 1 < length && s.charAt(i + 1) == 'F' && i + 2 < length && s.charAt(i + 2) == '(') {
                if (i - 1 >= 0 && s.charAt(i - 1) >= 'A' && s.charAt(i - 1) <= 'Z') continue;
                i += 2;
                block.type = this.type;
                block.sb.deleteCharAt(block.sb.length() - 1);
                block.sb.append("___value" + Integer.toString(++count));
                stack.push(block);
                block = new Block(count);
                block.sb = new StringBuilder("IF(");
                ++block.parenthesis;
                continue;
            }
            if (c == '(' && block != null) {
                ++block.parenthesis;
                continue;
            }
            if (c != ')' || block == null) continue;
            --block.parenthesis;
            if (block.parenthesis != 0) continue;
            this.blockMap.put(block.id, block);
            if (stack.isEmpty()) continue;
            block = (Block)stack.pop();
        }
        if (block != null && !this.blockMap.containsKey(block.id)) {
            this.blockMap.put(block.id, block);
        }
    }

    private void process_adjust_type() {
        for (Integer key : this.blockMap.keySet()) {
            this.process_adjust_type0(key);
        }
    }

    private void process_adjust_type0(Integer key) {
        Block block = this.blockMap.get(key);
        String expr = block.sb.toString();
        int count = 0;
        Block __block = null;
        boolean quoteMode = false;
        Stack<Block> stack = new Stack<Block>();
        int length = expr.length();
        for (int i = 0; i < length; ++i) {
            char c = expr.charAt(i);
            if (c == '\"') {
                boolean bl = quoteMode = !quoteMode;
            }
            if (__block != null) {
                __block.sb.append(c);
            }
            if (quoteMode) continue;
            if (c == 'O' && i + 1 < length && expr.charAt(i + 1) == 'R' && i + 2 < length && expr.charAt(i + 2) == '(') {
                if (i - 1 >= 0 && expr.charAt(i - 1) >= 'A' && expr.charAt(i - 1) <= 'Z') continue;
                if (__block != null) {
                    stack.push(__block);
                }
                __block = new Block(count++);
                __block.sb = new StringBuilder("OR(");
                i += 2;
            } else if (c == 'A' && i + 1 < length && expr.charAt(i + 1) == 'N' && i + 2 < length && expr.charAt(i + 2) == 'D' && i + 3 < length && expr.charAt(i + 3) == '(') {
                if (i - 1 >= 0 && expr.charAt(i - 1) >= 'A' && expr.charAt(i - 1) <= 'Z') continue;
                if (__block != null) {
                    stack.push(__block);
                }
                __block = new Block(count++);
                __block.sb = new StringBuilder("AND(");
                i += 3;
            } else if (c == 'N' && i + 1 < length && expr.charAt(i + 1) == 'O' && i + 2 < length && expr.charAt(i + 2) == 'T' && i + 3 < length && expr.charAt(i + 3) == '(') {
                if (i - 1 >= 0 && expr.charAt(i - 1) >= 'A' && expr.charAt(i - 1) <= 'Z') continue;
                if (__block != null) {
                    stack.push(__block);
                }
                __block = new Block(count++);
                __block.sb = new StringBuilder("NOT(");
                i += 3;
            }
            if (c == '(' && __block != null) {
                ++__block.parenthesis;
                continue;
            }
            if (c != ')' || __block == null) continue;
            --block.parenthesis;
            if (__block.parenthesis != 0) continue;
            String cnt = __block.sb.toString();
            if (cnt.indexOf("___value") >= 0) {
                int[] targetids;
                for (int id : targetids = this.searchValueVariable(cnt)) {
                    Block tblock = this.blockMap.get(id);
                    tblock.type = "boolean";
                }
            }
            __block = !stack.isEmpty() ? (Block)stack.pop() : null;
        }
    }

    private String outputIfLadder(String varname, String type, String _type, String basetab) {
        Integer first_id;
        Block block;
        String expr;
        String exprtype;
        StringBuilder buf = new StringBuilder();
        ArrayList<Integer> idList = new ArrayList<Integer>(this.blockMap.keySet());
        int size = idList.size();
        if (size <= 1) {
            logger.error("[Internal Error] illegal value has detected, idList.size is less equal 1, model=" + this.model.getId() + ", item=" + this.sitem.getName() + ", blockMap=" + this.blockMap);
            return "// " + this.blockMap;
        }
        TreeMap<String, String> typeMap = new TreeMap<String, String>();
        Integer id = (Integer)idList.get(1);
        try {
            do {
                Object block2;
                String tmp = null;
                Object object = block2 = this.blockMap != null ? this.blockMap.get(id) : null;
                if (block2 != null && ((Block)block2).sb != null) {
                    tmp = ((Block)block2).sb.toString();
                }
                if (tmp != null && (tmp.indexOf("ARRAY") >= 0 || tmp.indexOf("REVERSE") >= 0 || tmp.indexOf("SORT") >= 0 || tmp.indexOf("ADD") >= 0 || tmp.indexOf("REMOVE") >= 0 || tmp.indexOf("MAX") >= 0 || tmp.indexOf("MIN") >= 0)) {
                    Integer n = id;
                    id = id + 1;
                    this.outputIfLadder0(n, idList, typeMap, _type, basetab, buf);
                    continue;
                }
                Integer n = id;
                id = id + 1;
                this.outputIfLadder0(n, idList, typeMap, type, basetab, buf);
            } while (this.blockMap.size() > 1);
        }
        catch (IllegalArgumentException e) {
            return "";
        }
        StringBuilder vardef = new StringBuilder();
        for (Map.Entry entry : typeMap.entrySet()) {
            String ___varname = (String)entry.getKey();
            String ___type = (String)entry.getValue();
            String ___p_type = JavaSourceGenerator.getProperType(___type);
            vardef.append(basetab);
            vardef.append(___p_type);
            vardef.append(" ");
            vardef.append(___varname);
            vardef.append(" = ");
            if (JavaSourceGenerator.isBasicType(___p_type) && !___type.endsWith("[]")) {
                vardef.append(JavaSourceGenerator.getValidValue(___p_type));
            } else {
                vardef.append("null");
            }
            vardef.append(";");
            vardef.append(CR);
        }
        if (vardef.length() > 0) {
            buf.insert(0, vardef.toString());
        }
        if ((exprtype = (String)typeMap.get(expr = (block = this.blockMap.get(first_id = idList.size() > 0 ? (Integer)idList.get(0) : null)) != null ? block.sb.toString() : null)) == null) {
            exprtype = _type;
        }
        if (first_id != null && expr != null) {
            String _wtype = null;
            _wtype = JavaSourceGenerator.isBasicType(_type) ? JavaSourceGenerator.b2wc(_type) : _type;
            buf.append(basetab);
            if (JavaSourceGenerator.isWrapperClass(_wtype) && !"Boolean".equals(_wtype)) {
                if (exprtype == null || exprtype != null && !exprtype.endsWith("[]")) {
                    buf.append("Number __n");
                } else {
                    buf.append(exprtype).append(" __n");
                }
            } else {
                buf.append(varname);
            }
            buf.append(" = ");
            buf.append(expr);
            buf.append(";");
            buf.append(CR);
            if (JavaSourceGenerator.isWrapperClass(_wtype) && !"Boolean".equals(_wtype)) {
                buf.append(basetab);
                buf.append("if (__n != null) {");
                buf.append(CR);
                buf.append(basetab + "    ");
                buf.append(varname);
                buf.append(" = __n");
                if (exprtype == null || exprtype != null && !exprtype.endsWith("[]")) {
                    buf.append(JavaSourceGenerator.getWc2b_method(_type));
                    buf.append("()");
                }
                buf.append(";");
                buf.append(CR);
                buf.append(basetab);
                buf.append("}");
                buf.append(CR);
            }
        }
        return buf.toString();
    }

    private void outputIfLadder0(Integer id, List<Integer> idList, Map<String, String> typeMap, String defaultType, String basetab, StringBuilder buf) throws IllegalArgumentException {
        String expr;
        if (!this.blockMap.containsKey(id)) {
            return;
        }
        Block block = this.blockMap.get(id);
        String string = expr = block != null ? block.sb.toString() : null;
        if (!expr.startsWith("IF(")) {
            Object[] o = new Object[]{this.model.getId(), this.sitem.getName(), expr, this.blockMap};
            logger.error(this.rman.getValue("expr.invalid.ifclause.begin", o));
            throw new IllegalArgumentException(expr);
        }
        String cond = null;
        String value1 = null;
        String value2 = null;
        boolean quoteMode = false;
        Stack<StringBuilder> stack = new Stack<StringBuilder>();
        StringBuilder __sb = new StringBuilder();
        int length = expr.length();
        for (int i = "IF(".length(); i < length - ")".length(); ++i) {
            char c = expr.charAt(i);
            __sb.append(c);
            if (c == '\"') {
                boolean bl = quoteMode = !quoteMode;
            }
            if (quoteMode) continue;
            if (c == '(') {
                stack.push(__sb);
                __sb = new StringBuilder();
            } else if (c == ')') {
                String __buf = null;
                if (!stack.isEmpty()) {
                    __buf = __sb.toString();
                    __sb = (StringBuilder)stack.pop();
                    __sb.append(__buf);
                }
            }
            if (c != ',' || !stack.isEmpty()) continue;
            if (cond == null) {
                cond = StringUtil.removePreAndPostWhitespaceWithoutInside((String)__sb.toString());
                if (cond.endsWith(",")) {
                    cond = cond.substring(0, cond.length() - 1);
                }
                __sb = new StringBuilder();
                continue;
            }
            if (value1 != null) continue;
            value1 = StringUtil.removePreAndPostWhitespaceWithoutInside((String)StringUtil.removeCRLF((String)__sb.toString()));
            if (value1.endsWith(",")) {
                value1 = value1.substring(0, value1.length() - 1);
            }
            __sb = new StringBuilder();
        }
        value2 = StringUtil.removePreAndPostWhitespaceWithoutInside((String)StringUtil.removeCRLF((String)__sb.toString()));
        if (value2.endsWith(",")) {
            value2 = value2.substring(0, value2.length() - 1);
        }
        if (cond == null) {
            Object[] o = new Object[]{this.model.getId(), this.sitem.getName(), expr, stack};
            logger.error(this.rman.getValue("expr.invalid.ifclause.cond.null", o));
            throw new IllegalArgumentException(expr);
        }
        if (value1 == null) {
            Object[] o = new Object[]{this.model.getId(), this.sitem.getName(), expr, stack};
            logger.error(this.rman.getValue("expr.invalid.ifclause.value1.null", o));
            throw new IllegalArgumentException(expr);
        }
        if (cond.indexOf("___value") >= 0) {
            int[] targetids = this.searchValueVariable(cond);
            int[] c = targetids;
            int __buf = c.length;
            for (int i = 0; i < __buf; ++i) {
                int i2 = c[i];
                this.outputIfLadder0(i2, idList, typeMap, defaultType, basetab, buf);
            }
        }
        buf.append(basetab);
        buf.append("if (");
        buf.append(this.convertProperMethodCall(cond));
        buf.append(") {");
        buf.append(CR);
        if (value1.indexOf("___value") >= 0) {
            int[] targetids = this.searchValueVariable(value1);
            for (int i2 : targetids) {
                this.outputIfLadder0(i2, idList, typeMap, defaultType, basetab + "    ", buf);
            }
        }
        buf.append(basetab + "    ");
        buf.append("___value" + id);
        buf.append(" = ");
        buf.append(this.convertProperMethodCall(value1));
        buf.append(";");
        buf.append(CR);
        String ___type = this.getTypeUsingExpr(value1.trim(), value2.trim(), defaultType, this.sitem);
        typeMap.put("___value" + id, ___type);
        buf.append(basetab);
        buf.append("} else {");
        buf.append(CR);
        if (value2.indexOf("___value") >= 0) {
            int[] targetids = this.searchValueVariable(value2);
            for (int i : targetids) {
                this.outputIfLadder0(i, idList, typeMap, defaultType, basetab + "    ", buf);
            }
        }
        buf.append(basetab + "    ");
        buf.append("___value" + id);
        buf.append(" = ");
        buf.append(this.convertProperMethodCall(value2));
        buf.append(";");
        buf.append(CR);
        buf.append(basetab);
        buf.append("}");
        buf.append(CR);
        this.blockMap.remove(id);
    }

    private String getTypeUsingExpr(String expr1, String expr2, String defaultType, Modelitem sitem) {
        String ret = null;
        String type1 = null;
        if (expr1.indexOf("(") > 0) {
            String dec = expr1.substring(0, expr1.indexOf("(")).trim();
            for (String s : funcMap.keySet()) {
                if (!dec.equals(s)) continue;
                type1 = funcMap.get(s);
                break;
            }
        } else {
            type1 = this.solveType(expr1);
        }
        String type2 = null;
        if (expr2.indexOf("(") > 0) {
            String dec = expr2.substring(0, expr2.indexOf("(")).trim();
            for (String s : funcMap.keySet()) {
                if (!dec.equals(s)) continue;
                type2 = funcMap.get(s);
                break;
            }
        } else {
            type2 = this.solveType(expr2);
        }
        ret = type1 == null && type2 == null ? defaultType : (type1 == null && type2 != null ? type2 : (type1 != null && type2 == null ? type1 : (type1 != null && type2 != null && type1.equals(type2) ? type1 : defaultType)));
        if ("masterref".equals(defaultType) && !ret.endsWith("[]")) {
            ret = "int";
        } else if ("long".equals(ret) && "double".equalsIgnoreCase(defaultType)) {
            ret = "double";
        } else if ("long".equals(ret) && ("int".equals(defaultType) || "Integer".equals(defaultType))) {
            ret = "int";
        } else if (JavaSourceGenerator.isBasicType(ret) && JavaSourceGenerator.isDateOrTimeType(defaultType)) {
            ret = defaultType;
        }
        if (ret.endsWith("[]")) {
            return ret;
        }
        if (JavaSourceGenerator.isBasicType(ret) && sitem != null && sitem.getType().equals("storeref")) {
            ret = JavaSourceGenerator.b2wc(ret);
        } else if (JavaSourceGenerator.isBasicType(ret) && ("null".equals(expr1) || "null".equals(expr2)) && !sitem.getMust()) {
            ret = JavaSourceGenerator.b2wc(ret);
        }
        return ret;
    }

    private String solveType(String expr) {
        if ((expr = expr.trim()).startsWith("\"") && expr.endsWith("\"")) {
            return "String";
        }
        try {
            Double.parseDouble(expr);
            if (expr.indexOf(".") >= 0 || expr.toLowerCase().endsWith("d")) {
                return "double";
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            Long.parseLong(expr);
            return "long";
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private int[] searchValueVariable(String s) {
        ArrayList<String> varids = new ArrayList<String>();
        int ptr = -1;
        StringBuilder buf = new StringBuilder();
        boolean goNextFlag = false;
        while ((ptr = s.indexOf("___value")) >= 0) {
            goNextFlag = false;
            for (int i = ptr += "___value".length(); i < s.length(); ++i) {
                char c = s.charAt(i);
                if (!Character.isDigit(c)) {
                    varids.add(buf.toString());
                    buf = new StringBuilder();
                    s = s.substring(ptr);
                    goNextFlag = true;
                    break;
                }
                buf.append(c);
            }
            if (goNextFlag) continue;
            if (buf.length() <= 0) break;
            varids.add(buf.toString());
            break;
        }
        int[] ret = new int[varids.size()];
        for (int i = 0; i < ret.length; ++i) {
            try {
                ret[i] = Integer.parseInt((String)varids.get(i));
                continue;
            }
            catch (NumberFormatException e) {
                logger.error("[Internal Error] illegal parameter is detected, varids[" + i + "]=" + (String)varids.get(i) + ", s=" + s);
            }
        }
        return ret;
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public boolean isError_child() {
        return false;
    }

    @Override
    public void process_single0(String basetab) {
        this.process_single0(basetab, this.id, this.id, this.name, this.type, true);
    }

    public void process_single0(String basetab, String id, String id0, String name, String type, boolean wrapFlag) {
        boolean outputReturnStatementInCatchClause = false;
        boolean isIgnoreCalcFlag = false;
        String vname = "_ret_" + name;
        String mtab = "";
        if (wrapFlag) {
            this.sb.append(basetab);
            if (this.sitem.getTransient()) {
                this.sb.append("{");
            } else {
                this.sb.append("if (!isIgnoreCalc(\"" + this.sitem.getName() + "\", p, ignoreIfSaveDBFlag)) { ");
                isIgnoreCalcFlag = true;
            }
            this.sb.append(CR);
            mtab = "    ";
        }
        if (!this.isMust_sitem || !this.sitem.getTransient()) {
            this.sb.append(basetab + mtab);
            this.sb.append("boolean _processed = ");
            if (this.isMust_sitem || this.varMap.size() == 0 && this.preformula.size() == 0) {
                this.sb.append("true;");
            } else {
                this.sb.append("false;");
            }
            this.sb.append(CR);
        }
        if (this.varMap.size() > 0) {
            for (String varname : this.varMap.keySet()) {
                String orig_varname;
                Modelitem __mitem;
                VariableStatus vstatus = this.varMap.get(varname);
                String vartype = vstatus.type;
                boolean _isMust = vstatus.isMust;
                boolean _isContainer = vstatus.isContainer;
                boolean isCheckBox = false;
                if ("int[]".equals(vartype)) {
                    vartype = "int";
                    isCheckBox = true;
                }
                boolean _isMultiple = false;
                if (varname.charAt(0) == '_' && (__mitem = AppSchemaUtil.getModelitem(orig_varname = varname.substring(1), this.model)) != null && __mitem.getMultiple()) {
                    _isMultiple = true;
                }
                this.sb.append(basetab + mtab);
                this.sb.append(JavaSourceGenerator.getProperType(vartype));
                if (_isMultiple || isCheckBox) {
                    this.sb.append("[]");
                }
                this.sb.append(" ");
                this.sb.append(varname);
                this.sb.append(" = ");
                if (isCheckBox) {
                    this.sb.append(_isContainer ? id : id0);
                    this.sb.append(JavaSourceGenerator.getterFullMethod(varname));
                    this.sb.append(";").append(CR);
                } else if (_isMust) {
                    this.sb.append(_isContainer ? id : id0);
                    this.sb.append(JavaSourceGenerator.getterFullMethod(varname));
                    this.sb.append(";");
                } else if (JavaSourceGenerator.isBasicType(vartype) && (!this.isMultiple || this.isChild)) {
                    this.sb.append("(");
                    this.sb.append(_isContainer ? id : id0);
                    this.sb.append(" != null && ");
                    this.sb.append(_isContainer ? id : id0);
                    this.sb.append(JavaSourceGenerator.checkFullMethod(varname));
                    this.sb.append(") ? ");
                    this.sb.append(_isContainer ? id : id0);
                    this.sb.append(JavaSourceGenerator.getterFullMethod(varname));
                    this.sb.append(" : ");
                    this.sb.append(JavaSourceGenerator.getValidValue(vartype));
                    this.sb.append(";");
                } else {
                    this.sb.append("(");
                    this.sb.append(_isContainer ? id : id0);
                    this.sb.append(" != null) ? ");
                    this.sb.append(_isContainer ? id : id0);
                    this.sb.append(JavaSourceGenerator.getterFullMethod(varname));
                    this.sb.append(" : null");
                    this.sb.append(";");
                }
                this.sb.append(CR);
            }
        }
        if (this.preformula.size() > 0) {
            for (int i = 0; i < this.preformula.size(); ++i) {
                String line = this.preformula.get(i);
                this.sb.append(basetab + mtab);
                this.sb.append(line);
                this.sb.append(CR);
            }
        }
        String ltab = "";
        this.sb.append(basetab + mtab);
        this.sb.append("try {");
        this.sb.append(CR);
        if (!this.isMust_sitem || !this.sitem.getTransient()) {
            this.sb.append(basetab + mtab + "    ");
            this.sb.append("if (_processed) {");
            this.sb.append(CR);
            ltab = "    ";
        }
        this.sb.append(basetab + mtab + "    " + ltab);
        boolean isCheckbox = false;
        Relation relation = AppSchemaUtil.getRelationTypeExceptRef(this.sitem);
        if (relation != null && relation.getType().equals("check")) {
            isCheckbox = true;
        }
        String _type = AppSchemaUtil.getProperTypeConsideringNull(type, this.sitem, this.model);
        if (this.blockMap.size() == 0) {
            String _wtype = null;
            _wtype = JavaSourceGenerator.isBasicType(_type) ? JavaSourceGenerator.b2wc(_type) : _type;
            boolean useVarN = false;
            if ((JavaSourceGenerator.isWrapperClass(_type) || JavaSourceGenerator.isBasicType(_type)) && isCheckbox && ("_calc_".equals(this.methodNamePrefix) || this.methodNamePrefix.startsWith("_defaultValue_"))) {
                if (JavaSourceGenerator.isWrapperClass(_type)) {
                    _wtype = _type = JavaSourceGenerator.wc2b(_type);
                } else if (JavaSourceGenerator.isWrapperClass(_wtype)) {
                    _wtype = JavaSourceGenerator.wc2b(_wtype);
                }
                this.sb.append(_type).append("[] __n");
                useVarN = true;
            } else if (JavaSourceGenerator.isWrapperClass(_wtype) && !"Boolean".equals(_wtype)) {
                if (this.isMultiple && !this.isChild && !this.hasChild && ("_calc_".equals(this.methodNamePrefix) || this.methodNamePrefix.startsWith("_defaultValue_"))) {
                    this.sb.append(_wtype).append("[]");
                } else {
                    this.sb.append("Number");
                }
                this.sb.append(" __n");
                useVarN = true;
            } else {
                this.sb.append(_wtype);
                if ((this.isMultiple && !this.isChild && !this.hasChild || isCheckbox) && ("_calc_".equals(this.methodNamePrefix) || this.methodNamePrefix.startsWith("_defaultValue_") || this.methodNamePrefix.startsWith("_copy_formula_"))) {
                    this.sb.append("[]");
                }
                this.sb.append(" ");
                this.sb.append(vname);
            }
            this.sb.append(" = ");
            boolean illegalState = false;
            String _expr = this.convertProperMethodCall(this.formula.toString());
            if (StringUtils.isNotBlank((CharSequence)_expr)) {
                boolean useToObjectMethod = false;
                if (JavaSourceGenerator.isWrapperClass(_wtype) && !"Boolean".equals(_wtype) && this.isMultiple && !this.isChild && !this.hasChild && _expr.indexOf(".wf_nextgroupid") <= 0 && _expr.indexOf("WFNEXTGROUPID") < 0) {
                    this.sb.append("ArrayUtils.toObject(");
                    useToObjectMethod = true;
                }
                this.sb.append(_expr);
                if (useToObjectMethod) {
                    this.sb.append(")");
                }
            } else {
                if (JavaSourceGenerator.isBasicType(_type)) {
                    if (this.isMultiple && !this.isChild && !this.hasChild && ("_calc_".equals(this.methodNamePrefix) || this.methodNamePrefix.startsWith("_defaultValue_"))) {
                        this.sb.append("new ").append(_wtype).append("[0]");
                    } else {
                        this.sb.append(JavaSourceGenerator.getValidValue(_type));
                    }
                } else {
                    this.sb.append("null");
                }
                illegalState = true;
            }
            this.sb.append(";");
            if (illegalState) {
                this.sb.append(" // illegal expression has detected. " + this.cnt);
                this.sb.append(", _expr=" + _expr + ",formula=" + this.formula + ",preformula=" + this.preformula);
                Object[] o = new Object[]{id, this.cnt};
                logger.error(this.rman.getValue("helper.comment.autocalc.error2", o));
            }
            this.sb.append(CR);
            if ((JavaSourceGenerator.isWrapperClass(_wtype) || isCheckbox) && !"Boolean".equals(_wtype) && useVarN) {
                this.sb.append(basetab + mtab + "    " + ltab);
                this.sb.append(_wtype);
                if ((this.isMultiple && !this.isChild && !this.hasChild || isCheckbox) && ("_calc_".equals(this.methodNamePrefix) || this.methodNamePrefix.startsWith("_defaultValue_") || this.methodNamePrefix.startsWith("_copy_formula_"))) {
                    this.sb.append("[]");
                }
                this.sb.append(" ");
                this.sb.append(vname);
                this.sb.append(" = null;");
                this.sb.append(CR);
                this.sb.append(basetab + mtab + "    " + ltab);
                this.sb.append("if (__n != null) {");
                this.sb.append(CR);
                this.sb.append(basetab + mtab + "        " + ltab);
                this.sb.append(vname);
                this.sb.append(" = __n");
                if ((!this.isMultiple || this.isChild || this.hasChild) && !isCheckbox || !"_calc_".equals(this.methodNamePrefix) && !this.methodNamePrefix.startsWith("_defaultValue_") && !this.methodNamePrefix.startsWith("_copy_formula_")) {
                    this.sb.append(JavaSourceGenerator.getWc2b_method(_type));
                    this.sb.append("()");
                }
                this.sb.append(";");
                this.sb.append(CR);
                this.sb.append(basetab + mtab + "    " + ltab);
                this.sb.append("}");
                this.sb.append(CR);
            }
        } else {
            boolean needsAddArray = false;
            if ((JavaSourceGenerator.isWrapperClass(_type) || JavaSourceGenerator.isBasicType(_type)) && isCheckbox) {
                if (JavaSourceGenerator.isWrapperClass(_type)) {
                    _type = JavaSourceGenerator.wc2b(_type);
                }
                if (JavaSourceGenerator.isWrapperClass(_type) || isCheckbox) {
                    needsAddArray = true;
                }
            } else if ((JavaSourceGenerator.isStringType(_type) || JavaSourceGenerator.isDateOrTimeType(_type)) && isCheckbox) {
                needsAddArray = true;
            }
            if (this.methodNamePrefix.startsWith("__permission_")) {
                needsAddArray = false;
            }
            if (this.methodNamePrefix.startsWith("getStyle_")) {
                needsAddArray = false;
            }
            this.sb.append("/*" + CR);
            this.sb.append(" " + this.formula + CR);
            for (Integer key : this.blockMap.keySet()) {
                Block block = this.blockMap.get(key);
                String expr = block != null ? block.sb.toString() : null;
                this.sb.append(" ___value" + key + "=" + expr + CR);
            }
            this.sb.append(basetab + mtab + "    " + ltab);
            this.sb.append(" */" + CR);
            this.sb.append(basetab + mtab + "    " + ltab);
            this.sb.append(_type);
            if (needsAddArray) {
                this.sb.append("[]");
            }
            this.sb.append(" ");
            this.sb.append(vname);
            this.sb.append(" = ");
            if (JavaSourceGenerator.isBasicType(_type) && !needsAddArray) {
                this.sb.append(JavaSourceGenerator.getValidValue(_type));
            } else {
                this.sb.append("null");
            }
            this.sb.append(";");
            this.sb.append(CR);
            this.sb.append(this.outputIfLadder(vname, type, _type + (needsAddArray ? "[]" : ""), basetab + mtab + "    " + ltab));
        }
        if (this.isMultiple && !this.isChild && !this.hasChild && ("_calc_".equals(this.methodNamePrefix) || this.methodNamePrefix.startsWith("_defaultValue_")) && (JavaSourceGenerator.isStringType(type) || JavaSourceGenerator.isDateOrTimeType(type))) {
            this.sb.append(basetab + mtab + "    " + ltab);
            this.sb.append("return ");
            this.sb.append("ARRAY");
            this.sb.append("(");
            this.sb.append(vname);
            this.sb.append(");");
            this.sb.append(CR);
        } else {
            this.sb.append(basetab + mtab + "    " + ltab);
            this.sb.append("return ");
            this.sb.append(vname);
            this.sb.append(";");
            this.sb.append(CR);
        }
        if (!this.isMust_sitem || !this.sitem.getTransient()) {
            this.sb.append(basetab + mtab + "    ");
            this.sb.append("}");
            if (!this.sitem.getTransient() && !this.sitem.getMultiple()) {
                this.sb.append(" else {");
                this.sb.append(CR);
                String ntab = "";
                if (JavaSourceGenerator.isBasicType(this.sitem.getType()) && !this.sitem.getMust()) {
                    this.sb.append(basetab + mtab + "        ");
                    this.sb.append("if (");
                    this.sb.append(id);
                    this.sb.append(JavaSourceGenerator.checkFullMethod(name));
                    this.sb.append(") {");
                    this.sb.append(CR);
                    ntab = "    ";
                }
                this.sb.append(basetab + mtab + ntab + "        ");
                this.sb.append("return ");
                this.sb.append(id);
                this.sb.append(JavaSourceGenerator.getterFullMethod(name));
                this.sb.append(";");
                this.sb.append(CR);
                if (ntab.length() > 0) {
                    this.sb.append(basetab + mtab + "        ");
                    this.sb.append("}");
                    this.sb.append(CR);
                }
                this.sb.append(basetab + mtab + "    ");
                this.sb.append("}");
            }
            this.sb.append(CR);
        }
        this.sb.append(basetab + mtab);
        this.sb.append("} catch (java.lang.Exception e) {");
        this.sb.append(CR);
        this.sb.append(basetab + mtab + "    ");
        this.sb.append("logger.warn(\"An exceptional arithmetic condition has occurred, " + this.sitem.getName() + " in " + id + ". \" + e.getMessage());");
        this.sb.append(CR);
        if (this.isMust_sitem) {
            this.sb.append(basetab + mtab + "    ");
            this.sb.append("return ");
            if (JavaSourceGenerator.isBasicType(type)) {
                if (isCheckbox && !"boolean".equals(type)) {
                    this.sb.append("ARRAY_").append(type.toUpperCase()).append("(");
                    this.sb.append(JavaSourceGenerator.getValidValue(type));
                    this.sb.append(")");
                } else {
                    this.sb.append(JavaSourceGenerator.b2wc(type));
                    this.sb.append(".valueOf(");
                    this.sb.append(JavaSourceGenerator.getValidValue(type));
                    this.sb.append(")");
                }
            } else {
                this.sb.append(JavaSourceGenerator.getValidValue(type));
            }
            this.sb.append(";");
            this.sb.append(CR);
            outputReturnStatementInCatchClause = true;
        }
        this.sb.append(basetab + mtab);
        this.sb.append("}");
        this.sb.append(CR);
        if (wrapFlag) {
            this.sb.append(basetab);
            this.sb.append("}");
            this.sb.append(CR);
        }
        boolean isOutputFinalReturnNullFlag = false;
        if (isIgnoreCalcFlag) {
            isOutputFinalReturnNullFlag = true;
        } else if (!outputReturnStatementInCatchClause) {
            isOutputFinalReturnNullFlag = true;
        }
        if (isOutputFinalReturnNullFlag) {
            this.sb.append(basetab);
            this.sb.append("return null;");
            this.sb.append(CR);
        }
    }

    private String convertProperMethodCall(String formula) {
        if (this.model == null || "_calc_".equals(this.methodNamePrefix)) {
            return formula;
        }
        String methodCallPrefix = AppSchemaUtil.getHelperClassname4Dicon(this.model, this.project);
        return StringUtil.replaceAll((String)formula, (String)"__calc_", (String)(methodCallPrefix + ".__calc_"));
    }

    @Override
    public void process_child_op(String basetab) {
        this.process_single0(basetab, "__" + this.pname, this.id, "__" + this.cname, this.type, false);
    }

    protected int gVarExpand(String s) {
        int func_type;
        CalcProcess _instance = null;
        String name = s;
        String __name = null;
        String condition = "";
        boolean conditionError = false;
        int ptr = s.indexOf(",");
        if (ptr > 0) {
            __name = StringUtil.removePreAndPostWhitespaceWithoutInside((String)s.substring(0, ptr));
            condition = StringUtil.removePreAndPostWhitespaceWithoutInside((String)s.substring(ptr + 1));
            if (condition.length() > 1 && condition.startsWith("\"") && condition.endsWith("\"")) {
                condition = condition.substring(1, condition.length() - 1);
            } else {
                conditionError = true;
            }
        } else {
            __name = name;
        }
        Model targetmodel = this.model;
        int __ptr = __name.indexOf(".");
        if (__name != null && __ptr > 0) {
            Model __model;
            String prefix = __name.substring(0, __ptr);
            if ("cond".equals(prefix)) {
                Action[] actions = AppSchemaUtil.getActionByModelId(this.project, AppSchemaUtil.getStoreModel(this.model).getId());
                if (actions != null) {
                    for (Action action : actions) {
                        Model cond;
                        Conditionlist conditionlist;
                        if (!"showList".equals(action.getType()) || (conditionlist = AppSchemaUtil.getConditionlist(action)) == null || (cond = (Model)conditionlist.getIdrefAsIRNode()) == null) continue;
                        targetmodel = cond;
                        this.id = targetmodel.getId();
                        __name = __name.substring(__ptr + 1);
                        this.useConditionModel = true;
                        break;
                    }
                }
            } else if (!prefix.endsWith("_lp") && (__model = AppSchemaUtil.getModel(this.project, prefix)) != null) {
                targetmodel = __model;
                __name = __name.substring(__ptr + 1);
            }
        }
        if ((func_type = HelperGenerator_calc_parser.getFunctionType(name)) > -1) {
            if (func_type == 0 || func_type == 1 || func_type == 2 || func_type == 3 || func_type == 4 || func_type == 5 || func_type == 6 || func_type == 11 || func_type == 13) {
                name = __name;
            }
            name = HelperGenerator_calc_parser.getModelitemNameIncludingFunction(name, func_type);
            name = this.consideringMethod(name, targetmodel);
            switch (func_type) {
                case 0: {
                    Object[] o;
                    if (conditionError) {
                        o = new Object[]{this.id, s};
                        logger.error(this.rman.getValue("helper.invalid.autocalc.condition.beginend", o));
                        return 6;
                    }
                    _instance = new CalcProcess_Sum(this.id, s, name, condition, this.formula, this.preformula, this.sitem, targetmodel, this.declareVarSet, this.varMap);
                    break;
                }
                case 1: {
                    Object[] o;
                    if (conditionError) {
                        o = new Object[]{this.id, s};
                        logger.error(this.rman.getValue("helper.invalid.autocalc.condition.beginend", o));
                        return 6;
                    }
                    _instance = new CalcProcess_Count(this.id, s, name, condition, this.formula, this.preformula, this.sitem, targetmodel, this.declareVarSet, this.varMap);
                    break;
                }
                case 2: {
                    Object[] o;
                    if (conditionError) {
                        o = new Object[]{this.id, s};
                        logger.error(this.rman.getValue("helper.invalid.autocalc.condition.beginend", o));
                        return 6;
                    }
                    _instance = new CalcProcess_Avg(this.id, s, name, condition, this.formula, this.preformula, this.sitem, targetmodel, this.declareVarSet, this.varMap);
                    break;
                }
                case 3: {
                    Object[] o;
                    if (conditionError) {
                        o = new Object[]{this.id, s};
                        logger.error(this.rman.getValue("helper.invalid.autocalc.condition.beginend", o));
                        return 6;
                    }
                    _instance = new CalcProcess_Max(this.id, s, name, condition, this.formula, this.preformula, this.sitem, targetmodel, this.declareVarSet, this.varMap);
                    break;
                }
                case 4: {
                    Object[] o;
                    if (conditionError) {
                        o = new Object[]{this.id, s};
                        logger.error(this.rman.getValue("helper.invalid.autocalc.condition.beginend", o));
                        return 6;
                    }
                    _instance = new CalcProcess_Min(this.id, s, name, condition, this.formula, this.preformula, this.sitem, targetmodel, this.declareVarSet, this.varMap);
                    break;
                }
                case 5: {
                    Object[] o;
                    if (conditionError) {
                        o = new Object[]{this.id, s};
                        logger.error(this.rman.getValue("helper.invalid.autocalc.condition.beginend", o));
                        return 6;
                    }
                    _instance = new CalcProcess_First(this.id, s, name, condition, this.formula, this.preformula, this.sitem, targetmodel, this.declareVarSet, this.varMap);
                    break;
                }
                case 6: {
                    Object[] o;
                    if (conditionError) {
                        o = new Object[]{this.id, s};
                        logger.error(this.rman.getValue("helper.invalid.autocalc.condition.beginend", o));
                        return 6;
                    }
                    _instance = new CalcProcess_Last(this.id, s, name, condition, this.formula, this.preformula, this.sitem, targetmodel, this.declareVarSet, this.varMap);
                    break;
                }
                case 7: {
                    _instance = new CalcProcess_Slice(this.id, s, name, condition, this.formula, this.preformula, this.sitem, targetmodel, this.declareVarSet, this.varMap);
                    break;
                }
                case 8: {
                    _instance = new CalcProcess_Join(this.id, s, name, condition, this.formula, this.preformula, this.sitem, targetmodel, this.declareVarSet, this.varMap, JoinMode.Simple);
                    break;
                }
                case 9: {
                    _instance = new CalcProcess_Join(this.id, s, name, condition, this.formula, this.preformula, this.sitem, targetmodel, this.declareVarSet, this.varMap, JoinMode.Distinct);
                    break;
                }
                case 10: {
                    _instance = new CalcProcess_Join(this.id, s, name, condition, this.formula, this.preformula, this.sitem, targetmodel, this.declareVarSet, this.varMap, JoinMode.DoubleDistinct);
                    break;
                }
                case 11: {
                    _instance = new CalcProcess_Isnoselection(this.id, s, name, condition, this.formula, this.preformula, this.sitem, targetmodel, this.declareVarSet, this.varMap);
                    break;
                }
                case 13: {
                    Object[] o;
                    if (conditionError) {
                        o = new Object[]{this.id, s};
                        logger.error(this.rman.getValue("helper.invalid.autocalc.condition.beginend", o));
                        return 6;
                    }
                    _instance = new CalcProcess_Collect(this.id, s, name, condition, this.formula, this.preformula, this.sitem, targetmodel, this.declareVarSet, this.varMap);
                }
            }
        } else {
            name = name != null ? HelperGenerator_calc_parser.normalize(name) : "";
            name = this.consideringMethod(name, targetmodel);
            _instance = new CalcProcess_Normal(this.id, s, name, condition, this.formula, this.preformula, this.sitem, targetmodel, this.declareVarSet, this.varMap);
        }
        return _instance.process();
    }

    private String consideringMethod(String name, Model model) {
        Modelitem __mitem;
        if (!(AppSchemaUtil.hasIdSuffixInExpr((String)name) || ((String)name).endsWith("#content") || ((String)name).endsWith("#array") || ((String)name).equals(this.sitem.getName()) || !AppSchemaUtil.hasAutocalc(__mitem = AppSchemaUtil.getModelitem((String)name, model)))) {
            name = StringUtil.replaceAll((String)name, (String)"/", (String)"$");
            name = "__calc_" + (String)name + "(" + model.getId();
            if (AppSchemaUtil.hasChildPart(__mitem.getName())) {
                String _pname = AppSchemaUtil.getParentPart(__mitem.getName());
                name = (String)name + ", __" + _pname;
            }
            name = (String)name + ", p, ignoreIfSaveDBFlag)";
        }
        return name;
    }

    private String createTmpVarName(String tname, String cname) {
        if (tname != null && tname.startsWith("__calc_") && tname.endsWith(")")) {
            return tname;
        }
        return "_" + cname;
    }

    protected String resolvTargetitemType(String targetitemtype, Modelitem targetitem) {
        Relation rel;
        String _targetitemtype = targetitemtype;
        if ("storeref".equals(targetitemtype) && (rel = AppSchemaUtil.getRelationTypeIsRef(targetitem)) != null) {
            Modelitem ritem;
            Model rmodel = null;
            IRNode node = rel.getIdrefAsIRNode();
            if (node != null && node instanceof Model) {
                rmodel = (Model)node;
            }
            if (rmodel != null && (ritem = AppSchemaUtil.getModelitem(rel.getName(), rmodel)) != null) {
                if (AppSchemaUtil.getRelationTypeExceptRef(ritem) != null) {
                    Relation rel_ritem;
                    _targetitemtype = AppSchemaUtil.getModelitemType(this.project, rmodel.getId(), ritem, "roleid");
                    if ("int".equals(_targetitemtype) && "storeref".equals(ritem.getType()) && (rel_ritem = AppSchemaUtil.getRelation(ritem)) != null && "check".equals(rel_ritem.getType())) {
                        _targetitemtype = "int[]";
                    }
                } else {
                    _targetitemtype = this.resolvTargetitemType(ritem.getType(), ritem);
                }
            }
        }
        return _targetitemtype;
    }

    public static String createIdentification4CacheModel(String ppackagename, String pclassname, Model smodel, String sid, Project project) {
        return HelperGenerator_calc_operation.createIdentification4CacheModel(ppackagename, pclassname, smodel, sid, project, false);
    }

    public static String createIdentification4CacheModel(String ppackagename, String pclassname, Model smodel, String sid, Project project, boolean usePackageAndClassName) {
        StringBuilder _sb = new StringBuilder();
        PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(smodel, project);
        _sb.append("\"");
        if (usePackageAndClassName) {
            _sb.append(ppackagename).append(pclassname).append("_\"+");
        } else {
            _sb.append("_\"+");
        }
        for (int i = 0; i < pkeys.length; ++i) {
            _sb.append(sid);
            _sb.append(JavaSourceGenerator.getterFullMethod(AppSchemaUtil.createFullPrimaryKeyName(pkeys[i])));
            if (i >= pkeys.length - 1) continue;
            _sb.append("+PrimaryKeyUtils.PKEY_SEPARATOR()+");
        }
        return _sb.toString();
    }

    public String getProperConvMethod(String type, Modelitem item, boolean mode_id, boolean mode_content) {
        Object ret = null;
        if (type == null || type.length() == 0 || JavaSourceGenerator.isStringType(type)) {
            ret = "(";
        } else if (JavaSourceGenerator.isBasicType(type)) {
            ret = "StringUtil." + type + "Value(";
        } else if (JavaSourceGenerator.isDateOrTimeType(type)) {
            ret = "DateTimeUtil.getSQLDate(";
        } else if ("masterref".equals(type)) {
            ret = !mode_id && !mode_content ? "StringUtil.intValue(" : "(";
        } else if ("storeref".equals(type) && item != null) {
            String _type0 = AppSchemaUtil.getModelitemType(this.project, "", item, "roleid");
            if (_type0 != null) {
                ret = this.getProperConvMethod(_type0, null, mode_id, mode_content);
            }
        } else {
            ret = "(";
        }
        return ret;
    }

    public static String getModelIdPart(String tname) {
        String _refmodel_id = null;
        int __ptr = tname.indexOf(".");
        _refmodel_id = __ptr < 0 ? tname : tname.substring(0, __ptr);
        return _refmodel_id;
    }

    public static String getModelItemNamePart(String tname) {
        String _refmodel_itemname = null;
        int __ptr = tname.indexOf(".");
        if (__ptr > 0) {
            _refmodel_itemname = tname.substring(__ptr + 1);
        }
        return _refmodel_itemname;
    }

    public static String getProperTab(List<String> preformula) {
        return HelperGenerator_calc_operation.getProperTab(preformula, true);
    }

    public static String getProperTab(List<String> preformula, boolean addTab4Flag) {
        if (preformula == null || preformula.size() == 0) {
            return "";
        }
        int size = preformula.size();
        String last_sentence = preformula.get(size - 1);
        StringBuilder tab = new StringBuilder();
        for (int i = 0; i < last_sentence.length() && last_sentence.charAt(i) == ' '; ++i) {
            tab.append(" ");
        }
        if (addTab4Flag) {
            tab.append("    ");
        }
        return tab.toString();
    }

    public static String toStringPart(String s) {
        String ret = StringUtil.removePreAndPostWhitespaceWithoutInside((String)s);
        ret = ret.startsWith("\"") && ret.endsWith("\"") || ret.startsWith("'") && ret.endsWith("'") ? ret.substring(1, ret.length() - 1) : "";
        return ret;
    }

    public static void clearLpModelCache(Set<String> lpModelAttrNameSet, StringBuilder sb, String tab) {
        if (lpModelAttrNameSet == null || lpModelAttrNameSet.size() == 0) {
            return;
        }
        Iterator<String> it = lpModelAttrNameSet.iterator();
        while (it.hasNext()) {
            sb.append(tab);
            sb.append("p.request.removeAttribute(\"");
            sb.append(it.next());
            sb.append("\");");
            sb.append(CR);
        }
    }

    public static void gPutLruMapCode(List<String> preformula, Model model, Project project, String id) {
        HelperGenerator_calc_operation.gPutLruMapCode(preformula, model, project, id, false);
    }

    public static void gPutLruMapCode(List<String> preformula, Model model, Project project, String id, boolean isOverwrite) {
        Model pmodel = AppSchemaUtil.getModel(project, id, "presentation");
        String ppackagename = pmodel != null ? AppSchemaUtil.getPackagename(pmodel, project) : "";
        String ppackagename_app = AppSchemaUtil.getPackagename_app(model, project);
        String pclassname = AppSchemaUtil.getClassname(pmodel);
        String sid = model.getId();
        String pid = sid + "_p";
        String key = HelperGenerator_calc_operation.createIdentification4CacheModel(ppackagename, pclassname, model, sid, project);
        if (preformula.toString().indexOf(key) >= 0) {
            return;
        }
        StringBuilder _sb = new StringBuilder();
        Object tab = HelperGenerator_calc_operation.getProperTab(preformula);
        _sb.append((String)tab);
        _sb.append("String __key = ").append(key).append(";");
        preformula.add(_sb.toString());
        _sb = new StringBuilder();
        _sb.append((String)tab);
        _sb.append("LRUMap __lruMap = ");
        _sb.append("(LRUMap)p.request.getAttribute(\"");
        _sb.append(ppackagename + pclassname).append("\");");
        preformula.add(_sb.toString());
        _sb = new StringBuilder();
        _sb.append((String)tab);
        _sb.append(ppackagename);
        _sb.append(pclassname);
        _sb.append(" ");
        _sb.append(pid);
        _sb.append(";");
        preformula.add(_sb.toString());
        String base_tab = "";
        if (!isOverwrite) {
            _sb = new StringBuilder();
            _sb.append((String)tab);
            _sb.append(pid);
            _sb.append(" = (__lruMap != null) ? ");
            _sb.append("(").append(ppackagename).append(pclassname).append(")");
            _sb.append("__lruMap.get(__key) : null;");
            preformula.add(_sb.toString());
            _sb = new StringBuilder();
            _sb.append((String)tab);
            _sb.append("if (").append(pid).append(" == null) {");
            preformula.add(_sb.toString());
            base_tab = tab;
            tab = (String)tab + "    ";
        }
        _sb = new StringBuilder();
        _sb.append((String)tab);
        _sb.append(pid);
        _sb.append(" = ");
        _sb.append(AppSchemaUtil.getHelperClassname4Dicon(pmodel, project));
        _sb.append(".s2p(");
        _sb.append(sid);
        _sb.append(", p, ");
        _sb.append(ppackagename_app);
        _sb.append(pclassname + "Helper");
        _sb.append(".SHOW);");
        preformula.add(_sb.toString());
        _sb = new StringBuilder();
        _sb.append((String)tab);
        _sb.append("if (__lruMap == null) {");
        preformula.add(_sb.toString());
        _sb = new StringBuilder();
        _sb.append((String)tab + "    ");
        _sb.append("__lruMap = new LRUMap();");
        preformula.add(_sb.toString());
        _sb = new StringBuilder();
        _sb.append((String)tab + "    ");
        _sb.append("p.request.setAttribute(\"");
        _sb.append(ppackagename + pclassname).append("\", __lruMap);");
        preformula.add(_sb.toString());
        _sb = new StringBuilder();
        _sb.append((String)tab);
        _sb.append("}");
        preformula.add(_sb.toString());
        _sb = new StringBuilder();
        _sb.append((String)tab);
        _sb.append("__lruMap.put(__key, ").append(pid).append(");");
        preformula.add(_sb.toString());
        if (!isOverwrite) {
            tab = base_tab;
            _sb = new StringBuilder();
            _sb.append((String)tab);
            _sb.append("}");
            preformula.add(_sb.toString());
        }
    }

    protected boolean isMatchType(String stype, String dtype) {
        return JavaSourceGenerator.isStringType(stype) && JavaSourceGenerator.isStringType(dtype) || JavaSourceGenerator.isBasicType(stype) && JavaSourceGenerator.isBasicType(dtype) || JavaSourceGenerator.isDateOrTimeType(stype) && JavaSourceGenerator.isDateOrTimeType(dtype);
    }

    static {
        HashSet<String> skipNameSet = new HashSet<String>();
        skipNameSet.add("ARRAY");
        skipNameSet.add("MAX");
        skipNameSet.add("MIN");
        skipNameSet.add("REMOVEELEMENT");
        skipNameSet.add("REMOVEELEMENTALL");
        try {
            Method[] methods;
            Class<?> clazz = Class.forName("jp.jasminesoft.util.ExcelFunction");
            for (Method method : methods = clazz.getMethods()) {
                int modifiers = method.getModifiers();
                if (!Modifier.isFinal(modifiers) || !Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers)) continue;
                String retType = ClassUtils.getProperReturnType(method.getReturnType());
                String name = method.getName();
                if (skipNameSet.contains(name)) {
                    funcMap.remove(name);
                    continue;
                }
                boolean needsFuncMapSetFlag = true;
                if (funcMap.containsKey(name)) {
                    String prefix;
                    String _retType = funcMap.get(name);
                    if (retType.endsWith("[]") && "Object".equals(prefix = retType.substring(0, retType.length() - "[]".length()))) {
                        skipNameSet.add(name);
                        continue;
                    }
                    if ((retType = HelperGenerator_calc_operation.selectPriorType(retType, _retType)).equals(_retType)) {
                        needsFuncMapSetFlag = false;
                    }
                }
                if (!needsFuncMapSetFlag) continue;
                funcMap.put(name, retType);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        funcMap.put("TODAY", "java.sql.Date");
        funcMap.put("NOW", "java.sql.Timestamp");
        funcMap.put("ANORMPART", "String");
        funcMap.put("FLOWSTATUS", "String");
        funcMap.put("USERNAME", "String");
        funcMap.put("HASPRINCIPAL", "boolean");
        funcMap.put("USERINFO", "String");
        funcMap.put("HASMODELPERMISSION", "boolean");
        funcMap.put("LOCALE", "String");
        funcMap.put("LOCALEPART", "String");
        funcMap.put("SCREENID", "String");
        funcMap.put("SCREENUID", "String");
        funcMap.put("SCREENTYPE", "String");
        funcMap.put("WIZARDPAGE", "int");
        funcMap.put("RESULTSIZE", "int");
        funcMap.put("EVENT", "String");
        funcMap.put("RAND", "double");
        funcMap.put("RANDBETWEEN", "double");
        funcMap.put("RANDSTR", "String");
        funcMap.put("BROWSERTYPE", "String");
        funcMap.put("CHANGELOG", "String");
        funcMap.put("WF_CURRENT_USERID", "String");
        funcMap.put("WF_CURRENT_GROUPID", "int");
        funcMap.put("WF_NEXT_USERID", "String");
        funcMap.put("WF_NEXT_GROUPID", "Integer[]");
        funcMap.put("WF_USERID", "String");
        funcMap.put("WF_GROUPID", "String");
        funcMap.put("WF_IS_ADMITUSER", "boolean");
        funcMap.put("WF_LASTPROCESSDATE", "java.sql.Timestamp");
        funcMap.put("WF_LASTEVENT", "String");
        funcMap.put("WF_EVENT", "String");
        funcMap.put("WF_NEXT_USERID_MAIL", "String");
        funcMap.put("WF_NEXT_GROUPID_MAIL", "String");
        funcMap.put("WF_NEXT_MAIL", "String");
        funcMap.put("WF_APPLICANT", "String");
        funcMap.put("WF_APPLICANT_MAIL", "String");
        funcMap.put("WF_LASTPROCESS_USERID", "String");
        funcMap.put("WF_LASTPROCESS_USERNAME", "String");
        funcMap.put("WORKDAY", "java.sql.Date");
        funcMap.put("NETWORKDAYS", "int");
        funcMap.put("REQUEST", "String");
        funcMap.put("ARRAY_INT", "int[]");
        funcMap.put("ARRAY_LONG", "long[]");
        funcMap.put("ARRAY_FLOAT", "float[]");
        funcMap.put("ARRAY_DOUBLE", "double[]");
        funcMap.put("JGROUPID", "int[]");
        funcMap.put("ISREST", "boolean");
        funcMap.put("MESSAGE", "String");
        funcMap.put("ERRORMESSAGE", "String");
        funcMap.put("HTTPSEND", "String");
        funcMap.put("BARCODE", "String");
        funcMap.put("CLIENTHOSTNAME", "String");
        funcMap.put("CLIENTHOST", "String");
        funcMap.put("SERVERHOSTNAME", "String");
        funcMap.put("GETENV", "String");
        funcMap.put("WEBAPI", "String");
    }

    class Block {
        int id;
        String type;
        StringBuilder sb;
        int parenthesis;

        public Block(int id) {
            this.id = id;
            this.sb = new StringBuilder();
        }

        public String toString() {
            return this.sb != null ? this.sb.toString() : "";
        }
    }

    class VariableStatus {
        String type;
        boolean isMust;
        boolean isContainer;

        VariableStatus(String type, boolean isMust, boolean isContainer) {
            this.type = type;
            this.isMust = isMust;
            this.isContainer = isContainer;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("<VariableStatus>");
            if (this.type != null) {
                sb.append("<type>" + this.type + "</type>");
            }
            sb.append("<isMust>" + this.isMust + "</isMust>");
            sb.append("<isContainer>" + this.isContainer + "</isContainer>");
            sb.append("</VariableStatus>");
            return sb.toString();
        }
    }

    class CalcProcess_Sum
    extends CalcProcess_Func {
        CalcProcess_Sum(String id, String s, String tname, String condition, StringBuilder formula, List<String> preformula, Modelitem sitem, Model model, Set<String> declareVarSet, Map<String, VariableStatus> varMap) {
            super(id, s, tname, condition, formula, preformula, sitem, model, declareVarSet, varMap);
        }

        @Override
        public String getType() {
            return "sum";
        }

        @Override
        public String getProperType(String type) {
            String ret = null;
            ret = JavaSourceGenerator.isBasicType(type) ? ("byte".equals(type) || "short".equals(type) ? "int" : type) : JavaSourceGenerator.getProperType(type);
            return ret;
        }

        @Override
        public void multiple() {
            Modelitem multiple_item = AppSchemaUtil.getModelitem(this.org_tname, this.model);
            String multiple_type = AppSchemaUtil.getModelitemType(HelperGenerator_calc_operation.this.project, this.model.getId(), multiple_item);
            if (multiple_type == null) {
                multiple_type = this.sitemtype;
            }
            String vname = this.createVariableNameForResult(this.org_tname);
            StringBuilder _sb = null;
            this.addDeclareArrayVariableFromStoreModel(vname, this.targetitemtype, this.id, this.org_tname, multiple_item);
            this.addMultipleTmpvarDefinition(vname, multiple_type);
            _sb = new StringBuilder();
            _sb.append("if (");
            _sb.append(vname + "_ary");
            _sb.append(" != null) {");
            this.preformula.add(_sb.toString());
            this.addMultipleReadyCode();
            _sb = new StringBuilder();
            _sb.append("    ");
            _sb.append("for (int j=0; j<");
            _sb.append(vname + "_ary.length");
            _sb.append("; j++) {");
            this.preformula.add(_sb.toString());
            Object mtab = "    ";
            if (StringUtils.isNotBlank((CharSequence)this.condition)) {
                Object[] _expressions = null;
                try {
                    _expressions = this.parsePlaceHolderInOperator(this.condition, multiple_item.getName(), vname + "_ary[j]", this.model);
                }
                catch (Exception e) {
                    Object[] o = new Object[]{this.model.getId(), HelperGenerator_calc_operation.this.pname, this.getType(), this.condition, e.getMessage()};
                    logger.error(HelperGenerator_calc_operation.this.rman.getValue("expr.invalid.autocalc.condition", o));
                    return;
                }
                if (ArrayUtils.isNotEmpty((Object[])_expressions) && StringUtils.isNotBlank((CharSequence)((ExpandExpression)_expressions[0]).content)) {
                    this.addCondition((ExpandExpression[])_expressions, this.model, HelperGenerator_calc_operation.this.pname, "_ary[j]", vname + "_ary[j]", (String)mtab);
                    mtab = (String)mtab + "    ";
                }
            }
            this.addMultipleOperationCode(vname + "_ary", vname, multiple_type, (String)mtab + "    ");
            if (StringUtils.isNotBlank((CharSequence)this.condition)) {
                this.preformula.add((String)mtab + "}");
            }
            _sb = new StringBuilder();
            _sb.append("    ");
            _sb.append("}");
            this.preformula.add(_sb.toString());
            this.addMultipleFinishCode(vname + "_ary", vname, multiple_type);
            _sb = new StringBuilder();
            _sb.append("}");
            this.preformula.add(_sb.toString());
            this.formula.append(vname);
        }

        @Override
        public void addMultipleTmpvarDefinition(String vname, String multiple_type) {
            StringBuilder _sb = new StringBuilder();
            _sb.append("BigDecimal");
            _sb.append(" ");
            _sb.append(vname);
            _sb.append(" = ");
            _sb.append("BigDecimal.ZERO");
            _sb.append(";");
            this.preformula.add(_sb.toString());
        }

        @Override
        public void addMultipleOperationCode(String name, String vname, String multiple_type, String tab) {
            StringBuilder _sb = new StringBuilder();
            _sb.append(tab);
            _sb.append(vname);
            _sb.append(".add(new BigDecimal(String.valueOf(");
            _sb.append(name + "[j]");
            _sb.append(")));");
            this.preformula.add(_sb.toString());
        }

        @Override
        public void container(String pname, String cname) {
            Modelitem container_item = AppSchemaUtil.getModelitem(pname + "/" + cname, this.model);
            String container_type = AppSchemaUtil.getModelitemType(HelperGenerator_calc_operation.this.project, this.model.getId(), container_item, this.rtype);
            if (container_type == null) {
                container_type = this.sitemtype;
            }
            Modelitem p_mitem = AppSchemaUtil.getModelitem(pname, this.model);
            String p_classname = AppSchemaUtil.getModelitemClassname(p_mitem);
            String vname = this.createVariableNameForResult(pname);
            StringBuilder _sb = null;
            this.addDeclareArrayVariableFromStoreModel(vname, p_classname, this.id, pname, container_item);
            this.addContainerTmpvarDefinition(vname, container_type);
            _sb = new StringBuilder();
            _sb.append("if (");
            _sb.append(vname + "_ary");
            _sb.append(" != null) {");
            this.preformula.add(_sb.toString());
            this.addContainerReadyCode();
            _sb = new StringBuilder();
            _sb.append("    ");
            _sb.append("for (int j=0; j<");
            _sb.append(vname + "_ary.length");
            _sb.append("; j++) {");
            this.preformula.add(_sb.toString());
            this.op_code0(pname, cname, vname, container_type, "_ary[j]", this.model);
            _sb = new StringBuilder();
            _sb.append("    ");
            _sb.append("}");
            this.preformula.add(_sb.toString());
            this.addContainerFinishCode(vname + "_ary", vname, container_type);
            _sb = new StringBuilder();
            _sb.append("}");
            this.preformula.add(_sb.toString());
            this.formula.append(vname);
        }

        protected void op_code0(String pname, String cname, String vname, String target_type, String pname_postfix, Model model) {
            Modelitem target_item = null;
            String target_name = null;
            boolean isForeignKeyMode = false;
            if (pname_postfix.length() > 0) {
                target_item = AppSchemaUtil.getModelitem(pname + "/" + cname, model);
                target_name = vname + pname_postfix;
            } else {
                target_item = AppSchemaUtil.getModelitem(cname, model);
                target_name = pname + pname_postfix;
                isForeignKeyMode = true;
            }
            String tab = HelperGenerator_calc_operation.getProperTab(this.preformula);
            StringBuilder _sb = new StringBuilder();
            _sb.append(tab);
            String mtab = "    ";
            if (this.needsCheckMethod() && !this.needsPresentationModel && !HelperGenerator_calc_operation.this.isMust && JavaSourceGenerator.isBasicType(target_item.getType())) {
                _sb = new StringBuilder();
                _sb.append("        ");
                _sb.append("if (");
                _sb.append(target_name);
                _sb.append(JavaSourceGenerator.checkFullMethod(cname));
                _sb.append(") {");
                this.preformula.add(_sb.toString());
                mtab = "        ";
            }
            Object[] _expressions = null;
            if (StringUtils.isNotBlank((CharSequence)this.condition)) {
                try {
                    String _pname = pname;
                    if (isForeignKeyMode && pname.endsWith("_p")) {
                        _pname = pname.substring(0, pname.length() - 2);
                    }
                    _expressions = this.parsePlaceHolderInOperator(this.condition, _pname, target_name, model);
                }
                catch (Exception e) {
                    Object[] o = new Object[]{model.getId(), pname, this.getType(), this.condition, e.getMessage()};
                    logger.error(HelperGenerator_calc_operation.this.rman.getValue("expr.invalid.autocalc.condition", o));
                    return;
                }
                if (ArrayUtils.isNotEmpty((Object[])_expressions) && StringUtils.isNotBlank((CharSequence)((ExpandExpression)_expressions[0]).content)) {
                    this.addCondition((ExpandExpression[])_expressions, model, pname, pname_postfix, target_name, mtab);
                }
            }
            this.addContainerOperationCode(target_name, cname, vname, target_type, pname_postfix, model);
            if (StringUtils.isNotBlank((CharSequence)this.condition)) {
                this.preformula.add(mtab + "    }");
            }
            if (this.needsCheckMethod() && !this.needsPresentationModel && !HelperGenerator_calc_operation.this.isMust && JavaSourceGenerator.isBasicType(target_item.getType())) {
                _sb = new StringBuilder();
                _sb.append("        ");
                _sb.append("}");
                this.preformula.add(_sb.toString());
            }
        }

        public boolean needsCheckMethod() {
            return true;
        }

        @Override
        public void addContainerTmpvarDefinition(String vname, String container_type) {
            StringBuilder _sb = new StringBuilder();
            _sb.append("BigDecimal");
            _sb.append(" ");
            _sb.append(vname);
            _sb.append(" = ");
            _sb.append("BigDecimal.ZERO");
            _sb.append(";");
            this.preformula.add(_sb.toString());
        }

        @Override
        public void addContainerOperationCode(String pname, String cname, String vname, String container_type) {
            this.addContainerOperationCode(pname, cname, vname, container_type, "", this.model);
        }

        public void addContainerOperationCode(String pname, String cname, String vname, String container_type, String pname_postfix, Model model) {
            boolean useTargetObject;
            String tab = HelperGenerator_calc_operation.getProperTab(this.preformula);
            StringBuilder _sb = new StringBuilder();
            _sb.append(tab);
            boolean needsValueCheck = this.isNeedsValueCheck(cname, model);
            if (this.needsPresentationModel && (!this.mode_ref || this.mode_ref_multiple)) {
                _sb.append("if (");
                _sb.append(pname);
                _sb.append(JavaSourceGenerator.getterFullMethod(cname));
                _sb.append(".length > 0) {");
                this.preformula.add(_sb.toString());
                _sb = new StringBuilder();
                _sb.append(tab + "    ");
            }
            boolean bl = useTargetObject = this.needsPresentationModel && (!this.mode_ref || this.mode_ref_multiple);
            if (useTargetObject) {
                String _packagename = AppSchemaUtil.getPackagename(this.pmodel, HelperGenerator_calc_operation.this.project);
                Modelitem _targetitem = AppSchemaUtil.getModelitem(cname, model);
                _sb.append("for (");
                _sb.append(_packagename);
                _sb.append(AppSchemaUtil.getModelitemClassname(_targetitem));
                _sb.append(" __target : ");
                _sb.append(pname + JavaSourceGenerator.getterFullMethod(cname));
                _sb.append(") {");
                this.preformula.add(_sb.toString());
                _sb = new StringBuilder();
                _sb.append(tab + "        ");
                _sb.append("if (__target.getChoose()) {");
                this.preformula.add(_sb.toString());
                _sb = new StringBuilder();
                _sb.append(tab + "            ");
            }
            String addProcessedOperationCondition = null;
            _sb.append(vname).append(" = ").append(vname);
            _sb.append(".add(");
            boolean isAddConvertFunction = false;
            if (this.needsPresentationModel && this.mode_ref) {
                isAddConvertFunction = this.addConvertFunction4Ref(this.refitemtype, useTargetObject, container_type, _sb, true);
            }
            if (useTargetObject) {
                if ("masterref".equals(this.targetitemtype)) {
                    _sb.append(this.processMasterref(this.targetitem, "__target"));
                } else if ("storeref".equals(this.targetitemtype)) {
                    _sb.append(this.processStoreref(this.targetitem, "__target", true));
                } else if (this.mode_id) {
                    _sb.append("__target.getId();");
                } else {
                    _sb.append("__target.getContent();");
                }
                if (isAddConvertFunction) {
                    _sb.append(")");
                }
            } else {
                if (needsValueCheck && cname != null) {
                    _sb.append("((");
                    _sb.append(pname);
                    _sb.append(JavaSourceGenerator.checkFullMethod(cname));
                    _sb.append(") ? ");
                    addProcessedOperationCondition = pname + JavaSourceGenerator.checkFullMethod(cname);
                }
                if (this.needsPresentationModel && !this.mode_id) {
                    _sb.append("new BigDecimal(JFCUtils.getNumberAsString(p, ");
                } else {
                    _sb.append("new BigDecimal(String.valueOf(");
                }
                _sb.append(pname);
                _sb.append(JavaSourceGenerator.getterFullMethod(cname));
                if (this.needsPresentationModel) {
                    if (this.mode_id) {
                        String _getter = this.getter4presentationWithCompositeKey == null ? ".getId()" : this.getter4presentationWithCompositeKey[this.mode_id_suffix_no - 1];
                        _sb.append(_getter);
                        addProcessedOperationCondition = pname + JavaSourceGenerator.getterFullMethod(cname) + _getter + " != null";
                    } else if (this.mode_content) {
                        _sb.append(".getContent()");
                        addProcessedOperationCondition = pname + JavaSourceGenerator.getterFullMethod(cname) + ".getContent() != null";
                    } else {
                        _sb.append(".getContent()");
                        addProcessedOperationCondition = pname + JavaSourceGenerator.getterFullMethod(cname) + ".getContent() != null";
                    }
                    if (isAddConvertFunction) {
                        _sb.append(")");
                    }
                }
                _sb.append("))");
                if (needsValueCheck && cname != null) {
                    _sb.append(" : BigDecimal.ZERO)");
                }
            }
            _sb.append(")").append(";");
            this.preformula.add(_sb.toString());
            this.addProcessedOperationCode(addProcessedOperationCondition);
            if (useTargetObject) {
                _sb = new StringBuilder();
                _sb.append(tab + "            ");
                _sb.append("break;");
                this.preformula.add(_sb.toString());
                _sb = new StringBuilder();
                _sb.append(tab + "        ");
                _sb.append("}");
                this.preformula.add(_sb.toString());
                _sb = new StringBuilder();
                _sb.append(tab + "    ");
                _sb.append("}");
                this.preformula.add(_sb.toString());
            }
            if (this.needsPresentationModel && (!this.mode_ref || this.mode_ref_multiple)) {
                _sb = new StringBuilder();
                _sb.append(tab);
                _sb.append("}");
                this.preformula.add(_sb.toString());
            }
        }

        @Override
        public void foreignmodel(Model _rmodel) {
            if (!this.isForeignModel) {
                return;
            }
            if (!this.isValidForeignmodel(_rmodel)) {
                this.status = 3;
                return;
            }
            Model _smodel = AppSchemaUtil.getStoreModel(_rmodel);
            String _smodel_id = _smodel.getId();
            String _s_packagename = AppSchemaUtil.getPackagename(_smodel, HelperGenerator_calc_operation.this.project);
            String _s_classname = AppSchemaUtil.getClassname(_smodel);
            String _s_varname = _smodel_id + "_ary";
            String _refmodel_itemname = HelperGenerator_calc_operation.getModelItemNamePart(this.org_tname);
            String _refmodel_id = _rmodel.getId();
            String vname = "__" + _refmodel_itemname + "_" + this.getType();
            Modelitem _refmodel_item = AppSchemaUtil.getModelitem(_refmodel_itemname, _smodel);
            String _refmodel_item_rawtype = _refmodel_item.getType();
            String _refmodel_item_type = null;
            _refmodel_item_type = "masterref".equals(_refmodel_item_rawtype) ? (this.mode_id || !this.mode_id && !this.mode_content ? "int" : "String") : (this.mode_content ? AppSchemaUtil.getModelitemType(HelperGenerator_calc_operation.this.project, _refmodel_id, _refmodel_item, "rolecontent", true) : AppSchemaUtil.getModelitemType(HelperGenerator_calc_operation.this.project, _refmodel_id, _refmodel_item, "roleid"));
            _refmodel_item_type = this.getProperType(_refmodel_item_type);
            this.addForeignModelGetObject(_smodel, _rmodel);
            this.addForeignModelTmpvarDefinition(vname, _refmodel_item_type);
            StringBuilder _sb = new StringBuilder();
            _sb.append("if (");
            if (!HelperGenerator_calc_operation.this.isMust && !HelperGenerator_calc_operation.this.outputSetProcessedFlag2True) {
                _sb.append("!_processed && ");
            }
            _sb.append(_s_varname);
            _sb.append(" != null) {");
            this.preformula.add(_sb.toString());
            this.addForeignModelReadyCode();
            _sb = new StringBuilder();
            _sb.append("    ");
            _sb.append("for (").append(_s_packagename).append(_s_classname).append(" ");
            _sb.append(_smodel_id).append(" : ").append(_s_varname).append(") {");
            this.preformula.add(_sb.toString());
            this.addForeignModelReadyPresentation4Child(_rmodel);
            Object target_id = this.needsPresentationModel ? _smodel_id + "_p" : _smodel_id;
            this.op_code0((String)target_id, _refmodel_itemname, vname, _refmodel_item_type, "", AppSchemaUtil.getStoreModel(_rmodel));
            _sb = new StringBuilder();
            _sb.append("    ");
            _sb.append("}");
            this.preformula.add(_sb.toString());
            if (this.isAddForeignModelFinishCode(true)) {
                this.addForeignModelFinishCode(_refmodel_id, vname);
            } else {
                this.setProcessedFlag(true);
            }
            _sb = new StringBuilder();
            _sb.append("}");
            this.preformula.add(_sb.toString());
            this.formula.append(vname);
        }

        @Override
        public void addForeignModelTmpvarDefinition(String vname, String _refmodel_item_type) {
            StringBuilder _sb = new StringBuilder();
            _sb.append("BigDecimal");
            _sb.append(" ");
            _sb.append(vname);
            _sb.append(" = ");
            _sb.append("BigDecimal.ZERO");
            _sb.append(";");
            this.preformula.add(_sb.toString());
        }

        public void addProcessedOperationCode() {
        }

        public void addProcessedOperationCode(String condition) {
        }
    }

    class CalcProcess_Count
    extends CalcProcess_Func {
        CalcProcess_Count(String id, String s, String tname, String condition, StringBuilder formula, List<String> preformula, Modelitem sitem, Model model, Set<String> declareVarSet, Map<String, VariableStatus> varMap) {
            super(id, s, tname, condition, formula, preformula, sitem, model, declareVarSet, varMap);
        }

        @Override
        public String getType() {
            return "count";
        }

        @Override
        boolean needsitemtypeCheck() {
            return false;
        }

        @Override
        public void multiple() {
            Modelitem multiple_item = AppSchemaUtil.getModelitem(this.org_tname, this.model);
            String multiple_type = AppSchemaUtil.getModelitemType(HelperGenerator_calc_operation.this.project, this.model.getId(), multiple_item);
            if (multiple_type == null) {
                multiple_type = this.sitemtype;
            }
            String vname = this.createVariableNameForResult(this.org_tname);
            StringBuilder _sb = null;
            boolean isRef = false;
            if (("masterref".equals(this.targetitemtype) || "storeref".equals(this.targetitemtype)) && multiple_item != null) {
                isRef = true;
            }
            String _tname0 = null;
            String _tname1 = null;
            String classname = AppSchemaUtil.getModelitemClassname(multiple_item);
            if (isRef) {
                String _name = multiple_item.getName();
                Relation _relation = AppSchemaUtil.getRelationTypeExceptRef(multiple_item);
                if (!"ref".equals(_relation.getType())) {
                    boolean _isContainer = AppSchemaUtil.hasChildPart(_name);
                    _tname0 = _isContainer ? AppSchemaUtil.getChildPart(_name) : _name;
                    _tname1 = _isContainer ? AppSchemaUtil.getParentPart(_name) : this.model.getId();
                    this.process0_ref_ready(_tname0, (String)(_isContainer ? "__" + _tname1 : _tname1));
                }
            } else {
                this.addDeclareArrayVariableFromStoreModel(vname, this.targetitemtype, this.id, this.org_tname, multiple_item);
            }
            _sb = new StringBuilder();
            _sb.append("int");
            _sb.append(" ");
            _sb.append(vname);
            _sb.append(" = ");
            _sb.append("0");
            _sb.append(";");
            this.preformula.add(_sb.toString());
            _sb = new StringBuilder();
            _sb.append("if (");
            if (isRef) {
                _sb.append("__" + _tname0);
            } else {
                _sb.append(vname + "_ary");
            }
            _sb.append(" != null) {");
            this.preformula.add(_sb.toString());
            if (StringUtils.isNotBlank((CharSequence)this.condition) && this.isConditionAvailable()) {
                Object[] _expressions = null;
                try {
                    _expressions = this.parsePlaceHolderInOperator(this.condition, multiple_item.getName(), "_item", this.model);
                    if (ArrayUtils.isEmpty((Object[])_expressions) || StringUtils.isBlank((CharSequence)((ExpandExpression)_expressions[0]).content)) {
                        Object[] o = new Object[]{this.model.getId(), multiple_item.getName(), this.getType(), this.condition};
                        logger.warn(HelperGenerator_calc_operation.this.rman.getValue("expr.skip.autocalc.condition", o));
                    }
                }
                catch (Exception e) {
                    Object[] o = new Object[]{this.model.getId(), multiple_item.getName(), this.getType(), this.condition, e.getMessage()};
                    logger.error(HelperGenerator_calc_operation.this.rman.getValue("expr.invalid.autocalc.condition", o));
                    return;
                }
                if (ArrayUtils.isNotEmpty((Object[])_expressions) && StringUtils.isNotBlank((CharSequence)((ExpandExpression)_expressions[0]).content)) {
                    if (isRef) {
                        Model pmodel = AppSchemaUtil.getModel(HelperGenerator_calc_operation.this.project, this.model.getId(), "presentation");
                        String ppackagename = AppSchemaUtil.getPackagename(pmodel, HelperGenerator_calc_operation.this.project);
                        this.preformula.add("    for (" + ppackagename + classname + " _item : __" + _tname0 + ") {");
                    } else {
                        this.preformula.add("    for (" + this.targetitemtype + " _item : " + vname + "_ary) {");
                    }
                    this.addCondition((ExpandExpression[])_expressions, this.model, HelperGenerator_calc_operation.this.pname, "", "_item", "    ");
                    _sb = new StringBuilder();
                    _sb.append("            ");
                    _sb.append(vname + "++;");
                    this.preformula.add(_sb.toString());
                    this.preformula.add("        }");
                    this.preformula.add("    }");
                }
            } else {
                _sb = new StringBuilder();
                _sb.append("    ");
                _sb.append(vname);
                _sb.append(" = ");
                if (isRef) {
                    _sb.append("(__" + _tname0 + " != null) ? ");
                    _sb.append("__" + _tname0 + ".length : 0");
                } else {
                    _sb.append("(" + vname + "_ary != null) ? ");
                    _sb.append(vname + "_ary.length : 0");
                }
                _sb.append(";");
                this.preformula.add(_sb.toString());
            }
            this.preformula.add("}");
            this.setProcessedFlag(true);
            this.addMultipleFinishCode(vname + "_ary", vname, multiple_type);
            this.formula.append(vname);
        }

        @Override
        public void container(String pname, String cname) {
            Modelitem container_item = AppSchemaUtil.getModelitem(pname + "/" + cname, this.model);
            String container_type = AppSchemaUtil.getModelitemType(HelperGenerator_calc_operation.this.project, this.model.getId(), container_item, this.rtype);
            if (container_type == null) {
                container_type = this.sitemtype;
            }
            Modelitem p_mitem = AppSchemaUtil.getModelitem(pname, this.model);
            String p_classname = AppSchemaUtil.getModelitemClassname(p_mitem);
            String vname = this.createVariableNameForResult(pname);
            if (!this.isCheckbox) {
                this.container_normal(pname, cname, container_item, container_type, p_mitem, p_classname, vname);
            } else {
                this.container_checkbox(pname, cname, container_item, container_type, p_mitem, p_classname, vname);
            }
        }

        private void container_normal(String pname, String cname, Modelitem container_item, String container_type, Modelitem p_mitem, String p_classname, String vname) {
            this.addDeclareArrayVariableFromStoreModel(vname, p_classname, this.id, pname, container_item);
            StringBuilder _sb = new StringBuilder();
            _sb.append("int");
            _sb.append(" ");
            _sb.append(vname);
            _sb.append(" = ");
            _sb.append("0");
            _sb.append(";");
            this.preformula.add(_sb.toString());
            _sb = new StringBuilder();
            _sb.append("if (");
            _sb.append(vname + "_ary");
            _sb.append(" != null) {");
            this.preformula.add(_sb.toString());
            String mtab = "";
            if (StringUtils.isNotBlank((CharSequence)this.condition) && this.isConditionAvailable()) {
                Object[] _expressions = null;
                try {
                    _expressions = this.parsePlaceHolderInOperator(this.condition, pname, vname + "_ary[j]", this.model);
                    if (ArrayUtils.isEmpty((Object[])_expressions) || StringUtils.isBlank((CharSequence)((ExpandExpression)_expressions[0]).content)) {
                        Object[] o = new Object[]{this.model.getId(), pname, this.getType(), this.condition};
                        logger.warn(HelperGenerator_calc_operation.this.rman.getValue("expr.skip.autocalc.condition", o));
                    }
                }
                catch (Exception e) {
                    Object[] o = new Object[]{this.model.getId(), pname, this.getType(), this.condition, e.getMessage()};
                    logger.error(HelperGenerator_calc_operation.this.rman.getValue("expr.invalid.autocalc.condition", o));
                    return;
                }
                if (ArrayUtils.isNotEmpty((Object[])_expressions) && StringUtils.isNotBlank((CharSequence)((ExpandExpression)_expressions[0]).content)) {
                    _sb = new StringBuilder();
                    _sb.append("    ");
                    _sb.append("for (int j=0; j<");
                    _sb.append(vname + "_ary");
                    _sb.append(".length; j++) {");
                    this.preformula.add(_sb.toString());
                    this.addCondition((ExpandExpression[])_expressions, this.model, pname, "", vname + "_ary[j]", "    ");
                    _sb = new StringBuilder();
                    _sb.append("            " + mtab);
                    _sb.append(vname + "++;");
                    this.preformula.add(_sb.toString());
                    this.preformula.add("        }");
                    this.preformula.add("    }");
                }
            } else {
                _sb = new StringBuilder();
                _sb.append("    ");
                _sb.append(vname);
                _sb.append(" = ");
                _sb.append(vname + "_ary.length");
                _sb.append(";");
                this.preformula.add(_sb.toString());
            }
            this.preformula.add("}");
            this.setProcessedFlag(true);
            this.addContainerFinishCode(pname, vname, container_type);
            this.formula.append(vname);
        }

        private void container_checkbox(String pname, String cname, Modelitem container_item, String container_type, Modelitem p_mitem, String p_classname, String vname) {
            Relation _relation;
            StringBuilder _sb = new StringBuilder();
            _sb.append("int");
            _sb.append(" ");
            _sb.append(vname);
            _sb.append(" = ");
            _sb.append("0");
            _sb.append(";");
            this.preformula.add(_sb.toString());
            String classname = AppSchemaUtil.getModelitemClassname(container_item);
            if (("masterref".equals(this.targetitemtype) || "storeref".equals(this.targetitemtype)) && container_item != null && !"ref".equals((_relation = AppSchemaUtil.getRelationTypeExceptRef(container_item)).getType())) {
                this.process0_ref_ready(cname, "__" + pname);
            }
            _sb = new StringBuilder();
            _sb.append("if (");
            _sb.append("__" + cname);
            _sb.append(" != null) {");
            this.preformula.add(_sb.toString());
            if (StringUtils.isNotBlank((CharSequence)this.condition) && this.isConditionAvailable()) {
                Object[] _expressions = null;
                try {
                    _expressions = this.parsePlaceHolderInOperator(this.condition, pname, "_item", this.model, false, true, false);
                    if (ArrayUtils.isEmpty((Object[])_expressions) || StringUtils.isBlank((CharSequence)((ExpandExpression)_expressions[0]).content)) {
                        Object[] o = new Object[]{this.model.getId(), pname, this.getType(), this.condition};
                        logger.warn(HelperGenerator_calc_operation.this.rman.getValue("expr.skip.autocalc.condition", o));
                    }
                }
                catch (Exception e) {
                    Object[] o = new Object[]{this.model.getId(), pname, this.getType(), this.condition, e.getMessage()};
                    logger.error(HelperGenerator_calc_operation.this.rman.getValue("expr.invalid.autocalc.condition", o));
                    return;
                }
                if (ArrayUtils.isNotEmpty((Object[])_expressions) && StringUtils.isNotBlank((CharSequence)((ExpandExpression)_expressions[0]).content)) {
                    Model pmodel = AppSchemaUtil.getModel(HelperGenerator_calc_operation.this.project, this.model.getId(), "presentation");
                    String ppackagename = AppSchemaUtil.getPackagename(pmodel, HelperGenerator_calc_operation.this.project);
                    this.preformula.add("    for (" + ppackagename + classname + " _item : __" + cname + ") {");
                    this.addCondition((ExpandExpression[])_expressions, this.model, pname, "", "_item", "    ");
                    _sb = new StringBuilder();
                    _sb.append("            ");
                    _sb.append(vname + "++;");
                    this.preformula.add(_sb.toString());
                    this.preformula.add("        }");
                    this.preformula.add("    }");
                }
            } else {
                _sb = new StringBuilder();
                _sb.append("    ");
                _sb.append(vname);
                _sb.append(" = ");
                _sb.append("(");
                _sb.append("__" + cname);
                _sb.append(" != null) ? ");
                _sb.append("__" + cname);
                _sb.append(".length : 0");
                _sb.append(";");
                this.preformula.add(_sb.toString());
            }
            this.preformula.add("}");
            this.setProcessedFlag(true);
            this.addContainerFinishCode(pname, vname, container_type);
            this.formula.append(vname);
        }

        @Override
        public void foreignmodel(Model _rmodel) {
            if (!this.isForeignModel) {
                return;
            }
            Model __smodel = AppSchemaUtil.getStoreModel(_rmodel);
            String __smodel_id = __smodel.getId();
            String vname = this.createVariableNameForResult(__smodel_id);
            String _s_packagename = AppSchemaUtil.getPackagename(__smodel, HelperGenerator_calc_operation.this.project);
            String _s_classname = AppSchemaUtil.getClassname(__smodel);
            String _s_varname = __smodel_id + "_ary";
            Model __rmodel = AppSchemaUtil.getModel(HelperGenerator_calc_operation.this.project, __smodel_id, "presentation");
            String __rmodel_id = __rmodel.getId();
            String _r_packagename = AppSchemaUtil.getPackagename(__rmodel, HelperGenerator_calc_operation.this.project);
            this.addForeignModelGetObject(__smodel, _rmodel);
            StringBuilder _sb = new StringBuilder();
            _sb.append("int ");
            _sb.append(vname);
            _sb.append(" = 0;");
            this.preformula.add(_sb.toString());
            _sb = new StringBuilder();
            _sb.append("if (");
            if (!HelperGenerator_calc_operation.this.isMust_sitem && !HelperGenerator_calc_operation.this.outputSetProcessedFlag2True) {
                _sb.append("!_processed && ");
            }
            _sb.append(_s_varname);
            _sb.append(" != null) {");
            this.preformula.add(_sb.toString());
            this.addForeignModelReadyCode();
            if (StringUtils.isNotBlank((CharSequence)this.condition) && this.isConditionAvailable()) {
                Object[] _expressions = null;
                try {
                    _expressions = this.parsePlaceHolderInOperator(this.condition, __smodel.getId(), HelperGenerator_calc_operation.this.pname, __smodel, false, false, true);
                    if (ArrayUtils.isEmpty((Object[])_expressions) || StringUtils.isBlank((CharSequence)((ExpandExpression)_expressions[0]).content)) {
                        Object[] o = new Object[]{this.model.getId(), HelperGenerator_calc_operation.this.pname, this.getType(), this.condition};
                        logger.warn(HelperGenerator_calc_operation.this.rman.getValue("expr.skip.autocalc.condition", o));
                    }
                }
                catch (Exception e) {
                    Object[] o = new Object[]{this.model.getId(), HelperGenerator_calc_operation.this.pname, this.getType(), this.condition, e.getMessage()};
                    logger.error(HelperGenerator_calc_operation.this.rman.getValue("expr.invalid.autocalc.condition", o));
                    return;
                }
                if (ArrayUtils.isNotEmpty((Object[])_expressions) && StringUtils.isNotBlank((CharSequence)((ExpandExpression)_expressions[0]).content)) {
                    _sb = new StringBuilder();
                    _sb.append("    ");
                    _sb.append("for (").append(_s_packagename).append(_s_classname).append(" ");
                    _sb.append(__smodel_id).append(" : ").append(_s_varname).append(") {");
                    this.preformula.add(_sb.toString());
                    if (((ExpandExpression)_expressions[0]).useIsNullOperator) {
                        this.addForeignModelReadyPresentation4Child(_rmodel, __smodel, __smodel_id, __rmodel_id, true);
                        _sb = new StringBuilder();
                        _sb.append("        ");
                        _sb.append("if (");
                        ArrayList<ClassVarnamePair> _list = new ArrayList<ClassVarnamePair>(((ExpandExpression)_expressions[0]).master);
                        for (int k = 0; k < _list.size(); ++k) {
                            ClassVarnamePair cv = (ClassVarnamePair)_list.get(k);
                            _sb.append("(");
                            _sb.append(__rmodel_id);
                            _sb.append(JavaSourceGenerator.getterFullMethod(cv.varname));
                            _sb.append(" == null || ");
                            _sb.append(__rmodel_id);
                            _sb.append(JavaSourceGenerator.getterFullMethod(cv.varname));
                            _sb.append(".length == 0");
                            _sb.append(")");
                            if (k <= 0) continue;
                            _sb.append(" && ");
                        }
                        _sb.append(") {");
                        this.preformula.add(_sb.toString());
                        _sb = new StringBuilder();
                        _sb.append("            ");
                        _sb.append(vname + "++;");
                        this.preformula.add(_sb.toString());
                        _sb = new StringBuilder();
                        _sb.append("        ");
                        _sb.append("}");
                        this.preformula.add(_sb.toString());
                    } else {
                        Object ntab = "";
                        if (!((ExpandExpression)_expressions[0]).isContentOnly()) {
                            this.addForeignModelReadyPresentation4Child(_rmodel, __smodel, __smodel_id, __rmodel_id, true);
                            if (((ExpandExpression)_expressions[0]).master.size() > 0) {
                                for (ClassVarnamePair cv : ((ExpandExpression)_expressions[0]).master) {
                                    _sb = new StringBuilder();
                                    _sb.append("        " + (String)ntab);
                                    _sb.append("for (");
                                    _sb.append(_r_packagename);
                                    if (cv.classname != null) {
                                        _sb.append(cv.classname);
                                        _sb.append(" ");
                                        _sb.append(cv.varname);
                                    } else {
                                        _sb.append(((ExpandExpression)_expressions[0]).multiple.classname);
                                        _sb.append(" ");
                                        _sb.append(((ExpandExpression)_expressions[0]).multiple.varname);
                                    }
                                    _sb.append(" : ").append(__rmodel_id);
                                    _sb.append(JavaSourceGenerator.getterFullMethod(cv.varname));
                                    _sb.append(") {");
                                    this.preformula.add(_sb.toString());
                                    if (cv.classname != null) {
                                        _sb = new StringBuilder();
                                        _sb.append("            " + (String)ntab);
                                        _sb.append("if (!");
                                        _sb.append(cv.varname);
                                        _sb.append(".getChoose()) {");
                                        this.preformula.add(_sb.toString());
                                        this.preformula.add("                continue;");
                                        this.preformula.add("            }");
                                    }
                                    ntab = (String)ntab + "    ";
                                }
                            }
                        }
                        _sb = new StringBuilder();
                        _sb.append("        " + (String)ntab);
                        _sb.append("if (");
                        _sb.append(_expressions[0]);
                        _sb.append(") {");
                        this.preformula.add(_sb.toString());
                        _sb = new StringBuilder();
                        _sb.append("            " + (String)ntab);
                        _sb.append(vname + "++;");
                        this.preformula.add(_sb.toString());
                        this.preformula.add("        " + (String)ntab + "}");
                        if (!((ExpandExpression)_expressions[0]).isContentOnly()) {
                            for (int k = ((ExpandExpression)_expressions[0]).master.size(); k > 0; --k) {
                                _sb = new StringBuilder();
                                _sb.append("        ");
                                for (int loop = 1; loop < k; ++loop) {
                                    _sb.append("    ");
                                }
                                _sb.append("}");
                                this.preformula.add(_sb.toString());
                            }
                        }
                    }
                    this.preformula.add("    }");
                }
            } else {
                _sb = new StringBuilder();
                _sb.append("    ");
                _sb.append(vname);
                _sb.append(" = ");
                _sb.append(_s_varname + ".length");
                _sb.append(";");
                this.preformula.add(_sb.toString());
            }
            this.setProcessedFlag(true);
            _sb = new StringBuilder();
            _sb.append("}");
            this.preformula.add(_sb.toString());
            this.formula.append(vname);
        }

        @Override
        public void checkbox() {
            this.multiple();
        }
    }

    class CalcProcess_Avg
    extends CalcProcess_Sum {
        CalcProcess_Avg(String id, String s, String tname, String condition, StringBuilder formula, List<String> preformula, Modelitem sitem, Model model, Set<String> declareVarSet, Map<String, VariableStatus> varMap) {
            super(id, s, tname, condition, formula, preformula, sitem, model, declareVarSet, varMap);
            String tab = HelperGenerator_calc_operation.getProperTab(preformula);
            StringBuilder _sb = new StringBuilder();
            _sb.append(tab);
            _sb.append("long __count = 0;");
            preformula.add(_sb.toString());
        }

        @Override
        public String getType() {
            return "avg";
        }

        @Override
        public String getProperType(String type) {
            return "double";
        }

        @Override
        public String getValidValue(String type) {
            return "0.0";
        }

        @Override
        public void addProcessedOperationCode() {
            this.addProcessedOperationCode(null);
        }

        @Override
        public void addProcessedOperationCode(String condition) {
            String tab = HelperGenerator_calc_operation.getProperTab(this.preformula);
            tab = tab.substring(0, tab.length() - "    ".length());
            StringBuilder _sb = new StringBuilder();
            _sb.append(tab);
            if (condition != null) {
                _sb.append("if (");
                _sb.append(condition);
                _sb.append(") ");
            }
            _sb.append("__count++;");
            this.preformula.add(_sb.toString());
        }

        @Override
        public void addMultipleOperationCode(String name, String vname, String multiple_type, String tab) {
            super.addMultipleOperationCode(name, vname, multiple_type, tab);
            StringBuilder _sb = new StringBuilder();
            _sb.append(tab);
            _sb.append("__count++;");
            this.preformula.add(_sb.toString());
        }

        @Override
        public void addMultipleFinishCode(String tname, String vname, String multiple_type) {
            this.addMultipleFinishCode(tname, vname, multiple_type, false);
        }

        private void addMultipleFinishCode(String tname, String vname, String multiple_type, boolean forceOverrideFlag) {
            StringBuilder _sb = new StringBuilder();
            _sb.append("    ");
            _sb.append("if (__count > 0) {");
            this.preformula.add(_sb.toString());
            _sb = new StringBuilder();
            _sb.append("        ");
            _sb.append("try {");
            this.preformula.add(_sb.toString());
            _sb = new StringBuilder();
            _sb.append("            ");
            _sb.append(vname);
            _sb.append(" = ");
            _sb.append(vname);
            _sb.append(".divide(");
            _sb.append("new BigDecimal(__count))");
            _sb.append(";");
            this.preformula.add(_sb.toString());
            _sb = new StringBuilder();
            _sb.append("        ");
            _sb.append("} catch (ArithmeticException ae) {");
            this.preformula.add(_sb.toString());
            _sb = new StringBuilder();
            _sb.append("            ");
            _sb.append(vname);
            _sb.append(" = ");
            _sb.append(vname);
            _sb.append(".divide(");
            _sb.append("new BigDecimal(__count)");
            _sb.append(", 16, RoundingMode.HALF_UP)");
            _sb.append(";");
            this.preformula.add(_sb.toString());
            _sb = new StringBuilder();
            _sb.append("        ");
            _sb.append("}");
            this.preformula.add(_sb.toString());
            this.setProcessedFlag(forceOverrideFlag);
            _sb = new StringBuilder();
            _sb.append("    ");
            _sb.append("}");
            this.preformula.add(_sb.toString());
        }

        @Override
        public void addContainerFinishCode(String pname, String vname, String container_type) {
            this.addMultipleFinishCode(pname, vname, container_type);
        }

        @Override
        public void addForeignModelFinishCode(String pname, String vname) {
            this.addMultipleFinishCode(pname, vname, null, true);
        }

        @Override
        public boolean isAddForeignModelFinishCode(boolean isUlpModel) {
            return true;
        }
    }

    class CalcProcess_Max
    extends CalcProcess_MaxMin {
        CalcProcess_Max(String id, String s, String tname, String condition, StringBuilder formula, List<String> preformula, Modelitem sitem, Model model, Set<String> declareVarSet, Map<String, VariableStatus> varMap) {
            super(id, s, tname, condition, formula, preformula, sitem, model, declareVarSet, varMap);
        }

        @Override
        public String getType() {
            return "max";
        }
    }

    class CalcProcess_Min
    extends CalcProcess_MaxMin {
        CalcProcess_Min(String id, String s, String tname, String condition, StringBuilder formula, List<String> preformula, Modelitem sitem, Model model, Set<String> declareVarSet, Map<String, VariableStatus> varMap) {
            super(id, s, tname, condition, formula, preformula, sitem, model, declareVarSet, varMap);
        }

        @Override
        public String getType() {
            return "min";
        }
    }

    class CalcProcess_First
    extends CalcProcess_FirstLast {
        CalcProcess_First(String id, String s, String tname, String condition, StringBuilder formula, List<String> preformula, Modelitem sitem, Model model, Set<String> declareVarSet, Map<String, VariableStatus> varMap) {
            super(id, s, tname, condition, formula, preformula, sitem, model, declareVarSet, varMap);
        }

        @Override
        public String getType() {
            return "first";
        }

        @Override
        public String getIndexCode(String tname) {
            return StringUtils.isNotBlank((CharSequence)this.condition) ? "_i" : "0";
        }

        @Override
        public String getForeignModelIndexCode(String refmodel_id) {
            return StringUtils.isNotBlank((CharSequence)this.condition) ? "_i" : "0";
        }
    }

    class CalcProcess_Last
    extends CalcProcess_FirstLast {
        CalcProcess_Last(String id, String s, String tname, String condition, StringBuilder formula, List<String> preformula, Modelitem sitem, Model model, Set<String> declareVarSet, Map<String, VariableStatus> varMap) {
            super(id, s, tname, condition, formula, preformula, sitem, model, declareVarSet, varMap);
        }

        @Override
        public String getType() {
            return "last";
        }

        @Override
        public String getIndexCode(String tname) {
            return StringUtils.isNotBlank((CharSequence)this.condition) ? "_i" : tname + ".length-1";
        }

        @Override
        public String getForeignModelIndexCode(String refmodel_id) {
            return StringUtils.isNotBlank((CharSequence)this.condition) ? "_i" : refmodel_id + ".length-1";
        }
    }

    class CalcProcess_Slice
    extends CalcProcess_FirstLast {
        private String _index_expr;
        private String _noExistContent;

        CalcProcess_Slice(String id, String s, String tname, String condition, StringBuilder formula, List<String> preformula, Modelitem sitem, Model model, Set<String> declareVarSet, Map<String, VariableStatus> varMap) {
            super(id, s, tname, null, formula, preformula, sitem, model, declareVarSet, varMap);
            StringTokenizer st = new StringTokenizer(this.org_tname, ",");
            int ptr = 0;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (ptr == 0) {
                    this.org_tname = token;
                    this.init();
                } else if (ptr == 1) {
                    this._index_expr = StringUtil.removePreAndPostWhitespaceWithoutInside((String)token);
                } else if (ptr == 2) {
                    this._noExistContent = StringUtil.removePreAndPostWhitespaceWithoutInside((String)token);
                }
                ++ptr;
            }
            if (StringUtils.isEmpty((CharSequence)this._index_expr)) {
                this._index_expr = "0";
            } else {
                if (declareVarSet.size() == 0) {
                    String slicecnt = this.getSliceContent(HelperGenerator_calc_operation.this.cnt);
                    ptr = 0;
                    st = new StringTokenizer(slicecnt, ",");
                    while (st.hasMoreTokens()) {
                        String token = StringUtil.removePreAndPostWhitespaceWithoutInside((String)st.nextToken());
                        if (ptr == 0) {
                            if (token.indexOf(this.org_tname) < 0) {
                                if (this._index_expr.startsWith("${") || this._index_expr.endsWith("}") || this._index_expr.indexOf("(") >= 0) break;
                                this._index_expr = "${" + this._index_expr + "}";
                                break;
                            }
                        } else if (ptr == 1) {
                            int b_ptr = token.indexOf("${");
                            int e_ptr = token.lastIndexOf("}");
                            if (b_ptr >= 0 && e_ptr > 0 && b_ptr < e_ptr) {
                                this._index_expr = token;
                                break;
                            }
                        }
                        ++ptr;
                    }
                }
                int length = this._index_expr.length();
                boolean varMode = false;
                StringBuilder buf = new StringBuilder();
                StringBuilder varbuf = new StringBuilder();
                for (int i = 0; i < length; ++i) {
                    char c = this._index_expr.charAt(i);
                    if (varMode) {
                        if (c == '}') {
                            String _index_declare_part = null;
                            String _t_itemname = new String(varbuf);
                            String idsuffix = AppSchemaUtil.getIdSuffixPartInExpr(_t_itemname);
                            if (idsuffix != null && _t_itemname.endsWith(idsuffix) || _t_itemname.endsWith("#content") || _t_itemname.endsWith("#array")) {
                                if (idsuffix != null && _t_itemname.endsWith(idsuffix)) {
                                    _t_itemname = _t_itemname.substring(0, _t_itemname.length() - idsuffix.length());
                                } else if (_t_itemname.endsWith("#content")) {
                                    _t_itemname = _t_itemname.substring(0, _t_itemname.length() - "#content".length());
                                } else if (_t_itemname.endsWith("#array")) {
                                    _t_itemname = _t_itemname.substring(0, _t_itemname.length() - "#array".length());
                                }
                            }
                            if (_t_itemname.endsWith("_lp") || _t_itemname.indexOf("_lp.") > 0) {
                                int _ptr = _t_itemname.indexOf("_lp");
                                String _f_modelId = _t_itemname.substring(0, _ptr);
                                Model _dummy = AppSchemaUtil.getModel(HelperGenerator_calc_operation.this.project, _f_modelId);
                                if (_dummy == null) {
                                    Object[] o = new Object[]{id, HelperGenerator_calc_operation.this.name, _f_modelId};
                                    logger.error(HelperGenerator_calc_operation.this.rman.getValue("helper.invalid.autocalc.content.notfound.model", o));
                                }
                                _index_declare_part = "((" + _f_modelId + " != null) ? " + _f_modelId + JavaSourceGenerator.getterFullMethod(_t_itemname.substring(_ptr + 1)) + " : 0)";
                            } else {
                                Modelitem mitem = AppSchemaUtil.getModelitem(_t_itemname, model);
                                if (mitem == null) {
                                    Object[] o = new Object[]{id, HelperGenerator_calc_operation.this.name, this.org_tname};
                                    logger.error(HelperGenerator_calc_operation.this.rman.getValue("helper.invalid.autocalc.content.notfound", o));
                                }
                                if (AppSchemaUtil.hasChildPart(_t_itemname)) {
                                    String _p_name = AppSchemaUtil.getParentPart(_t_itemname);
                                    String _c_name = AppSchemaUtil.getChildPart(_t_itemname);
                                    _index_declare_part = "__" + _p_name + JavaSourceGenerator.getterFullMethod(_c_name);
                                } else {
                                    _index_declare_part = "((" + model.getId() + " != null) ? " + model.getId() + JavaSourceGenerator.getterFullMethod(_t_itemname);
                                }
                                if (idsuffix != null && _t_itemname.endsWith(idsuffix)) {
                                    String _getter = this.getter4presentationWithCompositeKey == null ? ".getId()" : this.getter4presentationWithCompositeKey[this.mode_id_suffix_no - 1];
                                    _index_declare_part = _index_declare_part + _getter;
                                } else if (_t_itemname.endsWith("#content")) {
                                    _index_declare_part = _index_declare_part + ".getContent()";
                                }
                                if (!AppSchemaUtil.hasChildPart(_t_itemname)) {
                                    _index_declare_part = _index_declare_part + " : 0)";
                                }
                            }
                            buf.append(_index_declare_part);
                            varbuf = new StringBuilder();
                            varMode = false;
                            continue;
                        }
                        varbuf.append(c);
                        continue;
                    }
                    if (c == '$' && i + 1 < length) {
                        char c2 = this._index_expr.charAt(i + 1);
                        if (c2 == '{') {
                            ++i;
                            varMode = true;
                            continue;
                        }
                    } else if (c == 'f' && i + 4 < length) {
                        if ("first".equals(this._index_expr.substring(i, i + 5))) {
                            buf.append("0");
                            i += 4;
                            continue;
                        }
                        buf.append(c);
                    } else if (c == 'l' && i + 3 < length) {
                        if ("last".equals(this._index_expr.substring(i, i + 4))) {
                            buf.append("(($LAST$ != null) ? ");
                            buf.append("$LAST$.length-1 : 0)");
                            i += 3;
                            continue;
                        }
                        buf.append(c);
                    }
                    buf.append(c);
                }
                this._index_expr = buf.toString();
            }
        }

        private String getSliceContent(String s) {
            int ptr = s.indexOf("${slice(");
            if (ptr < 0) {
                return s;
            }
            return s.substring(ptr + "${slice(".length());
        }

        @Override
        public String getIndexDeclareCode(String vname) {
            if (this._index_expr != null) {
                return "int __index = " + StringUtil.replaceAll((String)this._index_expr, (String)"$LAST$", (String)vname) + ";";
            }
            return null;
        }

        @Override
        public String getNoExistContent() {
            return this._noExistContent;
        }

        @Override
        public String getLowerLimitOfArrayInMultiple(String name) {
            return "__index";
        }

        @Override
        public String getLowerLimitOfArrayInContainer(String name) {
            return "__index";
        }

        @Override
        public String getLimitValue4FirstOperation() {
            if (this._index_expr != null) {
                return "__index";
            }
            return "0";
        }

        @Override
        public String getLimitValue4LastOperation() {
            return "length";
        }

        @Override
        public String getLowerLimitOfArrayInForeignModel(String name) {
            return "__index";
        }

        @Override
        public String getType() {
            return "slice";
        }

        @Override
        public String getIndexCode(String tname) {
            return "__index";
        }

        @Override
        public String getForeignModelIndexCode(String refmodel_id) {
            return "__index";
        }
    }

    class CalcProcess_Join
    extends CalcProcess_MaxMin {
        private String _sepchar;
        private JoinMode _joinMode;

        CalcProcess_Join(String id, String s, String tname, String condition, StringBuilder formula, List<String> preformula, Modelitem sitem, Model model, Set<String> declareVarSet, Map<String, VariableStatus> varMap, JoinMode joinMode) {
            super(id, s, tname, null, formula, preformula, sitem, model, declareVarSet, varMap);
            int ptr = this.org_tname.indexOf(",");
            if (ptr > 0) {
                this._sepchar = HelperGenerator_calc_operation.toStringPart(this.org_tname.substring(ptr + 1));
                this.org_tname = this.org_tname.substring(0, ptr);
                this.init();
            }
            if (this._sepchar == null) {
                this._sepchar = ",";
            }
            this._joinMode = joinMode;
        }

        @Override
        public String getType() {
            return "join";
        }

        @Override
        public boolean needsCheckMethod() {
            return false;
        }

        @Override
        public boolean isAddForeignModelFinishCode(boolean isUlpModel) {
            return true;
        }

        @Override
        protected void ready_code0() {
            StringBuilder _sb = new StringBuilder();
            _sb.append("    ");
            _sb.append("StringBuilder __sb = new StringBuilder();");
            this.preformula.add(_sb.toString());
            if (this._joinMode != JoinMode.Simple) {
                _sb = new StringBuilder();
                _sb.append("    ");
                _sb.append("Set<String> __processedValueSet = new HashSet<String>();");
                this.preformula.add(_sb.toString());
            }
        }

        @Override
        public void addMultipleTmpvarDefinition(String vname, String multiple_type) {
            StringBuilder _sb = new StringBuilder();
            _sb.append("String ");
            _sb.append(vname);
            _sb.append(" = null;");
            this.preformula.add(_sb.toString());
        }

        @Override
        protected void op_code0(String pname, String cname, String vname, String type) {
            this.op_code0(pname, cname, vname, type, "[j]", this.model);
        }

        @Override
        protected void op_code0(String pname, String cname, String vname, String type, String pname_postfix, Model model) {
            Format[] formats;
            Relation rel;
            Model pmodel = AppSchemaUtil.getModel(HelperGenerator_calc_operation.this.project, model.getId(), "presentation");
            String _packagename = AppSchemaUtil.getPackagename(pmodel, HelperGenerator_calc_operation.this.project);
            String __vname = vname + pname_postfix;
            boolean usePresentationModel = false;
            Object __targetobj = null;
            if (pname_postfix.length() > 0) {
                __targetobj = cname == null ? vname + "_ary" + pname_postfix : __vname;
            } else {
                __targetobj = pname;
                if (((String)__targetobj).equals(pmodel.getId())) {
                    usePresentationModel = true;
                }
            }
            Modelitem containerId = null;
            boolean isCheckboxInContainerFlag = false;
            if (AppSchemaUtil.hasChildPart(this.targetitem.getName()) && ("masterref".equals(this.targetitemtype) || "storeref".equals(this.targetitemtype)) && (rel = AppSchemaUtil.getRelationTypeExceptRef(this.targetitem)) != null && "check".equals(rel.getType())) {
                isCheckboxInContainerFlag = true;
                containerId = AppSchemaUtil.getContainerIdItem(this.targetitem, model);
            }
            String tab = HelperGenerator_calc_operation.getProperTab(this.preformula);
            StringBuilder _sb = new StringBuilder();
            _sb.append(tab);
            String mtab = "";
            if (this.needsPresentationModel) {
                if (!this.mode_ref) {
                    _sb.append("if (");
                    _sb.append((String)__targetobj);
                    _sb.append(JavaSourceGenerator.getterFullMethod(cname));
                    _sb.append(".length > 0");
                    if (isCheckboxInContainerFlag && AppSchemaUtil.hasChildPart(this.sitem.getName())) {
                        String getter = JavaSourceGenerator.getterFullMethod(AppSchemaUtil.getChildPart(containerId.getName()));
                        _sb.append(" && StringUtil.intValue(");
                        _sb.append((String)__targetobj);
                        _sb.append(getter);
                        _sb.append(".getContent()) == ");
                        _sb.append("__").append(pname);
                        _sb.append(getter);
                    }
                    _sb.append(") {");
                    this.preformula.add(_sb.toString());
                    _sb = new StringBuilder();
                    _sb.append(tab + "    ");
                    mtab = "    ";
                } else if (this.mode_ref && this.mode_ref_multiple) {
                    __vname = "_" + cname + "s[k]";
                    Modelitem c_mitem = AppSchemaUtil.getModelitem(cname, model);
                    String c_classname = AppSchemaUtil.getModelitemClassname(c_mitem);
                    _sb.append(_packagename);
                    _sb.append(c_classname);
                    _sb.append("[] ");
                    _sb.append("_" + cname + "s");
                    _sb.append(" = ");
                    _sb.append((String)__targetobj);
                    _sb.append(JavaSourceGenerator.getterFullMethod(cname));
                    _sb.append(";");
                    this.preformula.add(_sb.toString());
                    _sb = new StringBuilder();
                    _sb.append(tab);
                    _sb.append("for (int k=0; k<");
                    _sb.append("_" + cname + "s");
                    _sb.append(".length; k++) {");
                    this.preformula.add(_sb.toString());
                    _sb = new StringBuilder();
                    _sb.append(tab + "    ");
                    _sb.append("if (!");
                    _sb.append(__vname);
                    _sb.append(".getChoose()) continue;");
                    this.preformula.add(_sb.toString());
                    _sb = new StringBuilder();
                    _sb.append(tab + "    ");
                    mtab = "    ";
                }
            }
            StringBuilder post_accessor = new StringBuilder();
            if (StringUtils.isNotBlank((CharSequence)cname)) {
                if (this.mode_ref && this.mode_ref_multiple) {
                    post_accessor.append(".getContent()");
                } else {
                    post_accessor.append(JavaSourceGenerator.getterFullMethod(cname));
                    if (this.needsPresentationModel) {
                        if (!this.mode_ref) {
                            post_accessor.append("[0]");
                        }
                        if (this.mode_id) {
                            String _getter = this.getter4presentationWithCompositeKey == null ? ".getId()" : this.getter4presentationWithCompositeKey[this.mode_id_suffix_no - 1];
                            post_accessor.append(_getter);
                        } else if (this.mode_content) {
                            post_accessor.append(".getContent()");
                        } else {
                            post_accessor.append(".getContent()");
                        }
                    }
                }
            }
            boolean useDateFormat = false;
            if (this.isDateOrTimeType(type) && !post_accessor.toString().endsWith(".getContent()") && (formats = AppSchemaUtil.getFormat(this.targetitem)) != null && formats.length > 0) {
                _sb.append("if (").append((String)__targetobj);
                if (post_accessor != null) {
                    _sb.append((CharSequence)post_accessor);
                }
                _sb.append(" == null) continue;");
                this.preformula.add(_sb.toString());
                _sb = new StringBuilder();
                _sb.append(tab + mtab);
                String formatstr = formats[0].getContent();
                String formatstrExpr = AppSchemaUtil.convertRuntimeFormat(formatstr);
                _sb.append("SimpleDateFormat __fmt = new SimpleDateFormat(");
                if (formatstrExpr != null) {
                    _sb.append(formatstrExpr);
                } else {
                    _sb.append("\"").append(formatstr).append("\"");
                }
                _sb.append(");");
                this.preformula.add(_sb.toString());
                _sb = new StringBuilder();
                _sb.append(tab + mtab);
                useDateFormat = true;
            }
            _sb.append("String __cnt = ");
            String qtab = "";
            if (this.needsPresentationModel && (!this.mode_ref || this.mode_ref_multiple)) {
                _sb.append("null;");
                this.preformula.add(_sb.toString());
                _sb = new StringBuilder();
                _sb.append(tab + mtab);
                Modelitem _targetitem = AppSchemaUtil.getModelitem(cname, model);
                _sb.append("for (");
                _sb.append(_packagename);
                _sb.append(AppSchemaUtil.getModelitemClassname(_targetitem));
                _sb.append(" __target : ");
                _sb.append((String)__targetobj + JavaSourceGenerator.getterFullMethod(cname));
                _sb.append(") {");
                this.preformula.add(_sb.toString());
                _sb = new StringBuilder();
                _sb.append(tab + mtab + "    ");
                _sb.append("if (__target.getChoose()) {");
                this.preformula.add(_sb.toString());
                _sb = new StringBuilder();
                _sb.append(tab + mtab + "        ");
                if (this.mode_id) {
                    String _type = AppSchemaUtil.getModelitemType(model.getId(), _targetitem, "roleid", false);
                    if (JavaSourceGenerator.isBasicType(_type)) {
                        _sb.append("__cnt = String.valueOf(__target.getId());");
                    } else {
                        _sb.append("__cnt = __target.getId();");
                    }
                } else {
                    _sb.append("__cnt = __target.getContent();");
                }
                this.preformula.add(_sb.toString());
                if (!isCheckboxInContainerFlag) {
                    _sb = new StringBuilder();
                    _sb.append(tab + mtab + "        ");
                    _sb.append("break;");
                    this.preformula.add(_sb.toString());
                    _sb = new StringBuilder();
                    _sb.append(tab + mtab + "    ");
                    _sb.append("}");
                    this.preformula.add(_sb.toString());
                    _sb = new StringBuilder();
                    _sb.append(tab + mtab);
                    _sb.append("}");
                    this.preformula.add(_sb.toString());
                } else {
                    qtab = "        ";
                }
            } else {
                boolean isBasicType = false;
                if (JavaSourceGenerator.isBasicType(this.targetitemtype) || "masterref".equals(this.targetitemtype) && this.mode_id) {
                    isBasicType = true;
                }
                if (!usePresentationModel) {
                    if (isBasicType && !this.needsPresentationModel) {
                        if (!(this.mode_ref || !StringUtils.isNotBlank((CharSequence)cname) || this.isContainerFlag || "masterref".equals(this.targetitemtype) || HelperGenerator_calc_operation.this.isMust)) {
                            _sb.append("(" + (String)__targetobj);
                            _sb.append(JavaSourceGenerator.checkFullMethod(cname));
                            _sb.append(") ? ");
                        }
                        _sb.append(JavaSourceGenerator.b2wc(type));
                        _sb.append(".toString(");
                    } else if (this.isDateOrTimeType(type)) {
                        if (StringUtils.isNotBlank((CharSequence)cname)) {
                            _sb.append("(" + (String)__targetobj);
                            _sb.append(JavaSourceGenerator.getterFullMethod(cname));
                            _sb.append(" != null");
                            if (post_accessor.length() > 0) {
                                _sb.append(" && ");
                                _sb.append((String)__targetobj);
                                _sb.append((CharSequence)post_accessor);
                                _sb.append(" != null");
                                if (post_accessor.toString().endsWith(".getContent()")) {
                                    _sb.append(" && ");
                                    _sb.append((String)__targetobj);
                                    _sb.append((CharSequence)post_accessor);
                                    _sb.append(".length() > 0");
                                }
                            }
                            _sb.append(") ? ");
                        }
                        if (useDateFormat) {
                            _sb.append("__fmt.format(");
                        }
                    }
                }
                _sb.append((String)__targetobj);
                _sb.append((CharSequence)post_accessor);
                if (!usePresentationModel) {
                    if (isBasicType && !this.needsPresentationModel) {
                        _sb.append(")");
                        if (!(this.mode_ref || !StringUtils.isNotBlank((CharSequence)cname) || this.isContainerFlag || "masterref".equals(this.targetitemtype) || HelperGenerator_calc_operation.this.isMust)) {
                            _sb.append(" : \"\"");
                        }
                    } else if (this.isDateOrTimeType(type)) {
                        if (useDateFormat) {
                            _sb.append(")");
                        }
                        if (StringUtils.isNotBlank((CharSequence)cname)) {
                            _sb.append(" : null");
                        }
                    }
                }
                _sb.append(";");
                this.preformula.add(_sb.toString());
            }
            _sb = new StringBuilder();
            _sb.append(tab + mtab + qtab);
            _sb.append("if (StringUtils.isBlank(__cnt)) continue;");
            this.preformula.add(_sb.toString());
            boolean use_L_loop = false;
            String cntVarName = "__cnt";
            String ntab = "";
            _sb = new StringBuilder();
            _sb.append(tab + mtab + qtab);
            if (this._joinMode != JoinMode.Simple) {
                if (this._joinMode == JoinMode.DoubleDistinct) {
                    _sb.append("String[] __tokens = StringUtils.split(" + cntVarName + ", \"" + this._sepchar + "\");");
                    this.preformula.add(_sb.toString());
                    _sb = new StringBuilder();
                    _sb.append(tab + mtab + qtab);
                    _sb.append("if (__tokens == null) __tokens = new String[0];");
                    this.preformula.add(_sb.toString());
                    ntab = "    ";
                    cntVarName = "__token";
                    _sb = new StringBuilder();
                    _sb.append(tab + mtab + qtab);
                    _sb.append("for (int l=0; l<__tokens.length; l++) {");
                    this.preformula.add(_sb.toString());
                    _sb = new StringBuilder();
                    _sb.append(tab + mtab + ntab + qtab);
                    _sb.append("String __token = __tokens[l];");
                    this.preformula.add(_sb.toString());
                    _sb = new StringBuilder();
                    _sb.append(tab + mtab + ntab + qtab);
                    _sb.append("if (StringUtils.isBlank(__token)) continue;");
                    this.preformula.add(_sb.toString());
                    _sb = new StringBuilder();
                    _sb.append(tab + mtab + ntab + qtab);
                    use_L_loop = true;
                }
                _sb.append("if (__processedValueSet.contains(" + cntVarName + "))");
                this.preformula.add(_sb.toString());
                _sb = new StringBuilder();
                _sb.append(tab + mtab + ntab + "    " + qtab);
                _sb.append("continue;");
                this.preformula.add(_sb.toString());
                _sb = new StringBuilder();
                _sb.append(tab + mtab + ntab + qtab);
                _sb.append("__processedValueSet.add(" + cntVarName + ");");
                this.preformula.add(_sb.toString());
                _sb = new StringBuilder();
                _sb.append(tab + mtab + ntab + qtab);
            }
            _sb.append("__sb.append(" + cntVarName + ");");
            this.preformula.add(_sb.toString());
            if (!(this._joinMode != JoinMode.DoubleDistinct || this.mode_ref && this.mode_ref_multiple)) {
                this.add_separator("l", "__tokens", this.needsPresentationModel && !this.mode_ref ? tab + mtab + "        " + qtab : tab + mtab + "    " + qtab);
            }
            if (this.mode_ref && this.mode_ref_multiple) {
                this.add_separator("k", "_" + cname + "s", this._joinMode == JoinMode.DoubleDistinct ? tab + mtab + "    " + qtab : tab + mtab + qtab);
                _sb = new StringBuilder();
                _sb.append(tab + (use_L_loop ? mtab + qtab : qtab));
                _sb.append("}");
                this.preformula.add(_sb.toString());
            }
            if (this._joinMode == JoinMode.DoubleDistinct) {
                _sb = new StringBuilder();
                _sb.append(tab + qtab);
                _sb.append("}");
                this.preformula.add(_sb.toString());
                this.addMultipleFinishCode(null, vname, null, tab + qtab, false);
                _sb = new StringBuilder();
                _sb.append(tab + qtab);
                _sb.append("__sb = new StringBuilder(" + vname + ");");
                this.preformula.add(_sb.toString());
            }
            if (!(this.needsPresentationModel && this.mode_ref && this.mode_ref_multiple)) {
                this.add_separator("j", pname, tab + qtab + (this.needsPresentationModel && !this.mode_ref ? "    " : ""));
            }
            if (this.needsPresentationModel && !this.mode_ref) {
                _sb = new StringBuilder();
                _sb.append(tab + qtab);
                _sb.append("}");
                this.preformula.add(_sb.toString());
            }
            if (isCheckboxInContainerFlag) {
                _sb = new StringBuilder();
                _sb.append(tab + mtab);
                _sb.append("}");
                this.preformula.add(_sb.toString());
                _sb = new StringBuilder();
                _sb.append(tab);
                _sb.append("}");
                this.preformula.add(_sb.toString());
            }
        }

        private final boolean isDateOrTimeType(String type) {
            return this.isDateType(type) || this.isTimeType(type) || this.isDateTimeType(type);
        }

        private final boolean isDateType(String type) {
            return "date".equalsIgnoreCase(type) || "java.sql.Date".equals(type);
        }

        private final boolean isTimeType(String type) {
            return "time".equalsIgnoreCase(type) || "java.sql.Time".equals(type);
        }

        private final boolean isDateTimeType(String type) {
            return "dateTime".equalsIgnoreCase(type) || "java.sql.Timestamp".equals(type);
        }

        private void add_separator(String loopv, String name, String tab) {
            StringBuilder _sb = new StringBuilder();
            _sb.append(tab);
            _sb.append("__sb.append(\"");
            _sb.append(this._sepchar);
            _sb.append("\");");
            this.preformula.add(_sb.toString());
        }

        @Override
        public void addMultipleFinishCode(String name, String vname, String type) {
            this.addMultipleFinishCode(name, vname, type, "    ", true);
        }

        public void addMultipleFinishCode(String name, String vname, String type, String tab, boolean isOutputSetoutFlag) {
            StringBuilder _sb = new StringBuilder();
            _sb.append(tab);
            _sb.append(vname);
            _sb.append(" = __sb.toString();");
            this.preformula.add(_sb.toString());
            if (StringUtils.isNotBlank((CharSequence)this._sepchar)) {
                this.removeFinalSepchar(vname, tab);
            }
            if (isOutputSetoutFlag) {
                this.setProcessedFlag();
            }
        }

        private void removeFinalSepchar(String vname, String tab) {
            StringBuilder _sb = new StringBuilder();
            _sb.append(tab);
            _sb.append("if (" + vname + " != null) {");
            this.preformula.add(_sb.toString());
            _sb = new StringBuilder();
            _sb.append("    " + tab);
            _sb.append("while (" + vname + ".endsWith(\"" + this._sepchar + "\")) {");
            this.preformula.add(_sb.toString());
            _sb = new StringBuilder();
            _sb.append("        " + tab);
            _sb.append(vname + " = " + vname + ".substring(0, " + vname + ".length()-\"" + this._sepchar + "\".length());");
            this.preformula.add(_sb.toString());
            _sb = new StringBuilder();
            _sb.append("    " + tab);
            _sb.append("}");
            this.preformula.add(_sb.toString());
            _sb = new StringBuilder();
            _sb.append(tab);
            _sb.append("}");
            this.preformula.add(_sb.toString());
        }

        @Override
        public void addContainerTmpvarDefinition(String vname, String container_type) {
            this.addMultipleTmpvarDefinition(vname, container_type);
        }

        @Override
        public void addContainerFinishCode(String pname, String vname, String type) {
            this.addMultipleFinishCode(pname, vname, type);
        }

        @Override
        public void addForeignModelTmpvarDefinition(String vname, String _refmodel_item_type) {
            this.addMultipleTmpvarDefinition(vname, _refmodel_item_type);
        }

        @Override
        public void addForeignModelFinishCode(String pname, String vname) {
            StringBuilder _sb = new StringBuilder();
            _sb.append("    ");
            _sb.append(vname);
            _sb.append(" = __sb.toString();");
            this.preformula.add(_sb.toString());
            if (StringUtils.isNotBlank((CharSequence)this._sepchar)) {
                this.removeFinalSepchar(vname, "    ");
            }
            this.setProcessedFlag(true);
        }

        @Override
        public void checkbox() {
            this.pmodel = AppSchemaUtil.getModel(HelperGenerator_calc_operation.this.project, this.id, "presentation");
            this.ppackagename = this.pmodel != null ? AppSchemaUtil.getPackagename(this.pmodel, HelperGenerator_calc_operation.this.project) : "";
            this.ppackagename_app = AppSchemaUtil.getPackagename_app(this.model, HelperGenerator_calc_operation.this.project);
            this.pclassname = AppSchemaUtil.getClassname(this.pmodel);
            String _packagename = AppSchemaUtil.getPackagename(this.pmodel, HelperGenerator_calc_operation.this.project);
            StringBuilder _sb = new StringBuilder();
            Object tab = "";
            String _name = this.tcname;
            String _vname = "_join_" + _name;
            this.formula.append(_vname);
            _sb = new StringBuilder();
            _sb.append("String ").append(_vname).append(" = null;");
            this.preformula.add(_sb.toString());
            _sb = new StringBuilder();
            _sb.append((String)tab);
            _sb.append("{");
            this.preformula.add(_sb.toString());
            tab = (String)tab + "    ";
            _sb = new StringBuilder();
            _sb.append((String)tab).append("StringBuilder __sb = new StringBuilder();");
            this.preformula.add(_sb.toString());
            if (this._joinMode != JoinMode.Simple) {
                _sb = new StringBuilder();
                _sb.append((String)tab).append("Set<String> __processedValueSet = new HashSet<String>();");
                this.preformula.add(_sb.toString());
            }
            _sb = new StringBuilder();
            _sb.append((String)tab).append("String __cnt = null;");
            this.preformula.add(_sb.toString());
            _sb = new StringBuilder();
            _sb.append((String)tab);
            Modelitem _targetitem = AppSchemaUtil.getModelitem(_name, this.model);
            _sb.append("for (");
            _sb.append(_packagename);
            _sb.append(AppSchemaUtil.getModelitemClassname(_targetitem));
            _sb.append(" __target : ");
            Relation _relation = AppSchemaUtil.getRelationTypeExceptRef(_targetitem);
            String _restrict = _relation != null ? _relation.getRestrict() : null;
            _sb.append(AppSchemaUtil.getHelperClassname4Dicon(this.pmodel, HelperGenerator_calc_operation.this.project));
            _sb.append(".get");
            _sb.append(AppSchemaUtil.getModelitemClassname(_targetitem));
            _sb.append("_show(");
            _sb.append(this.id + JavaSourceGenerator.getterFullMethod(_name));
            _sb.append(", ");
            if (StringUtils.isNotBlank((CharSequence)_restrict)) {
                _sb.append(this.id + JavaSourceGenerator.getterFullMethod(_restrict));
                _sb.append(", ");
            }
            _sb.append("p)");
            _sb.append(") {");
            this.preformula.add(_sb.toString());
            _sb = new StringBuilder();
            _sb.append((String)tab + "    ");
            _sb.append("if (__target.getChoose()) {");
            this.preformula.add(_sb.toString());
            _sb = new StringBuilder();
            _sb.append((String)tab + "        ");
            if (this.mode_id) {
                String _type = AppSchemaUtil.getModelitemType(this.model.getId(), _targetitem, "roleid", false);
                if (JavaSourceGenerator.isBasicType(_type)) {
                    _sb.append("__cnt = String.valueOf(__target.getId());");
                } else {
                    _sb.append("__cnt = __target.getId();");
                }
            } else {
                _sb.append("__cnt = __target.getContent();");
            }
            this.preformula.add(_sb.toString());
            _sb = new StringBuilder();
            _sb.append((String)tab + "        ");
            _sb.append("if (StringUtils.isBlank(__cnt)) continue;");
            this.preformula.add(_sb.toString());
            String cntVarName = "__cnt";
            _sb = new StringBuilder();
            _sb.append((String)tab + "        ");
            if (this._joinMode != JoinMode.Simple) {
                if (this._joinMode == JoinMode.DoubleDistinct) {
                    _sb.append("String[] __tokens = StringUtils.split(" + cntVarName + ", \"" + this._sepchar + "\");");
                    this.preformula.add(_sb.toString());
                    _sb = new StringBuilder();
                    _sb.append((String)tab + "        ");
                    _sb.append("if (__tokens == null) __tokens = new String[0];");
                    this.preformula.add(_sb.toString());
                    cntVarName = "__token";
                    _sb = new StringBuilder();
                    _sb.append((String)tab + "        ");
                    _sb.append("for (int l=0; l<__tokens.length; l++) {");
                    this.preformula.add(_sb.toString());
                    _sb = new StringBuilder();
                    _sb.append((String)tab + "            ");
                    _sb.append("String __token = __tokens[l];");
                    this.preformula.add(_sb.toString());
                    _sb = new StringBuilder();
                    _sb.append((String)tab + "            ");
                    _sb.append("if (StringUtils.isBlank(__token)) continue;");
                    this.preformula.add(_sb.toString());
                    _sb = new StringBuilder();
                    _sb.append((String)tab + "            ");
                }
                _sb.append("if (__processedValueSet.contains(" + cntVarName + "))");
                this.preformula.add(_sb.toString());
                _sb = new StringBuilder();
                _sb.append((String)tab + "                ");
                _sb.append("continue;");
                this.preformula.add(_sb.toString());
                _sb = new StringBuilder();
                _sb.append((String)tab + "            ");
                _sb.append("__processedValueSet.add(" + cntVarName + ");");
                this.preformula.add(_sb.toString());
                _sb = new StringBuilder();
                _sb.append((String)tab + "            ");
            }
            _sb.append("__sb.append(" + cntVarName + ");");
            this.preformula.add(_sb.toString());
            if (!(this._joinMode != JoinMode.DoubleDistinct || this.mode_ref && this.mode_ref_multiple)) {
                this.add_separator("", "", (String)tab + "            ");
            }
            if (this._joinMode == JoinMode.DoubleDistinct) {
                _sb = new StringBuilder();
                _sb.append((String)tab + "        ");
                _sb.append("}");
                this.preformula.add(_sb.toString());
                this.addMultipleFinishCode(_vname, _vname, null, (String)tab + "        ", false);
                _sb = new StringBuilder();
                _sb.append((String)tab + "        ");
                _sb.append("__sb = new StringBuilder(" + _vname + ");");
                this.preformula.add(_sb.toString());
            }
            this.add_separator("", "", (String)tab + "        ");
            _sb = new StringBuilder();
            _sb.append((String)tab + "    ");
            _sb.append("}");
            this.preformula.add(_sb.toString());
            this.addMultipleFinishCode(_vname, _vname, null, "        ", true);
            _sb = new StringBuilder();
            _sb.append("    ").append("}");
            this.preformula.add(_sb.toString());
            _sb = new StringBuilder();
            _sb.append("}");
            this.preformula.add(_sb.toString());
        }
    }

    private static enum JoinMode {
        Simple,
        Distinct,
        DoubleDistinct;

    }

    class CalcProcess_Isnoselection
    extends CalcProcess_Func {
        CalcProcess_Isnoselection(String id, String s, String tname, String condition, StringBuilder formula, List<String> preformula, Modelitem sitem, Model model, Set<String> declareVarSet, Map<String, VariableStatus> varMap) {
            super(id, s, tname, condition, formula, preformula, sitem, model, declareVarSet, varMap);
        }

        @Override
        public String getType() {
            return "isnoselection";
        }

        @Override
        public void process0() {
            this.packagename = AppSchemaUtil.getPackagename(this.model, HelperGenerator_calc_operation.this.project);
            if (!"masterref".equals(this.targetitem.getType()) && !"storeref".equals(this.targetitem.getType())) {
                Object[] o = new Object[]{this.id, this.sitem.getName(), this.tname};
                logger.warn(HelperGenerator_calc_operation.this.rman.getValue("expr.invalid.autocalc.isnoselection.type", o));
                return;
            }
            Relation rel_targetitem = AppSchemaUtil.getRelationTypeExceptRef(this.targetitem);
            if (rel_targetitem == null) {
                Object[] o = new Object[]{this.id, this.sitem.getName(), this.tname};
                logger.warn(HelperGenerator_calc_operation.this.rman.getValue("expr.invalid.autocalc.isnoselection.norelation", o));
                return;
            }
            String rel_type = null;
            PrimaryKey[] pkeys = null;
            Model rel_model = null;
            if ("storeref".equals(this.targetitem.getType())) {
                PrimaryKey pkey;
                rel_model = (Model)rel_targetitem.getIdrefAsIRNode();
                pkeys = AppSchemaUtil.getPrimaryKey(rel_model);
                PrimaryKey primaryKey = pkey = pkeys != null && pkeys.length > 0 ? pkeys[0] : null;
                if (pkey != null) {
                    Modelitem rel_mitem = AppSchemaUtil.getModelitem(pkey.getName(), rel_model);
                    rel_type = AppSchemaUtil.getModelitemType(HelperGenerator_calc_operation.this.project, this.id, rel_mitem, "roleid");
                }
            } else {
                rel_type = "int";
            }
            StringBuilder _sb = new StringBuilder();
            String tab = HelperGenerator_calc_operation.getProperTab(this.preformula);
            String vname = this.createVariableNameForResult(AppSchemaUtil.getChildPart(this.tname));
            String target_id = this.isContainer ? "__" + AppSchemaUtil.getParentPart(this.tname) : this.id;
            Modelitem target_mitem = AppSchemaUtil.getModelitem(this.tname, this.model);
            String target_itemname = AppSchemaUtil.getChildPart(target_mitem.getName());
            if ("combo".equals(rel_targetitem.getType()) || "radio".equals(rel_targetitem.getType())) {
                _sb.append(tab);
                _sb.append("boolean ").append(vname).append(" = (");
                if (pkeys == null || pkeys.length == 1) {
                    _sb.append(target_id);
                    if (JavaSourceGenerator.isBasicType(rel_type)) {
                        _sb.append(JavaSourceGenerator.checkFullMethod(target_itemname));
                        _sb.append(" == false");
                    } else {
                        _sb.append(JavaSourceGenerator.getterFullMethod(target_itemname));
                        _sb.append(" == null");
                    }
                    _sb.append(");");
                } else if (pkeys != null && pkeys.length > 1) {
                    for (int i = 0; i < pkeys.length; ++i) {
                        PrimaryKey pkey = pkeys[i];
                        String pkey_name = AppSchemaUtil.createFullPrimaryKeyName(pkey);
                        String pkey_type = AppSchemaUtil.getPkeyType(rel_model, pkey_name, "int", HelperGenerator_calc_operation.this.project);
                        _sb.append(target_id);
                        String _name = target_itemname + "_" + pkey_name;
                        if (JavaSourceGenerator.isBasicType(pkey_type)) {
                            _sb.append(JavaSourceGenerator.checkFullMethod(_name));
                            _sb.append(" == false");
                        } else {
                            _sb.append(JavaSourceGenerator.getterFullMethod(_name));
                            _sb.append(" == null");
                        }
                        if (i >= pkeys.length - 1) continue;
                        _sb.append(" || ");
                    }
                    _sb.append(");");
                }
                this.preformula.add(_sb.toString());
                this.setProcessedFlag(true);
                this.formula.append(vname);
            } else if ("check".equals(rel_targetitem.getType())) {
                _sb.append("boolean ").append(vname).append(" = ");
                _sb.append("(");
                _sb.append(target_id);
                _sb.append(JavaSourceGenerator.getterFullMethod(target_itemname));
                _sb.append(" == null || ");
                _sb.append(target_id);
                _sb.append(JavaSourceGenerator.getterFullMethod(target_itemname));
                _sb.append(".length == 0)");
                _sb.append(";");
                this.preformula.add(_sb.toString());
                this.setProcessedFlag(true);
                this.formula.append(vname);
            }
        }
    }

    class CalcProcess_Collect
    extends CalcProcess_MaxMin {
        private String __type;
        private String __wtype;

        CalcProcess_Collect(String id, String s, String tname, String condition, StringBuilder formula, List<String> preformula, Modelitem sitem, Model model, Set<String> declareVarSet, Map<String, VariableStatus> varMap) {
            super(id, s, tname, condition, formula, preformula, sitem, model, declareVarSet, varMap);
        }

        @Override
        public String getType() {
            return "collect";
        }

        @Override
        public String getProperType(String type) {
            this.__type = JavaSourceGenerator.getProperType(type);
            this.__wtype = JavaSourceGenerator.b2wc(this.__type);
            return this.__type + "[]";
        }

        @Override
        public String getValidValue(String type) {
            return "null";
        }

        @Override
        protected void ready_code0() {
            StringBuilder _sb = new StringBuilder();
            _sb.append("    ");
            _sb.append("List<").append(this.__wtype).append("> _list = ");
            _sb.append("new ArrayList<").append(this.__wtype).append(">();");
            this.preformula.add(_sb.toString());
        }

        @Override
        protected void op_code0_main(String vname, String type, String pname, String cname, String pname_postfix, String __targetobj, String basetab, String ntab) {
            String leftexpr = "_list.add(";
            String rightexpr = ")";
            this.createMaxMinProperExpression(leftexpr, rightexpr, type, pname, cname, pname_postfix, __targetobj);
        }

        @Override
        public void addMultipleFinishCode(String name, String vname, String multiple_type) {
            this.addFinishCode(vname);
        }

        @Override
        public void addContainerFinishCode(String pname, String vname, String container_type) {
            this.addFinishCode(vname);
        }

        @Override
        public void addForeignModelFinishCode(String refmodel_items, String vname) {
            this.addFinishCode(vname);
        }

        private void addFinishCode(String vname) {
            String tab = HelperGenerator_calc_operation.getProperTab(this.preformula, false);
            StringBuilder _sb = new StringBuilder();
            _sb.append(tab);
            _sb.append(vname);
            _sb.append(" = ");
            if (JavaSourceGenerator.isBasicType(this.__type)) {
                _sb.append("ArrayUtils.toPrimitive(");
            }
            _sb.append("_list.toArray(new ").append(this.__wtype).append("[_list.size()])");
            if (JavaSourceGenerator.isBasicType(this.__type)) {
                _sb.append(")");
            }
            _sb.append(";");
            this.preformula.add(_sb.toString());
            this.setProcessedFlag();
        }
    }

    class CalcProcess_Normal
    extends CalcProcess {
        CalcProcess_Normal(String id, String s, String tname, String condition, StringBuilder formula, List<String> preformula, Modelitem sitem, Model model, Set<String> declareVarSet, Map<String, VariableStatus> varMap) {
            super(id, s, tname, condition, formula, preformula, sitem, model, declareVarSet, varMap);
        }

        @Override
        public void process0() {
            Object[] o;
            boolean isOutputTcname = true;
            if (this.isMultiple) {
                Modelitem titem = AppSchemaUtil.getModelitem(this.tname, this.model);
                if (!(HelperGenerator_calc_operation.this.methodNamePrefix.endsWith("_count_condition") || this.sitem.getMultiple() || titem != null && titem.getMultiple())) {
                    Object[] o2 = new Object[]{this.id, this.tname};
                    logger.error(HelperGenerator_calc_operation.this.rman.getValue("helper.invalid.autocalc.content.cannotuse.container", o2));
                    this.status = 3;
                    return;
                }
            }
            if (this.isContainer && !"".equals(HelperGenerator_calc_operation.this.pname) && !"".equals(this.tpname) && !HelperGenerator_calc_operation.this.pname.equals(this.tpname)) {
                o = new Object[]{this.id, HelperGenerator_calc_operation.this.name, this.tname};
                logger.error(HelperGenerator_calc_operation.this.rman.getValue("helper.invalid.autocalc.pname.mismatch", o));
                this.status = 3;
                return;
            }
            if ("storeref".equals(this.targetitemtype)) {
                this.targetitemtype = HelperGenerator_calc_operation.this.resolvTargetitemType(this.targetitemtype, this.targetitem);
            }
            if ("masterref".equals(this.targetitemtype) || "storeref".equals(this.targetitemtype)) {
                Relation rel = AppSchemaUtil.getRelation(this.targetitem);
                if (rel == null) {
                    return;
                }
                if ("check".equals(rel.getType())) {
                    this.isCheckbox = true;
                }
                String _tname0 = null;
                String _tname1 = null;
                if (this.org_tname.indexOf("/") >= 0) {
                    _tname0 = this.org_tname.substring(this.org_tname.indexOf("/") + 1);
                    _tname1 = this.org_tname.substring(0, this.org_tname.indexOf("/"));
                } else {
                    _tname0 = this.org_tname;
                    _tname1 = this.id;
                }
                if (!"ref".equals(rel.getType())) {
                    this.process0_ref_ready(_tname0, (String)(this.isContainer ? "__" + _tname1 : _tname1));
                }
                if ("masterref".equals(this.targetitemtype)) {
                    this.process0_masterref(_tname0, _tname1);
                    this.setProcessedFlag();
                    return;
                }
                this.process0_storeref(this.targetitem, _tname0);
                if (!"ref".equals(rel.getType())) {
                    this.setProcessedFlag();
                    return;
                }
                isOutputTcname = false;
            }
            if ("storeref".equals(this.targetitemtype)) {
                this.targetitemtype = HelperGenerator_calc_operation.this.resolvTargetitemType(this.targetitemtype, this.targetitem);
            }
            if (this.targetitem == null) {
                o = new Object[]{this.id, this.s};
                logger.error(HelperGenerator_calc_operation.this.rman.getValue("helper.invalid.autocalc.targetitem.null", o));
                this.status = 3;
                return;
            }
            PrimaryKey __relmodel_pkey = null;
            if (this.mode_id && this.mode_id_suffix_no > 0 && this.targetitemtype.indexOf("$SEP$") >= 0) {
                String[] tokens = this.targetitemtype.split(PrimaryKeyUtils.PKEY_SEPARATOR_REGEXP());
                if (this.mode_id_suffix_no > tokens.length) {
                    Object[] o3 = new Object[]{this.id, this.s, this.mode_id_suffix_no};
                    logger.error(HelperGenerator_calc_operation.this.rman.getValue("helper.invalid.autocalc.targetitem.suffix", o3));
                    this.status = 3;
                    return;
                }
                this.targetitemtype = tokens[this.mode_id_suffix_no - 1];
                Relation _rel = AppSchemaUtil.getRelationTypeIsRef(this.targetitem);
                if (_rel != null) {
                    Model __relmodel;
                    PrimaryKey[] __relmodel_pkeys;
                    Relation __rel;
                    this.targetitem = AppSchemaUtil.getModelitem(_rel.getName(), this.model);
                    if (this.targetitem != null && (__rel = AppSchemaUtil.getRelation(this.targetitem)) != null && (__relmodel_pkeys = AppSchemaUtil.getPrimaryKey(__relmodel = (Model)__rel.getIdrefAsIRNode())) != null && __relmodel_pkeys.length > 0 && this.mode_id_suffix_no <= __relmodel_pkeys.length) {
                        __relmodel_pkey = __relmodel_pkeys[this.mode_id_suffix_no - 1];
                    }
                }
                if (this.targetitem == null) {
                    Object[] o4 = new Object[]{this.id, this.s, this.mode_id_suffix_no};
                    logger.error(HelperGenerator_calc_operation.this.rman.getValue("helper.invalid.autocalc.targetitem.suffix.notfound", o4));
                    this.status = 3;
                    return;
                }
            }
            VariableStatus vs = new VariableStatus(this.targetitemtype, this.targetitem.getMust(), this.isContainer);
            if (__relmodel_pkey != null) {
                this.tcname = this.tcname + "_" + __relmodel_pkey.getName();
            }
            if (!AppSchemaUtil.hasAutocalc(this.targetitem) || this.sitem.getName().equals(this.targetitem.getName())) {
                this.varMap.put(HelperGenerator_calc_operation.this.createTmpVarName(null, this.tcname), vs);
            }
            if (isOutputTcname) {
                this.formula.append(HelperGenerator_calc_operation.this.createTmpVarName(this.tname, this.tcname));
            }
            this.setProcessedFlag();
        }
    }

    abstract class CalcProcess {
        String id;
        String s;
        String tname;
        String tpname;
        String tcname;
        StringBuilder formula;
        List<String> preformula;
        Modelitem sitem;
        Model model;
        Set<String> declareVarSet;
        Map<String, VariableStatus> varMap;
        Modelitem targetitem;
        String sitemtype;
        String targetitemtype;
        boolean mode_id;
        int mode_id_suffix_no;
        boolean mode_content;
        boolean mode_array;
        boolean mode_ref;
        String refitemtype;
        boolean mode_ref_multiple;
        String mode_id_targetname;
        String[] getter4presentationWithCompositeKey;
        int status = 1;
        boolean isMultiple;
        boolean isContainer;
        boolean isCheckbox;
        boolean isForeignModel;
        String condition;
        String org_tname;

        CalcProcess(String id, String s, String tname, String condition, StringBuilder formula, List<String> preformula, Modelitem sitem, Model model, Set<String> declareVarSet, Map<String, VariableStatus> varMap) {
            this.id = id;
            this.s = s;
            this.tname = tname;
            this.condition = condition;
            this.formula = formula;
            this.preformula = preformula;
            this.sitem = sitem;
            this.model = model;
            this.declareVarSet = declareVarSet;
            this.varMap = varMap;
            if (this.tname.startsWith("__calc_") && this.tname.endsWith(")")) {
                this.org_tname = this.tname.substring("__calc_".length());
                this.org_tname = this.org_tname.substring(0, this.org_tname.indexOf("("));
                this.org_tname = StringUtil.replaceAll((String)this.org_tname, (String)"$", (String)"/");
            } else {
                this.org_tname = this.tname;
            }
            this.tname = StringUtil.removePreAndPostWhitespaceWithoutInside((String)this.tname);
            this.org_tname = StringUtil.removePreAndPostWhitespaceWithoutInside((String)this.org_tname);
            this.condition = StringUtil.removePreAndPostWhitespaceWithoutInside((String)this.condition);
            if (this.tname.startsWith("(") && this.tname.endsWith(")")) {
                this.tname = this.tname.substring(1);
                this.tname = this.tname.substring(0, this.tname.length() - 1);
            }
            this.init();
        }

        public void init() {
            String prefix;
            this.tpname = "";
            this.tcname = this.org_tname;
            int idx = this.org_tname.indexOf("/");
            if (idx > 0) {
                this.tpname = this.org_tname.substring(0, idx);
                this.tcname = this.org_tname.substring(idx + 1);
                this.org_tname = this.tpname + "/" + this.tcname;
            }
            if ((idx = this.org_tname.indexOf(".")) > 0 && (prefix = this.org_tname.substring(0, idx)) != null && !prefix.endsWith("_lp")) {
                this.tcname = this.org_tname = this.org_tname.substring(idx + 1);
            }
        }

        public int process() {
            Model _m;
            PrimaryKey[] r_pkeys;
            Relation _r;
            Relation _relation;
            String idsuffix = AppSchemaUtil.getIdSuffixPartInExpr(this.tcname);
            if (idsuffix != null) {
                this.tcname = this.tcname.substring(0, this.tcname.length() - idsuffix.length());
                this.tname = this.tname.substring(0, this.tname.length() - idsuffix.length());
                this.org_tname = this.org_tname.substring(0, this.org_tname.length() - idsuffix.length());
                this.mode_id = true;
                if (idsuffix.length() > "#id".length()) {
                    String mode_id_suffix_str = idsuffix.substring("#id".length());
                    this.mode_id_suffix_no = StringUtil.intValue((String)mode_id_suffix_str);
                }
            }
            if (this.tcname.endsWith("#content")) {
                this.tcname = this.tcname.substring(0, this.tcname.length() - "#content".length());
                this.tname = this.tname.substring(0, this.tname.length() - "#content".length());
                this.org_tname = this.org_tname.substring(0, this.org_tname.length() - "#content".length());
                this.mode_content = true;
            }
            if (this.tcname.endsWith("#array")) {
                this.tcname = this.tcname.substring(0, this.tcname.length() - "#array".length());
                this.tname = this.tname.substring(0, this.tname.length() - "#array".length());
                this.org_tname = this.org_tname.substring(0, this.org_tname.length() - "#array".length());
                this.mode_array = true;
            }
            this.targetitem = AppSchemaUtil.getModelitem(this.org_tname, this.model);
            if (!(this.mode_content || this.targetitem == null || this.targetitem.getType().equals("masterref") || AppSchemaUtil.getRelation(this.targetitem) == null || idsuffix != null || this.tcname.endsWith("#content") || this.tcname.endsWith("#array"))) {
                this.mode_content = true;
            }
            if (this.targetitem == null && !this.org_tname.endsWith("_lp")) {
                this.targetitem = AppSchemaUtil.withRefmodelPrimaryKeyName(this.org_tname, this.model, HelperGenerator_calc_operation.this.project);
            }
            Relation _rel = AppSchemaUtil.getRelationTypeIsRef(this.targetitem);
            Model __target = this.model;
            if (this.targetitem == null) {
                String _refmodel_id = HelperGenerator_calc_operation.getModelIdPart(this.org_tname);
                Action _action = AppSchemaUtil.getActionByModelIdAndType(HelperGenerator_calc_operation.this.project, this.model.getId(), "show");
                if (_action != null) {
                    IProjectChoice[] _refmodels = AppSchemaUtil.getDataitemAsModel(_action, "array2list");
                    if (_refmodels != null) {
                        for (IProjectChoice _refmodel : _refmodels) {
                            if (!((Model)_refmodel).getId().equals(_refmodel_id)) continue;
                            this.isForeignModel = true;
                            __target = AppSchemaUtil.getStoreModel((Model)_refmodel);
                            this.targetitem = AppSchemaUtil.getModelitem(HelperGenerator_calc_operation.getModelItemNamePart(this.org_tname), __target);
                            _rel = AppSchemaUtil.getRelationTypeIsRef(this.targetitem);
                            break;
                        }
                    }
                } else {
                    for (IProjectChoice ipc : HelperGenerator_calc_operation.this.project.getContent()) {
                        IProjectChoice _refmodel;
                        if (!(ipc instanceof Model) || !((Model)(_refmodel = (Model)ipc)).getId().equals(_refmodel_id)) continue;
                        this.isForeignModel = true;
                        __target = AppSchemaUtil.getStoreModel((Model)_refmodel);
                        this.targetitem = AppSchemaUtil.getModelitem(HelperGenerator_calc_operation.getModelItemNamePart(this.org_tname), __target);
                        _rel = AppSchemaUtil.getRelationTypeIsRef(this.targetitem);
                        break;
                    }
                }
                if (!this.isForeignModel) {
                    this.status = 2;
                    return this.status;
                }
            }
            this.sitemtype = this.sitem.getType();
            String string = this.targetitemtype = this.targetitem != null ? this.targetitem.getType() : null;
            if (JavaSourceGenerator.isDateOrTimeType(this.targetitemtype)) {
                this.targetitemtype = JavaSourceGenerator.getProperType(this.targetitemtype);
            } else if (JavaSourceGenerator.isStringType(this.targetitemtype)) {
                this.targetitemtype = "String";
            }
            if (_rel != null) {
                ForeignKey[] fkeys;
                Model __model;
                this.mode_ref = true;
                this.refitemtype = AppSchemaUtil.getRelationRefType(__target.getId(), this.targetitem.getName(), _rel, HelperGenerator_calc_operation.this.project);
                Model __refmodel = (Model)_rel.getIdrefAsIRNode();
                Modelitem __item_refmodel = AppSchemaUtil.getModelitem(_rel.getName(), __refmodel);
                if (__item_refmodel == null && (__model = AppSchemaUtil.getModel(HelperGenerator_calc_operation.this.project, __target.getId())) != null && (fkeys = AppSchemaUtil.getForeignKey(__model)) != null) {
                    for (ForeignKey fkey : fkeys) {
                        String refname;
                        if (!fkey.getIdref().equals(_rel.getIdref()) || !fkey.getName().equals(_rel.getName()) || !StringUtils.isNotBlank((CharSequence)(refname = fkey.getRefname()))) continue;
                        __item_refmodel = AppSchemaUtil.getModelitem(refname, __refmodel);
                        break;
                    }
                }
                if ("masterref".equals(__item_refmodel.getType())) {
                    this.mode_ref_multiple = true;
                    if (!this.mode_content) {
                        this.mode_id = true;
                    }
                } else if ("storeref".equals(__item_refmodel.getType())) {
                    Relation __r = AppSchemaUtil.getRelatedRelationInCaseofTypeRef(HelperGenerator_calc_operation.this.project, __target, this.targetitem);
                    if (__r != null) {
                        this.mode_ref_multiple = true;
                        if (!this.mode_content) {
                            this.mode_id = true;
                        }
                    }
                } else if (this.mode_id) {
                    this.mode_id = false;
                    this.mode_content = true;
                    Object[] o = new Object[]{__target.getId(), this.sitem.getName(), this.s};
                    logger.error(HelperGenerator_calc_operation.this.rman.getValue("helper.invalid.autocalc.useid.refitem", o));
                }
            }
            if (this.targetitem != null && ("storeref".equals(this.targetitem.getType()) || "masterref".equals(this.targetitem.getType())) && (_relation = AppSchemaUtil.getRelationTypeExceptRef(this.targetitem)) != null && "check".equals(_relation.getType())) {
                this.isCheckbox = true;
            }
            this.isMultiple = this.targetitem != null ? this.targetitem.getMultiple() : false;
            boolean bl = this.isContainer = this.targetitem != null ? this.targetitem.getHasChild() : false;
            if (!this.isContainer) {
                boolean bl2 = this.isContainer = this.org_tname.indexOf("/") > 0;
            }
            if (this.isContainer && "".equals(this.tpname)) {
                this.tpname = this.tcname;
            }
            if ("storeref".equals(this.targetitemtype) && !this.mode_id && !this.mode_content && !this.mode_ref) {
                this.mode_content = true;
            }
            if (this.mode_id_suffix_no > 1 && (_r = AppSchemaUtil.getRelation(this.targetitem)) != null && (r_pkeys = AppSchemaUtil.getPrimaryKey(_m = (Model)_r.getIdrefAsIRNode())) != null && r_pkeys.length > 1) {
                this.getter4presentationWithCompositeKey = new String[r_pkeys.length];
                for (int k = 0; k < r_pkeys.length; ++k) {
                    String _getter;
                    if (k == 0) {
                        this.getter4presentationWithCompositeKey[0] = ".getId()";
                        continue;
                    }
                    String _name = r_pkeys[k].getName() + "_jshpkey";
                    this.getter4presentationWithCompositeKey[k] = _getter = JavaSourceGenerator.getterFullMethod(_name);
                }
            }
            this.process0();
            return this.status;
        }

        public abstract void process0();

        protected void process0_ref_ready(String name0, String name1) {
            Model pmodel = AppSchemaUtil.getModel(HelperGenerator_calc_operation.this.project, this.id, "presentation");
            if (pmodel == null) {
                logger.error(HelperGenerator_calc_operation.this.rman.getValue("value.null.model.presentation", this.id));
                return;
            }
            String ppackagename = AppSchemaUtil.getPackagename(pmodel, HelperGenerator_calc_operation.this.project);
            Modelitem mitem = AppSchemaUtil.getModelitem(name0, this.model);
            Relation rel = AppSchemaUtil.getRelationTypeExceptRef(mitem);
            String classname = AppSchemaUtil.getModelitemClassname(mitem);
            boolean isCheckboxFlag = false;
            StringBuilder vardef = new StringBuilder();
            vardef.append(ppackagename);
            vardef.append(classname);
            if (("masterref".equals(this.targetitemtype) || "storeref".equals(this.targetitemtype)) && rel != null && "check".equals(rel.getType())) {
                vardef.append("[]");
                isCheckboxFlag = true;
            }
            vardef.append(" ");
            vardef.append("__" + name0);
            if (!this.declareVarSet.contains(vardef.toString())) {
                String restrict;
                this.declareVarSet.add(vardef.toString());
                this.preformula.add(vardef.toString() + " =");
                StringBuilder _sb = new StringBuilder();
                _sb.append("(").append(name1).append(" != null) ? ");
                _sb.append(AppSchemaUtil.getHelperClassname4Dicon(pmodel, HelperGenerator_calc_operation.this.project));
                _sb.append(".").append(JavaSourceGenerator.getterMethod(classname));
                if (rel != null && "radio".equals(rel.getType())) {
                    _sb.append("_show_single(");
                } else if (rel != null && "check".equals(rel.getType())) {
                    _sb.append("_update(");
                } else {
                    _sb.append("_show(");
                }
                boolean isCheckRelation = AppSchemaUtil.isCheckRelation(mitem);
                boolean isNoselection = false;
                if (isCheckRelation && this.model.getType().equals("condition")) {
                    Model srcm = (Model)this.model.getIdrefAsIRNode();
                    Modelitem srcmi = AppSchemaUtil.getModelitem(mitem.getName(), srcm);
                    if (srcmi != null && StringUtils.isNotBlank((CharSequence)AppSchemaUtil.getNoselection(srcmi, srcm, HelperGenerator_calc_operation.this.project))) {
                        isNoselection = true;
                    }
                }
                Object[] _realfields = StringUtils.isNotEmpty((CharSequence)mitem.getRealfield()) ? mitem.getRealfield().split(",") : null;
                Model rmodel = rel != null ? (Model)rel.getIdrefAsIRNode() : null;
                PrimaryKey[] r_pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(rmodel, HelperGenerator_calc_operation.this.project);
                if (r_pkeys != null && r_pkeys.length <= 1) {
                    String mitem_type;
                    boolean isBasicType;
                    Modelitem rfield;
                    boolean isMust = false;
                    if (ArrayUtils.isNotEmpty((Object[])_realfields) && !"condition".equals(rmodel.getType()) && (rfield = AppSchemaUtil.getModelitem((String)_realfields[0], rmodel)) != null && rfield.getMust()) {
                        isMust = true;
                    }
                    if ((isBasicType = JavaSourceGenerator.isBasicType(mitem_type = AppSchemaUtil.getModelitemType(HelperGenerator_calc_operation.this.project, rmodel.getId(), mitem, "roleid"))) && !isCheckRelation && !isMust) {
                        _sb.append(JavaSourceGenerator.getterFullMethodAsObject(name1, name0, mitem_type));
                    } else {
                        _sb.append(name1);
                        _sb.append(JavaSourceGenerator.getterFullMethod(name0));
                    }
                    _sb.append(", ");
                } else if (r_pkeys != null) {
                    for (int i = 0; i < r_pkeys.length; ++i) {
                        Modelitem rfield;
                        boolean isMust = false;
                        if (ArrayUtils.isNotEmpty((Object[])_realfields) && !"condition".equals(rmodel.getType()) && (rfield = AppSchemaUtil.getModelitem((String)_realfields[i], rmodel)) != null && rfield.getMust()) {
                            isMust = true;
                        }
                        String pkey_name = AppSchemaUtil.createFullPrimaryKeyName(r_pkeys[i]);
                        String pkey_type = AppSchemaUtil.getPkeyType(rmodel, pkey_name, "int", HelperGenerator_calc_operation.this.project);
                        boolean isBasicType = JavaSourceGenerator.isBasicType(pkey_type);
                        String _name = AppSchemaUtil.getChildPart(mitem.getName()) + "_" + pkey_name;
                        if (isBasicType && !isCheckRelation && !isMust) {
                            _sb.append(JavaSourceGenerator.getterFullMethodAsObject(name1, _name, pkey_type));
                        } else {
                            _sb.append(name1);
                            _sb.append(JavaSourceGenerator.getterFullMethod(_name));
                        }
                        _sb.append(", ");
                    }
                }
                if (isNoselection) {
                    _sb.append(name1).append(".getNoselectionJshparam(), ");
                }
                String string = restrict = rel != null ? rel.getRestrict() : null;
                if (StringUtils.isNotBlank((CharSequence)restrict)) {
                    Modelitem restrict_item = AppSchemaUtil.getModelitem(restrict, this.model);
                    if (restrict_item == null) {
                        Object[] o = new Object[]{this.id, mitem.getName(), restrict};
                        logger.error(HelperGenerator_calc_operation.this.rman.getValue("helper.invalid.autocalc.restrict.null", o));
                    } else {
                        String mitem_type_restrict = AppSchemaUtil.getModelitemType(HelperGenerator_calc_operation.this.project, this.model.getId(), restrict_item, "roleid");
                        boolean isBasicType_restrict = JavaSourceGenerator.isBasicType(mitem_type_restrict);
                        boolean isCheckRelation_restrict = AppSchemaUtil.isCheckRelation(restrict_item);
                        String _cname = AppSchemaUtil.getChildPart(restrict_item.getName());
                        if (isBasicType_restrict && !isCheckRelation_restrict && !restrict_item.getMust()) {
                            _sb.append(JavaSourceGenerator.getterFullMethodAsObject(name1, _cname, mitem_type_restrict));
                        } else {
                            _sb.append(name1);
                            _sb.append(JavaSourceGenerator.getterFullMethod(_cname));
                        }
                        _sb.append(", ");
                    }
                } else if (rel != null && ArrayUtils.isNotEmpty((Object[])AppSchemaUtil.getRestrictparam(rel.getRestrictparamlist())) && "check".equals(rel.getType())) {
                    if (Arrays.stream(AppSchemaUtil.getRestrictparam(rel.getRestrictparamlist())).anyMatch(rparam -> AppSchemaUtil.hasChildPart(rparam.getSource()))) {
                        _sb.append(this.id).append(", ");
                    }
                    _sb.append(name1);
                    _sb.append(", ");
                }
                _sb.append("p) : null;");
                this.preformula.add(_sb.toString());
            }
            if (isCheckboxFlag && !(this instanceof CalcProcess_Func) && !this.mode_array) {
                String innerClassName = classname + "Chooser";
                boolean hasAlreadyDeclaredFlag = false;
                for (String st : this.preformula) {
                    if (!st.startsWith("class " + innerClassName)) continue;
                    hasAlreadyDeclaredFlag = true;
                    break;
                }
                if (!hasAlreadyDeclaredFlag) {
                    Modelitem __r_pkey_item;
                    PrimaryKey[] __r_pkeys;
                    Model __rmodel;
                    Relation __r;
                    this.preformula.add("class " + innerClassName + " {");
                    this.preformula.add("    " + ppackagename + classname + "[] getItems(" + ppackagename + classname + "[] _items) {");
                    this.preformula.add("        List<" + ppackagename + classname + "> _list = new ArrayList<" + ppackagename + classname + ">();");
                    this.preformula.add("        if (_items != null) {");
                    this.preformula.add("            for (" + ppackagename + classname + " _item : _items) {");
                    this.preformula.add("                if (_item.getChoose()) {");
                    this.preformula.add("                    _list.add(_item);");
                    this.preformula.add("                }");
                    this.preformula.add("            }");
                    this.preformula.add("        }");
                    this.preformula.add("        return _list.toArray(new " + ppackagename + classname + "[0]);");
                    this.preformula.add("    }");
                    this.preformula.add("    " + ppackagename + classname + " getItem(" + ppackagename + classname + "[] _items) {");
                    this.preformula.add("        if (_items != null) {");
                    this.preformula.add("            for (" + ppackagename + classname + " _item : _items) {");
                    this.preformula.add("                if (_item.getChoose()) {");
                    this.preformula.add("                    return _item;");
                    this.preformula.add("                }");
                    this.preformula.add("            }");
                    this.preformula.add("        }");
                    this.preformula.add("        return new " + ppackagename + classname + "();");
                    this.preformula.add("    }");
                    this.preformula.add("}");
                    String innerClassNameCollection = classname + "Collection";
                    String paramname = "__" + AppSchemaUtil.getChildPart(this.sitem.getName());
                    String vname = "_ret_" + AppSchemaUtil.getChildPart(this.sitem.getName());
                    String stype = JavaSourceGenerator.getProperType(HelperGenerator_calc_operation.this.type);
                    if (stype == null || this.mode_content) {
                        stype = "String";
                    }
                    if ((__r = AppSchemaUtil.getRelationTypeExceptRef(this.sitem)) != null && "check".equals(__r.getType()) && (__rmodel = AppSchemaUtil.getModel(HelperGenerator_calc_operation.this.project, __r.getIdref())) != null && (__r_pkeys = AppSchemaUtil.getPrimaryKey(__rmodel)) != null && (__r_pkey_item = AppSchemaUtil.getModelitem(__r_pkeys[0].getName(), __rmodel)) != null) {
                        stype = JavaSourceGenerator.getProperType(AppSchemaUtil.getModelitemType(__rmodel.getId(), __r_pkey_item, "roleid", false));
                    }
                    String _getter = this.getter4presentationWithCompositeKey == null ? ".getId()" : this.getter4presentationWithCompositeKey[this.mode_id_suffix_no - 1];
                    this.preformula.add("class " + innerClassNameCollection + " {");
                    this.preformula.add("    " + stype + "[] apply(" + ppackagename + classname + "[] " + paramname + ") {");
                    this.preformula.add("        " + stype + "[] " + vname + " = new " + stype + "[0];");
                    this.preformula.add("        for (" + ppackagename + classname + " _obj : (new " + innerClassName + "().getItems(" + paramname + "))) {");
                    this.preformula.add("            " + vname + " = (" + stype + "[])org.apache.commons.lang3.ArrayUtils.add(" + vname + ", _obj" + _getter + ");");
                    this.preformula.add("        }");
                    this.preformula.add("        return " + vname + ";");
                    this.preformula.add("    }");
                    this.preformula.add("}");
                }
            }
        }

        protected void process0_masterref(String name0, String name1) {
            Modelitem mitem = AppSchemaUtil.getModelitem(name0, this.model);
            this.formula.append(this.processMasterref(mitem, "__" + name0));
        }

        protected String processMasterref(Modelitem mitem, String name0) {
            Relation rel = AppSchemaUtil.getRelationTypeExceptRef(mitem);
            StringBuilder __sb = new StringBuilder();
            if (rel != null && "check".equals(rel.getType()) && !this.mode_array) {
                String classname = AppSchemaUtil.getModelitemClassname(mitem);
                String innerClassName = classname + "Chooser";
                if (!this.mode_id && !this.mode_content) {
                    __sb.append("StringUtil.intValue(");
                } else {
                    __sb.append("(");
                }
                __sb.append("new ").append(innerClassName).append("().getItem(");
                __sb.append(name0);
                __sb.append(")");
                if (this.mode_id || this.mode_content) {
                    if (this.mode_id) {
                        String _getter = this.getter4presentationWithCompositeKey == null ? ".getId()" : this.getter4presentationWithCompositeKey[this.mode_id_suffix_no - 1];
                        __sb.append(_getter);
                    } else if (this.mode_content) {
                        __sb.append(".getContent()");
                    }
                } else {
                    __sb.append(".getContent()");
                }
                __sb.append(")");
                return __sb.toString();
            }
            if (this.mode_array) {
                __sb.append(name0);
            } else if (this.mode_id || this.mode_content) {
                __sb.append("((" + name0 + " != null) ? ");
                __sb.append(name0);
                if (this.mode_id) {
                    String _getter = this.getter4presentationWithCompositeKey == null ? ".getId()" : this.getter4presentationWithCompositeKey[this.mode_id_suffix_no - 1];
                    __sb.append(_getter);
                    __sb.append(" : 0)");
                } else if (this.mode_content) {
                    __sb.append(".getContent() : \"\")");
                }
            } else {
                __sb.append("((" + name0 + " != null) ? ");
                __sb.append("StringUtil.intValue(");
                __sb.append(name0);
                __sb.append(".getContent()) : 0)");
            }
            return __sb.toString();
        }

        protected void process0_storeref(Modelitem mitem, String name0) {
            String s = this.processStoreref(mitem, "__" + name0, false);
            if (StringUtils.isNotBlank((CharSequence)s)) {
                this.formula.append(s);
            }
        }

        protected String processStoreref(Modelitem mitem, String name0) {
            return this.processStoreref(mitem, name0, false);
        }

        protected String processStoreref(Modelitem mitem, String name0, boolean useBigDecimalFlag) {
            String _getter;
            IRNode node;
            Relation rel = AppSchemaUtil.getRelationTypeExceptRef(mitem);
            StringBuilder __sb = new StringBuilder();
            if (rel != null && "check".equals(rel.getType()) && !this.mode_array) {
                String _getter2;
                Model pmodel = AppSchemaUtil.getModel(HelperGenerator_calc_operation.this.project, this.id, "presentation");
                if (pmodel == null) {
                    return "";
                }
                String classname = AppSchemaUtil.getModelitemClassname(mitem);
                String innerClassName = classname + "Chooser";
                boolean isMultiple = false;
                if (this.sitem.getMultiple() && !this.sitem.getHasChild()) {
                    isMultiple = true;
                } else {
                    Relation __r = AppSchemaUtil.getRelationTypeExceptRef(this.sitem);
                    if (__r != null && "check".equals(__r.getType())) {
                        isMultiple = true;
                        Model __rmodel = AppSchemaUtil.getModel(HelperGenerator_calc_operation.this.project, __r.getIdref());
                        if (__rmodel == null) {
                            return "";
                        }
                        PrimaryKey[] __r_pkeys = AppSchemaUtil.getPrimaryKey(__rmodel);
                        if (__r_pkeys == null) {
                            return "";
                        }
                        if (__r_pkeys.length > 1) {
                            logger.error(HelperGenerator_calc_operation.this.rman.getValue("helper.invalid.chooser.compositekey", new Object[]{this.id, this.sitem.getName(), __rmodel.getId()}));
                            return "";
                        }
                        Modelitem __r_pkey_item = AppSchemaUtil.getModelitem(__r_pkeys[0].getName(), __rmodel);
                        if (__r_pkey_item == null) {
                            return "";
                        }
                    }
                }
                String string = _getter2 = this.getter4presentationWithCompositeKey == null ? ".getId()" : this.getter4presentationWithCompositeKey[this.mode_id_suffix_no - 1];
                if (!isMultiple) {
                    __sb.append("new ").append(innerClassName).append("().getItem(");
                    __sb.append(name0);
                    __sb.append(")");
                    if (this.mode_id || this.mode_content) {
                        if (this.mode_id) {
                            __sb.append(_getter2);
                        } else if (this.mode_content) {
                            __sb.append(".getContent()");
                        }
                    } else {
                        __sb.append(".getContent()");
                    }
                } else {
                    String innerClassNameCollection = classname + "Collection";
                    __sb.append("new ").append(innerClassNameCollection).append("().apply(");
                    __sb.append(name0).append(")");
                }
                return __sb.toString();
            }
            Model rmodel = null;
            IRNode iRNode = node = rel != null ? rel.getIdrefAsIRNode() : null;
            if (node != null && node instanceof Model) {
                rmodel = (Model)node;
            }
            if (rmodel == null) {
                return "";
            }
            Modelitem ritem = null;
            String rtargetitemtype = null;
            String _target = null;
            if (rel != null && "ref".equals(rel.getType())) {
                _target = rel.getName();
            } else if (rel != null) {
                if (this.mode_id) {
                    String[] tokens;
                    _target = AppSchemaUtil.getRoleid(rel, HelperGenerator_calc_operation.this.project);
                    if (_target.indexOf(PrimaryKeyUtils.PKEY_SEPARATOR()) > 0 && this.mode_id_suffix_no > 0 && this.mode_id_suffix_no <= (tokens = _target.split(PrimaryKeyUtils.PKEY_SEPARATOR_REGEXP())).length) {
                        _target = tokens[this.mode_id_suffix_no - 1];
                    }
                } else {
                    _target = rel.getRolecontent();
                }
            }
            ritem = AppSchemaUtil.getModelitem(_target, rmodel);
            if (ritem == null) {
                Object[] o = new Object[]{this.id, mitem.getName(), _target};
                logger.error(HelperGenerator_calc_operation.this.rman.getValue("helper.invalid.autocalc.content.target.null", o));
                return null;
            }
            rtargetitemtype = null;
            rtargetitemtype = ritem.getType().equals("masterref") ? ritem.getType() : AppSchemaUtil.getModelitemType(HelperGenerator_calc_operation.this.project, rmodel.getId(), ritem, this.mode_content || !this.mode_id ? "rolecontent" : "roleid");
            if (this.mode_id && JavaSourceGenerator.isBasicType(rtargetitemtype)) {
                __sb.append("((" + name0 + " != null) ? ");
                String string = _getter = this.getter4presentationWithCompositeKey == null ? ".getId()" : this.getter4presentationWithCompositeKey[this.mode_id_suffix_no - 1];
                if (useBigDecimalFlag) {
                    __sb.append("new BigDecimal(").append(name0).append(_getter).append(")");
                } else {
                    __sb.append(name0);
                    __sb.append(_getter);
                }
                __sb.append(" : ");
                if (useBigDecimalFlag) {
                    __sb.append("BigDecimal.ZERO");
                } else {
                    __sb.append(JavaSourceGenerator.getValidValue(rtargetitemtype));
                }
                __sb.append(")");
            } else if (this.mode_array) {
                __sb.append(name0);
            } else {
                __sb.append("((" + name0 + " != null) ? ");
                if (useBigDecimalFlag) {
                    Object m = HelperGenerator_calc_operation.this.getProperConvMethod(rtargetitemtype, ritem, this.mode_id, this.mode_content);
                    if (((String)m).startsWith("StringUtil")) {
                        int _ptr = ((String)m).indexOf("(");
                        m = "new BigDecimal" + ((String)m).substring(_ptr);
                    }
                    __sb.append((String)m);
                } else {
                    __sb.append(HelperGenerator_calc_operation.this.getProperConvMethod(rtargetitemtype, ritem, this.mode_id, this.mode_content));
                }
                __sb.append(name0);
                if (this.mode_id) {
                    _getter = this.getter4presentationWithCompositeKey == null ? ".getId()" : this.getter4presentationWithCompositeKey[this.mode_id_suffix_no - 1];
                    __sb.append(_getter);
                    __sb.append(") : ");
                } else {
                    __sb.append(".getContent()) : ");
                }
                if (JavaSourceGenerator.isBasicType(rtargetitemtype)) {
                    if (useBigDecimalFlag) {
                        __sb.append("BigDecimal.ZERO");
                    } else {
                        __sb.append(JavaSourceGenerator.getValidValue(rtargetitemtype));
                    }
                } else if (JavaSourceGenerator.isStringType(rtargetitemtype)) {
                    __sb.append("\"\"");
                } else {
                    __sb.append("null");
                }
                __sb.append(")");
            }
            return __sb.toString();
        }

        public void setProcessedFlag() {
            this.setProcessedFlag(false);
        }

        public void setProcessedFlag(boolean forceOverrideFlag) {
            if (HelperGenerator_calc_operation.this.isMust_sitem || !forceOverrideFlag && HelperGenerator_calc_operation.this.outputSetProcessedFlag2True) {
                return;
            }
            if (!forceOverrideFlag) {
                for (String cs : this.preformula) {
                    if (cs.indexOf("_processed = true;") < 0) continue;
                    HelperGenerator_calc_operation.this.outputSetProcessedFlag2True = true;
                    return;
                }
            }
            String tab = HelperGenerator_calc_operation.getProperTab(this.preformula, false);
            StringBuilder _sb = new StringBuilder();
            _sb.append(tab);
            _sb.append("_processed = true;");
            this.preformula.add(_sb.toString());
            HelperGenerator_calc_operation.this.outputSetProcessedFlag2True = true;
        }

        public String getProperDateOrTimeTypeWrapperFunction(String type) {
            if (type == null) {
                return null;
            }
            if ("date".equals(type.toLowerCase())) {
                return "DATEVALUE";
            }
            if ("time".equals(type.toLowerCase())) {
                return "TIMEVALUE";
            }
            if ("datetime".equals(type.toLowerCase())) {
                return "DATETIMEVALUE";
            }
            return null;
        }
    }

    abstract class CalcProcess_FirstLast
    extends CalcProcess_Func {
        CalcProcess_FirstLast(String id, String s, String tname, String condition, StringBuilder formula, List<String> preformula, Modelitem sitem, Model model, Set<String> declareVarSet, Map<String, VariableStatus> varMap) {
            super(id, s, tname, condition, formula, preformula, sitem, model, declareVarSet, varMap);
        }

        public abstract String getIndexCode(String var1);

        public abstract String getForeignModelIndexCode(String var1);

        @Override
        boolean needsitemtypeCheck() {
            return false;
        }

        public String getLowerLimitOfArrayInMultiple(String name) {
            return this.getLowerLimitOfArray();
        }

        public String getLowerLimitOfArrayInContainer(String name) {
            return this.getLowerLimitOfArray();
        }

        public String getLowerLimitOfArrayInForeignModel(String name) {
            return this.getLowerLimitOfArray();
        }

        public String getNoExistContent() {
            return null;
        }

        public String getLimitValue4FirstOperation() {
            return "0";
        }

        public String getLimitValue4LastOperation() {
            return "length";
        }

        public String getIndexDeclareCode(String vname) {
            return null;
        }

        @Override
        public void multiple() {
            Modelitem multiple_item = AppSchemaUtil.getModelitem(this.org_tname, this.model);
            String multiple_type = AppSchemaUtil.getModelitemType(HelperGenerator_calc_operation.this.project, this.model.getId(), multiple_item);
            if (multiple_type == null) {
                multiple_type = this.sitemtype;
            }
            String vname = this.createVariableNameForResult(this.org_tname);
            StringBuilder _sb = null;
            this.addDeclareArrayVariableFromStoreModel(vname, this.targetitemtype, this.id, this.org_tname, multiple_item);
            _sb = new StringBuilder();
            _sb.append(JavaSourceGenerator.getProperType(multiple_type));
            _sb.append(" ");
            _sb.append(vname);
            _sb.append(" = ");
            if ("masterref".equals(multiple_type)) {
                _sb.append("0");
            } else {
                _sb.append(JavaSourceGenerator.getValidValue(multiple_type));
            }
            _sb.append(";");
            this.preformula.add(_sb.toString());
            String mtab = "";
            String _code = this.getIndexDeclareCode(vname + "_ary");
            if (_code != null) {
                this.preformula.add("{");
                this.preformula.add("    " + _code);
                mtab = "    ";
            }
            _sb = new StringBuilder();
            _sb.append("if (");
            _sb.append(vname + "_ary");
            _sb.append(" != null) {");
            this.preformula.add(mtab + _sb.toString());
            String ll_str = this.getLowerLimitOfArrayInMultiple(vname + "_ary");
            _sb = new StringBuilder();
            _sb.append("    ");
            _sb.append("if (" + vname + "_ary.");
            _sb.append(this.getLimitValue4LastOperation());
            _sb.append(" > ");
            _sb.append(this.getLimitValue4FirstOperation());
            if (!ll_str.equals("0")) {
                _sb.append(" && ");
                _sb.append(ll_str);
                _sb.append(" >= 0");
            }
            _sb.append(") {");
            this.preformula.add(mtab + _sb.toString());
            this.op_code0(vname + "_ary", this.org_tname, vname + "_ary", vname, multiple_type, null, this.model, null, null);
            _sb = new StringBuilder();
            _sb.append("    ");
            _sb.append("}");
            if (StringUtils.isNotBlank((CharSequence)this.condition)) {
                String _default = JavaSourceGenerator.getValidValue(JavaSourceGenerator.getProperType(multiple_type));
                this.preformula.add("        if (!_processed) {");
                this.preformula.add("            " + vname + " = " + _default + ";");
                this.setProcessedFlag(true);
                this.preformula.add("        }");
            }
            if (this.getNoExistContent() != null) {
                _sb.append(" else {");
                this.preformula.add(mtab + _sb.toString());
                _sb = new StringBuilder();
                _sb.append("        ");
                _sb.append(vname);
                _sb.append(" = ");
                _sb.append(this.getNoExistContent());
                _sb.append(";");
                this.preformula.add(mtab + _sb.toString());
                this.setProcessedFlag(true);
                _sb = new StringBuilder();
                _sb.append("    ");
                _sb.append("}");
            }
            this.preformula.add(mtab + _sb.toString());
            this.addMultipleFinishCode(vname + "_ary", vname, multiple_type);
            if (_code != null) {
                this.preformula.add(mtab + "}");
            }
            _sb = new StringBuilder();
            _sb.append("}");
            this.preformula.add(_sb.toString());
            this.formula.append(vname);
        }

        @Override
        public void addMultipleOperationCode(String tname, String vname, String multiple_type, String tab) {
            this.op_code0(tname, tname, vname, vname, multiple_type, null, this.model, null, null);
        }

        @Override
        public void container(String pname, String cname) {
            Modelitem container_item = AppSchemaUtil.getModelitem(pname + "/" + cname, this.model);
            String container_type = AppSchemaUtil.getModelitemType(this.model.getId(), container_item, this.rtype, true);
            if (container_type == null) {
                container_type = this.sitemtype;
            }
            Modelitem p_mitem = AppSchemaUtil.getModelitem(pname, this.model);
            String p_classname = AppSchemaUtil.getModelitemClassname(p_mitem);
            String vname = this.createVariableNameForResult(pname);
            StringBuilder _sb = null;
            this.addDeclareArrayVariableFromStoreModel(vname, p_classname, this.id, pname, container_item);
            _sb = new StringBuilder();
            _sb.append(JavaSourceGenerator.getProperType(container_type));
            _sb.append(" ");
            _sb.append(vname);
            _sb.append(" = ");
            if ("masterref".equals(container_type)) {
                _sb.append("0");
            } else {
                _sb.append(JavaSourceGenerator.getValidValue(container_type));
            }
            _sb.append(";");
            this.preformula.add(_sb.toString());
            String mtab = "";
            String _code = this.getIndexDeclareCode(vname + "_ary");
            if (_code != null) {
                this.preformula.add("{");
                this.preformula.add("    " + _code);
                mtab = "    ";
            }
            _sb = new StringBuilder();
            _sb.append("if (");
            _sb.append(vname + "_ary");
            _sb.append(" != null) {");
            this.preformula.add(mtab + _sb.toString());
            String ll_str = this.getLowerLimitOfArrayInContainer(vname + "_ary");
            _sb = new StringBuilder();
            _sb.append("    ");
            _sb.append("if (" + vname + "_ary.");
            _sb.append(this.getLimitValue4LastOperation());
            _sb.append(" > ");
            _sb.append(this.getLimitValue4FirstOperation());
            if (!ll_str.equals("0")) {
                _sb.append(" && ");
                _sb.append(ll_str);
                _sb.append(" >= 0");
            }
            _sb.append(") {");
            this.preformula.add(mtab + _sb.toString());
            String idx_code = this.getIndexCode(vname + "_ary");
            if (!(HelperGenerator_calc_operation.this.isMust || this.needsPresentationModel || !JavaSourceGenerator.isBasicType(container_type) || "_i".equals(idx_code) || container_item.getAutokey())) {
                _sb = new StringBuilder();
                _sb.append("        ");
                _sb.append("if (");
                _sb.append(vname + "_ary[");
                _sb.append(idx_code);
                _sb.append("]");
                _sb.append(JavaSourceGenerator.checkFullMethod(cname));
                _sb.append(") {");
                this.preformula.add(mtab + _sb.toString());
            }
            this.addContainerOperationCode(vname + "_ary", pname, cname, vname, HelperGenerator_calc_operation.this.type, null, this.model);
            if (!(HelperGenerator_calc_operation.this.isMust || this.needsPresentationModel || !JavaSourceGenerator.isBasicType(container_type) || "_i".equals(idx_code) || container_item.getAutokey())) {
                _sb = new StringBuilder();
                _sb.append("        ");
                _sb.append("}");
                this.preformula.add(mtab + _sb.toString());
            }
            if (StringUtils.isNotBlank((CharSequence)this.condition)) {
                String _default = JavaSourceGenerator.getValidValue(JavaSourceGenerator.getProperType(HelperGenerator_calc_operation.this.type));
                this.preformula.add("        if (!_processed) {");
                this.preformula.add("            " + vname + " = " + _default + ";");
                this.setProcessedFlag(true);
                this.preformula.add("        }");
            }
            _sb = new StringBuilder();
            _sb.append("    ");
            _sb.append("}");
            if (this.getNoExistContent() != null) {
                _sb.append(" else {");
                this.preformula.add(mtab + _sb.toString());
                _sb = new StringBuilder();
                _sb.append("        ");
                _sb.append(vname);
                _sb.append(" = ");
                _sb.append(this.getNoExistContent());
                _sb.append(";");
                this.preformula.add(mtab + _sb.toString());
                this.setProcessedFlag(true);
                _sb = new StringBuilder();
                _sb.append("    ");
                _sb.append("}");
            }
            this.preformula.add(mtab + _sb.toString());
            this.addContainerFinishCode(vname + "_ary", vname, HelperGenerator_calc_operation.this.type);
            if (_code != null) {
                this.preformula.add(mtab + "}");
            }
            _sb = new StringBuilder();
            _sb.append("}");
            this.preformula.add(_sb.toString());
            this.formula.append(vname);
        }

        @Override
        public void addContainerOperationCode(String pname, String cname, String vname, String container_type) {
            this.addContainerOperationCode(null, pname, cname, vname, container_type, null, this.model);
        }

        public void addContainerOperationCode(String ary_name, String pname, String cname, String vname, String container_type, String tname, Model model) {
            this.op_code0(ary_name, pname, cname, vname, container_type, tname, model, null, null);
        }

        private void op_code0(String ary_name, String pname, String cname, String vname, String container_type, String tname, Model model, String s_varname, String checkCode) {
            String _sitemname;
            boolean useTargetObject;
            String tab = HelperGenerator_calc_operation.getProperTab(this.preformula);
            StringBuilder _sb = new StringBuilder();
            _sb.append(tab);
            boolean foreignModelMode = false;
            if (ary_name.endsWith("_p")) {
                foreignModelMode = true;
            }
            Object mtab = "";
            if (StringUtils.isNotBlank((CharSequence)this.condition)) {
                Object[] _expressions = null;
                try {
                    _expressions = this.parsePlaceHolderInOperator(this.condition, pname, (String)(foreignModelMode ? s_varname : ary_name + "[_i]"), model);
                }
                catch (Exception e) {
                    Object[] o = new Object[]{model.getId(), pname, this.getType(), this.condition, e.getMessage()};
                    logger.error(HelperGenerator_calc_operation.this.rman.getValue("expr.invalid.autocalc.condition", o));
                    return;
                }
                if (ArrayUtils.isNotEmpty((Object[])_expressions) && StringUtils.isNotBlank((CharSequence)((ExpandExpression)_expressions[0]).content)) {
                    if (!foreignModelMode) {
                        if ("first".equals(this.getType())) {
                            _sb.append("for (int _i=0; _i<").append(ary_name).append(".length; _i++) {");
                        } else if ("last".equals(this.getType())) {
                            _sb.append("for (int _i=").append(ary_name).append(".length-1; _i>=0; --_i) {");
                        }
                        this.preformula.add(_sb.toString());
                    }
                    if (checkCode != null) {
                        this.preformula.add("    " + checkCode);
                        mtab = (String)mtab + "    ";
                    }
                    this.addCondition((ExpandExpression[])_expressions, model, pname, "", (String)(foreignModelMode ? s_varname : ary_name + "[_i]"), tab + (String)mtab);
                    mtab = (String)mtab + "        ";
                    _sb = new StringBuilder();
                    _sb.append(tab + (String)mtab);
                }
            } else if (checkCode != null) {
                _sb.append(checkCode);
                this.preformula.add(checkCode);
                mtab = "    ";
                _sb = new StringBuilder();
                _sb.append(tab + (String)mtab);
            }
            if (this.needsPresentationModel && (!this.mode_ref || this.mode_ref_multiple)) {
                _sb.append("if (");
                _sb.append(ary_name);
                if (!ary_name.endsWith("_p")) {
                    _sb.append("[");
                    _sb.append(this.getIndexCode(ary_name));
                    _sb.append("]");
                }
                if (tname == null && AppSchemaUtil.hasChildPart(this.org_tname)) {
                    _sb.append(JavaSourceGenerator.getterFullMethod(AppSchemaUtil.getChildPart(this.org_tname)));
                } else if (tname != null) {
                    _sb.append(JavaSourceGenerator.getterFullMethod(tname));
                }
                _sb.append(".length > 0) {");
                this.preformula.add(_sb.toString());
                _sb = new StringBuilder();
                _sb.append(tab + "    " + (String)mtab);
            }
            boolean bl = useTargetObject = this.needsPresentationModel && (!this.mode_ref || this.mode_ref_multiple);
            if (useTargetObject) {
                String _packagename = AppSchemaUtil.getPackagename(this.pmodel, HelperGenerator_calc_operation.this.project);
                Modelitem _targetitem = AppSchemaUtil.getModelitem(cname, model);
                _sb.append("for (");
                _sb.append(_packagename);
                _sb.append(AppSchemaUtil.getModelitemClassname(_targetitem));
                _sb.append(" __target : ");
                _sb.append(ary_name);
                if (!ary_name.endsWith("_p")) {
                    _sb.append("[");
                    _sb.append(this.getIndexCode(ary_name));
                    _sb.append("]");
                }
                _sb.append(JavaSourceGenerator.getterFullMethod(cname));
                _sb.append(") {");
                this.preformula.add(_sb.toString());
                _sb = new StringBuilder();
                _sb.append(tab + "        " + (String)mtab);
                _sb.append("if (__target.getChoose()) {");
                this.preformula.add(_sb.toString());
                _sb = new StringBuilder();
                _sb.append(tab + "            " + (String)mtab);
            }
            _sb.append(vname);
            _sb.append(" = ");
            boolean isAddConvertFunction = false;
            if (this.needsPresentationModel && this.mode_ref && ary_name.endsWith("_p")) {
                isAddConvertFunction = this.addConvertFunction4Ref(this.refitemtype, useTargetObject, container_type, _sb);
            }
            String reftype = null;
            if (useTargetObject) {
                if ("masterref".equals(this.targetitemtype)) {
                    _sb.append(this.processMasterref(this.targetitem, "__target"));
                } else if ("storeref".equals(this.targetitemtype)) {
                    _sb.append(this.processStoreref(this.targetitem, "__target"));
                } else if (this.mode_id) {
                    _sb.append("__target.getId()");
                    reftype = AppSchemaUtil.getModelitemType(HelperGenerator_calc_operation.this.project, model.getId(), this.targetitem, "roleid");
                } else {
                    _sb.append("__target.getContent()");
                    reftype = AppSchemaUtil.getModelitemType(HelperGenerator_calc_operation.this.project, model.getId(), this.targetitem, "rolecontent");
                }
                if (isAddConvertFunction) {
                    _sb.append(")");
                }
            } else {
                _sb.append(ary_name);
                if (!ary_name.endsWith("_p")) {
                    _sb.append("[");
                    _sb.append(this.getIndexCode(ary_name));
                    _sb.append("]");
                }
                if (tname == null && AppSchemaUtil.hasChildPart(this.org_tname)) {
                    _sb.append(JavaSourceGenerator.getterFullMethod(AppSchemaUtil.getChildPart(this.org_tname)));
                } else if (tname != null) {
                    _sb.append(JavaSourceGenerator.getterFullMethod(tname));
                }
                if (this.needsPresentationModel) {
                    if (this.mode_id) {
                        String _getter = this.getter4presentationWithCompositeKey == null ? ".getId()" : this.getter4presentationWithCompositeKey[this.mode_id_suffix_no - 1];
                        _sb.append(_getter);
                    } else if (this.mode_content) {
                        _sb.append(".getContent()");
                    } else {
                        _sb.append(".getContent()");
                    }
                    if (isAddConvertFunction) {
                        _sb.append(")");
                    }
                }
            }
            _sb.append(";");
            if (reftype != null && !HelperGenerator_calc_operation.this.isMatchType(reftype, container_type)) {
                _sb.append("/* type mismatch : reftype=" + reftype + "," + cname + ".type=" + container_type + " */");
                Object[] o = new Object[]{this.id, this.sitem.getName(), model.getId() + "." + this.targetitem.getName(), reftype, container_type};
                logger.error(HelperGenerator_calc_operation.this.rman.getValue("helper.invalid.autocalc.content.mismatch", o));
            }
            this.preformula.add(_sb.toString());
            this.setProcessedFlag(true);
            boolean isOutputBreakStatement = false;
            if (StringUtils.isNotBlank((CharSequence)this.condition)) {
                _sb = new StringBuilder();
                _sb.append(tab + (String)mtab);
                _sb.append("break;");
                this.preformula.add(_sb.toString());
                isOutputBreakStatement = true;
            }
            if (useTargetObject) {
                if (!isOutputBreakStatement) {
                    _sb = new StringBuilder();
                    _sb.append(tab + "            " + (String)mtab);
                    _sb.append("break;");
                    this.preformula.add(_sb.toString());
                }
                _sb = new StringBuilder();
                _sb.append(tab + "        " + (String)mtab);
                _sb.append("}");
                this.preformula.add(_sb.toString());
                _sb = new StringBuilder();
                _sb.append(tab + "    " + (String)mtab);
                _sb.append("}");
                this.preformula.add(_sb.toString());
            }
            boolean isOutputReturnNullCode = false;
            if (this.needsPresentationModel && (!this.mode_ref || this.mode_ref_multiple)) {
                _sb = new StringBuilder();
                _sitemname = this.sitem.getName();
                if (!this.sitem.getTransient() && ("last".equals(this.getType()) || "slice".equals(this.getType())) && !AppSchemaUtil.hasChildPart(_sitemname)) {
                    _sb.append(tab + (String)mtab);
                    _sb.append("} else {");
                    this.preformula.add(_sb.toString());
                    _sb = new StringBuilder();
                    _sb.append(tab + (String)mtab + "    ");
                    _sb.append(this.id).append(".");
                    _sb.append(JavaSourceGenerator.setterMethod(_sitemname) + "(null);");
                    this.preformula.add(_sb.toString());
                    _sb = new StringBuilder();
                    _sb.append(tab + (String)mtab);
                    _sb.append("}");
                    this.preformula.add(_sb.toString());
                    isOutputReturnNullCode = true;
                } else {
                    _sb.append(tab + (String)mtab);
                    _sb.append("}");
                    this.preformula.add(_sb.toString());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)this.condition)) {
                if (checkCode != null) {
                    _sitemname = this.sitem.getName();
                    mtab = ((String)mtab).substring(0, ((String)mtab).length() - 4);
                    if (!this.sitem.getTransient() && ("last".equals(this.getType()) || "slice".equals(this.getType())) && StringUtils.isBlank((CharSequence)this.getNoExistContent()) && !isOutputReturnNullCode && !AppSchemaUtil.hasChildPart(_sitemname)) {
                        this.preformula.add(tab + (String)mtab + "} else {");
                        _sb = new StringBuilder();
                        _sb.append(tab + (String)mtab + "    ");
                        _sb.append(this.id).append(".");
                        _sb.append(JavaSourceGenerator.setterMethod(_sitemname) + "(null);");
                        this.preformula.add(_sb.toString());
                    } else {
                        this.preformula.add(tab + (String)mtab + "}");
                    }
                }
                mtab = ((String)mtab).substring(0, ((String)mtab).length() - 4);
                this.preformula.add(tab + (String)mtab + "}");
                if (!foreignModelMode) {
                    this.preformula.add(tab + "}");
                }
            } else {
                if (checkCode != null) {
                    this.preformula.add(tab + "}");
                }
                _sitemname = this.sitem.getName();
                if (!this.sitem.getTransient() && ("last".equals(this.getType()) || "slice".equals(this.getType())) && StringUtils.isBlank((CharSequence)this.getNoExistContent()) && !isOutputReturnNullCode && !AppSchemaUtil.hasChildPart(_sitemname)) {
                    String _tab = tab.substring(0, tab.length() - 4);
                    this.preformula.add(_tab + "} else {");
                    _sb = new StringBuilder();
                    _sb.append(_tab + "    ");
                    _sb.append(this.id).append(".");
                    _sb.append(JavaSourceGenerator.setterMethod(_sitemname) + "(null);");
                    this.preformula.add(_sb.toString());
                }
            }
        }

        @Override
        public void foreignmodel(Model _rmodel) {
            if (!this.isForeignModel) {
                return;
            }
            Model _smodel = AppSchemaUtil.getStoreModel(_rmodel);
            String _smodel_id = _smodel.getId();
            String _s_varname = _smodel_id + "_ary";
            Model _refmodel_store = AppSchemaUtil.getStoreModel(_rmodel);
            String _refmodel_itemname = HelperGenerator_calc_operation.getModelItemNamePart(this.org_tname);
            String _refmodel_id = _refmodel_store.getId();
            String vname = "__" + _refmodel_itemname + "_" + this.getType();
            Modelitem _refmodel_item = AppSchemaUtil.getModelitem(_refmodel_itemname, _refmodel_store);
            String _refmodel_item_rawtype = _refmodel_item.getType();
            String _refmodel_item_type = null;
            _refmodel_item_type = "masterref".equals(_refmodel_item_rawtype) ? (this.mode_id || !this.mode_id && !this.mode_content ? "int" : "String") : (this.mode_ref ? this.sitemtype : (this.mode_content ? AppSchemaUtil.getModelitemType(HelperGenerator_calc_operation.this.project, _refmodel_id, _refmodel_item, "rolecontent", true) : AppSchemaUtil.getModelitemType(HelperGenerator_calc_operation.this.project, _refmodel_id, _refmodel_item, "roleid")));
            this.addForeignModelGetObject(_smodel, _rmodel);
            this.addForeignModelTmpvarDefinition(vname, _refmodel_item_type);
            StringBuilder _sb = null;
            _sb = new StringBuilder();
            _sb.append(JavaSourceGenerator.getProperType(_refmodel_item_type));
            _sb.append(" ");
            _sb.append(vname);
            _sb.append(" = ");
            if ("masterref".equals(_refmodel_item_type)) {
                _sb.append("0");
            } else {
                _sb.append(JavaSourceGenerator.getValidValue(_refmodel_item_type));
            }
            _sb.append(";");
            this.preformula.add(_sb.toString());
            String _code = this.getIndexDeclareCode(_refmodel_id + "_ary");
            if (_code != null) {
                this.preformula.add(_code);
            }
            _sb = new StringBuilder();
            _sb.append("if (");
            if (!HelperGenerator_calc_operation.this.isMust && !HelperGenerator_calc_operation.this.outputSetProcessedFlag2True) {
                _sb.append("!_processed && ");
            }
            _sb.append(_refmodel_id + "_ary");
            _sb.append(" != null) {");
            this.preformula.add(_sb.toString());
            String ll_str = this.getLowerLimitOfArrayInContainer(_refmodel_id + "_ary");
            _sb = new StringBuilder();
            _sb.append("    ");
            _sb.append("if (" + _refmodel_id + "_ary.");
            _sb.append(this.getLimitValue4LastOperation());
            _sb.append(" > ");
            _sb.append(this.getLimitValue4FirstOperation());
            if (!ll_str.equals("0")) {
                _sb.append(" && ");
                _sb.append(ll_str);
                _sb.append(" >= 0");
            }
            _sb.append(") {");
            this.preformula.add(_sb.toString());
            this.addForeignModelReadyCode();
            boolean outputForLoop = false;
            String mtab = "";
            if (this.needsPresentationModel) {
                if (StringUtils.isNotBlank((CharSequence)this.condition)) {
                    _sb = new StringBuilder();
                    _sb.append("        ");
                    if ("first".equals(this.getType())) {
                        _sb.append("for (int _i=0; _i<").append(_s_varname).append(".length; _i++) {");
                    } else if ("last".equals(this.getType())) {
                        _sb.append("for (int _i=").append(_s_varname).append(".length-1; _i>=0; --_i) {");
                    }
                    this.preformula.add(_sb.toString());
                    outputForLoop = true;
                    mtab = "    ";
                }
                this.addForeignModelReadyPresentation4Child(_rmodel, _smodel, _refmodel_id + "_ary[" + this.getIndexCode(_refmodel_id + "_ary") + "]", _refmodel_id + "_p");
            } else {
                this.addForeignModelReadyPresentation4Child(_rmodel);
            }
            String checkCode = null;
            if (!HelperGenerator_calc_operation.this.isMust && !this.needsPresentationModel && JavaSourceGenerator.isBasicType(HelperGenerator_calc_operation.this.type)) {
                _sb = new StringBuilder();
                _sb.append("        " + mtab);
                _sb.append("if (");
                _sb.append(_refmodel_id + "_ary[");
                _sb.append(this.getIndexCode(_refmodel_id + "_ary"));
                _sb.append("]");
                _sb.append(JavaSourceGenerator.checkFullMethod(_refmodel_itemname));
                _sb.append(") {");
                checkCode = _sb.toString();
            }
            if (this.needsPresentationModel) {
                this.op_code0(_refmodel_id + "_p", _refmodel_id + "_p", _refmodel_itemname, vname, _refmodel_item_type, _refmodel_itemname, _smodel, _refmodel_id + "_p", null);
            } else {
                this.op_code0(_refmodel_id + "_ary", _refmodel_id + "_ary[" + this.getIndexCode(_refmodel_id + "_ary") + "]", _refmodel_itemname, vname, _refmodel_item_type, _refmodel_itemname, _smodel, _s_varname, checkCode);
            }
            if (outputForLoop) {
                _sb = new StringBuilder();
                _sb.append("        ");
                _sb.append("}");
                this.preformula.add(_sb.toString());
            }
            _sb = new StringBuilder();
            _sb.append("    ");
            _sb.append("}");
            if (StringUtils.isNotBlank((CharSequence)this.condition)) {
                String _default = JavaSourceGenerator.getValidValue(JavaSourceGenerator.getProperType(HelperGenerator_calc_operation.this.type));
                this.preformula.add("        if (!_processed) {");
                this.preformula.add("            " + vname + " = " + _default + ";");
                this.setProcessedFlag(true);
                this.preformula.add("        }");
            }
            if (this.getNoExistContent() != null) {
                _sb.append(" else {");
                this.preformula.add(_sb.toString());
                _sb = new StringBuilder();
                _sb.append("        ");
                _sb.append(vname);
                _sb.append(" = ");
                _sb.append(this.getNoExistContent());
                _sb.append(";");
                this.preformula.add(_sb.toString());
                this.setProcessedFlag(true);
                _sb = new StringBuilder();
                _sb.append("    ");
                _sb.append("}");
            }
            this.preformula.add(_sb.toString());
            this.addContainerFinishCode(_refmodel_id + "_ary", vname, HelperGenerator_calc_operation.this.type);
            _sb = new StringBuilder();
            _sb.append("}");
            this.preformula.add(_sb.toString());
            this.formula.append(vname);
        }

        @Override
        public void addMultipleFinishCode(String name, String vname, String multiple_type) {
        }

        @Override
        public void addContainerFinishCode(String pname, String vname, String container_type) {
        }

        @Override
        public void addForeignModelFinishCode(String pname, String vname) {
        }
    }

    abstract class CalcProcess_MaxMin
    extends CalcProcess_Sum {
        CalcProcess_MaxMin(String id, String s, String tname, String condition, StringBuilder formula, List<String> preformula, Modelitem sitem, Model model, Set<String> declareVarSet, Map<String, VariableStatus> varMap) {
            super(id, s, tname, condition, formula, preformula, sitem, model, declareVarSet, varMap);
        }

        @Override
        boolean needsitemtypeCheck() {
            return false;
        }

        @Override
        public void addMultipleTmpvarDefinition(String vname, String multiple_type) {
            StringBuilder _sb = new StringBuilder();
            String _type = this.getProperType(multiple_type);
            _sb.append(_type);
            _sb.append(" ");
            _sb.append(vname);
            _sb.append(" = ");
            _sb.append(this.getValidValue(multiple_type));
            _sb.append(";");
            this.preformula.add(_sb.toString());
        }

        @Override
        public void addContainerTmpvarDefinition(String vname, String container_type) {
            StringBuilder _sb = new StringBuilder();
            String _type = this.getProperType(container_type);
            _sb.append(_type);
            _sb.append(" ");
            _sb.append(vname);
            _sb.append(" = ");
            _sb.append(this.getValidValue(container_type));
            _sb.append(";");
            this.preformula.add(_sb.toString());
        }

        @Override
        public void addForeignModelTmpvarDefinition(String vname, String _refmodel_item_type) {
            StringBuilder _sb = new StringBuilder();
            _sb.append(_refmodel_item_type);
            _sb.append(" ");
            _sb.append(vname);
            _sb.append(" = ");
            _sb.append(this.getValidValue(_refmodel_item_type));
            _sb.append(";");
            this.preformula.add(_sb.toString());
        }

        @Override
        public void addMultipleReadyCode() {
            this.ready_code0();
        }

        @Override
        public void addContainerReadyCode() {
            this.ready_code0();
        }

        @Override
        public void addForeignModelReadyCode() {
            this.ready_code0();
        }

        protected void ready_code0() {
            StringBuilder _sb = new StringBuilder();
            _sb.append("    ");
            _sb.append("boolean firstFlag = true;");
            this.preformula.add(_sb.toString());
        }

        @Override
        public void addMultipleOperationCode(String tname, String vname, String multiple_type, String tab) {
            this.op_code0(tname, null, vname, multiple_type);
        }

        @Override
        public void addContainerOperationCode(String pname, String cname, String vname, String container_type) {
            this.op_code0(pname, cname, vname, container_type);
        }

        protected void op_code0(String pname, String cname, String vname, String type) {
            this.op_code0(pname, cname, vname, type, "[j]", this.model);
        }

        @Override
        protected void op_code0(String pname, String cname, String vname, String type, String pname_postfix, Model model) {
            String __targetobj = null;
            __targetobj = pname_postfix.length() > 0 ? vname + "_ary[j]" : pname + pname_postfix;
            String tab = HelperGenerator_calc_operation.getProperTab(this.preformula);
            StringBuilder _sb = new StringBuilder();
            _sb.append(tab);
            if (this.needsPresentationModel && (!this.mode_ref || this.mode_ref_multiple)) {
                _sb.append("if (");
                _sb.append(__targetobj);
                _sb.append(JavaSourceGenerator.getterFullMethod(cname));
                _sb.append(".length > ");
                _sb.append(this.getLowerLimitOfArray());
                _sb.append(") {");
                this.preformula.add(_sb.toString());
                _sb = new StringBuilder();
                _sb.append(tab + "    ");
            }
            String mtab = "";
            boolean isUseTargetChooseProcess = false;
            if (this.needsPresentationModel && (!this.mode_ref || this.mode_ref_multiple)) {
                String _packagename = AppSchemaUtil.getPackagename(this.pmodel, HelperGenerator_calc_operation.this.project);
                Modelitem _targetitem = AppSchemaUtil.getModelitem(cname, model);
                _sb.append("for (");
                _sb.append(_packagename);
                _sb.append(AppSchemaUtil.getModelitemClassname(_targetitem));
                _sb.append(" __target : ");
                _sb.append(__targetobj + JavaSourceGenerator.getterFullMethod(cname));
                _sb.append(") {");
                this.preformula.add(_sb.toString());
                _sb = new StringBuilder();
                _sb.append(tab + "        ");
                _sb.append("if (__target.getChoose()) {");
                this.preformula.add(_sb.toString());
                mtab = "            ";
                isUseTargetChooseProcess = true;
            }
            String ntab = "";
            boolean needsValueCheck = this.isNeedsValueCheck(cname, model);
            if (needsValueCheck && cname != null && !pname.endsWith("_p") && !isUseTargetChooseProcess && !HelperGenerator_calc_operation.this.isMust) {
                _sb.append("if (");
                _sb.append(__targetobj);
                _sb.append(JavaSourceGenerator.checkFullMethod(cname));
                _sb.append(") {");
                this.preformula.add(_sb.toString());
                ntab = "    ";
            }
            String __basetab = tab + mtab;
            this.op_code0_main(vname, type, pname, cname, pname_postfix, __targetobj, __basetab, ntab);
            if (needsValueCheck && cname != null && !pname.endsWith("_p") && !isUseTargetChooseProcess && !HelperGenerator_calc_operation.this.isMust) {
                _sb = new StringBuilder();
                _sb.append(tab + mtab);
                _sb.append("}");
                this.preformula.add(_sb.toString());
            }
            if (this.needsPresentationModel && (!this.mode_ref || this.mode_ref_multiple)) {
                _sb = new StringBuilder();
                _sb.append(tab + "            ");
                _sb.append("break;");
                this.preformula.add(_sb.toString());
                _sb = new StringBuilder();
                _sb.append(tab + "        ");
                _sb.append("}");
                this.preformula.add(_sb.toString());
                _sb = new StringBuilder();
                _sb.append(tab + "    ");
                _sb.append("}");
                this.preformula.add(_sb.toString());
            }
            if (this.needsPresentationModel && (!this.mode_ref || this.mode_ref_multiple)) {
                _sb = new StringBuilder();
                _sb.append(tab);
                _sb.append("}");
                this.preformula.add(_sb.toString());
            }
        }

        protected void op_code0_main(String vname, String type, String pname, String cname, String pname_postfix, String __targetobj, String basetab, String ntab) {
            String classname = this.getProperMathClassname(type);
            StringBuilder _sb = new StringBuilder();
            _sb.append(basetab + ntab);
            _sb.append("if (firstFlag) {");
            this.preformula.add(_sb.toString());
            String leftexpr = vname + " = ";
            String rightexpr = "";
            this.createMaxMinProperExpression(leftexpr, rightexpr, type, pname, cname, pname_postfix, __targetobj);
            _sb = new StringBuilder();
            _sb.append(basetab + ntab + "    ");
            _sb.append("firstFlag = false;");
            this.preformula.add(_sb.toString());
            _sb = new StringBuilder();
            _sb.append(basetab + ntab);
            _sb.append("} else {");
            this.preformula.add(_sb.toString());
            leftexpr = vname + " = " + classname + "." + this.getType() + "(" + vname + ", ";
            rightexpr = ")";
            this.createMaxMinProperExpression(leftexpr, rightexpr, type, pname, cname, pname_postfix, __targetobj);
            _sb = new StringBuilder();
            _sb.append(basetab + ntab);
            _sb.append("}");
            this.preformula.add(_sb.toString());
        }

        private String getProperMathClassname(String type) {
            String classname = null;
            classname = JavaSourceGenerator.isBasicType(type) ? "Math" : (JavaSourceGenerator.isDateOrTimeType(type) || type.startsWith("java.sql.") ? "DateTimeUtil" : "StringUtil");
            return classname;
        }

        protected void createMaxMinProperExpression(String leftexpr, String rightexpr, String type, String pname, String cname, String pname_postfix, String __targetobj) {
            boolean useTargetObject;
            String tab = HelperGenerator_calc_operation.getProperTab(this.preformula);
            StringBuilder _sb = new StringBuilder();
            _sb.append(tab);
            _sb.append(leftexpr);
            boolean isAddConvertFunction = false;
            boolean bl = useTargetObject = this.needsPresentationModel && (!this.mode_ref || this.mode_ref_multiple);
            if (this.needsPresentationModel && this.mode_ref) {
                isAddConvertFunction = this.addConvertFunction4Ref(this.refitemtype, useTargetObject, type, _sb);
            }
            if (useTargetObject) {
                if ("masterref".equals(this.targetitemtype)) {
                    _sb.append(this.processMasterref(this.targetitem, "__target"));
                } else if ("storeref".equals(this.targetitemtype)) {
                    _sb.append(this.processStoreref(this.targetitem, "__target"));
                } else if (this.mode_id) {
                    _sb.append("__target.getId()");
                } else {
                    _sb.append("__target.getContent()");
                }
            } else {
                _sb.append(__targetobj);
                if (this.needsPresentationModel) {
                    if (cname != null) {
                        _sb.append(JavaSourceGenerator.getterFullMethod(cname));
                        if (!this.mode_ref || this.mode_ref_multiple) {
                            _sb.append("[0]");
                        }
                        if (this.mode_id) {
                            String _getter = this.getter4presentationWithCompositeKey == null ? ".getId()" : this.getter4presentationWithCompositeKey[this.mode_id_suffix_no - 1];
                            _sb.append(_getter);
                        } else if (this.mode_content) {
                            _sb.append(".getContent()");
                        } else {
                            _sb.append(".getContent()");
                        }
                    }
                    if (isAddConvertFunction) {
                        _sb.append(")");
                    }
                } else {
                    _sb.append(cname != null ? JavaSourceGenerator.getterFullMethod(cname) : "");
                }
            }
            _sb.append(rightexpr);
            _sb.append(";");
            this.preformula.add(_sb.toString());
        }
    }

    abstract class CalcProcess_Func
    extends CalcProcess {
        boolean needsPresentationModel;
        String rtype;
        Model pmodel;
        String packagename;
        String ppackagename;
        String ppackagename_app;
        String pclassname;
        boolean isContainerFlag;

        CalcProcess_Func(String id, String s, String tname, String condition, StringBuilder formula, List<String> preformula, Modelitem sitem, Model model, Set<String> declareVarSet, Map<String, VariableStatus> varMap) {
            super(id, s, tname, condition, formula, preformula, sitem, model, declareVarSet, varMap);
            this.rtype = "rolecontent";
        }

        abstract String getType();

        boolean needsitemtypeCheck() {
            return true;
        }

        void multiple() {
        }

        void container(String pname, String cname) {
        }

        void foreignmodel(Model _rmodel) {
        }

        void checkbox() {
        }

        public void addMultipleTmpvarDefinition(String vname, String multiple_type) {
        }

        public void addMultipleReadyCode() {
        }

        public void addMultipleOperationCode(String name, String vname, String multiple_type, String tab) {
        }

        public void addMultipleFinishCode(String name, String vname, String multiple_type) {
            this.setProcessedFlag();
        }

        public void addContainerTmpvarDefinition(String vname, String container_type) {
        }

        public void addContainerReadyCode() {
        }

        public void addContainerOperationCode(String pname, String cname, String vname, String container_type) {
        }

        public void addContainerFinishCode(String pname, String vname, String container_type) {
            this.setProcessedFlag();
        }

        public void addForeignModelTmpvarDefinition(String vname, String _refmodel_item_type) {
        }

        public void addForeignModelReadyCode() {
        }

        public void addForeignModelFinishCode(String refmodel_items, String vname) {
            this.setProcessedFlag();
        }

        public boolean isAddForeignModelFinishCode(boolean isUlpModel) {
            return isUlpModel;
        }

        public String getProperType(String type) {
            return JavaSourceGenerator.getProperType(type);
        }

        public String getValidValue(String type) {
            return JavaSourceGenerator.getValidValue(type);
        }

        public String getLowerLimitOfArray() {
            return "0";
        }

        public boolean isConditionAvailable() {
            return true;
        }

        public void addDeclareArrayVariableFromStoreModel(String vname, String type, String id, String name, Modelitem mitem) {
            Relation _relation;
            StringBuilder vardef = new StringBuilder();
            StringBuilder _sb = new StringBuilder();
            if (("masterref".equals(type) || "storeref".equals(type)) && mitem != null && "check".equals((_relation = AppSchemaUtil.getRelationTypeExceptRef(mitem)).getType())) {
                type = AppSchemaUtil.getModelitemType(id, mitem, "roleid", true);
                if (type.endsWith("[]")) {
                    type = type.substring(0, type.length() - "[]".length());
                }
                type = JavaSourceGenerator.getProperType(type);
            }
            if (this.needsPresentationModel) {
                vardef.append(this.ppackagename);
            } else if (!(!StringUtils.isNotBlank((CharSequence)this.packagename) || JavaSourceGenerator.isBasicType(type) || JavaSourceGenerator.isDateOrTimeType(type) || JavaSourceGenerator.isStringType(type) || type.startsWith("java.sql."))) {
                vardef.append(this.packagename);
                this.isContainerFlag = true;
            }
            vardef.append(type);
            vardef.append("[] ");
            vardef.append(vname + "_ary");
            if (!this.declareVarSet.contains(vardef.toString())) {
                this.declareVarSet.add(vardef.toString());
                _sb.append(vardef.toString());
                _sb.append(" = ");
                _sb.append(id);
                if (this.needsPresentationModel) {
                    _sb.append("_p");
                }
                _sb.append(JavaSourceGenerator.getterFullMethod(name));
                _sb.append(";");
                this.preformula.add(_sb.toString());
            }
        }

        public String createVariableNameForResult(String itemname) {
            Integer _suffix;
            Map<String, Integer> vmap = HelperGenerator_calc_operation.this.variableNameMap.get(this.getType());
            if (vmap == null) {
                vmap = new HashMap<String, Integer>();
                HelperGenerator_calc_operation.this.variableNameMap.put(this.getType(), vmap);
            }
            if ((_suffix = vmap.get(itemname)) == null) {
                _suffix = 0;
            }
            int suffix = _suffix;
            vmap.put(itemname, ++suffix);
            if (suffix == 1) {
                return "_" + this.getType() + "_" + itemname;
            }
            return "_" + this.getType() + suffix + "_" + itemname;
        }

        @Override
        public void process0() {
            this.packagename = AppSchemaUtil.getPackagename(this.model, HelperGenerator_calc_operation.this.project);
            boolean bl = HelperGenerator_calc_operation.this.isMust = this.targetitem != null ? this.targetitem.getMust() : false;
            if (this.isContainer) {
                if (this.needsitemtypeCheck() && (this.tcname == null || this.tcname.length() == 0)) {
                    Object[] o = new Object[]{this.id, this.org_tname};
                    logger.error(HelperGenerator_calc_operation.this.rman.getValue("helper.invalid.autocalc.content.container", o));
                    this.status = 3;
                    return;
                }
                if (this.mode_id) {
                    this.rtype = "roleid";
                } else if (this.mode_content) {
                    this.rtype = "rolecontent";
                }
                if ("storeref".equals(this.targetitemtype) || "masterref".equals(this.targetitemtype) && (!this.mode_id && !this.mode_content || this.mode_content)) {
                    if ("first".equals(this.getType()) || "last".equals(this.getType()) || "slice".equals(this.getType())) {
                        if (!this.mode_ref && !this.mode_ref_multiple) {
                            this.needsPresentationModel = true;
                        }
                    } else {
                        this.needsPresentationModel = true;
                    }
                }
                if (this.needsPresentationModel) {
                    this.pmodel = AppSchemaUtil.getModel(HelperGenerator_calc_operation.this.project, this.id, "presentation");
                    this.ppackagename = this.pmodel != null ? AppSchemaUtil.getPackagename(this.pmodel, HelperGenerator_calc_operation.this.project) : "";
                    this.ppackagename_app = AppSchemaUtil.getPackagename_app(this.model, HelperGenerator_calc_operation.this.project);
                    this.pclassname = AppSchemaUtil.getClassname(this.pmodel);
                    HelperGenerator_calc_operation.gPutLruMapCode(this.preformula, this.model, HelperGenerator_calc_operation.this.project, this.id);
                }
                if (this.needsitemtypeCheck() && ("masterref".equals(this.targetitemtype) || "storeref".equals(this.targetitemtype))) {
                    Relation rel = AppSchemaUtil.getRelationTypeExceptRef(this.targetitem);
                    if (rel == null && (rel = AppSchemaUtil.getRelationTypeIsRef(this.targetitem)) == null) {
                        return;
                    }
                    if ("check".equals(rel.getType())) {
                        Object[] o = new Object[]{this.id, this.org_tname, this.targetitemtype};
                        logger.warn(HelperGenerator_calc_operation.this.rman.getValue("helper.invalid.autocalc.content.targetitemtypeerror.check", o));
                        this.status = 3;
                        return;
                    }
                    this.container(this.tpname, this.tcname);
                    return;
                }
                if ("storeref".equals(this.targetitemtype)) {
                    this.targetitemtype = HelperGenerator_calc_operation.this.resolvTargetitemType(this.targetitemtype, this.targetitem);
                }
                if (this.needsitemtypeCheck() && !JavaSourceGenerator.isBasicType(this.targetitemtype)) {
                    Object[] o = new Object[]{this.id, this.org_tname, this.targetitemtype};
                    logger.error(HelperGenerator_calc_operation.this.rman.getValue("helper.invalid.autocalc.content.typeerror", o));
                    this.status = 3;
                    return;
                }
                this.container(this.tpname, this.tcname);
            } else if (this.isMultiple) {
                if (this.needsitemtypeCheck() && ("masterref".equals(this.targetitemtype) || "storeref".equals(this.targetitemtype))) {
                    Object[] o = new Object[]{this.id, this.org_tname};
                    logger.error(HelperGenerator_calc_operation.this.rman.getValue("helper.invalid.autocalc.content.notsupport", o));
                    this.status = 3;
                    return;
                }
                if (this.needsitemtypeCheck() && !JavaSourceGenerator.isBasicType(this.targetitemtype)) {
                    Object[] o = new Object[]{this.id, this.org_tname, this.targetitemtype};
                    logger.error(HelperGenerator_calc_operation.this.rman.getValue("helper.invalid.autocalc.content.typeerror", o));
                    this.status = 3;
                    return;
                }
                this.multiple();
            } else if (this.isForeignModel) {
                Model _rmodel = AppSchemaUtil.getModel(HelperGenerator_calc_operation.this.project, HelperGenerator_calc_operation.getModelIdPart(this.org_tname));
                if (_rmodel == null) {
                    Object[] o = new Object[]{this.id, this.getType(), this.org_tname};
                    logger.error(HelperGenerator_calc_operation.this.rman.getValue("helper.invalid.autocalc.content.cannotfunc.foreignmodel", o));
                    this.status = 3;
                    return;
                }
                if (this.mode_id) {
                    this.rtype = "roleid";
                } else if (this.mode_content) {
                    this.rtype = "rolecontent";
                }
                if ("storeref".equals(this.targetitemtype) || "masterref".equals(this.targetitemtype) && (!this.mode_id && !this.mode_content || this.mode_content)) {
                    this.needsPresentationModel = true;
                }
                if (this.needsitemtypeCheck() && ("masterref".equals(this.targetitemtype) || "storeref".equals(this.targetitemtype))) {
                    Relation rel = AppSchemaUtil.getRelationTypeExceptRef(this.targetitem);
                    if (rel == null && (rel = AppSchemaUtil.getRelationTypeIsRef(this.targetitem)) == null) {
                        return;
                    }
                    if ("check".equals(rel.getType())) {
                        Object[] o = new Object[]{this.id, this.org_tname, this.targetitemtype};
                        logger.warn(HelperGenerator_calc_operation.this.rman.getValue("helper.invalid.autocalc.content.targetitemtypeerror.check", o));
                        this.status = 3;
                        return;
                    }
                    this.foreignmodel(_rmodel);
                    return;
                }
                if ("storeref".equals(this.targetitemtype)) {
                    this.targetitemtype = HelperGenerator_calc_operation.this.resolvTargetitemType(this.targetitemtype, this.targetitem);
                }
                if (this.needsitemtypeCheck() && !JavaSourceGenerator.isBasicType(this.targetitemtype)) {
                    Object[] o = new Object[]{this.id, this.org_tname, this.targetitemtype};
                    logger.error(HelperGenerator_calc_operation.this.rman.getValue("helper.invalid.autocalc.content.typeerror", o));
                    this.status = 3;
                    return;
                }
                this.foreignmodel(_rmodel);
            } else if (this.isCheckbox) {
                this.checkbox();
            } else {
                Object[] o = new Object[]{this.id, this.getType(), this.org_tname};
                logger.error(HelperGenerator_calc_operation.this.rman.getValue("helper.invalid.autocalc.content.cannotfunc", o));
                this.status = 3;
            }
        }

        public void addForeignModelReadyPresentation4Child(Model _rmodel) {
            Model _smodel = AppSchemaUtil.getStoreModel(_rmodel);
            String _sid = _smodel.getId();
            this.addForeignModelReadyPresentation4Child(_rmodel, _smodel, _sid, _sid + "_p", false);
        }

        public void addForeignModelReadyPresentation4Child(Model _rmodel, Model _smodel, String _sid, String _pid) {
            this.addForeignModelReadyPresentation4Child(_rmodel, _smodel, _sid, _pid, false);
        }

        public void addForeignModelReadyPresentation4Child(Model _rmodel, Model _smodel, String _sid, String _pid, boolean isForceFlag) {
            if (this.needsPresentationModel || isForceFlag) {
                this.pmodel = AppSchemaUtil.getModel(HelperGenerator_calc_operation.this.project, _smodel.getId(), "presentation");
                this.ppackagename = this.pmodel != null ? AppSchemaUtil.getPackagename(this.pmodel, HelperGenerator_calc_operation.this.project) : "";
                this.ppackagename_app = AppSchemaUtil.getPackagename_app(_smodel, HelperGenerator_calc_operation.this.project);
                this.pclassname = AppSchemaUtil.getClassname(this.pmodel);
                String key = HelperGenerator_calc_operation.createIdentification4CacheModel(this.ppackagename, this.pclassname, _smodel, _sid, HelperGenerator_calc_operation.this.project, true);
                StringBuilder _sb = new StringBuilder();
                String tab = HelperGenerator_calc_operation.getProperTab(this.preformula);
                _sb.append(tab);
                _sb.append("String __key = ").append(key).append(";");
                this.preformula.add(_sb.toString());
                boolean outputInsertCheckCode = false;
                Model ulpmodel = AppSchemaUtil.getModel(HelperGenerator_calc_operation.this.project, _sid + "_ulp");
                if (ulpmodel != null) {
                    boolean useUpdatelist = false;
                    block0: for (IProjectChoice ipc : HelperGenerator_calc_operation.this.project.getContent()) {
                        Action _action;
                        if (!(ipc instanceof Action) || !(_action = (Action)ipc).getType().equals("insert") && !_action.getType().equals("update")) continue;
                        for (Dataitem dataitem : AppSchemaUtil.getDataitems(_action)) {
                            if (!ulpmodel.getId().equals(dataitem.getIdrefAsString())) continue;
                            useUpdatelist = true;
                            break block0;
                        }
                    }
                    if (useUpdatelist) {
                        _sb = new StringBuilder();
                        _sb.append(tab);
                        _sb.append(this.ppackagename);
                        _sb.append(this.pclassname);
                        _sb.append(" ");
                        _sb.append(_pid);
                        _sb.append(" = null;");
                        this.preformula.add(_sb.toString());
                        String __key4insert = AppSchemaUtil.getPackagename(ulpmodel, HelperGenerator_calc_operation.this.project) + "Item.insertcopy";
                        _sb = new StringBuilder();
                        _sb.append(tab);
                        _sb.append("Set<String> __pkeySet4insertcopy = (Set<String>)p.request.getAttribute(\"" + __key4insert + "\");");
                        this.preformula.add(_sb.toString());
                        _sb = new StringBuilder();
                        _sb.append(tab).append("if (__pkeySet4insertcopy == null || !__pkeySet4insertcopy.contains(");
                        _sb.append(AppSchemaUtil.getHelperClassname(_smodel, HelperGenerator_calc_operation.this.project));
                        _sb.append(".getPrimaryKeyAsString(").append(_sid).append(", p))) {");
                        this.preformula.add(_sb.toString());
                        _sb = new StringBuilder();
                        _sb.append(tab + "    ");
                        _sb.append(_pid).append(" = ");
                        _sb.append("(").append(this.ppackagename).append(this.pclassname).append(")");
                        _sb.append("p.request.getAttribute(__key);");
                        this.preformula.add(_sb.toString());
                        this.preformula.add(tab + "}");
                        outputInsertCheckCode = true;
                    }
                }
                if (!outputInsertCheckCode) {
                    _sb = new StringBuilder();
                    _sb.append(tab);
                    _sb.append(this.ppackagename);
                    _sb.append(this.pclassname);
                    _sb.append(" ");
                    _sb.append(_pid);
                    _sb.append(" = ");
                    _sb.append("(").append(this.ppackagename).append(this.pclassname).append(")");
                    _sb.append("p.request.getAttribute(__key);");
                    this.preformula.add(_sb.toString());
                }
                _sb = new StringBuilder();
                _sb.append(tab);
                _sb.append("if (").append(_pid).append(" == null) {");
                this.preformula.add(_sb.toString());
                _sb = new StringBuilder();
                _sb.append(tab + "    ");
                _sb.append(_pid);
                _sb.append(" = ");
                _sb.append(AppSchemaUtil.getHelperClassname4Dicon(this.pmodel, HelperGenerator_calc_operation.this.project));
                _sb.append(".s2p(");
                _sb.append(_sid);
                _sb.append(", p, ");
                _sb.append(this.ppackagename_app);
                _sb.append(this.pclassname + "Helper");
                _sb.append(".SHOW);");
                this.preformula.add(_sb.toString());
                _sb = new StringBuilder();
                _sb.append(tab + "    ");
                _sb.append("p.request.setAttribute(__key, ").append(_pid).append(");");
                this.preformula.add(_sb.toString());
                _sb = new StringBuilder();
                _sb.append(tab);
                _sb.append("}");
                this.preformula.add(_sb.toString());
            }
        }

        public boolean isValidForeignmodel(Model _rmodel) {
            return this.isValidForeignmodel(_rmodel, true);
        }

        public boolean isValidForeignmodel(Model _rmodel, boolean needsCheckType) {
            Model _refmodel_store = AppSchemaUtil.getStoreModel(_rmodel);
            String _refmodel_itemname = HelperGenerator_calc_operation.getModelItemNamePart(this.org_tname);
            String _refmodel_id = HelperGenerator_calc_operation.getModelIdPart(this.org_tname);
            Modelitem _refmodel_item = AppSchemaUtil.getModelitem(_refmodel_itemname, _refmodel_store);
            if (_refmodel_item == null) {
                Object[] o = new Object[]{this.id, this.getType(), _refmodel_id, _refmodel_itemname};
                logger.error(HelperGenerator_calc_operation.this.rman.getValue("helper.invalid.autocalc.content.cannotfunc.foreignmodelitem", o));
                return false;
            }
            String _refmodel_item_type = this.getProperType(AppSchemaUtil.getModelitemType(HelperGenerator_calc_operation.this.project, _refmodel_id, _refmodel_item, this.mode_id ? "roleid" : "rolecontent"));
            if (!(JavaSourceGenerator.isBasicType(_refmodel_item_type) || "first".equals(this.getType()) || "last".equals(this.getType()) || "slice".equals(this.getType()) || "join".equals(this.getType()) || "max".equals(this.getType()) || "min".equals(this.getType()))) {
                Object[] o = new Object[]{this.id, this.getType(), _refmodel_id, _refmodel_itemname};
                logger.error(HelperGenerator_calc_operation.this.rman.getValue("helper.invalid.autocalc.content.cannotfunc.foreignmodelitem.type", o));
                return false;
            }
            return true;
        }

        public void addForeignModelGetObject(Model smodel, Model rmodel) {
            String _smodel_id = smodel.getId();
            String _s_varname = _smodel_id + "_ary";
            String _datas_varname = _smodel_id + "_datas_ulp";
            if (this.declareVarSet.contains(_s_varname)) {
                return;
            }
            this.declareVarSet.add(_s_varname);
            String _s_packagename = AppSchemaUtil.getPackagename(smodel, HelperGenerator_calc_operation.this.project);
            String _s_classname = AppSchemaUtil.getClassname(smodel);
            StringBuilder _sb = new StringBuilder();
            boolean useUpdatelist = false;
            Model ulpmodel = AppSchemaUtil.getModel(HelperGenerator_calc_operation.this.project, _smodel_id + "_ulp");
            if (ulpmodel != null) {
                block0: for (IProjectChoice ipc : HelperGenerator_calc_operation.this.project.getContent()) {
                    Action _action;
                    if (!(ipc instanceof Action) || !(_action = (Action)ipc).getType().equals("insert") && !_action.getType().equals("update")) continue;
                    for (Dataitem dataitem : AppSchemaUtil.getDataitems(_action)) {
                        if (!ulpmodel.getId().equals(dataitem.getIdrefAsString())) continue;
                        useUpdatelist = true;
                        break block0;
                    }
                }
            }
            if (!useUpdatelist) {
                _sb.append(_s_packagename).append(_s_classname).append("[] ");
                _sb.append(_s_varname).append(" = ");
                _sb.append("(").append(_s_packagename).append(_s_classname).append("[])");
                _sb.append("p.request.getAttribute(\"");
                _sb.append(_s_varname);
                _sb.append("\");");
                this.preformula.add(_sb.toString());
            } else {
                _sb.append(_s_packagename).append(_s_classname).append("[] ");
                _sb.append(_s_varname).append(" = null;");
                this.preformula.add(_sb.toString());
                _sb = new StringBuilder();
                _sb.append("List<");
                _sb.append(_s_packagename).append(_s_classname).append("> ").append(_datas_varname).append(" = (List<");
                _sb.append(_s_packagename).append(_s_classname).append(">)p.request.getAttribute(\"");
                _sb.append("datas_").append(_s_classname).append("_ulp\");");
                this.preformula.add(_sb.toString());
                _sb = new StringBuilder();
                _sb.append("if (").append(_datas_varname).append(" != null) {");
                this.preformula.add(_sb.toString());
                _sb = new StringBuilder();
                _sb.append("    ").append(_s_varname).append(" = ").append(_datas_varname).append(".toArray(new ");
                _sb.append(_s_packagename).append(_s_classname).append("[0]);");
                this.preformula.add(_sb.toString());
                String _ulp_packagename = AppSchemaUtil.getPackagename(ulpmodel, HelperGenerator_calc_operation.this.project);
                String _ulp_id = ulpmodel.getId();
                String _ulp_classname = AppSchemaUtil.getClassname(ulpmodel);
                _sb = new StringBuilder();
                _sb.append("    ").append(_ulp_packagename).append(_ulp_classname);
                _sb.append(" ").append(_ulp_id).append(" = (");
                _sb.append(_ulp_packagename).append(_ulp_classname);
                _sb.append(")p.request.getAttribute(\"").append(_ulp_id).append("\");");
                this.preformula.add(_sb.toString());
                _sb = new StringBuilder();
                _sb.append("    ").append("if (").append(_ulp_id).append(" != null) {");
                this.preformula.add(_sb.toString());
                this.preformula.add("        List<Integer> _deleteIndex = null;");
                _sb = new StringBuilder();
                _sb.append("        ").append(_ulp_packagename).append("Item[] _items = ");
                _sb.append(_ulp_id).append(".getItem();");
                this.preformula.add(_sb.toString());
                this.preformula.add("        if (_items != null && _items.length > 0) {");
                this.preformula.add("            for (int _idx=0; _idx < _items.length; _idx++) {");
                _sb = new StringBuilder();
                _sb.append("                ").append(_ulp_packagename).append("Item _item = _items[_idx];");
                this.preformula.add(_sb.toString());
                this.preformula.add("                if (_item.getJfcdelete()) {");
                this.preformula.add("                    if (_deleteIndex == null) {");
                this.preformula.add("                        _deleteIndex = new ArrayList<>();");
                this.preformula.add("                    }");
                this.preformula.add("                    _deleteIndex.add(_idx);");
                this.preformula.add("                }");
                this.preformula.add("            }");
                this.preformula.add("        }");
                this.preformula.add("        if (_deleteIndex != null) {");
                this.preformula.add("            java.util.Collections.reverse(_deleteIndex);");
                this.preformula.add("            for (int _idx : _deleteIndex) {");
                _sb = new StringBuilder();
                _sb.append("                ");
                _sb.append(_s_varname).append(" = org.apache.commons.lang3.ArrayUtils.remove(");
                _sb.append(_s_varname).append(", _idx);");
                this.preformula.add(_sb.toString());
                this.preformula.add("            }");
                this.preformula.add("        }");
                this.preformula.add("    }");
                this.preformula.add("}");
                this.preformula.add("if (" + _s_varname + " == null) {");
                _sb = new StringBuilder();
                _sb.append("    ").append(_s_varname).append(" = ");
                _sb.append("(").append(_s_packagename).append(_s_classname).append("[])");
                _sb.append("p.request.getAttribute(\"");
                _sb.append(_s_varname);
                _sb.append("\");");
                this.preformula.add(_sb.toString());
                this.preformula.add("}");
            }
            this.preformula.add("if (" + _s_varname + " == null) {");
            _sb = new StringBuilder();
            _sb.append("    ").append(_s_varname).append(" = ");
            _sb.append("(").append(_s_packagename).append(_s_classname).append("[])");
            _sb.append("p.pageMap.get(\"");
            _sb.append(_s_varname);
            _sb.append("\");");
            this.preformula.add(_sb.toString());
            this.preformula.add("}");
            if (useUpdatelist) {
                String __key4delete = AppSchemaUtil.getPackagename(ulpmodel, HelperGenerator_calc_operation.this.project) + "Item.delete";
                this.preformula.add("if (" + _s_varname + " != null) {");
                this.preformula.add("    Set<String> __pkeySet4delete = (Set<String>)p.request.getAttribute(\"" + __key4delete + "\");");
                this.preformula.add("    if (__pkeySet4delete != null) {");
                this.preformula.add("        List<" + _s_packagename + _s_classname + "> _list = new ArrayList<" + _s_packagename + _s_classname + ">();");
                this.preformula.add("        for (int k=0; k<" + _s_varname + ".length; k++) {");
                _sb = new StringBuilder();
                _sb.append("            ").append(_s_packagename).append(_s_classname).append(" ");
                _sb.append("_" + _smodel_id).append(" = ").append(_s_varname).append("[k];");
                this.preformula.add(_sb.toString());
                _sb = new StringBuilder();
                _sb.append("            ").append("String __pkey = ");
                _sb.append(AppSchemaUtil.getHelperClassname(smodel, HelperGenerator_calc_operation.this.project));
                _sb.append(".getPrimaryKeyAsString(").append("_" + _smodel_id).append(", p);");
                this.preformula.add(_sb.toString());
                this.preformula.add("            if (!__pkeySet4delete.contains(__pkey)) {");
                this.preformula.add("                _list.add((" + _s_packagename + _s_classname + ")_" + _smodel_id + ".clone());");
                this.preformula.add("            } else {");
                this.preformula.add("                __pkeySet4delete.remove(__pkey);");
                this.preformula.add("            }");
                this.preformula.add("        }");
                this.preformula.add("        " + _s_varname + " = (" + _s_packagename + _s_classname + "[])_list.toArray(new " + _s_packagename + _s_classname + "[0]);");
                this.preformula.add("    }");
                this.preformula.add("}");
                _sb = new StringBuilder();
            }
        }

        public ExpandExpression[] parsePlaceHolderInOperator(String condition, String pname, String vname, Model model) {
            return this.parsePlaceHolderInOperator(condition, pname, vname, model, false, false, false);
        }

        public ExpandExpression[] parsePlaceHolderInOperator(String condition, String pname, String vname, Model model, boolean useUlpModel, boolean useTemplateVariable, boolean isProcessedForeignModelCount) {
            if (condition == null || condition.length() == 0) {
                return null;
            }
            ArrayList<ExpandExpression> list = null;
            ExpandExpression ee = null;
            ExpandExpression eefirst = null;
            int length = condition.length();
            StringBuilder exp = new StringBuilder();
            StringBuilder var = null;
            boolean varMode = false;
            for (int i = 0; i < length; ++i) {
                char c = condition.charAt(i);
                if (c == '$') {
                    if (i + 1 >= length || condition.charAt(i + 1) != '{') continue;
                    varMode = true;
                    ++i;
                    continue;
                }
                if (c == '}' && varMode && var != null) {
                    Modelitem mitem;
                    String itemname = var.toString();
                    if (list == null) {
                        list = new ArrayList<ExpandExpression>();
                    }
                    ee = new ExpandExpression();
                    list.add(ee);
                    if (eefirst == null) {
                        eefirst = ee;
                    }
                    if (itemname.startsWith("size(") && itemname.endsWith(")")) {
                        ee.useSizeOperator(true);
                        itemname = itemname.substring("size(".length(), itemname.length() - 1);
                    }
                    if (itemname.startsWith("isNull(") && itemname.endsWith(")")) {
                        ee.useIsNullOperator(true);
                        itemname = itemname.substring("isNull(".length(), itemname.length() - 1);
                    }
                    if (itemname.startsWith("check(") && itemname.endsWith(")")) {
                        ee.useCheckOperator(true);
                        itemname = itemname.substring("check(".length(), itemname.length() - 1);
                    }
                    boolean mode_id = false;
                    boolean mode_content = false;
                    boolean mode_choose = false;
                    String idsuffix = AppSchemaUtil.getIdSuffixPartInExpr(itemname);
                    if (idsuffix != null) {
                        int idsuffix_length = idsuffix.length();
                        itemname = itemname.substring(0, itemname.length() - idsuffix_length);
                        if (idsuffix_length > "#id".length()) {
                            // empty if block
                        }
                        mode_id = true;
                    } else if (itemname.endsWith("#content")) {
                        itemname = itemname.substring(0, itemname.length() - "#content".length());
                        mode_content = true;
                    } else if (itemname.endsWith("#choose")) {
                        itemname = itemname.substring(0, itemname.length() - "#choose".length());
                        mode_choose = true;
                    } else if (itemname.endsWith("#array")) {
                        itemname = itemname.substring(0, itemname.length() - "#array".length());
                        this.mode_array = true;
                    }
                    if (JavaSourceGenerator.isIncludeWagbyOperator(itemname)) {
                        throw new IllegalArgumentException(itemname);
                    }
                    boolean isForeignKey = false;
                    boolean isUpdatelist = false;
                    int ptr = itemname.indexOf(".");
                    if (ptr > 0) {
                        Object mname = itemname.substring(0, ptr);
                        itemname = itemname.substring(ptr + 1);
                        if (model.getUpdatelist()) {
                            if (((String)mname).endsWith("_lp")) {
                                mname = ((String)mname).substring(0, ((String)mname).length() - "_lp".length()) + "_ulp";
                            }
                            isUpdatelist = true;
                        }
                        if (((String)mname).endsWith("_lp") || ((String)mname).endsWith("_ulp")) {
                            isForeignKey = true;
                        }
                    }
                    if ((mitem = AppSchemaUtil.getModelitem(itemname, model)) == null) {
                        if (model != this.model) {
                            mitem = AppSchemaUtil.getModelitem(itemname, this.model);
                        }
                        if (mitem == null) {
                            throw new IllegalArgumentException(itemname);
                        }
                    }
                    String pname0 = null;
                    String cname0 = null;
                    if (AppSchemaUtil.hasChildPart(itemname)) {
                        pname0 = AppSchemaUtil.getParentPart(itemname);
                        cname0 = AppSchemaUtil.getChildPart(itemname);
                    } else {
                        pname0 = itemname;
                        cname0 = itemname;
                    }
                    if (pname0.equals(pname) && !AppSchemaUtil.hasChildPart(itemname)) {
                        if ("masterref".equals(mitem.getType()) || "storeref".equals(mitem.getType())) {
                            exp.append(vname);
                            if (mode_id) {
                                String _getter = this.getter4presentationWithCompositeKey == null ? ".getId()" : this.getter4presentationWithCompositeKey[this.mode_id_suffix_no - 1];
                                exp.append(_getter);
                            } else if (mode_content) {
                                exp.append(".getContent()");
                            } else if (mode_choose) {
                                exp.append(".getChoose()");
                            }
                        } else {
                            exp.append(vname);
                        }
                    } else if (pname0.equals(pname) || isForeignKey) {
                        String _getter;
                        ClassVarnamePair cv;
                        String getter = (isForeignKey ? pname : vname) + JavaSourceGenerator.getterFullMethod(cname0);
                        Model smodel = null;
                        Modelitem s_mitem = null;
                        boolean needsWrapper = false;
                        if (isForeignKey) {
                            Object wrapper = null;
                            smodel = AppSchemaUtil.getStoreModel(model);
                            s_mitem = AppSchemaUtil.getModelitem(mitem.getName(), smodel);
                            if (ee.useSizeOperator) {
                                ee.multiple = new ClassVarnamePair();
                                ee.multiple.classname = AppSchemaUtil.getModelitemClassname(s_mitem);
                                ee.multiple.varname = s_mitem.getName();
                                getter = pname + JavaSourceGenerator.sizeFullMethod(s_mitem.getName());
                            } else if (ee.useIsNullOperator) {
                                cv = new ClassVarnamePair();
                                cv.classname = AppSchemaUtil.getModelitemClassname(s_mitem);
                                cv.varname = s_mitem.getName();
                                eefirst.master.add(cv);
                            } else if (ee.useCheckOperator) {
                                ee.multiple = new ClassVarnamePair();
                                ee.multiple.classname = AppSchemaUtil.getModelitemClassname(s_mitem);
                                ee.multiple.varname = s_mitem.getName();
                                getter = pname + JavaSourceGenerator.checkFullMethod(s_mitem.getName());
                            } else if (s_mitem.getMultiple()) {
                                ee.multiple = new ClassVarnamePair();
                                ee.multiple.classname = AppSchemaUtil.getModelitemClassname(s_mitem);
                                ee.multiple.varname = s_mitem.getName();
                                getter = s_mitem.getName() + ".getContent()";
                                needsWrapper = true;
                            } else if ("masterref".equals(s_mitem.getType())) {
                                Object tname;
                                cv = new ClassVarnamePair();
                                cv.classname = AppSchemaUtil.getModelitemClassname(s_mitem);
                                cv.varname = s_mitem.getName();
                                eefirst.master.add(cv);
                                Object object = tname = isProcessedForeignModelCount ? s_mitem.getName() : "_" + s_mitem.getName() + "_code_m";
                                if (mode_id) {
                                    String _getter2 = this.getter4presentationWithCompositeKey == null ? ".getId()" : this.getter4presentationWithCompositeKey[this.mode_id_suffix_no - 1];
                                    getter = (String)(!useTemplateVariable ? tname : vname) + _getter2;
                                } else if (mode_choose) {
                                    getter = (String)(!useTemplateVariable ? tname : vname) + ".getChoose()";
                                } else {
                                    getter = (String)(!useTemplateVariable ? tname : vname) + ".getContent()";
                                    needsWrapper = true;
                                }
                            } else if ("storeref".equals(s_mitem.getType())) {
                                Relation r_smitem = AppSchemaUtil.getRelationTypeExceptRef(s_mitem);
                                String roleattr = mode_id ? "roleid" : "rolecontent";
                                ee.store = new ClassVarnamePair();
                                ee.store.type = AppSchemaUtil.getModelitemType(HelperGenerator_calc_operation.this.project, smodel.getId(), s_mitem, roleattr, true);
                                if (r_smitem != null) {
                                    ee.store.classname = AppSchemaUtil.getModelitemClassname(s_mitem);
                                    ee.store.varname = s_mitem.getName();
                                    ClassVarnamePair cv2 = new ClassVarnamePair();
                                    cv2.classname = ee.store.classname;
                                    cv2.varname = ee.store.varname;
                                    eefirst.master.add(cv2);
                                    if (mode_id) {
                                        _getter = this.getter4presentationWithCompositeKey == null ? ".getId()" : this.getter4presentationWithCompositeKey[this.mode_id_suffix_no - 1];
                                        getter = (!useTemplateVariable ? s_mitem.getName() : vname) + _getter;
                                    } else if (mode_choose) {
                                        getter = (!useTemplateVariable ? s_mitem.getName() : vname) + ".getChoose()";
                                    } else {
                                        getter = (!useTemplateVariable ? s_mitem.getName() : vname) + ".getContent()";
                                        needsWrapper = true;
                                    }
                                }
                            }
                            if ((isUpdatelist || useUlpModel) && ee.isContentOnly() && !ee.useSizeOperator) {
                                getter = getter + ".getContent()";
                            }
                            if (needsWrapper) {
                                String s_mitem_type = AppSchemaUtil.getModelitemType(HelperGenerator_calc_operation.this.project, smodel.getId(), s_mitem);
                                if (!"masterref".equals(s_mitem.getType()) || !mode_content) {
                                    if (JavaSourceGenerator.isBasicType(s_mitem_type)) {
                                        wrapper = "StringUtil" + JavaSourceGenerator.getWc2b_method(s_mitem_type);
                                    } else if (JavaSourceGenerator.isDateOrTimeType(s_mitem_type)) {
                                        wrapper = this.getProperDateOrTimeTypeWrapperFunction(s_mitem_type);
                                    }
                                }
                                if (wrapper != null) {
                                    exp.append((String)wrapper);
                                    exp.append("(");
                                }
                            }
                            exp.append(getter);
                            if (wrapper != null) {
                                exp.append(")");
                            }
                        } else {
                            smodel = model;
                            s_mitem = mitem;
                            if ("masterref".equals(s_mitem.getType())) {
                                if (useTemplateVariable) {
                                    if (mode_id) {
                                        String _getter3 = this.getter4presentationWithCompositeKey == null ? ".getId()" : this.getter4presentationWithCompositeKey[this.mode_id_suffix_no - 1];
                                        getter = vname + _getter3;
                                    } else {
                                        getter = mode_choose ? vname + ".getChoose()" : vname + ".getContent()";
                                    }
                                } else if (!mode_id) {
                                    ClassVarnamePair cv3 = new ClassVarnamePair();
                                    cv3.classname = AppSchemaUtil.getModelitemClassname(s_mitem);
                                    cv3.varname = cname0;
                                    getter = "_" + cv3.varname + "_code_m.getContent()";
                                    eefirst.master.add(cv3);
                                }
                            } else if ("storeref".equals(s_mitem.getType())) {
                                Relation r_smitem = AppSchemaUtil.getRelationTypeExceptRef(s_mitem);
                                if (r_smitem != null) {
                                    ee.store = new ClassVarnamePair();
                                    ee.store.classname = AppSchemaUtil.getModelitemClassname(s_mitem);
                                    ee.store.varname = cname0;
                                    cv = new ClassVarnamePair();
                                    cv.varname = cname0;
                                    eefirst.master.add(cv);
                                    Model r_smitem_model = (Model)r_smitem.getIdrefAsIRNode();
                                    Modelitem r_smitem_item = null;
                                    if (!mode_id) {
                                        getter = mode_choose ? (!useTemplateVariable ? cname0 : vname) + ".getChoose()" : (!useTemplateVariable ? cname0 : vname) + ".getContent()";
                                        r_smitem_item = AppSchemaUtil.getModelitem(r_smitem.getRolecontent(), r_smitem_model);
                                    } else {
                                        _getter = this.getter4presentationWithCompositeKey == null ? ".getId()" : this.getter4presentationWithCompositeKey[this.mode_id_suffix_no - 1];
                                        getter = cname0 + _getter;
                                        r_smitem_item = AppSchemaUtil.getModelitem(r_smitem.getRoleid(), r_smitem_model);
                                    }
                                    if (ee.useIsNullOperator) {
                                        getter = "(" + cname0 + " == null || " + getter + " == null)";
                                    } else {
                                        String r_smitem_type;
                                        String string = r_smitem_type = r_smitem_item != null ? r_smitem_item.getType() : null;
                                        if (r_smitem_type != null && JavaSourceGenerator.isBasicType(r_smitem_type)) {
                                            getter = "long".equals(r_smitem_type) ? "VALUE(" + getter + ")" : "VALUE(" + getter + ")";
                                        } else if (r_smitem_type != null && JavaSourceGenerator.isDateOrTimeType(r_smitem_type)) {
                                            getter = this.getProperDateOrTimeTypeWrapperFunction(r_smitem_type) + "(" + getter + ")";
                                        }
                                    }
                                } else {
                                    Modelitem rel_item;
                                    r_smitem = AppSchemaUtil.getRelationTypeIsRef(s_mitem);
                                    if (r_smitem == null || (rel_item = AppSchemaUtil.getRelatedModelitemInCaseofTypeRef(HelperGenerator_calc_operation.this.project, smodel.getId(), s_mitem)) != null) {
                                        // empty if block
                                    }
                                }
                            }
                            exp.append(getter);
                        }
                    } else {
                        Model tmodel = model;
                        Modelitem t_mitem = AppSchemaUtil.getModelitem(pname0, this.model);
                        if (t_mitem != null) {
                            tmodel = this.model;
                        }
                        exp.append(tmodel.getId() + JavaSourceGenerator.getterFullMethod(pname0));
                    }
                    varMode = false;
                    var = null;
                    continue;
                }
                if (varMode) {
                    if (var == null) {
                        var = new StringBuilder();
                    }
                    var.append(c);
                    continue;
                }
                if (c == '\\' && i + 1 < length && condition.charAt(i + 1) == '\"') {
                    exp.append('\"');
                    ++i;
                    continue;
                }
                exp.append(c);
            }
            ExpandExpression expandExpression = ee = list != null && list.size() > 0 ? (ExpandExpression)list.get(0) : null;
            if (ee != null) {
                ee.content = HelperGenerator_calc_parser.convertFunctionNames(exp.toString(), HelperGenerator_calc_operation.this.replaceFunctionMap);
            }
            return list != null ? list.toArray(new ExpandExpression[0]) : new ExpandExpression[]{};
        }

        public boolean addConvertFunction(String refitemtype, boolean useTargetObject, String type, StringBuilder _sb) {
            boolean ret = false;
            return ret;
        }

        public boolean addConvertFunction4Ref(String refitemtype, boolean useTargetObject, String type, StringBuilder _sb) {
            return this.addConvertFunction4Ref(refitemtype, useTargetObject, type, _sb, false);
        }

        public boolean addConvertFunction4Ref(String refitemtype, boolean useTargetObject, String type, StringBuilder _sb, boolean useBigDecimalFlag) {
            boolean ret = false;
            if (JavaSourceGenerator.isStringType(type)) {
                return ret;
            }
            if (refitemtype != null && JavaSourceGenerator.isBasicType(refitemtype) && !useBigDecimalFlag) {
                _sb.append("StringUtil");
                _sb.append(JavaSourceGenerator.getWc2b_method(refitemtype));
                _sb.append("(");
                ret = true;
            } else if (refitemtype != null && JavaSourceGenerator.isDateOrTimeType(refitemtype)) {
                _sb.append(this.getProperDateOrTimeTypeWrapperFunction(refitemtype) + "(");
                ret = true;
            }
            return ret;
        }

        public boolean isNeedsValueCheck(String name, Model model) {
            Modelitem _target;
            boolean needsValueCheck = false;
            if ((!this.mode_content || this.isForeignModel) && (_target = AppSchemaUtil.getModelitem(name, model)) != null) {
                if (JavaSourceGenerator.isBasicType(_target.getType()) && !_target.getMust()) {
                    needsValueCheck = true;
                } else if (x2aj_rman.getValue("r.model.modelitem.noselection").equals(AppSchemaUtil.getNoselection(_target, model, HelperGenerator_calc_operation.this.project))) {
                    needsValueCheck = true;
                } else {
                    String _rtype;
                    Relation _relation = AppSchemaUtil.getRelationTypeExceptRef(_target);
                    if (_relation != null && "storeref".equals(_target.getType()) && JavaSourceGenerator.isBasicType(_rtype = AppSchemaUtil.getModelitemType(HelperGenerator_calc_operation.this.project, model.getId(), _target))) {
                        needsValueCheck = true;
                    }
                }
            }
            return needsValueCheck;
        }

        public void addCondition(ExpandExpression[] _expressions, Model model, String pname, String pname_postfix, String target_name, String mtab) {
            StringBuilder _sb = null;
            HashSet<Object> processedClassnameSet = null;
            HashSet<String> skippedMasterClassnameSet = null;
            for (ExpandExpression _expression : _expressions) {
                if (_expression.master.size() > 0) {
                    HashSet<String> processedItemSet = new HashSet<String>();
                    for (ClassVarnamePair cv : _expression.master) {
                        if (processedItemSet.contains(cv.varname) || cv.classname == null || cv.varname != null && _expression.store != null && cv.varname.equals(_expression.store.varname)) continue;
                        processedItemSet.add(cv.varname);
                        Object _itemname = null;
                        _itemname = pname_postfix.length() > 0 ? pname + "/" + cv.varname : cv.varname;
                        Modelitem container_mrefitem = AppSchemaUtil.getModelitem((String)_itemname, model);
                        Relation _ref_mrefitem = AppSchemaUtil.getRelation(container_mrefitem);
                        Model master = AppSchemaUtil.getModel(HelperGenerator_calc_operation.this.project, _ref_mrefitem.getIdref());
                        if (master.getType().equals("store")) {
                            if (skippedMasterClassnameSet == null) {
                                skippedMasterClassnameSet = new HashSet<String>();
                            }
                            skippedMasterClassnameSet.add(cv.classname);
                            continue;
                        }
                        String mid = master.getId();
                        String mpackagename = AppSchemaUtil.getPackagename(master, HelperGenerator_calc_operation.this.project);
                        String mclassname = AppSchemaUtil.getMasterClassname(master);
                        String mclassname0 = AppSchemaUtil.getClassname(master);
                        Object mtpackagename = HelperGenerator_calc_operation.this.project.getPackage() + ".app." + mid + ".";
                        if (mclassname.indexOf(".") >= 0) {
                            mtpackagename = "";
                        }
                        _sb = new StringBuilder();
                        _sb.append(mtab + "    ");
                        _sb.append((String)mtpackagename);
                        _sb.append(mclassname);
                        _sb.append(" ");
                        _sb.append("_" + cv.varname + "_master = ");
                        this.preformula.add(_sb.toString());
                        _sb = new StringBuilder();
                        _sb.append(mtab + "        ");
                        _sb.append((String)mtpackagename);
                        _sb.append(mclassname);
                        _sb.append(".getInstance(p);");
                        this.preformula.add(_sb.toString());
                        _sb = new StringBuilder();
                        _sb.append(mtab + "    ");
                        _sb.append(mpackagename + mclassname0);
                        _sb.append(" ");
                        _sb.append("_" + cv.varname + "_code_m =");
                        this.preformula.add(_sb.toString());
                        _sb = new StringBuilder();
                        _sb.append(mtab + "        ");
                        _sb.append("(");
                        _sb.append(mpackagename + mclassname0);
                        _sb.append(")");
                        this.preformula.add(_sb.toString());
                        _sb = new StringBuilder();
                        _sb.append(mtab + "            ");
                        _sb.append("_" + cv.varname + "_master.getData(");
                        _sb.append(target_name);
                        _sb.append(JavaSourceGenerator.getterFullMethod(cv.varname));
                        _sb.append(");");
                        this.preformula.add(_sb.toString());
                    }
                }
                if (_expression.store == null || _expression.store.classname == null) continue;
                Object _itemname = null;
                _itemname = pname_postfix.length() > 0 ? pname + "/" + _expression.store.varname : _expression.store.varname;
                if (processedClassnameSet == null) {
                    processedClassnameSet = new HashSet<Object>();
                }
                if (processedClassnameSet.contains(_itemname)) continue;
                processedClassnameSet.add(_itemname);
                Modelitem container_mrefitem = AppSchemaUtil.getModelitem((String)_itemname, model);
                Relation _ref_mrefitem = container_mrefitem != null ? AppSchemaUtil.getRelation(container_mrefitem) : null;
                Model _rmodel = _ref_mrefitem != null ? (Model)_ref_mrefitem.getIdrefAsIRNode() : null;
                Model pmodel = AppSchemaUtil.getModel(HelperGenerator_calc_operation.this.project, model.getId(), "presentation");
                String _packagename = AppSchemaUtil.getPackagename(pmodel, HelperGenerator_calc_operation.this.project);
                boolean isMultipleRef = false;
                if (_ref_mrefitem != null && ("radio".equals(_ref_mrefitem.getType()) || "check".equals(_ref_mrefitem.getType()) || this.needsPresentationModel)) {
                    isMultipleRef = true;
                }
                if (this.needsPresentationModel) {
                    _sb = new StringBuilder();
                    _sb.append("        ");
                    _sb.append(_packagename);
                    _sb.append(_expression.store.classname);
                    if (isMultipleRef) {
                        _sb.append("[]");
                    }
                    _sb.append(" ");
                    _sb.append(_expression.store.varname + "_ary");
                    _sb.append(" =");
                    this.preformula.add(_sb.toString());
                    _sb = new StringBuilder();
                    _sb.append("            ");
                    _sb.append(target_name);
                    _sb.append(JavaSourceGenerator.getterFullMethod(_expression.store.classname));
                    _sb.append(";");
                    this.preformula.add(_sb.toString());
                } else {
                    _sb = new StringBuilder();
                    _sb.append("        ");
                    _sb.append(_packagename);
                    _sb.append(_expression.store.classname);
                    if (isMultipleRef) {
                        _sb.append("[]");
                    }
                    _sb.append(" ");
                    _sb.append(_expression.store.varname);
                    if (isMultipleRef) {
                        _sb.append("_ary");
                    }
                    _sb.append(" =");
                    this.preformula.add(_sb.toString());
                    _sb = new StringBuilder();
                    _sb.append("            ");
                    _sb.append(AppSchemaUtil.getHelperClassname4Dicon(pmodel, HelperGenerator_calc_operation.this.project));
                    _sb.append(".get");
                    _sb.append(_expression.store.classname);
                    _sb.append("_show(");
                    boolean isCheckRelation = AppSchemaUtil.isCheckRelation(container_mrefitem);
                    String restrict = null;
                    Relation relation = AppSchemaUtil.getRelationTypeExceptRef(container_mrefitem);
                    if (relation != null) {
                        restrict = relation.getRestrict();
                    }
                    Object[] _realfields = StringUtils.isNotEmpty((CharSequence)container_mrefitem.getRealfield()) ? container_mrefitem.getRealfield().split(",") : null;
                    PrimaryKey[] r_pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(_rmodel, HelperGenerator_calc_operation.this.project);
                    if (r_pkeys != null && r_pkeys.length <= 1) {
                        Modelitem rfield;
                        boolean isMust = false;
                        if (ArrayUtils.isNotEmpty((Object[])_realfields) && !"condition".equals(_rmodel.getType()) && (rfield = AppSchemaUtil.getModelitem((String)_realfields[0], _rmodel)) != null && rfield.getMust()) {
                            isMust = true;
                        }
                        String mitem_type = AppSchemaUtil.getModelitemType(HelperGenerator_calc_operation.this.project, _rmodel.getId(), container_mrefitem, "roleid");
                        boolean isBasicType = JavaSourceGenerator.isBasicType(mitem_type);
                        _sb.append(target_name);
                        _sb.append(".get");
                        _sb.append(_expression.store.classname);
                        if (isBasicType && !isCheckRelation && !isMust) {
                            _sb.append("As");
                            _sb.append(JavaSourceGenerator.b2wc(mitem_type));
                        }
                        _sb.append("()");
                    } else if (r_pkeys != null) {
                        for (int i = 0; i < r_pkeys.length; ++i) {
                            Modelitem rfield;
                            boolean isMust = false;
                            if (ArrayUtils.isNotEmpty((Object[])_realfields) && !"condition".equals(_rmodel.getType()) && (rfield = AppSchemaUtil.getModelitem((String)_realfields[i], _rmodel)) != null && rfield.getMust()) {
                                isMust = true;
                            }
                            String pkey_name = AppSchemaUtil.createFullPrimaryKeyName(r_pkeys[i]);
                            String pkey_type = AppSchemaUtil.getPkeyType(_rmodel, pkey_name, "int", HelperGenerator_calc_operation.this.project);
                            boolean isBasicType = JavaSourceGenerator.isBasicType(pkey_type);
                            _sb.append(target_name);
                            _sb.append(".get");
                            _sb.append(_expression.store.classname);
                            _sb.append(JavaSourceGenerator.capFirst("_" + pkey_name));
                            if (isBasicType && !isCheckRelation && !isMust) {
                                _sb.append("As");
                                _sb.append(JavaSourceGenerator.b2wc(pkey_type));
                            }
                            _sb.append("()");
                        }
                    }
                    if (restrict == null) {
                        _sb.append(", ");
                    } else {
                        HelperGenerator_s2p_master.gOutputMethodParameter4Restrict(target_name, restrict, model, _sb, HelperGenerator_calc_operation.this.project);
                        _sb.append(", ");
                    }
                    _sb.append("p);");
                    this.preformula.add(_sb.toString());
                }
                if (!isMultipleRef) continue;
                _sb = new StringBuilder();
                _sb.append("        ");
                _sb.append(_packagename);
                _sb.append(_expression.store.classname);
                _sb.append(" ");
                _sb.append(_expression.store.varname);
                _sb.append(" = null;");
                this.preformula.add(_sb.toString());
                _sb = new StringBuilder();
                _sb.append("        ");
                _sb.append("if (");
                _sb.append(_expression.store.varname + "_ary");
                _sb.append(" != null) {");
                this.preformula.add(_sb.toString());
                _sb = new StringBuilder();
                _sb.append("            ");
                _sb.append("for (");
                _sb.append(_packagename);
                _sb.append(_expression.store.classname);
                _sb.append(" __o : ");
                _sb.append(_expression.store.varname);
                if (isMultipleRef) {
                    _sb.append("_ary");
                }
                _sb.append(") {");
                this.preformula.add(_sb.toString());
                _sb = new StringBuilder();
                _sb.append("                ");
                _sb.append("if (__o.getChoose()) {");
                this.preformula.add(_sb.toString());
                _sb = new StringBuilder();
                _sb.append("                    ");
                _sb.append(_expression.store.varname);
                _sb.append(" = __o;");
                this.preformula.add(_sb.toString());
                _sb = new StringBuilder();
                _sb.append("                    ");
                _sb.append("break;");
                this.preformula.add(_sb.toString());
                _sb = new StringBuilder();
                _sb.append("                ");
                _sb.append("}");
                this.preformula.add(_sb.toString());
                _sb = new StringBuilder();
                _sb.append("            ");
                _sb.append("}");
                this.preformula.add(_sb.toString());
                _sb = new StringBuilder();
                _sb.append("        ");
                _sb.append("}");
                this.preformula.add(_sb.toString());
            }
            HashSet<String> processedNullCheckItemName = new HashSet<String>();
            _sb = new StringBuilder();
            _sb.append(mtab + "    ");
            _sb.append("if (");
            for (ExpandExpression _expression : _expressions) {
                if (_expression.master.size() > 0) {
                    for (ClassVarnamePair cv : _expression.master) {
                        if (cv.classname == null || cv.varname != null && _expression.store != null && cv.varname.equals(_expression.store.varname) || skippedMasterClassnameSet != null && skippedMasterClassnameSet.contains(cv.classname)) continue;
                        _sb.append("_" + cv.varname + "_code_m != null && ");
                    }
                }
                if (_expression.store == null || _expression.store.classname == null || _expression.useSizeOperator || _expression.useIsNullOperator || processedNullCheckItemName.contains(_expression.store.varname)) continue;
                _sb.append(_expression.store.varname);
                _sb.append(" != null && ");
                processedNullCheckItemName.add(_expression.store.varname);
            }
            for (ExpandExpression _expression : _expressions) {
                if (_expression.content == null) continue;
                _sb.append(_expression.content);
            }
            if (_sb.toString().endsWith(" && ")) {
                int len = _sb.toString().length();
                _sb.delete(len - " && ".length(), len);
            }
            _sb.append(") {");
            this.preformula.add(_sb.toString());
        }
    }

    class ExpandExpression {
        Set<ClassVarnamePair> master = new LinkedHashSet<ClassVarnamePair>();
        ClassVarnamePair multiple;
        String content;
        ClassVarnamePair store;
        boolean useSizeOperator;
        boolean useIsNullOperator;
        boolean useCheckOperator;

        ExpandExpression() {
        }

        public String toString() {
            return this.content;
        }

        public boolean isContentOnly() {
            return this.master.size() == 0 && this.multiple == null || this.useSizeOperator || this.useCheckOperator;
        }

        public void useSizeOperator(boolean useSizeOperator) {
            this.useSizeOperator = useSizeOperator;
        }

        public void useIsNullOperator(boolean useIsNullOperator) {
            this.useIsNullOperator = useIsNullOperator;
        }

        public void useCheckOperator(boolean useCheckOperator) {
            this.useCheckOperator = useCheckOperator;
        }

        public String debug() {
            StringBuilder sb = new StringBuilder();
            if (this.master != null) {
                sb.append("master=" + this.master + ",");
            }
            if (this.multiple != null) {
                sb.append("multiple=" + this.multiple + ",");
            }
            if (this.store != null) {
                sb.append("store=" + this.store + ",");
            }
            sb.append(",content=" + StringUtil.removePreAndPostWhitespace((String)this.content) + ",useSizeOp=" + this.useSizeOperator + ",useIsNullOp=" + this.useIsNullOperator);
            sb.append(",useCheckOp=" + this.useCheckOperator + ",isContentOnly=" + this.isContentOnly());
            return sb.toString();
        }
    }

    class ClassVarnamePair {
        String classname;
        String varname;
        String type;

        ClassVarnamePair() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[class:" + this.classname);
            sb.append(" var:" + this.varname);
            sb.append(" type:" + this.type);
            sb.append("]");
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof ClassVarnamePair)) {
                return false;
            }
            ClassVarnamePair cv = (ClassVarnamePair)o;
            return this.classname != null && this.classname.equals(cv.classname) && this.varname != null && this.varname.equals(cv.varname);
        }

        public int hashCode() {
            int hc = this.classname != null ? this.classname.hashCode() : 0;
            return hc += this.type != null ? hc + this.type.hashCode() : (hc += this.varname != null ? hc + this.varname.hashCode() : hc);
        }
    }
}

