/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import jp.jasminesoft.jfc.gen.HelperGenerator_calc_base0;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.StringUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelperGenerator_calc_padding
extends HelperGenerator_calc_base0 {
    private static final Logger logger = LogManager.getLogger((String)HelperGenerator_calc_padding.class.getName());

    public HelperGenerator_calc_padding(Project project, Model model, String id, String pname, String cname, String type, String content) {
        super(project, model, id, pname, cname, type, content);
    }

    @Override
    public void comment() {
    }

    @Override
    public boolean isError() {
        if (this.content == null || this.content.length() == 0) {
            Object[] o = new Object[]{this.id, this.name};
            logger.error(this.rman.getValue("helper.invalid.autocalc.content.null", o));
            this.setError();
            return true;
        }
        return false;
    }

    @Override
    public void process_single(String basetab, String id, String name, String type) {
        this.process_common(basetab, id, name, type, ProcessType.Single);
    }

    @Override
    public void process_multi_op(String basetab) {
        this.process_common(basetab, this.id, this.name, this.type, ProcessType.Multiple);
    }

    protected void process_common(String basetab, String id, String name, String type, ProcessType ptype) {
        int ptr = this.content.indexOf(",");
        String padding_char = this.content.substring(0, ptr);
        String padding_length_str = this.content.substring(ptr + 1);
        if (padding_char == null || padding_char.length() == 0) {
            Object[] o = new Object[]{id, name};
            logger.error(this.rman.getValue("helper.invalid.autocalc.padding.char.null", o));
            return;
        }
        char c = padding_char.charAt(0);
        int len = StringUtil.intValue((String)padding_length_str);
        if (len == 0) {
            Object[] o = new Object[]{id, name, padding_length_str};
            logger.error(this.rman.getValue("helper.invalid.autocalc.padding.length", o));
            return;
        }
        if (ptype == ProcessType.Single) {
            this.sb.append(basetab);
            this.sb.append(id);
            this.sb.append(".");
            this.sb.append(JavaSourceGenerator.setterMethod(name));
            this.sb.append("(");
            this.sb.append("PADDING(");
            this.sb.append("'");
            this.sb.append(c);
            this.sb.append("'");
            this.sb.append(",");
            this.sb.append(len);
            this.sb.append(",");
            this.sb.append(id);
            this.sb.append(JavaSourceGenerator.getterFullMethod(name));
            this.sb.append("));");
            this.sb.append(CR);
        } else {
            this.sb.append(basetab);
            this.sb.append(id);
            this.sb.append(".");
            this.sb.append(JavaSourceGenerator.setterMethod(this.cname));
            this.sb.append("(");
            this.sb.append("i, ");
            this.sb.append("PADDING(");
            this.sb.append("'");
            this.sb.append(c);
            this.sb.append("'");
            this.sb.append(",");
            this.sb.append(len);
            this.sb.append(",");
            this.sb.append("__" + this.cname + "[i]");
            this.sb.append("));");
            this.sb.append(CR);
        }
    }

    private static enum ProcessType {
        Single,
        Multiple;

    }
}

