/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.Iterator;
import java.util.Map;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.HelperGeneratorBaseTask;
import jp.jasminesoft.jfc.gen.JFCAppResourceGenerator;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Chartype;
import jp.jasminesoft.jfc.gen.appschema.Condition;
import jp.jasminesoft.jfc.gen.appschema.Conditionlist;
import jp.jasminesoft.jfc.gen.appschema.Control;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.util.ResourceManagerFactory;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelperGenerator_chartype
extends HelperGeneratorBaseTask {
    private Project project;
    protected Map chartypeMap;
    protected StringBuilder errmsg;
    private boolean isWarning;
    private String basetab;
    protected Logger logger = LogManager.getLogger((String)HelperGenerator_chartype.class.getName());

    public HelperGenerator_chartype(Project project, Model model, Modelitem item, Map chartypeMap, boolean isWarning) {
        this.project = project;
        this.model = model;
        this.item = item;
        this.chartypeMap = chartypeMap;
        this.isWarning = isWarning;
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
    }

    public HelperGenerator_chartype(Project project, Model model, Modelitem item, Map chartypeMap) {
        this(project, model, item, chartypeMap, false);
    }

    @Override
    public String process() {
        return this.process("");
    }

    @Override
    public String process(String basetab) {
        Object[] o;
        Condition condition;
        Conditionlist conditionlist;
        Model smodel;
        Action showListAction;
        if (this.chartypeMap.size() < 1) {
            return "";
        }
        this.basetab = basetab;
        boolean isRuntimePartMatch = false;
        Model _model = (Model)this.model.getIdrefAsIRNode();
        if ("condition".equals(_model.getType()) && (showListAction = AppSchemaUtil.getActionByModelIdAndType(this.project, (smodel = AppSchemaUtil.getStoreModel(_model)).getId(), "showList")) != null && (conditionlist = AppSchemaUtil.getConditionlist(showListAction)) != null && (condition = AppSchemaUtil.getCondition(conditionlist, this.item.getName())) != null && "LIKE".equals(condition.getCond()) && "runtime".equals(condition.getMatchtype())) {
            isRuntimePartMatch = true;
        }
        Chartype content = null;
        StringBuilder sb = new StringBuilder();
        if (this.chartypeMap.containsKey("date")) {
            content = (Chartype)this.chartypeMap.get("date");
            sb.append(this.gDate(this.getSeparator(content)));
        } else if (this.chartypeMap.containsKey("date:yyyyMMdd")) {
            content = (Chartype)this.chartypeMap.get("date:yyyyMMdd");
            sb.append(this.gDate_yyyyMMdd(this.getSeparator(content)));
        } else if (this.chartypeMap.containsKey("date:yyyyMM")) {
            content = (Chartype)this.chartypeMap.get("date:yyyyMM");
            sb.append(this.gDate_yyyyMM(this.getSeparator(content)));
        } else if (this.chartypeMap.containsKey("time")) {
            content = (Chartype)this.chartypeMap.get("time");
            sb.append(this.gTime(this.getSeparator(content)));
        } else if (this.chartypeMap.containsKey("datetime")) {
            content = (Chartype)this.chartypeMap.get("datetime");
            sb.append(this.gDateTime(this.getSeparator(content)));
        } else if (this.chartypeMap.containsKey("mailaddress")) {
            content = (Chartype)this.chartypeMap.get("mailaddress");
            if (!isRuntimePartMatch) {
                sb.append(this.gMailaddress(this.getSeparator(content)));
            } else {
                sb.append(this.gMailaddressIncludingPartialMatchOperator(this.getSeparator(content)));
            }
        }
        if (content != null) {
            o = new Object[]{this.model.getId(), this.item.getName(), content.getContent()};
            if (content.getMaxlength() > 0 || content.getMinlength() > 0) {
                this.logger.error(this.rman.getValue("helper.invalid.chartype.setlength", o));
            }
            if (this.chartypeMap.size() > 1) {
                this.logger.warn(this.rman.getValue("helper.invalid.chartype.multi", o));
            }
            return sb.toString();
        }
        if (this.chartypeMap.containsKey("number") && this.chartypeMap.size() == 1) {
            content = (Chartype)this.chartypeMap.get("number");
            o = new Object[]{this.model.getId(), this.item.getName(), content.getContent()};
            if (content.getMaxlength() > 0 || content.getMinlength() > 0) {
                this.logger.error(this.rman.getValue("helper.invalid.chartype.setlength", o));
            }
            return this.gNumber(this.getSeparator(content));
        }
        return this.gMultiCheckMethod();
    }

    protected String getSeparator(Chartype content) {
        String sep = content.getSeparator();
        if (sep != null && sep.length() == 0) {
            sep = null;
        }
        return sep;
    }

    protected String gNumber(String sep) {
        return this.gMethod(this.rman.getValue("helper.comment.chartype.number"), "StringCheck.isNumber", this.createErrorCode("error.input.numberonly"), sep, false, false);
    }

    protected String gDate(String sep) {
        return this.gMethod(this.rman.getValue("helper.comment.chartype.date"), "StringCheck.isDate", this.createErrorCode("error.input.notdateformat"), sep, false, true);
    }

    protected String gDate_yyyyMMdd(String sep) {
        return this.gMethod(this.rman.getValue("helper.comment.chartype.date.yyyyMMdd"), "DateTimeUtil.checkFormat_yyyyMMdd", this.createErrorCode("error.input.notdateformat.yyyyMMdd"), sep, false, true);
    }

    protected String gDate_yyyyMM(String sep) {
        return this.gMethod(this.rman.getValue("helper.comment.chartype.date.yyyyMM"), "DateTimeUtil.checkFormat_yyyyMM", this.createErrorCode("error.input.notdateformat.yyyyMM"), sep, false, true);
    }

    protected String gTime(String sep) {
        return this.gMethod(this.rman.getValue("helper.comment.chartype.time"), "StringCheck.isTime", this.createErrorCode("error.input.nottimeformat"), sep, false, true);
    }

    protected String gDateTime(String sep) {
        return this.gMethod(this.rman.getValue("helper.comment.chartype.datetime"), "StringCheck.isDateTime", this.createErrorCode("error.input.notdatetimeformat"), sep, false, true);
    }

    protected String gMailaddress(String sep) {
        return this.gMethod(this.rman.getValue("helper.comment.chartype.mailaddress"), "MimeMailUtilities.isValidMailAddress", this.createErrorCode("error.input.mailaddress"), sep, false, false);
    }

    protected String gMailaddressIncludingPartialMatchOperator(String sep) {
        return this.gMethod(this.rman.getValue("helper.comment.chartype.mailaddress"), "MimeMailUtilities.isValidMailaddressIncludingPartialMatchOperator", this.createErrorCode("error.input.mailaddress"), sep, false, false);
    }

    protected String gMultiCheckMethod() {
        StringBuilder sb = new StringBuilder();
        this.errmsg = new StringBuilder();
        sb.append(this.basetab + "        ");
        if (this.isWarning) {
            sb.append("AbstractChartype[] chartypesWarn = {");
        } else {
            sb.append("AbstractChartype[] chartypesError = {");
        }
        Iterator it = this.chartypeMap.values().iterator();
        boolean first = true;
        String sep = null;
        while (it.hasNext()) {
            Object[] o;
            Chartype content = (Chartype)it.next();
            String className = this.convertClassName(content.getContent());
            if (className == null) {
                Object[] o2 = new Object[]{this.model.getId(), this.item.getName(), content.getContent()};
                this.logger.error(this.rman.getValue("helper.invalid.chartype.value", o2));
                continue;
            }
            String anychars = null;
            if (className.equals("CtAnyCharacter")) {
                String cnt = content.getContent();
                if (cnt.startsWith("any-character:")) {
                    anychars = cnt.substring("any-character:".length());
                }
                if (StringUtils.isBlank(anychars)) continue;
            }
            if (!first) {
                sb.append(",");
                sb.append(CR);
                sb.append(this.basetab + "                                        ");
            } else {
                first = false;
            }
            sb.append(" new ");
            sb.append(className);
            sb.append("(");
            if (className.equals("CtAnyCharacter")) {
                sb.append("\"").append(StringUtil.convertJavaString((String)anychars)).append("\"");
            }
            if (content.getMaxlength() > 0) {
                if (this.chartypeMap.size() == 1) {
                    o = new Object[]{this.model.getId(), this.item.getName(), content.getContent()};
                    this.logger.error(this.rman.getValue("helper.invalid.chartype.setlength", o));
                } else {
                    if (className.equals("CtAnyCharacter")) {
                        sb.append(", ");
                    }
                    sb.append(content.getMaxlength());
                    sb.append(", ");
                    this.errmsg.append(" +");
                    this.errmsg.append(CR);
                    this.errmsg.append(this.basetab + "                        ");
                    this.errmsg.append("manager.getJfcerror(\"" + this.createErrorCode("error.input.chartype.lessthan") + "\", new Object[]{\"" + content.getMaxlength() + "\"}, p.locale).getContent()");
                    if (content.getMinlength() > 0) {
                        sb.append(content.getMinlength());
                        this.errmsg.append(" +");
                        this.errmsg.append(CR);
                        this.errmsg.append(this.basetab + "                        ");
                        this.errmsg.append("manager.getJfcerror(\"" + this.createErrorCode("error.input.chartype.morethan") + "\", new Object[]{\"" + content.getMinlength() + "\"}, p.locale).getContent()");
                    } else {
                        sb.append("-1");
                    }
                }
            } else if (content.getMinlength() > 0) {
                if (this.chartypeMap.size() == 1) {
                    o = new Object[]{this.model.getId(), this.item.getName(), content.getContent()};
                    this.logger.error(this.rman.getValue("helper.invalid.chartype.setlength", o));
                } else {
                    if (className.equals("CtAnyCharacter")) {
                        sb.append(", ");
                    }
                    sb.append("-1");
                    sb.append(", ");
                    sb.append(content.getMinlength());
                    this.errmsg.append(" +");
                    this.errmsg.append(CR);
                    this.errmsg.append(this.basetab + "                        ");
                    this.errmsg.append("manager.getJfcerror(\"" + this.createErrorCode("error.input.chartype.morethan") + "\", new Object[]{\"" + content.getMinlength() + "\"}, p.locale).getContent()");
                }
            }
            sb.append(")");
            this.errmsg.append(" +");
            this.errmsg.append(CR);
            this.errmsg.append(this.basetab + "                        ");
            this.errmsg.append("manager.getJfcerror(\"" + this.createErrorCode("error.input.chartype.endchar") + "\", p.locale).getContent()");
            if (content.getSeparator() == null) continue;
            if (sep == null) {
                sep = content.getSeparator();
                continue;
            }
            o = new Object[]{this.model.getId(), this.item.getName(), sep};
            this.logger.error(this.rman.getValue("helper.invalid.chartype.separetor", o));
        }
        sb.append(" };");
        sb.append(CR);
        sb.append(this.gMethod(this.rman.getValue("helper.comment.chartype"), "StringCheck.checkChartype", "", sep, true, false));
        return sb.toString();
    }

    protected String convertClassName(String type) {
        if ("number".equals(type)) {
            this.errmsg.append(" +");
            this.errmsg.append(CR);
            this.errmsg.append(this.basetab + "                        ");
            this.errmsg.append("manager.getJfcerror(\"" + this.createErrorCode("error.input.chartype.number") + "\", p.locale).getContent()");
            return "CtNumber";
        }
        if ("hankaku-number".equals(type)) {
            this.errmsg.append(" +");
            this.errmsg.append(CR);
            this.errmsg.append(this.basetab + "                        ");
            this.errmsg.append("manager.getJfcerror(\"" + this.createErrorCode("error.input.chartype.hankaku-number") + "\", p.locale).getContent()");
            return "CtHankakuNumber";
        }
        if ("zenkaku-number".equals(type)) {
            this.errmsg.append(" +");
            this.errmsg.append(CR);
            this.errmsg.append(this.basetab + "                        ");
            this.errmsg.append("manager.getJfcerror(\"" + this.createErrorCode("error.input.chartype.zenkaku-number") + "\", p.locale).getContent()");
            return "CtZenkakuNumber";
        }
        if ("alphabet".equals(type)) {
            this.errmsg.append(" +");
            this.errmsg.append(CR);
            this.errmsg.append(this.basetab + "                        ");
            this.errmsg.append("manager.getJfcerror(\"" + this.createErrorCode("error.input.chartype.alphabet") + "\", p.locale).getContent()");
            return "CtAlphabet";
        }
        if ("hankaku-alphabet".equals(type)) {
            this.errmsg.append(" +");
            this.errmsg.append(CR);
            this.errmsg.append(this.basetab + "                        ");
            this.errmsg.append("manager.getJfcerror(\"" + this.createErrorCode("error.input.chartype.hankaku-alphabet") + "\", p.locale).getContent()");
            return "CtHankakuAlphabet";
        }
        if ("hankaku-upper-alphabet".equals(type)) {
            this.errmsg.append(" +");
            this.errmsg.append(CR);
            this.errmsg.append(this.basetab + "                        ");
            this.errmsg.append("manager.getJfcerror(\"" + this.createErrorCode("error.input.chartype.hankaku-upper-alphabet") + "\", p.locale).getContent()");
            return "CtHankakuUpperAlphabet";
        }
        if ("hankaku-lower-alphabet".equals(type)) {
            this.errmsg.append(" +");
            this.errmsg.append(CR);
            this.errmsg.append(this.basetab + "                        ");
            this.errmsg.append("manager.getJfcerror(\"" + this.createErrorCode("error.input.chartype.hankaku-lower-alphabet") + "\", p.locale).getContent()");
            return "CtHankakuLowerAlphabet";
        }
        if ("zenkaku-alphabet".equals(type)) {
            this.errmsg.append(" +");
            this.errmsg.append(CR);
            this.errmsg.append(this.basetab + "                        ");
            this.errmsg.append("manager.getJfcerror(\"" + this.createErrorCode("error.input.chartype.zenkaku-alphabet") + "\", p.locale).getContent()");
            return "CtZenkakuAlphabet";
        }
        if ("zenkaku-upper-alphabet".equals(type)) {
            this.errmsg.append(" +");
            this.errmsg.append(CR);
            this.errmsg.append(this.basetab + "                        ");
            this.errmsg.append("manager.getJfcerror(\"" + this.createErrorCode("error.input.chartype.zenkaku-upper-alphabet") + "\", p.locale).getContent()");
            return "CtZenkakuUpperAlphabet";
        }
        if ("zenkaku-lower-alphabet".equals(type)) {
            this.errmsg.append(" +");
            this.errmsg.append(CR);
            this.errmsg.append(this.basetab + "                        ");
            this.errmsg.append("manager.getJfcerror(\"" + this.createErrorCode("error.input.chartype.zenkaku-lower-alphabet") + "\", p.locale).getContent()");
            return "CtZenkakuLowerAlphabet";
        }
        if ("hiragana".equals(type)) {
            this.errmsg.append(" +");
            this.errmsg.append(CR);
            this.errmsg.append(this.basetab + "                        ");
            this.errmsg.append("manager.getJfcerror(\"" + this.createErrorCode("error.input.chartype.hiragana") + "\", p.locale).getContent()");
            return "CtHiragana";
        }
        if ("katakana".equals(type)) {
            this.errmsg.append(" +");
            this.errmsg.append(CR);
            this.errmsg.append(this.basetab + "                        ");
            this.errmsg.append("manager.getJfcerror(\"" + this.createErrorCode("error.input.chartype.katakana") + "\", p.locale).getContent()");
            return "CtKatakana";
        }
        if ("hankaku-katakana".equals(type)) {
            this.errmsg.append(" +");
            this.errmsg.append(CR);
            this.errmsg.append(this.basetab + "                        ");
            this.errmsg.append("manager.getJfcerror(\"" + this.createErrorCode("error.input.chartype.hankaku-katakana") + "\", p.locale).getContent()");
            return "CtHankakuKatakana";
        }
        if ("zenkaku-katakana".equals(type)) {
            this.errmsg.append(" +");
            this.errmsg.append(CR);
            this.errmsg.append(this.basetab + "                        ");
            this.errmsg.append("manager.getJfcerror(\"" + this.createErrorCode("error.input.chartype.zenkaku-katakana") + "\", p.locale).getContent()");
            return "CtZenkakuKatakana";
        }
        if ("kigou".equals(type)) {
            this.errmsg.append(" +");
            this.errmsg.append(CR);
            this.errmsg.append(this.basetab + "                        ");
            this.errmsg.append("manager.getJfcerror(\"" + this.createErrorCode("error.input.chartype.kigou") + "\", p.locale).getContent()");
            return "CtKigou";
        }
        if ("hankaku-kigou".equals(type)) {
            this.errmsg.append(" +");
            this.errmsg.append(CR);
            this.errmsg.append(this.basetab + "                        ");
            this.errmsg.append("manager.getJfcerror(\"" + this.createErrorCode("error.input.chartype.hankaku-kigou") + "\", p.locale).getContent()");
            return "CtHankakuKigou";
        }
        if ("zenkaku-kigou".equals(type)) {
            this.errmsg.append(" +");
            this.errmsg.append(CR);
            this.errmsg.append(this.basetab + "                        ");
            this.errmsg.append("manager.getJfcerror(\"" + this.createErrorCode("error.input.chartype.zenkaku-kigou") + "\", p.locale).getContent()");
            return "CtZenkakuKigou";
        }
        if ("whitespace".equals(type)) {
            this.errmsg.append(" +");
            this.errmsg.append(CR);
            this.errmsg.append(this.basetab + "                        ");
            this.errmsg.append("manager.getJfcerror(\"" + this.createErrorCode("error.input.chartype.whitespace") + "\", p.locale).getContent()");
            return "CtWhitespace";
        }
        if (type.startsWith("any-character:")) {
            String rest = StringUtils.removeStart((String)type, (String)"any-character:");
            if (StringUtils.isBlank((CharSequence)rest)) {
                return null;
            }
            this.errmsg.append(" +");
            this.errmsg.append(CR);
            this.errmsg.append(this.basetab + "                        ");
            this.errmsg.append("manager.getJfcerror(\"" + this.createErrorCode("error.input.chartype.anycharacter") + "\", p.locale).getContent()");
            this.errmsg.append(" + \" '").append(StringUtil.convertJavaString((String)rest)).append("'\"");
            return "CtAnyCharacter";
        }
        if ("wildcard".equals(type)) {
            return "CtWildcard";
        }
        return null;
    }

    private String gMethod(String comment, String methodname, String errorid, String param_separator, boolean charMultiFlag, boolean checkStoreModel) {
        String varname;
        String cname;
        Object pname;
        String itemname;
        String sid;
        String _label;
        StringBuilder sb = new StringBuilder();
        String label = this.item.getLabel();
        if (label == null || label.length() == 0) {
            label = this.item.getName();
        }
        Relation relation = AppSchemaUtil.getRelationFromPModel(this.model, this.item);
        Model smodel = (Model)this.model.getIdrefAsIRNode();
        if ("list".equals(smodel.getType())) {
            smodel = (Model)smodel.getIdrefAsIRNode();
        }
        if (StringUtils.isNotBlank((CharSequence)(_label = AppSchemaUtil.getLabeli18n(this.item, sid = smodel.getId(), this.model, this.project)))) {
            label = _label;
        }
        String sitemname = (itemname = this.item.getName()).endsWith("jshparam") ? itemname.substring(0, itemname.length() - "xjshparam".length()) : itemname;
        Modelitem sitem = AppSchemaUtil.getModelitem(sitemname, AppSchemaUtil.getStoreModel(this.model));
        if ((AppSchemaUtil.hasChildPart(itemname) || sitem != null && sitem.getMultiple()) && "store".equals(smodel.getType())) {
            pname = "__" + AppSchemaUtil.getParentPart(itemname) + "_ary";
            cname = AppSchemaUtil.getChildPart(itemname);
        } else {
            pname = sid;
            cname = AppSchemaUtil.getChildPart(itemname);
        }
        String rkey = null;
        if (smodel != null) {
            rkey = JFCAppResourceGenerator.createModelResourceKey(smodel.getId(), this.item.getName(), label);
            JFCAppResourceGenerator.put(rkey, label);
        }
        Modelitem pitem = sitem != null ? AppSchemaUtil.getModelitem(sitem.getName(), this.model) : null;
        Control control_hidden = AppSchemaUtil.getControlTypeIsHidden(pitem);
        Control control_readonly = AppSchemaUtil.getControlTypeIsReadonly(pitem);
        sb.append(this.basetab + "        ");
        sb.append("// " + comment);
        sb.append(CR);
        if (AppSchemaUtil.hasControl(this.item) && AppSchemaUtil.hasChildPart(this.item.getName())) {
            sb.append(this.basetab + "        ");
            sb.append("if (_isContainsId) {").append(CR);
        }
        sb.append(this.basetab + "        ");
        sb.append("if (s != null && s.length() > 0) {");
        sb.append(CR);
        if (param_separator == null) {
            varname = "s";
        } else {
            sb.append(this.basetab + "            ");
            sb.append("StringTokenizer st = new StringTokenizer(s, ");
            sb.append("\"" + param_separator + "\");");
            sb.append(CR);
            sb.append(this.basetab + "            ");
            sb.append("Set tokenSet = new HashSet();");
            sb.append(CR);
            sb.append(this.basetab + "            ");
            sb.append("while (st.hasMoreTokens()) {");
            sb.append(CR);
            sb.append(this.basetab + "                ");
            sb.append("String token = st.nextToken();");
            sb.append(CR);
            this.basetab = this.basetab + "    ";
            varname = "token";
        }
        sb.append(this.basetab + "            ");
        sb.append("if (");
        boolean isMoreCheck = false;
        if (checkStoreModel && control_hidden == null && control_readonly == null && !sitem.getTransient()) {
            sb.append("(" + (String)pname + " != null && ");
            if ((AppSchemaUtil.hasChildPart(itemname) || sitem != null && sitem.getMultiple()) && "store".equals(smodel.getType())) {
                sb.append("i < ");
                sb.append((String)pname);
                sb.append(".length && ");
                sb.append((String)pname + "[i]");
                if (sitem == null || !sitem.getMultiple()) {
                    sb.append(JavaSourceGenerator.getterFullMethod(cname));
                }
                sb.append(" == null) || (");
            } else {
                sb.append((String)pname);
                sb.append(JavaSourceGenerator.getterFullMethod(cname));
                sb.append(" == null) || (");
            }
            sb.append((String)pname);
            sb.append(" == null && ");
            isMoreCheck = true;
        }
        sb.append("!" + methodname + "(" + varname);
        if (charMultiFlag) {
            if (this.isWarning) {
                sb.append(", chartypesWarn");
            } else {
                sb.append(", chartypesError");
            }
        }
        if (isMoreCheck) {
            sb.append(")");
        }
        sb.append(")) ");
        sb.append("{");
        sb.append(CR);
        sb.append(this.basetab + "                ");
        sb.append("Object[] o = { ");
        sb.append("getRValue(\"" + rkey + "\", p)");
        sb.append("");
        sb.append(" };");
        sb.append(CR);
        sb.append(this.basetab + "                ");
        if (this.isWarning) {
            sb.append("jp.jasminesoft.jfc.error.Jfcwarn _warn =");
            sb.append(CR);
            if (charMultiFlag) {
                sb.append(this.basetab + "                    ");
                sb.append("new jp.jasminesoft.jfc.error.Jfcwarn();");
                sb.append(CR);
                sb.append(this.basetab + "                ");
                sb.append("_warn.setCode(\"error.input.chartype\");");
                sb.append(CR);
                sb.append(this.basetab + "                ");
                sb.append("_warn.setContent(");
                sb.append("manager.getJfcwarn(\"" + this.createErrorCode("error.input.chartype") + "\", o, p.locale).getContent()");
                sb.append(" +  \" [ \" " + this.errmsg + " + \" ]\"");
                sb.append(");");
                sb.append(CR);
            } else {
                sb.append(this.basetab + "                    ");
                sb.append("manager.getJfcwarn(\"" + errorid + "\", o, p.locale);");
                sb.append(CR);
            }
            sb.append(this.basetab + "                ");
            sb.append("JFCHelperUtils.checkWarnedError(p, String.valueOf(s), _warn, \"");
            sb.append(rkey);
            sb.append("\", \"" + this.createErrorCode("error.input.chartype") + "\");");
            sb.append(CR);
        } else {
            sb.append("jp.jasminesoft.jfc.error.Jfcerror _error =");
            sb.append(CR);
            if (charMultiFlag) {
                sb.append(this.basetab + "                    ");
                sb.append("new jp.jasminesoft.jfc.error.Jfcerror();");
                sb.append(CR);
                sb.append(this.basetab + "                ");
                sb.append("_error.setCode(\"error.input.chartype\");");
                sb.append(CR);
                sb.append(this.basetab + "                ");
                sb.append("_error.setContent(");
                sb.append("manager.getJfcerror(\"" + this.createErrorCode("error.input.chartype") + "\", o, p.locale).getContent()");
                sb.append(" +  \" [ \" " + this.errmsg + " + \" ]\"");
                sb.append(");");
                sb.append(CR);
            } else {
                sb.append(this.basetab + "                    ");
                sb.append("manager.getJfcerror(\"" + errorid + "\", o, p.locale);");
                sb.append(CR);
            }
            sb.append(this.basetab + "                ");
            sb.append("p.errors.addJfcerror(_error);");
            sb.append(CR);
            if (!this.multiFlag) {
                if (relation == null || relation != null && relation.getType().equals("ref") && !this.model.getId().endsWith("_ulp")) {
                    sb.append(this.basetab + "                ");
                    sb.append("values.setErrorcode(_error.getContent());");
                    sb.append(CR);
                }
            } else {
                sb.append(this.basetab + "                ");
                sb.append(this.item.getName() + "_ary[i].setErrorcode(_error.getContent());");
                sb.append(CR);
            }
        }
        sb.append(this.basetab + "            ");
        sb.append("}");
        sb.append(CR);
        sb.append(this.basetab + "        ");
        sb.append("}");
        sb.append(CR);
        if (param_separator != null) {
            sb.append(this.basetab + "    ");
            sb.append("}");
            sb.append(CR);
        }
        if (AppSchemaUtil.hasControl(this.item) && AppSchemaUtil.hasChildPart(this.item.getName())) {
            sb.append(this.basetab + "        ").append("}").append(CR);
        }
        return sb.toString();
    }
}

