/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.HelperGeneratorBaseTask;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.ResourceManagerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelperGenerator_filter_init
extends HelperGeneratorBaseTask {
    protected Logger logger = LogManager.getLogger((String)HelperGenerator_filter_init.class.getName());
    protected Project project;

    public HelperGenerator_filter_init(Project project, Model model) {
        this.project = project;
        this.model = model;
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
    }

    @Override
    public String process() {
        return this.process("");
    }

    @Override
    public String process(String basetab) {
        StringBuilder sb = new StringBuilder();
        LinkedHashMap<String, Modelitem> itemMap = new LinkedHashMap<String, Modelitem>();
        IModelChoice[] imc = this.model.getContent();
        if (imc != null) {
            for (int i = 0; i < imc.length; ++i) {
                if (!(imc[i] instanceof Modelitem)) continue;
                Modelitem item = (Modelitem)imc[i];
                itemMap.put(item.getName(), item);
            }
        }
        HashSet processedItemNameSet = new HashSet();
        for (String name : itemMap.keySet()) {
            Modelitem item = (Modelitem)itemMap.get(name);
            if (processedItemNameSet.contains(name)) continue;
            String elementname = item.getName();
            if (elementname.charAt(0) == '/') {
                elementname = elementname.substring(1);
            }
            elementname = SourceGenerator.getElementNameByNestLevel(elementname, 0);
            sb.append(this.gModelitemProcess(item, this.model, itemMap, basetab, 0, null, null, processedItemNameSet));
        }
        return sb.toString();
    }

    protected String gModelitemProcess(Modelitem item, Model model, Map itemMap, String basetab, int nestlevel, String id, String rid, Set processedItemNameSet) {
        String filtername;
        if (item == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (item.getHasChild()) {
            sb.append(this.gHasChild(item, model, itemMap, basetab, nestlevel, id, id, processedItemNameSet));
            return sb.toString();
        }
        String string = filtername = item != null ? item.getFilter() : null;
        if (filtername == null || filtername.length() == 0) {
            return sb.toString();
        }
        if (item.getMultiple()) {
            sb.append(this.gAdaptMultiFilter(item, model, id == null ? model.getId() : id, filtername, basetab, nestlevel));
        } else {
            sb.append(this.gAdaptFilter(item, model, id == null ? model.getId() : id, filtername, basetab, nestlevel));
        }
        processedItemNameSet.add(item.getName());
        return sb.toString();
    }

    protected String gHasChild(Modelitem ritem, Model rmodel, Map itemMap, Set processedItemNameSet) {
        return this.gHasChild(ritem, rmodel, itemMap, "", 0, null, null, processedItemNameSet);
    }

    protected String gHasChild(Modelitem ritem, Model rmodel, Map itemMap, String basetab, int nestlevel, String id, String rid, Set processedItemNameSet) {
        StringBuilder sb = new StringBuilder();
        if (nestlevel > 24) {
            this.logger.error(this.rman.getValue("helper.comment.nestover", this.model.getId()));
            return sb.toString();
        }
        char loopv = (char)(97 + nestlevel);
        String varname = SourceGenerator.getElementNameByNestLevel(ritem.getName(), nestlevel);
        String fullname = SourceGenerator.getFullNameByNestLevel(ritem.getName(), nestlevel);
        Modelitem fullname_mitem = AppSchemaUtil.getModelitem(fullname, rmodel);
        String fullname_mitem_classname = AppSchemaUtil.getModelitemClassname(fullname_mitem);
        id = id == null ? this.model.getId() : id;
        rid = rid == null ? rmodel.getId() : rid;
        String packagename = AppSchemaUtil.getPackagename(this.model, this.project);
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("// " + varname + " : Multiple");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append(packagename);
        sb.append(fullname_mitem_classname + "[]");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append(varname + "_ary = ");
        sb.append(id);
        sb.append(JavaSourceGenerator.getterFullMethod(varname));
        sb.append(";");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("if (");
        sb.append(varname + "_ary");
        sb.append(" != null) {");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("int size = ");
        sb.append(varname + "_ary");
        sb.append(".length;");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("for (int _" + loopv + "=0; ");
        sb.append("_" + loopv + "<size; _" + loopv + "++) {");
        sb.append(CR);
        sb.append(basetab + "                ");
        sb.append(packagename);
        sb.append(fullname_mitem_classname);
        sb.append(" ");
        sb.append(varname);
        sb.append(" =");
        sb.append(CR);
        sb.append(basetab + "                    ");
        sb.append(varname + "_ary[_" + loopv + "];");
        sb.append(CR);
        IModelChoice[] imc = rmodel.getContent();
        if (imc != null) {
            for (int i = 0; i < imc.length; ++i) {
                if (!(imc[i] instanceof Modelitem)) continue;
                Modelitem _item = (Modelitem)imc[i];
                String _name = _item.getName();
                if (_name.charAt(0) == '/') {
                    _name = _name.substring(1);
                }
                if (!_name.startsWith(varname + "/") && _name.indexOf("/" + varname + "/") <= 0 || _name.equals(varname + "/")) continue;
                sb.append(this.gModelitemProcess(_item, rmodel, itemMap, basetab + "        ", nestlevel + 1, varname, varname, processedItemNameSet));
            }
        }
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("}");
        sb.append(CR);
        return sb.toString();
    }

    protected String gAdaptMultiFilter(Modelitem ritem, Model model, String objectname, String filtername, String basetab, int nestlevel) {
        String elementname = SourceGenerator.getElementNameByNestLevel(ritem.getName(), nestlevel);
        String javaClassType = JavaSourceGenerator.getProperType(ritem.getType());
        StringBuilder sb = new StringBuilder();
        sb.append(basetab + "        ");
        sb.append("if (");
        sb.append(objectname);
        sb.append(JavaSourceGenerator.getterFullMethod(elementname));
        sb.append(" != null) {");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append(javaClassType);
        sb.append("[] ");
        sb.append(elementname);
        sb.append(" = ");
        sb.append(objectname);
        sb.append(JavaSourceGenerator.getterFullMethod(elementname));
        sb.append(";");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("for (int i=0; i<");
        sb.append(elementname);
        sb.append(".length; i++) {");
        sb.append(CR);
        sb.append(basetab + "                ");
        sb.append(elementname);
        sb.append("[i] = ");
        sb.append(filtername);
        sb.append(".filter(");
        sb.append(elementname);
        sb.append("[i]);");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append(objectname);
        sb.append(".");
        sb.append(JavaSourceGenerator.setterMethod(elementname));
        sb.append("(");
        sb.append(elementname);
        sb.append(");");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("}");
        sb.append(CR);
        return sb.toString();
    }

    protected String gAdaptFilter(Modelitem ritem, Model model, String objectname, String filtername, String basetab, int nestlevel) {
        return this.gAdaptFilter(ritem, model, objectname, filtername, basetab, nestlevel, false);
    }

    protected String gAdaptFilter(Modelitem ritem, Model model, String objectname, String filtername, String basetab, int nestlevel, boolean isControlFlag) {
        String elementname = SourceGenerator.getElementNameByNestLevel(ritem.getName(), nestlevel);
        StringBuilder sb = new StringBuilder();
        sb.append(basetab + "        ");
        sb.append("if (");
        sb.append(objectname);
        sb.append(JavaSourceGenerator.getterFullMethod(elementname));
        sb.append(" != null) {");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append(objectname).append(".");
        sb.append(JavaSourceGenerator.setterMethod(elementname)).append("(");
        if (filtername != null) {
            sb.append(filtername);
            sb.append(".filter(");
            sb.append(objectname);
            sb.append(JavaSourceGenerator.getterFullMethod(elementname));
            sb.append(")");
        }
        sb.append(");");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("}");
        sb.append(CR);
        return sb.toString();
    }
}

