/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.HelperGeneratorBaseTask;
import jp.jasminesoft.jfc.gen.HelperGenerator_calc_parser;
import jp.jasminesoft.jfc.gen.HelperGenerator_input_check;
import jp.jasminesoft.jfc.gen.JFCAppResourceGenerator;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.GenericCheck;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.util.ResourceManagerFactory;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelperGenerator_generic_check
extends HelperGeneratorBaseTask {
    private Project project;
    protected GenericCheck gcheck;
    protected Logger logger = LogManager.getLogger((String)HelperGenerator_generic_check.class.getName());

    public HelperGenerator_generic_check(Project project, Model model, Modelitem item, GenericCheck gcheck) {
        this.project = project;
        this.model = model;
        this.item = item;
        this.gcheck = gcheck;
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
    }

    @Override
    public String process() {
        return this.process("");
    }

    @Override
    public String process(String basetab) {
        String tmp;
        int ptr2;
        int ptr;
        Object dstr;
        String tstr;
        String cnt = this.gcheck.getContent();
        if (StringUtils.isEmpty((CharSequence)cnt)) {
            return "";
        }
        boolean updateList = this.model.getUpdatelist();
        Model smodel = AppSchemaUtil.getStoreModel(this.model);
        String sid = smodel.getId();
        String name = HelperGenerator_input_check.getName4ErrorManager(this.item.getName(), this.model);
        Modelitem sitem = AppSchemaUtil.getModelitem(this.item.getName(), smodel);
        if (sitem == null) {
            Object[] o = new Object[]{this.model.getId(), this.item.getName(), this.gcheck.getContent()};
            this.logger.error(this.rman.getValue("helper.inputcheck.invaliditem", o));
            return "";
        }
        Model targetmodel = smodel;
        String header4target = "";
        if ((cnt = StringUtil.removePreAndPostWhitespaceWithoutInside((String)cnt)).startsWith("p;")) {
            cnt = cnt.substring(2);
            targetmodel = this.model;
        }
        StringBuilder sb = new StringBuilder();
        String label = this.item.getLabel();
        if (StringUtils.isBlank((CharSequence)label)) {
            label = this.item.getName();
        }
        String rkey = null;
        if (smodel != null) {
            String label_i18n = AppSchemaUtil.getLabeli18n(this.item, smodel.getId(), this.model, this.project);
            rkey = JFCAppResourceGenerator.createModelResourceKey(smodel.getId(), this.item.getName(), label_i18n);
            JFCAppResourceGenerator.put(rkey, label_i18n);
        }
        String rkey4error = null;
        String errormsg = this.gcheck.getErrormsg();
        if (smodel != null && StringUtils.isNotBlank((CharSequence)errormsg) && StringUtil.removePreAndPostWhitespace((String)errormsg).indexOf("MESSAGE(") < 0) {
            rkey4error = JFCAppResourceGenerator.createModelResourceKey(smodel.getId(), this.item.getName() + ".error", errormsg);
            JFCAppResourceGenerator.put(rkey4error, errormsg);
        }
        sb.append(basetab + "        ");
        sb.append("// " + this.rman.getValue("helper.comment.generic_check"));
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("if (" + sid + " != null) {");
        if (updateList) {
            sb.append(CR);
            sb.append(basetab + "            ");
            sb.append(AppSchemaUtil.getHelperClassname(this.model, this.project));
            sb.append(" ulphelper =");
            sb.append(CR);
            sb.append(basetab + "                ");
            sb.append(AppSchemaUtil.getHelperClassname4Dicon(this.model, this.project));
            sb.append(";");
            sb.append(CR);
            sb.append(basetab + "            ");
            sb.append(sid).append(" = ulphelper.p2s(").append(this.model.getId());
            sb.append(", p, ");
            sb.append(sid);
            sb.append(", itemSet);");
        }
        sb.append(CR);
        String expr = null;
        if (StringUtils.isNotBlank((CharSequence)cnt)) {
            String pi = null;
            if (AppSchemaUtil.hasChildPart(sitem.getName())) {
                pi = "PI:mid=" + header4target + AppSchemaUtil.getParentPart(sitem.getName()) + "_ary[i]";
            }
            try {
                expr = JavaSourceGenerator.parsePlaceHolder(HelperGenerator_calc_parser.convertFunctionNames(cnt, null, sitem.getName(), targetmodel), targetmodel, pi, this.project);
                if (updateList) {
                    Model pmodel = this.project != null ? AppSchemaUtil.getPresentationModel(this.project, targetmodel) : null;
                    String tstr2 = pmodel.getId();
                    String dstr2 = this.model.getId();
                    expr = StringUtil.replaceAll((String)expr, (String)tstr2, (String)dstr2);
                }
            }
            catch (Exception e) {
                Object[] o = new Object[]{smodel.getId(), this.item.getName(), e.getMessage()};
                this.logger.warn(this.rman.getValue("expr.invalid.generic_check", o));
            }
        }
        Relation relation = null;
        String rtype = null;
        if (("masterref".equals(sitem.getType()) || "storeref".equals(sitem.getType())) && (relation = AppSchemaUtil.getRelationTypeExceptRef(sitem)) != null) {
            rtype = relation.getType();
        }
        Object p_var = null;
        boolean useMultipleChkTypeName = false;
        if (sitem.getMultiple()) {
            p_var = JavaSourceGenerator.convClassname4Relax(sitem.getName()) + "_ary[i]";
            tstr = smodel.getId() + JavaSourceGenerator.getterFullMethod(sitem.getName());
            dstr = p_var;
            expr = StringUtil.replaceAll((String)expr, (String)tstr, (String)dstr);
            useMultipleChkTypeName = true;
        } else {
            p_var = !this.multiFlag ? (rtype == null ? "values" : "values[0]") : this.item.getName() + "_ary[i]";
            if (AppSchemaUtil.hasChildPart(sitem.getName())) {
                tstr = smodel.getId() + JavaSourceGenerator.getterFullMethod(sitem.getName());
                dstr = AppSchemaUtil.getParentPart(sitem.getName()) + "_ary[i]" + JavaSourceGenerator.getterFullMethod(AppSchemaUtil.getChildPart(sitem.getName()));
                expr = StringUtil.replaceAll((String)expr, (String)tstr, (String)dstr);
                useMultipleChkTypeName = true;
                if (expr.indexOf("ISEMPTY(") >= 0) {
                    boolean success = true;
                    while (expr.indexOf("ISEMPTY(") >= 0) {
                        int ptr3 = expr.indexOf("ISEMPTY(");
                        String beforePart = expr.substring(0, ptr3 + "ISEMPTY(".length());
                        String rest = expr.substring(beforePart.length() + 1);
                        int ptr22 = rest.indexOf(")");
                        if (ptr22 <= 0) {
                            success = false;
                            break;
                        }
                        String core = rest.substring(0, ptr22);
                        rest = rest.substring(ptr22);
                        int ptr32 = core.indexOf(",");
                        if (ptr32 <= 0) {
                            success = false;
                            break;
                        }
                        StringBuilder sb2 = new StringBuilder();
                        sb2.append(beforePart.replace("ISEMPTY", "iSeMpTy"));
                        sb2.append("__" + AppSchemaUtil.getParentPart(sitem.getName()) + "_ary[i]");
                        sb2.append(core.substring(ptr32));
                        sb2.append(rest);
                        expr = sb2.toString();
                    }
                    if (success) {
                        expr = StringUtil.replaceAll((String)expr, (String)"iSeMpTy", (String)"ISEMPTY");
                    }
                }
            }
        }
        sb.append(basetab + "            ");
        sb.append("boolean __ret = true;");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("try {");
        sb.append(CR);
        sb.append(basetab + "                ");
        sb.append("__ret = ");
        sb.append("(");
        sb.append(expr);
        sb.append(")");
        sb.append(";");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("} catch (Exception e) {");
        sb.append(CR);
        sb.append(basetab + "                ");
        sb.append("__ret = false;");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("if (!__ret) {");
        sb.append(CR);
        String rkey4customize = null;
        if (rkey4error == null && StringUtils.isNotBlank((CharSequence)errormsg) && (ptr = (errormsg = StringUtil.removePreAndPostWhitespaceWithoutInside((String)errormsg)).indexOf("(")) > 0 && (ptr2 = (tmp = errormsg.substring(ptr + 1)).lastIndexOf(")")) > 0) {
            rkey4customize = tmp.substring(0, ptr2);
        }
        sb.append(basetab + "                ");
        sb.append("Object[] o = { ");
        sb.append(CR);
        sb.append(basetab + "                    ");
        if (rkey4error != null) {
            sb.append("getRValue(\"" + StringUtil.convertJavaString((String)rkey4error) + "\", p)");
        } else if (rkey4customize != null) {
            if (errormsg.indexOf("ERRORMESSAGE") >= 0) {
                sb.append("JFCUtils.ErrorMessage(p, ").append(rkey4customize).append(")");
            } else {
                sb.append("JFCUtils.Message(p, ").append(rkey4customize).append(")");
            }
        } else {
            sb.append("getRValue(\"" + StringUtil.convertJavaString((String)rkey) + "\", p)");
        }
        sb.append(CR);
        sb.append(basetab + "                ");
        sb.append("};");
        sb.append(CR);
        sb.append(basetab + "                ");
        if (this.gcheck.getWarning()) {
            sb.append("jp.jasminesoft.jfc.error.Jfcwarn _warn =");
            sb.append(CR);
            sb.append(basetab + "                    ");
            sb.append("manager.getJfcwarn(");
            sb.append("\"").append(name).append("\", \"");
            if (StringUtils.isNotBlank((CharSequence)rkey4error) || StringUtils.isNotBlank((CharSequence)rkey4customize)) {
                sb.append(this.createErrorCode("error.input.generic"));
            } else {
                sb.append(this.createErrorCode("error.input.generic.standard"));
            }
            sb.append("\"");
            sb.append(", o, p.locale);");
            sb.append(CR);
            sb.append(basetab + "                ");
            sb.append("JFCHelperUtils.checkWarnedError(p, String.valueOf(s), _warn, ");
            sb.append("\"");
            sb.append(StringUtil.convertJavaString((String)rkey));
            sb.append("\", \"");
            if (StringUtils.isNotBlank((CharSequence)rkey4error) || StringUtils.isNotBlank((CharSequence)rkey4customize)) {
                sb.append(this.createErrorCode("error.input.generic"));
            } else {
                sb.append(this.createErrorCode("error.input.generic.standard"));
            }
            if (useMultipleChkTypeName) {
                sb.append(".");
            }
            sb.append("\"");
            if (useMultipleChkTypeName) {
                sb.append("+i");
            }
            sb.append(");");
            sb.append(CR);
            HelperGenerator_input_check.generateWarnCode(this.multiFlag, this.model, this.item, relation, sb, basetab + "                ");
        } else {
            sb.append("jp.jasminesoft.jfc.error.Jfcerror _error =");
            sb.append(CR);
            sb.append(basetab + "                    ");
            sb.append("manager.getJfcerror(");
            sb.append("\"").append(name).append("\", \"");
            if (StringUtils.isNotBlank((CharSequence)rkey4error) || StringUtils.isNotBlank((CharSequence)rkey4customize)) {
                sb.append(this.createErrorCode("error.input.generic"));
            } else {
                sb.append(this.createErrorCode("error.input.generic.standard"));
            }
            sb.append("\"");
            sb.append(", o, p.locale);");
            sb.append(CR);
            if ("search".equals(rtype)) {
                sb.append(basetab + "                ");
                sb.append("_error.setName(\"").append(name).append("\");").append(CR);
            }
            sb.append(basetab + "                ");
            sb.append("p.errors.addJfcerror(_error);");
            sb.append(CR);
            HelperGenerator_input_check.generateErrorCode(this.multiFlag, this.model, this.item, relation, sb, basetab + "                ");
        }
        sb.append(basetab + "            ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("}");
        sb.append(CR);
        return sb.toString();
    }
}

