/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CommentGenerator;
import jp.jasminesoft.jfc.gen.HelperGeneratorBaseTask;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.ResourceManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelperGenerator_getFileList
extends HelperGeneratorBaseTask {
    protected Project project;
    protected Logger logger = LogManager.getLogger((String)HelperGenerator_getFileList.class.getName());

    public HelperGenerator_getFileList(Project project, Model model) {
        this.project = project;
        this.model = model;
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
    }

    @Override
    public String process() {
        return this.process("");
    }

    @Override
    public String process(String basetab) {
        StringBuilder sb = new StringBuilder();
        String id = this.model.getId();
        String classname = AppSchemaUtil.getClassname(this.model);
        String[] msg_param = new String[]{id + " " + classname, "p ActionParameter"};
        sb.append(CommentGenerator.gComment(this.rman.getValue("helper.comment.getFileList"), msg_param, "return filelist."));
        sb.append("    ");
        sb.append("@Override").append(CR);
        sb.append("    ");
        sb.append("public List<String> getFileList(");
        sb.append(classname);
        sb.append(" ");
        sb.append(id);
        sb.append(", ActionParameter p) {");
        sb.append(CR);
        StringBuilder sb1 = new StringBuilder();
        this.output(sb1, id);
        if (!StringUtils.isNotEmpty((CharSequence)sb1.toString())) {
            return "";
        }
        sb.append("        ");
        sb.append("ArrayList<String> list = new ArrayList<>();");
        sb.append(CR);
        sb.append("        ");
        sb.append("String fn;");
        sb.append(CR);
        sb.append(CR);
        sb.append(sb1.toString());
        sb.append("        ");
        sb.append("return list;");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    private void output(StringBuilder sb, String id) {
        String realFilenameRefModelitemFooter = this.model.getRealFilenameRefModelitemFooter();
        if (realFilenameRefModelitemFooter == null || realFilenameRefModelitemFooter.length() == 0) {
            return;
        }
        IModelChoice[] imc = this.model.getContent();
        if (imc == null) {
            return;
        }
        LinkedHashMap<String, ArrayList<Modelitem>> pnameMap = new LinkedHashMap<String, ArrayList<Modelitem>>();
        for (int i = 0; i < imc.length; ++i) {
            Modelitem mitem;
            String mitemname;
            if (!(imc[i] instanceof Modelitem) || !(mitemname = (mitem = (Modelitem)imc[i]).getName()).endsWith(realFilenameRefModelitemFooter)) continue;
            int cnt = mitemname.indexOf(47);
            if (cnt < 0) {
                String mitemclassname = AppSchemaUtil.getModelitemClassname(mitem);
                this.outputCode(sb, mitemclassname, id, "        ");
                continue;
            }
            String pname = mitemname.substring(0, cnt);
            ArrayList<Modelitem> list = (ArrayList<Modelitem>)((HashMap)pnameMap).get(pname);
            if (list == null) {
                list = new ArrayList<Modelitem>();
                pnameMap.put(pname, list);
            }
            list.add(mitem);
        }
        for (String pname : ((HashMap)pnameMap).keySet()) {
            Modelitem pmitem = AppSchemaUtil.getModelitem(pname, this.model);
            if (pmitem == null) continue;
            String pmitemclassname = AppSchemaUtil.getModelitemClassname(pmitem);
            sb.append("        ");
            sb.append("for (");
            sb.append(AppSchemaUtil.getPackagename(this.model, this.project));
            sb.append(pmitemclassname);
            sb.append(" ");
            sb.append(pname);
            sb.append(" : ");
            sb.append(id);
            sb.append(JavaSourceGenerator.getterFullMethod(pmitem.getName()));
            sb.append(") {");
            sb.append(CR);
            List cmitems = (List)((HashMap)pnameMap).get(pname);
            for (Modelitem cmitem : cmitems) {
                String cmitemclassname = AppSchemaUtil.getModelitemClassname(cmitem);
                this.outputCode(sb, cmitemclassname, pname, "            ");
            }
            sb.append("        ");
            sb.append("}");
            sb.append(CR);
        }
    }

    private void outputCode(StringBuilder sb, String mitemclassname, String id, String tab) {
        sb.append(tab);
        sb.append("fn = ");
        sb.append(id);
        sb.append(".get");
        sb.append(mitemclassname);
        sb.append("();");
        sb.append(CR);
        sb.append(tab);
        sb.append("if (fn != null) {");
        sb.append(CR);
        sb.append(tab);
        sb.append("    list.add(fn);");
        sb.append(CR);
        sb.append(tab);
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
    }
}

