/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.GridColumnsGenerator;
import jp.jasminesoft.jfc.gen.HelperGeneratorBaseTask;
import jp.jasminesoft.jfc.gen.JFCAppResourceGenerator;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.ResourceManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelperGenerator_getGridColumns
extends HelperGeneratorBaseTask {
    protected Logger logger = LogManager.getLogger((String)HelperGenerator_getGridColumns.class.getName());
    protected Project project;
    protected Model smodel;

    public HelperGenerator_getGridColumns(Project project, Model model) {
        this.project = project;
        this.model = model;
        this.smodel = AppSchemaUtil.getStoreModel(this.model);
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
    }

    @Override
    public String process() {
        return this.process("");
    }

    @Override
    public String process(String basetab) {
        GridColumnsGenerator gcgen;
        if (!this.isListModel()) {
            this.logger.error("require list model");
            return "";
        }
        try {
            gcgen = new GridColumnsGenerator(this.project, this.smodel, this.model);
        }
        catch (IllegalStateException e) {
            return "";
        }
        List<Map<String, Object>> gridColumns = gcgen.createGridColumns();
        if (gridColumns == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("public List<Map<String, Object>> getGridColumns(HttpServletRequest request, Map<String, Object> map) {");
        sb.append(CR);
        String pclassname = AppSchemaUtil.getClassname(this.model);
        String ppkgname = AppSchemaUtil.getPackagename(this.model, this.project);
        String mapkey = this.model.getUpdatelist() ? "listulp" : "listp";
        ArrayList<String> buttonfieldids = new ArrayList<String>();
        ArrayList<String> nocondids = new ArrayList<String>();
        for (Map<String, Object> map : gridColumns) {
            String id = (String)map.get("id");
            if (id.startsWith("jfcButtonField")) {
                buttonfieldids.add(id);
                continue;
            }
            nocondids.add(id);
        }
        ArrayList<String> codes = new ArrayList<String>();
        codes.add("HashSet<String> targetIdSet = null;");
        if (buttonfieldids.size() > 0) {
            codes.addAll(Arrays.asList(pclassname + " listp = (" + pclassname + ") map.get(\"" + mapkey + "\");", "if (listp != null) {", "    targetIdSet = new HashSet<>();"));
            for (String id : nocondids) {
                codes.add("    targetIdSet.add(\"" + id + "\");");
            }
            codes.add("    for (" + ppkgname + "Item litem : listp.getItem()) {");
            for (String id : buttonfieldids) {
                String method = JavaSourceGenerator.getterFullMethod(id);
                codes.addAll(Arrays.asList("        if (litem" + method + " != null) {", "            targetIdSet.add(\"" + id + "\");", "        }"));
            }
            codes.addAll(Arrays.asList("    }", "}"));
        }
        codes.addAll(Arrays.asList("", "ArrayList<Map<String, Object>> list = new ArrayList<>();", "String locale = JFCUtils.getLocaleString(request);"));
        String string = "gridColumns";
        String[] resitems = new String[]{"field", "label"};
        for (Map<String, Object> gridColumn : gridColumns) {
            Iterator<String> it;
            String id = (String)gridColumn.get("id");
            for (String resitem : resitems) {
                String rcontent = StringUtils.defaultString((String)((String)gridColumn.get(resitem)));
                String rkey = JFCAppResourceGenerator.createHelperResourceKey("gridColumns", this.smodel.getId(), id + "." + resitem, rcontent);
                JFCAppResourceGenerator.put(rkey, rcontent);
                gridColumn.put(resitem, new GridColumnsGenerator.JavaCode("JFCUtils.getRValue(\"" + rkey + "\", locale)"));
            }
            GridColumnsGenerator.JsonJavaCode jjc = gcgen.toJsonJavaCode(gridColumn);
            if (jjc == null || !(it = jjc.codes.iterator()).hasNext()) continue;
            codes.add("if (targetIdSet == null || targetIdSet.contains(\"" + id + "\")) {");
            codes.add("    list.add(" + it.next());
            while (it.hasNext()) {
                codes.add("    " + it.next());
            }
            String lastcode = codes.get(codes.size() - 1);
            codes.set(codes.size() - 1, lastcode + ");");
            codes.add("}");
        }
        codes.add("return list;");
        this.append(sb, "        ", codes);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        return sb.toString();
    }

    private boolean isListModel() {
        Model rmodel;
        boolean isListModel = false;
        IRNode node = this.model.getIdrefAsIRNode();
        if (node != null && node instanceof Model && (rmodel = (Model)node).getType().equals("list")) {
            isListModel = true;
        }
        return isListModel;
    }

    protected void append(StringBuilder sb, String tab, List<String> codes) {
        for (String code : codes) {
            if (code == null) continue;
            if (StringUtils.isNotBlank((CharSequence)code)) {
                sb.append(tab);
                sb.append(code);
            }
            sb.append(CR);
        }
    }
}

