/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.HelperGeneratorBaseTask;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Dataitem;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.util.ResourceManagerFactory;
import jp.jasminesoft.util.SourceGeneratorUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelperGenerator_getParameterMap
extends HelperGeneratorBaseTask {
    protected Logger logger = LogManager.getLogger((String)HelperGenerator_getParameterMap.class.getName());
    protected Project project;
    protected Model smodel;

    public HelperGenerator_getParameterMap(Project project, Model model) {
        this.project = project;
        this.model = model;
        this.smodel = AppSchemaUtil.getStoreModel(this.model);
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
    }

    @Override
    public String process() {
        return this.process("");
    }

    @Override
    public String process(String basetab) {
        if (!this.model.getType().equals("presentation")) {
            return "";
        }
        IRNode node = this.model.getIdrefAsIRNode();
        if (node == null || !(node instanceof Model)) {
            return "";
        }
        Model model1 = (Model)node;
        if ("list".equals(model1.getType()) ? !this.model.getUpdatelist() : !"store".equals(model1.getType())) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        this.gGetParameterMap(sb);
        sb.append(CR);
        if (this.model.getUpdatelist()) {
            this.gAddParameterMapUlp(sb);
        } else {
            this.gAddParameterMap(sb, model1);
        }
        return sb.toString();
    }

    public void gAddParameterMap(StringBuilder sb, Model model1) {
        Modelitem[] mitems;
        String pclassname = AppSchemaUtil.getClassname(this.model);
        ArrayList<String> codes = new ArrayList<String>();
        codes.addAll(Arrays.asList("public void addParameterMap(ActionParameter p, Map<String, Object> map, " + pclassname + " pmodel) {", "    String locale = JFCUtils.getLocaleString(p.request);", "    String keyheader = \"" + this.model.getId() + "_002f\";", "    int cntcheck;"));
        for (Modelitem mitem : mitems = AppSchemaUtil.getModelitem(this.model)) {
            List<String> codes2;
            Modelitem smitem = AppSchemaUtil.getModelitem(mitem.getName(), model1);
            if (smitem == null || smitem.getGeneration()) continue;
            String getterMethod = "pmodel" + SourceGeneratorUtil.getterFullMethod((String)smitem.getName());
            if (smitem.getHasChild() || AppSchemaUtil.hasChildPart(smitem.getName()) || AppSchemaUtil.isMultiple(this.project, smitem) || "combo".equals(smitem.getDualinputmethod())) continue;
            if (AppSchemaUtil.isStorerefOrMasterref("", smitem)) {
                codes2 = this.gModelitemStoreref(smitem, getterMethod);
                this.append(codes, "    ", codes2);
                continue;
            }
            codes2 = this.gModelitem("pmodel", smitem, getterMethod);
            this.append(codes, "    ", codes2);
        }
        codes.add("}");
        this.append(sb, "    ", codes);
    }

    public void gAddParameterMapUlp(StringBuilder sb) {
        Modelitem[] mitems;
        String ppackagename = AppSchemaUtil.getPackagename(this.model, this.project);
        String pclassname = AppSchemaUtil.getClassname(this.model);
        ArrayList<String> codes = new ArrayList<String>();
        codes.addAll(Arrays.asList("public void addParameterMap(ActionParameter p, Map<String, Object> map, " + pclassname + " pmodel) {", "    String locale = JFCUtils.getLocaleString(p.request);", "    int cntulitem = 0, cntcheck;", "    for (" + ppackagename + "Item item : pmodel.getItem()) {", "        String keyheader = \"" + this.model.getId() + "_002fitem_005b\" + (++cntulitem) + \"_005d_002f\";", "        addParameterMap(p, map, item, keyheader, locale);", "        map.put(\"jfcdelete_" + this.smodel.getId() + "_\" + cntulitem, item.getJfcdelete());"));
        for (Modelitem mitem : mitems = AppSchemaUtil.getModelitem(this.model)) {
            List<String> codes2;
            Modelitem smitem = AppSchemaUtil.getModelitem(mitem.getName(), this.smodel);
            if (smitem == null || smitem.getGeneration()) continue;
            String getterMethod = "item" + SourceGeneratorUtil.getterFullMethod((String)smitem.getName());
            if (smitem.getHasChild() || AppSchemaUtil.hasChildPart(smitem.getName()) || AppSchemaUtil.isMultiple(this.project, smitem) || "combo".equals(smitem.getDualinputmethod())) continue;
            if (AppSchemaUtil.isStorerefOrMasterref("", smitem)) {
                codes2 = this.gModelitemStoreref(smitem, getterMethod);
                this.append(codes, "        ", codes2);
                continue;
            }
            codes2 = this.gModelitem("item", smitem, getterMethod);
            this.append(codes, "        ", codes2);
        }
        codes.add("    }");
        codes.add("}");
        this.append(sb, "    ", codes);
    }

    private List<String> gModelitem(String obj, Modelitem smitem, String getterMethod) {
        return Arrays.asList("addParameterMapModelitem(" + obj + ", \"" + smitem.getName() + "\", map, keyheader, p);");
    }

    private List<String> gModelitemStoreref(Modelitem smitem, String getterMethod) {
        Modelitem smitem2 = AppSchemaUtil.getRelatedModelitemInCaseofTypeRef(this.project, this.smodel.getId(), smitem);
        Relation rel = AppSchemaUtil.getRelationTypeExceptRef(smitem2);
        if (rel == null) {
            return Collections.emptyList();
        }
        if (rel.getType().equals("combo") || rel.getType().equals("radio") || rel.getType().equals("search")) {
            return this.gModelitemList(smitem, getterMethod);
        }
        if (rel.getType().equals("check")) {
            return this.gModelitemCheck(smitem, getterMethod);
        }
        return Collections.emptyList();
    }

    private List<String> gModelitemList(Modelitem smitem, String getterMethod) {
        String classname = AppSchemaUtil.getModelitemClassname(smitem);
        String packagename = "";
        if (this.model.getUpdatelist()) {
            packagename = AppSchemaUtil.getPackagename(this.model, this.project);
        }
        ArrayList<String> codes = new ArrayList<String>(Arrays.asList("for (" + packagename + classname + " mv : " + getterMethod + ") {", "    if (mv.getChoose()) {"));
        this.append(codes, "        ", this.gJfcpkeycode(smitem));
        codes.addAll(Arrays.asList("        String key = keyheader + \"" + smitem.getName() + "_005b1_005d_002f_0040id\";", "        map.put(key, jfcpkey);", "        map.put(key + \"/@content\", mv.getContent());", "        map.put(key + \"_content\", mv.getContent());", "    }", "}"));
        return codes;
    }

    private List<String> gModelitemCheck(Modelitem smitem, String getterMethod) {
        Model _rmodel;
        PrimaryKey[] _r_pkeys;
        String classname = AppSchemaUtil.getModelitemClassname(smitem);
        boolean hasComplexKey = false;
        Relation _relation = AppSchemaUtil.getRelationTypeExceptRef(smitem);
        if (_relation != null && (_r_pkeys = AppSchemaUtil.getPrimaryKey(_rmodel = (Model)_relation.getIdrefAsIRNode())) != null && _r_pkeys.length > 1) {
            hasComplexKey = true;
        }
        String packagename = "";
        if (this.model.getUpdatelist() || hasComplexKey) {
            packagename = AppSchemaUtil.getPackagename(this.model, this.project);
        }
        ArrayList<String> codes = new ArrayList<String>(Arrays.asList("cntcheck = 0;", "for (" + packagename + classname + " mv : " + getterMethod + ") {", "    cntcheck++;", "    if (mv.getChoose()) {"));
        this.append(codes, "        ", this.gJfcpkeycode(smitem));
        codes.addAll(Arrays.asList("        String key = keyheader + \"" + smitem.getName() + "_005b\" + cntcheck + \"_005d_002f_0040id\";", "        map.put(key, jfcpkey);", "        map.put(key + \"/@content\", mv.getContent());", "        map.put(key + \"_content\", mv.getContent());", "    }", "}"));
        return codes;
    }

    private List<String> gJfcpkeycode(Modelitem smitem) {
        Model _rmodel = this.getRefModel(smitem);
        PrimaryKey[] _r_pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(_rmodel, this.project);
        if (_r_pkeys != null && _r_pkeys.length > 1) {
            List<String> codes = this.gAppendCompositeKeyParameterInOnePart(_rmodel, _r_pkeys);
            codes.add("String jfcpkey = jfcpkeybuf.toString();");
            return codes;
        }
        String firstpkeytype = "Object";
        if (_r_pkeys != null && _r_pkeys.length == 1) {
            Modelitem mitem;
            String mitemname = _r_pkeys[0].getName();
            String mitemtype = AppSchemaUtil.getModelitemType(this.project, mitemname, mitem = AppSchemaUtil.getModelitem(mitemname, _rmodel), "roleid");
            if (SourceGeneratorUtil.isBasicType((String)mitemtype)) {
                firstpkeytype = SourceGeneratorUtil.b2wc((String)mitemtype);
            } else if (mitemtype.equals("date") || mitemtype.equals("dateTime") || mitemtype.equals("time")) {
                firstpkeytype = "String";
            }
        }
        if (firstpkeytype.equals("String")) {
            return Arrays.asList("String jfcpkey = mv.getId().toString();");
        }
        return Arrays.asList(firstpkeytype + " jfcpkey = mv.getId();");
    }

    private Model getRefModel(Modelitem sitem) {
        Relation _relation = AppSchemaUtil.getRelationTypeExceptRef(sitem);
        if (_relation != null) {
            Model _rmodel = (Model)_relation.getIdrefAsIRNode();
            return _rmodel;
        }
        _relation = AppSchemaUtil.getRelationTypeIsRef(sitem);
        Model _rmodel = (Model)_relation.getIdrefAsIRNode();
        Modelitem _rmitem = AppSchemaUtil.getModelitem(_relation.getName(), _rmodel);
        Relation _rel_rmitem = AppSchemaUtil.getRelationTypeExceptRef(_rmitem);
        if (_rel_rmitem != null) {
            Model __rmodel = (Model)_rel_rmitem.getIdrefAsIRNode();
            return __rmodel;
        }
        return null;
    }

    private List<String> gAppendCompositeKeyParameterInOnePart(Model _rmodel, PrimaryKey[] _r_pkeys) {
        ArrayList<String> codes = new ArrayList<String>();
        for (int i = 0; i < _r_pkeys.length; ++i) {
            Object code;
            Modelitem mitem;
            PrimaryKey _r_pkey = _r_pkeys[i];
            String mitemname = _r_pkey.getRefname();
            if (mitemname == null) {
                mitemname = _r_pkey.getName();
            }
            if ((mitem = AppSchemaUtil.getModelitem(mitemname, _rmodel)) == null) {
                System.out.println("[Internal Error] " + _rmodel.getId() + " " + _r_pkey);
                continue;
            }
            if (mitem.getGeneration()) continue;
            String mitemtype = AppSchemaUtil.getModelitemType(this.project, mitemname, mitem, "roleid");
            String b2wcmethod = SourceGeneratorUtil.getB2wc_method((String)mitemtype);
            if (i == 0) {
                code = "StringBuilder jfcpkeybuf = new StringBuilder();";
                codes.add((String)code);
                code = "jfcpkeybuf.append(";
                code = StringUtils.isNotBlank((CharSequence)b2wcmethod) ? (String)code + b2wcmethod + "(mv.getId())" : (String)code + "mv.getId()";
                code = (String)code + ");";
                codes.add((String)code);
                continue;
            }
            codes.add("jfcpkeybuf.append(PrimaryKeyUtils.PKEY_SEPARATOR());");
            code = "jfcpkeybuf.append(";
            Object name = _r_pkey.getName();
            name = StringUtils.isBlank((CharSequence)_r_pkey.getRefname()) ? (String)name + "Jshpkey" : _r_pkey.getRefname() + "_" + (String)name + "Jshpkey";
            String getterFullMethod = SourceGeneratorUtil.getterFullMethod((String)name);
            code = StringUtils.isNotBlank((CharSequence)b2wcmethod) ? (String)code + b2wcmethod + "(mv" + getterFullMethod + ")" : (String)code + "mv" + getterFullMethod;
            code = (String)code + ");";
            codes.add((String)code);
        }
        return codes;
    }

    public void gGetParameterMap(StringBuilder sb) {
        ArrayList<String> codes = new ArrayList<String>();
        Collection<Model> ulpmodels = this.getChildUlpModels(this.model);
        for (Model ulpmodel : ulpmodels) {
            String helperiname = ulpmodel.getId() + "Helper";
            String helperclassname = AppSchemaUtil.getHelperClassname(ulpmodel, this.project);
            codes.add("@Autowired");
            codes.add("private " + helperclassname + " " + helperiname + ";");
            codes.add("");
        }
        codes.addAll(Arrays.asList("@Override", "public Map<String, Object> getParameterMap(ActionParameter p) {", "    String locale = JFCUtils.getLocaleString(p.request);", "    HashMap<String, Object> map = new HashMap<>();"));
        String pclassname = AppSchemaUtil.getClassname(this.model);
        if (this.model.getUpdatelist()) {
            Model ulpmodel;
            ulpmodel = this.model;
            String ulpclassname = AppSchemaUtil.getPackagename(ulpmodel, this.project) + AppSchemaUtil.getClassname(ulpmodel);
            String ulpid = ulpmodel.getId();
            ArrayList<String> codes2 = new ArrayList<String>();
            codes2.addAll(Arrays.asList(ulpclassname + " ulpmodel = (" + ulpclassname + ") p.pageMap.get(\"" + ulpid + "\");", "if (ulpmodel != null) {", "    addParameterMap(p, map, ulpmodel);", "}"));
            this.append(codes, "    ", codes2);
        } else {
            ArrayList<String> codes2 = new ArrayList<String>();
            codes2.addAll(Arrays.asList(pclassname + " entity = (" + pclassname + ") p.appMap.get(\"" + this.model.getId() + "_preserve\");", "if (entity != null) {", "    addParameterMap(p, map, entity);", "}"));
            for (Model ulpmodel : ulpmodels) {
                String helperiname = ulpmodel.getId() + "Helper";
                String ulpclassname = AppSchemaUtil.getPackagename(ulpmodel, this.project) + AppSchemaUtil.getClassname(ulpmodel);
                String ulpid = ulpmodel.getId();
                codes2.addAll(Arrays.asList(ulpclassname + " " + ulpid + " = (" + ulpclassname + ") p.pageMap.get(\"" + ulpid + "\");", "if (" + ulpid + " != null) {", "    " + helperiname + ".addParameterMap(p, map, " + ulpid + ");", "}"));
            }
            this.append(codes, "    ", codes2);
        }
        codes.add("    return map;");
        codes.add("}");
        this.append(sb, "    ", codes);
    }

    private Collection<Model> getChildUlpModels(Model model) {
        Action[] actions;
        LinkedHashSet<Model> ulpmodels = new LinkedHashSet<Model>();
        IRNode parentnode = model.getIdrefAsIRNode();
        if (parentnode == null || !(parentnode instanceof Model)) {
            return ulpmodels;
        }
        Model smodel1 = (Model)parentnode;
        if (!smodel1.getType().equals("store")) {
            return ulpmodels;
        }
        for (Action action : actions = AppSchemaUtil.getActionByModelId(this.project, smodel1.getId())) {
            Dataitem[] dataitems;
            String actiontype = action.getType();
            if (!actiontype.equals("copy") && !actiontype.equals("insert") && !actiontype.equals("update")) continue;
            for (Dataitem dataitem : dataitems = AppSchemaUtil.getDataitems(action)) {
                IRNode node;
                if (!dataitem.getType().equals("updateList") || !((node = dataitem.getIdrefAsIRNode()) instanceof Model)) continue;
                ulpmodels.add((Model)node);
            }
        }
        return ulpmodels;
    }

    private void append(List<String> codes, String tab, List<String> codes2) {
        for (String code : codes2) {
            if (code == null) continue;
            if (StringUtils.isNotBlank((CharSequence)code)) {
                codes.add(tab + code);
                continue;
            }
            codes.add(code);
        }
    }

    protected void append(StringBuilder sb, String tab, List<String> codes) {
        for (String code : codes) {
            if (code == null) continue;
            if (StringUtils.isNotBlank((CharSequence)code)) {
                sb.append(tab);
                sb.append(code);
            }
            sb.append(CR);
        }
    }
}

