/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.HelperGeneratorBaseTask;
import jp.jasminesoft.jfc.gen.HelperGenerator_input_check;
import jp.jasminesoft.jfc.gen.JFCAppResourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Notequal;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.util.ResourceManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelperGenerator_notequal
extends HelperGeneratorBaseTask {
    protected Project project;
    protected Notequal content;
    protected Logger logger = LogManager.getLogger((String)HelperGenerator_notequal.class.getName());

    public HelperGenerator_notequal(Project project, Model model, Modelitem item, Notequal content) {
        this.project = project;
        this.model = model;
        this.item = item;
        this.content = content;
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
    }

    @Override
    public String process() {
        return this.process("");
    }

    @Override
    public String process(String basetab) {
        String value;
        StringBuilder sb = new StringBuilder();
        String name = HelperGenerator_input_check.getName4ErrorManager(this.item.getName(), this.model);
        String label = this.item.getLabel();
        if (label == null || label.length() == 0) {
            label = this.item.getName();
        }
        Relation relation = AppSchemaUtil.getRelationFromPModel(this.model, this.item);
        Model smodel = AppSchemaUtil.getStoreModel(this.model);
        String rkey = null;
        if (smodel != null) {
            String label_i18n = AppSchemaUtil.getLabeli18n(this.item, smodel.getId(), this.model, this.project);
            rkey = JFCAppResourceGenerator.createModelResourceKey(smodel.getId(), this.item.getName(), label_i18n);
            JFCAppResourceGenerator.put(rkey, label_i18n);
        }
        sb.append(basetab + "        ");
        sb.append("// " + this.rman.getValue("helper.comment.notequal"));
        sb.append(CR);
        if (AppSchemaUtil.hasControl(this.item) && AppSchemaUtil.hasChildPart(this.item.getName())) {
            sb.append(basetab + "        ");
            sb.append("if (_isContainsId) {").append(CR);
        }
        value = (value = this.content.getContent()) == null ? "" : value;
        boolean multiCheck = false;
        String sepchar = this.content.getSeparator();
        if (StringUtils.isBlank((CharSequence)sepchar)) {
            sepchar = String.valueOf(',');
        }
        if (value.indexOf(sepchar) > 0) {
            multiCheck = true;
        }
        String rv_key = JFCAppResourceGenerator.createValueResourceKey(smodel.getId(), this.item.getName() + ".notequal", value);
        JFCAppResourceGenerator.put(rv_key, value);
        String mtab = "";
        if (multiCheck) {
            sb.append(basetab + "        ");
            sb.append("String[] tokens = jp.jasminesoft.util.CSVUtil.parse(");
            sb.append("getRValue(\"" + rv_key + "\", p)");
            sb.append(");");
            sb.append(CR);
            sb.append(basetab + "        ");
            sb.append("for (String token : tokens) {");
            sb.append(CR);
            mtab = "    ";
        }
        sb.append(basetab + "        " + mtab);
        sb.append("try {");
        sb.append(CR);
        sb.append(basetab + "            " + mtab);
        sb.append("if (s != null && s.matches(");
        if (multiCheck) {
            sb.append("token");
        } else {
            sb.append("getRValue(\"" + rv_key + "\", p)");
        }
        sb.append(")) {");
        sb.append(CR);
        sb.append(basetab + "                " + mtab);
        sb.append("Object[] o = { ");
        sb.append("getRValue(\"" + rkey + "\", p)");
        sb.append(", ");
        if (multiCheck) {
            sb.append("token");
        } else {
            sb.append("getRValue(\"" + rv_key + "\", p)");
        }
        sb.append(" };");
        sb.append(CR);
        sb.append(basetab + "                " + mtab);
        if (this.content.getWarning()) {
            sb.append("jp.jasminesoft.jfc.error.Jfcwarn _warn =");
            sb.append(CR);
            sb.append(basetab + "                    " + mtab);
            sb.append("manager.getJfcwarn(\"");
            sb.append(name).append("\", \"");
            sb.append(this.createErrorCode("error.input.not_equal"));
            sb.append("\", o, p.locale);");
            sb.append(CR);
            sb.append(basetab + "                " + mtab);
            sb.append("JFCHelperUtils.checkWarnedError(p, String.valueOf(s), _warn, \"");
            sb.append(rkey);
            sb.append("\", \"" + this.createErrorCode("error.input.not_equal") + "\");");
            sb.append(CR);
            HelperGenerator_input_check.generateWarnCode(this.multiFlag, this.model, this.item, relation, sb, basetab + "                " + mtab);
        } else {
            String rtype;
            sb.append("jp.jasminesoft.jfc.error.Jfcerror _error =");
            sb.append(CR);
            sb.append(basetab + "                    " + mtab);
            sb.append("manager.getJfcerror(\"");
            sb.append(name).append("\", \"");
            sb.append(this.createErrorCode("error.input.not_equal"));
            sb.append("\", o, p.locale);");
            sb.append(CR);
            if (relation != null && "search".equals(rtype = relation.getType())) {
                sb.append(basetab + "                ");
                sb.append("_error.setName(\"").append(name).append("\");").append(CR);
            }
            sb.append(basetab + "                " + mtab);
            sb.append("p.errors.addJfcerror(_error);");
            sb.append(CR);
            HelperGenerator_input_check.generateErrorCode(this.multiFlag, this.model, this.item, relation, sb, basetab + "                ");
        }
        sb.append(basetab + "            " + mtab);
        sb.append("}");
        sb.append(CR);
        sb.append(basetab + "        " + mtab);
        sb.append("} catch (java.util.regex.PatternSyntaxException e) {");
        sb.append(CR);
        sb.append(basetab + "            " + mtab);
        sb.append("logger.warn(\"illegal syntax pattern, \"+e.getMessage());");
        sb.append(CR);
        sb.append(basetab + "        " + mtab);
        sb.append("}");
        sb.append(CR);
        if (multiCheck) {
            sb.append(basetab + "        ");
            sb.append("}");
            sb.append(CR);
        }
        if (AppSchemaUtil.hasControl(this.item) && AppSchemaUtil.hasChildPart(this.item.getName())) {
            sb.append(basetab + "        ").append("}").append(CR);
        }
        return sb.toString();
    }
}

