/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.HelperGenerator;
import jp.jasminesoft.jfc.gen.HelperGeneratorBaseTask;
import jp.jasminesoft.jfc.gen.HelperGenerator_s2p_storeref_common;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.util.ResourceManagerFactory;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelperGenerator_parseCsvData_getObject
extends HelperGeneratorBaseTask {
    protected Project project;
    protected Logger logger = LogManager.getLogger((String)HelperGenerator_parseCsvData_getObject.class.getName());
    private Modelitem smitem;
    private Modelitem pmitem;
    private String methodname;
    private String parseStorerefType;
    private String pbean;
    private String pre_mitem_classname;
    private String invalidMark;
    private int version;

    public HelperGenerator_parseCsvData_getObject(Project project, Model model, Modelitem smitem, Modelitem pmitem, String methodname, String parseStorerefType) {
        this.project = project;
        this.model = model;
        this.smitem = smitem;
        this.pmitem = pmitem;
        this.methodname = methodname;
        this.parseStorerefType = parseStorerefType;
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
        this.pre_mitem_classname = AppSchemaUtil.getModelitemClassname(pmitem);
        this.invalidMark = JavaSourceGenerator.getInvalidMark(project);
        this.version = JavaSourceGenerator.getVersionAsInt(project);
    }

    public String getMethodname() {
        return this.methodname;
    }

    public boolean check() {
        Action action = null;
        action = AppSchemaUtil.getCsvoutputParameterModelitemIdref(AppSchemaUtil.getCsvoutputParameterModelitem(this.pmitem));
        return action != null;
    }

    @Override
    public String process() {
        return this.process("");
    }

    @Override
    public String process(String basetab) {
        String key;
        StringBuilder sb = new StringBuilder();
        IRNode node = this.model.getIdrefAsIRNode();
        if (node == null || !(node instanceof Model)) {
            Object[] o = new Object[]{this.model.getId(), this.model.getIdref()};
            this.logger.error(this.rman.getValue("value.null.rmodel", o));
            return sb.toString();
        }
        Model smodel = (Model)node;
        String _pmodel_id = this.model.getId();
        String _pmodel_classname = AppSchemaUtil.getClassname(this.model);
        String _smodel_id = smodel.getId();
        String _smodel_classname = AppSchemaUtil.getClassname(smodel);
        String pmodel_packagename = AppSchemaUtil.getPackagename(this.model, this.project);
        String pmitem_classname = AppSchemaUtil.getModelitemClassname(this.pmitem);
        sb.append("    ");
        sb.append("public ");
        sb.append(pmodel_packagename);
        sb.append(pmitem_classname);
        sb.append(" " + this.getMethodname() + "(");
        sb.append(CR);
        sb.append("        ");
        sb.append("String _key, String _content,");
        sb.append(CR);
        sb.append("        ");
        sb.append(_smodel_classname);
        sb.append(" ");
        sb.append(_smodel_id);
        sb.append(", ");
        sb.append(_pmodel_classname);
        sb.append(" ");
        sb.append(_pmodel_id);
        sb.append(",");
        sb.append(CR);
        if (AppSchemaUtil.hasChildPart(this.smitem.getName())) {
            String containername;
            Modelitem containermitem = AppSchemaUtil.getModelitem(AppSchemaUtil.getParentPart(this.smitem.getName()), smodel);
            String smodel_id = containername = containermitem.getName();
            String smodel_classname = AppSchemaUtil.getPackagename(smodel, this.project) + AppSchemaUtil.getModelitemClassname(containermitem);
            String pmodel_id = "p_" + containername;
            String pmodel_classname = pmodel_packagename + AppSchemaUtil.getModelitemClassname(containermitem);
            sb.append("        ");
            sb.append(smodel_classname);
            sb.append(" ");
            sb.append(smodel_id);
            sb.append(",");
            sb.append(CR);
            sb.append("        ");
            sb.append(pmodel_classname);
            sb.append(" ");
            sb.append(pmodel_id);
            sb.append(",");
            sb.append(CR);
        }
        sb.append("        ");
        sb.append("ActionParameter p, JFCErrorManager _manager)");
        sb.append(CR);
        sb.append("    ");
        sb.append("{");
        sb.append(CR);
        if (this.do_ready_pbean(sb, "")) {
            sb.append("        ");
            sb.append("return null;");
            sb.append(CR);
            sb.append("    ");
            sb.append("}");
            sb.append(CR);
            sb.append(CR);
            return sb.toString();
        }
        Modelitem smitem2 = AppSchemaUtil.getRelatedModelitemInCaseofTypeRef(this.project, smodel.getId(), this.smitem);
        Relation relation = AppSchemaUtil.getRelationTypeExceptRef(smitem2);
        if (relation == null) {
            relation = AppSchemaUtil.getRelationTypeIsRef(smitem2);
        }
        if (AppSchemaUtil.isCompositePrimaryKey(key = this.parseStorerefType != null && this.parseStorerefType.equals("roleid") ? AppSchemaUtil.getRoleid(relation, this.project) : relation.getRolecontent())) {
            String[] tokens = AppSchemaUtil.decompositePrimaryKey(key);
            for (int i = 0; i < tokens.length; ++i) {
                String _name = tokens[i];
                sb.append(basetab + "        ");
                sb.append("pbean.setParameter(\"" + StringUtil.convertJavaString((String)_name) + "\", ");
                sb.append(CR);
                sb.append(basetab + "            ");
                sb.append("JFCUtils.decodePrimaryKey(JFCUtils.separatePrimaryKey(_content, " + i + ")));");
                sb.append(CR);
            }
        } else {
            sb.append("        ");
            sb.append("pbean.setParameter(\"" + key + "\", _content);");
            sb.append(CR);
        }
        Model refsmodel = (Model)relation.getIdrefAsIRNode();
        int sstoragetype = AppSchemaUtil.getStorageType(refsmodel.getStorage());
        boolean isSetWrappedObjectParam = false;
        if (sstoragetype == 5) {
            isSetWrappedObjectParam = true;
        }
        sb.append(HelperGenerator_s2p_storeref_common.gSetTargetItemSetForProcessBean(isSetWrappedObjectParam, AppSchemaUtil.getRoleid(relation, this.project), new String[]{relation.getRolecontent()}, relation.getRolepriority(), relation.getRolevalid(), "        "));
        sb.append(this.process_combo_radio_update(""));
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected boolean do_ready_pbean(StringBuilder sb, String basetab) {
        Action action = null;
        action = AppSchemaUtil.getCsvoutputParameterModelitemIdref(AppSchemaUtil.getCsvoutputParameterModelitem(this.pmitem));
        if (action == null) {
            this.logger.error("No processbean is found. model:" + this.model.getId() + " pitem:" + this.pmitem);
            return true;
        }
        this.pbean = AppSchemaUtil.createProcessBeanName(action, this.project);
        sb.append(basetab + "        ");
        sb.append("ProcessBean pbean = ");
        sb.append(AppSchemaUtil.createNewProcessBeanInstanceCode(this.pbean, HelperGenerator.getPackageNameAsJavaRule(this.project, this.model)));
        sb.append(";");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("pbean.setActionParameter(p);");
        sb.append(CR);
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("if (!pbean.isValidPermission())");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("return null;");
        sb.append(CR);
        sb.append(CR);
        return false;
    }

    protected String process_combo_radio_update(String basetab) {
        StringBuilder sb = new StringBuilder();
        Model smodel = (Model)this.model.getIdrefAsIRNode();
        Modelitem smitem2 = AppSchemaUtil.getRelatedModelitemInCaseofTypeRef(this.project, smodel.getId(), this.smitem);
        Relation relation = AppSchemaUtil.getRelationTypeExceptRef(smitem2);
        if (relation == null) {
            relation = AppSchemaUtil.getRelationTypeIsRef(smitem2);
        }
        String roleid = AppSchemaUtil.getRoleid(relation, this.project);
        String rolecontent = relation.getRolecontent();
        String rolepriority = relation.getRolepriority();
        String rolevalid = relation.getRolevalid();
        Model refsmodel = (Model)relation.getIdrefAsIRNode();
        String sid = refsmodel.getId();
        String spackagename = AppSchemaUtil.getPackagename(refsmodel, this.project);
        String sclassname = AppSchemaUtil.getClassname(refsmodel);
        int sstoragetype = AppSchemaUtil.getStorageType(refsmodel.getStorage());
        sb.append(basetab + "        ");
        sb.append("Object o = null;");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("try {");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("o = pbean.process();");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("} catch (SecurityException se) {");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("logger.warn(\"" + this.pbean + " failed.\", se);");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("return null;");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("} finally {");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("pbean.release();");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("if (o == null || !(o instanceof java.util.List)) {");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("if (o != null) {");
        sb.append(CR);
        sb.append(basetab + "                ");
        sb.append("logger.warn(\"" + this.pbean + " failed. \"+o);");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("} else {");
        sb.append(CR);
        sb.append(basetab + "                ");
        sb.append("logger.warn(\"" + this.pbean + " failed.\");");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("return null;");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("java.util.List ");
        sb.append("_" + sid + "_list");
        sb.append(" = (java.util.List)o;");
        sb.append(CR);
        if (sstoragetype == 5) {
            sb.append(basetab + "        ");
            sb.append("jp.jasminesoft.jfc.app.RHibernateList ");
            sb.append("_" + sid);
            sb.append("_rlist = null;");
            sb.append(CR);
            sb.append(basetab + "        ");
            sb.append("if (o instanceof ");
            sb.append("jp.jasminesoft.jfc.app.RHibernateList) {");
            sb.append(CR);
            sb.append(basetab + "            ");
            sb.append("_" + sid + "_rlist");
            sb.append(" = (");
            sb.append("jp.jasminesoft.jfc.app.RHibernateList)o;");
            sb.append(CR);
            sb.append(basetab + "        ");
            sb.append("}");
            sb.append(CR);
        } else {
            sb.append(basetab + "        ");
            sb.append(spackagename);
            sb.append("RJDBCList ");
            sb.append("_" + sid);
            sb.append("_rlist = null;");
            sb.append(CR);
            sb.append(basetab + "        ");
            sb.append("if (o instanceof ");
            sb.append(spackagename);
            sb.append("RJDBCList) {");
            sb.append(CR);
            sb.append(basetab + "            ");
            sb.append("_" + sid + "_rlist");
            sb.append(" = (");
            sb.append(spackagename);
            sb.append("RJDBCList)o;");
            sb.append(CR);
            sb.append(basetab + "        ");
            sb.append("}");
            sb.append(CR);
        }
        sb.append(basetab + "        ");
        sb.append("try {");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("int size = ");
        sb.append("_" + sid + "_list");
        sb.append(".size();");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("if (size == 0) {");
        sb.append(CR);
        sb.append(basetab + "                ");
        sb.append("return null;");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("if (size > 1) {");
        sb.append(CR);
        sb.append(basetab + "                ");
        sb.append("// ").append(this.rman.getValue("helper.comment.HelperGenerator_getValidCsvHeader.twice"));
        sb.append(CR);
        sb.append(basetab + "                ");
        sb.append("Object[] oa = { _key, _content };");
        sb.append(CR);
        sb.append(basetab + "                ");
        sb.append("Jfcerror _error = _manager.getJfcerror(\"error.parseCsvData.tooManySameContent\", oa, p.locale);");
        sb.append(CR);
        sb.append(basetab + "                ");
        sb.append("p.errors.addJfcerror(_error);");
        sb.append(CR);
        sb.append(basetab + "                ");
        sb.append("return null;");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append(this.pre_mitem_classname);
        sb.append(" r_code = null;");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append(spackagename);
        sb.append(sclassname);
        sb.append(" ");
        sb.append("_" + sid);
        sb.append(" = null;");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("if (");
        sb.append("_" + sid);
        sb.append("_rlist != null) {");
        sb.append(CR);
        sb.append(basetab + "                ");
        sb.append("_" + sid);
        sb.append(" = (");
        sb.append(spackagename);
        sb.append(sclassname);
        sb.append(")");
        sb.append("_" + sid);
        sb.append("_rlist.getObject(0);");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("} else {");
        sb.append(CR);
        sb.append(basetab + "                ");
        sb.append("_" + sid);
        sb.append(" = (");
        sb.append(spackagename);
        sb.append(sclassname);
        sb.append(")");
        sb.append("_" + sid);
        sb.append("_list.get(0);");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("r_code = ");
        sb.append("new ");
        sb.append(this.pre_mitem_classname);
        sb.append("();");
        sb.append(CR);
        HelperGenerator_s2p_storeref_common.createSetId2RCode(sb, basetab + "            ", sid, roleid, rolecontent, refsmodel, this.project);
        this.createSetContentByRolecontent(sb, basetab + "            ", "r_code", sid, new String[]{rolecontent}, refsmodel);
        if (rolevalid != null && rolevalid.length() > 0) {
            if (this.version < 4) {
                sb.append(basetab + "            ");
                sb.append("if (_" + sid);
                sb.append(JavaSourceGenerator.getterFullMethod(rolevalid));
                sb.append(" != null &&");
                sb.append(CR);
                sb.append(basetab + "                ");
                sb.append("_" + sid);
                sb.append(JavaSourceGenerator.getterFullMethod(rolevalid));
                sb.append(".length() > 0) {");
                sb.append(CR);
            } else {
                sb.append(basetab + "            ");
                sb.append("if (!JFCUtils.isValidValue(");
                sb.append("_" + sid);
                sb.append(JavaSourceGenerator.getterFullMethod(rolevalid));
                sb.append(")) {");
                sb.append(CR);
            }
            sb.append(basetab + "                ");
            if (StringUtils.isNotBlank((CharSequence)this.invalidMark)) {
                sb.append("r_code.setContent(r_code.getContent() + \"" + this.invalidMark + "\");");
            } else {
                sb.append("r_code.setContent(r_code.getContent());");
            }
            sb.append(CR);
            sb.append(basetab + "                ");
            sb.append("r_code.setInvalid(true);");
            sb.append(CR);
            sb.append(basetab + "            ");
            sb.append("}");
            sb.append(CR);
        }
        if (rolepriority != null && rolepriority.length() > 0) {
            sb.append(basetab + "            ");
            sb.append("r_code.setPriority(_" + sid);
            sb.append(JavaSourceGenerator.getterFullMethod(rolepriority));
            sb.append(");");
            sb.append(CR);
        }
        sb.append(basetab + "            ");
        sb.append("r_code.setChoose(true);");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("return r_code;");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("} catch (Exception e) {");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("logger.warn(\"_" + sid + "List access failed.\", e);");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("return null;");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("} finally {");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("if (");
        sb.append("_" + sid);
        sb.append("_rlist != null) {");
        sb.append(CR);
        sb.append(basetab + "                ");
        sb.append("try {");
        sb.append(CR);
        sb.append(basetab + "                    ");
        sb.append("_" + sid);
        sb.append("_rlist.close();");
        sb.append(CR);
        if (sstoragetype == 5) {
            sb.append(basetab + "                ");
            sb.append("} catch (Exception ex) {");
            sb.append(CR);
        } else {
            sb.append(basetab + "                ");
            sb.append("} catch (SQLException ex) {");
            sb.append(CR);
        }
        sb.append(basetab + "                    ");
        sb.append("logger.warn(\"_" + sid + "List close failed.\", ex);");
        sb.append(CR);
        sb.append(basetab + "                ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("}");
        sb.append(CR);
        return sb.toString();
    }

    protected void createSetContentByRolecontent(StringBuilder sb, String tab, String varname, String sid, String[] rolecontents, Model smodel) {
        ArrayList<String> _list = new ArrayList<String>();
        for (int k = 0; k < rolecontents.length; ++k) {
            String rolecontent = rolecontents[k];
            if (rolecontent.length() == 0) {
                _list.add("\"\"");
                continue;
            }
            char c = rolecontent.charAt(0);
            if (c == '\'' || c == '\"') {
                int end = rolecontent.length();
                if (rolecontent.charAt(end - 1) == c) {
                    --end;
                }
                StringBuilder sb0 = new StringBuilder();
                sb0.append("\"");
                if (end > 1) {
                    String _src = rolecontent.substring(1, end);
                    sb0.append(StringUtil.convertJavaString((String)_src));
                }
                sb0.append("\"");
                _list.add(sb0.toString());
                continue;
            }
            String _src = this.createSetContentSource(sid, rolecontents[k], smodel);
            if (_src != null && _src.length() > 0) {
                _list.add(_src);
                continue;
            }
            _list.add("\"\"");
        }
        if (_list.size() == 0) {
            return;
        }
        if (_list.size() == 1) {
            sb.append(tab);
            sb.append(varname);
            sb.append(".setContent(");
            sb.append((String)_list.get(0));
            sb.append(");");
            sb.append(CR);
            return;
        }
        String contentbuf_varname = varname + "_contentbuf";
        sb.append(tab);
        sb.append("StringBuilder " + contentbuf_varname + " = new StringBuilder();");
        sb.append(CR);
        for (String s : _list) {
            sb.append(tab);
            sb.append(contentbuf_varname);
            sb.append(".append(");
            sb.append(s);
            sb.append(");");
            sb.append(CR);
        }
        sb.append(tab);
        sb.append(varname);
        sb.append(".setContent(");
        sb.append(contentbuf_varname);
        sb.append(".toString());");
        sb.append(CR);
    }

    protected String createSetContentSource(String sid, String rolecontent, Model relmodel) {
        if (rolecontent == null || rolecontent.length() == 0 || relmodel == null) {
            return null;
        }
        Modelitem relmitem = null;
        IModelChoice[] relimc = relmodel.getContent();
        if (relimc != null) {
            for (int i = 0; !(i >= relimc.length || relimc[i] instanceof Modelitem && rolecontent.equals((relmitem = (Modelitem)relimc[i]).getName())); ++i) {
            }
        }
        String ctype = AppSchemaUtil.getModelitemType(this.project, relmodel.getId(), relmitem, "roleid");
        StringBuilder sb = new StringBuilder();
        if (JavaSourceGenerator.isBasicType(ctype)) {
            sb.append(JavaSourceGenerator.getB2wc_method(ctype));
            sb.append("(");
        } else if (JavaSourceGenerator.isDateOrTimeType(ctype)) {
            String fmt = null;
            fmt = "date".equals(ctype) ? "yyyy-MM-dd" : ("time".equals(ctype) ? "HH:mm:ss" : "yyyy-MM-dd HH:mm:ss");
            sb.append("(new SimpleDateFormat(\"");
            sb.append(fmt);
            sb.append("\")).format(");
        } else if (!"string".equals(ctype)) {
            sb.append("String.valueOf(");
        }
        sb.append("_" + sid);
        if (rolecontent.indexOf("/") < 0) {
            sb.append(JavaSourceGenerator.getterFullMethod(rolecontent));
        } else {
            int _idx = rolecontent.indexOf("/");
            String pname = rolecontent.substring(0, _idx);
            String cname = rolecontent.substring(_idx + 1);
            sb.append(JavaSourceGenerator.getterFullMethod(pname));
            sb.append("[0]");
            sb.append(JavaSourceGenerator.getterFullMethod(cname));
        }
        if (JavaSourceGenerator.isBasicType(ctype)) {
            sb.append(")");
        } else if (!"string".equals(ctype)) {
            sb.append(")");
        }
        return sb.toString();
    }
}

