/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.HashMap;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CommentGenerator;
import jp.jasminesoft.jfc.gen.HelperGeneratorBaseTask;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Filteritem;
import jp.jasminesoft.jfc.gen.appschema.Filterlist;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.util.ResourceManagerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelperGenerator_preprocess
extends HelperGeneratorBaseTask {
    protected Logger logger = LogManager.getLogger((String)HelperGenerator_preprocess.class.getName());

    public HelperGenerator_preprocess(Model model) {
        this.model = model;
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
    }

    @Override
    public String process() {
        return this.process("");
    }

    @Override
    public String process(String basetab) {
        StringBuilder sb = new StringBuilder();
        String id = this.model.getId();
        String classname = AppSchemaUtil.getClassname(this.model);
        HashMap<String, Filterlist> filterMap = new HashMap<String, Filterlist>();
        IModelChoice[] imc = this.model.getContent();
        if (imc != null) {
            for (int i = 0; i < imc.length; ++i) {
                if (!(imc[i] instanceof Filterlist)) continue;
                Filterlist filterlist = (Filterlist)((Object)imc[i]);
                filterMap.put(filterlist.getId(), filterlist);
            }
        }
        String[] msg_param = new String[]{id + " " + classname, "jsp_encoding"};
        sb.append(CommentGenerator.gComment(this.rman.getValue("helper.comment.preprocess"), msg_param, null));
        sb.append("    ");
        sb.append("public void preprocess(");
        sb.append(classname);
        sb.append(" ");
        sb.append(id);
        sb.append(", String jsp_encoding, ActionParameter p)");
        sb.append(CR);
        sb.append("    ");
        sb.append("{");
        sb.append(CR);
        if (filterMap.size() == 0) {
            sb.append("    ");
            sb.append("}");
            sb.append(CR);
            return sb.toString();
        }
        sb.append("    ").append("FilterManager filterman = (jp.jasminesoft.jfc.FilterManager)p.appctx.getBean(\"filterManager\");").append(CR);
        for (String _id : filterMap.keySet()) {
            Filterlist filterlist = (Filterlist)filterMap.get(_id);
            sb.append(this.gDefineFilter(_id, filterlist));
        }
        imc = this.model.getContent();
        if (imc != null) {
            for (int i = 0; i < imc.length; ++i) {
                Modelitem item;
                String filtername;
                if (!(imc[i] instanceof Modelitem) || (filtername = (item = (Modelitem)imc[i]).getFilter()) == null || filtername.length() == 0) continue;
                String objectname = id;
                sb.append(this.gAdaptFilter(objectname, item.getName(), filtername));
            }
        }
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        return sb.toString();
    }

    protected String gDefineFilter(String key, Filterlist pt) {
        Filteritem[] items = pt.getFilteritem();
        if (items.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < items.length; ++i) {
            String targetchar;
            Filteritem item = items[i];
            String type = item.getType();
            if (type == null || type.length() == 0) continue;
            if ("removeSpace".equals(type)) {
                sb.insert(0, "new StringRemoveSpaceFilter(");
                String pattern = item.getContent();
                if (pattern == null || pattern.length() == 0) {
                    sb.append(")");
                    continue;
                }
                if (i == 0) {
                    sb.append("null");
                }
                sb.append(", \"" + pattern + "\")");
                continue;
            }
            if ("encoding".equals(type)) {
                sb.insert(0, "new StringEncodeFilter(");
                if (i == 0) {
                    sb.append("null");
                }
                sb.append(", jsp_encoding)");
                continue;
            }
            if ("z2h".equals(type)) {
                targetchar = item.getContent();
                if (targetchar == null || targetchar.length() == 0) continue;
                if ("number".equals(targetchar)) {
                    sb.insert(0, "new StringConvNumZ2HFilter(");
                } else if ("alphabet".equals(targetchar)) {
                    sb.insert(0, "new StringConvAlphabetZ2HFilter(");
                } else if ("kana".equals(targetchar)) {
                    sb.insert(0, "new StringConvKanaZ2HFilter(");
                }
                sb.append(")");
                continue;
            }
            if ("h2z".equals(type)) {
                targetchar = item.getContent();
                if (targetchar == null || targetchar.length() == 0) continue;
                if ("number".equals(targetchar)) {
                    sb.insert(0, "new StringConvNumH2ZFilter(");
                } else if ("alphabet".equals(targetchar)) {
                    sb.insert(0, "new StringConvAlphabetH2ZFilter(");
                } else if ("kana".equals(targetchar)) {
                    sb.insert(0, "new StringConvKanaH2ZFilter(");
                }
                sb.append(")");
                continue;
            }
            if (!"chref".equals(type)) continue;
            sb.insert(0, "new StringCharacterReferenceFilter(");
            sb.append(")");
        }
        sb.insert(0, "        StringFilter " + key + " = ");
        sb.append(";");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected String gAdaptFilter(String objectname, String elementname, String filtername) {
        StringBuilder sb = new StringBuilder();
        sb.append("        ");
        sb.append(objectname);
        sb.append(".");
        sb.append(JavaSourceGenerator.setterMethod(elementname));
        sb.append("(");
        sb.append(filtername);
        sb.append(".filter(");
        sb.append(objectname);
        sb.append(".");
        sb.append(JavaSourceGenerator.getterMethod(elementname));
        sb.append("()");
        sb.append("));");
        sb.append(CR);
        return sb.toString();
    }
}

