/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CommentGenerator;
import jp.jasminesoft.jfc.gen.RelaxerWrapperBaseGenerator;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Dataitem;
import jp.jasminesoft.jfc.gen.appschema.Datalist;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Project;

public class HibernateListGenerator
extends RelaxerWrapperBaseGenerator {
    public HibernateListGenerator(Project project, Model model) {
        super(project, model);
    }

    @Override
    public String getClassname() {
        return AppSchemaUtil.getHibernateListclassname(this.model, this.project);
    }

    @Override
    public String getClassDeclarationSuffix() {
        String classname = AppSchemaUtil.getClassname(this.model);
        return " extends RHibernateList<" + classname + ">";
    }

    @Override
    public String[] getDefaultImport() {
        ArrayList<Object> importList = new ArrayList<Object>();
        importList.add("java.util.Set");
        importList.add("javax.xml.parsers.ParserConfigurationException");
        importList.add("org.w3c.dom.Document");
        importList.add("org.hibernate.Session");
        importList.add("org.hibernate.Query");
        importList.add("org.hibernate.Transaction");
        importList.add("org.hibernate.ScrollableResults");
        importList.add("jp.jasminesoft.jfc.ActionParameter");
        importList.add("jp.jasminesoft.jfc.ProcessBean");
        importList.add("jp.jasminesoft.jfc.app.RHibernateList");
        Object s = AppSchemaUtil.getPackagename(this.model, this.project);
        s = (String)s + "*";
        importList.add(s);
        return importList.toArray(new String[0]);
    }

    @Override
    protected String gVariableDefinition() {
        return "";
    }

    @Override
    protected String gConstructor() {
        StringBuilder sb = new StringBuilder();
        String[] param = new String[]{"result ScrollableResults", "st Session"};
        sb.append(CommentGenerator.gComment(rman.getValue("java.comment.constructor"), param, null));
        sb.append("    ");
        sb.append("public ");
        sb.append(this.getClassname());
        sb.append("(ScrollableResults result, Session st) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("super(result, st, null);");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        param = new String[]{"result ScrollableResults", "st Session", "expression String"};
        sb.append(CommentGenerator.gComment(rman.getValue("java.comment.constructor"), param, null));
        sb.append("    ");
        sb.append("public ");
        sb.append(this.getClassname());
        sb.append("(ScrollableResults result, Session st, String expression) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("super(result, st, expression);");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        param = new String[]{"result ScrollableResults", "st Session", "wrapobj return wrapped object for getObject method"};
        sb.append(CommentGenerator.gComment(rman.getValue("java.comment.constructor"), param, null));
        sb.append("    ");
        sb.append("public ");
        sb.append(this.getClassname());
        sb.append("(ScrollableResults result, Session st, boolean wrapobj) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("super(result, st);");
        sb.append(CR);
        sb.append("        ");
        sb.append("setReturnWrappedObject(wrapobj);");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    @Override
    protected String gBody() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.gCreateMethod_getSourceObject());
        sb.append(this.gCreateMethod_removeAttribute());
        sb.append(this.gCreateMethod_createObject());
        sb.append(this.gCreateMethod_beforeShowProcess());
        sb.append(this.gCreateMethod_getCountProcessBeanName());
        return sb.toString();
    }

    protected String gCreateMethod_getSourceObject() {
        String classname = AppSchemaUtil.getClassname(this.model);
        StringBuilder sb = new StringBuilder();
        String[] param = new String[]{"int index"};
        sb.append(CommentGenerator.gComment("gets a " + classname + ".", param, null, null));
        sb.append("    ");
        sb.append("protected " + classname + " get" + classname + "(int index) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("return ((");
        sb.append(classname);
        sb.append(")getObject(index));");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected String gCreateMethod_createObject() {
        String classname = AppSchemaUtil.getClassname(this.model);
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("protected ").append(classname);
        sb.append(" createObject(").append(classname).append(" src) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("return new ");
        sb.append(classname);
        sb.append("(src);");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected String gCreateMethod_removeAttribute() {
        Datalist datalist;
        Dataitem[] dataitems;
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("protected void removeAttribute() {");
        sb.append(CR);
        int count = 0;
        Action showAction = AppSchemaUtil.getActionByModelIdAndType(this.project, this.model.getId(), "show");
        if (showAction != null && (dataitems = (datalist = AppSchemaUtil.getDatalist(showAction)).getDataitem()) != null && dataitems.length > 1) {
            for (int i = 1; i < dataitems.length; ++i) {
                if ("reverse".equals(dataitems[i].getType())) continue;
                sb.append("        ");
                sb.append("p.request.removeAttribute(\"");
                sb.append(dataitems[i].getIdref());
                sb.append("\");");
                sb.append(CR);
                sb.append(CR);
                ++count;
            }
        }
        if (count == 0) {
            return "";
        }
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected String gCreateMethod_beforeShowProcess() {
        String classname = AppSchemaUtil.getClassname(this.model);
        String hclassname = AppSchemaUtil.getHelperClassname4Dicon(this.model, this.project);
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("protected void beforeShowProcess(").append(classname).append(" src) {");
        sb.append(CR);
        sb.append("        ");
        sb.append(hclassname);
        sb.append(".beforeShow(src, p, _targetItemSet, true, true);");
        sb.append(CR);
        if (AppSchemaUtil.hasRiskInfiniteLoop(this.model, this.project)) {
            String id = this.model.getId();
            String helperClassName = AppSchemaUtil.getHelperClassname(this.model);
            sb.append("        ");
            sb.append("p.request.removeAttribute(\"__jfc_control.callBeforeShowCount");
            sb.append("_").append(id);
            sb.append("_\" + ").append(helperClassName).append(".getPrimaryKeyAsString(").append("src").append(", p)");
            sb.append(");");
            sb.append(CR);
        }
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected String gCreateMethod_getCountProcessBeanName() {
        String pbean_name = AppSchemaUtil.createProcessBeanName(this.model.getId(), "getCount", null, null);
        String pbean_default_packagename = this.project.getPackage() + "." + this.getSubpackageNameAsJavaRule();
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("protected ProcessBean getCountProcessBean() {");
        sb.append(CR);
        sb.append("        ");
        sb.append("ProcessBean pbean = ");
        sb.append(AppSchemaUtil.createNewProcessBeanInstanceCode(pbean_name, pbean_default_packagename));
        sb.append(";");
        sb.append(CR);
        sb.append("        ");
        sb.append("return pbean;").append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        return sb.toString();
    }
}

