/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CommentGenerator;
import jp.jasminesoft.jfc.gen.DbTypeManager;
import jp.jasminesoft.jfc.gen.HelperGenerator_beforeBase;
import jp.jasminesoft.jfc.gen.HelperGenerator_filter_init;
import jp.jasminesoft.jfc.gen.JFCAppGenerator;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.TablenameGenerator;
import jp.jasminesoft.jfc.gen.appschema.Environment;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.StringUtil;
import jp.jasminesoft.util.VelocityUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InitLoaderGenerator
extends JavaSourceGenerator {
    public static final String SUB_PACKAGE_NAME = "initdb";
    protected Logger logger = LogManager.getLogger((String)InitLoaderGenerator.class.getName());
    protected Set<String> filterSet = null;
    protected String[] defaultImportStatement;
    private static final String[] XML2DBImportStatement = new String[]{"java.io.*", "java.util.List", "java.util.ArrayList", "java.sql.Connection", "java.sql.Statement", "java.sql.ResultSet", "java.sql.SQLException", "javax.xml.parsers.*", "javax.xml.transform.*", "javax.xml.transform.dom.*", "javax.xml.transform.stream.*", "org.w3c.dom.*", "org.apache.logging.log4j.Logger", "org.apache.logging.log4j.LogManager", "jp.jasminesoft.jfc.ActionParameter", "jp.jasminesoft.jfc.JFCUtils", "jp.jasminesoft.jfc.initdb.*", "jp.jasminesoft.jfc.initdb.conf.Directory", "jp.jasminesoft.jfc.initdb.conf.Sequence", "jp.jasminesoft.jfc.app.CommonService", "jp.jasminesoft.jfc.app.IllegalMergeObjectException", "jp.jasminesoft.util.JaxbUtil", "org.springframework.context.ApplicationContext", "org.springframework.context.support.FileSystemXmlApplicationContext"};
    private static final String[] TEXTSEARCHImportStatement = new String[]{"jp.jasminesoft.jfc.textsearch.servlet.*"};
    private String jfc_version = null;
    static final String TEXT_SEARCH_TEMPLATE_FILE = "template/javasrc/initdb/textsearch.vm";

    public InitLoaderGenerator(Project project) {
        super(project);
        this.initDefaultImportStatement();
        this.filterSet = new HashSet<String>();
    }

    private void initDefaultImportStatement() {
        Model model;
        ArrayList<Object> pkgList = new ArrayList<Object>();
        for (String s : XML2DBImportStatement) {
            pkgList.add(s);
        }
        if (JFCAppGenerator.getIsTextSearch()) {
            for (String s : TEXTSEARCHImportStatement) {
                pkgList.add(s);
            }
        }
        if ((model = AppSchemaUtil.getModel(this.project, "jfcflow_setting")) != null) {
            String packagename = AppSchemaUtil.getPackagename_app(model, this.project);
            pkgList.add(packagename + "JfcflowSettingUtil");
        }
        if ((model = AppSchemaUtil.getModel(this.project, "jfcportlet")) != null) {
            String packagename = AppSchemaUtil.getPackagename_app(model, this.project);
            pkgList.add(packagename + "JfcportletUtil");
        }
        this.defaultImportStatement = pkgList.toArray(new String[0]);
    }

    public boolean isValidType(String type) {
        if (type == null) {
            return false;
        }
        return "store".equals(type) || "master".equals(type);
    }

    @Override
    public String process0() {
        String loader_method = this.gLoaderMethod();
        StringBuilder sb = new StringBuilder();
        sb.append(this.gHeader());
        sb.append(this.gClassDeclaration());
        sb.append(this.gBegin());
        sb.append(this.gStaticDeclare());
        sb.append(loader_method);
        sb.append(this.gDoExecute());
        if (this.useTextSearch()) {
            sb.append(this.gTextSearch());
        }
        sb.append(this.gVersion());
        sb.append(this.gMain());
        sb.append(this.gEnd());
        return sb.toString();
    }

    boolean useTextSearch() {
        IProjectChoice[] ipcs;
        if (!JFCAppGenerator.getIsTextSearch()) {
            return false;
        }
        for (IProjectChoice ipc : ipcs = this.project.getContent()) {
            Model model;
            if (!(ipc instanceof Model) || !(model = (Model)ipc).getTextsearch()) continue;
            return true;
        }
        return false;
    }

    public String gTextSearch() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.createVariableBaseMap(map);
        return VelocityUtils.mergeContent((String)TEXT_SEARCH_TEMPLATE_FILE, map);
    }

    protected void createVariableBaseMap(Map<String, Object> map) {
        String webappname = this.project.getWebappname();
        if (StringUtils.isEmpty((CharSequence)webappname)) {
            webappname = "ROOT";
        }
        map.put("webappname", webappname);
        map.put("jfcpackagename", this.project.getPackage());
    }

    public String gClassDeclaration() {
        StringBuilder sb = new StringBuilder();
        sb.append("public class ");
        sb.append(this.getClassname());
        sb.append(" extends XML2DBLoader");
        sb.append(CR);
        return sb.toString();
    }

    public String getClassExplanation() {
        return rman.getValue("initloader.comment.explanation");
    }

    @Override
    public String getClassname() {
        return "InitLoader";
    }

    @Override
    public String getSubpackageName() {
        return SUB_PACKAGE_NAME;
    }

    @Override
    public String getSubpackageNameAsJavaRule() {
        return this.getSubpackageName();
    }

    @Override
    public String[] getDefaultImport() {
        return this.defaultImportStatement;
    }

    public String gHeader() {
        String[] ary;
        StringBuilder sb = new StringBuilder();
        boolean useCVSFlag = this.project.getUseCVS();
        if (useCVSFlag) {
            sb.append("/*");
            sb.append(CR);
            sb.append(" * $Id:$");
            sb.append(CR);
            sb.append(" */");
            sb.append(CR);
            sb.append("");
            sb.append(CR);
        }
        if (this.project.getPackage() != null) {
            sb.append("package ");
            sb.append(this.project.getPackage());
            sb.append(".");
            sb.append(this.getSubpackageNameAsJavaRule());
            sb.append(";");
            sb.append(CR);
            sb.append("");
            sb.append(CR);
        }
        if ((ary = this.getDefaultImport()) != null) {
            for (int i = 0; i < ary.length; ++i) {
                sb.append("import ");
                sb.append(ary[i]);
                sb.append(";");
                sb.append(CR);
            }
        }
        sb.append("import " + this.project.getPackage() + ".app.*;");
        sb.append(CR);
        HashSet<String> useSet = new HashSet<String>();
        IProjectChoice[] ipc = this.project.getContent();
        if (ipc != null) {
            for (int i = 0; i < ipc.length; ++i) {
                String packagename;
                Model model;
                String type;
                if (!(ipc[i] instanceof Model) || !this.isValidType(type = (model = (Model)ipc[i]).getType()) || !AppSchemaUtil.isGenerateInitLoader(model) || (packagename = AppSchemaUtil.getPackagename(model, this.project)) == null || packagename.length() <= 0 || useSet.contains(packagename)) continue;
                sb.append("import ");
                sb.append(packagename);
                sb.append(AppSchemaUtil.getClassname(model));
                sb.append(";");
                sb.append(CR);
                useSet.add(packagename);
            }
        }
        sb.append("");
        sb.append(CR);
        sb.append("/**");
        sb.append(CR);
        sb.append(" * " + AppSchemaUtil.getTitle(this.project));
        sb.append(CR);
        String[] comment_str = StringUtil.separateLine((String)this.getClassExplanation(), (int)72);
        if (comment_str != null) {
            for (int i = 0; i < comment_str.length; ++i) {
                sb.append(" * ");
                sb.append(comment_str[i]);
                sb.append(CR);
            }
        }
        sb.append(" *");
        sb.append(CR);
        if (useCVSFlag) {
            sb.append(" * @version $Revision:$ ");
            sb.append("Date:$");
            sb.append(CR);
        }
        sb.append(" * @author " + this.project.getAuthor());
        sb.append(CR);
        sb.append(" */");
        sb.append(CR);
        sb.append("");
        sb.append(CR);
        return sb.toString();
    }

    protected String gStaticDeclare() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.gLoggerReady("InitLoader"));
        return sb.toString();
    }

    protected String gLoaderMethod() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.gConstructor());
        sb.append(this.gGetDeployHomePath());
        sb.append(this.gInit());
        sb.append(this.gDoTableclassname());
        sb.append(this.gDoObjectclassname());
        sb.append(this.gCreateActionParameter());
        sb.append(this.gUpdateSequenceByImportTable());
        sb.append(this.gIsAutoSequenceData());
        sb.append(this.gBeforeImport());
        sb.append(this.gExportSequenceByExportTable());
        sb.append(this.gSuccessImport());
        return sb.toString();
    }

    protected String gConstructor() {
        StringBuilder sb = new StringBuilder();
        sb.append(CommentGenerator.gComment(rman.getValue("java.comment.constructor"), null, null));
        sb.append("    ");
        sb.append("private InitLoader() {");
        sb.append(CR);
        sb.append("        ");
        sb.append("super();");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected String gGetDeployHomePath() {
        String webappname = AppSchemaUtil.getWebappName(this.project);
        StringBuilder path = new StringBuilder();
        path.append("../webapps/");
        path.append(webappname);
        StringBuilder sb = new StringBuilder();
        sb.append(CommentGenerator.gComment(rman.getValue("initloader.comment.getdeloyhome"), null, null));
        sb.append("    ");
        sb.append("public static String getDeployHomePath() {");
        sb.append(CR);
        sb.append("        ");
        sb.append("return \"").append((CharSequence)path).append("\";").append(CR);
        sb.append("    ");
        sb.append("}").append(CR).append(CR);
        sb.append("    ");
        sb.append("@Override");
        sb.append(CR);
        sb.append("    ");
        sb.append("public String getDeployHomeDir() {");
        sb.append(CR);
        sb.append("        ");
        sb.append("return getDeployHomePath() + \"/WEB-INF/\";").append(CR);
        sb.append("    ");
        sb.append("}").append(CR).append(CR);
        return sb.toString();
    }

    protected String gInit() {
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("private File configfile_parentdir;");
        sb.append(CR);
        sb.append(CR);
        String[] msg_param = new String[]{"filename configuration file"};
        sb.append(CommentGenerator.gComment(rman.getValue("initloader.comment.init"), msg_param, null));
        sb.append("    ");
        sb.append("protected void init(String filename) throws IllegalStateException {");
        sb.append(CR);
        sb.append("        ");
        sb.append("super.init(filename);");
        sb.append(CR);
        sb.append(CR);
        sb.append("        ");
        sb.append("configfile_parentdir = new File(filename).getParentFile();");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected String gDoTableclassname() {
        StringBuilder sb = new StringBuilder();
        IProjectChoice[] ipc = this.project.getContent();
        if (ipc == null) {
            return sb.toString();
        }
        String[] msg_param = new String[]{"tablename Tablename"};
        sb.append(CommentGenerator.gComment(rman.getValue("initloader.comment.gettableclassname"), msg_param, "String"));
        sb.append("    ");
        sb.append("public String getTableclassname(String tablename) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("String tableclassname = super.getTableclassname(");
        sb.append("tablename);");
        sb.append(CR);
        sb.append("        ");
        sb.append("if (tableclassname != null) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("return tableclassname;");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        int count = 0;
        sb.append("        ");
        for (int i = 0; i < ipc.length; ++i) {
            if (!(ipc[i] instanceof Model)) continue;
            Model model = (Model)ipc[i];
            String type = model.getType();
            String storage = model.getStorage();
            int storagetype = AppSchemaUtil.getStorageType(storage);
            if (!this.isValidType(type) || !AppSchemaUtil.isGenerateInitLoader(model) || storagetype != 0 || "master".equals(type)) continue;
            String packagename = AppSchemaUtil.getPackagename(model, this.project);
            String tablename = TablenameGenerator.createTableVariableName(model);
            String tableclassname = AppSchemaUtil.getRelaxerTableclassname(model, this.project);
            sb.append("if (JFCAppTablename.");
            sb.append(tablename);
            sb.append(".equals(tablename)) {");
            sb.append(CR);
            sb.append("            ");
            sb.append("return \"");
            sb.append(packagename);
            sb.append(tableclassname);
            sb.append("\";");
            sb.append(CR);
            sb.append("        ");
            sb.append("} else ");
            ++count;
        }
        if (count > 0) {
            sb.append(" {");
            sb.append(CR);
            sb.append("            ");
            sb.append("return null;");
            sb.append(CR);
            sb.append("        ");
            sb.append("}");
            sb.append(CR);
        } else {
            sb.append("return null;");
            sb.append(CR);
        }
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected String gDoObjectclassname() {
        StringBuilder sb = new StringBuilder();
        IProjectChoice[] ipc = this.project.getContent();
        if (ipc == null) {
            return sb.toString();
        }
        String[] msg_param = new String[]{"dir Directory"};
        sb.append(CommentGenerator.gComment(rman.getValue("initloader.comment.getobjectclassname"), msg_param, "String"));
        sb.append("    ");
        sb.append("public String getObjectclassname(Directory dir) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("String objclassname = super.getObjectclassname(");
        sb.append("dir);");
        sb.append(CR);
        sb.append("        ");
        sb.append("if (objclassname != null) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("return objclassname;");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append("        ");
        sb.append("String modelid = dir.getTablename();");
        sb.append(CR);
        sb.append("        ");
        boolean exists_hibernate_model = false;
        for (int i = 0; i < ipc.length; ++i) {
            if (!(ipc[i] instanceof Model)) continue;
            Model model = (Model)ipc[i];
            String type = model.getType();
            String storage = model.getStorage();
            int storagetype = AppSchemaUtil.getStorageType(storage);
            if (!this.isValidType(type) || !AppSchemaUtil.isGenerateInitLoader(model) || storagetype != 5 && (storagetype != 0 || !"master".equals(type))) continue;
            String packagename = AppSchemaUtil.getPackagename(model, this.project);
            String tablename = TablenameGenerator.createTableVariableName(model);
            String objclassname = AppSchemaUtil.getClassname(model);
            sb.append("if (JFCAppTablename.");
            sb.append(tablename);
            sb.append(".equals(modelid)) {");
            sb.append(CR);
            sb.append("            ");
            sb.append("return \"");
            sb.append(packagename);
            sb.append(objclassname);
            sb.append("\";");
            sb.append(CR);
            sb.append("        ");
            sb.append("} else ");
            exists_hibernate_model = true;
        }
        if (!exists_hibernate_model) {
            return "";
        }
        sb.append(" {");
        sb.append(CR);
        sb.append("            ");
        sb.append("return null;");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected String gDoDirectoryclassname() {
        StringBuilder sb = new StringBuilder();
        IProjectChoice[] ipc = this.project.getContent();
        if (ipc == null) {
            return sb.toString();
        }
        String[] msg_param = new String[]{"tablename Tablename"};
        sb.append(CommentGenerator.gComment(rman.getValue("initloader.comment.gettableclassname"), msg_param, "String"));
        sb.append("    ");
        sb.append("public String getDirectoryclassname(String tablename) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("String tableclassname =");
        sb.append(CR);
        sb.append("            ");
        sb.append("TableConfigManager.getInstance().getDirectoryclassname(tablename);");
        sb.append(CR);
        sb.append("        ");
        sb.append("if (tableclassname != null) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("return tableclassname;");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append("        ");
        for (int i = 0; i < ipc.length; ++i) {
            Model model;
            String type;
            if (!(ipc[i] instanceof Model) || !this.isValidType(type = (model = (Model)ipc[i]).getType()) || !AppSchemaUtil.isGenerateInitLoader(model)) continue;
            String packagename = AppSchemaUtil.getPackagename(model, this.project);
            String tablename = TablenameGenerator.createTableVariableName(model);
            String tableclassname = AppSchemaUtil.getRelaxerTableclassname(model, this.project);
            sb.append("if (JFCAppTablename.");
            sb.append(tablename);
            sb.append(".equals(tablename)) {");
            sb.append(CR);
            sb.append("            ");
            sb.append("return \"");
            sb.append(packagename);
            sb.append(tableclassname);
            sb.append("\";");
            sb.append(CR);
            sb.append("        ");
            sb.append("} else ");
        }
        sb.append(" {");
        sb.append(CR);
        sb.append("            ");
        sb.append("return null;");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected String gUpdateSequenceByImportTable() {
        StringBuilder sb = new StringBuilder();
        IProjectChoice[] ipc = this.project.getContent();
        if (ipc == null) {
            return sb.toString();
        }
        StringBuilder sb0 = new StringBuilder();
        for (int i = 0; i < ipc.length; ++i) {
            String storage;
            int storagetype;
            PrimaryKey[] pkeys;
            Model model;
            String type;
            if (!(ipc[i] instanceof Model) || (type = (model = (Model)ipc[i]).getType()) == null || !"store".equals(type) || !AppSchemaUtil.isGenerateInitLoader(model) || (pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(model, this.project)) == null) continue;
            PrimaryKey pkeyitem = null;
            for (int j = 0; j < pkeys.length; ++j) {
                if (!this.isUseAutoid(model, pkeys[j])) continue;
                pkeyitem = pkeys[j];
                break;
            }
            if (pkeyitem == null || (storagetype = AppSchemaUtil.getStorageType(storage = model.getStorage())) == 3 || storagetype != 0 && storagetype != 5) continue;
            sb0.append(this.gUpdateSequenceByImportTable0(model, pkeyitem));
        }
        sb.append(sb0.toString());
        sb.append(CR);
        return sb.toString();
    }

    protected boolean isUseAutoid(Model model, PrimaryKey pkey) {
        return this.isUseAutoid(model, pkey, false);
    }

    protected boolean isUseAutoid(Model model, PrimaryKey pkey, boolean isWarnUseseqNull) {
        String pkey_type = AppSchemaUtil.getPkeyType(model, pkey.getName(), pkey.getType(), this.project);
        if (pkey_type == null) {
            return false;
        }
        if (!HelperGenerator_beforeBase.isValidAutoidPkeyType(pkey_type)) {
            return false;
        }
        if (!pkey.getAutoid()) {
            return false;
        }
        if (pkey.getUseseq() == null) {
            if (isWarnUseseqNull) {
                Object[] o = new Object[]{model.getId(), pkey.getName()};
                this.logger.warn(rman.getValue("value.null.pkeyseq", o));
            }
            return false;
        }
        return true;
    }

    protected ArrayList<PrimaryKey> getAutoidPrimaryKeyList(Model model, PrimaryKey[] pkeys) {
        ArrayList<PrimaryKey> autoid_pkey_list = new ArrayList<PrimaryKey>();
        for (int i = 0; i < pkeys.length; ++i) {
            if (!this.isUseAutoid(model, pkeys[i], true)) continue;
            autoid_pkey_list.add(pkeys[i]);
        }
        return autoid_pkey_list;
    }

    protected String gUpdateSequenceByImportTable0(Model model, PrimaryKey pkey) {
        boolean useStatement;
        StringBuilder sb = new StringBuilder();
        String pkey_type = AppSchemaUtil.getPkeyType(model, pkey.getName(), pkey.getType(), this.project);
        String id = model.getId();
        IModelChoice[] imc = model.getContent();
        if (imc != null) {
            for (int i = 0; i < imc.length; ++i) {
                Modelitem mitem;
                String filter;
                if (!(imc[i] instanceof Modelitem) || (filter = (mitem = (Modelitem)imc[i]).getFilter()) == null || filter.length() <= 0) continue;
                if (!"string".equals(mitem.getType()) && !"zipcode".equals(mitem.getType())) {
                    this.logger.warn(rman.getValue("initdb.illegal.filter", mitem.getName()));
                    continue;
                }
                this.filterSet.add(filter);
            }
        }
        String[] msg_param = new String[]{"dir " + rman.getValue("initloader.param.dir"), "classname " + rman.getValue("initloader.param.classname")};
        sb.append(CommentGenerator.gComment(rman.getValue("initloader.comment.updatesequencebyimporttable0", id), msg_param, null));
        sb.append("    ");
        sb.append("public void updateSequenceByImportTable_");
        sb.append(InitLoaderGenerator.capFirst(model.getId()));
        sb.append("(Directory dir, String classname) {");
        sb.append(CR);
        int seqtype = DbTypeManager.getSequenceStorageType(this.project.getEnvironment(), model);
        String sequencename = pkey.getUseseq();
        sb.append("        ");
        sb.append("final String seqname = \"");
        sb.append(StringUtil.convertJavaString((String)sequencename));
        sb.append("\";");
        sb.append(CR);
        int storagetype = AppSchemaUtil.getStorageType(model.getStorage());
        if (storagetype == 5) {
            sb.append("        ");
            sb.append("final String objclassname = getObjectclassname(dir);");
            sb.append(CR);
            sb.append("        ");
            sb.append("final String primaryKeyItemname = \"");
            sb.append(StringUtil.convertJavaString((String)AppSchemaUtil.getHibernatePropertyName(model, pkey)));
            sb.append("\";");
            sb.append(CR);
            useStatement = seqtype == 1;
        } else {
            String tablenameVariablename = TablenameGenerator.createTableVariableName(model);
            String primaryKeyColumnname = AppSchemaUtil.getProperColumnName(this.project, model, pkey.getName());
            sb.append("        ");
            sb.append("final String tablename = JFCAppTablename.");
            sb.append(tablenameVariablename);
            sb.append(";");
            sb.append(CR);
            sb.append("        ");
            sb.append("final String primaryKeyColumnname = \"");
            sb.append(StringUtil.convertJavaString((String)primaryKeyColumnname));
            sb.append("\";");
            sb.append(CR);
            useStatement = true;
        }
        sb.append(CR);
        sb.append("        ");
        sb.append("Connection conn = null;");
        sb.append(CR);
        if (useStatement) {
            sb.append("        ");
            sb.append("Statement stmt = null;");
            sb.append(CR);
        }
        sb.append("        ");
        sb.append("try {");
        sb.append(CR);
        sb.append("            ");
        sb.append("conn = createConnection();");
        sb.append(CR);
        sb.append("            ");
        sb.append("Number seq_data = getExportedSequenceData(seqname);");
        sb.append(CR);
        if (!"string".equals(pkey_type)) {
            sb.append("            ");
            sb.append("if (seq_data == null) {");
            sb.append(CR);
            sb.append("                ");
            if (storagetype == 5) {
                sb.append("seq_data = jp.jasminesoft.jfc.app.HibernateUtil.getMax(");
                sb.append(CR);
                sb.append("                        ");
                sb.append("objclassname, primaryKeyItemname);");
            } else {
                sb.append("seq_data = getMax(stmt, tablename, primaryKeyColumnname);");
            }
            sb.append(CR);
            sb.append("            ");
            sb.append("}");
            sb.append(CR);
        }
        sb.append(CR);
        String typeClass = "long.class";
        if ("byte".equals(pkey_type)) {
            typeClass = "byte.class";
        } else if ("short".equals(pkey_type)) {
            typeClass = "short.class";
        } else if ("int".equals(pkey_type)) {
            typeClass = "int.class";
        } else if ("long".equals(pkey_type)) {
            typeClass = "long.class";
        } else if ("string".equals(pkey_type)) {
            typeClass = "long.class";
        }
        if (seqtype == 1) {
            sb.append("            ");
            sb.append("Sequence sequenceitem = null;");
            sb.append(CR);
            sb.append("            ");
            sb.append("for (int i = 0; i < sequence.length ; i++) {");
            sb.append(CR);
            sb.append("            ");
            sb.append("    if (sequence[i].getSeqname().equals(seqname)) {");
            sb.append(CR);
            sb.append("            ");
            sb.append("        sequenceitem = sequence[i];");
            sb.append(CR);
            sb.append("            ");
            sb.append("        break;");
            sb.append(CR);
            sb.append("            ");
            sb.append("    }");
            sb.append(CR);
            sb.append("            ");
            sb.append("}");
            sb.append(CR);
            sb.append("            ");
            sb.append("if (sequenceitem == null) {");
            sb.append(CR);
            sb.append("                ");
            sb.append("sequenceitem = new Sequence();");
            sb.append(CR);
            sb.append("            ");
            sb.append("}");
            sb.append(CR);
            sb.append("            ");
            sb.append("if (seq_data == null) {");
            sb.append(CR);
            sb.append("                ");
            sb.append("seq_data = sequenceitem.getStartAsLong();");
            sb.append(CR);
            sb.append("            ");
            sb.append("}");
            sb.append(CR);
            sb.append("            ");
            sb.append("if (seq_data == null) {");
            sb.append(CR);
            sb.append("                ");
            sb.append("return;");
            sb.append(CR);
            sb.append("            ");
            sb.append("}");
            sb.append(CR);
            if (storagetype == 5) {
                sb.append("            ");
                sb.append("stmt = conn.createStatement();");
                sb.append(CR);
            }
            sb.append("            ");
            sb.append("dropSequence(stmt, seqname);");
            sb.append(CR);
            sb.append("            ");
            sb.append("createSequence(stmt, NEXTVALUE(seq_data.longValue(), " + typeClass + "),");
            sb.append(CR);
            sb.append("                    ");
            sb.append("sequenceitem);");
            sb.append(CR);
            sb.append(CR);
            sb.append("            ");
            sb.append("if (conn.getAutoCommit() == false) {");
            sb.append(CR);
            sb.append("                ");
            sb.append("conn.commit();");
            sb.append(CR);
            sb.append("            ");
            sb.append("}");
            sb.append(CR);
        } else if (seqtype == 2) {
            sb.append("            ");
            sb.append("if (seq_data == null) {");
            sb.append(CR);
            sb.append("                ");
            sb.append("return;");
            sb.append(CR);
            sb.append("            ");
            sb.append("}");
            sb.append(CR);
            sb.append("            ");
            sb.append("ActionParameter p = createActionParameter();");
            sb.append(CR);
            sb.append("            ");
            sb.append("CommonService.updateSeq(p, seqname,");
            sb.append(CR);
            sb.append("                    ");
            sb.append("NEXTVALUE(seq_data.longValue(), " + typeClass + "), false);");
            sb.append(CR);
        } else {
            this.logger.error("unknown sequence storage type " + seqtype);
        }
        if (storagetype == 5) {
            sb.append("        ");
            sb.append("} catch (Exception e) {");
            sb.append(CR);
        } else {
            sb.append("        ");
            sb.append("} catch (SQLException e) {");
            sb.append(CR);
        }
        sb.append("        ");
        sb.append("    logger.error(\"Failed to get max primary key\", e);");
        sb.append(CR);
        sb.append("        ");
        sb.append("} finally {");
        sb.append(CR);
        if (useStatement) {
            sb.append("        ");
            sb.append("    if (stmt != null) {");
            sb.append(CR);
            sb.append("        ");
            sb.append("        try {");
            sb.append(CR);
            sb.append("        ");
            sb.append("            stmt.close();");
            sb.append(CR);
            sb.append("        ");
            sb.append("        } catch (SQLException e) {");
            sb.append(CR);
            sb.append("        ");
            sb.append("            logger.error(\"Failed to close statement\", e);");
            sb.append(CR);
            sb.append("        ");
            sb.append("        }");
            sb.append(CR);
            sb.append("        ");
            sb.append("    }");
            sb.append(CR);
        }
        sb.append("            ");
        sb.append("if (conn != null) {");
        sb.append(CR);
        sb.append("                ");
        sb.append("try {");
        sb.append(CR);
        sb.append("                    ");
        sb.append("conn.close();");
        sb.append(CR);
        sb.append("                ");
        sb.append("} catch (SQLException se) {");
        sb.append(CR);
        sb.append("                    ");
        sb.append("logger.debug(\"Failed to close connection\", se);");
        sb.append(CR);
        sb.append("                ");
        sb.append("}");
        sb.append(CR);
        sb.append("            ");
        sb.append("}");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected String gIsAutoSequenceData() {
        StringBuilder sb = new StringBuilder();
        IProjectChoice[] ipc = this.project.getContent();
        if (ipc == null) {
            return sb.toString();
        }
        StringBuilder sb0 = new StringBuilder();
        for (int i = 0; i < ipc.length; ++i) {
            String storage;
            int storagetype;
            Model model;
            String type;
            if (!(ipc[i] instanceof Model) || (type = (model = (Model)ipc[i]).getType()) == null || !"store".equals(type) || !AppSchemaUtil.isGenerateInitLoader(model) || (storagetype = AppSchemaUtil.getStorageType(storage = model.getStorage())) == 3 || storagetype != 0 && storagetype != 5) continue;
            sb0.append(this.gIsAutoSequenceData0(model));
        }
        sb.append(sb0.toString());
        sb.append(CR);
        return sb.toString();
    }

    protected String gIsAutoSequenceData0(Model model) {
        PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(model, this.project);
        if (pkeys == null) {
            return "";
        }
        ArrayList<PrimaryKey> autoid_pkey_list = this.getAutoidPrimaryKeyList(model, pkeys);
        if (autoid_pkey_list.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String id = model.getId();
        String classname = AppSchemaUtil.getClassname(model);
        IModelChoice[] imc = model.getContent();
        if (imc != null) {
            for (int i = 0; i < imc.length; ++i) {
                Modelitem mitem;
                String filter;
                if (!(imc[i] instanceof Modelitem) || (filter = (mitem = (Modelitem)imc[i]).getFilter()) == null || filter.length() <= 0) continue;
                if (!"string".equals(mitem.getType()) && !"zipcode".equals(mitem.getType())) {
                    this.logger.warn(rman.getValue("initdb.illegal.filter", mitem.getName()));
                    continue;
                }
                this.filterSet.add(filter);
            }
        }
        String[] msg_param = new String[]{"dir " + rman.getValue("initloader.param.dir"), "classname " + rman.getValue("initloader.param.classname"), "f " + rman.getValue("initloader.param.file")};
        sb.append(CommentGenerator.gComment(rman.getValue("initloader.comment.isautosequencedata0", id), msg_param, "boolean"));
        sb.append("    ");
        sb.append("public boolean isAutoSequenceData_");
        sb.append(InitLoaderGenerator.capFirst(model.getId()));
        sb.append("(Directory dir, String classname, File f) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("Document doc = getDocument(dir, f);");
        sb.append(CR);
        sb.append(CR);
        sb.append("        ");
        sb.append("try {");
        sb.append(CR);
        String variablename = StringUtil.convertJavaVariableString((String)id);
        sb.append("            ");
        sb.append(classname);
        sb.append(" ");
        sb.append(variablename);
        sb.append(";");
        sb.append(CR);
        sb.append("            ");
        sb.append("if (doc != null)");
        sb.append(CR);
        sb.append("                ");
        sb.append(variablename);
        sb.append(" = JaxbUtil.unmarshal(doc, ").append(classname).append(".class);");
        sb.append(CR);
        sb.append("            ");
        sb.append("else");
        sb.append(CR);
        sb.append("                ");
        sb.append(variablename);
        sb.append(" = JaxbUtil.unmarshal(f, ").append(classname).append(".class);");
        sb.append(CR);
        sb.append(CR);
        sb.append("            ");
        sb.append("if (");
        this.gCheckAutoidPrimaryKey(model, sb, variablename, autoid_pkey_list);
        sb.append(") {");
        sb.append(CR);
        sb.append("                ");
        sb.append("return true;");
        sb.append(CR);
        sb.append("            ");
        sb.append("}");
        sb.append(CR);
        sb.append("        ");
        sb.append("} catch (Exception e) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("logger.warn(\"");
        sb.append(rman.getValue("initloader.comment.failmakedoc"));
        sb.append("\"+f);");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append("        ");
        sb.append("return false;");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected String gBeforeImport() {
        StringBuilder sb = new StringBuilder();
        IProjectChoice[] ipc = this.project.getContent();
        if (ipc == null) {
            return sb.toString();
        }
        StringBuilder sb0 = new StringBuilder();
        for (int i = 0; i < ipc.length; ++i) {
            String storage;
            int storagetype;
            Model model;
            String type;
            if (!(ipc[i] instanceof Model) || !this.isValidType(type = (model = (Model)ipc[i]).getType()) || !AppSchemaUtil.isGenerateInitLoader(model) || (storagetype = AppSchemaUtil.getStorageType(storage = model.getStorage())) == 3 || storagetype != 0 && storagetype != 5) continue;
            sb0.append(this.gBeforeImport0(model));
        }
        sb.append(sb0.toString());
        sb.append(CR);
        return sb.toString();
    }

    protected String gBeforeImport0(Model model) {
        StringBuilder sb = new StringBuilder();
        String id = model.getId();
        String classname = AppSchemaUtil.getClassname(model);
        int fcount = 0;
        IModelChoice[] imc = model.getContent();
        if (imc != null) {
            for (int i = 0; i < imc.length; ++i) {
                Modelitem mitem;
                String filter;
                if (!(imc[i] instanceof Modelitem) || (filter = (mitem = (Modelitem)imc[i]).getFilter()) == null || filter.length() <= 0) continue;
                if (!"string".equals(mitem.getType()) && !"zipcode".equals(mitem.getType())) {
                    this.logger.warn(rman.getValue("initdb.illegal.filter", mitem.getName()));
                    continue;
                }
                ++fcount;
                this.filterSet.add(filter);
            }
        }
        String[] msg_param = new String[]{"dir " + rman.getValue("initloader.param.dir"), "classname " + rman.getValue("initloader.param.classname"), "f " + rman.getValue("initloader.param.file")};
        sb.append(CommentGenerator.gComment(rman.getValue("initloader.comment.beforeimport0", id), msg_param, "Object"));
        sb.append("    ");
        sb.append("public Object beforeImport_");
        sb.append(InitLoaderGenerator.capFirst(model.getId()));
        sb.append("(Directory dir, String classname, File f) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("Document doc = getDocument(dir, f);");
        sb.append(CR);
        String variablename = StringUtil.convertJavaVariableString((String)id);
        PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(model, this.project);
        if (pkeys != null) {
            ArrayList<PrimaryKey> autoid_pkey_list = this.getAutoidPrimaryKeyList(model, pkeys);
            if (autoid_pkey_list.size() > 0) {
                sb.append("        ");
                sb.append("try {");
                sb.append(CR);
                sb.append("            ");
                sb.append(classname);
                sb.append(" ");
                sb.append(variablename);
                sb.append(";");
                sb.append(CR);
                sb.append("            ");
                sb.append("if (doc != null)");
                sb.append(CR);
                sb.append("                ");
                sb.append(variablename);
                sb.append(" = JaxbUtil.unmarshal(doc, ").append(classname).append(".class);");
                sb.append(CR);
                sb.append("            ");
                sb.append("else");
                sb.append(CR);
                sb.append("                ");
                sb.append(variablename);
                sb.append(" = JaxbUtil.unmarshal(f, ").append(classname).append(".class);");
                sb.append(CR);
                sb.append("            ");
                sb.append("if (");
                this.gCheckAutoidPrimaryKey(model, sb, variablename, autoid_pkey_list);
                sb.append(") {");
                sb.append(CR);
                sb.append("                ");
                sb.append("ActionParameter p = ");
                sb.append("createActionParameter();");
                sb.append(CR);
                sb.append("                ");
                sb.append(AppSchemaUtil.getHelperClassname4Dicon(model, this.project));
                sb.append(".beforeImport(");
                sb.append(variablename);
                sb.append(", p);");
                sb.append(CR);
                sb.append("            ");
                sb.append("}");
                sb.append(CR);
                if (fcount > 0) {
                    HelperGenerator_filter_init hgt = new HelperGenerator_filter_init(this.project, model);
                    sb.append(hgt.process("    "));
                }
                sb.append("            ");
                sb.append("return ");
                sb.append(variablename);
                sb.append(";");
                sb.append(CR);
                sb.append("        ");
                sb.append("} catch (Exception e) {");
                sb.append(CR);
                sb.append("            ");
                sb.append("logger.warn(\"");
                sb.append(rman.getValue("initloader.comment.failmakedoc"));
                sb.append("\"+f);");
                sb.append(CR);
                sb.append("        ");
                sb.append("} finally {");
                sb.append(CR);
                sb.append("        ");
                sb.append("}");
                sb.append(CR);
            }
        } else if (fcount > 0) {
            sb.append("        ");
            sb.append(classname);
            sb.append(" ");
            sb.append(variablename);
            sb.append(";");
            sb.append(CR);
            sb.append("        ");
            sb.append("if (doc != null)");
            sb.append(CR);
            sb.append("            ");
            sb.append(variablename);
            sb.append(" = JaxbUtil.unmarshal(doc, ").append(classname).append(".class);");
            sb.append(CR);
            sb.append("        ");
            sb.append("else");
            sb.append(CR);
            sb.append("            ");
            sb.append(variablename);
            sb.append(" = JaxbUtil.unmarshal(f, ").append(classname).append(".class);");
            sb.append(CR);
            HelperGenerator_filter_init hgt = new HelperGenerator_filter_init(this.project, model);
            sb.append(hgt.process());
            sb.append("        ");
            sb.append("return ");
            sb.append(variablename);
            sb.append(";");
            sb.append(CR);
        }
        sb.append("        ");
        sb.append("if (doc != null) return doc;");
        sb.append(CR);
        sb.append("        ");
        sb.append("return f;");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected void gCheckAutoidPrimaryKey(Model model, StringBuilder sb, String variablename, ArrayList<PrimaryKey> autoid_pkey_list) {
        Iterator<PrimaryKey> autoid_pkey_it = autoid_pkey_list.iterator();
        while (autoid_pkey_it.hasNext()) {
            PrimaryKey autoid_pkey = autoid_pkey_it.next();
            String pkey_type = AppSchemaUtil.getPkeyType(model, autoid_pkey.getName(), autoid_pkey.getType(), this.project);
            if (pkey_type.equals("string")) {
                sb.append("org.apache.commons.lang3.math.NumberUtils.toLong(");
            }
            sb.append(variablename);
            sb.append(JavaSourceGenerator.getterFullMethod(AppSchemaUtil.createFullPrimaryKeyName(autoid_pkey)));
            if (pkey_type.equals("string")) {
                sb.append(")");
            }
            sb.append(" < 0");
            if (!autoid_pkey_it.hasNext()) continue;
            sb.append(" || ");
        }
    }

    protected String gCreateActionParameter() {
        StringBuilder sb = new StringBuilder();
        sb.append(CommentGenerator.gComment(rman.getValue("initloader.comment.actionparameter"), null, "ActionParameter"));
        sb.append("    ");
        sb.append("@Override").append(CR);
        sb.append("    ");
        sb.append("public ActionParameter createActionParameter() {").append(CR);
        sb.append("        ");
        sb.append("return ");
        sb.append("ActionParameter.createActionParameter(");
        sb.append("logger, \"initdb\", appctx);");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected String gExportSequenceByExportTable() {
        StringBuilder sb = new StringBuilder();
        IProjectChoice[] ipc = this.project.getContent();
        if (ipc == null) {
            return sb.toString();
        }
        String[] msg_param = new String[]{"dir " + rman.getValue("initloader.param.dir"), "classname " + rman.getValue("initloader.param.classname")};
        sb.append(CommentGenerator.gComment(rman.getValue("initloader.comment.updatesequencebyimporttable"), msg_param, null));
        sb.append("    ");
        sb.append("public void exportSequenceByExportTable(Directory dir, String classname) throws Exception {");
        sb.append(CR);
        sb.append("        ");
        sb.append("String tablename = dir.getTablename();");
        sb.append(CR);
        sb.append("        ");
        sb.append("if (tablename == null)");
        sb.append(CR);
        sb.append("            ");
        sb.append("return;");
        sb.append(CR);
        sb.append(CR);
        int count = 0;
        sb.append("        ");
        for (int i = 0; i < ipc.length; ++i) {
            String storage;
            int storagetype;
            PrimaryKey[] pkeys;
            if (!(ipc[i] instanceof Model)) continue;
            Model model = (Model)ipc[i];
            String type = model.getType();
            int seqtype = DbTypeManager.getSequenceStorageType(this.project.getEnvironment(), model);
            if (seqtype != 1) continue;
            String tablename0 = TablenameGenerator.createTableVariableName(model);
            if (type == null || !"store".equals(type) || !AppSchemaUtil.isGenerateInitLoader(model) || (pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(model, this.project)) == null) continue;
            PrimaryKey pkeyitem = null;
            for (int j = 0; j < pkeys.length; ++j) {
                String pkey_type = AppSchemaUtil.getPkeyType(model, pkeys[j].getName(), pkeys[j].getType(), this.project);
                if (pkey_type == null || !pkeys[j].getAutoid() || pkeys[j].getUseseq() == null || !InitLoaderGenerator.isBasicType(pkey_type) && !"string".equals(pkey_type)) continue;
                pkeyitem = pkeys[j];
                break;
            }
            if (pkeyitem == null || (storagetype = AppSchemaUtil.getStorageType(storage = model.getStorage())) == 3 || storagetype != 0 && storagetype != 5) continue;
            sb.append("if (JFCAppTablename.");
            sb.append(tablename0);
            sb.append(".equals(tablename)) {");
            sb.append(CR);
            sb.append("            ");
            sb.append("exportSequenceByExportTable");
            sb.append("(dir, classname, \"");
            sb.append(StringUtil.convertJavaString((String)pkeyitem.getUseseq()));
            sb.append("\");");
            sb.append(CR);
            sb.append("        ");
            sb.append("} else ");
            ++count;
        }
        if (count == 0) {
            return "";
        }
        sb.append(" {");
        sb.append(CR);
        sb.append("            ");
        sb.append("return;");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected String gDoExecute() {
        StringBuilder sb = new StringBuilder();
        String[] msg_param = new String[]{"args " + rman.getValue("initloader.comment.main.param")};
        sb.append(CommentGenerator.gComment(rman.getValue("initloader.comment.do_execute"), msg_param, null));
        sb.append("    ");
        sb.append("public static void do_execute(String[] args) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("do_execute(args, null);");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        msg_param = new String[]{"args " + rman.getValue("initloader.comment.main.param"), "listener XMLLoaderActionListener"};
        sb.append(CommentGenerator.gComment(rman.getValue("initloader.comment.do_execute"), msg_param, null));
        sb.append("    ");
        sb.append("public static void do_execute(String[] args, XMLLoaderActionListener listener) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("do_execute(args, listener, null);");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        msg_param = new String[]{"args " + rman.getValue("initloader.comment.main.param"), "listener XMLLoaderActionListener", "appctx ApplicationContext"};
        sb.append(CommentGenerator.gComment(rman.getValue("initloader.comment.do_execute"), msg_param, null));
        sb.append("    ");
        sb.append("public static void do_execute(String[] args, XMLLoaderActionListener listener, ApplicationContext appctx) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("InitLoader loader = new InitLoader();");
        sb.append(CR);
        sb.append("        ");
        sb.append("if (listener != null) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("loader.addXMLLoaderActionListener(listener);");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append("        ");
        sb.append("loader.appctx = appctx;");
        sb.append(CR);
        sb.append("        ");
        sb.append("execute(args, loader, null, ExecuteEnvironmentType.webapp);");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected String gVersion() {
        if (this.jfc_version == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("public String getVersion() {");
        sb.append(CR);
        sb.append("        ");
        sb.append("return \"" + this.jfc_version + "\";");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected String gMain() {
        StringBuilder sb = new StringBuilder();
        String[] msg_param = new String[]{"args " + rman.getValue("initloader.comment.main.param")};
        sb.append(CommentGenerator.gComment(rman.getValue("initloader.comment.main"), msg_param, null));
        sb.append("    ");
        sb.append("public static void main(String[] args) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("InitLoader loader = new InitLoader();");
        sb.append(CR);
        Environment env = this.project.getEnvironment();
        if (DbTypeManager.isHSQLDB(env)) {
            sb.append("        ");
            sb.append("loader.addXMLLoaderActionListener(new HsqldbXMLLoaderActionListener());");
            sb.append(CR);
        }
        sb.append("        ");
        sb.append("loader.addXMLLoaderActionListener(new InitJholidayActionListener());");
        sb.append(CR);
        sb.append("        ");
        sb.append("execute(args, loader, null, ExecuteEnvironmentType.commandline);");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        return sb.toString();
    }

    protected String gSuccessImport() {
        IProjectChoice[] ipc = this.project.getContent();
        if (ipc == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ipc.length; ++i) {
            Model model;
            if (!(ipc[i] instanceof Model) || !"jfcportlet".equals((model = (Model)ipc[i]).getId()) || !model.getCreatetable()) continue;
            sb.append(this.gSuccessImport_jfcportlet());
        }
        sb.append(CR);
        return sb.toString();
    }

    protected String gSuccessImport_jfcportlet() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.createVariableBaseMap(map);
        return VelocityUtils.mergeContent((String)"template/javasrc/initdb/successImport_jfcportlet.vm", map);
    }

    public String getJfcVersion() {
        return this.jfc_version;
    }

    public void setJfcVersion(String jfc_version) {
        this.jfc_version = jfc_version;
    }
}

