/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.DbTypeManager;
import jp.jasminesoft.jfc.gen.ISourceVariable;
import jp.jasminesoft.jfc.gen.SourceWriter;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.Inititem;
import jp.jasminesoft.jfc.gen.appschema.Inititem2;
import jp.jasminesoft.jfc.gen.appschema.Jfcdomain;
import jp.jasminesoft.jfc.gen.appschema.Jfcdomains;
import jp.jasminesoft.jfc.gen.appschema.Jfcmodel;
import jp.jasminesoft.jfc.gen.appschema.Jfcmodels;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.ResourceManagerFactory;
import jp.jasminesoft.util.StringCRLFFilter;
import jp.jasminesoft.util.StringConvAlphabetZ2HFilter;
import jp.jasminesoft.util.StringConvKanaH2ZFilter;
import jp.jasminesoft.util.StringConvKigouZ2HFilter;
import jp.jasminesoft.util.StringConvNumZ2HFilter;
import jp.jasminesoft.util.StringDecodeXMLCharFilter;
import jp.jasminesoft.util.StringFilter;
import jp.jasminesoft.util.StringNormalizeZenkakuMinusFilter;
import jp.jasminesoft.util.StringRemoveSpaceFilter;
import jp.jasminesoft.util.WebStringEncodeUtilities;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class InititemGenerator
implements ISourceVariable {
    protected Project project;
    protected ResourceManager rman;
    protected Logger logger = null;
    private static Map<String, StringFilter> filterMap = new HashMap<String, StringFilter>();
    private static final StringFilter commonfilter = new StringNormalizeZenkakuMinusFilter((StringFilter)new StringConvKanaH2ZFilter((StringFilter)new StringConvKigouZ2HFilter((StringFilter)new StringConvNumZ2HFilter((StringFilter)new StringConvAlphabetZ2HFilter((StringFilter)new StringCRLFFilter((StringFilter)new StringRemoveSpaceFilter((StringFilter)new StringDecodeXMLCharFilter(), "prepost")))))));
    private static final StringFilter minimalfilter = new StringCRLFFilter((StringFilter)new StringDecodeXMLCharFilter());

    public InititemGenerator(Project project) {
        this.project = project;
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
        this.logger = LogManager.getLogger((String)this.getClass().getName());
    }

    public void process() {
        IProjectChoice[] ipc = this.project.getContent();
        if (ipc == null) {
            return;
        }
        HashMap<String, Integer> seqMap = new HashMap<String, Integer>();
        HashMap initMap = new HashMap();
        HashMap initMap2 = new HashMap();
        HashMap<String, File> initialdataSaveDirMap = new HashMap<String, File>();
        for (int i = 0; i < ipc.length; ++i) {
            String storage;
            int storagetype;
            IModelChoice[] imc;
            if (!(ipc[i] instanceof Model)) continue;
            Model model = (Model)ipc[i];
            if ("store".equals(model.getType())) {
                int seqtype;
                String savedir = model.getInitialDataSaveDir();
                if (savedir != null) {
                    this.logger.debug("model " + model.getId() + " dir:" + savedir);
                    initialdataSaveDirMap.put(model.getId(), new File(savedir));
                    Model pmodel = AppSchemaUtil.getModel(this.project, model.getId(), "presentation");
                    Modelitem pmitem = AppSchemaUtil.getModelitem("content", pmodel);
                    if (pmitem != null) {
                        if ("commonfilter".equals(pmitem.getFilter())) {
                            filterMap.put(model.getId(), commonfilter);
                        } else {
                            filterMap.put(model.getId(), minimalfilter);
                        }
                    }
                }
                if ((seqtype = DbTypeManager.getSequenceStorageType(this.project.getEnvironment(), model)) == 2) {
                    this.putSeqMap(seqMap, model);
                }
                if ((imc = model.getContent()) == null) continue;
                this.putInititem(initMap2, model, imc, Inititem2.class);
                continue;
            }
            if (!"master".equals(model.getType()) || (storagetype = AppSchemaUtil.getStorageType(storage = model.getStorage())) == 3 || (imc = model.getContent()) == null) continue;
            this.putInititem(initMap, model, imc, Inititem.class);
        }
        this.output_seq(seqMap);
        this.output_data(initMap);
        this.output_data(initMap2);
        this.output_domains();
        Jfcmodels jfcmodels = this.project.getJfcmodels();
        this.output_models(jfcmodels);
        this.output_models4dataMaintenance(jfcmodels);
        this.output_initialdata(initialdataSaveDirMap);
    }

    private void putSeqMap(Map<String, Integer> seqMap, Model model) {
        PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(model, this.project);
        if (pkeys != null) {
            for (int j = 0; j < pkeys.length; ++j) {
                int start = pkeys[j].getStart();
                String name = pkeys[j].getUseseq();
                if (name == null || start < 1) continue;
                seqMap.put(pkeys[j].getUseseq(), start);
            }
        }
    }

    private <T extends IModelChoice> void putInititem(Map<String, Set<T>> initMap, Model model, IModelChoice[] imc, Class<T> class1) {
        String id = model.getId();
        Set<T> set = initMap.get(id);
        if (set == null) {
            set = new LinkedHashSet<T>();
            initMap.put(id, set);
        }
        for (int j = 0; j < imc.length; ++j) {
            if (!class1.isInstance(imc[j])) continue;
            IModelChoice value = imc[j];
            set.add(value);
        }
    }

    private void output_models(Jfcmodels jfcmodels) {
        String basedir = this.project.getBasedir();
        String enc = "UTF-8";
        StringBuilder header = new StringBuilder();
        header.append("<?xml version=\"1.0\" encoding=\"");
        header.append(enc);
        header.append("\"?>");
        for (Jfcmodel jfcmodel : jfcmodels.getJfcmodel()) {
            try {
                SourceWriter.write(basedir, "init", "jfcmodel", jfcmodel.getNameEn(), ".xml", header + jfcmodel.toString(), enc);
            }
            catch (Exception e) {
                this.logger.error((Object)e);
            }
        }
    }

    private void output_models4dataMaintenance(Jfcmodels jfcmodels) {
        String basedir = this.project.getBasedir();
        String enc = "UTF-8";
        for (Jfcmodel jfcmodel : jfcmodels.getJfcmodel()) {
            if (JFCUtils.isSystemModel((String)jfcmodel.getNameEn())) continue;
            StringBuilder sb = new StringBuilder();
            sb.append("<?xml version=\"1.0\" encoding=\"");
            sb.append(enc);
            sb.append("\"?>");
            sb.append(CR);
            sb.append("<jfcmodel4dm>");
            sb.append(CR);
            sb.append("  ");
            sb.append("<name_en>");
            sb.append(WebStringEncodeUtilities.replaceCharEntity((String)jfcmodel.getNameEn()));
            sb.append("</name_en>");
            sb.append(CR);
            sb.append("  ");
            sb.append("<name_jp>");
            sb.append(WebStringEncodeUtilities.replaceCharEntity((String)jfcmodel.getNameJp()));
            sb.append("</name_jp>");
            sb.append(CR);
            sb.append("</jfcmodel4dm>");
            sb.append(CR);
            try {
                SourceWriter.write(basedir, "init", "jfcmodel4dm", jfcmodel.getNameEn(), ".xml", sb.toString(), enc);
            }
            catch (Exception e) {
                this.logger.error((Object)e);
            }
        }
    }

    private void output_seq(Map<String, Integer> seqMap) {
        if (seqMap == null || seqMap.size() == 0) {
            return;
        }
        String basedir = this.project.getBasedir();
        String enc = "UTF-8";
        for (String name : seqMap.keySet()) {
            Integer num = seqMap.get(name);
            StringBuilder sb = new StringBuilder();
            sb.append("<?xml version=\"1.0\" encoding=\"");
            sb.append(enc);
            sb.append("\"?>");
            sb.append(CR);
            sb.append("<seq>");
            sb.append(CR);
            sb.append("  ");
            sb.append("<name>");
            sb.append(WebStringEncodeUtilities.replaceCharEntity((String)name));
            sb.append("</name>");
            sb.append(CR);
            sb.append("  ");
            sb.append("<number>");
            sb.append(num);
            sb.append("</number>");
            sb.append(CR);
            sb.append("</seq>");
            sb.append(CR);
            try {
                SourceWriter.write(basedir, "init", "seq", name, ".xml", sb.toString(), enc);
            }
            catch (Exception e) {
                this.logger.error((Object)e);
            }
        }
    }

    private <T extends IModelChoice> void output_data(Map<String, Set<T>> initMap) {
        if (initMap == null || initMap.size() == 0) {
            return;
        }
        String basedir = this.project.getBasedir();
        String enc = "UTF-8";
        for (String id : initMap.keySet()) {
            Set<T> set = initMap.get(id);
            for (IModelChoice item : set) {
                String content;
                Object filename;
                if (item instanceof Inititem) {
                    filename = "item_" + ((Inititem)item).getId();
                    content = item.toString();
                } else {
                    if (!(item instanceof Inititem2)) continue;
                    filename = ((Inititem2)item).getFilename();
                    content = ((Inititem2)item).getContent();
                }
                StringBuilder sb = new StringBuilder();
                sb.append("<?xml version=\"1.0\" encoding=\"");
                sb.append(enc);
                sb.append("\"?>");
                sb.append(CR);
                sb.append(content);
                sb.append(CR);
                try {
                    SourceWriter.write(basedir, "init", id, (String)filename, ".xml", sb.toString(), enc);
                }
                catch (Exception e) {
                    this.logger.error((Object)e);
                }
            }
        }
    }

    private void output_domains() {
        Jfcdomains jfcdomains = this.project.getJfcdomains();
        if (jfcdomains == null) {
            return;
        }
        String basedir = this.project.getBasedir();
        String enc = "UTF-8";
        for (Jfcdomain jfcdomain : jfcdomains.getJfcdomain()) {
            StringBuilder sb = new StringBuilder();
            sb.append("<?xml version=\"1.0\" encoding=\"");
            sb.append(enc);
            sb.append("\"?>");
            sb.append(CR);
            sb.append(jfcdomain.toString());
            sb.append(CR);
            try {
                SourceWriter.write(basedir, "init", "jfcdomain", String.valueOf(jfcdomain.getId()), ".xml", sb.toString(), enc);
            }
            catch (Exception e) {
                this.logger.error((Object)e);
            }
        }
    }

    private void output_initialdata(Map<String, File> initialdataSaveDirMap) {
        Transformer trans;
        DocumentBuilder builder;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            this.logger.error("Failed output initialdata", (Throwable)e);
            return;
        }
        try {
            trans = TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException e) {
            this.logger.error("Failed output initialdata", (Throwable)e);
            return;
        }
        catch (TransformerFactoryConfigurationError e) {
            this.logger.error("Failed output initialdata", (Throwable)e);
            return;
        }
        String basedir = this.project.getBasedir();
        for (Map.Entry<String, File> e : initialdataSaveDirMap.entrySet()) {
            File src = e.getValue();
            File srcFile = null;
            try {
                if (!src.isDirectory()) continue;
                for (Object obj : FileUtils.listFiles((File)src, null, (boolean)true)) {
                    if (!(obj instanceof File)) continue;
                    srcFile = (File)obj;
                    SourceWriter.write(basedir, "init/" + e.getKey() + "/" + srcFile.getName(), this.readInitialdata(e.getKey(), srcFile, builder, trans), "UTF-8");
                }
            }
            catch (IOException e1) {
                this.logger.error("Failed output initialdata file " + srcFile, (Throwable)e1);
            }
        }
    }

    private String readInitialdata(String id, File srcFile, DocumentBuilder builder, Transformer trans) throws IOException {
        try {
            Document doc = builder.parse(srcFile);
            this.filterText(id, doc);
            StringWriter writer = new StringWriter();
            trans.transform(new DOMSource(doc), new StreamResult(writer));
            return writer.toString();
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        catch (TransformerException e) {
            throw new IOException(e);
        }
    }

    private void filterText(String id, Node node) {
        if (node.getNodeType() == 3) {
            node.setNodeValue(InititemGenerator.filterContent(id, node.getNodeValue()));
            return;
        }
        if (node.hasChildNodes()) {
            Node child = node.getFirstChild();
            do {
                this.filterText(id, child);
            } while ((child = child.getNextSibling()) != null);
        }
    }

    private static String filterContent(String id, String s) {
        StringFilter sfilter = filterMap.get(id);
        if (sfilter == null) {
            sfilter = commonfilter;
        }
        return sfilter.filter(s);
    }
}

