/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.ISourceVariable;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.JspBodyGeneratorDisplayitem_update;
import jp.jasminesoft.jfc.gen.JspPanelContentBase;
import jp.jasminesoft.jfc.gen.JspPanelContent_displaycondition;
import jp.jasminesoft.jfc.gen.PresentationSourceGenerator;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.TabBuffer;
import jp.jasminesoft.jfc.gen.TipsManager;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Autocalc;
import jp.jasminesoft.jfc.gen.appschema.Condition;
import jp.jasminesoft.jfc.gen.appschema.Conditionlist;
import jp.jasminesoft.jfc.gen.appschema.Constraint;
import jp.jasminesoft.jfc.gen.appschema.Dataitem;
import jp.jasminesoft.jfc.gen.appschema.Directcopy;
import jp.jasminesoft.jfc.gen.appschema.Displaychart;
import jp.jasminesoft.jfc.gen.appschema.Displaycondition;
import jp.jasminesoft.jfc.gen.appschema.Displayitem;
import jp.jasminesoft.jfc.gen.appschema.Displayitemgroup;
import jp.jasminesoft.jfc.gen.appschema.Displaymodel;
import jp.jasminesoft.jfc.gen.appschema.Displaymodelgroup;
import jp.jasminesoft.jfc.gen.appschema.Environment;
import jp.jasminesoft.jfc.gen.appschema.ForeignKey;
import jp.jasminesoft.jfc.gen.appschema.IDisplayitemgroupChoice;
import jp.jasminesoft.jfc.gen.appschema.IDisplaymodelChoice;
import jp.jasminesoft.jfc.gen.appschema.IDisplaymodelgroupChoice;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IPanelChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Item;
import jp.jasminesoft.jfc.gen.appschema.Layout;
import jp.jasminesoft.jfc.gen.appschema.Link;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Page;
import jp.jasminesoft.jfc.gen.appschema.Panel;
import jp.jasminesoft.jfc.gen.appschema.Panelgroup;
import jp.jasminesoft.jfc.gen.appschema.Presentation;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.jfc.gen.appschema.Restrictparam;
import jp.jasminesoft.jfc.gen.appschema.Restrictparamlist;
import jp.jasminesoft.jfc.gen.appschema.Searchparam;
import jp.jasminesoft.jfc.gen.appschema.Sort;
import jp.jasminesoft.jfc.gen.appschema.Sortkey;
import jp.jasminesoft.jfc.gen.appschema.Uifunction;
import jp.jasminesoft.jfc.gen.appschema.Updatelist;
import jp.jasminesoft.jfc.gen.appschema.View;
import jp.jasminesoft.jfc.gen.ui.th.ThBodyGenerator;
import jp.jasminesoft.jfc.gen.ui.th.ThBodyGeneratorDisplayitem_update;
import jp.jasminesoft.util.FileTemplateManager;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.ResourceManagerFactory;
import jp.jasminesoft.util.StringUtil;
import jp.jasminesoft.util.WebStringEncodeUtilities;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JavaScriptManager
extends PresentationSourceGenerator {
    public static final String METHOD_DO_SUBMIT = "doSubmit";
    public static final String TemplatefilenameBase = "template" + File.separator + "html" + File.separator;
    private static final String TemplatefileCharEncoding = "UTF-8";
    protected static final String CONTAINER_LOOP_INDEX = "\" + i + \"";
    protected static final String CONTAINER_CHECKBOX_LOOP_INDEX = "\\${__position.count}";
    protected static final String TH_CONTAINER_LOOP_INDEX = "${iterStat.count}";
    protected static final String TH_CONTAINER_CHECKBOX_LOOP_INDEX = "\\${iterStat.count}";
    protected String id;
    protected String filename;
    protected Model smodel;
    protected Model pmodel;
    protected Model cmodel;
    protected Model cpmodel;
    protected static Logger logger = LogManager.getLogger((String)JavaScriptManager.class.getName());
    protected static ResourceManager rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
    protected String actiontype;
    protected Set<String> methodSet;
    protected Map<String, Modelitem> nullCheckMap;
    protected Map<String, Modelitem> cancelConstraintMap;
    protected TipsManager tipsman;
    protected Map<String, String> functionCodeMap;
    protected Map<String, ChangeSelectMethod> changeSelectMethodMap;
    protected Map<String, DisableCtrlManager> dcmMap;
    protected Map<String, TabManager> tabManagerMap;
    protected Set<String> notsameInputValueModelitemSet = new HashSet<String>();
    protected Map<String, String> doClearMethodMap;
    protected Map<String, SortedMap<InputCodeConfig, String>> inputCodeMap = new HashMap<String, SortedMap<InputCodeConfig, String>>();
    protected TreeSet<String> fixTableHeaderRowColumnModels;
    protected List<Displaymodel> showListGridDisplaymodels = new ArrayList<Displaymodel>();
    protected List<Displaymodel> showListSpreadsheetDisplaymodels = new ArrayList<Displaymodel>();
    protected List<Modelitem> checkboxSearchItems;
    protected List<Displayitem> textareaWithRemainingChars;
    protected boolean isMobileRefSearchDefined = false;
    protected boolean isJgroupnodeOrgChartDefined = false;
    protected List<Displaychart> displaycharts;
    protected List<IPanelChoice> displaymodelsContainingSeparatePhonenumberItem;
    protected List<Displaymodel> displaymodelsContainingfuriganaItem;
    protected Map<Displayitem, List<Uifunction>> uifunctions;
    protected Map<String, String> inputCheckRegexp = null;
    protected boolean isAutofillFuriganaDefined = false;
    public boolean isCreateRelationValuesFunc = false;
    protected boolean isCssLayoutMultipleLayoutDefined = false;
    protected Map<String, String> treeWidgetItemSettings = null;
    private Map<String, List<String>> directCopySettings = null;
    public static final String jsFunctionName_OpenSearchWindow = "openSearchWindow";
    public static final String jsFunctionName_GetSearchListTarget = "getSearchListTarget";

    protected JavaScriptManager(Project project, Presentation presentation, String id, String filename) {
        super(project, null, presentation);
        this.id = id;
        this.filename = filename;
        this.init();
    }

    protected void init() {
        this.methodSet = new HashSet<String>();
        this.nullCheckMap = new TreeMap<String, Modelitem>();
        this.cancelConstraintMap = new TreeMap<String, Modelitem>();
        this.tipsman = TipsManager.getInstance();
        this.functionCodeMap = new TreeMap<String, String>();
        this.changeSelectMethodMap = new TreeMap<String, ChangeSelectMethod>();
        this.doClearMethodMap = new TreeMap<String, String>();
        this.dcmMap = new TreeMap<String, DisableCtrlManager>();
        this.tabManagerMap = new TreeMap<String, TabManager>();
        this.fixTableHeaderRowColumnModels = new TreeSet();
        this.action = AppSchemaUtil.getAction(this.project, this.id);
        if (this.action == null) {
            return;
        }
        this.actiontype = this.action.getType();
        String idref = this.action.getIdref();
        this.smodel = AppSchemaUtil.getModel(this.project, idref);
        this.pmodel = AppSchemaUtil.getModel(this.project, idref, "presentation");
        if ("showList".equals(this.actiontype) || "download".equals(this.actiontype)) {
            this.cmodel = AppSchemaUtil.getConditionModel(this.project, this.action);
            this.cpmodel = AppSchemaUtil.getConditionPModel(this.project, this.action);
        } else {
            this.cmodel = this.smodel;
            this.cpmodel = this.pmodel;
        }
        if (this.pmodel == null) {
            return;
        }
    }

    @Override
    public String getEncoding() {
        return JavaSourceGenerator.getWebEncoding(this.project);
    }

    public void setAvailableMethod(String methodName) {
        this.methodSet.add(methodName);
    }

    public int getAvailableMethodSize() {
        return this.methodSet.size();
    }

    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getFileSuffix() {
        return ".js";
    }

    @Override
    public void process() {
        String modelid;
        String content = this.process0();
        String filename = this.getFilename();
        String string = modelid = this.smodel != null ? this.smodel.getId() : null;
        if (modelid == null) {
            modelid = "system";
        }
        filename = this.addModelidToFilename(modelid, filename);
        if (StringUtils.isEmpty((CharSequence)(content = this.balanceGeneratedCode(content)))) {
            return;
        }
        this.createSource(this.getGeneratorClassName() + content, filename, this.getPackageName(), false);
    }

    private String balanceGeneratedCode(String content) {
        StringBuilder vardef = new StringBuilder();
        StringBuilder rest = new StringBuilder();
        String[] lines = content.split(CR);
        if (lines == null || lines.length == 0) {
            return content;
        }
        for (String s : lines) {
            if (s.startsWith("var ")) {
                vardef.append(s);
                vardef.append(CR);
                continue;
            }
            rest.append(s);
            rest.append(CR);
        }
        if (vardef.length() > 0) {
            vardef.append(CR);
            vardef.append(rest.toString());
            return vardef.toString();
        }
        return rest.toString();
    }

    public void addDoSubmitParameter(String type, String name, Modelitem pitem) {
        if ("notnull".equals(type)) {
            this.nullCheckMap.put(name, pitem);
        }
    }

    public void addCancelOfConstraintElement(String name, Modelitem pitem) {
        this.cancelConstraintMap.put(name, pitem);
    }

    public void addJavaScriptDoClearFunctionCode(String labelid, String functionName, String code) {
        this.functionCodeMap.put(functionName, code);
        this.doClearMethodMap.put(functionName, labelid);
    }

    public void addJavaScriptFunctionCode(String functionName, String code) {
        this.functionCodeMap.put(functionName, code);
    }

    public String getJavaScriptFunctionCode(String functionName) {
        return this.functionCodeMap.get(functionName);
    }

    public boolean checkForDuplicateJavaScriptFunction(String functionName) {
        return this.functionCodeMap.containsKey(functionName);
    }

    public void addChangeSelectMethod(String functionName, String labelid, String labelid2, boolean isContainer) {
        this.changeSelectMethodMap.put(functionName, new ChangeSelectMethod(functionName, labelid, labelid2, isContainer));
    }

    public void addDisableCtrl(Constraint c, Model pmodel2, String targetCtrlName) {
        String srcCtrlName = c.getTarget();
        String value = c.getValue() == null ? "" : c.getValue();
        DisableCtrlManager dcm = !this.dcmMap.containsKey(srcCtrlName) ? this.createDisableCtrlManager(pmodel2, srcCtrlName) : this.dcmMap.get(srcCtrlName);
        if (dcm == null) {
            return;
        }
        dcm.addTargetCtrl(targetCtrlName, c.getType(), value);
        if (c.getKeep()) {
            dcm.setKeepValue();
        }
        this.dcmMap.put(srcCtrlName, dcm);
    }

    public DisableCtrlManager createDisableCtrlManager(Model pmodel2, String srcCtrlName) {
        Displayitem srcDisplyitem;
        Conditionlist cl;
        Model cpmodel2;
        Model smodel2 = AppSchemaUtil.getStoreModel(pmodel2);
        Modelitem srcModelitem = AppSchemaUtil.getModelitem(srcCtrlName, smodel2);
        if (srcModelitem == null) {
            Object[] o = new Object[]{srcCtrlName, this.smodel.getId(), pmodel2.getId(), this.presentation.getIdref()};
            logger.error(rman.getValue("js.disableCtrlManager.srcCtrlName.notfound", o));
            return null;
        }
        if ("showList".equals(this.action.getType()) && !this.action.getUpdatelist() && (cpmodel2 = (Model)(cl = AppSchemaUtil.getConditionlist(this.action)).getParameterAsIRNode()) != null) {
            pmodel2 = cpmodel2;
        }
        if ((srcDisplyitem = AppSchemaUtil.getDisplayitem(srcCtrlName, this.presentation)) == null) {
            Object[] o = new Object[]{srcCtrlName, this.presentation.getIdref()};
            logger.error(rman.getValue("js.disableCtrlManager.srcDisplayitem.notfound", o));
            return null;
        }
        String name = JspBodyGeneratorDisplayitem_update.getCheckboxREName(this.project, srcModelitem, pmodel2, srcDisplyitem);
        return new DisableCtrlManager(name, pmodel2, srcDisplyitem);
    }

    public void setTabVisibility(String tabContainerId, String targetTabId, Displayitemgroup displayitemgroup) {
        String[] conditions;
        for (String condition : conditions = displayitemgroup.getTabvisible().split(",")) {
            Relation relation;
            String[] conditionValues = condition.split(":");
            if (conditionValues == null || conditionValues.length == 0) continue;
            Modelitem srcModelitem = AppSchemaUtil.getModelitem(conditionValues[0], this.smodel);
            String srcModelitemType = null;
            if (srcModelitem != null && (relation = AppSchemaUtil.getRelation(srcModelitem)) != null) {
                srcModelitemType = relation.getType();
            }
            String srcCtrlName = "check".equals(srcModelitemType) || "radio".equals(srcModelitemType) ? JspBodyGeneratorDisplayitem_update.getCheckboxRadioREName(this.project, srcModelitem, this.pmodel) : AppSchemaUtil.createNameAttribute(this.project, conditionValues[0], this.pmodel, true);
            String value = conditionValues[1];
            TabManager tabManager = this.tabManagerMap.get(tabContainerId);
            if (tabManager == null) {
                tabManager = new TabManager();
            }
            tabManager.addTabVisibilityCondition(srcCtrlName, value + ":" + targetTabId);
            this.tabManagerMap.put(tabContainerId, tabManager);
        }
    }

    public String process0() {
        String code;
        String cpm_id;
        String pm_id;
        Map<String, String> tmap;
        StringBuilder sb = new StringBuilder();
        if (this.pmodel != null && (tmap = this.tipsman.getTipsMap(pm_id = this.pmodel.getId())) != null) {
            sb.append(this.gDoTipsArray(tmap));
        }
        if (this.cpmodel != null && this.cpmodel != this.pmodel && (tmap = this.tipsman.getTipsMap(cpm_id = this.cpmodel.getId())) != null) {
            sb.append(this.gDoTipsArray(tmap, false));
        }
        if (this.methodSet.contains(METHOD_DO_SUBMIT)) {
            sb.append(this.gDoSubmit());
        }
        if ((code = this.getCode(this.functionCodeMap)) != null) {
            sb.append(code);
        }
        if (this.actiontype != null && ("insert".equals(this.actiontype) || "update".equals(this.actiontype) || "showList".equals(this.actiontype) || "download".equals(this.actiontype) || "copy".equals(this.actiontype))) {
            sb.append(this.gIndividualClearFunction());
            sb.append(this.gSetOpenSearchListOverlayFunc());
        }
        sb.append(this.gInit());
        sb.append(this.gCreateDisableCtrlManager());
        sb.append(this.gCreateCheckboxToggleButtonEventFunc());
        sb.append(this.gCreateTabManager());
        sb.append(this.gFixTableHeaderRowColumnFunc());
        sb.append(this.gCreateShowListGridFunc());
        sb.append(this.gCreateShowListSpreadsheetFunc());
        sb.append(this.gUpdateContent());
        sb.append(this.gSetCheckboxSearchButtonClickEvent());
        sb.append(this.gSetBtnSetValuesToParentClickEvent());
        sb.append(this.gSetShowNumOfRemainingCharEvent());
        sb.append(this.gDrawChartsFunc());
        sb.append(this.gSetJgroupnodeOrgChartButtonClickEvent());
        sb.append(this.gSeparatePhonenumberEvent());
        sb.append(this.gAutofillFuriganaEvent());
        sb.append(this.gUifunctionEvent());
        sb.append(this.gInputCheckRegexpFunc());
        sb.append(this.gTreeWidgetOnClickFunc());
        sb.append(this.gDirectcopyFunc());
        return sb.toString();
    }

    protected String gSetOpenSearchListOverlayFunc() {
        this.isMobileRefSearchDefined = false;
        if (!AppSchemaUtil.isMobile(this.presentation)) {
            return "";
        }
        List<Modelitem> modelitems = AppSchemaUtil.getStorerefSearchModelitems(this.smodel);
        if (modelitems == null || modelitems.isEmpty()) {
            return "";
        }
        ArrayList<Modelitem> searchModelitems = new ArrayList<Modelitem>();
        Model presentationModel = this.pmodel;
        if ("showList".equals(this.actiontype) || "download".equals(this.actiontype)) {
            presentationModel = AppSchemaUtil.getConditionPModel(this.project, this.action);
            Displaycondition displaycondition = AppSchemaUtil.findDisplaycondition(this.presentation);
            for (Modelitem mitem : modelitems) {
                Displayitem displayitem = AppSchemaUtil.getDisplayitem(mitem.getName(), displaycondition);
                if (displayitem == null || AppSchemaUtil.isHiddenDisplayitem(displayitem)) continue;
                searchModelitems.add(mitem);
            }
        } else {
            for (Modelitem mitem : modelitems) {
                Displayitem displayitem = AppSchemaUtil.getDisplayitem(mitem.getName(), this.presentation);
                if (displayitem == null || AppSchemaUtil.isHiddenDisplayitem(displayitem)) continue;
                searchModelitems.add(mitem);
            }
        }
        if (searchModelitems.isEmpty()) {
            return "";
        }
        boolean isContainerItemExists = false;
        StringBuilder onClickCode = new StringBuilder();
        for (Modelitem searchModelitem : searchModelitems) {
            Relation rel = AppSchemaUtil.getRelationTypeExceptRef(searchModelitem);
            String relationIdref = rel.getIdref();
            String idElement = AppSchemaUtil.createNameAttribute(this.project, searchModelitem.getName(), presentationModel);
            if (StringUtils.contains((CharSequence)idElement, (CharSequence)"${__position.count}")) {
                isContainerItemExists = true;
            }
            onClickCode.append(this.getOpenSearchListOnClickCode(idElement, SourceGenerator.capFirst(relationIdref), AppSchemaUtil.getPrimaryKeyName(AppSchemaUtil.getModel(this.project, relationIdref)), rel.getRolecontent()));
        }
        if (onClickCode.length() == 0) {
            return "";
        }
        this.isMobileRefSearchDefined = true;
        StringBuilder sb = new StringBuilder();
        sb.append("function setOpenSearchListOverlayFunc() {").append(CR);
        sb.append("  ").append("var button;").append(CR);
        sb.append("  ").append("require(['dijit/registry', 'dojo/ready'], function(registry, ready) {").append(CR);
        sb.append("    ").append("ready(function() {").append(CR);
        if (isContainerItemExists) {
            sb.append("      ").append("var i;").append(CR);
        }
        sb.append(onClickCode.toString());
        sb.append("    ").append("});").append(CR);
        sb.append("  ").append("});").append(CR);
        sb.append("}").append(CR);
        return sb.toString();
    }

    protected String getOpenSearchListOnClickCode(String idElement, String capitalizedRelationModelId, String relationId, String relationRolecontent) {
        StringBuilder sb = new StringBuilder();
        String BASETAB = "      ";
        String id = idElement;
        boolean isContainerItem = false;
        if (StringUtils.contains((CharSequence)idElement, (CharSequence)"${__position.count}")) {
            id = StringUtils.replace((String)id, (String)"${__position.count}", (String)"' + i + '");
            isContainerItem = true;
        }
        if (isContainerItem) {
            sb.append(BASETAB).append("i = 1;").append(CR);
            sb.append(BASETAB).append("while(i < 1000) {").append(CR);
            BASETAB = "        ";
        }
        sb.append(BASETAB).append("button = registry.byId('btn_").append(id).append("');").append(CR);
        if (!isContainerItem) {
            sb.append(BASETAB).append("if (button) {").append(CR);
        } else {
            sb.append(BASETAB).append("if (!button) {").append(CR);
            sb.append(BASETAB).append("  ").append("break;").append(CR);
            sb.append(BASETAB).append("}").append(CR);
        }
        sb.append(BASETAB).append("button.on('click', getOpenSearchListOverlayFunc({").append(CR);
        sb.append(BASETAB).append("  ").append("idElement: '").append(id).append("',").append(CR);
        sb.append(BASETAB).append("  ").append("contentElement: '_").append(id).append("_content',").append(CR);
        sb.append(BASETAB).append("  ").append("getGridFunc: get").append(capitalizedRelationModelId).append("ShowListGrid(),").append(CR);
        sb.append(BASETAB).append("  ").append("overlayId: 'searchList").append(capitalizedRelationModelId).append("Overlay',").append(CR);
        sb.append(BASETAB).append("  ").append("setValueFunc: set").append(StringUtil.capFirst((String)relationRolecontent)).append("Value,").append(CR);
        sb.append(BASETAB).append("  ").append("valueId: '").append(relationId).append("',").append(CR);
        sb.append(BASETAB).append("  ").append("contentId: '").append(relationRolecontent).append("'").append(CR);
        sb.append(BASETAB).append("}));").append(CR);
        if (isContainerItem) {
            sb.append(BASETAB).append("i = i + 1;").append(CR);
        }
        sb.append("      ").append("}").append(CR);
        return sb.toString();
    }

    protected String gSetCheckboxSearchButtonClickEvent() {
        if (this.action == null || this.actiontype == null || "show".equals(this.actiontype) || this.checkboxSearchItems.size() == 0) {
            return "";
        }
        Object formName = JspPanelContentBase.createActionId(this.action, this.action.getIdref()) + "_p";
        Displaycondition displaycondition = null;
        if (("showList".equals(this.action.getType()) || "download".equals(this.action.getType())) && (displaycondition = AppSchemaUtil.findDisplaycondition(this.presentation)) != null) {
            formName = JspPanelContent_displaycondition.createFormName(displaycondition.getIdref());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("function setCheckboxSearchButtonEvent() {").append(CR);
        for (Modelitem modelitem : this.checkboxSearchItems) {
            Relation relation = AppSchemaUtil.getRelationTypeExceptRef(modelitem);
            if (!"search".equals(relation.getUi())) continue;
            Model relationModel = AppSchemaUtil.getModel(this.project, relation.getIdref());
            String labelid = AppSchemaUtil.createNameAttribute(this.project, modelitem.getName(), this.cpmodel != null ? this.cpmodel : this.pmodel);
            String btnId = "btn_" + labelid.replace("${fn:escapeXml(c.id)}", "1");
            sb.append("  ").append("setCheckboxSearchButtonEventFunc(").append(CR);
            sb.append("    ").append("\"").append(btnId).append("\",").append(CR);
            sb.append("    ").append("\"").append(labelid).append("\",").append(CR);
            sb.append("    ").append("\"").append(SourceGenerator.capFirst(relation.getIdref())).append("\",").append(CR);
            sb.append("    ").append("\"").append(AppSchemaUtil.getPrimaryKeyName(relationModel)).append("\",").append(CR);
            sb.append("    ").append("document.forms[\"").append((String)formName).append("\"],").append(CR);
            String _width = null;
            String _height = null;
            Displayitem ditem = null;
            ditem = displaycondition != null ? AppSchemaUtil.getDisplayitem(modelitem.getName(), displaycondition) : AppSchemaUtil.getDisplayitem(modelitem.getName(), this.presentation);
            if (ditem != null) {
                _width = ditem.getSearchListWindowWidthAsString();
                _height = ditem.getSearchListWindowHeightAsString();
            }
            if (_width == null) {
                _width = "500";
            }
            if (_height == null) {
                _height = "500";
            }
            sb.append("    ").append("{width: ").append(_width).append(", height: ").append(_height).append("}");
            Searchparam[] searchparams = AppSchemaUtil.getSearchparams(ditem);
            if (searchparams != null && searchparams.length > 0) {
                sb.append(",").append(CR);
                sb.append("    ").append(JavaScriptManager.createJsFunctionName_actionParam(ditem));
            }
            sb.append(CR);
            sb.append("  ").append(");").append(CR);
        }
        sb.append("}").append(CR).append(CR);
        return sb.toString();
    }

    protected String gSetJgroupnodeOrgChartButtonClickEvent() {
        if (!this.isJgroupnodeOrgChartDefined) {
            return "";
        }
        String labelid = AppSchemaUtil.createNameAttribute(this.project, "jgroupidjshparam", this.cpmodel != null ? this.cpmodel : this.pmodel);
        StringBuilder sb = new StringBuilder();
        sb.append("function setJgroupnodeOrgChartButtonEvent() {").append(CR);
        sb.append("  ").append("setJgroupnodeOrgChartButtonClickEventFunc(").append(CR);
        sb.append("    ").append("\"btn_").append(labelid.replace("${fn:escapeXml(c.id)}", "1")).append("\",").append(CR);
        sb.append("    ").append("\"").append(labelid).append("\",").append(CR);
        sb.append("    ").append("document.forms[\"").append(JspPanelContentBase.createActionId(this.action, this.action.getIdref())).append("_p\"]").append(CR);
        sb.append("  ").append(");").append(CR);
        sb.append("}").append(CR).append(CR);
        return sb.toString();
    }

    protected String gAutofillFuriganaEvent() {
        if (this.displaymodelsContainingfuriganaItem == null || this.displaymodelsContainingfuriganaItem.isEmpty()) {
            return "";
        }
        if (!("insert".equals(this.actiontype) || "update".equals(this.actiontype) || "copy".equals(this.actiontype) || "showList".equals(this.actiontype) && this.action.getUpdatelist())) {
            return "";
        }
        StringBuilder autofillFurigana = new StringBuilder();
        for (Displaymodel displaymodel : this.displaymodelsContainingfuriganaItem) {
            if (StringUtils.endsWith((CharSequence)displaymodel.getIdref(), (CharSequence)"_ulp")) {
                autofillFurigana.append(this.gAutofillFuriganaUpdateList(displaymodel));
                continue;
            }
            autofillFurigana.append(this.gAutofillFurigana(displaymodel));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("function setAutofillFuriganaEvent() {").append(CR).append("  ").append("setAutofillFurigana([").append(CR).append(autofillFurigana.toString()).append("  ").append("]);").append(CR).append("}").append(CR).append(CR);
        return sb.toString();
    }

    protected String gAutofillFuriganaUpdateList(Displaymodel displaymodel) {
        TreeMap<String, List<Displayitem>> updateListDisplayitems = new TreeMap<String, List<Displayitem>>();
        updateListDisplayitems.put("updateList", AppSchemaUtil.getFuriganaItems(displaymodel));
        return this.gAutofillFuriganaItemInContainer(AppSchemaUtil.getModel(this.project, displaymodel.getIdref()), updateListDisplayitems);
    }

    protected String gAutofillFurigana(Displaymodel displaymodel) {
        TreeMap<String, List<Displayitem>> displayitemsInContainer = new TreeMap<String, List<Displayitem>>();
        StringBuilder autokana = new StringBuilder();
        for (Displayitem displayitem : AppSchemaUtil.getFuriganaItems(displaymodel)) {
            if (AppSchemaUtil.hasChildPart(displayitem.getName())) {
                String containerName = AppSchemaUtil.getParentPart(displayitem.getName());
                ArrayList<Displayitem> containerDisplayitems = (ArrayList<Displayitem>)displayitemsInContainer.get(containerName);
                if (containerDisplayitems == null) {
                    containerDisplayitems = new ArrayList<Displayitem>();
                }
                containerDisplayitems.add(displayitem);
                displayitemsInContainer.put(containerName, containerDisplayitems);
                continue;
            }
            autokana.append(this.gSetAutofillFurigana(AppSchemaUtil.createNameAttribute(this.project, displayitem.getFuriganaSrcItem(), this.pmodel), AppSchemaUtil.createNameAttribute(this.project, displayitem.getName(), this.pmodel), displayitem));
        }
        StringBuilder sb = new StringBuilder();
        sb.append(autokana.toString());
        sb.append(this.gAutofillFuriganaItemInContainer(this.pmodel, displayitemsInContainer));
        return sb.toString();
    }

    protected String gSetAutofillFurigana(String srcId, String dstId, Displayitem displayitem) {
        return this.gSetAutofillFurigana(null, srcId, dstId, displayitem);
    }

    protected String gSetAutofillFurigana(String prefixId, String srcId, String dstId, Displayitem displayitem) {
        StringBuilder sb = new StringBuilder();
        sb.append("    ").append("{").append(CR);
        if (StringUtils.isNotBlank((CharSequence)prefixId)) {
            sb.append("      ").append("prefixId: \"").append(prefixId).append("\",").append(CR);
        }
        sb.append("      ").append("srcId: \"").append(srcId).append("\",").append(CR).append("      ").append("dstId: \"").append(dstId).append("\",").append(CR).append("      ").append("isKatakana: ").append("katakana".equals(displayitem.getFuriganaCharType())).append(",").append(CR).append("    ").append("},").append(CR);
        return sb.toString();
    }

    protected String gAutofillFuriganaItemInContainer(Model furiganaModel, Map<String, List<Displayitem>> displayitemsInContainer) {
        if (furiganaModel == null || displayitemsInContainer.isEmpty()) {
            return "";
        }
        String delimiter = "${__position.count}";
        StringBuilder sb = new StringBuilder();
        for (String name : displayitemsInContainer.keySet()) {
            List<Displayitem> displayitems = displayitemsInContainer.get(name);
            for (Displayitem displayitem : displayitems) {
                sb.append(this.gSetAutofillFurigana(StringUtils.substringBefore((String)AppSchemaUtil.createNameAttribute(this.project, displayitem.getFuriganaSrcItem(), furiganaModel), (String)"${__position.count}"), AppSchemaUtil.getChildPart(displayitem.getFuriganaSrcItem()), AppSchemaUtil.getChildPart(displayitem.getName()), displayitem));
            }
        }
        return sb.toString();
    }

    protected String gUifunctionEvent() {
        if (this.uifunctions == null || this.uifunctions.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        StringBuilder uifunctionEventFunc = new StringBuilder();
        sb.append("function setUifunctionEvent() {").append(CR);
        sb.append("  ").append("require([\"dijit/registry\", \"dojo/query\"], function(registry, query) {").append(CR);
        for (Displayitem ditem : this.uifunctions.keySet()) {
            List<Uifunction> uifunctionSet = this.uifunctions.get(ditem);
            for (Uifunction uifunction : uifunctionSet) {
                StringBuilder functionName = new StringBuilder();
                String id = uifunction.getId();
                if (AppSchemaUtil.hasChildPart(id)) {
                    id = AppSchemaUtil.getChildPart(id);
                }
                functionName.append("set").append(StringUtils.capitalize((String)id)).append("ClickEvent(registry, query)");
                sb.append("    ").append(functionName.toString()).append(";").append(CR);
                uifunctionEventFunc.append(this.gUifunctionEvent(functionName.toString(), ditem, uifunction));
            }
        }
        sb.append("  ").append("});").append(CR);
        sb.append("}").append(CR).append(CR);
        sb.append(uifunctionEventFunc.toString());
        return sb.toString();
    }

    protected String gUifunctionEvent(String functionName, Displayitem ditem, Uifunction uifunction) {
        StringBuilder sb = new StringBuilder();
        sb.append("function ").append(functionName).append(" {").append(CR);
        this.id = uifunction.getId();
        if (AppSchemaUtil.hasChildPart(this.id)) {
            sb.append(this.gUifunctionContainerEvent(ditem, uifunction));
        } else {
            sb.append("  ").append("var button = registry.byId(\"").append(this.id).append("\");").append(CR);
            sb.append("  ").append("if (!button) {").append(CR);
            sb.append("    ").append("return;").append(CR);
            sb.append("  ").append("}").append(CR);
            sb.append(this.gUifunction(ditem, uifunction));
        }
        sb.append("}").append(CR).append(CR);
        return sb.toString();
    }

    protected String gUifunctionContainerEvent(Displayitem ditem, Uifunction uifunction) {
        List<Map<String, String>> srcDstItems = this.getUifunctionItems(ditem, uifunction);
        if (srcDstItems == null || srcDstItems.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String id = uifunction.getId();
        sb.append("  ").append("query(\"span[role='button'][id^='").append(AppSchemaUtil.getParentPart(id)).append(StringUtil.convertHtmlIdString((String)"/")).append(AppSchemaUtil.getChildPart(id)).append("_']\").forEach(function(node, i) {").append(CR);
        sb.append("    ").append("var button = registry.byId(node.id);").append(CR);
        sb.append("    ").append("if (button) {").append(CR);
        if ("copy".equals(uifunction.getType())) {
            sb.append("      ").append("var src = [];").append(CR);
        }
        sb.append("      ").append("var dst = [];").append(CR);
        for (Map<String, String> srcDstItem : srcDstItems) {
            String[] srcKeys = srcDstItem.keySet().toArray(new String[0]);
            String src = srcKeys[0];
            String[] srcContainerItemNames = StringUtils.splitByWholeSeparator((String)src, (String)"${__position.count}");
            String[] dstContainerItemNames = StringUtils.splitByWholeSeparator((String)srcDstItem.get(src), (String)"${__position.count}");
            if (srcContainerItemNames == null || srcContainerItemNames.length != 2) continue;
            if ("copy".equals(uifunction.getType())) {
                sb.append("      ").append("src.push(registry.byId(\"").append(srcContainerItemNames[0]).append("\" + (i + 1) + \"").append(srcContainerItemNames[1]).append("\"));").append(CR);
            }
            sb.append("      ").append("dst.push(registry.byId(\"").append(dstContainerItemNames[0]).append("\" + (i + 1) + \"").append(dstContainerItemNames[1]).append("\"));").append(CR);
        }
        sb.append("      ").append("button.on(\"click\", function() {").append(CR);
        sb.append("        ").append("for (var j=0,l=");
        if ("copy".equals(uifunction.getType())) {
            sb.append("src");
        } else {
            sb.append("dst");
        }
        sb.append(".length; j<l; j++) {").append(CR);
        if ("copy".equals(uifunction.getType())) {
            sb.append("          ").append("if (src[j] && dst[j]) {").append(CR);
            sb.append("            ").append("dst[j].set(\"value\", src[j].get(\"value\"));").append(CR);
            sb.append("          ").append("}").append(CR);
        } else if ("clear".equals(uifunction.getType())) {
            sb.append("          ").append("if (dst[j]) {").append(CR);
            sb.append("            ").append("dst[j].set(\"value\", \"\");").append(CR);
            sb.append("          ").append("}").append(CR);
        }
        sb.append("        ").append("}").append(CR);
        sb.append("      ").append("});").append(CR);
        sb.append("    ").append("}").append(CR);
        sb.append("  ").append("});").append(CR);
        return sb.toString();
    }

    protected String gUifunctionSrcElementQuery(String id) {
        return this.gUifunctionElementQuery("src", id);
    }

    protected String gUifunctionDstElementQuery(String id) {
        return this.gUifunctionElementQuery("dst", id);
    }

    protected String gUifunctionElementQuery(String srcDst, String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (StringUtils.contains((CharSequence)id, (CharSequence)"${__position.count}")) {
            String[] containerItemNames = StringUtils.splitByWholeSeparator((String)id, (String)"${__position.count}");
            sb.append("  ").append("query(\"input[id^='").append(containerItemNames[0]).append("']").append("[id$='").append(containerItemNames[1]).append("']\").forEach(function(node) {").append(CR);
            sb.append("    ").append(srcDst).append(".push(registry.byId(node.id));").append(CR);
            sb.append("  ").append("});").append(CR);
        } else {
            sb.append("  ").append(srcDst).append(".push(registry.byId(\"").append(id).append("\"));").append(CR);
        }
        return sb.toString();
    }

    protected String gUifunction(Displayitem ditem, Uifunction uifunction) {
        List<Map<String, String>> srcDstItems = this.getUifunctionItems(ditem, uifunction);
        if (srcDstItems == null || srcDstItems.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if ("copy".equals(uifunction.getType())) {
            sb.append("  ").append("var src = [];").append(CR);
        }
        sb.append("  ").append("var dst = [];").append(CR);
        for (Map<String, String> srcDstItem : srcDstItems) {
            String[] srcKeys = srcDstItem.keySet().toArray(new String[0]);
            String src = srcKeys[0];
            if ("copy".equals(uifunction.getType())) {
                sb.append(this.gUifunctionSrcElementQuery(src));
            }
            sb.append(this.gUifunctionDstElementQuery(srcDstItem.get(src)));
        }
        sb.append("  ").append("button.on(\"click\", function() {").append(CR);
        sb.append("    ").append("for (var i=0,l=");
        if ("copy".equals(uifunction.getType())) {
            sb.append("src");
        } else if ("clear".equals(uifunction.getType())) {
            sb.append("dst");
        }
        sb.append(".length; i<l; i++) {").append(CR);
        if ("copy".equals(uifunction.getType())) {
            sb.append("      ").append("if (src[i] && dst[i]) {").append(CR);
            sb.append("        ").append("dst[i].set(\"value\", src[i].get(\"value\"));").append(CR);
            sb.append("      ").append("}").append(CR);
        } else if ("clear".equals(uifunction.getType())) {
            sb.append("      ").append("if (dst[i]) {").append(CR);
            sb.append("        ").append("dst[i].set(\"value\", \"\");").append(CR);
            sb.append("      ").append("}").append(CR);
        }
        sb.append("    ").append("}").append(CR);
        sb.append("  ").append("});").append(CR);
        return sb.toString();
    }

    protected List<Map<String, String>> getUifunctionItems(Displayitem ditem, Uifunction uifunction) {
        String uiTargetitem = uifunction.getTargetitem();
        if (StringUtils.isBlank((CharSequence)uiTargetitem)) {
            return null;
        }
        String[] targetItems = new String[]{uiTargetitem};
        if (StringUtils.contains((CharSequence)uiTargetitem, (CharSequence)",")) {
            targetItems = uiTargetitem.split(",");
        }
        ArrayList<Map<String, String>> items = new ArrayList<Map<String, String>>();
        if (StringUtils.contains((CharSequence)uiTargetitem, (CharSequence)"[")) {
            for (String targetitem : targetItems) {
                String[] srcDstItem;
                if (!StringUtils.contains((CharSequence)targetitem, (CharSequence)"[") || (srcDstItem = (targetitem = StringUtils.substringAfter((String)StringUtils.substringBeforeLast((String)targetitem, (String)"]"), (String)"[")).split(":")) == null || srcDstItem.length != 2) continue;
                this.putUifunctionTargetItem(srcDstItem[0], srcDstItem[1], items);
            }
        } else {
            for (String dstItem : targetItems) {
                this.putUifunctionTargetItem(ditem.getName(), dstItem, items);
            }
        }
        return items;
    }

    protected void putUifunctionTargetItem(String srcItem, String dstItem, List<Map<String, String>> items) {
        String src = "";
        if (StringUtils.isNotBlank((CharSequence)srcItem)) {
            src = AppSchemaUtil.createNameAttribute(this.project, srcItem.trim(), this.pmodel);
        }
        String dst = "";
        if (StringUtils.isNotBlank((CharSequence)dstItem)) {
            dst = AppSchemaUtil.createNameAttribute(this.project, dstItem.trim(), this.pmodel);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(src, dst);
        items.add(map);
        String srcSearchItem = "";
        if (AppSchemaUtil.isRelationItemTypeSearch(this.smodel, srcItem)) {
            srcSearchItem = this.getRelationTypeSearchItem(src);
        }
        String dstSearchItem = "";
        if (AppSchemaUtil.isRelationItemTypeSearch(this.smodel, dstItem)) {
            dstSearchItem = this.getRelationTypeSearchItem(dst);
        }
        map = new HashMap();
        map.put(srcSearchItem, dstSearchItem);
        items.add(map);
    }

    protected String getRelationTypeSearchItem(String name) {
        StringBuilder sb = new StringBuilder();
        sb.append("_").append(name).append("_content");
        return sb.toString();
    }

    protected String gSeparatePhonenumberEvent() {
        if (this.displaymodelsContainingSeparatePhonenumberItem == null || this.displaymodelsContainingSeparatePhonenumberItem.isEmpty()) {
            return "";
        }
        String separatePhonenumberItemsId = "";
        if ("insert".equals(this.actiontype) || "update".equals(this.actiontype) || "copy".equals(this.actiontype) || "showList".equals(this.actiontype)) {
            separatePhonenumberItemsId = this.gSeparatePhonenumberItemsId();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("function setSeparatePhonenumberEvent() {").append(CR);
        sb.append("  ").append("require([\"./system/libphonenumber.js\", \"dijit/registry\"], (libphonenumber, registry) => {").append(CR);
        sb.append("    ").append("var itemsId = [];").append(CR);
        sb.append(separatePhonenumberItemsId);
        sb.append("    ").append("itemsId.forEach((itemId) => setSeparatePhonenumberEventToWidgets(itemId, libphonenumber, registry));").append(CR);
        sb.append("  ").append("});").append(CR);
        sb.append("}").append(CR).append(CR);
        return sb.toString();
    }

    protected String gSeparatePhonenumberItemsId() {
        ArrayList itemNames = new ArrayList();
        this.displaymodelsContainingSeparatePhonenumberItem.stream().forEach(ipc -> {
            if (ipc instanceof Displaycondition) {
                Displaycondition displaycondition = (Displaycondition)ipc;
                Model model = AppSchemaUtil.getModel(this.project, displaycondition.getIdref());
                itemNames.addAll(Stream.of(displaycondition.getContent()).filter(idc -> idc instanceof Displayitem && ((Displayitem)idc).getSeparatePhonenumber()).map(idc -> AppSchemaUtil.createNameAttribute(this.project, ((Displayitem)idc).getName(), model)).collect(Collectors.toList()));
            } else if (ipc instanceof Displaymodel) {
                Displaymodel displaymodel = (Displaymodel)ipc;
                String idref = displaymodel.getIdref();
                Model model = StringUtils.isBlank((CharSequence)idref) ? this.pmodel : AppSchemaUtil.getModel(this.project, idref);
                itemNames.addAll(AppSchemaUtil.getDisplayitems(displaymodel).stream().filter(idc -> idc instanceof Displayitem && idc.getSeparatePhonenumber()).map(idc -> AppSchemaUtil.createNameAttribute(this.project, idc.getName(), model)).collect(Collectors.toList()));
            }
        });
        return itemNames.stream().map(itemName -> "    itemsId.push(\"" + itemName + "\");").collect(Collectors.joining(CR, "", CR));
    }

    protected String gSetBtnSetValuesToParentClickEvent() {
        if (this.presentation == null || !StringUtils.startsWith((CharSequence)this.presentation.getIdref(), (CharSequence)"searchList")) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("function setBtnSetValuesToParentClickEvent() {").append(CR);
        sb.append("  ").append("require([\"dijit/registry\", \"dojo/dom\", \"dojo/dom-attr\", \"dojo/query\"], function(registry, dom, domAttr, query) {").append(CR);
        sb.append("    ").append("var btn = registry.byId(\"btnSetValuesToParent\");").append(CR);
        sb.append("    ").append("if (!btn) {").append(CR);
        sb.append("      ").append("return;").append(CR);
        sb.append("    ").append("}").append(CR);
        sb.append("    ").append("var jfcLpHiddenItem = dom.byId(\"jfc_lp_hidden_item\");").append(CR);
        sb.append("    ").append("btn.on(\"click\", function() {").append(CR);
        sb.append("      ").append("var selectedPkeys = {};").append(CR);
        sb.append("      ").append("query(\"input[type='checkbox'][name$='_jsh_cb']:checked\").forEach(function(node) {").append(CR);
        sb.append("        ").append("selectedPkeys[node.value] = true;").append(CR);
        sb.append("      ").append("});").append(CR);
        sb.append("      ").append("if (jfcLpHiddenItem) {").append(CR);
        sb.append("        ").append("query(\"input[type='hidden'][name$='_jsh_cb']\", jfcLpHiddenItem).forEach(function(node) {").append(CR);
        sb.append("          ").append("selectedPkeys[node.value] = true;").append(CR);
        sb.append("        ").append("});").append(CR);
        sb.append("      ").append("}").append(CR);
        sb.append("      ").append("window.opener.setCheckcboxSearchWindowSelectedValue(selectedPkeys);").append(CR);
        sb.append("      ").append("self.close();").append(CR);
        sb.append("    ").append("});").append(CR);
        sb.append("    ").append("query(\"table.display_table > tbody > tr > th.display_label_list > a\").forEach(function(node) {").append(CR);
        sb.append("      ").append("var href = domAttr.get(node, \"href\");").append(CR);
        sb.append("      ").append("if (href && href !== \"\") {").append(CR);
        sb.append("        ").append("domAttr.set(node, \"href\", href + \"&").append("jfc_use_cb").append("=true\");").append(CR);
        sb.append("      ").append("}").append(CR);
        sb.append("    ").append("});").append(CR);
        sb.append("  ").append("});").append(CR);
        sb.append("}").append(CR);
        return sb.toString();
    }

    protected String gDoTipsArray(Map<String, String> tmap) {
        return this.gDoTipsArray(tmap, true);
    }

    protected String gDoTipsArray(Map<String, String> tmap, boolean isOutputCommentFlag) {
        StringBuilder sb = new StringBuilder();
        boolean isOutputTipsArray = false;
        for (String key : tmap.keySet()) {
            if (!key.endsWith(this.actiontype)) continue;
            String comment = tmap.get(key);
            sb.append("tips[\"").append(StringEscapeUtils.escapeHtml4((String)key)).append("\"]=\"");
            sb.append(WebStringEncodeUtilities.unescapeHtmlTag((String)comment));
            sb.append("\";");
            sb.append(CR);
            isOutputTipsArray = true;
        }
        if (isOutputCommentFlag && isOutputTipsArray) {
            sb.insert(0, "// Tips array" + CR);
            sb.append(CR);
        }
        return sb.toString();
    }

    protected String gDoSubmit() {
        StringBuilder sb = new StringBuilder();
        sb.append("DoSubmitList = new Array();");
        sb.append(CR);
        sb.append("function addDoSubmit(fnc) {");
        sb.append(CR);
        sb.append("   DoSubmitList.push(fnc);");
        sb.append(CR);
        sb.append("}");
        sb.append(CR);
        sb.append("function fireDoSubmit() {");
        sb.append(CR);
        sb.append("   for (i in DoSubmitList) {");
        sb.append(CR);
        sb.append("      (DoSubmitList[i])();");
        sb.append(CR);
        sb.append("   }");
        sb.append(CR);
        sb.append("} ");
        sb.append(CR);
        sb.append(CR);
        sb.append("function doSubmit(f, isNoValidate) {").append(CR);
        sb.append("  if (!isNoValidate && !isFormValid(f)) {").append(CR);
        sb.append("    return false;").append(CR);
        sb.append("  }").append(CR);
        sb.append("  try {").append(CR);
        sb.append("    fireDoSubmit();").append(CR);
        sb.append("  } catch (e) {").append(CR);
        sb.append("    return false;").append(CR);
        sb.append("  }").append(CR);
        boolean isNeedEnableWidgetsOnSubmitFunction = false;
        if (this.cancelConstraintMap.size() > 0 && this.actiontype != null && (this.actiontype.startsWith("insert") || this.actiontype.startsWith("copy") || this.actiontype.startsWith("update") || this.actiontype.startsWith("showList") && this.action.getUpdatelist())) {
            sb.append("  ").append("enableWidgetsOnSubmit();").append(CR);
            isNeedEnableWidgetsOnSubmitFunction = true;
        }
        sb.append("  ");
        sb.append("return true;");
        sb.append(CR);
        sb.append("}");
        sb.append(CR);
        if (isNeedEnableWidgetsOnSubmitFunction) {
            sb.append(CR).append(this.gEnableWidgetsOnSubmitFunction()).append(CR);
        }
        sb.append(this.gEndsWithFunction());
        return sb.toString();
    }

    protected String gEnableWidgetsOnSubmitFunction() {
        StringBuilder sb = new StringBuilder();
        sb.append("function enableWidgetsOnSubmit() {").append(CR);
        sb.append("  ").append("var widgets = getAllWidgets();").append(CR);
        sb.append("  ").append("if (!widgets || widgets.length === 0) {").append(CR);
        sb.append("    ").append("return;").append(CR);
        sb.append("  ").append("}").append(CR);
        sb.append("  ").append("require([\"dojo/_base/array\"], function(array) {").append(CR);
        Iterator<String> it = this.cancelConstraintMap.keySet().iterator();
        if (this.actiontype.startsWith("showList") && this.action.getUpdatelist()) {
            sb.append(this.gUpdateListWidgetName(it));
        } else {
            sb.append("    ").append("array.some(widgets, function(widget) {").append(CR);
            sb.append("      ").append("if (!widget.name) {").append(CR);
            sb.append("        ").append("return false;").append(CR);
            sb.append("      ").append("}").append(CR);
            sb.append(this.gNormalWidgetName(it));
        }
        sb.append("  ").append("});").append(CR);
        sb.append("}").append(CR);
        return sb.toString();
    }

    protected String gUpdateListWidgetName(Iterator<String> it) {
        StringBuilder sb = new StringBuilder();
        sb.append("    ").append("var regExps = [];").append(CR);
        String name = null;
        while (it.hasNext()) {
            name = it.next();
            name = StringUtils.replace((String)name, (String)CONTAINER_CHECKBOX_LOOP_INDEX, (String)"\\\\d+");
            name = StringUtils.replace((String)name, (String)"${__position.count}", (String)"\\\\d+");
            name = StringUtils.replace((String)name, (String)TH_CONTAINER_CHECKBOX_LOOP_INDEX, (String)"\\\\d+");
            name = StringUtils.replace((String)name, (String)TH_CONTAINER_LOOP_INDEX, (String)"\\\\d+");
            sb.append("    ").append("regExps.push(new RegExp(\"");
            if (StringUtils.startsWith((CharSequence)name, (CharSequence)"/") && StringUtils.endsWith((CharSequence)name, (CharSequence)"/")) {
                name = StringUtils.substringBefore((String)StringUtils.substringAfter((String)name, (String)"/^"), (String)"$/");
                name = StringUtils.replace((String)name, (String)"\\w", (String)"\\\\w");
                sb.append(StringUtils.replace((String)name, (String)"$", (String)"\\$"));
            } else {
                sb.append(StringUtils.replace((String)name, (String)"$", (String)"\\\\$"));
            }
            sb.append("\"));").append(CR);
        }
        sb.append("    ").append("array.some(widgets, function(widget) {").append(CR);
        sb.append("      ").append("if (!widget.name) {").append(CR);
        sb.append("        ").append("return false;").append(CR);
        sb.append("      ").append("}").append(CR);
        sb.append("      ").append("for (var i=0; i<regExps.length; i++) {").append(CR);
        sb.append("        ").append("if (regExps[i].test(widget.name)) {").append(CR);
        sb.append("          ").append("widget.set(\"disabled\", false);").append(CR);
        sb.append("        ").append("}").append(CR);
        sb.append("      ").append("}").append(CR);
        sb.append("    ").append("});").append(CR);
        return sb.toString();
    }

    protected String gNormalWidgetName(Iterator<String> it) {
        StringBuilder sb = new StringBuilder();
        String name = null;
        String jspIteratorCount = "${__position.count}";
        String thIteratorCount = TH_CONTAINER_LOOP_INDEX;
        while (it.hasNext()) {
            name = it.next();
            sb.append("      ").append("if (widget.name");
            if (StringUtils.startsWith((CharSequence)name, (CharSequence)"/") && StringUtils.endsWith((CharSequence)name, (CharSequence)"/")) {
                sb.append(".match(").append(this.getCheckboxNameRegExp(name)).append(")");
            } else if (name.indexOf(jspIteratorCount) > 0) {
                sb.append(this.getRepeatItemWidgetNameCondition(name, jspIteratorCount));
            } else if (name.indexOf(thIteratorCount) > 0) {
                sb.append(this.getRepeatItemWidgetNameCondition(name, thIteratorCount));
            } else {
                sb.append(" === \"").append(name).append("\"");
            }
            sb.append(") {").append(CR);
            sb.append("        ").append("widget.set(\"disabled\", false);").append(CR);
            sb.append("      ").append("}").append(CR);
        }
        sb.append("    ").append("});").append(CR);
        return sb.toString();
    }

    protected String getCheckboxNameRegExp(String name) {
        if (!StringUtils.contains((CharSequence)name, (CharSequence)TH_CONTAINER_CHECKBOX_LOOP_INDEX) && !StringUtils.contains((CharSequence)name, (CharSequence)CONTAINER_CHECKBOX_LOOP_INDEX)) {
            return name;
        }
        if (StringUtils.contains((CharSequence)name, (CharSequence)TH_CONTAINER_CHECKBOX_LOOP_INDEX)) {
            return StringUtils.replace((String)name, (String)TH_CONTAINER_CHECKBOX_LOOP_INDEX, (String)"\\d+");
        }
        return StringUtils.replace((String)name, (String)CONTAINER_CHECKBOX_LOOP_INDEX, (String)"\\d+");
    }

    protected String getRepeatItemWidgetNameCondition(String name, String iteratorCount) {
        StringBuilder sb = new StringBuilder();
        String[] names = name.split(Pattern.quote(iteratorCount));
        sb.append(".lastIndexOf(\"").append(names[0]).append("\", 0) === 0 &&").append(CR);
        sb.append("          ").append("widget.name.indexOf(\"").append(names[1]).append("\") > 0");
        return sb.toString();
    }

    protected String gEndsWithFunction() {
        String templatefilename = TemplatefilenameBase + "__javascript_endsWith.html";
        FileTemplateManager tplman = new FileTemplateManager(templatefilename, TemplatefileCharEncoding);
        return tplman.getResult();
    }

    private String getCode(Map<String, String> codeMap) {
        if (codeMap.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = codeMap.values().iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            sb.append(CR);
        }
        return sb.toString();
    }

    protected String gInit() {
        String tab = "  ";
        boolean isSearchListHierarchicalView = false;
        if (this.isSearchListHierarchicalView()) {
            tab = "    ";
            isSearchListHierarchicalView = true;
        }
        StringBuilder sb = new StringBuilder();
        this.gInit_createDisableCtrlManager(sb, tab);
        this.gInit_tabSettings(sb, tab);
        this.gInit_createClearToggleButton(sb, tab);
        this.gInit_createEnter2TabHandler(sb, tab);
        this.gInit_createTabManager(sb, tab);
        this.gInit_getDisableNoUseAnchor(sb, tab);
        this.gInit_FixTableHeaderRowColumn(sb, tab);
        this.gInit_createShowListGrid(sb, tab);
        this.gInit_createShowListSpreadsheet(sb, tab);
        this.gInit_mobileFunc(sb, tab);
        this.gInit_createCheckboxSearchButtonEvent(sb, tab);
        this.gInit_createSetBtnSetValuesToParentClickEvent(sb, tab);
        this.gInit_createUpdateListDeleteCheckboxEvent(sb, tab);
        this.gInit_createUpdateListInitFunc(sb, tab);
        this.gInit_createShowNumOfRemainingCharEvent(sb, tab);
        this.gInit_createDisplaychart(sb, tab);
        this.gInit_setBatchBtnDisabledEvent(sb, tab);
        this.gInit_setJgroupnodeOrgChartButtonEvent(sb, tab);
        this.gInit_setSeparatePhonenumberEvent(sb, tab);
        this.gInit_setUifunctionEvent(sb, tab);
        this.gInit_setAutofillFuriganaEvent(sb, tab);
        this.gInit_createRelationValuesFunc(sb, tab);
        this.gInit_setTableRowHoverEvent(sb, tab);
        this.gInit_setInputCheckRegexpFunc(sb, tab);
        this.gInit_setCalendarViewAllDayItemEvent(sb, tab);
        this.gInit_setDirectcopyEvent(sb, tab);
        this.gInit_setListeners(sb, tab);
        if (!this.isAutofillFuriganaDefined) {
            this.gInit_focusFirstElement(sb, tab);
        }
        if (isSearchListHierarchicalView) {
            sb.insert(0, "  if (!setSubWindowHierarchicalView(window.location.href)) {" + CR).append("  } else {").append(CR).append(this.gShowTreeWidgetCode()).append("  }").append(CR);
        }
        sb.insert(0, "function init() {" + CR).append("}").append(CR);
        sb.append("Initializer.addInit(init);").append(CR).append(CR);
        return sb.toString();
    }

    protected boolean isSearchListHierarchicalView() {
        if (this.presentation == null || !StringUtils.startsWith((CharSequence)this.presentation.getIdref(), (CharSequence)"searchList")) {
            return false;
        }
        Optional<Relation> selfReferenceRelation = Arrays.stream(AppSchemaUtil.getModelitem(this.smodel)).map(mitem -> AppSchemaUtil.getRelationTypeExceptRef(mitem)).filter(Objects::nonNull).filter(r -> this.smodel.getId().equals(r.getIdref())).findFirst();
        if (!selfReferenceRelation.isPresent()) {
            return false;
        }
        String pkeys = Arrays.stream(AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(this.smodel, this.project)).map(p -> StringUtils.wrap((String)p.getName(), (String)"'")).collect(Collectors.joining(", "));
        Modelitem selfReferenceModelitem = (Modelitem)selfReferenceRelation.get().rGetParentRNode();
        this.treeWidgetItemSettings = new HashMap<String, String>();
        this.treeWidgetItemSettings.put("pkeys", pkeys);
        this.treeWidgetItemSettings.put("parent", selfReferenceModelitem.getName());
        this.treeWidgetItemSettings.put("content", selfReferenceRelation.get().getRolecontent());
        return true;
    }

    protected boolean isModelReferenceSearchHierarchicalView(String modelId, String modelitemName) {
        Action[] actions;
        for (Action action : actions = AppSchemaUtil.getActionByModelId(this.project, modelId)) {
            Presentation[] presentations;
            if (!"showList".equals(action.getType()) || (presentations = AppSchemaUtil.getPresentation(this.project, action)) == null) continue;
            for (Presentation presentation : presentations) {
                Displayitem displayitem = AppSchemaUtil.getDisplayitem(modelitemName, presentation);
                if (displayitem == null || !displayitem.getSearchListHierarchicalView()) continue;
                return true;
            }
        }
        return false;
    }

    protected String gShowTreeWidgetCode() {
        String content = this.treeWidgetItemSettings.get("content");
        StringBuilder sb = new StringBuilder();
        sb.append("    ").append("showTreeWidget(").append(StringUtils.wrap((String)this.smodel.getId(), (String)"'")).append(", 'jfcTreeWidget', {").append(CR).append("      ").append("pkeys: [").append(this.treeWidgetItemSettings.get("pkeys")).append("],").append(CR).append("      ").append("content: ").append(StringUtils.wrap((String)content, (String)"'")).append(",").append(CR).append("      ").append("parent: ").append(StringUtils.wrap((String)this.treeWidgetItemSettings.get("parent"), (String)"'")).append(",").append(CR).append("    ").append("}, jfcTreeWidgetOnClick);").append(CR);
        return sb.toString();
    }

    protected String gTreeWidgetOnClickFunc() {
        if (this.treeWidgetItemSettings == null) {
            return "";
        }
        String content = this.treeWidgetItemSettings.get("content");
        StringBuilder sb = new StringBuilder();
        sb.append("function jfcTreeWidgetOnClick(id, name) {").append(CR).append("  ").append("window.opener.set").append(SourceGenerator.capFirst(content)).append("Value(id, name);").append(CR).append("}").append(CR);
        return sb.toString();
    }

    protected String gIndividualClearFunction() {
        boolean isSubmit;
        StringBuilder sb = new StringBuilder();
        sb.append("function individualClear(formname) {");
        sb.append(CR);
        sb.append("  ");
        sb.append("var f = document.forms[formname];");
        sb.append(CR);
        for (String functionName : this.doClearMethodMap.keySet()) {
            String sep;
            String labelid = this.doClearMethodMap.get(functionName);
            if (labelid.indexOf(sep = " + i + ") < 0) {
                sb.append("  ");
                sb.append(functionName);
                sb.append("(f);");
                sb.append(CR);
                continue;
            }
            String p_labelid = labelid.substring(0, labelid.indexOf(sep) - 1);
            String c_labelid = labelid.substring(labelid.indexOf(sep) + sep.length() + 1);
            this.gCallFuncInContainer(functionName, p_labelid, c_labelid, sb, "f");
        }
        boolean bl = isSubmit = AppSchemaUtil.needsReload(this.project, this.smodel) || AppSchemaUtil.hasAutocalc(this.smodel, this.project) || AppSchemaUtil.hasConditionControl(this.smodel, this.pmodel);
        if (!isSubmit) {
            isSubmit = this.isOnChangeSubmit();
        }
        if (isSubmit) {
            sb.append("  ");
            sb.append("buttonOff();");
            sb.append(CR);
            sb.append("  ");
            sb.append("f.submit();");
            sb.append(CR);
        } else {
            sb.append("  ");
            sb.append("updateContentForm(f);");
            sb.append(CR);
        }
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    private boolean isOnChangeSubmit() {
        Presentation[] presentations = AppSchemaUtil.getPresentation(this.project, this.action);
        if (presentations == null) {
            return false;
        }
        for (Presentation presentation : presentations) {
            if (!this.isOnChangeSubmit(presentation)) continue;
            return true;
        }
        return false;
    }

    private boolean isOnChangeSubmit(Presentation presentation) {
        if (this.pmodel == null) {
            return false;
        }
        for (IModelChoice o : this.pmodel.getContent()) {
            String _onchange;
            if (!(o instanceof Modelitem)) continue;
            Modelitem p_mitem = (Modelitem)o;
            Displayitem ditem = AppSchemaUtil.getDisplayitem(p_mitem.getName(), presentation);
            String string = _onchange = ditem != null && ditem.getOnChange() != null ? ditem.getOnChange() : "";
            if (!StringUtils.isNotBlank((CharSequence)_onchange) || !StringUtils.contains((CharSequence)_onchange, (CharSequence)"submit")) continue;
            return true;
        }
        return false;
    }

    protected void gInit_changeSelectMethod(StringBuilder sb) {
        int size = this.changeSelectMethodMap.size();
        if (size == 0) {
            return;
        }
        sb.append("  ");
        sb.append("var f = document.forms;");
        sb.append(CR);
        sb.append("  ");
        sb.append("for (var i=0; i<f.length; i++) {");
        sb.append(CR);
        for (String methodname : this.changeSelectMethodMap.keySet()) {
            ChangeSelectMethod csm = this.changeSelectMethodMap.get(methodname);
            if (!csm.isContainer) {
                sb.append("    ");
                sb.append(methodname);
                sb.append("(f[i]);");
                sb.append(CR);
                continue;
            }
            this.gCallFuncInContainer(methodname, csm.labelid, csm.labelid2, sb, "f[i]");
        }
        sb.append("  ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
    }

    protected void gInit_setListeners(StringBuilder sb, String tab) {
        if (!(this.actiontype != null && ("insert".equals(this.actiontype) || "update".equals(this.actiontype) || "copy".equals(this.actiontype) || "showList".equals(this.actiontype) || "download".equals(this.actiontype)))) {
            return;
        }
        List<Modelitem> sitem_list = Arrays.asList(AppSchemaUtil.getIncludedModelitemInUpdateContent(this.project, this.cmodel));
        if (sitem_list.size() == 0) {
            return;
        }
        Set<String> callsrc_sitem_set = JavaScriptManager.getCallsrcSitemSet(this.project, this.cmodel, this.action, sitem_list);
        if (callsrc_sitem_set.size() == 0) {
            return;
        }
        sb.append(tab).append("if (window.setListeners) {").append(CR);
        sb.append(tab).append("  setListeners();").append(CR);
        sb.append(tab).append("}").append(CR);
    }

    protected void gInit_createDisableCtrlManager(StringBuilder sb, String tab) {
        if (!("insert".equals(this.actiontype) || "update".equals(this.actiontype) || "copy".equals(this.actiontype) || this.action != null && this.action.getUpdatelist())) {
            return;
        }
        this.createDcmMap();
        if (this.dcmMap.size() == 0) {
            return;
        }
        sb.append(tab).append("createCtrlDisableManager();").append(CR);
    }

    protected void createDcmMap() {
        Optional.ofNullable(AppSchemaUtil.getDataitems(this.action)).map(Arrays::stream).orElse(Stream.empty()).forEach(d -> {
            Panel bodyPanel = this.getBodyPanelIncludeConstraintItem((Dataitem)d);
            Model presentationModel = AppSchemaUtil.getModel(this.project, d.getIdref());
            Optional.ofNullable(this.getStoreModelIncludeConstraintItem(presentationModel)).ifPresent(m -> Optional.ofNullable(AppSchemaUtil.getModelitem(m)).map(Arrays::stream).orElse(Stream.empty()).forEach(i -> Optional.ofNullable(AppSchemaUtil.getConstraint(i)).filter(c -> c != null && ((Constraint[])c).length > 0).map(Arrays::stream).orElse(Stream.empty()).forEach(c -> this.addContstraint(presentationModel, (Modelitem)i, (Constraint)c, bodyPanel))));
        });
    }

    protected Model getStoreModelIncludeConstraintItem(Model presentationModel) {
        String id = presentationModel.getIdref();
        if (StringUtils.endsWith((CharSequence)id, (CharSequence)"_l")) {
            id = StringUtils.substringBeforeLast((String)id, (String)"_l");
        }
        return AppSchemaUtil.getModel(this.project, id);
    }

    protected Panel getBodyPanelIncludeConstraintItem(Dataitem dataitem) {
        Action targetAction;
        Presentation[] presentations;
        Presentation targetPresentation = this.presentation;
        if (StringUtils.isNotBlank((CharSequence)dataitem.getActionid()) && (presentations = AppSchemaUtil.getPresentation(this.project, targetAction = AppSchemaUtil.getAction(this.project, dataitem.getActionid()))) != null && presentations.length > 0) {
            targetPresentation = presentations[0];
        }
        return AppSchemaUtil.findBodyPanel(targetPresentation);
    }

    protected void addContstraint(Model presentationModel, Modelitem modelitem, Constraint constraint, Panel bodyPanel) {
        Displayitem displayitem = AppSchemaUtil.findDisplayitem(bodyPanel.getContent(), modelitem.getName());
        if (displayitem == null) {
            return;
        }
        String itemname = AppSchemaUtil.isCSSLayout(this.presentation) ? ThBodyGeneratorDisplayitem_update.getCheckboxREName(this.project, modelitem, presentationModel, displayitem) : JspBodyGeneratorDisplayitem_update.getCheckboxREName(this.project, modelitem, presentationModel, displayitem);
        if ("date".equals(modelitem.getType()) || "dateTime".equals(modelitem.getType()) || "time".equals(modelitem.getType()) || "file".equals(displayitem.getType())) {
            this.addDateTimeFileContstraint(presentationModel, modelitem, constraint, displayitem, itemname);
        } else {
            this.addDisableCtrl(constraint, presentationModel, itemname);
        }
        if ("storeref".equals(modelitem.getType()) || "masterref".equals(modelitem.getType())) {
            this.addRelationContstraint(presentationModel, modelitem, constraint, displayitem);
        } else if ("zipcode".equals(displayitem.getType())) {
            this.addDisableCtrl(constraint, presentationModel, "btnZipcode_" + modelitem.getName());
        }
    }

    protected void addDateTimeFileContstraint(Model presentationModel, Modelitem modelitem, Constraint constraint, Displayitem displayitem, String itemname) {
        Modelitem pmodelitem = AppSchemaUtil.getModelitem(modelitem.getName(), presentationModel);
        String selectinput = null;
        if (pmodelitem != null) {
            selectinput = pmodelitem.getSelectinput();
        }
        if (!AppSchemaUtil.isCSSLayout(this.presentation) && StringUtils.isNotBlank((CharSequence)selectinput)) {
            if (!constraint.getKeep()) {
                this.addDisableCtrl(constraint, presentationModel, itemname);
            }
            for (String selectinputName : ThBodyGenerator.getSelectinputItemName(itemname, selectinput)) {
                this.addDisableCtrl(constraint, presentationModel, selectinputName);
            }
        } else {
            this.addDisableCtrl(constraint, presentationModel, itemname);
        }
    }

    protected void addRelationContstraint(Model presentationModel, Modelitem modelitem, Constraint constraint, Displayitem displayitem) {
        Relation relation = AppSchemaUtil.getRelation(modelitem);
        String relationType = AppSchemaUtil.getRelationType(relation, this.project);
        String targetName = AppSchemaUtil.createNameAttribute_th(this.project, modelitem.getName(), presentationModel, true);
        String btnId = null;
        if ("search".equals(AppSchemaUtil.getRelationType(AppSchemaUtil.getRelation(modelitem), this.project))) {
            btnId = "btn_" + targetName;
        } else if ("check".equals(relationType) && "search".equals(relation.getUi())) {
            btnId = "btn_" + ThBodyGenerator.createNameAttributeValue_id(presentationModel.getId(), ThBodyGenerator.createValueOfName(displayitem, modelitem, "${__position.count}"));
        }
        if (StringUtils.isNotBlank((CharSequence)btnId)) {
            this.addDisableCtrl(constraint, presentationModel, btnId);
        }
        if (displayitem.getClear()) {
            if (AppSchemaUtil.hasChildPart(displayitem.getName())) {
                targetName = StringUtils.replace((String)targetName, (String)"_005b1_005d_002f_0040id", (String)"");
            }
            this.addDisableCtrl(constraint, presentationModel, "btnClear_" + targetName);
        }
    }

    protected String gCreateDisableCtrlManager() {
        if (this.dcmMap.size() == 0) {
            return "";
        }
        boolean isSrcTargetContainerItem = false;
        boolean isKeepValue = false;
        boolean isSrcNodeReadonly = false;
        StringBuilder sb = new StringBuilder();
        StringBuilder dcmJsCode = new StringBuilder();
        sb.append("function createCtrlDisableManager() {").append(CR);
        sb.append("  ").append("require([\"dojo/aspect\", \"dojo/dom\", \"dojo/query\", \"dojo/ready\"], function(aspect, dom, query, ready) {").append(CR);
        sb.append("    ").append("ready(function() {").append(CR);
        if (this.action.getUpdatelist()) {
            sb.append("      ").append("var srcCtrlNameSet;").append(CR);
        }
        int count = 1;
        for (String key : this.dcmMap.keySet()) {
            DisableCtrlManager dcm = this.dcmMap.get(key);
            dcmJsCode.append(dcm.getJavaScriptCode(String.valueOf(count++)));
            if (dcm.isContainerItem) {
                isSrcTargetContainerItem = true;
            }
            if (dcm.isKeepValue()) {
                isKeepValue = true;
            }
            if (dcm.ditem == null || !dcm.ditem.getReadonly()) continue;
            isSrcNodeReadonly = true;
        }
        if (isSrcTargetContainerItem) {
            sb.append("      ").append("var name");
            if (isSrcNodeReadonly) {
                sb.append(", id");
            }
            sb.append(";").append(CR);
        }
        sb.append(dcmJsCode.toString());
        if (isKeepValue) {
            sb.append(this.gKeepValueDisableCtrlBeforeSubmit());
        }
        sb.append("    ").append("});").append(CR);
        sb.append("  ").append("});").append(CR);
        sb.append("}").append(CR).append(CR);
        return sb.toString();
    }

    protected String gKeepValueDisableCtrlBeforeSubmit() {
        String formName = JspPanelContentBase.createActionId(this.action, this.action.getIdref()) + "_p";
        StringBuilder sb = new StringBuilder();
        sb.append(CR);
        sb.append("      ").append("var form = dom.byId(\"").append(formName).append("\");").append(CR);
        sb.append("      ").append("if (!form) {").append(CR);
        sb.append("        ").append("return;").append(CR);
        sb.append("      ").append("}").append(CR);
        sb.append("      ").append("aspect.before(form, \"submit\", function() {").append(CR);
        sb.append("        ").append("if (form.SENDACTION && form.SENDACTION.name && (form.SENDACTION.name === \"SENDACTION\" ||").append(CR);
        sb.append("            ").append("form.SENDACTION.name.lastIndexOf(\"action_Clear\", 0) === 0) ||").append(CR);
        sb.append("            ").append("document.querySelector(\"input[type='hidden'][name^='action_Clear']\")) {").append(CR);
        sb.append("          ").append("doSubmit(form, true);").append(CR);
        sb.append("        ").append("}").append(CR);
        sb.append("      ").append("});").append(CR);
        return sb.toString();
    }

    protected void gInit_createTabManager(StringBuilder sb, String tab) {
        if (!this.isTabLayoutUsed()) {
            return;
        }
        sb.append(tab).append("createTabManager(tabSettings);").append(CR);
    }

    protected String gCreateTabManager() {
        if (!this.isTabLayoutUsed()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("function createTabManager(tabSettings) {").append(CR);
        sb.append("  ").append("require([\"dojo/ready\", \"wagby/TabManager\"], function(ready, TabManager) {").append(CR);
        sb.append("    ").append("ready(function() {").append(CR);
        sb.append("      ").append("(new TabManager(tabSettings)).init();").append(CR);
        sb.append("    ").append("});").append(CR);
        sb.append("  ").append("});").append(CR);
        sb.append("}").append(CR);
        return sb.toString();
    }

    protected boolean isTabLayoutUsed() {
        if (this.action == null) {
            return false;
        }
        if (!("insert".equals(this.action.getType()) || "update".equals(this.action.getType()) || "copy".equals(this.action.getType()) || "show".equals(this.action.getType()))) {
            return false;
        }
        return AppSchemaUtil.isTablayoutUsed(this.action.getIdref(), this.project);
    }

    private void gInit_focusFirstElement(StringBuilder sb, String tab) {
        String labelid = null;
        if (this.pmodel != null) {
            for (IModelChoice o : this.pmodel.getContent()) {
                Modelitem p_mitem;
                Displayitem ditem;
                if (!(o instanceof Modelitem) || (ditem = AppSchemaUtil.getDisplayitem((p_mitem = (Modelitem)o).getName(), this.presentation)) == null || !ditem.getFocusFirstElement()) continue;
                labelid = AppSchemaUtil.createNameAttribute(this.project, p_mitem.getName(), this.pmodel);
                if (labelid.indexOf("${__position.count}") <= 0) break;
                labelid = StringUtil.replace((String)labelid, (String)"${__position.count}", (String)"1");
                break;
            }
        }
        if (labelid == null) {
            if (!this.presentation.getEnableFocusFirstElement()) {
                return;
            }
            sb.append(tab).append("focusFirstElement();").append(CR);
        } else {
            sb.append(tab).append("var e = document.getElementById('").append(labelid).append("');").append(CR);
            sb.append(tab).append("if (e != null) {").append(CR);
            sb.append(tab).append("  ").append("e.focus();").append(CR);
            sb.append(tab).append("} else {").append(CR);
            sb.append(tab).append("  ").append("focusFirstElement();").append(CR);
            sb.append(tab).append("}").append(CR);
        }
    }

    private void gCallFuncInContainer(String methodname, String label1, String label2, StringBuilder sb, String formvariable) {
        sb.append("    ");
        sb.append("var count_" + methodname + " = 1;");
        sb.append(CR);
        sb.append("    ");
        sb.append("for (var j=0; j<" + formvariable + ".length; j++) {");
        sb.append(CR);
        sb.append("      ");
        sb.append("var e = " + formvariable + ".elements[j];");
        sb.append(CR);
        sb.append("      ");
        sb.append("if (e.name != null && e.name.indexOf(\"" + label1 + "\") == 0 && ");
        sb.append("endsWith(e.name, \"" + label2 + "\"))");
        sb.append(CR);
        sb.append("        ");
        sb.append("count_" + methodname + "++;");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append("    ");
        sb.append("for (var pos=1; pos<count_" + methodname + "+1; pos++) {");
        sb.append(CR);
        sb.append("      ");
        sb.append(methodname);
        sb.append("(" + formvariable + ", pos);");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
    }

    protected String gUpdateContent_empty() {
        StringBuilder sb = new StringBuilder();
        String templatefilename = TemplatefilenameBase + "__javascript_updateContent_empty.html";
        FileTemplateManager tplman = new FileTemplateManager(templatefilename, TemplatefileCharEncoding);
        sb.append(tplman.getResult());
        return sb.toString();
    }

    private boolean isChangeAjaxElement() {
        boolean isChangeAjaxElement = false;
        Environment env = this.project.getEnvironment();
        if (env != null) {
            isChangeAjaxElement = env.getChangeAjaxElement();
        }
        return isChangeAjaxElement;
    }

    public static Set<String> getCallsrcSitemSet(Project project, Model cmodel, Action action, List<Modelitem> sitem_list) {
        boolean isChangeCallsrcSitemSet;
        boolean isUpdateList;
        Presentation[] presentations = AppSchemaUtil.getPresentation(project, action);
        ArrayList<Modelitem> hidden_sitem_list = new ArrayList<Modelitem>();
        Model targetmodel = cmodel;
        boolean bl = isUpdateList = action != null ? action.getUpdatelist() : false;
        if (isUpdateList) {
            targetmodel = AppSchemaUtil.getModel(project, AppSchemaUtil.getStoreModel(cmodel).getId() + "_ulp");
        }
        Iterator<Modelitem> sitem_ite = sitem_list.iterator();
        HashSet<String> callsrc_sitem_set = new HashSet<String>();
        while (sitem_ite.hasNext()) {
            Object ditem;
            boolean isHidden;
            Modelitem sitem = sitem_ite.next();
            String mitemname = sitem.getName();
            if (cmodel.getType().equals("condition")) {
                isHidden = true;
                for (Presentation presentation : presentations) {
                    Displaycondition displaycondition = AppSchemaUtil.findDisplaycondition(presentation);
                    if (displaycondition == null) continue;
                    if ("modernCalendar".equals(displaycondition.getType())) {
                        displaycondition = JavaScriptManager.getModernCalendarviewCondition(project, action);
                    }
                    if ((ditem = AppSchemaUtil.getDisplayitem(mitemname, displaycondition)) == null || AppSchemaUtil.isHiddenDisplayitem((Displayitem)ditem)) continue;
                    isHidden = false;
                    break;
                }
                if (isHidden) {
                    hidden_sitem_list.add(sitem);
                    continue;
                }
            } else {
                isHidden = true;
                block2: for (Presentation presentation : presentations) {
                    List<Displayitem> ditems = AppSchemaUtil.getDisplayitemList(mitemname, presentation, targetmodel);
                    ditem = ditems.iterator();
                    while (ditem.hasNext()) {
                        Displayitem ditem1 = ditem.next();
                        if (ditem1 == null || AppSchemaUtil.isHiddenDisplayitem(ditem1) && !JavaScriptManager.isRestrictItem(targetmodel, sitem)) continue;
                        isHidden = false;
                        break block2;
                    }
                }
                if (isHidden) {
                    hidden_sitem_list.add(sitem);
                    continue;
                }
            }
            JavaScriptManager.addCallsrcSitem(project, targetmodel, callsrc_sitem_set, sitem);
        }
        do {
            isChangeCallsrcSitemSet = false;
            Iterator hidden_sitem_it = hidden_sitem_list.iterator();
            while (hidden_sitem_it.hasNext()) {
                Modelitem hidden_sitem = (Modelitem)hidden_sitem_it.next();
                if (callsrc_sitem_set.contains(hidden_sitem.getName())) continue;
                hidden_sitem_it.remove();
                JavaScriptManager.addCallsrcSitem(project, targetmodel, callsrc_sitem_set, hidden_sitem);
                isChangeCallsrcSitemSet = true;
            }
        } while (isChangeCallsrcSitemSet);
        HashSet<String> needsReloadSuggestItems = new HashSet<String>();
        ArrayList<String> suggestItems = new ArrayList<String>();
        for (String itemName : callsrc_sitem_set) {
            Modelitem sitem = null;
            for (Modelitem mitem : sitem_list) {
                if (!itemName.equals(mitem.getName())) continue;
                sitem = mitem;
                break;
            }
            if (!AppSchemaUtil.isMitemSuggest(sitem, project)) continue;
            Model refmodel = AppSchemaUtil.getModel(project, AppSchemaUtil.getStoreModel(cmodel).getId());
            Modelitem __refitem = null;
            Modelitem[] refitems = AppSchemaUtil.getModelitem_InRefRelation(refmodel, sitem);
            if (refitems != null) {
                for (int k = 0; k < refitems.length; ++k) {
                    if (!AppSchemaUtil.hasChildPart(sitem.getName()) || !AppSchemaUtil.hasChildPart(refitems[k].getName())) continue;
                    __refitem = refitems[k];
                    break;
                }
            }
            if (AppSchemaUtil.needsReload(project, refmodel, sitem) && __refitem == null) {
                needsReloadSuggestItems.add(itemName);
                continue;
            }
            suggestItems.add(itemName);
        }
        callsrc_sitem_set.removeAll(needsReloadSuggestItems);
        Iterator<String> callsrc_sitem_ite = callsrc_sitem_set.iterator();
        block9: while (callsrc_sitem_ite.hasNext()) {
            String callsrc_sitem_name = callsrc_sitem_ite.next();
            for (Presentation presentation : presentations) {
                String _onchange;
                Displayitem ditem = AppSchemaUtil.getDisplayitem(callsrc_sitem_name, presentation);
                String string = _onchange = ditem != null && ditem.getOnChange() != null ? ditem.getOnChange() : "";
                if (!StringUtils.isNotBlank((CharSequence)_onchange) || !StringUtils.contains((CharSequence)_onchange, (CharSequence)"submit") || suggestItems.contains(callsrc_sitem_name)) continue;
                callsrc_sitem_ite.remove();
                continue block9;
            }
        }
        return callsrc_sitem_set;
    }

    private static boolean isRestrictItem(Model cmodel, Modelitem sitem) {
        Relation rel;
        if ("storeref".equals(sitem.getType()) && (rel = AppSchemaUtil.getRelationTypeExceptRef(sitem)) != null) {
            Modelitem restrict_sitem;
            String restrict = rel.getRestrict();
            if (restrict != null && (restrict_sitem = AppSchemaUtil.getModelitem(restrict, cmodel)) != null) {
                return true;
            }
            Restrictparamlist paramlist = rel.getRestrictparamlist();
            if (paramlist != null) {
                for (Restrictparam param : paramlist.getRestrictparam()) {
                    String src = param.getSource();
                    Modelitem restrict_sitem2 = AppSchemaUtil.getModelitem(src, cmodel);
                    if (restrict_sitem2 == null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static void addCallsrcSitem(Project project, Model cmodel, HashSet<String> callsrc_sitem_set, Modelitem sitem) {
        Relation rel;
        String relateditem_mitem_name;
        Modelitem refsrc_sitem;
        Relation relation;
        Autocalc autocalc = AppSchemaUtil.getAutocalc(sitem);
        if (autocalc != null) {
            AppSchemaUtil.setAutocalcReferenceModelitemName(project, cmodel, autocalc, callsrc_sitem_set);
        }
        if ("storeref".equals(sitem.getType()) && (relation = AppSchemaUtil.getRelationTypeIsRef(sitem)) != null && (refsrc_sitem = AppSchemaUtil.getModelitem(relateditem_mitem_name = relation.getRelateditem(), cmodel)) != null && !AppSchemaUtil.needsReload(project, cmodel, refsrc_sitem)) {
            callsrc_sitem_set.add(refsrc_sitem.getName());
        }
        if ("storeref".equals(sitem.getType()) && AppSchemaUtil.getModelitem(sitem.getName(), cmodel) != null && (rel = AppSchemaUtil.getRelationTypeExceptRef(sitem)) != null) {
            Restrictparamlist paramlist;
            Modelitem restrict_sitem;
            String restrict = rel.getRestrict();
            if (restrict != null && (restrict_sitem = AppSchemaUtil.getModelitem(restrict, cmodel)) != null) {
                callsrc_sitem_set.add(restrict_sitem.getName());
            }
            if ((paramlist = rel.getRestrictparamlist()) != null) {
                for (Restrictparam param : paramlist.getRestrictparam()) {
                    String src = param.getSource();
                    Modelitem restrict_sitem2 = AppSchemaUtil.getModelitem(src, cmodel);
                    if (restrict_sitem2 == null) continue;
                    callsrc_sitem_set.add(restrict_sitem2.getName());
                }
            }
        }
        if (AppSchemaUtil.isMitemSuggest(sitem, project)) {
            callsrc_sitem_set.add(sitem.getName());
        }
        ArrayList<String> list = null;
        for (String s : callsrc_sitem_set) {
            Relation _rel;
            Modelitem _mitem;
            if (s.endsWith("#id")) {
                s = s.substring(0, s.length() - "#id".length());
            } else if (s.endsWith("#content")) {
                s = s.substring(0, s.length() - "#content".length());
            } else if (s.endsWith("#array")) {
                s = s.substring(0, s.length() - "#array".length());
            }
            if ((_mitem = AppSchemaUtil.getModelitem(s, cmodel)) == null || (_rel = AppSchemaUtil.getRelationTypeIsRef(_mitem)) == null || _rel.getRelateditem() == null) continue;
            if (list == null) {
                list = new ArrayList<String>();
            }
            list.add(_rel.getRelateditem());
        }
        if (list != null) {
            callsrc_sitem_set.addAll(list);
        }
    }

    private static Displaycondition getModernCalendarviewCondition(Project project, Action action) {
        if (project == null || action == null) {
            return null;
        }
        String showListActionId = StringUtils.substringBefore((String)action.getId(), (String)"Calendarview");
        Action showListAction = AppSchemaUtil.getAction(project, showListActionId);
        if (showListAction == null) {
            return null;
        }
        Presentation[] presentations = AppSchemaUtil.getPresentation(project, showListAction);
        if (presentations == null || presentations.length == 0) {
            return null;
        }
        for (Presentation presentation : presentations) {
            Displaycondition displaycondition = AppSchemaUtil.findDisplaycondition(presentation);
            if (displaycondition == null) continue;
            return displaycondition;
        }
        return null;
    }

    protected String gUpdateContent() {
        String idref;
        Presentation[] presentations;
        StringBuilder sb = new StringBuilder();
        if (!(this.actiontype != null && ("insert".equals(this.actiontype) || "update".equals(this.actiontype) || "copy".equals(this.actiontype) || "showList".equals(this.actiontype) || "download".equals(this.actiontype)))) {
            return this.gUpdateContent_empty();
        }
        List<Modelitem> sitem_list = Arrays.asList(AppSchemaUtil.getIncludedModelitemInUpdateContent(this.project, this.cmodel));
        if (sitem_list.size() == 0) {
            return this.gUpdateContent_empty();
        }
        Set<String> callsrc_sitem_set = JavaScriptManager.getCallsrcSitemSet(this.project, this.cmodel, this.action, sitem_list);
        if (callsrc_sitem_set.size() == 0) {
            return this.gUpdateContent_empty();
        }
        sb.append("");
        sb.append("var updateContent_text;");
        sb.append(CR);
        sb.append(CR);
        boolean isChangeAjaxElement = this.isChangeAjaxElement();
        Modelitem __refitem = this.gUpdateContent_updateContent(sb, callsrc_sitem_set, isChangeAjaxElement);
        sb.append(CR);
        if (isChangeAjaxElement) {
            this.gUpdateContent_changeUpdateBgcolor(sb);
            sb.append(CR);
            this.gUpdateContent_failedUpdateContentHttpRequest(sb);
            sb.append(CR);
            this.gUpdateContent_setBgcolor(sb, sitem_list, __refitem);
            sb.append(CR);
        } else {
            this.gUpdateContent_failedUpdateContentHttpRequest_empty(sb);
            sb.append(CR);
        }
        Presentation targetPresentation = null;
        for (Presentation presentation : presentations = AppSchemaUtil.getPresentation(this.project, this.action)) {
            idref = presentation.getIdref();
            if (!idref.startsWith("insert") && !idref.startsWith("update")) continue;
            targetPresentation = presentation;
            break;
        }
        if (targetPresentation == null) {
            for (Presentation presentation : presentations) {
                idref = presentation.getIdref();
                if (!idref.startsWith("show")) continue;
                targetPresentation = presentation;
                break;
            }
        }
        boolean isNeedIgnoreAutocompleteForSearchItemChangeEvent = this.gIgnoreAutocompleteForSearchItemChangeEvent(sb, sitem_list, this.presentation);
        this.gUpdateContent_setResponseXMLContent(sb, sitem_list, __refitem, this.presentation, isNeedIgnoreAutocompleteForSearchItemChangeEvent);
        sb.append(CR);
        if (isChangeAjaxElement) {
            this.gUpdateContent_originalArray(sb);
            this.gUpdateContent_setBgcolor_id(sb);
            sb.append(CR);
        }
        this.gUpdateContent_setResponseXMLContent_id(sb);
        sb.append(CR);
        this.gUpdateContent_setResponseXMLContent_value(sb, isChangeAjaxElement);
        sb.append(CR);
        this.gUpdateContent_setResponseXMLContent_combo(sb);
        sb.append(CR);
        this.gUpdateContent_setResponseXMLContent_radio(sb);
        sb.append(CR);
        this.gUpdateContent_setResponseXMLContent_check(sb);
        sb.append(CR);
        this.gUpdateContent_setResponseXMLContent_search(sb);
        sb.append(CR);
        this.gUpdateContent_setListeners(sb, callsrc_sitem_set);
        sb.append(CR);
        this.gUpdateContent_setListeners_updateContent(sb);
        sb.append(CR);
        if (this.isExistsEnter2TabSetting()) {
            sb.append("").append("var enterKeyHandler;").append(CR);
        }
        return sb.toString();
    }

    private Modelitem gUpdateContent_updateContent(StringBuilder sb, Set<String> callsrc_sitem_set, boolean isChangeAjaxElement) {
        String templatefilename = TemplatefilenameBase + "__javascript_updateContent.html";
        FileTemplateManager tplman = new FileTemplateManager(templatefilename, TemplatefileCharEncoding);
        ArrayList<String> callsrc_sitem_list = new ArrayList<String>(callsrc_sitem_set);
        Collections.sort(callsrc_sitem_list);
        ArrayList<String> notsameInputValueModelitemList = new ArrayList<String>(callsrc_sitem_list);
        notsameInputValueModelitemList.retainAll(this.notsameInputValueModelitemSet);
        if (notsameInputValueModelitemList.size() > 0) {
            StringBuilder sb1 = new StringBuilder();
            this.gCheckElementNameIf(sb1, notsameInputValueModelitemList, "        ", "elem.name");
            tplman.setContent("isNotsameInputValueModelitemIfCode", "true");
            tplman.setContent("notsameInputValueModelitemIfCode", sb1.toString());
        } else {
            tplman.setContent("isNotsameInputValueModelitemIfCode", "");
            tplman.setContent("notsameInputValueModelitemIfCode", "");
        }
        StringBuilder sb2 = new StringBuilder();
        Modelitem __refitem = this.gCheckElementNameIf(sb2, callsrc_sitem_list, "    ", "text.name");
        tplman.setContent("ifCode", sb2.toString());
        tplman.setContent("checkDisabledCode", this.gUpdateContentCheckDisabled());
        if (isChangeAjaxElement) {
            tplman.setContent("isChangeAjaxElement", "true");
        } else {
            tplman.setContent("isChangeAjaxElement", "");
        }
        tplman.setUseCommandFeature(true);
        sb.append(tplman.getResult());
        return __refitem;
    }

    private String gUpdateContentCheckDisabled() {
        StringBuilder csb = new StringBuilder();
        if (this.cancelConstraintMap.size() > 0 && this.actiontype != null && (this.actiontype.startsWith("insert") || this.actiontype.startsWith("copy") || this.actiontype.startsWith("update"))) {
            String loopCountStr = "${__position.count}";
            if (AppSchemaUtil.isCSSLayout(this.presentation)) {
                loopCountStr = TH_CONTAINER_LOOP_INDEX;
            }
            Iterator<String> it = this.cancelConstraintMap.keySet().iterator();
            csb.append("            ");
            csb.append("var disabledFlag = true;");
            csb.append(CR);
            boolean isfirst = true;
            while (it.hasNext()) {
                Object name = it.next();
                if (StringUtils.contains((CharSequence)name, (CharSequence)loopCountStr) && !((String)(name = StringUtils.replace((String)name, (String)loopCountStr, (String)"\\d+"))).startsWith("/^")) {
                    name = "/^" + (String)name + "$/";
                }
                csb.append("            ");
                if (isfirst) {
                    isfirst = false;
                } else {
                    csb.append("} else ");
                }
                csb.append("if (elem.name");
                if (StringUtils.startsWith((CharSequence)name, (CharSequence)"/") && StringUtils.endsWith((CharSequence)name, (CharSequence)"/")) {
                    csb.append(".match(").append((String)name).append(")");
                } else {
                    csb.append(" == \"").append((String)name).append("\"");
                }
                csb.append(") {");
                csb.append(CR);
                csb.append("                ");
                csb.append("disabledFlag = false;");
                csb.append(CR);
            }
            csb.append("            ");
            csb.append("}");
            csb.append(CR);
            csb.append("            ");
            csb.append("if (disabledFlag) {");
            csb.append(CR);
            csb.append("                ");
            csb.append("continue;");
            csb.append(CR);
            csb.append("            ");
            csb.append("}");
            csb.append(CR);
        } else {
            csb.append("            ");
            csb.append("continue;");
            csb.append(CR);
        }
        return csb.toString();
    }

    private Modelitem gCheckElementNameIf(StringBuilder sb, List<String> callsrc_sitem_list, String tab, String varname) {
        Iterator<String> callsrc_sitem_ite = callsrc_sitem_list.iterator();
        boolean isFirst_callsrc_sitem = true;
        Modelitem __refitem = null;
        while (callsrc_sitem_ite.hasNext()) {
            IModelChoice[] n_labelid;
            String callsrc_sitem_name = callsrc_sitem_ite.next();
            String labelid = AppSchemaUtil.createNameAttribute(this.project, callsrc_sitem_name, this.cpmodel);
            if (isFirst_callsrc_sitem) {
                sb.append(tab).append("if (").append(varname).append(" && ");
                isFirst_callsrc_sitem = false;
            } else {
                sb.append(" &&");
                sb.append(CR);
                sb.append(tab + "    ");
            }
            Modelitem callsrc_sitem = AppSchemaUtil.getModelitem(callsrc_sitem_name, this.cmodel);
            boolean isCheckbox = AppSchemaUtil.isCheckRelation(callsrc_sitem, this.project, null);
            if (labelid.indexOf("${__position.count}") > 0) {
                sb.append("!");
                sb.append(varname);
                sb.append(".match(/^");
                n_labelid = labelid.replace("${__position.count}", "[0-9]+").replace("$", "\\$").replace(")", "");
                if (isCheckbox) {
                    n_labelid = n_labelid.replace("${fn:escapeXml(c.id}", "-?\\w+");
                }
                sb.append((String)n_labelid);
                sb.append("$/)");
                continue;
            }
            if (callsrc_sitem != null && callsrc_sitem.getMultiple()) {
                sb.append("!");
                sb.append(varname);
                sb.append(".match(/^");
                sb.append(labelid.replace("$", "\\$").replace(")", ""));
                sb.append(StringUtil.convertHtmlIdString((String)"[") + "[0-9]+" + StringUtil.convertHtmlIdString((String)"]"));
                __refitem = null;
                block1: for (IModelChoice imc : this.cmodel.getContent()) {
                    Modelitem[] refitems;
                    Modelitem __mitem;
                    if (!(imc instanceof Modelitem) || !(__mitem = (Modelitem)imc).getName().startsWith(callsrc_sitem.getName() + "/") || (refitems = AppSchemaUtil.getModelitem_InRefRelation(this.smodel, __mitem)) == null) continue;
                    for (int k = 0; k < refitems.length; ++k) {
                        if (!AppSchemaUtil.hasChildPart(__mitem.getName()) || !AppSchemaUtil.hasChildPart(refitems[k].getName())) continue;
                        __refitem = __mitem;
                        break block1;
                    }
                }
                if (__refitem == null) {
                    sb.append(StringUtil.convertHtmlIdString((String)"/@") + "content");
                } else {
                    sb.append(StringUtil.convertHtmlIdString((String)"/")).append(AppSchemaUtil.getChildPart(__refitem.getName()));
                }
                sb.append("$/)");
                continue;
            }
            if (callsrc_sitem != null && "dateTime".equals(callsrc_sitem.getType())) {
                String name = labelid.replace(")", "");
                sb.append(varname).append(" != '").append(name).append("_DateTextBox").append("' &&").append(CR).append(tab).append("    ").append(varname).append(" != '").append(name).append("_TimeTextBox").append("'");
                continue;
            }
            if (!isCheckbox) {
                sb.append(varname);
                sb.append(" != '");
                sb.append(labelid.replace(")", ""));
                sb.append("'");
                continue;
            }
            sb.append("!");
            sb.append(varname);
            sb.append(".match(/^");
            n_labelid = labelid.replace("$", "\\$").replace(")", "").replace("${fn:escapeXml(c.id}", "-?\\w+").replace(StringUtil.convertHtmlIdString((String)"[") + "\\[0-9]+", StringUtil.convertHtmlIdString((String)"[") + "[0-9]+");
            sb.append((String)n_labelid);
            sb.append("$/)");
        }
        sb.append(")");
        sb.append(CR);
        return __refitem;
    }

    private void gUpdateContent_changeUpdateBgcolor(StringBuilder sb) {
        String templatefilename = TemplatefilenameBase + "__javascript_changeUpdateBgcolor.html";
        FileTemplateManager tplman = new FileTemplateManager(templatefilename, TemplatefileCharEncoding);
        sb.append(tplman.getResult());
    }

    private void gUpdateContent_failedUpdateContentHttpRequest(StringBuilder sb) {
        String templatefilename = TemplatefilenameBase + "__javascript_failedUpdateContentHttpXMLRequest.html";
        FileTemplateManager tplman = new FileTemplateManager(templatefilename, TemplatefileCharEncoding);
        sb.append(tplman.getResult());
    }

    private void gUpdateContent_failedUpdateContentHttpRequest_empty(StringBuilder sb) {
        String templatefilename = TemplatefilenameBase + "__javascript_failedUpdateContentHttpXMLRequest_empty.html";
        FileTemplateManager tplman = new FileTemplateManager(templatefilename, TemplatefileCharEncoding);
        sb.append(tplman.getResult());
    }

    private void gUpdateContent_setBgcolor(StringBuilder sb, List<Modelitem> sitem_list, Modelitem __refitem) {
        sb.append("");
        sb.append("function setBgcolor(color, footer) {");
        sb.append(CR);
        for (Modelitem sitem : sitem_list) {
            Relation rel = AppSchemaUtil.getRelationTypeExceptRef(sitem);
            if (rel == null) {
                rel = AppSchemaUtil.getRelatedRelationInCaseofTypeRef(this.smodel, sitem);
            }
            if (rel != null) continue;
            if (AppSchemaUtil.hasChildPart(sitem.getName())) {
                this.gUpdateContent_multiple_setBgcolor_id(sb, sitem, 0);
                continue;
            }
            String labelid = AppSchemaUtil.createNameAttribute(this.project, sitem.getName(), this.cpmodel);
            sb.append("    ");
            sb.append("setBgcolor_id(");
            sb.append(CR);
            sb.append("        ");
            sb.append("'content_" + labelid + "',");
            sb.append(CR);
            sb.append("        ");
            sb.append("'" + labelid + "',");
            sb.append(CR);
            sb.append("        ");
            sb.append("color, footer);");
            sb.append(CR);
        }
        if (__refitem != null) {
            Modelitem[] refitems = AppSchemaUtil.getModelitem_InRefRelation(this.cmodel, __refitem);
            for (int k = 0; k < refitems.length; ++k) {
                this.gUpdateContent_multiple_setBgcolor_id(sb, refitems[k], k);
            }
        }
        sb.append("");
        sb.append("}");
        sb.append(CR);
    }

    private boolean isResrictHiddenModelitem(String mitemname) {
        return this.isRestrictHiddenModelitem(mitemname, this.presentation);
    }

    private boolean isRestrictHiddenModelitem(String mitemname, Presentation presentation) {
        List<Displayitem> ditems;
        if (this.cmodel.getType().equals("condition")) {
            Displaycondition dc = AppSchemaUtil.findDisplaycondition(presentation);
            if (dc != null && "modernCalendar".equals(dc.getType())) {
                dc = JavaScriptManager.getModernCalendarviewCondition(this.project, this.action);
            }
            ditems = new ArrayList<Displayitem>();
            ditems.add(AppSchemaUtil.getDisplayitem(mitemname, dc));
        } else {
            ditems = AppSchemaUtil.getDisplayitemList(mitemname, presentation, this.cmodel);
        }
        for (Displayitem ditem1 : ditems) {
            if (ditem1 == null || AppSchemaUtil.isHiddenDisplayitem(ditem1) || ditem1.getReadonly()) continue;
            return false;
        }
        return true;
    }

    private boolean gIgnoreAutocompleteForSearchItemChangeEvent(StringBuilder sb, List<Modelitem> sitem_list, Presentation presentation) {
        Action action = AppSchemaUtil.getAction(this.project, presentation);
        if (!"showList".equals(action.getType()) && !"download".equals(action.getType())) {
            return false;
        }
        ArrayList<CallSite> autocompleteForSearchItems = new ArrayList<CallSite>();
        if (sitem_list == null) {
            return false;
        }
        for (Modelitem sitem : sitem_list) {
            String displayfield;
            Relation rel = AppSchemaUtil.getRelationTypeIsRef(sitem);
            if (rel == null || !"ref".equals(rel.getType()) || !"thismodel".equals(rel.getRefstoretype())) continue;
            String doClearFuncName = "doClear" + SourceGenerator.capFirst(rel.getRelateditem());
            Displayitem ditem = AppSchemaUtil.getDisplayitem(sitem.getName(), AppSchemaUtil.findDisplaycondition(presentation));
            if (ditem == null || !StringUtils.contains((CharSequence)ditem.getOnChange(), (CharSequence)doClearFuncName)) continue;
            String labelid = AppSchemaUtil.createNameAttribute(this.project, sitem.getName(), this.cpmodel);
            if (JavaSourceGenerator.isStringType(sitem.getType()) && presentation != null && StringUtils.isNotBlank((CharSequence)(displayfield = ditem.getDisplayfield()))) {
                labelid = AppSchemaUtil.createNameAttribute(this.project, displayfield, this.cpmodel);
            }
            autocompleteForSearchItems.add((CallSite)((Object)("\"" + labelid + "\"")));
        }
        if (autocompleteForSearchItems.size() == 0) {
            return false;
        }
        sb.append("").append("function setAutocompleteForSearchItemChangeEvent(disabled) {").append(CR);
        sb.append("  ").append("require(['dijit/registry'], function(registry) {").append(CR);
        sb.append("    ").append("var autocompleteForSearchItems = [").append(StringUtils.join((Object[])autocompleteForSearchItems.toArray(), (String)",")).append("];").append(CR);
        sb.append("    ").append("for(var i=0,l=autocompleteForSearchItems.length; i<l; i++) {").append(CR);
        sb.append("      ").append("var widget = registry.byId(autocompleteForSearchItems[i]);").append(CR);
        sb.append("      ").append("if (widget) {").append(CR);
        sb.append("        ").append("widget.set('_onChangeActive', disabled);").append(CR);
        sb.append("      ").append("}").append(CR);
        sb.append("    ").append("}").append(CR);
        sb.append("  ").append("});").append(CR);
        sb.append("").append("}").append(CR);
        sb.append(CR);
        return true;
    }

    private void gUpdateContent_setResponseXMLContent(StringBuilder sb, List<Modelitem> sitem_list, Modelitem __refitem, Presentation presentation, boolean isNeedIgnoreAutocompleteForSearchItemChangeEvent) {
        sb.append("").append("function setResponseXMLContent(xml) {").append(CR);
        sb.append("    ").append("buttonOn();").append(CR);
        sb.append("    ").append("if (!xml) {").append(CR);
        sb.append("        ").append("requestTimerId = null;").append(CR);
        sb.append("        ").append("return;").append(CR);
        sb.append("    ").append("}").append(CR);
        sb.append("    ").append("var xmlnode, param;").append(CR);
        if (isNeedIgnoreAutocompleteForSearchItemChangeEvent) {
            sb.append("    ").append("setAutocompleteForSearchItemChangeEvent(false);").append(CR).append(CR);
        }
        ArrayList<String> containerNameList = new ArrayList<String>();
        for (Modelitem sitem : sitem_list) {
            String displayfield;
            Displayitem ditem;
            Relation rel = AppSchemaUtil.getRelationTypeExceptRef(sitem);
            if (rel == null) {
                rel = AppSchemaUtil.getRelatedRelationInCaseofTypeRef(this.smodel, sitem);
            }
            if (rel != null) {
                if (AppSchemaUtil.hasChildPart(sitem.getName())) {
                    String pname = AppSchemaUtil.getParentPart(sitem.getName());
                    if (containerNameList.contains(pname)) continue;
                    containerNameList.add(pname);
                    continue;
                }
                this.gUpdateContentSetResponseXMLContentRelation(sb, sitem, rel);
                continue;
            }
            if (AppSchemaUtil.hasChildPart(sitem.getName())) {
                this.gUpdateContent_multiple_setResponseXMLContent_value(sb, sitem, 0);
                continue;
            }
            String labelid = AppSchemaUtil.createNameAttribute(this.project, sitem.getName(), this.cpmodel);
            if (JavaSourceGenerator.isStringType(sitem.getType()) && presentation != null && (ditem = AppSchemaUtil.getDisplayitem(sitem.getName(), presentation)) != null && StringUtils.isNotBlank((CharSequence)(displayfield = ditem.getDisplayfield()))) {
                labelid = AppSchemaUtil.createNameAttribute(this.project, displayfield, this.cpmodel);
            }
            sb.append("    ");
            sb.append("setResponseXMLContent_id(xml,");
            sb.append(CR);
            sb.append("        ");
            sb.append("'" + sitem.getName() + "',");
            sb.append(CR);
            sb.append("        ");
            sb.append("'content_" + labelid + "',");
            sb.append(CR);
            sb.append("        ");
            sb.append("'" + labelid + "');");
            sb.append(CR);
            Modelitem pitem = AppSchemaUtil.getModelitem(sitem.getName(), this.pmodel);
            String selectinput = pitem.getSelectinput();
            if (selectinput == null) continue;
            Modelitem refmitem = AppSchemaUtil.getRelatedModelitemInCaseofTypeRef(this.project, this.smodel.getId(), sitem);
            String type = refmitem.getType();
            if (type.equals("date") || type.equals("dateTime")) {
                sb.append("    ").append("if (window.setDate_").append(labelid).append(") {").append(CR);
                sb.append("      ").append("setDate_").append(labelid).append("(updateContent_textform);").append(CR);
                sb.append("    ").append("}").append(CR);
                continue;
            }
            if (!type.equals("time")) continue;
            sb.append("    ").append("if (window.setTime_").append(labelid).append(") {").append(CR);
            sb.append("      ").append("setTime_").append(labelid).append("();").append(CR);
            sb.append("    ").append("}").append(CR);
        }
        if (__refitem != null) {
            Modelitem[] refitems = AppSchemaUtil.getModelitem_InRefRelation(this.cmodel, __refitem);
            for (int k = 0; k < refitems.length; ++k) {
                this.gUpdateContent_multiple_setResponseXMLContent_value(sb, refitems[k], k);
            }
        }
        for (String containerName : containerNameList) {
            Iterator<Modelitem> sitem_ite = sitem_list.iterator();
            sb.append("    ").append("var xmlnode_").append(containerName).append(" = xml.getElementsByTagName('");
            Action action = AppSchemaUtil.getAction(this.project, presentation);
            if ("showList".equals(action.getType()) || "download".equals(action.getType())) {
                Model model = AppSchemaUtil.getConditionPModel(this.project, action);
                sb.append(model.getId());
            } else {
                sb.append(containerName);
            }
            sb.append("');");
            sb.append(CR);
            sb.append("    ");
            sb.append("var cnt_" + containerName + ";");
            sb.append(CR);
            sb.append("    ");
            sb.append("for (cnt_" + containerName + "=1; cnt_" + containerName + " <= xmlnode_" + containerName + ".length; cnt_" + containerName + "++) {");
            sb.append(CR);
            sb.append("        ");
            sb.append("xml_cont = xmlnode_" + containerName + ".item(cnt_" + containerName + "-1);");
            sb.append(CR);
            while (sitem_ite.hasNext()) {
                Modelitem sitem = sitem_ite.next();
                if (!AppSchemaUtil.hasChildPart(sitem.getName()) || !containerName.equals(AppSchemaUtil.getParentPart(sitem.getName()))) continue;
                Relation rel = AppSchemaUtil.getRelationTypeExceptRef(sitem);
                if (rel == null) {
                    rel = AppSchemaUtil.getRelatedRelationInCaseofTypeRef(this.smodel, sitem);
                }
                if (rel == null) continue;
                this.gUpdateContentMultipleSetResponseXMLContentRelation(sb, containerName, sitem, rel);
            }
            sb.append("    ");
            sb.append("}");
            sb.append(CR);
            sb.append(CR);
        }
        if (isNeedIgnoreAutocompleteForSearchItemChangeEvent) {
            sb.append("    ").append("setAutocompleteForSearchItemChangeEvent(true);").append(CR).append(CR);
        }
        this.gInit_createDisableCtrlManager(sb, "    ");
        this.gInit_createEnter2TabHandler(sb, "    ");
        sb.append("    ").append("requestTimerId = null;").append(CR).append("    ").append("require([\"dojo/topic\"], function(topic) { topic.publish(\"jfcUpdateContent\", xml); });").append(CR).append("}").append(CR);
    }

    private void gUpdateContentMultipleSetResponseXMLContentRelation(StringBuilder sb, String containerName, Modelitem sitem, Relation rel) {
        String labelid = AppSchemaUtil.createNameAttribute_header(sitem.getName(), this.cpmodel);
        labelid = labelid.replaceAll("[$][{]__position[.]count[}]", "\"+cnt_" + containerName + "+\"");
        sb.append("        ");
        sb.append("xmlnode = xml_cont.getElementsByTagName(\"");
        sb.append(AppSchemaUtil.getChildPart(sitem.getName()));
        sb.append("\");");
        sb.append(CR);
        this.callSetResponseXMLContentRelation(sb, "        ", sitem, rel, labelid);
    }

    private void gUpdateContentSetResponseXMLContentRelation(StringBuilder sb, Modelitem sitem, Relation rel) {
        String labelid = AppSchemaUtil.createNameAttribute_header(sitem.getName(), this.cpmodel);
        sb.append("    ");
        sb.append("xmlnode = xml.getElementsByTagName(\"");
        sb.append(AppSchemaUtil.getChildPart(sitem.getName()));
        sb.append("\");");
        sb.append(CR);
        this.callSetResponseXMLContentRelation(sb, "    ", sitem, rel, labelid);
    }

    private String getRelType(Modelitem sitem, Relation rel) {
        String relType = rel.getType();
        if (!"radio".equals(relType)) {
            return relType;
        }
        Displayitem ditem = AppSchemaUtil.getDisplayitem(sitem.getName(), this.presentation);
        if (ditem != null && "pseudo_checkbox".equals(ditem.getType())) {
            return "check";
        }
        return relType;
    }

    private void callSetResponseXMLContentRelation(StringBuilder sb, String tab, Modelitem sitem, Relation rel, String labelid) {
        String reltype = this.getRelType(sitem, rel);
        Model rmodel = (Model)rel.getIdrefAsIRNode();
        String compositeKeyParam = this.getCompositeKeyParam(rmodel);
        TreeMap<InputCodeConfig, String> codeMap = (TreeMap<InputCodeConfig, String>)this.inputCodeMap.get(sitem.getName());
        if (compositeKeyParam != null) {
            codeMap = codeMap != null ? new TreeMap(codeMap) : new TreeMap<InputCodeConfig, String>();
            codeMap.put(InputCodeConfig.compositeKey, compositeKeyParam);
        }
        sb.append(tab);
        sb.append("param = {");
        if (codeMap != null) {
            sb.append(CR);
            Iterator it = codeMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                sb.append(tab + "    ");
                sb.append("'" + e.getKey() + "': " + (String)e.getValue());
                if (it.hasNext()) {
                    sb.append(",");
                }
                sb.append(CR);
            }
            sb.append(tab);
        }
        sb.append("};");
        sb.append(CR);
        sb.append(tab);
        sb.append("setResponseXMLContent_" + reltype);
        if (this.isResrictHiddenModelitem(sitem.getName())) {
            sb.append("_hidden");
        }
        sb.append("(xml, xmlnode, \"" + labelid + "\", param);");
        sb.append(CR);
    }

    private String getCompositeKeyParam(Model rmodel) {
        PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(rmodel, this.project);
        if (pkeys == null || pkeys.length <= 1) {
            return null;
        }
        StringBuilder sb0 = new StringBuilder();
        sb0.append("\"");
        for (int j = 1; j < pkeys.length; ++j) {
            sb0.append(pkeys[j].getName()).append("_jshpkey");
            if (j >= pkeys.length - 1) continue;
            sb0.append(",");
        }
        sb0.append("\"");
        return sb0.toString();
    }

    private void gUpdateContent_originalArray(StringBuilder sb) {
        String templatefilename = TemplatefilenameBase + "__javascript_originalArray.html";
        FileTemplateManager tplman = new FileTemplateManager(templatefilename, TemplatefileCharEncoding);
        sb.append(tplman.getResult());
    }

    private void gUpdateContent_setBgcolor_id(StringBuilder sb) {
        String templatefilename = TemplatefilenameBase + "__javascript_setBgcolor_id.html";
        FileTemplateManager tplman = new FileTemplateManager(templatefilename, TemplatefileCharEncoding);
        sb.append(tplman.getResult());
    }

    private void gUpdateContent_setResponseXMLContent_id(StringBuilder sb) {
        String templatefilename = TemplatefilenameBase + "__javascript_setResponseXMLContent_id.html";
        FileTemplateManager tplman = new FileTemplateManager(templatefilename, TemplatefileCharEncoding);
        sb.append(tplman.getResult());
    }

    private void gUpdateContent_setResponseXMLContent_value(StringBuilder sb, boolean isChangeAjaxElement) {
        String templatefilename = TemplatefilenameBase + "__javascript_setResponseXMLContent_value.html";
        FileTemplateManager tplman = new FileTemplateManager(templatefilename, TemplatefileCharEncoding);
        if (isChangeAjaxElement) {
            tplman.setContent("isChangeAjaxElement", "true");
        } else {
            tplman.setContent("isChangeAjaxElement", "");
        }
        tplman.setUseCommandFeature(true);
        sb.append(tplman.getResult());
    }

    private void gUpdateContent_setResponseXMLContent_combo(StringBuilder sb) {
        String templatefilename = TemplatefilenameBase + "__javascript_setResponseXMLContent_combo.html";
        FileTemplateManager tplman = new FileTemplateManager(templatefilename, TemplatefileCharEncoding);
        sb.append(tplman.getResult());
    }

    private void gUpdateContent_setResponseXMLContent_radio(StringBuilder sb) {
        String templatefilename = TemplatefilenameBase + "__javascript_setResponseXMLContent_radio.html";
        FileTemplateManager tplman = new FileTemplateManager(templatefilename, TemplatefileCharEncoding);
        sb.append(tplman.getResult());
    }

    private void gUpdateContent_setResponseXMLContent_check(StringBuilder sb) {
        String templatefilename = TemplatefilenameBase + "__javascript_setResponseXMLContent_check.html";
        FileTemplateManager tplman = new FileTemplateManager(templatefilename, TemplatefileCharEncoding);
        sb.append(tplman.getResult());
    }

    private void gUpdateContent_setResponseXMLContent_search(StringBuilder sb) {
        String templatefilename = TemplatefilenameBase + "__javascript_setResponseXMLContent_search.html";
        FileTemplateManager tplman = new FileTemplateManager(templatefilename, TemplatefileCharEncoding);
        sb.append(tplman.getResult());
    }

    private void gUpdateContent_setListeners(StringBuilder sb, Set<String> callsrcSitemSet) {
        String templatefilename = TemplatefilenameBase + "__javascript_setListeners.html";
        FileTemplateManager tplman = new FileTemplateManager(templatefilename, TemplatefileCharEncoding);
        ArrayList<String> checkSetListenersModelitemList = new ArrayList<String>();
        block0: for (String mitemname : callsrcSitemSet) {
            Relation rel;
            Modelitem smitem = AppSchemaUtil.getModelitem(mitemname, this.smodel);
            if (smitem == null || !"storeref".equals(smitem.getType()) || (rel = AppSchemaUtil.getRelationTypeExceptRef(smitem)) == null && (rel = AppSchemaUtil.getRelatedRelationInCaseofTypeRef(this.smodel, smitem)) == null || !"search".equals(rel.getType())) continue;
            List<Displayitem> ditems = AppSchemaUtil.getDisplayitemList(mitemname, this.presentation, this.smodel);
            for (Displayitem ditem : ditems) {
                if (!ditem.getDisplayRoleid()) continue;
                checkSetListenersModelitemList.add(mitemname);
                continue block0;
            }
        }
        if (checkSetListenersModelitemList.size() > 0) {
            StringBuilder sb1 = new StringBuilder();
            this.gCheckElementNameIf(sb1, checkSetListenersModelitemList, "    ", "elem.name");
            tplman.setContent("isCheckSetListenersIfCode", "true");
            tplman.setContent("checkSetListenersIfCode", sb1.toString());
        } else {
            tplman.setContent("isCheckSetListenersIfCode", "");
        }
        tplman.setUseCommandFeature(true);
        sb.append(tplman.getResult());
    }

    private void gUpdateContent_setListeners_updateContent(StringBuilder sb) {
        String templatefilename = TemplatefilenameBase + "__javascript_setListeners_updateContent.html";
        FileTemplateManager tplman = new FileTemplateManager(templatefilename, TemplatefileCharEncoding);
        sb.append(tplman.getResult());
    }

    private void gUpdateContent_multiple_setResponseXMLContent_value(StringBuilder sb, Modelitem refitem, int k) {
        String s;
        Displayitem ditem;
        String displayfield = AppSchemaUtil.getChildPart(refitem.getName());
        if (JavaSourceGenerator.isStringType(refitem.getType()) && this.presentation != null && (ditem = AppSchemaUtil.getDisplayitem(refitem.getName(), this.presentation)) != null && StringUtils.isNotBlank((CharSequence)(s = AppSchemaUtil.getChildPart(ditem.getDisplayfield())))) {
            displayfield = s;
        }
        int containerIndex = k + 1;
        String widget = "widget" + containerIndex;
        sb.append("    ");
        sb.append("var cnt=1;");
        sb.append(CR);
        sb.append("    ");
        sb.append("while (true) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("htmlkey" + (k + 1));
        sb.append(" = 'content_");
        sb.append(AppSchemaUtil.createNameAttribute(this.project, AppSchemaUtil.getParentPart(refitem.getName()), this.cpmodel));
        sb.append(StringUtil.convertHtmlIdString((String)"["));
        sb.append("'+cnt+'");
        sb.append(StringUtil.convertHtmlIdString((String)"]/"));
        sb.append(AppSchemaUtil.getChildPart(refitem.getName()));
        sb.append("',");
        sb.append(CR);
        sb.append("        ");
        sb.append("htmlnode" + (k + 1) + " = document.getElementById(htmlkey" + (k + 1) + ");");
        sb.append(CR);
        sb.append("        ");
        sb.append("htmlinputkey" + (k + 1));
        sb.append(" = '");
        sb.append(AppSchemaUtil.createNameAttribute(this.project, AppSchemaUtil.getParentPart(refitem.getName()), this.cpmodel));
        sb.append(StringUtil.convertHtmlIdString((String)"["));
        sb.append("'+cnt+'");
        sb.append(StringUtil.convertHtmlIdString((String)"]/"));
        sb.append(AppSchemaUtil.getChildPart(refitem.getName()));
        sb.append("';");
        sb.append(CR);
        sb.append("        ");
        sb.append("htmlinputnode" + (k + 1) + " = updateContent_textform.elements[htmlinputkey" + (k + 1) + "];");
        sb.append(CR);
        sb.append("        ").append("var ").append(widget).append(";").append(CR);
        sb.append("        ").append("require([\"dijit/registry\"], function(registry) {").append(CR);
        sb.append("            ").append(widget).append(" = registry.byId(htmlinputkey").append(containerIndex).append(");").append(CR);
        sb.append("        ").append("});").append(CR);
        sb.append("        ").append("if (").append(widget).append(") {").append(CR);
        sb.append("            ").append("var widgetNode = ").append(widget).append(".focusNode || ").append(widget).append(".valueNode;").append(CR);
        sb.append("            ").append("var widgetNodeName = widgetNode.nodeName;").append(CR);
        sb.append("            ").append("if (widgetNodeName) {").append(CR);
        sb.append("                ").append("htmlinputnodename").append(containerIndex).append(" = widgetNodeName.toUpperCase();").append(CR);
        sb.append("            ").append("}").append(CR);
        sb.append("        ").append("} else if (htmlinputnode").append(containerIndex).append(") {").append(CR);
        sb.append("            ").append("htmlinputnodename").append(containerIndex).append(" = htmlinputnode").append(containerIndex).append(".nodeName.toUpperCase();").append(CR);
        sb.append("        ").append("}").append(CR);
        sb.append("        ");
        sb.append("if ((htmlnode" + (k + 1));
        sb.append(" && htmlnode" + (k + 1));
        sb.append(".nodeName.toUpperCase() != 'INPUT')");
        sb.append(" || (htmlinputnode" + (k + 1) + " && (htmlinputnodename" + (k + 1) + " == 'INPUT' || htmlinputnodename" + (k + 1) + " == 'TEXTAREA'))) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("xmlnode = xml.getElementsByTagName('");
        sb.append(displayfield);
        sb.append("');");
        sb.append(CR);
        sb.append("            ");
        sb.append("var inputValue = '';");
        sb.append(CR);
        sb.append("            ");
        sb.append("var formattedValue = '';");
        sb.append(CR);
        sb.append("            ");
        sb.append("if (xmlnode.length < cnt || !xmlnode[cnt-1].hasChildNodes()) {");
        sb.append(CR);
        sb.append("                ");
        sb.append("inputValue = '';");
        sb.append(CR);
        sb.append("                ");
        sb.append("formattedValue = '';");
        sb.append(CR);
        sb.append("            ");
        sb.append("} else {");
        sb.append(CR);
        sb.append("                ").append("inputValue = xmlnode[cnt-1].firstChild.nodeValue;").append(CR);
        sb.append("                ").append("formattedValue = xmlnode[cnt-1].getAttribute(\"formatted\");").append(CR);
        sb.append("                ").append("if (formattedValue == null || formattedValue == '') {").append(CR);
        sb.append("                    ").append("formattedValue = inputValue;").append(CR);
        sb.append("                ").append("}");
        sb.append(CR);
        sb.append("            ");
        sb.append("}");
        sb.append(CR);
        sb.append("            ");
        sb.append("setResponseXMLContent_value(xml,");
        sb.append(CR);
        sb.append("                ");
        sb.append("formattedValue, inputValue, ");
        sb.append(CR);
        sb.append("                ");
        sb.append("htmlkey" + (k + 1));
        sb.append(",");
        sb.append(CR);
        sb.append("                ");
        sb.append("htmlinputkey" + (k + 1) + ");");
        sb.append(CR);
        Modelitem pitem = AppSchemaUtil.getModelitem(refitem.getName(), this.pmodel);
        String selectinput = pitem.getSelectinput();
        if (selectinput != null) {
            Modelitem refmitem = AppSchemaUtil.getRelatedModelitemInCaseofTypeRef(this.project, this.smodel.getId(), refitem);
            String type = refmitem.getType();
            if (type.equals("date") || type.equals("dateTime")) {
                sb.append("            ");
                sb.append("new Function(\"f\", \"setDate_\"+htmlinputkey1+\"(f);\")(updateContent_textform);");
                sb.append(CR);
            } else if (type.equals("time")) {
                sb.append("            ");
                sb.append("new Function(\"setTime_\"+htmlinputkey1+\"();\")();");
                sb.append(CR);
            }
        }
        sb.append("            ");
        sb.append("cnt++;");
        sb.append(CR);
        sb.append("            ");
        sb.append("continue;");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append("        ");
        sb.append("break;");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
    }

    private void gUpdateContent_multiple_setBgcolor_id(StringBuilder sb, Modelitem refitem, int k) {
        sb.append("    ");
        sb.append("var cnt=1;");
        sb.append(CR);
        sb.append("    ");
        sb.append("while (true) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("htmlkey" + (k + 1));
        sb.append(" = 'content_");
        sb.append(AppSchemaUtil.createNameAttribute(this.project, AppSchemaUtil.getParentPart(refitem.getName()), this.cpmodel));
        sb.append(StringUtil.convertHtmlIdString((String)"["));
        sb.append("'+cnt+'");
        sb.append(StringUtil.convertHtmlIdString((String)"]/"));
        sb.append(AppSchemaUtil.getChildPart(refitem.getName()));
        sb.append("',");
        sb.append(CR);
        sb.append("        ");
        sb.append("htmlnode" + (k + 1) + " = document.getElementById(htmlkey" + (k + 1) + ");");
        sb.append(CR);
        sb.append("        ");
        sb.append("htmlinputkey" + (k + 1));
        sb.append(" = '");
        sb.append(AppSchemaUtil.createNameAttribute(this.project, AppSchemaUtil.getParentPart(refitem.getName()), this.cpmodel));
        sb.append(StringUtil.convertHtmlIdString((String)"["));
        sb.append("'+cnt+'");
        sb.append(StringUtil.convertHtmlIdString((String)"]/"));
        sb.append(AppSchemaUtil.getChildPart(refitem.getName()));
        sb.append("';");
        sb.append(CR);
        sb.append("        ");
        sb.append("htmlinputnode" + (k + 1) + " = updateContent_textform.elements[htmlinputkey" + (k + 1) + "];");
        sb.append(CR);
        sb.append("        ");
        sb.append("if (htmlinputnode" + (k + 1) + ") {");
        sb.append(CR);
        sb.append("            ");
        sb.append("htmlinputnodename" + (k + 1) + " = htmlinputnode" + (k + 1) + ".nodeName.toUpperCase();");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append("        ");
        sb.append("if ((htmlnode" + (k + 1));
        sb.append(" && htmlnode" + (k + 1));
        sb.append(".nodeName.toUpperCase() != 'INPUT')");
        sb.append(" || (htmlinputnode" + (k + 1) + " && (htmlinputnodename" + (k + 1) + " == 'INPUT' || htmlinputnodename" + (k + 1) + " == 'TEXTAREA'))) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("setBgcolor_id(");
        sb.append(CR);
        sb.append("                ");
        sb.append("htmlkey" + (k + 1));
        sb.append(",");
        sb.append(CR);
        sb.append("                ");
        sb.append("htmlinputkey" + (k + 1) + ",");
        sb.append(CR);
        sb.append("                ");
        sb.append("color, footer);");
        sb.append(CR);
        sb.append("            ");
        sb.append("cnt++;");
        sb.append(CR);
        sb.append("            ");
        sb.append("continue;");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append("        ");
        sb.append("break;");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
    }

    public void outputCheckAllOnFunctionCode() {
        StringBuilder sb = new StringBuilder();
        String templatefilename = TemplatefilenameBase + "__javascript_checkAllOn.html";
        FileTemplateManager tplman = new FileTemplateManager(templatefilename, TemplatefileCharEncoding);
        sb.append(tplman.getResult());
        this.addJavaScriptFunctionCode("checkAllOn", sb.toString());
    }

    public void outputCheckAllOffFunctionCode() {
        StringBuilder sb = new StringBuilder();
        String templatefilename = TemplatefilenameBase + "__javascript_checkAllOff.html";
        FileTemplateManager tplman = new FileTemplateManager(templatefilename, TemplatefileCharEncoding);
        sb.append(tplman.getResult());
        this.addJavaScriptFunctionCode("checkAllOff", sb.toString());
    }

    @Override
    protected String getGeneratorClassName() {
        if (System.getProperty("jfc.output.genclassname") != null) {
            return "// genclassname:" + this.getClass().getName() + CR;
        }
        return "";
    }

    public void addNotsameInputValueModelitem(String mitemname) {
        this.notsameInputValueModelitemSet.add(mitemname);
    }

    public static String gJavaScript_openSearchWindow() {
        StringBuilder sb = new StringBuilder();
        String templatefilename = TemplatefilenameBase + "__javascript_openSearchWindow.html";
        FileTemplateManager tplman = new FileTemplateManager(templatefilename, TemplatefileCharEncoding);
        sb.append(tplman.getResult());
        return sb.toString();
    }

    public static String gJavaScript_getSearchListTarget() {
        TabBuffer sb = new TabBuffer();
        sb.setIndentSize(2);
        sb.append("function ");
        sb.append(jsFunctionName_GetSearchListTarget);
        sb.append("() {");
        sb.cr();
        sb.forward();
        sb.append("return searchListTargetName;");
        sb.cr();
        sb.back();
        sb.append("}");
        sb.cr();
        return sb.toString();
    }

    protected final boolean isExistsEnter2TabSetting() {
        Displayitem ditem;
        Modelitem p_mitem;
        if (this.pmodel == null && this.cpmodel == null) {
            return this.id == null && "logon".equals(this.filename);
        }
        Presentation[] presentations = AppSchemaUtil.getPresentation(this.project, this.action);
        if (this.pmodel != null) {
            for (IModelChoice o : this.pmodel.getContent()) {
                if (!(o instanceof Modelitem)) continue;
                for (Presentation presentation : presentations) {
                    p_mitem = (Modelitem)o;
                    ditem = AppSchemaUtil.getDisplayitem(p_mitem.getName(), presentation);
                    if (ditem == null || !"changetab".equals(ditem.getEnterKeyAction())) continue;
                    return true;
                }
            }
        }
        if (this.cpmodel != null) {
            for (IModelChoice o : this.cpmodel.getContent()) {
                if (!(o instanceof Modelitem)) continue;
                for (Presentation presentation : presentations) {
                    p_mitem = (Modelitem)o;
                    ditem = AppSchemaUtil.getDisplayitem(p_mitem.getName(), AppSchemaUtil.findDisplaycondition(presentation));
                    if (ditem == null || !"changetab".equals(ditem.getEnterKeyAction())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void gInit_createEnter2TabHandler(StringBuilder sb, String tab) {
        if (!this.isExistsEnter2TabSetting()) {
            return;
        }
        sb.append(tab).append("enterKeyHandler = new EnterKeyHandler();").append(CR);
    }

    public void addJavaScriptInputCode(String labelid, InputCodeConfig key, String code) {
        SortedMap<InputCodeConfig, String> codeMap = this.inputCodeMap.get(labelid);
        if (codeMap == null) {
            codeMap = new TreeMap<InputCodeConfig, String>();
            this.inputCodeMap.put(labelid, codeMap);
        }
        codeMap.put(key, code);
    }

    protected void gInit_tabSettings(StringBuilder sb, String tab) {
        if (!this.isTabLayoutUsed()) {
            return;
        }
        LinkedHashMap<String, String> defaultTabIds = new LinkedHashMap<String, String>();
        LinkedHashMap<String, LinkedHashMap<String, List<String>>> selectTabConditions = new LinkedHashMap<String, LinkedHashMap<String, List<String>>>();
        this.setDefaultTabIdInDisplaymodel(this.presentation, defaultTabIds, selectTabConditions);
        this.setDefaultTabIdInPanelgroup(this.presentation, defaultTabIds, selectTabConditions);
        this.setDefaultTabId(defaultTabIds);
        this.setSelectTabCondition(selectTabConditions);
        StringBuilder defaultTabSetting = new StringBuilder();
        StringBuilder selectTabSetting = new StringBuilder();
        StringBuilder tabVisibilitySetting = new StringBuilder();
        sb.append(tab).append("var tabSettings = {").append(CR);
        for (Map.Entry<String, TabManager> tabManagerEntry : this.tabManagerMap.entrySet()) {
            TabManager tabManager = tabManagerEntry.getValue();
            String defaultTabId = tabManager.getDefaultTabId();
            if (StringUtils.isBlank((CharSequence)defaultTabId)) {
                defaultTabId = "";
            }
            defaultTabSetting.append("      ").append("\"").append(tabManagerEntry.getKey()).append("\":");
            defaultTabSetting.append("\"").append(defaultTabId).append("\",").append(CR);
            selectTabSetting.append("      ").append("\"").append(tabManagerEntry.getKey()).append("\":{").append(CR);
            selectTabSetting.append(tabManager.getSelectTabConditions());
            selectTabSetting.append("      ").append("},").append(CR);
            tabVisibilitySetting.append("      ").append("\"").append(tabManagerEntry.getKey()).append("\":{").append(CR);
            tabVisibilitySetting.append(tabManager.getTabVisibilityConditions());
            tabVisibilitySetting.append("      ").append("},").append(CR);
        }
        if (defaultTabSetting.length() > 0) {
            sb.append("    ").append("\"defaultTabIds\":{").append(CR);
            sb.append(defaultTabSetting.toString());
            sb.append("    ").append("},").append(CR);
        }
        if (selectTabSetting.length() > 0) {
            sb.append("    ").append("\"selectTabConditions\":{").append(CR);
            sb.append(selectTabSetting.toString());
            sb.append("    ").append("},").append(CR);
        }
        if (tabVisibilitySetting.length() > 0) {
            sb.append("    ").append("\"visibilityConditions\":{").append(CR);
            sb.append(tabVisibilitySetting.toString());
            sb.append("    ").append("},").append(CR);
        }
        sb.append(this.getTabSelectChildEnableFlag());
        sb.append("  ").append("}").append(CR);
    }

    protected void setDefaultTabIdInDisplaymodel(Presentation presentation, Map<String, String> defaultTabIds, Map<String, LinkedHashMap<String, List<String>>> selectTabConditions) {
        IPanelChoice[] ipcs;
        Panel bodyPanel = AppSchemaUtil.findBodyPanel(presentation);
        if (bodyPanel == null) {
            return;
        }
        HashMap<String, String> tabContainerId = new HashMap<String, String>();
        for (IPanelChoice ipc : ipcs = bodyPanel.getContent()) {
            if (ipc instanceof Displaymodelgroup) {
                this.setDefaultTabIdInDisplaymodel((Displaymodelgroup)ipc, tabContainerId, defaultTabIds, selectTabConditions);
                continue;
            }
            if (!(ipc instanceof Displaymodel)) continue;
            this.setDefaultTabIdInDisplaymodel((Displaymodel)ipc, tabContainerId, defaultTabIds, selectTabConditions);
        }
    }

    protected void setDefaultTabIdInDisplaymodel(Displaymodelgroup displaymodelgroup, Map<String, String> tabContainerId, Map<String, String> defaultTabIds, Map<String, LinkedHashMap<String, List<String>>> selectTabConditions) {
        IDisplaymodelgroupChoice[] idgc = displaymodelgroup.getContent();
        if (idgc == null) {
            return;
        }
        for (int i = 0; i < idgc.length; ++i) {
            if (!(idgc[i] instanceof Displaymodel)) continue;
            this.setDefaultTabIdInDisplaymodel((Displaymodel)idgc[i], tabContainerId, defaultTabIds, selectTabConditions);
        }
    }

    protected void setDefaultTabIdInDisplaymodel(Displaymodel displaymodel, Map<String, String> tabContainerId, Map<String, String> defaultTabIds, Map<String, LinkedHashMap<String, List<String>>> selectTabConditions) {
        IDisplaymodelChoice[] idc = displaymodel.getContent();
        if (idc == null) {
            return;
        }
        String tabGroup = "0";
        for (int i = 0; i < idc.length; ++i) {
            Displayitemgroup displayitemgroup;
            if (!(idc[i] instanceof Displayitemgroup) || !(displayitemgroup = (Displayitemgroup)idc[i]).getUseTab()) continue;
            if (StringUtils.isNotBlank((CharSequence)displayitemgroup.getTabgroup()) && !tabGroup.equals(displayitemgroup.getTabgroup())) {
                tabGroup = displayitemgroup.getTabgroup();
            }
            tabContainerId.put("id", tabGroup);
            this.setDefaultTabIdInDisplayitemgroup(displayitemgroup, tabGroup, tabContainerId, defaultTabIds, selectTabConditions);
        }
    }

    protected void setDefaultTabIdInDisplayitemgroup(Displayitemgroup displayitemgroup, String tabGroup, Map<String, String> tabContainerId, Map<String, String> defaultTabIds, Map<String, LinkedHashMap<String, List<String>>> selectTabConditions) {
        String key = this.smodel.getId() + "__" + tabContainerId.get("id");
        if (displayitemgroup.getSelected()) {
            defaultTabIds.put(key, displayitemgroup.getId());
        }
        String selectTabCondition = displayitemgroup.getSelectTabCondition();
        String[] conditions = new String[]{""};
        if (StringUtils.isNotBlank((CharSequence)selectTabCondition)) {
            conditions = selectTabCondition.split(",");
        }
        for (String condition : conditions) {
            List<String> tabSelectConditionValues;
            String[] conditionValues = condition.split(":");
            if (conditionValues == null || conditionValues.length == 0) continue;
            LinkedHashMap<String, List<String>> map = selectTabConditions.get(key);
            if (map == null) {
                map = new LinkedHashMap();
            }
            if (StringUtils.isBlank((CharSequence)condition)) {
                condition = "";
            }
            if ((tabSelectConditionValues = map.get(displayitemgroup.getId())) == null) {
                tabSelectConditionValues = new ArrayList<String>();
            }
            tabSelectConditionValues.add(condition);
            map.put(displayitemgroup.getId(), tabSelectConditionValues);
            selectTabConditions.put(key, map);
        }
        boolean isNestedTab = false;
        IDisplayitemgroupChoice[] idmc = displayitemgroup.getContent();
        for (int i = 0; i < idmc.length; ++i) {
            if (!(idmc[i] instanceof Displayitemgroup) || !((Displayitemgroup)idmc[i]).getUseTab()) continue;
            if (!isNestedTab) {
                isNestedTab = true;
                tabContainerId.put("id", ((Displayitemgroup)idmc[i]).getTabgroup());
            }
            this.setDefaultTabIdInDisplayitemgroup((Displayitemgroup)idmc[i], tabGroup, tabContainerId, defaultTabIds, selectTabConditions);
        }
    }

    protected void setDefaultTabIdInPanelgroup(Presentation presentation, Map<String, String> defaultTabIds, Map<String, LinkedHashMap<String, List<String>>> selectTabConditions) {
        Panelgroup[] panelgroups = AppSchemaUtil.findPanelgroup(presentation);
        if (panelgroups == null) {
            return;
        }
        for (Panelgroup panelgroup : panelgroups) {
            String key = SourceGenerator.capFirst(this.smodel.getId()) + panelgroup.getName();
            defaultTabIds.put(key, "");
            for (Panel panel : panelgroup.getPanel()) {
                String selectTabCondition;
                if (!panel.getUseTab()) continue;
                if (panel.getSelected()) {
                    defaultTabIds.put(key, panel.getId());
                }
                if (StringUtils.isBlank((CharSequence)(selectTabCondition = panel.getSelectTabCondition()))) continue;
                String[] conditions = selectTabCondition.split(",");
                LinkedHashMap<String, List<String>> map = null;
                for (String condition : conditions) {
                    List<String> tabSelectConditionValues;
                    map = selectTabConditions.get(key);
                    if (map == null) {
                        map = new LinkedHashMap();
                    }
                    if ((tabSelectConditionValues = map.get(key)) == null) {
                        tabSelectConditionValues = new ArrayList<String>();
                    }
                    tabSelectConditionValues.add(condition);
                    map.put(panelgroup.getName(), tabSelectConditionValues);
                }
                selectTabConditions.put(key, map);
            }
        }
    }

    protected void setDefaultTabId(Map<String, String> defaultTabIds) {
        for (Map.Entry<String, String> entry : defaultTabIds.entrySet()) {
            String tabContainerId = entry.getKey().replaceAll("\\*", "_");
            TabManager tabManager = this.tabManagerMap.get(tabContainerId);
            if (tabManager == null) {
                tabManager = new TabManager();
            }
            tabManager.setDefaultTabId(entry.getValue());
            this.tabManagerMap.put(tabContainerId, tabManager);
        }
    }

    protected void setSelectTabCondition(Map<String, LinkedHashMap<String, List<String>>> selectTabConditions) {
        for (Map.Entry<String, LinkedHashMap<String, List<String>>> entry : selectTabConditions.entrySet()) {
            String tabContainerId = entry.getKey().replaceAll("\\*", "_");
            TabManager tabManager = this.tabManagerMap.get(tabContainerId);
            if (tabManager == null) {
                tabManager = new TabManager();
            }
            LinkedHashMap<String, List<String>> conditionMap = entry.getValue();
            for (Map.Entry<String, List<String>> conditionEntry : conditionMap.entrySet()) {
                for (String conditionValue : conditionEntry.getValue()) {
                    Relation relation;
                    String[] idValue = conditionValue.split(":");
                    if (idValue == null || idValue.length < 2) continue;
                    Modelitem srcModelitem = AppSchemaUtil.getModelitem(idValue[0], this.smodel);
                    String srcModelitemType = null;
                    if (srcModelitem != null && (relation = AppSchemaUtil.getRelation(srcModelitem)) != null) {
                        srcModelitemType = relation.getType();
                    }
                    String srcCtrlName = "check".equals(srcModelitemType) || "radio".equals(srcModelitemType) ? JspBodyGeneratorDisplayitem_update.getCheckboxRadioREName(this.project, srcModelitem, this.pmodel) : AppSchemaUtil.createNameAttribute(this.project, idValue[0], this.pmodel, true);
                    tabManager.addSelectTabCondition(srcCtrlName, idValue[1] + ":" + conditionEntry.getKey());
                }
            }
            this.tabManagerMap.put(tabContainerId, tabManager);
        }
    }

    protected String getTabSelectChildEnableFlag() {
        StringBuilder sb = new StringBuilder();
        sb.append("    ").append("\"enableSelectChild\":");
        if ("insert".equals(this.action.getType()) || "update".equals(this.action.getType()) || "copy".equals(this.action.getType()) || "show".equals(this.action.getType())) {
            sb.append("true");
        } else {
            sb.append("false");
        }
        sb.append(CR);
        return sb.toString();
    }

    protected void gInit_getDisableNoUseAnchor(StringBuilder sb, String tab) {
        if (this.presentation == null || !StringUtils.startsWith((CharSequence)this.presentation.getIdref(), (CharSequence)"searchList")) {
            return;
        }
        sb.append(tab).append("disableNoUseAnchor(window.opener.").append(jsFunctionName_GetSearchListTarget).append("());").append(CR);
    }

    protected List<String> getCheckboxItemnames(Model _cmodel, Model _pmodel, Model _smodel) {
        ArrayList<String> checkboxItemnames = new ArrayList<String>();
        Modelitem sitem = null;
        Modelitem modelitem = null;
        for (IModelChoice imc : _pmodel.getContent()) {
            if (!(imc instanceof Modelitem)) continue;
            modelitem = (Modelitem)imc;
            sitem = "showList".equals(this.action.getType()) && !StringUtils.startsWith((CharSequence)this.presentation.getIdref(), (CharSequence)"updateList") || "download".equals(this.action.getType()) ? AppSchemaUtil.getModelitem(modelitem.getName(), _cmodel) : AppSchemaUtil.getModelitem(modelitem.getName(), _smodel);
            if (!AppSchemaUtil.isCheckRelation(sitem)) continue;
            checkboxItemnames.add(modelitem.getName());
        }
        return checkboxItemnames;
    }

    protected Displayitem getDisplayitemOfCheckbox(String itemname) {
        Displayitem displayitem = null;
        if ("showList".equals(this.action.getType()) && !StringUtils.startsWith((CharSequence)this.presentation.getIdref(), (CharSequence)"updateList") || "download".equals(this.action.getType())) {
            Presentation target_presentation = this.presentation;
            if (this.presentation.getIdref() != null && this.presentation.getIdref().endsWith("Calendarview")) {
                Action[] _actions;
                block0: for (Action _action : _actions = AppSchemaUtil.getActionByModelId(this.project, this.action.getIdref())) {
                    Presentation[] presentations;
                    if (!"showList".equals(_action.getType())) continue;
                    for (Presentation _presentation : presentations = AppSchemaUtil.getPresentation(this.project, _action)) {
                        Displaycondition displaycondition = AppSchemaUtil.findDisplaycondition(_presentation);
                        if (displaycondition == null || displaycondition.sizeContent() <= 0) continue;
                        target_presentation = _presentation;
                        break block0;
                    }
                }
            }
            displayitem = AppSchemaUtil.getDisplayitem(itemname, AppSchemaUtil.findDisplaycondition(target_presentation));
        } else {
            IPanelChoice ipc;
            Panel panel = AppSchemaUtil.findBodyPanel(this.presentation);
            IPanelChoice[] iPanelChoiceArray = panel.getContent();
            int n = iPanelChoiceArray.length;
            for (int i = 0; i < n && (displayitem = AppSchemaUtil.findDisplayitem(ipc = iPanelChoiceArray[i], itemname)) == null; ++i) {
            }
        }
        return displayitem;
    }

    protected void gInit_createClearToggleButton(StringBuilder sb, String tab) {
        if (this.pmodel == null || "show".equals(this.action.getType()) || this.presentation.getIdref() != null && this.presentation.getIdref().endsWith("Calendarview")) {
            return;
        }
        sb.append(tab).append("setCheckboxToggleButtonEvent();").append(CR);
    }

    protected void gInit_setBatchBtnDisabledEvent(StringBuilder sb, String tab) {
        if (this.action == null || !"showList".equals(this.action.getType())) {
            return;
        }
        Link[] links = AppSchemaUtil.findLink(this.presentation);
        if (links == null || links.length == 0) {
            return;
        }
        boolean isBatchProcessDifined = false;
        for (Link link : links) {
            if (!"action".equals(link.getType()) || !StringUtils.endsWith((CharSequence)link.getAction(), (CharSequence)"All")) continue;
            isBatchProcessDifined = true;
            break;
        }
        if (!isBatchProcessDifined) {
            return;
        }
        sb.append(tab).append("setBatchBtnDisabledEvent();").append(CR);
    }

    public String gCreateCheckboxToggleButtonEventFunc() {
        if (this.pmodel == null || "show".equals(this.action.getType()) || this.presentation.getIdref() != null && this.presentation.getIdref().endsWith("Calendarview")) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("function setCheckboxToggleButtonEvent() {").append(CR);
        sb.append("  ").append("setCheckboxToggleButtonClickEventFunc({").append(CR);
        sb.append(this.getCheckboxLabelIdFromThisModel());
        sb.append(this.getCheckboxLabelIdFromChildModel());
        sb.append("  ").append("});").append(CR).append("}").append(CR);
        return sb.toString();
    }

    protected String getCheckboxLabelIdFromThisModel() {
        return this.getCheckboxLabelId(this.getCheckboxItemnames(this.cmodel, this.pmodel, this.smodel), this.cmodel, this.cpmodel, this.pmodel, this.smodel);
    }

    protected String getCheckboxLabelIdFromChildModel() {
        if ("showList".equals(this.action.getType()) || "download".equals(this.action.getType())) {
            return "";
        }
        List<Displaymodel> childDisplaymodels = this.getChildDisplaymodel();
        if (childDisplaymodels.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Displaymodel childDisplaymodel : childDisplaymodels) {
            String idref = childDisplaymodel.getIdref();
            Model fpmodel = AppSchemaUtil.getModel(this.project, idref);
            Model fsmodel = AppSchemaUtil.getStoreModel(AppSchemaUtil.getModel(this.project, idref));
            sb.append(this.getCheckboxLabelId(this.getCheckboxItemnames(null, fpmodel, fsmodel), null, null, fpmodel, fsmodel));
        }
        return sb.toString();
    }

    protected List<Displaymodel> getChildDisplaymodel() {
        Displaymodel[] displaymodels;
        ArrayList<Displaymodel> childDisplaymodels = new ArrayList<Displaymodel>();
        for (Displaymodel displaymodel : displaymodels = AppSchemaUtil.findDisplaymodel(AppSchemaUtil.findBodyPanel(this.presentation))) {
            String idref = displaymodel.getForeignKeyIdref();
            if (StringUtils.isBlank((CharSequence)idref)) continue;
            childDisplaymodels.add(displaymodel);
        }
        return childDisplaymodels;
    }

    protected String getCheckboxLabelId(List<String> checkboxItemnames, Model _cmodel, Model _cpmodel, Model _pmodel, Model _smodel) {
        boolean isUpdateList;
        if (checkboxItemnames.isEmpty()) {
            return "";
        }
        Model targetmodel = _smodel;
        boolean bl = isUpdateList = this.action != null ? this.action.getUpdatelist() : false;
        if (isUpdateList) {
            targetmodel = AppSchemaUtil.getModel(this.project, AppSchemaUtil.getStoreModel(_smodel).getId() + "_ulp");
        }
        Displayitem displayitem = null;
        Modelitem sitem = null;
        String displayitemName = null;
        StringBuilder sb = new StringBuilder();
        for (String itemname : checkboxItemnames) {
            Model model;
            displayitem = this.getDisplayitemOfCheckbox(itemname);
            if (displayitem == null || !displayitem.getClear()) continue;
            displayitemName = displayitem.getName();
            if ("showList".equals(this.action.getType()) && !StringUtils.startsWith((CharSequence)this.presentation.getIdref(), (CharSequence)"updateList") || "download".equals(this.action.getType())) {
                model = _cpmodel;
                sitem = AppSchemaUtil.getModelitem(itemname, _cmodel);
                displayitemName = StringUtils.substringAfter((String)displayitemName, (String)"/");
            } else {
                model = _pmodel;
                if (StringUtils.startsWith((CharSequence)this.presentation.getIdref(), (CharSequence)"updateList")) {
                    Displaymodel[] displaymodels;
                    for (Displaymodel displaymodel : displaymodels = AppSchemaUtil.findDisplaymodel(AppSchemaUtil.findBodyPanel(this.presentation))) {
                        IRNode node = displaymodel.getIdrefAsIRNode();
                        if (!(node instanceof Model)) continue;
                        model = (Model)node;
                        break;
                    }
                }
                if ((sitem = AppSchemaUtil.getModelitem(itemname, targetmodel)) == null) continue;
            }
            sb.append("    ").append("\"").append(AppSchemaUtil.createNameAttribute(this.project, sitem.getName(), model)).append("\": \"");
            Object reloadItemName = StringUtils.capitalize((String)displayitemName);
            if (StringUtils.contains((CharSequence)displayitemName, (CharSequence)"/")) {
                reloadItemName = StringUtils.capitalize((String)displayitemName) + StringUtils.capitalize((String)displayitem.getName().substring(displayitem.getName().indexOf("/") + 1));
            }
            if (!AppSchemaUtil.isSubmitOnChange(this.project, targetmodel, sitem, displayitem) && AppSchemaUtil.isNeedReload(this.project, targetmodel, sitem, displayitem)) {
                sb.append((String)reloadItemName);
            }
            sb.append("\",").append(CR);
        }
        return sb.toString();
    }

    protected void gInit_createShowNumOfRemainingCharEvent(StringBuilder sb, String tab) {
        if (this.pmodel == null || this.smodel == null || "show".equals(this.action.getType()) || this.presentation.getIdref() != null && this.presentation.getIdref().endsWith("Calendarview")) {
            return;
        }
        Presentation[] presentations = AppSchemaUtil.getPresentation(this.project, this.action);
        if (presentations == null || presentations.length == 0) {
            return;
        }
        this.textareaWithRemainingChars = new ArrayList<Displayitem>();
        for (Presentation presentation : presentations) {
            Displaymodel[] dmodels;
            Panel bodyPanel = AppSchemaUtil.findBodyPanel(presentation);
            if (bodyPanel == null || (dmodels = AppSchemaUtil.findDisplaymodel(bodyPanel)) == null || dmodels.length == 0) continue;
            for (Displaymodel dmodel : dmodels) {
                List<Displayitem> displayitems = AppSchemaUtil.getDisplayitems(dmodel);
                for (Displayitem displayitem : displayitems) {
                    if (displayitem == null || AppSchemaUtil.isHiddenDisplayitem(displayitem) || !"textarea".equals(displayitem.getType()) || displayitem.getMaxlength() == 0 || displayitem.getReadonly() || !displayitem.getShowNumOfRemainingChar()) continue;
                    this.textareaWithRemainingChars.add(displayitem);
                }
            }
        }
        if (this.textareaWithRemainingChars.isEmpty()) {
            return;
        }
        sb.append(tab).append("setShowNumOfRemainingCharEvent();").append(CR);
    }

    protected void gInit_createDisplaychart(StringBuilder sb, String tab) {
        if (!"showList".equals(this.actiontype) && !"show".equals(this.actiontype)) {
            return;
        }
        Displaychart[] displaychartArray = AppSchemaUtil.getDisplaycharts(this.presentation);
        if (displaychartArray == null || displaychartArray.length == 0) {
            return;
        }
        this.displaycharts = Arrays.asList(displaychartArray);
        sb.append(tab).append("drawChart();").append(CR);
    }

    protected String gDrawChartsFunc() {
        if (this.displaycharts == null || this.displaycharts.isEmpty()) {
            return "";
        }
        String templatefilename = TemplatefilenameBase + "__javascript_drawChart.html";
        StringBuilder formId = new StringBuilder();
        formId.append("condition").append(SourceGenerator.capFirst(this.action.getIdref())).append("Cp");
        StringBuilder drawChartFunctions = new StringBuilder();
        StringBuilder datasetFunctions = new StringBuilder();
        StringBuilder func = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        for (Displaychart displaychart : this.displaycharts) {
            drawChartFunctions.append(this.getCreateChartFunc(displaychart));
            datasetFunctions.append(this.getDatasetFunc(displaychart));
            func.append(this.gDrawChartLabelsFunc(displaychart));
            func.append(this.gChartDatasetFunc(displaychart));
            FileTemplateManager tplman = new FileTemplateManager(templatefilename, TemplatefileCharEncoding);
            tplman.setUseCommandFeature(true);
            tplman.setContent("chartId", displaychart.getId());
            tplman.setContent("chartCanvasId", this.getChartCanvasId(displaychart));
            tplman.setContent("chartType", displaychart.getType());
            tplman.setContent("chartDatasetLabelFuncName", this.getChartDatasetLabelFuncName(displaychart));
            String datasetLabel = "";
            if (StringUtils.isNotBlank((CharSequence)displaychart.getLabel())) {
                datasetLabel = displaychart.getLabel();
            }
            tplman.setContent("chartDatasetLabel", datasetLabel);
            tplman.setContent("chartDatasetColorFuncName", this.getChartDatasetColorFuncName(displaychart));
            tplman.setContent("chartDatasetColor", this.getChartDatasetColor(displaychart));
            tplman.setContent("chartDatasetBgColorFuncName", this.getChartDatasetBgColorFuncName(displaychart));
            tplman.setContent("chartDatasetBorderColorFuncName", this.getChartDatasetBorderColorFuncName(displaychart));
            tplman.setContent("datasetFunctions", datasetFunctions.toString());
            tplman.setContent("formId", formId.toString());
            func.append(tplman.getResult());
            datasetFunctions = new StringBuilder();
        }
        sb.append(this.gChartFunctionsForScreen(formId.toString(), drawChartFunctions.toString()));
        sb.append(this.gCommonChartFunctions());
        sb.append(func.toString());
        return sb.toString();
    }

    protected String getChartDatasetColor(Displaychart displaychart) {
        if (StringUtils.isBlank((CharSequence)displaychart.getColor())) {
            return "[\"\"]";
        }
        StringBuilder datasetColor = new StringBuilder();
        datasetColor.append("[");
        int i = 1;
        for (String color : displaychart.getColor().split(",")) {
            if (i > 1) {
                datasetColor.append(",");
            }
            datasetColor.append("\"").append(color).append("\"");
            ++i;
        }
        datasetColor.append("]");
        return datasetColor.toString();
    }

    protected String gDrawChartLabelsFunc(Displaychart displaychart) {
        if ("showList".equals(this.actiontype)) {
            return this.gDrawChartLabelsFuncForShowList(displaychart);
        }
        if ("show".equals(this.actiontype)) {
            return this.gDrawChartLabelsFuncForShow(displaychart);
        }
        return "";
    }

    protected String gDrawChartLabelsFuncForShowList(Displaychart displaychart) {
        StringBuilder sb = new StringBuilder();
        sb.append("function ").append(this.getChartLabelsFuncName(displaychart)).append("(data) {").append(CR);
        if (StringUtils.isNotBlank((CharSequence)displaychart.getAxisLabel())) {
            sb.append("  ").append("return getEntityListData(data.entity, '").append(displaychart.getAxisLabel()).append("');").append(CR);
        } else {
            sb.append("  ").append("var labels = [];").append(CR);
            sb.append("  ").append("for (var i=1,l=data.entity.length; i<=l; i++) {").append(CR);
            sb.append("    ").append("labels.push(i);").append(CR);
            sb.append("  ").append("}").append(CR);
            sb.append("  ").append("return labels;").append(CR);
        }
        sb.append("}").append(CR).append(CR);
        return sb.toString();
    }

    protected String gDrawChartLabelsFuncForShow(Displaychart displaychart) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getChartLabelsFunc(displaychart));
        sb.append(this.getChartDataItemNamesFunc(displaychart));
        return sb.toString();
    }

    protected String gChartDatasetFunc(Displaychart displaychart) {
        StringBuilder sb = new StringBuilder();
        String label = displaychart.getLabel();
        if (label == null) {
            label = "";
        }
        sb.append("function ").append(this.getChartDatasetFuncName(displaychart)).append("(data) {").append(CR);
        sb.append("  ").append("return {").append(CR);
        sb.append("    ").append("label: ").append(this.getChartDatasetLabelFuncName(displaychart)).append("(data),").append(CR);
        sb.append("    ").append("data: ").append(this.gChartDatasetDataFuncForScreen(displaychart)).append(",").append(CR);
        sb.append("    ").append("backgroundColor: ").append(this.getChartDatasetBgColorFuncName(displaychart)).append("(),").append(CR);
        if (!"pie".equals(displaychart.getType()) && !"doughnut".equals(displaychart.getType())) {
            sb.append("    ").append("borderColor: ").append(this.getChartDatasetBorderColorFuncName(displaychart)).append("(),").append(CR);
            sb.append("    ").append("borderWidth: getChartBorderWidth(),").append(CR);
        }
        if ("line".equals(displaychart.getType())) {
            sb.append("    ").append("fill: false,").append(CR);
        }
        sb.append("  ").append("};").append(CR);
        sb.append("}").append(CR).append(CR);
        return sb.toString();
    }

    protected String gChartDatasetDataFuncForScreen(Displaychart displaychart) {
        if ("showList".equals(this.actiontype)) {
            return this.gChartDatasetDataFuncForShowList(displaychart);
        }
        if ("show".equals(this.actiontype)) {
            return this.gChartDatasetDataFuncForShow(displaychart);
        }
        return "";
    }

    protected String gChartDatasetDataFuncForShowList(Displaychart displaychart) {
        StringBuilder sb = new StringBuilder();
        if ("scatter".equals(displaychart.getType())) {
            sb.append("getScatterData(data.entity, \"").append(displaychart.getName()).append("\", \"").append(displaychart.getName()).append("\")");
        } else {
            sb.append("getEntityListData(data.entity, '").append(displaychart.getName()).append("')");
        }
        return sb.toString();
    }

    protected String gChartDatasetDataFuncForShow(Displaychart displaychart) {
        StringBuilder sb = new StringBuilder();
        sb.append("getEntityData(data.entity, ").append(this.getChartDataItemNamesFuncName(displaychart)).append("())");
        return sb.toString();
    }

    protected String gChartFunctionsForScreen(String formId, String drawChartFunctions) {
        StringBuilder templatefilename = new StringBuilder();
        templatefilename.append(TemplatefilenameBase).append("__javascript_drawChartFor").append(SourceGenerator.capFirst(this.actiontype)).append(".html");
        FileTemplateManager tplman = new FileTemplateManager(templatefilename.toString(), TemplatefileCharEncoding);
        tplman.setContent("modelId", this.action.getIdref());
        tplman.setContent("primaryKeys", AppSchemaUtil.createPrimaryKeyName(AppSchemaUtil.getPrimaryKeys(this.smodel)));
        tplman.setContent("formId", formId);
        tplman.setContent("drawChartFunctions", drawChartFunctions);
        return tplman.getResult();
    }

    protected String gCommonChartFunctions() {
        String templatefilename = TemplatefilenameBase + "__javascript_commonChartFunctions.html";
        FileTemplateManager tplman = new FileTemplateManager(templatefilename, TemplatefileCharEncoding);
        tplman.setContent("modelId", this.action.getIdref());
        return tplman.getResult();
    }

    protected String getCreateChartFunc(Displaychart displaychart) {
        StringBuilder sb = new StringBuilder();
        sb.append("      ").append("charts.push(create").append(displaychart.getId()).append("Chart(data, dom, domAttr, domClass, domConstruct, domStyle, query, Button, registry, request, afterCreate").append(displaychart.getId()).append("Chart));").append(CR);
        return sb.toString();
    }

    protected String getDatasetFunc(Displaychart displaychart) {
        StringBuilder sb = new StringBuilder();
        sb.append("  ").append("datasets.push(get").append(displaychart.getId()).append(SourceGenerator.capFirst(displaychart.getName())).append("ChartDataset(data));").append(CR);
        return sb.toString();
    }

    protected String getChartCanvasId(Displaychart displaychart) {
        return this.action.getId() + "_" + displaychart.getId() + "_chart";
    }

    protected String getChartLabelsFuncName(Displaychart displaychart) {
        return "get" + displaychart.getId() + "ChartLabels";
    }

    protected String getChartLabelsFunc(Displaychart displaychart) {
        StringBuilder sb = new StringBuilder();
        sb.append("function ").append(this.getChartLabelsFuncName(displaychart)).append("(data) {").append(CR);
        sb.append("  ").append("return ");
        String axisLabel = displaychart.getAxisLabel();
        if (StringUtils.isBlank((CharSequence)axisLabel)) {
            int i = 1;
            sb.append("[");
            for (Item item : displaychart.getItem()) {
                Modelitem pitem = AppSchemaUtil.getModelitem(item.getName(), this.pmodel);
                String label = pitem == null ? item.getName() : pitem.getLabel();
                if (i > 1) {
                    sb.append(",");
                }
                sb.append("\"").append(label).append("\"");
                ++i;
            }
            sb.append("]");
        } else {
            sb.append("getEntityData(data.entity, [\"").append(axisLabel).append("\"])");
        }
        sb.append(";").append(CR);
        sb.append("}").append(CR).append(CR);
        return sb.toString();
    }

    protected String getChartDataItemNamesFuncName(Displaychart displaychart) {
        StringBuilder sb = new StringBuilder();
        sb.append("get").append(displaychart.getId()).append("ChartDataItemNames");
        return sb.toString();
    }

    protected String getChartDataItemNamesFunc(Displaychart displaychart) {
        StringBuilder sb = new StringBuilder();
        sb.append("function ").append(this.getChartDataItemNamesFuncName(displaychart)).append("() {").append(CR);
        sb.append("  ").append("return [");
        int i = 1;
        for (Item item : displaychart.getItem()) {
            if (i > 1) {
                sb.append(",");
            }
            sb.append("\"").append(item.getName()).append("\"");
            ++i;
        }
        sb.append("];").append(CR);
        sb.append("}").append(CR).append(CR);
        return sb.toString();
    }

    protected String getChartDatasetFuncName(Displaychart displaychart) {
        return "get" + displaychart.getId() + SourceGenerator.capFirst(displaychart.getName()) + "ChartDataset";
    }

    protected String getChartDatasetLabelFuncName(Displaychart displaychart) {
        return this.getChartDatasetFuncName(displaychart) + "Label";
    }

    protected String getChartDatasetColorFuncName(Displaychart displaychart) {
        return this.getChartDatasetFuncName(displaychart) + "Color";
    }

    protected String getChartDatasetBgColorFuncName(Displaychart displaychart) {
        return this.getChartDatasetFuncName(displaychart) + "BgColor";
    }

    protected String getChartDatasetBorderColorFuncName(Displaychart displaychart) {
        return this.getChartDatasetFuncName(displaychart) + "BorderColor";
    }

    /*
     * WARNING - void declaration
     */
    protected String gSetShowNumOfRemainingCharEvent() {
        if (this.textareaWithRemainingChars == null || this.textareaWithRemainingChars.isEmpty()) {
            return "";
        }
        ArrayList<String> textareaLabelId = new ArrayList<String>();
        ArrayList<String> textareaLabelIdInContainer = new ArrayList<String>();
        for (Displayitem displayitem : this.textareaWithRemainingChars) {
            if (!AppSchemaUtil.hasChildPart(displayitem.getName()) && !StringUtils.startsWith((CharSequence)this.presentation.getIdref(), (CharSequence)"updateList")) {
                textareaLabelId.add(displayitem.getName());
                continue;
            }
            textareaLabelIdInContainer.add(displayitem.getName());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("function setShowNumOfRemainingCharEvent() {").append(CR);
        if (!textareaLabelId.isEmpty()) {
            sb.append("  ").append("setShowNumOfRemainingCharEventToItems([").append(CR);
            for (String name : textareaLabelId) {
                sb.append("    ").append("\"").append(AppSchemaUtil.createNameAttribute(this.project, name, this.pmodel)).append("\",").append(CR);
            }
            sb.append("  ").append("]);").append(CR);
        }
        if (!textareaLabelIdInContainer.isEmpty()) {
            Model model = this.pmodel;
            if ("showList".equals(this.actiontype) && this.action.getUpdatelist()) {
                Model model2 = AppSchemaUtil.getModel(this.project, this.action.getIdref() + "_ulp");
            }
            sb.append("  ").append("setShowNumOfRemainingCharEventToContainerItems([").append(CR);
            for (String name : textareaLabelIdInContainer) {
                void var4_9;
                String labelId = AppSchemaUtil.createNameAttribute(this.project, name, (Model)var4_9);
                String prefix = StringUtils.substringBefore((String)labelId, (String)"${__position.count}");
                String suffix = StringUtils.substringAfter((String)labelId, (String)"${__position.count}");
                sb.append("    ").append("{\"prefix\": \"").append(prefix).append("\", ").append("\"suffix\": \"").append(suffix).append("\"},").append(CR);
            }
            sb.append("  ").append("]);").append(CR);
        }
        sb.append("}").append(CR);
        return sb.toString();
    }

    public void gInit_FixTableHeaderRowColumn(StringBuilder sb, String tab) {
        if (this.fixTableHeaderRowColumnModels.size() == 0 && !this.isPrintListScreenGrid()) {
            return;
        }
        sb.append(tab).append("fixTableHeaderRowColumn();").append(CR);
    }

    public boolean isPrintListScreenGrid() {
        Presentation[] presentations;
        if (!StringUtils.startsWith((CharSequence)this.presentation.getFilename(), (CharSequence)"printListScreen")) {
            return false;
        }
        Action showListAction = AppSchemaUtil.getAction(this.project, this.presentation.getIdref());
        for (Presentation presentation : presentations = AppSchemaUtil.getPresentation(this.project, showListAction)) {
            Displaymodel[] displaymodels;
            for (Displaymodel displaymodel : displaymodels = AppSchemaUtil.findDisplaymodel(AppSchemaUtil.findBodyPanel(presentation))) {
                if (!"grid".equals(displaymodel.getShowListDisplayType()) && !"scrollrow".equals(displaymodel.getShowListScrollType())) continue;
                this.addFixTableHeaderRowColumnTarget(showListAction.getIdref());
                return true;
            }
        }
        return false;
    }

    public void addFixTableHeaderRowColumnTarget(String modelId) {
        if (StringUtils.isBlank((CharSequence)modelId)) {
            return;
        }
        this.fixTableHeaderRowColumnModels.add(modelId);
    }

    public String gFixTableHeaderRowColumnFunc() {
        if (this.fixTableHeaderRowColumnModels.size() == 0) {
            return "";
        }
        StringBuilder fixTableObject = new StringBuilder();
        for (String modelId : this.fixTableHeaderRowColumnModels) {
            fixTableObject.append("    ").append("\"").append(modelId).append("\":").append(" new FixTableHeaderRowColumn({modelId: \"").append(modelId).append("\"}),").append(CR);
        }
        fixTableObject.insert(0, "  window.fixTableHeaderRowColumnFuncs = {" + CR);
        fixTableObject.append("  ").append("};").append(CR);
        fixTableObject.append("  ").append("Object.values(window.fixTableHeaderRowColumnFuncs)").append(CR).append("    ").append(".forEach((fixTableHeaderRowColumnFunc) => fixTableHeaderRowColumnFunc.init());").append(CR);
        StringBuilder sb = new StringBuilder();
        sb.append("function fixTableHeaderRowColumn() {").append(CR).append(fixTableObject.toString()).append("}").append(CR).append(CR);
        return sb.toString();
    }

    public void gInit_createShowListGrid(StringBuilder sb, String tab) {
        Displaymodel[] searchListMobileDisplaymodels;
        if (!"showList".equals(this.actiontype) && !"show".equals(this.actiontype)) {
            return;
        }
        Panel bodyPanel = AppSchemaUtil.findBodyPanel(this.presentation);
        if (bodyPanel == null) {
            return;
        }
        Displaymodel[] displaymodels = AppSchemaUtil.findDisplaymodel(bodyPanel);
        if (StringUtils.startsWith((CharSequence)this.id, (CharSequence)"searchList") && (searchListMobileDisplaymodels = AppSchemaUtil.getSearchListMobileDisplaymodel(this.project, this.id)) != null) {
            ArrayList<Displaymodel> displaymodelList = new ArrayList<Displaymodel>(Arrays.asList(displaymodels));
            displaymodelList.addAll(Arrays.asList(searchListMobileDisplaymodels));
            displaymodels = displaymodelList.toArray(new Displaymodel[0]);
        }
        if (displaymodels == null || displaymodels.length == 0) {
            return;
        }
        HashSet<String> idrefSet = new HashSet<String>();
        for (Displaymodel displaymodel : displaymodels) {
            IDisplaymodelChoice[] idc;
            if (!"grid".equals(displaymodel.getShowListDisplayType()) || idrefSet.contains(displaymodel.getIdref()) || (idc = displaymodel.getContent()) == null) continue;
            this.showListGridDisplaymodels.add(displaymodel);
            idrefSet.add(displaymodel.getIdref());
        }
        if (this.showListGridDisplaymodels.isEmpty()) {
            return;
        }
        sb.append(tab).append(this.getGridFuncName()).append(";").append(CR);
    }

    protected String getGridFuncName() {
        StringBuilder sb = new StringBuilder();
        sb.append("create");
        if (StringUtils.startsWith((CharSequence)this.presentation.getIdref(), (CharSequence)"showList") || StringUtils.startsWith((CharSequence)this.presentation.getIdref(), (CharSequence)"searchList")) {
            sb.append("ShowList");
        } else if (StringUtils.startsWith((CharSequence)this.presentation.getIdref(), (CharSequence)"updateList")) {
            sb.append("UpdateList");
        }
        sb.append("Grid()");
        return sb.toString();
    }

    public void gInit_createShowListSpreadsheet(StringBuilder sb, String tab) {
        if (!"showList".equals(this.actiontype) && !"show".equals(this.actiontype)) {
            return;
        }
        Displaymodel spreadsheetDisplaymodel = this.getSpreadsheetDisplaymodel(this.presentation);
        if (spreadsheetDisplaymodel == null) {
            return;
        }
        this.showListSpreadsheetDisplaymodels.add(spreadsheetDisplaymodel);
        sb.append(tab).append(this.getSpreadsheetFuncName()).append(";").append(CR);
    }

    private Displaymodel getSpreadsheetDisplaymodel(Presentation presentation) {
        Displaymodel[] searchListMobileDisplaymodels;
        Panel bodyPanel = AppSchemaUtil.findBodyPanel(presentation);
        if (bodyPanel == null) {
            return null;
        }
        Displaymodel[] displaymodels = AppSchemaUtil.findDisplaymodel(bodyPanel);
        if (StringUtils.startsWith((CharSequence)this.id, (CharSequence)"searchList") && (searchListMobileDisplaymodels = AppSchemaUtil.getSearchListMobileDisplaymodel(this.project, this.id)) != null) {
            ArrayList<Displaymodel> displaymodelList = new ArrayList<Displaymodel>(Arrays.asList(displaymodels));
            displaymodelList.addAll(Arrays.asList(searchListMobileDisplaymodels));
            displaymodels = displaymodelList.toArray(new Displaymodel[0]);
        }
        if (displaymodels == null || displaymodels.length == 0) {
            return null;
        }
        for (Displaymodel displaymodel : displaymodels) {
            IDisplaymodelChoice[] idc;
            if (!"spreadsheet".equals(displaymodel.getShowListDisplayType()) || (idc = displaymodel.getContent()) == null) continue;
            return displaymodel;
        }
        return null;
    }

    protected String getSpreadsheetFuncName() {
        StringBuilder sb = new StringBuilder();
        sb.append("create");
        if (StringUtils.startsWith((CharSequence)this.presentation.getIdref(), (CharSequence)"showList") || StringUtils.startsWith((CharSequence)this.presentation.getIdref(), (CharSequence)"searchList")) {
            sb.append("ShowList");
        } else if (StringUtils.startsWith((CharSequence)this.presentation.getIdref(), (CharSequence)"updateList")) {
            sb.append("UpdateList");
        }
        sb.append("Spreadsheet()");
        return sb.toString();
    }

    protected Set<String> getSortKeyItems() {
        HashSet<String> sortKeyItems = new HashSet<String>();
        Sort sort = AppSchemaUtil.getSort(AppSchemaUtil.getActionByModelIdAndType(this.project, this.smodel.getId(), "showList"));
        if (sort == null) {
            return sortKeyItems;
        }
        Sortkey[] sortKeys = sort.getSortkey();
        if (sortKeys == null) {
            return sortKeyItems;
        }
        for (int i = 0; i < sortKeys.length; ++i) {
            sortKeyItems.add(sortKeys[i].getContent());
        }
        return sortKeyItems;
    }

    protected void setGridItemSortable(Displayitem displayitem, Modelitem storeModelitem, Set<String> sortKeyItems, StringBuilder sb) {
        if (sortKeyItems.contains(displayitem.getName()) && storeModelitem != null && !storeModelitem.getTransient()) {
            return;
        }
        sb.append("      ").append("sortable: false,").append(CR);
    }

    protected boolean isUpdateListGridNeedsRefresh(Project project, Model smodel, Modelitem storeModelitem, Displayitem displayitem) {
        if (AppSchemaUtil.isNeedReload(project, smodel, storeModelitem, displayitem) || AppSchemaUtil.hasAutocalcUsingModelitem(smodel, storeModelitem, project)) {
            return true;
        }
        Modelitem[] ref_mitems = AppSchemaUtil.getModelitem_InRefRelation(smodel, storeModelitem);
        return ref_mitems != null && ref_mitems.length > 0;
    }

    protected void setWidgetTypeInGrid(boolean isUpdateList, Displayitem displayitem, Relation relation, Modelitem modelitem, StringBuilder sb) {
        String addressfield;
        String type;
        if (!isUpdateList && displayitem.getBarGauge() || isUpdateList && displayitem.getReadonly() && displayitem.getBarGauge()) {
            this.setBarGaugeProps(displayitem, sb);
            return;
        }
        if (!isUpdateList || displayitem.getReadonly()) {
            return;
        }
        if (modelitem != null && modelitem.getCalendarinput()) {
            type = "dateTextbox";
        } else {
            type = displayitem.getType();
            if (!"pseudo_checkbox".equals(type) && relation != null) {
                type = AppSchemaUtil.getRelationType(relation, this.project);
            }
        }
        if ("file".equals(type)) {
            return;
        }
        sb.append("      ").append("type: '").append(type).append("',").append(CR);
        if ("pseudo_checkbox".equals(type)) {
            sb.append("      ").append("pseudoCheckValue: '").append(displayitem.getPseudoCheckboxValue()).append("',").append(CR);
        }
        if ("zipcode".equals(type) && StringUtils.isNotBlank((CharSequence)(addressfield = AppSchemaUtil.getAddressfield(AppSchemaUtil.getModelitem(modelitem.getName(), this.smodel))))) {
            sb.append("      ").append("addressItemId: '").append(addressfield).append("',").append(CR);
        }
        this.setInputFormat(displayitem, type, sb);
        if (AppSchemaUtil.isHiddenDisplayitem(displayitem)) {
            sb.append("      ").append("hidden: true,").append(CR);
            sb.append("      ").append("unhidable: true,").append(CR);
        } else if ("search".equals(type)) {
            sb.append("      ").append("searchWindow: {").append(CR);
            sb.append("        ").append("actionName: '").append(displayitem.getAction()).append(".do',").append(CR);
            sb.append("        ").append("contentElement: '").append(relation.getRolecontent()).append("',").append(CR);
            sb.append("        ").append("size: {width: ").append(displayitem.getSearchListWindowWidth()).append(", height: ").append(displayitem.getSearchListWindowHeight()).append("},").append(CR);
            sb.append("      ").append("},").append(CR);
        }
    }

    protected void setInputFormat(Displayitem displayitem, String type, StringBuilder sb) {
        if (!"dateTextbox".equals(type) && !"number".equals(type)) {
            return;
        }
        String format = null;
        if ("dateTextbox".equals(type) && StringUtils.isNotBlank((CharSequence)displayitem.getDateformat())) {
            format = displayitem.getDateformat();
        } else if ("number".equals(type) && StringUtils.isNotBlank((CharSequence)displayitem.getNumberformat())) {
            format = displayitem.getNumberformat();
            format = StringUtils.replace((String)format, (String)"\\", (String)"\\\\");
        }
        if (StringUtils.isBlank(format)) {
            return;
        }
        sb.append("      ").append("format: '").append(format).append("',").append(CR);
    }

    protected void setBarGaugeProps(Displayitem displayitem, StringBuilder sb) {
        sb.append("      ").append("type: 'barGauge',").append(CR);
        StringBuilder props = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)displayitem.getBarGaugeUnit())) {
            props.append("        ").append("unit: '").append(displayitem.getBarGaugeUnit()).append("',").append(CR);
        }
        if (StringUtils.isNotBlank((CharSequence)displayitem.getBarGaugeMaxValue())) {
            props.append("        ").append("maximum: '").append(displayitem.getBarGaugeMaxValue()).append("',").append(CR);
        }
        if (StringUtils.isNotBlank((CharSequence)displayitem.getBarGaugeColor())) {
            props.append("        ").append("color: '").append(displayitem.getBarGaugeColor()).append("',").append(CR);
        }
        if (props.length() != 0) {
            sb.append("      ").append("barGaugeProps: {").append(CR);
            sb.append(props.toString());
            sb.append("      ").append("},").append(CR);
        }
    }

    public String gCreateShowListGridFunc() {
        if (this.showListGridDisplaymodels.isEmpty()) {
            return "";
        }
        Displaycondition displayconditionTextSearch = AppSchemaUtil.findDisplaycondition(this.presentation, true);
        StringBuilder sb = new StringBuilder();
        StringBuilder createShowListGridFunc = new StringBuilder();
        for (Displaymodel showListGridDisplaymodel : this.showListGridDisplaymodels) {
            String idref = showListGridDisplaymodel.getIdref();
            String modelId = "";
            String funcNamePrefix = "";
            if (idref.endsWith("_lp")) {
                modelId = idref.substring(0, idref.length() - "_lp".length());
                funcNamePrefix = "ShowListGrid();";
            } else if (idref.endsWith("_ulp")) {
                modelId = idref.substring(0, idref.length() - "_ulp".length());
                funcNamePrefix = "UpdateListGrid();";
            }
            String capitalizedModelId = SourceGenerator.capFirst(modelId);
            String funcName = "create" + capitalizedModelId + funcNamePrefix;
            if (displayconditionTextSearch != null && displayconditionTextSearch.getTextsearch()) {
                createShowListGridFunc.append("  ").append("if (getCookie(\"").append(modelId).append(".isTextsearch\") === \"true\") {").append(CR);
                createShowListGridFunc.append("    ").append("return;").append(CR);
                createShowListGridFunc.append("  ").append("}").append(CR);
            }
            createShowListGridFunc.append("  ").append(funcName).append(CR);
            LinkedHashSet<Link> gridLinkSet = new LinkedHashSet<Link>();
            AppSchemaUtil.findLink(showListGridDisplaymodel, gridLinkSet);
            boolean isBatchProcessingDefined = this.isBatchProcessingDefined(gridLinkSet);
            Iterator i = gridLinkSet.iterator();
            while (i.hasNext()) {
                Link link = (Link)i.next();
                if ("Update".equals(link.getAction()) || "Show".equals(link.getAction()) || StringUtils.startsWith((CharSequence)link.getAction(), (CharSequence)"Copy") || link.getOriginal() && link.getOriginalPerRow()) continue;
                i.remove();
            }
            sb.append(this.gCreateShowListGridFunc(modelId, capitalizedModelId, showListGridDisplaymodel, gridLinkSet, isBatchProcessingDefined));
        }
        createShowListGridFunc.insert(0, CR);
        createShowListGridFunc.insert(0, "function " + this.getGridFuncName() + " {");
        createShowListGridFunc.append("}").append(CR);
        sb.append(createShowListGridFunc.toString());
        return sb.toString();
    }

    private Displaymodel getUpdateListSpreadsheetDisplaymodel() {
        if (StringUtils.startsWith((CharSequence)this.action.getId(), (CharSequence)"updateList")) {
            return null;
        }
        Action[] actions = AppSchemaUtil.getActionsByModelIdAndType(this.project, this.action.getIdref(), "showList");
        if (actions == null || actions.length == 0) {
            return null;
        }
        Optional<Action> updateListAction = Arrays.stream(actions).filter(a -> a.checkUpdatelist()).findFirst();
        if (!updateListAction.isPresent()) {
            return null;
        }
        Presentation[] presentations = AppSchemaUtil.getPresentation(this.project, updateListAction.get());
        if (presentations == null || presentations.length == 0) {
            return null;
        }
        for (Presentation p : presentations) {
            Displaymodel displaymodel = this.getSpreadsheetDisplaymodel(p);
            if (displaymodel == null) continue;
            return displaymodel;
        }
        return null;
    }

    public String gCreateShowListSpreadsheetFunc() {
        if (this.showListSpreadsheetDisplaymodels.isEmpty()) {
            return "";
        }
        Displaycondition displayconditionTextSearch = AppSchemaUtil.findDisplaycondition(this.presentation, true);
        StringBuilder sb = new StringBuilder();
        StringBuilder createShowListSpreadsheetFunc = new StringBuilder();
        for (Displaymodel showListSpreadsheetDisplaymodel : this.showListSpreadsheetDisplaymodels) {
            String idref = showListSpreadsheetDisplaymodel.getIdref();
            String modelId = "";
            String funcNamePrefix = "";
            if (idref.endsWith("_lp")) {
                modelId = idref.substring(0, idref.length() - "_lp".length());
                funcNamePrefix = "ShowListSpreadsheet();";
            } else if (idref.endsWith("_ulp")) {
                modelId = idref.substring(0, idref.length() - "_ulp".length());
                funcNamePrefix = "UpdateListSpreadsheet();";
            }
            String capitalizedModelId = SourceGenerator.capFirst(modelId);
            String funcName = "create" + capitalizedModelId + funcNamePrefix;
            if (displayconditionTextSearch != null && displayconditionTextSearch.getTextsearch()) {
                createShowListSpreadsheetFunc.append("  ").append("if (getCookie(\"").append(modelId).append(".isTextsearch\") === \"true\") {").append(CR);
                createShowListSpreadsheetFunc.append("    ").append("return;").append(CR);
                createShowListSpreadsheetFunc.append("  ").append("}").append(CR);
            }
            createShowListSpreadsheetFunc.append("  ").append(funcName).append(CR);
            sb.append(this.gCreateGetConditionParamsFunc(modelId, AppSchemaUtil.findDisplaycondition(this.presentation)));
            sb.append(this.gCreateGetSpreadsheetColumnsFunc(showListSpreadsheetDisplaymodel));
            Displaymodel updateListSpreadsheetDisplaymodel = this.getUpdateListSpreadsheetDisplaymodel();
            if (updateListSpreadsheetDisplaymodel != null) {
                sb.append(this.gCreateGetSpreadsheetColumnsFunc(updateListSpreadsheetDisplaymodel));
            }
            sb.append(this.gCreateShowListSpreadsheetFunc(modelId, capitalizedModelId, showListSpreadsheetDisplaymodel, updateListSpreadsheetDisplaymodel));
        }
        createShowListSpreadsheetFunc.insert(0, CR);
        createShowListSpreadsheetFunc.insert(0, "function " + this.getSpreadsheetFuncName() + " {");
        createShowListSpreadsheetFunc.append("}").append(CR);
        sb.append(createShowListSpreadsheetFunc.toString());
        return sb.toString();
    }

    protected String gCreateGetConditionParamsFunc(String modelId, Displaycondition displaycondition) {
        if (displaycondition == null) {
            return "";
        }
        List<Displayitem> displayitems = AppSchemaUtil.getDisplayitems(displaycondition);
        if (displayitems.isEmpty()) {
            return "";
        }
        Conditionlist conditionlist = AppSchemaUtil.getConditionlist(this.action);
        StringBuilder sb = new StringBuilder();
        StringBuilder paramKey = new StringBuilder();
        String name = null;
        String labelid = null;
        for (Displayitem ditem : displayitems) {
            name = ditem.getName();
            labelid = AppSchemaUtil.createNameAttribute_th(this.project, name, this.cpmodel);
            sb.append("    ").append("'").append(labelid).append("'");
            Condition condition = AppSchemaUtil.getCondition(conditionlist, name);
            if (StringUtils.endsWith((CharSequence)name, (CharSequence)"1jshparam")) {
                paramKey.append(StringUtils.substringBefore((String)name, (String)"1jshparam")).append("_gte");
            } else if (StringUtils.endsWith((CharSequence)name, (CharSequence)"2jshparam")) {
                paramKey.append(StringUtils.substringBefore((String)name, (String)"2jshparam")).append("_lte");
            } else if ("LIKE".equals(condition.getCond())) {
                paramKey.append(name).append("_like");
            } else {
                paramKey.append(name).append("_eq");
            }
            sb.append(": '").append(paramKey.toString()).append("',").append(CR);
            paramKey.setLength(0);
        }
        StringBuilder funcName = new StringBuilder();
        funcName.append("function get").append(SourceGenerator.capFirst(modelId)).append("ConditionParams() {").append(CR).append("  ").append("return {").append(CR);
        sb.insert(0, funcName.toString()).append("  ").append("};").append(CR).append("}").append(CR).append(CR);
        return sb.toString();
    }

    protected String gCreateGetSpreadsheetColumnsFunc(Displaymodel spreadSheetDisplaymodel) {
        String idref = spreadSheetDisplaymodel.getIdref();
        String modelId = "";
        String screenType = "ShowList";
        if (StringUtils.contains((CharSequence)idref, (CharSequence)"_lp")) {
            modelId = StringUtils.substringBefore((String)idref, (String)"_lp");
        } else if (StringUtils.contains((CharSequence)idref, (CharSequence)"_ulp")) {
            modelId = StringUtils.substringBefore((String)idref, (String)"_ulp");
            screenType = "UpdateList";
        }
        Model presentationModel = AppSchemaUtil.getModel(this.project, modelId, "presentation");
        PrimaryKey[] primaryKeys = AppSchemaUtil.getPrimaryKeys(presentationModel);
        HashMap primaryKeysInList = new HashMap();
        Arrays.stream(primaryKeys).forEach(item -> primaryKeysInList.put(item.getName(), Boolean.FALSE));
        Model storeModel = AppSchemaUtil.getStoreModel(presentationModel);
        Optional<PrimaryKey> primaryKey = null;
        ArrayList<String> hiddenDisplayitemNames = new ArrayList<String>();
        Modelitem presentationModelitem = null;
        StringBuilder sb = new StringBuilder();
        for (IDisplaymodelChoice idc : spreadSheetDisplaymodel.getContent()) {
            if (!(idc instanceof Displayitem)) continue;
            Displayitem displayitem = (Displayitem)idc;
            String displayitemName = AppSchemaUtil.getChildPart(displayitem.getName());
            if (AppSchemaUtil.isHiddenDisplayitem(displayitem)) {
                hiddenDisplayitemNames.add(displayitemName);
                continue;
            }
            sb.append("    ").append("{");
            sb.append(" name: '").append(displayitemName).append("',");
            String label = displayitem.getLabelname();
            if (StringUtils.isBlank((CharSequence)label)) {
                presentationModelitem = AppSchemaUtil.getModelitem(displayitem.getName(), presentationModel);
                label = presentationModelitem != null ? presentationModelitem.getLabel() : "";
            }
            sb.append(" title: '").append(label).append("',");
            if (StringUtils.isNotBlank((CharSequence)displayitem.getLabelwidth())) {
                sb.append(" width: '").append(displayitem.getLabelwidth()).append("',");
            }
            Modelitem storeModelitem = AppSchemaUtil.getModelitem(displayitem.getName(), storeModel);
            Relation relation = AppSchemaUtil.getRelationTypeExceptRef(storeModelitem);
            String type = this.getSpreadsheetType(displayitem, relation, storeModelitem);
            sb.append(" type: '").append(type).append("',");
            sb.append(this.getSpreadsheetTypeOption(displayitem, type, relation));
            String align = displayitem.getAlign();
            if ("number".equals(type)) {
                align = "right";
            }
            sb.append(" align: '").append(align).append("',");
            primaryKey = Arrays.stream(primaryKeys).filter(item -> !item.getAutoid() && (Boolean)primaryKeysInList.get(item.getName()) == false && displayitemName.equals(AppSchemaUtil.getChildPart(item.getName()))).findFirst();
            primaryKey.ifPresent(item -> primaryKeysInList.put(item.getName(), Boolean.TRUE));
            String readonlyAttr = this.getSpreadsheetReadonlyAttr(screenType, primaryKey, displayitem);
            if (StringUtils.isNotBlank((CharSequence)readonlyAttr)) {
                sb.append(readonlyAttr);
            }
            sb.append(" },").append(CR);
        }
        primaryKeysInList.entrySet().stream().filter(item -> (Boolean)item.getValue() == false).forEach(item -> {
            String name = AppSchemaUtil.getChildPart((String)item.getKey());
            if (!hiddenDisplayitemNames.contains(name)) {
                hiddenDisplayitemNames.add(name);
            }
        });
        hiddenDisplayitemNames.add("wbversion");
        hiddenDisplayitemNames.add("wbCRUDStatus");
        StringBuilder funcName = new StringBuilder();
        funcName.append("function get").append(SourceGenerator.capFirst(modelId)).append(screenType).append("SpreadsheetColumns() {").append(CR).append("  ").append("return [").append(CR);
        sb.insert(0, funcName.toString());
        sb.append(this.getSpreadsheetHiddenColumns(hiddenDisplayitemNames));
        sb.append("  ").append("];").append(CR);
        sb.append("}").append(CR).append(CR);
        return sb.toString();
    }

    private String getSpreadsheetReadonlyAttr(String screenType, Optional<PrimaryKey> primaryKey, Displayitem displayitem) {
        if (!"UpdateList".equals(screenType)) {
            return "";
        }
        boolean isReadonlyColumn = false;
        if (primaryKey.isPresent() || "file".equals(displayitem.getType())) {
            isReadonlyColumn = true;
        } else {
            String[] readOnlyTypes = displayitem.getReadonlytype();
            if (readOnlyTypes != null && readOnlyTypes.length > 0) {
                if (Arrays.asList(readOnlyTypes).contains("update")) {
                    isReadonlyColumn = true;
                }
            } else {
                isReadonlyColumn = displayitem.getReadonly();
            }
        }
        if (isReadonlyColumn) {
            return " readOnly: true,";
        }
        return "";
    }

    protected String getSpreadsheetType(Displayitem displayitem, Relation relation, Modelitem modelitem) {
        String type = displayitem.getType();
        if (!"number".equals(type)) {
            if (modelitem != null && "date".equals(modelitem.getType())) {
                type = "calendar";
            } else if (relation != null) {
                String relationType = AppSchemaUtil.getRelationType(relation, this.project);
                if ("combo".equals(relationType)) {
                    type = "dropdown";
                } else if ("search".equals(relationType)) {
                    type = "autocomplete";
                }
            } else {
                type = "text";
            }
        }
        return type;
    }

    protected String getSpreadsheetTypeOption(Displayitem displayitem, String type, Relation relation) {
        StringBuilder option = new StringBuilder();
        if ("dropdown".equals(type) || "autocomplete".equals(type)) {
            option.append(" source: [], sourceModelId: '").append(relation.getIdref()).append("',").append(" sourceModelPkey: '").append(AppSchemaUtil.getPrimaryKeyName(AppSchemaUtil.getModel(this.project, relation.getIdref()))).append("',").append(" sourceModelContent: '").append(relation.getRolecontent()).append("',");
        } else if ("number".equals(type) || "calendar".equals(type)) {
            option.append(this.getSpreadsheetTypeFormat(displayitem, type));
        }
        return option.toString();
    }

    protected String getSpreadsheetTypeFormat(Displayitem displayitem, String type) {
        if ("number".equals(type)) {
            if ("###,###.###".equals(displayitem.getNumberformat())) {
                return " format: '#,##',";
            }
        } else if ("calendar".equals(type)) {
            String format = "YYYY-MM-DD";
            if (StringUtils.isNotBlank((CharSequence)displayitem.getDateformat())) {
                format = displayitem.getDateformat();
            }
            return " options: { format: '" + format + "', textDone: res.LABEL_SPREADSHEET_CALENDAR_DONE, textReset: res.LABEL_SPREADSHEET_CALENDAR_RESET, textUpdate: res.LABEL_SPREADSHEET_CALENDAR_UPDATE, months: res.LABEL_SPREADSHEET_CALENDAR_MONTH, weekdays: res.LABEL_SPREADSHEET_CALENDAR_WEEKDAYS, weekdays_short: res.LABEL_SPREADSHEET_CALENDAR_WEEKDAYS_SHORT, onchange: function(instance, value) { if (value && value.indexOf(' ') > 0) { this.value = value.split(' ')[0]; }}},";
        }
        return "";
    }

    protected String getSpreadsheetHiddenColumns(List<String> names) {
        StringBuilder sb = new StringBuilder();
        names.forEach(name -> sb.append("    ").append("{ name: '").append((String)name).append("',").append(" type: 'hidden', },").append(CR));
        return sb.toString();
    }

    protected boolean isUpdateListUseInsert(Model smodel) {
        Updatelist updatelist = AppSchemaUtil.getUpdatelist(this.action);
        if (updatelist != null && !updatelist.getUseInsert()) {
            return false;
        }
        Action insert_action = AppSchemaUtil.getActionByModelIdAndType(this.project, smodel.getId(), "insert");
        return insert_action != null;
    }

    protected boolean isUpdateListUseCopyButton(Model smodel) {
        Updatelist updatelist = AppSchemaUtil.getUpdatelist(this.action);
        if (updatelist != null && !updatelist.getUseCopyButton()) {
            return false;
        }
        Action copy_action = AppSchemaUtil.getActionByModelIdAndType(this.project, smodel.getId(), "copy");
        return copy_action != null;
    }

    public String gCreateShowListGridFunc(String modelId, String capitalizedModelId, Displaymodel showListGridDisplaymodel, Set<Link> gridLinkSet, boolean isBatchProcessingDefined) {
        Model showListGridModel = AppSchemaUtil.getModel(this.project, modelId);
        if (showListGridModel == null) {
            logger.warn("[Internal Error] " + modelId + " is not found. capitalizedModelId=" + capitalizedModelId + ",showListGridDisplaymodel=" + showListGridDisplaymodel);
            return "";
        }
        boolean isSearchListGrid = StringUtils.startsWith((CharSequence)this.presentation.getIdref(), (CharSequence)"searchList");
        Action showListAction = AppSchemaUtil.getAction(this.project, this.presentation.getIdref());
        String filename = "";
        Object funcName = capitalizedModelId;
        if (StringUtils.startsWith((CharSequence)this.presentation.getIdref(), (CharSequence)"show") || isSearchListGrid) {
            filename = "__javascript_createShowListGrid.html";
            funcName = (String)funcName + "ShowListGrid";
        } else if (StringUtils.startsWith((CharSequence)this.presentation.getIdref(), (CharSequence)"updateList")) {
            filename = "__javascript_createUpdateListGrid.html";
            funcName = (String)funcName + "UpdateListGrid";
        }
        String templatefilename = TemplatefilenameBase + filename;
        FileTemplateManager tplman = new FileTemplateManager(templatefilename, TemplatefileCharEncoding);
        tplman.setUseCommandFeature(true);
        tplman.setContent("gridFuncName", (String)funcName);
        tplman.setContent("modelId", modelId);
        tplman.setContent("capitalizedModelId", capitalizedModelId);
        PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKeys(showListGridModel);
        tplman.setContent("idProperty", AppSchemaUtil.createPrimaryKeyName(pkeys));
        tplman.setContent("isUsePagination", this.getGridUsePagination(showListGridDisplaymodel));
        this.setGridPageOption(showListAction, tplman);
        tplman.setContent("isInTab", String.valueOf(showListGridDisplaymodel.getIsInTab()));
        tplman.setContent("batchProcessing", String.valueOf(isBatchProcessingDefined));
        tplman.setContent("isUseDeleteCheckbox", this.getUseDeleteCheckbox());
        this.setGridForeignKeyProperty(showListGridDisplaymodel, modelId, tplman);
        Object height = showListGridDisplaymodel.getShowListScrollHeight();
        height = StringUtils.isBlank((CharSequence)height) ? "auto" : (String)height + "px";
        tplman.setContent("height", (String)height);
        tplman.setContent("initSearch", String.valueOf(!AppSchemaUtil.isControlInitSearch(this.action)));
        tplman.setContent("isSearchListGrid", String.valueOf(isSearchListGrid));
        StringBuilder links = new StringBuilder();
        links.append("[");
        if (!gridLinkSet.isEmpty()) {
            links.append(CR);
            for (Link link : gridLinkSet) {
                String linkType = link.getType();
                if (!"click".equals(linkType)) continue;
                links.append("        ").append("{").append(CR);
                links.append("          ").append("type: '").append(linkType).append("',").append(CR);
                links.append("          ").append("action: '").append(link.getAction()).append("',").append(CR);
                links.append("          ").append("forward: '").append(link.getForward()).append(".do',").append(CR);
                links.append("        ").append("},").append(CR);
            }
            links.append("      ");
        }
        links.append("]");
        tplman.setContent("links", links.toString());
        return tplman.getResult();
    }

    private String getGridUsePagination(Displaymodel showListGridDisplaymodel) {
        String idref = showListGridDisplaymodel.getIdref();
        if (AppSchemaUtil.isMobile(StringUtils.substringBefore((String)idref, (String)"_"), this.project) && showListGridDisplaymodel.getOutputfilename().startsWith("searchList")) {
            return "true";
        }
        return String.valueOf(AppSchemaUtil.isContainsDisplaypageindex(showListGridDisplaymodel));
    }

    public String gCreateShowListSpreadsheetFunc(String modelId, String capitalizedModelId, Displaymodel showListSpreadsheetDisplaymodel, Displaymodel updateListSpreadsheetDisplaymodel) {
        Model showListSpreadsheetModel = AppSchemaUtil.getModel(this.project, modelId);
        if (showListSpreadsheetModel == null) {
            logger.warn("[Internal Error] " + modelId + " is not found. capitalizedModelId=" + capitalizedModelId + ",showListSpreadsheetDisplaymodel=" + showListSpreadsheetDisplaymodel);
            return "";
        }
        boolean isSearchListSpreadsheet = StringUtils.startsWith((CharSequence)this.presentation.getIdref(), (CharSequence)"searchList");
        Action showListAction = AppSchemaUtil.getAction(this.project, this.presentation.getIdref());
        String filename = "";
        Object funcName = capitalizedModelId;
        if (StringUtils.startsWith((CharSequence)this.presentation.getIdref(), (CharSequence)"show") || isSearchListSpreadsheet) {
            filename = "__javascript_createShowListSpreadsheet.html";
            funcName = (String)funcName + "ShowListSpreadsheet";
        } else if (StringUtils.startsWith((CharSequence)this.presentation.getIdref(), (CharSequence)"updateList")) {
            filename = "__javascript_createUpdateListSpreadsheet.html";
            funcName = (String)funcName + "UpdateListSpreadsheet";
        }
        String templatefilename = TemplatefilenameBase + filename;
        FileTemplateManager tplman = new FileTemplateManager(templatefilename, TemplatefileCharEncoding);
        tplman.setUseCommandFeature(true);
        tplman.setContent("spreadSheetFuncName", (String)funcName);
        tplman.setContent("capitalizedModelId", capitalizedModelId);
        tplman.setContent("modelId", modelId);
        PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKeys(showListSpreadsheetModel);
        tplman.setContent("idProperty", AppSchemaUtil.createPrimaryKeyName(pkeys));
        tplman.setContent("isUsePagination", String.valueOf(AppSchemaUtil.isContainsDisplaypageindex(showListSpreadsheetDisplaymodel)));
        this.setGridPageOption(showListAction, tplman);
        Object height = showListSpreadsheetDisplaymodel.getShowListScrollHeight();
        height = StringUtils.isBlank((CharSequence)height) || StringUtils.contains((CharSequence)height, (CharSequence)"%") ? "auto" : (String)height + "px";
        tplman.setContent("height", (String)height);
        tplman.setContent("initSearch", String.valueOf(!AppSchemaUtil.isControlInitSearch(this.action)));
        tplman.setContent("isSearchListSpreadsheet", String.valueOf(isSearchListSpreadsheet));
        tplman.setContent("insertable", String.valueOf(!showListSpreadsheetDisplaymodel.getSpreadsheetPreventInsert()));
        tplman.setContent("deletable", String.valueOf(!showListSpreadsheetDisplaymodel.getSpreadsheetPreventDelete()));
        PrimaryKey[] primaryKeys = AppSchemaUtil.getPrimaryKey(AppSchemaUtil.getModel(this.project, modelId));
        tplman.setContent("editableColumnsWhenInsert", this.getEditableColumnsWhenInsert(primaryKeys, updateListSpreadsheetDisplaymodel));
        tplman.setContent("readonlyColumnsWhenInsert", this.getReadonlyColumnsWhenInsert(primaryKeys, updateListSpreadsheetDisplaymodel));
        if (updateListSpreadsheetDisplaymodel != null) {
            this.setUpdateListSpreadsheetColumnsFunc(tplman, capitalizedModelId);
        }
        return tplman.getResult();
    }

    private Set<String> getPrimaryKeyNames(PrimaryKey[] primaryKeys, boolean isAutoid) {
        Set<String> primaryKeyNames = Stream.of(primaryKeys).filter(p -> p.getAutoid() == isAutoid).map(p -> p.getName()).collect(Collectors.toSet());
        return primaryKeyNames;
    }

    private String getEditableColumnsWhenInsert(PrimaryKey[] primaryKeys, Displaymodel updateListSpreadsheetDisplaymodel) {
        return this.getDisplayitemNamesByReadonlyType(this.getPrimaryKeyNames(primaryKeys, false), updateListSpreadsheetDisplaymodel, new Function<String[], Boolean>(){

            @Override
            public Boolean apply(String[] readOnlyTypes) {
                return Arrays.asList(readOnlyTypes).contains("update") && !Arrays.asList(readOnlyTypes).contains("insert");
            }
        });
    }

    private String getReadonlyColumnsWhenInsert(PrimaryKey[] primaryKeys, Displaymodel updateListSpreadsheetDisplaymodel) {
        return this.getDisplayitemNamesByReadonlyType(this.getPrimaryKeyNames(primaryKeys, true), updateListSpreadsheetDisplaymodel, new Function<String[], Boolean>(){

            @Override
            public Boolean apply(String[] readOnlyTypes) {
                return Arrays.asList(readOnlyTypes).contains("insert") && !Arrays.asList(readOnlyTypes).contains("update");
            }
        });
    }

    private String getDisplayitemNamesByReadonlyType(Set<String> primaryKeyNames, Displaymodel updateListSpreadsheetDisplaymodel, Function<String[], Boolean> checkReadonlyType) {
        if (updateListSpreadsheetDisplaymodel == null) {
            return "";
        }
        ArrayList<String> editableColumnsWhenInsert = new ArrayList<String>();
        for (IDisplaymodelChoice idc : updateListSpreadsheetDisplaymodel.getContent()) {
            if (!(idc instanceof Displayitem)) continue;
            Displayitem displayitem = (Displayitem)idc;
            if (primaryKeyNames.contains(displayitem.getName())) {
                editableColumnsWhenInsert.add(displayitem.getName());
                continue;
            }
            String[] readOnlyTypes = displayitem.getReadonlytype();
            if (readOnlyTypes == null || readOnlyTypes.length == 0 || !checkReadonlyType.apply(readOnlyTypes).booleanValue()) continue;
            editableColumnsWhenInsert.add(displayitem.getName());
        }
        return editableColumnsWhenInsert.stream().distinct().map(name -> StringUtils.wrap((String)name, (String)"'")).collect(Collectors.joining(", "));
    }

    private void setUpdateListSpreadsheetColumnsFunc(FileTemplateManager tplman, String capitalizedModelId) {
        StringBuilder updateListColumnFunc = new StringBuilder();
        updateListColumnFunc.append("spreadSheet.getUpdateListSpreadsheetColumns = window.get").append(capitalizedModelId).append("UpdateListSpreadsheetColumns;");
        tplman.setContent("updateListSpreadsheetColumnsFunc", updateListColumnFunc.toString());
    }

    protected String getUseDeleteCheckbox() {
        Updatelist updatelist = AppSchemaUtil.getUpdatelist(this.action);
        if (updatelist != null && !updatelist.getUseDelete()) {
            return String.valueOf(Boolean.FALSE);
        }
        Action delete_action = AppSchemaUtil.getActionByModelIdAndType(this.project, this.smodel.getId(), "delete");
        if (delete_action != null) {
            return String.valueOf(Boolean.TRUE);
        }
        return String.valueOf(Boolean.FALSE);
    }

    private boolean isBatchProcessingDefined(Set<Link> gridLinkSet) {
        if (gridLinkSet.isEmpty()) {
            return false;
        }
        for (Link link : gridLinkSet) {
            if (!"action".equals(link.getType()) || !StringUtils.contains((CharSequence)link.getAction(), (CharSequence)"All")) continue;
            return true;
        }
        return false;
    }

    private void setGridPageOption(Action showListAction, FileTemplateManager tplman) {
        String rowsPerPage = "10";
        String pageSizeOptions = "[10,20,30]";
        Page page = AppSchemaUtil.getPage(showListAction);
        if (page != null) {
            int size = page.getSize();
            if (size > 0) {
                rowsPerPage = String.valueOf(size);
            }
            StringBuilder options = new StringBuilder();
            options.append("[");
            if (StringUtils.isNotBlank((CharSequence)page.getOption())) {
                options.append(page.getOption());
            }
            options.append("]");
            pageSizeOptions = options.toString();
        }
        tplman.setContent("rowsPerPage", rowsPerPage);
        tplman.setContent("pageSizeOptions", pageSizeOptions);
    }

    private void setGridForeignKeyProperty(Displaymodel showListGridDisplaymodel, String childModelId, FileTemplateManager tplman) {
        tplman.setContent("isForeignModel", "");
        String parentModelId = showListGridDisplaymodel.getForeignKeyIdref();
        if (StringUtils.isBlank((CharSequence)parentModelId)) {
            return;
        }
        Model childStoreModel = AppSchemaUtil.getModel(this.project, childModelId);
        ForeignKey[] fkeys = AppSchemaUtil.getForeignKey(childStoreModel);
        if (fkeys == null || fkeys.length == 0) {
            return;
        }
        Action showListAction = AppSchemaUtil.getActionByModelIdAndType(this.project, childModelId, "showList");
        this.setGridPageOption(showListAction, tplman);
        this.setGridForeignKeyProperty(fkeys, parentModelId, childModelId, showListAction, tplman);
    }

    private void setGridForeignKeyProperty(ForeignKey[] fkeys, String parentModelId, String childModelId, Action childModelShowListAction, FileTemplateManager tplman) {
        tplman.setContent("isForeignModel", "true");
        StringBuilder foreignKeyProperties = new StringBuilder();
        Conditionlist conditionlist = AppSchemaUtil.getConditionlist(childModelShowListAction);
        Model showListCpmodel = AppSchemaUtil.getConditionPModel(this.project, childModelShowListAction);
        for (ForeignKey fkey : fkeys) {
            String refname;
            String idref = fkey.getIdref();
            if (!parentModelId.equals(idref)) continue;
            ArrayList<String> conditionNames = new ArrayList<String>();
            Condition condition = AppSchemaUtil.getCondition(conditionlist, fkey.getName());
            if (condition != null) {
                String name = condition.getName();
                if ("BETWEEN".equals(condition.getCond())) {
                    conditionNames.add(AppSchemaUtil.createNameAttribute(this.project, name + condition.getStartPrefix(), showListCpmodel));
                    conditionNames.add(AppSchemaUtil.createNameAttribute(this.project, name + condition.getEndPrefix(), showListCpmodel));
                } else {
                    conditionNames.add(AppSchemaUtil.createNameAttribute(this.project, name, showListCpmodel));
                }
            }
            if (StringUtils.isBlank((CharSequence)(refname = fkey.getRefname()))) {
                refname = fkey.getName();
            }
            this.setGridForeignKeyProperty(parentModelId, refname, fkey.getName(), conditionNames, foreignKeyProperties);
        }
        foreignKeyProperties.insert(0, CR);
        foreignKeyProperties.insert(0, "foreignKeyProperties: [");
        foreignKeyProperties.append("      ").append("],");
        tplman.setContent("foreignKeyProperties", foreignKeyProperties.toString());
    }

    private void setGridForeignKeyProperty(String idref, String refname, String name, List<String> conditionNames, StringBuilder foreignKeyProperties) {
        foreignKeyProperties.append("        ").append("{").append(CR);
        foreignKeyProperties.append("          ").append("idref: '").append(idref).append("',").append(CR);
        foreignKeyProperties.append("          ").append("refname: '").append(refname).append("',").append(CR);
        foreignKeyProperties.append("          ").append("name: '").append(name).append("',").append(CR);
        foreignKeyProperties.append("          ").append("conditionParams: [").append(CR);
        for (String conditionName : conditionNames) {
            foreignKeyProperties.append("            ").append("'").append(conditionName).append("',").append(CR);
        }
        foreignKeyProperties.append("          ").append("],").append(CR);
        foreignKeyProperties.append("        ").append("},").append(CR);
    }

    protected void gInit_mobileFunc(StringBuilder sb, String tab) {
        this.gInit_createBtnSearchClickEventFunc(sb, "  ");
        this.gInit_createOpenSearchListOverlayFunc(sb, "  ");
        this.gInit_setTouchScrollDisableEvent(sb, "  ");
    }

    protected void gInit_createCheckboxSearchButtonEvent(StringBuilder sb, String tab) {
        if (this.smodel == null) {
            return;
        }
        if ("show".equals(this.action.getType())) {
            return;
        }
        IModelChoice[] simc = this.smodel.getContent();
        if (simc == null || simc.length == 0) {
            return;
        }
        this.checkboxSearchItems = new ArrayList<Modelitem>();
        Modelitem mitem = null;
        Displayitem displayitem = null;
        for (int i = 0; i < simc.length; ++i) {
            Relation rel;
            if (!(simc[i] instanceof Modelitem) || !"storeref".equals((mitem = (Modelitem)simc[i]).getType()) || (rel = AppSchemaUtil.getRelationTypeExceptRef(mitem)) == null || "check".equals(rel.getType()) && !"search".equals(rel.getUi())) continue;
            if (StringUtils.startsWith((CharSequence)this.presentation.getIdref(), (CharSequence)"showList") || StringUtils.startsWith((CharSequence)this.presentation.getIdref(), (CharSequence)"download") || StringUtils.startsWith((CharSequence)this.presentation.getIdref(), (CharSequence)"searchList") || StringUtils.startsWith((CharSequence)this.presentation.getIdref(), (CharSequence)"reportList")) {
                Displaycondition displaycondition = AppSchemaUtil.findDisplaycondition(this.presentation);
                displayitem = AppSchemaUtil.getDisplayitem(mitem.getName(), displaycondition);
            } else {
                displayitem = AppSchemaUtil.getDisplayitem(mitem.getName(), this.presentation);
            }
            if (displayitem == null || AppSchemaUtil.isHiddenDisplayitem(displayitem)) continue;
            this.checkboxSearchItems.add(mitem);
        }
        if (this.checkboxSearchItems.size() == 0) {
            return;
        }
        sb.append(tab).append("setCheckboxSearchButtonEvent();").append(CR);
    }

    protected void gInit_setJgroupnodeOrgChartButtonEvent(StringBuilder sb, String tab) {
        this.isJgroupnodeOrgChartDefined = AppSchemaUtil.isJgroupnodeOrgChartDefined(this.smodel, this.action);
        if (!this.isJgroupnodeOrgChartDefined) {
            return;
        }
        sb.append(tab).append("setJgroupnodeOrgChartButtonEvent();").append(CR);
    }

    protected void gInit_setSeparatePhonenumberEvent(StringBuilder sb, String tab) {
        if (this.presentation == null || this.pmodel == null || StringUtils.isBlank((CharSequence)this.actiontype) || !"insert".equals(this.actiontype) && !"update".equals(this.actiontype) && !"copy".equals(this.actiontype) && !"showList".equals(this.actiontype)) {
            return;
        }
        this.displaymodelsContainingSeparatePhonenumberItem = AppSchemaUtil.getIpcsContainingSeparatePhonenumberItem(this.presentation);
        if (this.displaymodelsContainingSeparatePhonenumberItem.isEmpty()) {
            return;
        }
        sb.append(tab).append("setSeparatePhonenumberEvent();").append(CR);
    }

    protected void gInit_setAutofillFuriganaEvent(StringBuilder sb, String tab) {
        if (!(this.presentation != null && this.pmodel != null && !StringUtils.isBlank((CharSequence)this.actiontype) && ("insert".equals(this.actiontype) || "update".equals(this.actiontype) || "copy".equals(this.actiontype) || "showList".equals(this.actiontype) && this.action.getUpdatelist()))) {
            return;
        }
        this.displaymodelsContainingfuriganaItem = AppSchemaUtil.getDisplaymodelContainingFuriganaItem(this.presentation);
        if (this.displaymodelsContainingfuriganaItem.isEmpty()) {
            return;
        }
        this.isAutofillFuriganaDefined = true;
        sb.append(tab).append("setAutofillFuriganaEvent();").append(CR);
    }

    protected void gInit_setUifunctionEvent(StringBuilder sb, String tab) {
        if (this.presentation == null || this.pmodel == null || StringUtils.isBlank((CharSequence)this.actiontype) || !"insert".equals(this.actiontype) && !"update".equals(this.actiontype) && !"copy".equals(this.actiontype)) {
            return;
        }
        if (this.uifunctions == null || this.uifunctions.isEmpty()) {
            return;
        }
        sb.append(tab).append("setUifunctionEvent();").append(CR);
    }

    protected void gInit_createSetBtnSetValuesToParentClickEvent(StringBuilder sb, String tab) {
        if (this.presentation == null || !StringUtils.startsWith((CharSequence)this.presentation.getIdref(), (CharSequence)"searchList")) {
            return;
        }
        sb.append(tab).append("setBtnSetValuesToParentClickEvent();").append(CR);
    }

    protected void gInit_createBtnSearchClickEventFunc(StringBuilder sb, String tab) {
        if (!AppSchemaUtil.isMobile(this.presentation) || !"showList".equals(this.actiontype)) {
            return;
        }
        sb.append(tab).append("setJfcToolBarBtnSearchClickEvent();").append(CR);
    }

    protected void gInit_createOpenSearchListOverlayFunc(StringBuilder sb, String tab) {
        if (!this.isMobileRefSearchDefined) {
            return;
        }
        sb.append(tab).append("setOpenSearchListOverlayFunc();").append(CR);
    }

    protected void gInit_setTouchScrollDisableEvent(StringBuilder sb, String tab) {
        if (!AppSchemaUtil.isMobile(this.presentation) || this.smodel == null) {
            return;
        }
        Modelitem[] parents = AppSchemaUtil.getAllParent(this.smodel);
        if (parents == null || parents.length == 0) {
            return;
        }
        sb.append(tab).append("setTouchScrollDisableEvent();").append(CR);
    }

    protected void gInit_createUpdateListDeleteCheckboxEvent(StringBuilder sb, String tab) {
        if (this.presentation == null) {
            return;
        }
        if (!StringUtils.startsWith((CharSequence)this.presentation.getIdref(), (CharSequence)"updateList")) {
            ArrayList list = new ArrayList();
            this.accept(this.presentation, (IRNode arg) -> {
                if (arg == null || !(arg instanceof Displaymodel)) {
                    return;
                }
                Displaymodel displaymodel = (Displaymodel)arg;
                if (StringUtils.isNotBlank((CharSequence)displaymodel.getType()) && StringUtils.isNotBlank((CharSequence)displaymodel.getIdref()) && StringUtils.isNotBlank((CharSequence)displaymodel.getOutputfilename()) && StringUtils.isNotBlank((CharSequence)displaymodel.getActionheader()) && displaymodel.getType().equals("showList") && displaymodel.getIdref().endsWith("_ulp") && displaymodel.getOutputfilename().startsWith("updateList") && displaymodel.getActionheader().startsWith("UserDefined_") && displaymodel.getActionheader().endsWith(":")) {
                    list.add(displaymodel);
                }
            });
            if (list.size() == 0) {
                return;
            }
        }
        sb.append(tab).append("setUpdateListDeleteCheckboxClickEvent();").append(CR);
    }

    private void gInit_createUpdateListInitFunc(StringBuilder sb, String tab) {
        if (this.action == null || this.presentation == null || !AppSchemaUtil.isCSSLayout(this.presentation)) {
            return;
        }
        List<String> updateListModelIds = null;
        boolean isOutsidekeyModel = false;
        if ("showList".equals(this.action.getType()) && this.action.getUpdatelist()) {
            updateListModelIds = Arrays.asList(StringUtils.wrap((String)this.action.getIdref(), (String)"\""));
        } else {
            updateListModelIds = this.getUpdateListModelIds();
            isOutsidekeyModel = true;
        }
        if (updateListModelIds.size() == 0) {
            return;
        }
        sb.append(tab).append("initUpdateListTables({").append(CR).append(tab).append("  ").append(StringUtils.wrap((String)"modelIds", (String)"\"")).append(": [").append(StringUtils.join(updateListModelIds, (String)", ")).append("],").append(CR).append(tab).append("  ").append(StringUtils.wrap((String)"isOutsidekeyModel", (String)"\"")).append(": ").append(isOutsidekeyModel).append(",").append(CR).append(tab).append("});").append(CR);
    }

    private List<String> getUpdateListModelIds() {
        Dataitem[] dataitems = AppSchemaUtil.getDataitems(this.action);
        if (dataitems == null) {
            return new ArrayList<String>();
        }
        return Stream.of(dataitems).filter(d -> "updateList".equals(d.getType())).map(d -> StringUtils.wrap((String)StringUtils.substringBefore((String)d.getIdref(), (String)"_ulp"), (String)"\"")).collect(Collectors.toList());
    }

    protected void accept(Presentation o, Consumer<IRNode> cons) {
        if (o == null) {
            return;
        }
        cons.accept(o);
        Layout layout = o.getLayout();
        this.accept(layout, cons);
    }

    protected void accept(Layout o, Consumer<IRNode> cons) {
        if (o == null) {
            return;
        }
        cons.accept(o);
        for (Panel panel : o.getPanel()) {
            this.accept(panel, cons);
        }
    }

    protected void accept(Panel o, Consumer<IRNode> cons) {
        if (o == null) {
            return;
        }
        cons.accept(o);
        for (IPanelChoice ipc : o.getContent()) {
            if (ipc instanceof Displaymodel) {
                this.accept((Displaymodel)ipc, cons);
            }
            if (!(ipc instanceof Displaymodelgroup)) continue;
            this.accept((Displaymodelgroup)ipc, cons);
        }
    }

    protected void accept(Displaymodel o, Consumer<IRNode> cons) {
        if (o == null) {
            return;
        }
        cons.accept(o);
    }

    protected void accept(Displaymodelgroup o, Consumer<IRNode> cons) {
        if (o == null) {
            return;
        }
        cons.accept(o);
        for (IDisplaymodelgroupChoice ipc : o.getContent()) {
            if (ipc instanceof Displaymodel) {
                this.accept((Displaymodel)ipc, cons);
            }
            if (!(ipc instanceof Panelgroup)) continue;
            this.accept((Panelgroup)ipc, cons);
        }
    }

    protected void accept(Panelgroup o, Consumer<IRNode> cons) {
        if (o == null) {
            return;
        }
        cons.accept(o);
        for (Panel panel : o.getPanel()) {
            this.accept(panel, cons);
        }
    }

    public static String createJsFunctionName_actionParam(Displayitem ditem) {
        if (ditem == null) {
            return "";
        }
        return "createActionParam_" + AppSchemaUtil.getChildPart(ditem.getName());
    }

    public void addUifunction(Displayitem ditem, Uifunction uifunction) {
        List<Uifunction> uifunctionSet;
        if (this.uifunctions == null) {
            this.uifunctions = new LinkedHashMap<Displayitem, List<Uifunction>>();
        }
        if ((uifunctionSet = this.uifunctions.get(ditem)) == null) {
            uifunctionSet = new ArrayList<Uifunction>();
        }
        uifunctionSet.add(uifunction);
        this.uifunctions.put(ditem, uifunctionSet);
    }

    public void setCreateRelationValuesFunc(boolean isCreate) {
        this.isCreateRelationValuesFunc = isCreate;
    }

    protected void gInit_createRelationValuesFunc(StringBuilder sb, String TAB2) {
        String restType;
        if (!(this.isCreateRelationValuesFunc && ("showList".equals(this.actiontype) && this.action.getUpdatelist() || "insert".equals(this.actiontype) || "copy".equals(this.actiontype) || "update".equals(this.actiontype)))) {
            return;
        }
        StringBuilder modelId = new StringBuilder();
        modelId.append(JspPanelContentBase.createActionId(this.action, this.action.getIdref()));
        if ("showList".equals(this.actiontype) && this.action.getUpdatelist()) {
            modelId.append("_ulp");
        } else {
            modelId.append("_p");
        }
        if ("showList".equals(this.actiontype) && this.action.getUpdatelist()) {
            restType = "updatelist";
        } else if ("insert".equals(this.actiontype)) {
            restType = "new";
        } else if ("copy".equals(this.actiontype)) {
            restType = "copy";
        } else if ("update".equals(this.actiontype)) {
            restType = "edit";
        } else {
            restType = "edit";
            logger.error("Unknown relation rest api action type " + this.actiontype + " in action " + this.action.getId());
        }
        sb.append(TAB2).append("createGetRelationValuesFunc(").append("\"").append(modelId.toString()).append("\"").append(", \"rest/").append(this.smodel.getId()).append("/").append(restType).append("/relation\");").append(CR);
    }

    public void gGetRelationValuesCode(StringBuilder sb) {
        this.setCreateRelationValuesFunc(true);
        if (sb.indexOf("getRelationValues();") != -1) {
            return;
        }
        sb.append("getRelationValues();");
    }

    public void setMultipleLayoutDefined(boolean value) {
        this.isCssLayoutMultipleLayoutDefined = value;
    }

    public void gInit_setTableRowHoverEvent(StringBuilder sb, String tab2) {
        if (!this.isCssLayoutMultipleLayoutDefined) {
            return;
        }
        sb.append("  ").append("setTableRowHoverEvent();").append(CR);
    }

    private void gInit_setInputCheckRegexpFunc(StringBuilder sb, String tab2) {
        if (this.inputCheckRegexp == null || this.inputCheckRegexp.isEmpty()) {
            return;
        }
        sb.append("  ").append("setInputCheckRegExp();").append(CR);
    }

    private void gInit_setCalendarViewAllDayItemEvent(StringBuilder sb, String tab) {
        if (!("insert".equals(this.actiontype) || "update".equals(this.actiontype) || "copy".equals(this.actiontype))) {
            return;
        }
        Action calendarViewAction = AppSchemaUtil.getActionByModelIdAndTypeAndView(this.project, this.action.getIdref(), "showList", "calendar");
        if (calendarViewAction == null || !"modern".equals(AppSchemaUtil.getDisplaycalendarType(this.project, calendarViewAction))) {
            return;
        }
        View view = AppSchemaUtil.getView(calendarViewAction);
        Item startTimeItem = AppSchemaUtil.getItem("starttime", view);
        Item endTimeItem = AppSchemaUtil.getItem("endtime", view);
        Item allDayItem = AppSchemaUtil.getItem("allDay", view);
        if (startTimeItem == null || endTimeItem == null || allDayItem == null) {
            return;
        }
        String allDayLabelId = AppSchemaUtil.createNameAttribute(this.project, allDayItem.getContent(), this.pmodel);
        allDayLabelId = StringUtils.replace((String)allDayLabelId, (String)"${fn:escapeXml(c.id)}", (String)"1");
        sb.append("  ").append("setCalendarViewAllDayItemEvent(").append(StringUtils.wrap((String)AppSchemaUtil.createNameAttribute(this.project, startTimeItem.getContent(), this.pmodel), (String)"\"")).append(", ").append(StringUtils.wrap((String)AppSchemaUtil.createNameAttribute(this.project, endTimeItem.getContent(), this.pmodel), (String)"\"")).append(", ").append(StringUtils.wrap((String)allDayLabelId, (String)"\"")).append(");").append(CR);
    }

    private String gInputCheckRegexpFunc() {
        if (this.inputCheckRegexp == null || this.inputCheckRegexp.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("function setInputCheckRegExp() {").append(CR).append("  ").append("setWidgetPatternAttr({").append(CR);
        this.inputCheckRegexp.entrySet().stream().forEach(m -> sb.append("    ").append(StringUtils.wrap((String)((String)m.getKey()), (char)'\"')).append(": ").append(StringUtils.wrap((String)((String)m.getValue()), (char)'\"')).append(",").append(CR));
        sb.append("  ").append("});").append(CR).append("}").append(CR).append(CR);
        return sb.toString();
    }

    public void addInputCheckRegexp(String labelid, String regexp) {
        if (StringUtils.isBlank((CharSequence)labelid) || StringUtils.isBlank((CharSequence)regexp)) {
            return;
        }
        if (this.inputCheckRegexp == null) {
            this.inputCheckRegexp = new LinkedHashMap<String, String>();
        }
        String escapedRegExp = Matcher.quoteReplacement(regexp);
        escapedRegExp = escapedRegExp.replaceAll("\"", Matcher.quoteReplacement("\\\""));
        this.inputCheckRegexp.put(labelid, escapedRegExp);
    }

    private void gInit_setDirectcopyEvent(StringBuilder sb, String tab) {
        if (!("insert".equals(this.actiontype) || "update".equals(this.actiontype) || "copy".equals(this.actiontype))) {
            return;
        }
        Stream.of(this.pmodel.getContent()).filter(i -> i instanceof Modelitem).map(i -> (Modelitem)i).forEach(pitem -> {
            Modelitem sitem;
            Directcopy dcopy = AppSchemaUtil.getDirectcopy(pitem);
            if (dcopy != null && this.isDirectcopySettingValid((Modelitem)pitem, dcopy, sitem = AppSchemaUtil.getModelitem(pitem.getName(), this.smodel))) {
                this.setDirectcopySettings((Modelitem)pitem, sitem, dcopy);
            }
        });
        if (this.directCopySettings == null || this.directCopySettings.isEmpty()) {
            return;
        }
        sb.append("  ").append("setDirectcopyEvent();").append(CR);
    }

    private boolean isDirectcopySettingValid(Modelitem pitem, Directcopy dcopy, Modelitem sitem) {
        if (sitem.getMultiple()) {
            Object[] o = new Object[]{this.smodel.getId(), dcopy.getTarget(), sitem.getName()};
            logger.warn(rman.getValue("js.directcopy.notsupport.multiple", o));
            return false;
        }
        if (AppSchemaUtil.hasChildPart(sitem.getName()) && !AppSchemaUtil.hasChildPart(dcopy.getTarget())) {
            Object[] o = new Object[]{this.smodel.getId(), dcopy.getTarget(), sitem.getName()};
            logger.warn(rman.getValue("js.directcopy.notsupport.container", o));
            return false;
        }
        if (!AppSchemaUtil.hasChildPart(sitem.getName()) && AppSchemaUtil.hasChildPart(dcopy.getTarget())) {
            Object[] o = new Object[]{this.smodel.getId(), sitem.getName(), dcopy.getTarget()};
            logger.warn(rman.getValue("js.directcopy.notsupport.container2", o));
            return false;
        }
        return true;
    }

    private void setDirectcopySettings(Modelitem pitem, Modelitem sitem, Directcopy dcopy) {
        String srcItemId;
        List<String> directCopyTargets;
        if (this.directCopySettings == null) {
            this.directCopySettings = new TreeMap<String, List<String>>();
        }
        if ((directCopyTargets = this.directCopySettings.get(srcItemId = AppSchemaUtil.createNameAttribute_th(this.project, dcopy.getTarget(), this.pmodel, false))) == null) {
            directCopyTargets = new ArrayList<String>();
        }
        String targetItemId = AppSchemaUtil.createNameAttribute_th(this.project, pitem.getName(), this.pmodel, false);
        StringBuilder sb = new StringBuilder();
        sb.append("      ").append("{").append(CR).append("        ").append("id: '").append(targetItemId).append("',").append(CR).append("        ").append("type: '").append(sitem.getType()).append("',").append(CR).append("        ").append("forceCopy: ").append(dcopy.getForce()).append(",").append(CR).append("      ").append("},").append(CR);
        directCopyTargets.add(sb.toString());
        this.directCopySettings.put(srcItemId, directCopyTargets);
    }

    private String gDirectcopyFunc() {
        if (this.directCopySettings == null || this.directCopySettings.isEmpty()) {
            return "";
        }
        StringBuilder settings = new StringBuilder();
        this.directCopySettings.entrySet().stream().forEach(s -> {
            settings.append("  ").append("{").append(CR).append("    ").append("src: '").append((String)s.getKey()).append("',").append(CR).append("    ").append("targets: [").append(CR);
            ((List)s.getValue()).forEach(t -> settings.append((String)t));
            settings.append("    ").append("],").append(CR).append("  ").append("},").append(CR);
        });
        StringBuilder sb = new StringBuilder();
        sb.append("function setDirectcopyEvent() {").append(CR).append("  ").append("setDirectcopyEventToWidget([").append(CR).append(settings.toString()).append("  ").append("]);").append(CR).append("}").append(CR).append(CR);
        return sb.toString();
    }

    class ChangeSelectMethod {
        String functionName;
        String labelid;
        String labelid2;
        boolean isContainer;

        public ChangeSelectMethod(String functionName, String labelid, String labelid2, boolean isContainer) {
            this.functionName = functionName;
            this.labelid = labelid;
            this.labelid2 = labelid2;
            this.isContainer = isContainer;
        }
    }

    class DisableCtrlManager {
        String srcCtrlName;
        String srcCtrlNamePrefix;
        String srcCtrlNameSuffix;
        List<DisableCtrl> targetCtrls;
        boolean isKeepValue = false;
        boolean isContainerItem = false;
        private Model pmodel2;
        private Displayitem ditem;

        public DisableCtrlManager(String srcCtrlName, Model pmodel2, Displayitem ditem) {
            this.srcCtrlName = srcCtrlName;
            this.targetCtrls = new ArrayList<DisableCtrl>();
            this.pmodel2 = pmodel2;
            this.ditem = ditem;
            this.splitSrcCtrlName();
        }

        private void splitSrcCtrlName() {
            if (StringUtils.contains((CharSequence)this.srcCtrlName, (CharSequence)JavaScriptManager.CONTAINER_LOOP_INDEX)) {
                this.isContainerItem = true;
                this.srcCtrlNamePrefix = StringUtils.substringBefore((String)this.srcCtrlName, (String)JavaScriptManager.CONTAINER_LOOP_INDEX);
                this.srcCtrlNameSuffix = StringUtils.substringAfter((String)this.srcCtrlName, (String)JavaScriptManager.CONTAINER_LOOP_INDEX);
            } else if (StringUtils.contains((CharSequence)this.srcCtrlName, (CharSequence)JavaScriptManager.CONTAINER_CHECKBOX_LOOP_INDEX)) {
                this.isContainerItem = true;
                this.srcCtrlNamePrefix = StringUtils.substringBefore((String)this.srcCtrlName, (String)JavaScriptManager.CONTAINER_CHECKBOX_LOOP_INDEX);
                this.srcCtrlNameSuffix = StringUtils.substringAfter((String)this.srcCtrlName, (String)JavaScriptManager.CONTAINER_CHECKBOX_LOOP_INDEX);
            } else if (StringUtils.contains((CharSequence)this.srcCtrlName, (CharSequence)JavaScriptManager.TH_CONTAINER_CHECKBOX_LOOP_INDEX)) {
                this.isContainerItem = true;
                this.srcCtrlNamePrefix = StringUtils.substringBefore((String)this.srcCtrlName, (String)JavaScriptManager.TH_CONTAINER_CHECKBOX_LOOP_INDEX);
                this.srcCtrlNameSuffix = StringUtils.substringAfter((String)this.srcCtrlName, (String)JavaScriptManager.TH_CONTAINER_CHECKBOX_LOOP_INDEX);
            } else if (StringUtils.contains((CharSequence)this.srcCtrlName, (CharSequence)JavaScriptManager.TH_CONTAINER_LOOP_INDEX)) {
                this.isContainerItem = true;
                this.srcCtrlNamePrefix = StringUtils.substringBefore((String)this.srcCtrlName, (String)JavaScriptManager.TH_CONTAINER_LOOP_INDEX);
                this.srcCtrlNameSuffix = StringUtils.substringAfter((String)this.srcCtrlName, (String)JavaScriptManager.TH_CONTAINER_LOOP_INDEX);
            }
        }

        public void addTargetCtrl(String ctrlName, String type, String value) {
            DisableCtrl dc = new DisableCtrl(ctrlName, type, value);
            boolean isSameTargetIn = false;
            for (int i = 0; i < this.targetCtrls.size(); ++i) {
                DisableCtrl already_added_dc = this.targetCtrls.get(i);
                if (!already_added_dc.equals(dc)) continue;
                already_added_dc.addValue(value);
                isSameTargetIn = true;
                break;
            }
            if (!isSameTargetIn) {
                this.targetCtrls.add(dc);
            }
        }

        public void addTargetCtrl(String ctrlName, String type, String value, Displayitem ditem) {
            DisableCtrl dc = new DisableCtrl(ctrlName, type, value, ditem);
            boolean isSameTargetIn = false;
            for (int i = 0; i < this.targetCtrls.size(); ++i) {
                DisableCtrl already_added_dc = this.targetCtrls.get(i);
                if (!already_added_dc.equals(dc)) continue;
                already_added_dc.addValue(value);
                isSameTargetIn = true;
                break;
            }
            if (!isSameTargetIn) {
                this.targetCtrls.add(dc);
            }
        }

        public void setKeepValue() {
            this.isKeepValue = true;
        }

        public boolean isKeepValue() {
            return this.isKeepValue;
        }

        public String getJavaScriptCode(String num) {
            if (this.pmodel2.getUpdatelist()) {
                return this.getJavaScriptCodeUpdatelist(num);
            }
            return this.getJavaScriptCodePresentation(num);
        }

        public String getJavaString(String s) {
            if (this.pmodel2.getUpdatelist()) {
                s = ((String)s).replace(JavaScriptManager.CONTAINER_CHECKBOX_LOOP_INDEX, "\"+i+\"");
                s = ((String)s).replace("${__position.count}", "\"+i+\"");
                s = ((String)s).replace(JavaScriptManager.TH_CONTAINER_CHECKBOX_LOOP_INDEX, "\"+i+\"");
                if (StringUtils.startsWith((CharSequence)(s = ((String)s).replace(JavaScriptManager.TH_CONTAINER_LOOP_INDEX, "\"+i+\"")), (CharSequence)"/") && StringUtils.endsWith((CharSequence)s, (CharSequence)"/")) {
                    s = ((String)s).substring(1, ((String)s).length() - 2);
                    s = ((String)s).replace("\\$", "\\\\$");
                    s = ((String)s).replace("\\w", "\\\\w");
                    s = "new RegExp(\"" + (String)s + "\")";
                    return s;
                }
            } else {
                if (StringUtils.contains((CharSequence)s, (CharSequence)JavaScriptManager.CONTAINER_LOOP_INDEX)) {
                    s = StringUtils.replace((String)s, (String)"$", (String)"\\$");
                    s = StringUtils.replace((String)s, (String)JavaScriptManager.CONTAINER_LOOP_INDEX, (String)"\\d+");
                    StringBuilder sb = new StringBuilder();
                    sb.append("/^").append((String)s).append("$/");
                    return sb.toString();
                }
                if (StringUtils.startsWith((CharSequence)s, (CharSequence)"/") && StringUtils.endsWith((CharSequence)s, (CharSequence)"/")) {
                    if (StringUtils.contains((CharSequence)s, (CharSequence)JavaScriptManager.CONTAINER_CHECKBOX_LOOP_INDEX)) {
                        s = StringUtils.replace((String)s, (String)JavaScriptManager.CONTAINER_CHECKBOX_LOOP_INDEX, (String)"\\d+");
                    }
                    return s;
                }
            }
            StringBuilder sb = new StringBuilder();
            sb.append("\"").append((String)s).append("\"");
            return sb.toString();
        }

        public boolean isTargetCtrlContainerItem() {
            for (int i = 0; i < this.targetCtrls.size(); ++i) {
                DisableCtrl dc = this.targetCtrls.get(i);
                if (!dc.isContainerItem) continue;
                return true;
            }
            return false;
        }

        public String getJavaScriptCodePresentation(String num) {
            String cdmName = "cdm" + num;
            StringBuilder sb = new StringBuilder();
            if (Integer.valueOf(num) > 1) {
                sb.append(ISourceVariable.CR);
            }
            if (this.isContainerItem && this.isTargetCtrlContainerItem()) {
                sb.append(this.getJavaScriptCodeContainer());
            } else {
                sb.append("      ").append(cdmName).append(" = new CtrlDisableManager(");
                sb.append(this.getJavaString(this.srcCtrlName));
                sb.append(");").append(ISourceVariable.CR);
                this.getJavaScriptCodePresentation("      ", sb, cdmName);
                sb.append(this.getAddCtrlDisableManagerCode("      ", cdmName));
            }
            return sb.toString();
        }

        public String getJavaScriptCodeContainer() {
            Object srcCtrlNamePrefix;
            boolean isPseudoCheckbox;
            StringBuilder sb = new StringBuilder();
            boolean isSrcCtrlCheckBox = false;
            boolean bl = isPseudoCheckbox = this.ditem != null && "pseudo_checkbox".equals(this.ditem.getType());
            if (StringUtils.contains((CharSequence)this.srcCtrlName, (CharSequence)"\\-?\\w") || isPseudoCheckbox) {
                isSrcCtrlCheckBox = true;
                srcCtrlNamePrefix = StringUtils.replace((String)StringUtils.substringAfter((String)this.srcCtrlNamePrefix, (String)"/^"), (String)"\\", (String)"");
            } else {
                srcCtrlNamePrefix = this.srcCtrlNamePrefix;
                if (this.ditem.getReadonly() && !"hidden".equals(this.ditem.getType())) {
                    srcCtrlNamePrefix = "content_" + (String)srcCtrlNamePrefix;
                }
            }
            String srcNodeTagName = "input";
            String srcNodeAttrName = "name";
            if (this.ditem.getReadonly() && !"hidden".equals(this.ditem.getType())) {
                srcNodeTagName = "span";
                srcNodeAttrName = "id";
            }
            sb.append("      ").append(srcNodeAttrName).append(" = \"\";").append(ISourceVariable.CR);
            sb.append("      ").append("query(\"").append(srcNodeTagName).append("[").append(srcNodeAttrName).append("^='").append((String)srcCtrlNamePrefix).append("'][").append(srcNodeAttrName);
            if (isPseudoCheckbox) {
                sb.append("$='").append(StringUtils.substringBefore((String)this.srcCtrlNameSuffix, (String)"$/"));
            } else if (isSrcCtrlCheckBox) {
                sb.append("*='").append(StringUtils.replace((String)StringUtils.substringBefore((String)this.srcCtrlNameSuffix, (String)"\\-?\\w+"), (String)"\\", (String)""));
            } else {
                sb.append("$='").append(this.srcCtrlNameSuffix);
            }
            sb.append("']\").forEach(function(node) {").append(ISourceVariable.CR).append("        ").append("if (").append(srcNodeAttrName).append(" !== node.").append(srcNodeAttrName).append(") {").append(ISourceVariable.CR);
            if (isSrcCtrlCheckBox) {
                sb.append("          ").append("var row = node.name.replace(\"").append((String)srcCtrlNamePrefix).append("\", \"\");").append(ISourceVariable.CR).append("          ").append("row = row.substring(0, row.indexOf(\"" + StringUtil.convertHtmlIdString((String)"]") + "\"));").append(ISourceVariable.CR).append("          ").append("var cdm = new CtrlDisableManager(").append(this.getContainerItemName(this.srcCtrlNamePrefix, this.srcCtrlNameSuffix)).append(");").append(ISourceVariable.CR);
            } else {
                sb.append("          ").append("var row = node.").append(srcNodeAttrName).append(".replace(\"").append((String)srcCtrlNamePrefix).append("\", \"\").replace(\"").append(this.srcCtrlNameSuffix).append("\", \"\");").append(ISourceVariable.CR).append("          ").append("var cdm = new CtrlDisableManager(node.").append(srcNodeAttrName).append(");").append(ISourceVariable.CR);
            }
            sb.append(this.getJavaScriptCodeContainerTargetCtrl()).append("          ").append("cdm.addEvent(cdm);").append(ISourceVariable.CR).append("          ").append("cdm.changeTargetCtrlDisabled();").append(ISourceVariable.CR).append("          ").append("addCtrlDisableManager(cdm);").append(ISourceVariable.CR).append("          ").append(srcNodeAttrName).append(" = node.").append(srcNodeAttrName).append(";").append(ISourceVariable.CR).append("        ").append("}").append(ISourceVariable.CR).append("      ").append("});").append(ISourceVariable.CR);
            return sb.toString();
        }

        public String getJavaScriptCodeContainerTargetCtrl() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.targetCtrls.size(); ++i) {
                DisableCtrl ctrl = this.targetCtrls.get(i);
                sb.append("          ").append("cdm.addTargetCtrl(");
                if (ctrl.isContainerItem) {
                    sb.append(this.getContainerItemName(ctrl.ctrlNamePrefix, ctrl.ctrlNameSuffix));
                } else {
                    sb.append(ctrl.ctrlName);
                }
                sb.append(this.getTargetCtrlConditionValues(ctrl));
            }
            return sb.toString();
        }

        public String getContainerItemName(String prefix, String suffix) {
            StringBuilder sb = new StringBuilder();
            if (StringUtils.startsWith((CharSequence)prefix, (CharSequence)"/^") && StringUtils.endsWith((CharSequence)suffix, (CharSequence)"$/")) {
                sb.append("new RegExp(\"").append(StringUtils.replace((String)StringUtils.substringAfter((String)prefix, (String)"/"), (String)"\\", (String)"\\\\")).append("\" + row + \"").append(StringUtils.replace((String)StringUtils.substringBeforeLast((String)suffix, (String)"/"), (String)"\\", (String)"\\\\")).append("\")");
            } else {
                sb.append("\"").append(prefix).append("\" + row + \"").append(suffix).append("\"");
            }
            return sb.toString();
        }

        public String getSrcCtrlNameQuery(String s) {
            String srcCtrlName = s;
            boolean isItemTypeCheck = false;
            if (StringUtils.startsWith((CharSequence)s, (CharSequence)"/") && StringUtils.endsWith((CharSequence)s, (CharSequence)"/")) {
                srcCtrlName = s.substring(2, s.length() - 2);
                srcCtrlName = StringUtils.substringBefore((String)srcCtrlName, (String)"\\-?\\w");
                srcCtrlName = StringUtils.replace((String)srcCtrlName, (String)"\\", (String)"");
                isItemTypeCheck = true;
            }
            String[] srcCtrlNames = StringUtils.splitByWholeSeparator((String)srcCtrlName, (String)"${__position.count}");
            StringBuilder sb = new StringBuilder();
            sb.append("input[name^='").append(srcCtrlNames[0]).append("']").append("[name");
            if (isItemTypeCheck) {
                sb.append("*");
            } else {
                sb.append("$");
            }
            sb.append("='").append(srcCtrlNames[1]).append("']");
            return sb.toString();
        }

        public String getJavaScriptCodeUpdatelist(String num) {
            String cdmName = "cdm" + num;
            if (StringUtils.startsWith((CharSequence)this.srcCtrlName, (CharSequence)"/") && StringUtils.endsWith((CharSequence)this.srcCtrlName, (CharSequence)"/")) {
                return this.getCheckBoxJavaScriptCodeUpdatelist(cdmName);
            }
            StringBuilder sb = new StringBuilder();
            sb.append("      ").append("srcCtrlNameSet = {};").append(ISourceVariable.CR).append("      ").append("query(\"").append(this.getSrcCtrlNameQuery(this.srcCtrlName)).append("\").forEach(function(node) {").append(ISourceVariable.CR).append("        ").append("if (!srcCtrlNameSet[node.name]) {").append(ISourceVariable.CR).append("          ").append("var i = node.name.substring(node.name.indexOf(\"_005b\") + 5).split(\"_005d\")[0];").append(ISourceVariable.CR).append("          ").append(cdmName).append(" = new CtrlDisableManager(node.name);").append(ISourceVariable.CR);
            this.getJavaScriptCodePresentation("          ", sb, cdmName);
            sb.append(this.getAddCtrlDisableManagerCode("          ", cdmName)).append("          ").append("srcCtrlNameSet[node.name] = true;").append(ISourceVariable.CR).append("        ").append("}").append(ISourceVariable.CR).append("      ").append("});").append(ISourceVariable.CR);
            return sb.toString();
        }

        public String getCheckBoxJavaScriptCodeUpdatelist(String cdmName) {
            StringBuilder sb = new StringBuilder();
            sb.append("      ").append("var prevIndex;").append(ISourceVariable.CR).append("      ").append("var srcCtrlNamesByRow = {};").append(ISourceVariable.CR).append("      ").append("query(\"").append(this.getSrcCtrlNameQuery(this.srcCtrlName)).append("\").forEach(function(node) {").append(ISourceVariable.CR).append("        ").append("var i = node.name.substring(node.name.indexOf(\"_005b\") + 5).split(\"_005d\")[0];").append(ISourceVariable.CR).append("        ").append("if (prevIndex !== i) {").append(ISourceVariable.CR).append("          ").append("var srcCtrlNames = [];").append(ISourceVariable.CR).append("          ").append("srcCtrlNames.push(node.name);").append(ISourceVariable.CR).append("          ").append("srcCtrlNamesByRow[i] = srcCtrlNames;").append(ISourceVariable.CR).append("        ").append("} else {").append(ISourceVariable.CR).append("          ").append("srcCtrlNamesByRow[i].push(node.name);").append(ISourceVariable.CR).append("        ").append("}").append(ISourceVariable.CR).append("        ").append("prevIndex = i;").append(ISourceVariable.CR).append("      ").append("});").append(ISourceVariable.CR).append("      ").append("for (var i in srcCtrlNamesByRow) {").append(ISourceVariable.CR).append("        ").append("var srcCtrlNames = srcCtrlNamesByRow[i];").append(ISourceVariable.CR).append("        ").append("srcCtrlNames.forEach(function(name) {").append(ISourceVariable.CR).append("          ").append(cdmName).append(" = new CtrlDisableManager(srcCtrlNames);").append(ISourceVariable.CR);
            this.getJavaScriptCodePresentation("          ", sb, cdmName);
            sb.append(this.getAddCtrlDisableManagerCode("          ", cdmName)).append("        ").append("});").append(ISourceVariable.CR).append("      ").append("}").append(ISourceVariable.CR);
            return sb.toString();
        }

        public void getJavaScriptCodePresentation(String tab, StringBuilder sb, String cdmName) {
            for (int i = 0; i < this.targetCtrls.size(); ++i) {
                DisableCtrl ctrl = this.targetCtrls.get(i);
                if (StringUtils.contains((CharSequence)ctrl.getCtrlName(), (CharSequence)JavaScriptManager.CONTAINER_LOOP_INDEX)) {
                    sb.append(this.getContainerItemTargetCtrlCondition(cdmName, ctrl, tab));
                    continue;
                }
                sb.append(this.getTargetCtrlCondition(cdmName, ctrl, tab));
            }
        }

        public String getAddCtrlDisableManagerCode(String tab, String cdmName) {
            StringBuilder sb = new StringBuilder();
            sb.append(tab).append(cdmName).append(".addEvent(").append(cdmName).append(");").append(ISourceVariable.CR).append(tab).append(cdmName).append(".changeTargetCtrlDisabled();").append(ISourceVariable.CR).append(tab).append("addCtrlDisableManager(").append(cdmName).append(");").append(ISourceVariable.CR);
            return sb.toString();
        }

        public String getContainerItemTargetCtrlCondition(String cdmName, DisableCtrl ctrl, String tab) {
            StringBuilder sb = new StringBuilder();
            String query = "name";
            sb.append(tab).append("query(\"input[").append(query).append("^='").append(ctrl.ctrlNamePrefix).append("']").append("[").append(query).append("$='").append(ctrl.ctrlNameSuffix).append("']\")").append(".forEach(function(node) {").append(ISourceVariable.CR);
            sb.append(tab).append("  ").append(cdmName).append(".addTargetCtrl(node.").append(query);
            sb.append(this.getTargetCtrlConditionValues(ctrl));
            sb.append(tab).append("});").append(ISourceVariable.CR);
            return sb.toString();
        }

        public String getTargetCtrlCondition(String cdmName, DisableCtrl ctrl, String tab) {
            StringBuilder sb = new StringBuilder();
            sb.append(tab).append(cdmName).append(".addTargetCtrl(").append(this.getJavaString(ctrl.getCtrlName()));
            sb.append(this.getTargetCtrlConditionValues(ctrl));
            return sb.toString();
        }

        public String getTargetCtrlConditionValues(DisableCtrl ctrl) {
            StringBuilder sb = new StringBuilder();
            List<String> values = ctrl.getValues();
            sb.append(", \"").append(ctrl.getType()).append("\"").append(", [\"").append(values.get(0)).append("\"");
            for (int j = 1; j < values.size(); ++j) {
                sb.append(", \"").append(values.get(j)).append("\"");
            }
            sb.append("]);").append(ISourceVariable.CR);
            return sb.toString();
        }
    }

    class TabManager {
        String defaultTabId;
        String srcCtrlName;
        Map<String, Set<String>> selectTabCondition = new TreeMap<String, Set<String>>();
        Map<String, Set<String>> tabVisibilityCondition = new TreeMap<String, Set<String>>();

        public void setDefaultTabId(String defaultTabId) {
            this.defaultTabId = defaultTabId;
        }

        public String getDefaultTabId() {
            return this.defaultTabId;
        }

        public void addSelectTabCondition(String ctrlId, String condition) {
            Set<String> conditionSet = this.selectTabCondition.get(ctrlId);
            if (conditionSet == null) {
                conditionSet = new TreeSet<String>();
            }
            conditionSet.add(condition);
            this.selectTabCondition.put(ctrlId, conditionSet);
        }

        public void addTabVisibilityCondition(String ctrlId, String condition) {
            Set<String> conditionSet = this.tabVisibilityCondition.get(ctrlId);
            if (conditionSet == null) {
                conditionSet = new TreeSet<String>();
            }
            conditionSet.add(condition);
            this.tabVisibilityCondition.put(ctrlId, conditionSet);
        }

        public String getSelectTabConditions() {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, Set<String>> entry : this.selectTabCondition.entrySet()) {
                LinkedHashMap<String, ArrayList<String>> conditionMap = new LinkedHashMap<String, ArrayList<String>>();
                sb.append("        ").append("\"").append(entry.getKey()).append("\":{").append(ISourceVariable.CR);
                for (String condition : entry.getValue()) {
                    String[] valueTabId = condition.split(":");
                    String value = valueTabId[0];
                    String tabId = valueTabId[1];
                    ArrayList<String> tabIds = (ArrayList<String>)conditionMap.get(value);
                    if (tabIds == null) {
                        tabIds = new ArrayList<String>();
                    }
                    tabIds.add(tabId);
                    conditionMap.put(value, tabIds);
                }
                for (String value : conditionMap.keySet()) {
                    int count = 0;
                    sb.append("          ").append("\"").append(value).append("\": [");
                    for (String tabId : (List)conditionMap.get(value)) {
                        if (count > 0) {
                            sb.append(",").append(ISourceVariable.CR);
                        }
                        sb.append("\"").append(tabId).append("\"");
                        ++count;
                    }
                    sb.append("],").append(ISourceVariable.CR);
                }
                sb.append("        ").append("},").append(ISourceVariable.CR);
            }
            return sb.toString();
        }

        public String getTabVisibilityConditions() {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, Set<String>> entry : this.tabVisibilityCondition.entrySet()) {
                LinkedHashMap<String, ArrayList<String>> conditionMap = new LinkedHashMap<String, ArrayList<String>>();
                sb.append("        ").append("\"").append(entry.getKey()).append("\":{").append(ISourceVariable.CR);
                for (String condition : entry.getValue()) {
                    String[] valueTabId = condition.split(":");
                    String value = valueTabId[0];
                    String tabId = valueTabId[1];
                    ArrayList<String> tabIds = (ArrayList<String>)conditionMap.get(value);
                    if (tabIds == null) {
                        tabIds = new ArrayList<String>();
                    }
                    tabIds.add(tabId);
                    conditionMap.put(value, tabIds);
                }
                for (String value : conditionMap.keySet()) {
                    int count = 0;
                    sb.append("          ").append("\"").append(value).append("\": [");
                    for (String tabId : (List)conditionMap.get(value)) {
                        if (count > 0) {
                            sb.append(",");
                        }
                        sb.append("\"").append(tabId).append("\"");
                        ++count;
                    }
                    sb.append("],").append(ISourceVariable.CR);
                }
                sb.append("        ").append("},").append(ISourceVariable.CR);
            }
            return sb.toString();
        }
    }

    public static enum InputCodeConfig {
        OnClickCode,
        OnChangeCode,
        OnKeyDownCode,
        Columnsize,
        compositeKey,
        Displaynotcheckeditem;

    }

    class TargetTab {
        String tabId;
        List<String> values;

        public TargetTab(String tabId, String value) {
            this.tabId = tabId;
            this.values = new ArrayList<String>();
            this.values.add(value);
        }

        public String getTabId() {
            return this.tabId;
        }

        public void addValue(String value) {
            if (!this.values.contains(value)) {
                this.values.add(value);
            }
        }

        public List<String> getValues() {
            return this.values;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TargetTab)) {
                return false;
            }
            TargetTab targetTab = (TargetTab)o;
            return this.getTabId().equals(targetTab.getTabId());
        }

        public int hashCode() {
            int hash = 17;
            hash = hash * 31 + this.getTabId().hashCode();
            return hash;
        }
    }

    class DisableCtrl {
        String ctrlName;
        String ctrlNamePrefix;
        String ctrlNameSuffix;
        String type;
        Displayitem ditem;
        boolean isContainerItem = false;
        List<String> values;

        public DisableCtrl(String ctrlName, String type, String value) {
            this.ctrlName = ctrlName;
            this.type = type;
            this.values = new ArrayList<String>();
            this.values.add(value);
            this.splitCtrlName();
        }

        public DisableCtrl(String ctrlName, String type, String value, Displayitem ditem) {
            this(ctrlName, type, value);
            this.ditem = ditem;
        }

        private void splitCtrlName() {
            if (StringUtils.contains((CharSequence)this.ctrlName, (CharSequence)JavaScriptManager.CONTAINER_LOOP_INDEX)) {
                this.isContainerItem = true;
                this.ctrlNamePrefix = StringUtils.substringBefore((String)this.ctrlName, (String)JavaScriptManager.CONTAINER_LOOP_INDEX);
                this.ctrlNameSuffix = StringUtils.substringAfter((String)this.ctrlName, (String)JavaScriptManager.CONTAINER_LOOP_INDEX);
            } else if (StringUtils.contains((CharSequence)this.ctrlName, (CharSequence)JavaScriptManager.CONTAINER_CHECKBOX_LOOP_INDEX)) {
                this.isContainerItem = true;
                this.ctrlNamePrefix = StringUtils.substringBefore((String)this.ctrlName, (String)JavaScriptManager.CONTAINER_CHECKBOX_LOOP_INDEX);
                this.ctrlNameSuffix = StringUtils.substringAfter((String)this.ctrlName, (String)JavaScriptManager.CONTAINER_CHECKBOX_LOOP_INDEX);
            } else if (StringUtils.contains((CharSequence)this.ctrlName, (CharSequence)JavaScriptManager.TH_CONTAINER_CHECKBOX_LOOP_INDEX)) {
                this.isContainerItem = true;
                this.ctrlNamePrefix = StringUtils.substringBefore((String)this.ctrlName, (String)JavaScriptManager.TH_CONTAINER_CHECKBOX_LOOP_INDEX);
                this.ctrlNameSuffix = StringUtils.substringAfter((String)this.ctrlName, (String)JavaScriptManager.TH_CONTAINER_CHECKBOX_LOOP_INDEX);
            }
        }

        public String getCtrlName() {
            return this.ctrlName;
        }

        public String getType() {
            return this.type;
        }

        public boolean isTypeFile() {
            if (this.ditem == null) {
                return false;
            }
            return "file".equals(this.ditem.getType());
        }

        public void addValue(String value) {
            if (!this.values.contains(value)) {
                this.values.add(value);
            }
        }

        public List<String> getValues() {
            return this.values;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DisableCtrl)) {
                return false;
            }
            DisableCtrl target = (DisableCtrl)o;
            return this.getCtrlName().equals(target.getCtrlName()) && this.getType().equals(target.getType());
        }

        public int hashCode() {
            int hash = 17;
            hash = hash * 31 + this.getCtrlName().hashCode();
            hash = hash * 31 + this.getType().hashCode();
            return hash;
        }
    }
}

