/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.EmptyJavaScriptManager;
import jp.jasminesoft.jfc.gen.IGeneratorFactory;
import jp.jasminesoft.jfc.gen.JavaScriptManager;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Include;
import jp.jasminesoft.jfc.gen.appschema.Layout;
import jp.jasminesoft.jfc.gen.appschema.Panel;
import jp.jasminesoft.jfc.gen.appschema.Presentation;
import jp.jasminesoft.jfc.gen.appschema.Project;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JavaScriptManagerFactory
implements IGeneratorFactory {
    private static Map idmap;
    private static Map filenamemap;
    private static List instancelist;
    protected static Logger logger;

    public static JavaScriptManager getInstance(Project project, Presentation presentation, Action action) {
        if (action != null) {
            String id = JavaSourceGenerator.createProperId(action);
            return JavaScriptManagerFactory.getInstance(project, presentation, id);
        }
        return JavaScriptManagerFactory.getInstance(project, presentation, (String)null);
    }

    public static JavaScriptManager getInstance(Project project, Presentation presentation, String id) {
        JavaScriptManager _instance;
        String filename;
        if (presentation.getFilename() != null) {
            Panel body;
            Include[] includes;
            Layout layout;
            filename = presentation.getFilename();
            _instance = (JavaScriptManager)filenamemap.get(filename);
            if (_instance != null) {
                return _instance;
            }
            if (filename != null && presentation.getIdref() != null && presentation.getIdref().equals(filename) && filename.startsWith("show") && "standard".equals((layout = presentation.getLayout()).getType()) && (includes = AppSchemaUtil.getAllInclude(body = AppSchemaUtil.findBodyPanel(presentation))) != null && includes.length > 0) {
                for (Include include : includes) {
                    String content;
                    if (!"import".equals(include.getType()) || !(content = include.getContent()).startsWith(filename)) continue;
                    return null;
                }
            }
            _instance = new JavaScriptManager(project, presentation, id, filename);
            if (idmap.containsKey(filename)) {
                logger.warn("[1] duplicate javascript filename " + filename + " " + presentation);
                return null;
            }
            filenamemap.put(filename, _instance);
        } else if (id != null) {
            filename = id;
            _instance = (JavaScriptManager)idmap.get(filename);
            if (_instance != null) {
                return _instance;
            }
            _instance = new JavaScriptManager(project, presentation, id, filename);
            if (filenamemap.containsKey(filename)) {
                logger.warn("[2] duplicate javascript filename " + filename + " " + presentation);
                return null;
            }
            idmap.put(filename, _instance);
        } else {
            return null;
        }
        instancelist.add(_instance);
        if (id != null) {
            String my_filename = "My" + filename.substring(0, 1).toUpperCase() + filename.substring(1);
            EmptyJavaScriptManager _my_instance = new EmptyJavaScriptManager(project, presentation, id, my_filename);
            idmap.put(my_filename, _my_instance);
            instancelist.add(_my_instance);
            String myJsFilename = "My";
            EmptyJavaScriptManager myJsManager = new EmptyJavaScriptManager(project, presentation, id, myJsFilename);
            idmap.put(myJsFilename, myJsManager);
            instancelist.add(myJsManager);
        }
        return _instance;
    }

    public static Collection getAllJavaScriptManager() {
        return Collections.unmodifiableCollection(instancelist);
    }

    public static void reset() {
        idmap = Collections.synchronizedMap(new HashMap());
        filenamemap = Collections.synchronizedMap(new HashMap());
        instancelist = Collections.synchronizedList(new ArrayList());
    }

    static {
        JavaScriptManagerFactory.reset();
        logger = LogManager.getLogger((String)JavaScriptManagerFactory.class.getName());
    }
}

