/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.File;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.ConfigGenerator;
import jp.jasminesoft.jfc.gen.appschema.Database;
import jp.jasminesoft.jfc.gen.appschema.Environment;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.FileTemplateManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JndiXmlGenerator
extends ConfigGenerator {
    protected static Logger logger = LogManager.getLogger(JndiXmlGenerator.class);

    public JndiXmlGenerator(String tmplatefilename, Project project) {
        super(tmplatefilename, project);
    }

    @Override
    public String getFileSuffix() {
        return ".xml";
    }

    @Override
    public String getFilename() {
        return "jndi";
    }

    @Override
    public String getSubpackageName() {
        return "webpage" + File.separator + "WEB-INF" + File.separator + "classes";
    }

    @Override
    public String process0() {
        Database db;
        FileTemplateManager tplman = new FileTemplateManager(this.tmplatefilename);
        if (!tplman.isValid()) {
            return "";
        }
        IProjectChoice[] ipc = this.project.getContent();
        if (ipc == null) {
            return "";
        }
        String driver = "org.hsqldb.jdbcDriver";
        String url = "jdbc:hsqldb:jfcappdb";
        String user = "sa";
        String pwd = "";
        Environment env = this.project.getEnvironment();
        if (env != null && (db = AppSchemaUtil.getDatabase(env)) != null) {
            driver = db.getDriver();
            url = db.getUrl();
            user = db.getUser();
            pwd = db.getPassword();
        }
        if (driver.equals("org.hsqldb.jdbcDriver")) {
            File file = new File(".");
            Object path = file.getAbsolutePath();
            int ptr = ((String)path).lastIndexOf(File.separator);
            path = ((String)path).substring(0, ptr);
            ptr = ((String)path).lastIndexOf(File.separator);
            path = ((String)path).substring(0, ptr);
            path = (String)path + File.separator + "wagbyapp";
            url = url.replace("${catalina.home}", (CharSequence)path);
        }
        tplman.addContent("driverClassName", driver);
        tplman.addContent("url", url);
        tplman.addContent("username", user);
        tplman.addContent("password", pwd);
        return tplman.getResult();
    }
}

