/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.GoogleMapScriptManager;
import jp.jasminesoft.jfc.gen.JFCAppResourceGenerator;
import jp.jasminesoft.jfc.gen.JavaScriptManager;
import jp.jasminesoft.jfc.gen.JavaScriptManagerFactory;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.PresentationSourceGenerator;
import jp.jasminesoft.jfc.gen.StyleSheetManager;
import jp.jasminesoft.jfc.gen.StyleSheetManagerFactory;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Displaychart;
import jp.jasminesoft.jfc.gen.appschema.Displaymap;
import jp.jasminesoft.jfc.gen.appschema.Javascript;
import jp.jasminesoft.jfc.gen.appschema.Javascriptlist;
import jp.jasminesoft.jfc.gen.appschema.Layout;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Presentation;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.ResourceManagerFactory;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;

public abstract class JspSourceGenerator
extends PresentationSourceGenerator {
    protected String fid;
    protected String actionref;
    protected JavaScriptManager jsman;
    protected StyleSheetManager ssman;
    protected ResourceManager rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
    protected boolean isRedirectJspFlag;
    protected static ResourceManager x2aj_rman = ResourceManager.getInstance((String)"x2aj");
    public static final String ResultBeanName = "jfc_result";

    public JspSourceGenerator(Project project, Action action, Presentation presentation) {
        super(project, action, presentation);
        this.fid = this.getFid(this.fid, action, presentation);
        this.actionref = "";
        this.jsman = JavaScriptManagerFactory.getInstance(project, presentation, action);
        this.ssman = StyleSheetManagerFactory.getInstance(project, presentation, action);
    }

    @Override
    public String getEncoding() {
        return JavaSourceGenerator.getWebEncoding(this.project);
    }

    public abstract String getFilename();

    @Override
    public String getFileSuffix() {
        return ".jsp";
    }

    public boolean isTiles() {
        return false;
    }

    public String getActionIdref() {
        return this.action.getIdref();
    }

    public String getFid() {
        return this.fid;
    }

    public String getJavaScriptOnFormSubmit() {
        return "return doSubmit(this);";
    }

    public String getFormActionName() {
        return this.actionref;
    }

    protected String getJspPrefix() {
        return this.getActionType();
    }

    public String gRequestFormBegin(String name, String basetab) {
        return this.gRequestFormBegin(name, null, this.getJavaScriptOnFormSubmit(), null, basetab);
    }

    public String gRequestFormBegin(String name, String code, String basetab) {
        return this.gRequestFormBegin(name, null, code, null, basetab);
    }

    public String gRequestFormBegin(String name, String actionref, String code, String basetab) {
        return this.gRequestFormBegin(name, actionref, code, null, basetab);
    }

    public String gRequestFormBegin(String name, String actionref, String code, String style, String basetab) {
        return "";
    }

    protected String gRequestFormEnd(String basetab) {
        return "";
    }

    protected String gComment(String comment) {
        if (!this.project.getDebug()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<%-- ").append(this.getClass().getName()).append("::").append(comment).append(" --%>").append(CR);
        return sb.toString();
    }

    protected String gJavaScript0() {
        return "";
    }

    protected String[] gJavaScriptRef() {
        Set<String> set;
        int i;
        Javascript[] jsa;
        ArrayList<Javascript> list = new ArrayList<Javascript>();
        Javascript js = null;
        String type = this.action != null ? this.action.getType() : "";
        Javascriptlist jlist = this.project.getJavascriptlist();
        if (jlist != null && (jsa = jlist.getJavascript()) != null && jsa.length > 0) {
            for (i = 0; i < jsa.length; ++i) {
                js = jsa[i];
                if (!type.equals(js.getType()) && js.getType() != null && js.getType().length() != 0) continue;
                list.add(js);
            }
        }
        if ((jlist = this.presentation.getJavascriptlist()) != null && (jsa = jlist.getJavascript()) != null && jsa.length > 0) {
            for (i = 0; i < jsa.length; ++i) {
                js = jsa[i];
                list.add(js);
            }
        }
        if (this.jsman != null) {
            String s = null;
            String my_s = null;
            String myJs = null;
            String jsfilename = this.jsman.getFilename();
            if (this.action != null) {
                s = this.action.getIdref() + "/" + jsfilename + this.jsman.getFileSuffix();
                myJs = this.action.getIdref() + "/My.js";
                my_s = this.action.getIdref() + "/My" + jsfilename.substring(0, 1).toUpperCase() + jsfilename.substring(1) + this.jsman.getFileSuffix();
            } else if (!("analyticsLog".equals(jsfilename) || "showListLog".equals(jsfilename) || "showAboutApp".equals(jsfilename) || "licenseUpdatorConfig".equals(jsfilename) || "showListLogonUsers".equals(jsfilename) || "maintenanceApp".equals(jsfilename) || "initLoader".equals(jsfilename) || "webapi".equals(jsfilename))) {
                s = jsfilename + this.jsman.getFileSuffix();
            }
            if (StringUtils.isNotBlank(s)) {
                js = new Javascript();
                js.setContent(s);
                list.add(js);
            }
            js = new Javascript();
            js.setContent("system/mycommon.js");
            list.add(js);
            if (my_s != null) {
                js = new Javascript();
                js.setContent(myJs);
                list.add(js);
                js = new Javascript();
                js.setContent(my_s);
                list.add(js);
            }
        }
        HashSet<String> removeRef = new HashSet<String>();
        int size = list.size();
        for (int i2 = 0; i2 < size; ++i2) {
            js = (Javascript)list.get(i2);
            if (!js.getRemove()) continue;
            removeRef.add(js.getContent());
        }
        TreeMap<Integer, LinkedHashSet<String>> map = new TreeMap<Integer, LinkedHashSet<String>>();
        for (int i3 = 0; i3 < size; ++i3) {
            js = (Javascript)list.get(i3);
            String filename = js.getContent();
            if (removeRef.contains(filename)) continue;
            Integer order = js.getOrder();
            set = (Set)map.get(order);
            if (set == null) {
                set = new LinkedHashSet<String>();
                map.put(order, (LinkedHashSet<String>)set);
            }
            set.add(filename);
        }
        ArrayList<String> rlist = new ArrayList<String>();
        for (Integer order : map.keySet()) {
            set = (LinkedHashSet<String>)map.get(order);
            for (String s : set) {
                rlist.add(s);
            }
        }
        return rlist.toArray(new String[0]);
    }

    protected String gJavaScriptTag() {
        String code;
        StringBuilder sb = new StringBuilder();
        sb.append(this.gComment("gJavaScript"));
        String[] ref = this.gJavaScriptRef();
        if (ref != null) {
            Arrays.asList(ref).stream().forEach(e -> sb.append("<script type=\"text/javascript\" src=\"").append((String)e).append("?<c:out value='${applicationScope.__jfc_buildTimestamp}'/>").append("\" charset=\"").append(this.getEncoding()).append("\"").append("></script>").append(CR));
        }
        if (StringUtils.isNotBlank((CharSequence)(code = this.gJavaScript0()))) {
            sb.append("<script type=\"text/javascript\"").append(code).append(CR).append("</script>").append(CR);
        }
        return sb.toString();
    }

    protected String gStyleSheetRef() {
        if (this.action == null || this.ssman == null) {
            return null;
        }
        String ssfilename = this.ssman.getFilename();
        String ssfilename2 = ssfilename != null && ssfilename.startsWith("printScreen") ? "show" + ssfilename.substring("printScreen".length()) : ssfilename;
        String id = this.action.getIdref();
        StringBuilder sb = new StringBuilder();
        sb.append(this.getStyleSheetTag(id + "/" + ssfilename2 + this.ssman.getFileSuffix()));
        sb.append(this.getStyleSheetTag(id + "/My.css"));
        sb.append(this.getStyleSheetTag(id + "/My" + ssfilename.substring(0, 1).toUpperCase() + ssfilename.substring(1) + this.ssman.getFileSuffix()));
        return sb.toString();
    }

    protected String getStyleSheetTag(String src) {
        StringBuilder sb = new StringBuilder();
        sb.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"").append(src).append("?<c:out value='${applicationScope.__jfc_releaseTimestamp}'/>\" />").append(CR);
        return sb.toString();
    }

    public boolean isMobile() {
        return AppSchemaUtil.isMobile(this.presentation);
    }

    public String calcFormActionName(String actionref) {
        if (actionref == null || ((String)actionref).length() == 0) {
            actionref = this.presentation.getFilename();
        }
        if (actionref == null || ((String)actionref).length() == 0) {
            actionref = this.presentation.getIdref();
        }
        if (actionref == null || ((String)actionref).length() == 0) {
            actionref = this.getActionType() + JspSourceGenerator.capFirst(this.getActionIdref());
        }
        return actionref;
    }

    protected abstract String getActionType();

    protected String getFid(String fid, Action action, Presentation presentation) {
        if (StringUtils.isNotBlank((CharSequence)fid)) {
            return fid;
        }
        String filename = presentation.getFilename();
        if (StringUtils.isNotBlank((CharSequence)filename)) {
            return filename;
        }
        if (action != null) {
            return action.getId();
        }
        this.logger.error(this.rman.getValue("jsp.filename.null", presentation.getIdref()));
        return "";
    }

    protected String getEscapedTitle() {
        Object title = AppSchemaUtil.getTitle(this.project);
        if (!this.project.getFixedtitle()) {
            String pagetitle = null;
            if (this.action != null) {
                pagetitle = this.action.getDescription();
            }
            if (pagetitle == null || pagetitle.length() == 0) {
                pagetitle = this.presentation.getDescription();
            }
            if (pagetitle != null && pagetitle.length() > 0) {
                title = (String)title + " " + StringUtil.escapeStringForXML((String)pagetitle);
            }
        }
        return title;
    }

    protected boolean hasTips() {
        if (this.action == null || this.presentation == null) {
            return false;
        }
        Layout layout = this.presentation.getLayout();
        if (layout == null) {
            return false;
        }
        String type = this.action.getType();
        if (type == null) {
            return false;
        }
        return type.equals("insert") || type.equals("update") || type.equals("copy");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        String styleSheetRef;
        this.init();
        String filename = this.getFilename();
        this.isRedirectJspFlag = filename.startsWith("redirect");
        filename = this.addModelidToFilename(this.action, filename);
        StringBuilder sb = new StringBuilder();
        BufferedReader br = null;
        try {
            String dirbase0 = this.project.getBasedir() + File.separator + this.getPackageName() + File.separator;
            String dirbase1 = "webpage" + File.separator;
            String checkLine = "<script type=\"text/javascript\" src=";
            br = new BufferedReader(new StringReader(this.process0()));
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("<script type=\"text/javascript\" src=")) {
                    File _file1;
                    String _rest = line.substring("<script type=\"text/javascript\" src=".length() + 1);
                    String terminalSymbol = _rest.contains("?") ? "?" : "\"";
                    String _fid = _rest.substring(0, _rest.indexOf(terminalSymbol));
                    File _file0 = new File(dirbase0 + _fid);
                    if (!(StringUtils.endsWith((CharSequence)_fid, (CharSequence)"dojo.js") || StringUtils.startsWith((CharSequence)_fid, (CharSequence)"system/") || _file0.exists() || (_file1 = new File(dirbase1 + _fid)).exists())) {
                        int _ptr = _fid.indexOf("/");
                        if (this.action == null || _ptr <= 0) continue;
                        String mid = _fid.substring(0, _ptr);
                        if (!this.action.getIdref().equals(mid)) continue;
                    }
                }
                sb.append(line);
                sb.append(CR);
            }
        }
        catch (IOException dirbase0) {
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException dirbase0) {}
            }
        }
        String content = sb.toString();
        if (!this.isTiles() || this.isRedirectJspFlag) {
            this.createSource(this.getGeneratorClassName() + content, filename, this.getPackageName(), false);
        } else {
            Object tcontent;
            String tfilename;
            String line = null;
            StringBuilder javascript_code = new StringBuilder();
            StringBuilder bean_code = new StringBuilder();
            javascript_code.append(this.gTilesJspInit());
            bean_code.append(this.gTilesJspInit());
            boolean isJavaScriptCreateFlag = false;
            boolean isBeanDefCreateFlag = false;
            HashMap<String, StringBuilder> tmap = new HashMap<String, StringBuilder>();
            String tid2 = null;
            StringTokenizer st = new StringTokenizer(content, CR);
            while (st.hasMoreTokens()) {
                line = st.nextToken();
                if (line.startsWith("<script") && line.endsWith("</script>")) {
                    isJavaScriptCreateFlag = true;
                    javascript_code.append(line.replaceFirst("\\.js\"", "\\.js\\?<c:out value='\\${applicationScope.__jfc_buildTimestamp}'/>\"") + CR);
                } else if (line.startsWith("<bean:define")) {
                    isBeanDefCreateFlag = true;
                    bean_code.append(line + CR);
                } else {
                    if (line.startsWith("<!-- begin")) {
                        String s = line.substring("<!-- begin ".length());
                        tid2 = s.substring(0, s.length() - " -->".length());
                        continue;
                    }
                    if (line.startsWith("<!-- end")) {
                        tid2 = null;
                        continue;
                    }
                }
                if (tid2 == null) continue;
                StringBuilder sb0 = (StringBuilder)tmap.get(tid2);
                if (sb0 == null) {
                    sb0 = new StringBuilder();
                    sb0.append(this.gTilesJspInit());
                    tmap.put(tid2, sb0);
                }
                sb0.append(line + CR);
            }
            for (String tid2 : tmap.keySet()) {
                StringBuilder sb0 = (StringBuilder)tmap.get(tid2);
                String tfilename2 = filename + "_" + tid2;
                String tcontent2 = sb0.toString();
                this.createSource(this.getGeneratorClassName() + tcontent2, tfilename2, this.getPackageName(), false);
            }
            if (isJavaScriptCreateFlag) {
                tfilename = filename + "_javascript";
                tcontent = javascript_code.toString();
                Displaymap displaymap = AppSchemaUtil.findDisplaymap(this.presentation);
                if (displaymap != null && "google".equals(displaymap.getType())) {
                    StringBuilder __sb = new StringBuilder((String)tcontent);
                    GoogleMapScriptManager gmsm = GoogleMapScriptManager.getInstance(this.project);
                    if (gmsm != null) {
                        __sb.append(gmsm.getReadyScript());
                        __sb.append(gmsm.getScript(this.presentation));
                        tcontent = __sb.toString();
                    }
                }
                if (this.action != null && AppSchemaUtil.isJgroupnodeOrgChartDefined(AppSchemaUtil.getModel(this.project, this.action.getIdref()), this.action)) {
                    tcontent = (String)tcontent + "<script type=\"text/javascript\">\r\nlet datasource = <c:choose><c:when test=\"${__jfc_groupChart != null}\"><c:out value=\"${__jfc_groupChart}\" escapeXml=\"false\"/></c:when><c:otherwise>null</c:otherwise></c:choose>;\r\n</script>\r\n";
                }
                this.createSource(this.getGeneratorClassName() + (String)tcontent, tfilename, this.getPackageName(), false);
            }
            if (isBeanDefCreateFlag) {
                tfilename = filename + "_beandef";
                tcontent = bean_code.toString();
                this.createSource(this.getGeneratorClassName() + (String)tcontent, tfilename, this.getPackageName(), false);
            }
        }
        if ((this.isTiles() && !this.isRedirectJspFlag || this.action == null || this.action.getId().startsWith("searchList")) && StringUtils.isNotBlank((CharSequence)(styleSheetRef = this.gStyleSheetRef()))) {
            StringBuilder stylesheetCode = new StringBuilder();
            stylesheetCode.append(this.getGeneratorClassName()).append(this.gTilesJspInit()).append(styleSheetRef);
            StringBuilder tfilename = new StringBuilder();
            tfilename.append(filename).append("_").append("stylesheet");
            this.createSource(stylesheetCode.toString(), tfilename.toString(), this.getPackageName(), false);
        }
    }

    protected String gTilesJspInit() {
        StringBuilder sb = new StringBuilder();
        sb.append("<%@ page pageEncoding=\"");
        sb.append(this.getEncoding());
        sb.append("\"");
        String[] importlist = this.getImportList();
        if (importlist != null && importlist.length > 0) {
            sb.append(CR);
            sb.append("    import=\"");
            for (int i = 0; i < importlist.length; ++i) {
                sb.append(importlist[i]);
                if (i + 1 >= importlist.length) continue;
                sb.append(",");
            }
            sb.append("\"");
        }
        sb.append(" %>").append(CR);
        sb.append("<fmt:setBundle basename=\"jfcapp\"/>").append(CR);
        return sb.toString();
    }

    public void init() {
    }

    public abstract String process0();

    public boolean equals(Object o) {
        boolean ret = false;
        if (o != null && o instanceof JspSourceGenerator) {
            JspSourceGenerator jsg = (JspSourceGenerator)o;
            if (this.getFilename().equals(jsg.getFilename()) && this.getFileSuffix().equals(jsg.getFileSuffix())) {
                ret = true;
            }
        }
        return ret;
    }

    protected String[] getImportList() {
        Model _model;
        ArrayList<String> importList = new ArrayList<String>();
        if (AppSchemaUtil.isMobile(this.presentation)) {
            importList.add("jp.jasminesoft.jfc.controller.BaseController");
        }
        if (this.action != null && (_model = AppSchemaUtil.getModel(this.project, this.action.getIdref())) != null && _model.getWorkflow()) {
            importList.add("jp.jasminesoft.workflow.WorkEvent");
        }
        return importList.toArray(new String[0]);
    }

    @Override
    protected String getGeneratorClassName() {
        if (System.getProperty("jfc.output.genclassname") != null) {
            return "<%-- genclassname:" + this.getClass().getName() + " --%>" + CR;
        }
        return "";
    }

    protected String gDisplaychart(Displaychart displaychart) {
        StringBuilder sb = new StringBuilder();
        Action action = this.getAction();
        if (action == null) {
            return "";
        }
        Object title = displaychart.getTitle();
        if (title == null) {
            title = "";
        } else {
            String rkey = JFCAppResourceGenerator.createModelResourceKey(action.getIdref(), "chart." + displaychart.getId() + ".title", (String)title);
            JFCAppResourceGenerator.put(rkey, (String)title);
            title = "<fmt:message key=\"" + rkey + "\"/>";
        }
        sb.append("<div style=\"margin: 0 10px;\">").append(CR);
        sb.append("<h4 style=\"margin: 0; text-align: center;\">").append((String)title).append("</h4>").append(CR);
        sb.append("<canvas id=\"").append(action.getId()).append("_").append(displaychart.getId()).append("_chart").append("\"").append(" height=\"").append(displaychart.getHeight()).append("\"").append(" width=\"").append(displaychart.getWidth()).append("\"/>").append(CR);
        sb.append("</div>").append(CR);
        return sb.toString();
    }

    protected String getResultSizeCondition() {
        return "jfc_result ne null and jfc_result.size";
    }
}

