/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.File;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.IWebSourceVariable;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.FileTemplateManager;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.ResourceManagerFactory;

public class JspTilesComponentGenerator
extends SourceGenerator
implements IWebSourceVariable {
    private String dirname;
    private String filename;
    protected ResourceManager rman;
    protected FileTemplateManager tplman;

    public JspTilesComponentGenerator(String dirname, String filename, Project project) {
        super(project);
        this.dirname = dirname != null && dirname.length() > 0 ? dirname : "";
        this.filename = filename != null && filename.length() > 0 ? filename : "";
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
    }

    @Override
    public String getFileSuffix() {
        return ".jsp";
    }

    public String getFilename() {
        return this.filename;
    }

    public String getSubpackageName() {
        return "webpage" + File.separator;
    }

    @Override
    public String getEncoding() {
        return JavaSourceGenerator.getWebEncoding(this.project);
    }

    @Override
    public void process() {
        String enc;
        if ("sidebar_submenu.jsp".equals(this.filename)) {
            return;
        }
        String tmplatefilename = this.dirname + File.separator + this.filename;
        FileTemplateManager tplman = new FileTemplateManager(tmplatefilename, enc = JavaSourceGenerator.getWebEncoding(this.project));
        if (!tplman.isValid()) {
            return;
        }
        tplman.addContent("webencoding", enc);
        if ("submenu.jsp".equals(this.filename)) {
            String submenuFilename = null;
            String menuFilename = AppSchemaUtil.getMenuFilename(this.project);
            submenuFilename = "system/displayMenubar_12colors.jsp".equals(menuFilename) ? "system/showSubmenubar_rich2.xsl" : "system/showSubmenubar_rich.xsl";
            tplman.addContent("displaySubmenu", submenuFilename);
        }
        Object content = tplman.getResult();
        content = this.getGeneratorClassName() + (String)content;
        this.filename = "parts" + File.separator + this.filename;
        this.createSource((String)content, this.filename, this.getSubpackageName(), false);
    }

    @Override
    protected void createSource(String content, String filename, String subpackagename, boolean p) {
        filename = JspTilesComponentGenerator.convertJspFilename(filename);
        super.createSource(content, filename, subpackagename, p);
    }

    @Override
    protected String getGeneratorClassName() {
        if (System.getProperty("jfc.output.genclassname") != null) {
            return "<%-- genclassname:" + this.getClass().getName() + " --%>" + CR;
        }
        return "";
    }
}

