/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jp.jasminesoft.jfc.gen.ISourceVariable;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.Keyevent;
import jp.jasminesoft.jfc.gen.appschema.Project;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KeyEventHandlerGenerator
implements ISourceVariable {
    public static final String BaseDirectory = "webpage" + File.separator + "system";
    protected static Logger logger = LogManager.getLogger(KeyEventHandlerGenerator.class);
    private String basedir;
    private Project project;
    private List<Keyevent> list = null;

    public KeyEventHandlerGenerator(Project project, String basedir) {
        this.project = project;
        this.basedir = basedir;
        for (IProjectChoice ipc : project.getContent()) {
            if (!(ipc instanceof Keyevent)) continue;
            Keyevent keyevent = (Keyevent)ipc;
            if (this.list == null) {
                this.list = new ArrayList<Keyevent>();
            }
            this.list.add(keyevent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        if (this.list == null) {
            return;
        }
        File base = new File(this.basedir + File.separator + BaseDirectory);
        if (!base.exists() || !base.isDirectory()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        TreeMap<String, String> codeMap = new TreeMap<String, String>();
        TreeMap<String, String> typeMap = new TreeMap<String, String>();
        sb.append("function getKeyEventHandlers(keys) {").append(CR);
        sb.append("  var keyEventHandlers = {};").append(CR);
        for (Keyevent keyevent : this.list) {
            String key = this.getContentValue(keyevent.getKey());
            int ptr = key != null ? key.indexOf(":") : -1;
            if (ptr <= 0) continue;
            String _code = key.substring(ptr + 1);
            String _desc = key.substring(0, ptr);
            codeMap.put(_code, keyevent.getContent());
            if (StringUtils.isNotBlank((CharSequence)keyevent.getType())) {
                typeMap.put(_code, keyevent.getType());
            }
            sb.append("  keyEventHandlers[\"").append(_code).append("\"] = handler_keyDown_").append(_code).append("; // ").append(_desc).append(CR);
        }
        sb.append("  return keyEventHandlers;").append(CR);
        sb.append("}").append(CR).append(CR);
        for (Map.Entry entry : codeMap.entrySet()) {
            String _code = (String)entry.getKey();
            String _script = (String)entry.getValue();
            String _type = (String)typeMap.get(_code);
            if (StringUtils.isNotBlank((CharSequence)_type)) {
                sb.append("// ").append(_type).append(CR);
            } else {
                sb.append(CR);
            }
            sb.append("function handler_keyDown_").append(_code).append("(event, dom, registry, query) {").append(CR);
            sb.append(_script).append(CR);
            sb.append("}").append(CR);
        }
        sb.append(CR);
        File jsfile = new File(base.getAbsolutePath() + File.separator + "keyEventHandlers.js");
        if (jsfile.exists()) {
            FileUtils.deleteQuietly((File)jsfile);
        }
        try (PrintWriter printWriter = null;){
            PrintWriter printWriter2 = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(jsfile), this.project.getEncoding())));
            printWriter2.print(sb.toString());
            if (printWriter2 != null) {
                printWriter2.close();
            }
        }
    }

    private String getContentValue(String s) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        if (s.charAt(0) == '[') {
            s = s.substring(1);
        }
        if (s.charAt(s.length() - 1) == ']') {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }
}

