/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.File;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.jsplayoutlist.Jsplayoutitem;
import jp.jasminesoft.jfc.gen.jsplayoutlist.Jsplayoutlist;
import jp.jasminesoft.util.FileTemplateManager;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.ResourceManagerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LayoutJspGenerator
extends SourceGenerator {
    private Logger logger = LogManager.getLogger((String)LayoutJspGenerator.class.getName());
    private String dirname;
    private String filenameheader;
    private String filename;
    protected ResourceManager rman;
    protected FileTemplateManager tplman;
    private static final String JFC_LAYOUT_SIMPLE = "base_simple.jsp";
    private static final String JFC_LAYOUT_CLASSIC = "base_classic.jsp";
    private static final String JFC_LAYOUT_PRINT = "base_printlayout.jsp";
    public String[][] layouttable = new String[][]{{"simple", "base_simple.jsp"}, {"classic", "base_classic.jsp"}, {"print", "base_printlayout.jsp"}};
    public static final String LAYOUT_FILENAME = "template" + File.separator + "jsplayoutlist.xml";

    public LayoutJspGenerator(String layoutname, String dirname, Project project, String filenameheader) {
        super(project);
        this.dirname = dirname != null && dirname.length() > 0 ? dirname : "";
        this.filenameheader = filenameheader != null && filenameheader.length() > 0 ? filenameheader : "";
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
        File file = new File(LAYOUT_FILENAME);
        if (file.exists()) {
            try {
                Jsplayoutlist jsplayoutlist = new Jsplayoutlist(file);
                Jsplayoutitem[] items = jsplayoutlist.getJsplayoutitem();
                if (items != null && items.length > 0) {
                    this.layouttable = new String[items.length][2];
                    for (int i = 0; i < items.length; ++i) {
                        this.layouttable[i][0] = items[i].getName();
                        this.layouttable[i][1] = items[i].getContent();
                        if (!layoutname.equals(this.layouttable[i][0])) continue;
                        this.filename = this.layouttable[i][1];
                    }
                }
            }
            catch (Exception e) {
                this.logger.warn(e.getMessage());
            }
        }
    }

    @Override
    public String getFileSuffix() {
        return ".jsp";
    }

    public String getFilename() {
        return this.filenameheader + this.filename;
    }

    public String getSubpackageName() {
        return "webpage" + File.separator;
    }

    @Override
    public String getEncoding() {
        return JavaSourceGenerator.getWebEncoding(this.project);
    }

    protected String getTmplatefilename() {
        String tmplatefilename = null;
        tmplatefilename = this.filename != null ? this.dirname + File.separator + this.filenameheader + this.filename : this.dirname + File.separator + this.filenameheader + JFC_LAYOUT_SIMPLE;
        return tmplatefilename;
    }

    @Override
    public void process() {
        String enc;
        String tmplatefilename = this.getTmplatefilename();
        FileTemplateManager tplman = new FileTemplateManager(tmplatefilename, enc = JavaSourceGenerator.getWebEncoding(this.project));
        if (!tplman.isValid()) {
            return;
        }
        tplman.addContent("webencoding", enc);
        Object content = tplman.getResult();
        content = this.getGeneratorClassName() + (String)content;
        this.createSource((String)content, this.filenameheader + this.filename, this.getSubpackageName(), false);
    }

    @Override
    protected String getGeneratorClassName() {
        if (System.getProperty("jfc.output.genclassname") != null) {
            return "<%-- genclassname:" + this.getClass().getName() + " --%>" + CR;
        }
        return "";
    }
}

