/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.File;
import java.util.StringTokenizer;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Environment;
import jp.jasminesoft.jfc.gen.appschema.Jarfile;
import jp.jasminesoft.jfc.gen.appschema.Jarfilelist;
import jp.jasminesoft.jfc.gen.appschema.Manifest;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.ResourceManagerFactory;
import jp.jasminesoft.util.StringUtil;

public class ManifestGenerator
extends SourceGenerator {
    protected Manifest manifest;
    protected ResourceManager rman;
    protected String packagedir;
    protected String packagename;
    protected String tomcat;
    boolean v4Flag = false;
    String prefix0;

    public ManifestGenerator(Project project, Manifest manifest) {
        super(project);
        String version;
        this.manifest = manifest;
        this.packagedir = JavaSourceGenerator.convPackage2FilePath(project.getPackage());
        this.packagename = project.getPackage();
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
        Environment environment = project.getEnvironment();
        if (environment != null) {
            this.tomcat = environment.getTomcat();
        }
        if (this.tomcat == null) {
            this.tomcat = "7";
        }
        if (StringUtil.doubleValue((String)(version = project.getVersion())) >= 4.0) {
            this.v4Flag = true;
        }
        if (this.v4Flag) {
            StringBuilder sb = new StringBuilder("../webapps/");
            sb.append(AppSchemaUtil.getWebappName(project));
            sb.append("/WEB-INF/");
            this.prefix0 = sb.toString();
        }
    }

    @Override
    public void process() {
        String content = this.process0();
        String filename = this.getFilename();
        String subpackagename = this.getSubpackageName();
        if (content != null) {
            this.createSource(content, filename, subpackagename, false);
        }
    }

    @Override
    public String getFileSuffix() {
        return ".manifest";
    }

    public String getFilename() {
        return this.manifest != null ? this.manifest.getName() : "";
    }

    public String getSubpackageName() {
        return "manifest" + File.separator;
    }

    public String process0() {
        String[] classpaths;
        int i;
        Jarfile[] jarfiles;
        StringBuilder sb = new StringBuilder();
        String classname = this.manifest.getMain();
        String filename = this.getFilename();
        sb.append("Main-Class: ");
        sb.append(classname);
        sb.append(CR);
        sb.append("Class-Path: ");
        if (this.tomcat.startsWith("3")) {
            if (this.v4Flag) {
                sb.append("../classes/ ");
                sb.append(this.prefix0 + "lib ");
                sb.append(this.prefix0 + "classes");
            } else {
                sb.append("./classes/ ./lib/");
            }
        } else if (this.v4Flag) {
            sb.append("../classes/ ");
            sb.append(this.prefix0 + "lib/ ");
            sb.append(this.prefix0 + "classes/");
        } else {
            sb.append("./shared/classes/ ./shared/lib/");
        }
        Jarfilelist jarfilelist = this.project.getJarfilelist();
        if (jarfilelist != null && (jarfiles = jarfilelist.getJarfile()) != null && jarfiles.length > 0) {
            for (i = 0; i < jarfiles.length; ++i) {
                String mf = jarfiles[i].getMf();
                if (mf == null) continue;
                StringTokenizer st = new StringTokenizer(mf, ", ");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (!filename.equals(token)) continue;
                    sb.append(" ");
                    sb.append(this.getPrefix(jarfiles[i]));
                    sb.append(jarfiles[i].getContent());
                }
            }
        }
        if ((classpaths = this.manifest.getManifestClasspath()) != null) {
            for (i = 0; i < classpaths.length; ++i) {
                String classpath = classpaths[i];
                sb.append(" ");
                sb.append(classpath);
            }
        }
        sb.append(CR);
        return sb.toString();
    }

    private String getPrefix(Jarfile jarfile) {
        Object prefix = null;
        prefix = this.tomcat.startsWith("3") ? (this.v4Flag ? this.prefix0 + "lib/" : "./lib/") : (this.tomcat.startsWith("4") || this.tomcat.startsWith("5") ? (jarfile.getCommon() || jarfile.getEnv() ? (this.v4Flag ? "../common/lib/" : "./common/lib/") : (this.v4Flag ? this.prefix0 + "lib/" : "./shared/lib/")) : (jarfile.getCommon() || jarfile.getEnv() ? "../lib/" : this.prefix0 + "lib/"));
        return prefix;
    }
}

