/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CommentGenerator;
import jp.jasminesoft.jfc.gen.MasterBeanGenerator;
import jp.jasminesoft.jfc.gen.TablenameGenerator;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Project;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MasterBeanGenerator_with_db
extends MasterBeanGenerator {
    protected Logger logger = LogManager.getLogger((String)MasterBeanGenerator_with_db.class.getName());
    protected String storage;
    protected int storagetype;

    public MasterBeanGenerator_with_db(Project project, Model model) {
        super(project, model);
        this.storage = model.getStorage();
        this.storagetype = AppSchemaUtil.getStorageType(this.storage);
    }

    @Override
    public String[] getDefaultImport() {
        ArrayList<Object> ilist = new ArrayList<Object>();
        ilist.add("java.sql.Connection");
        ilist.add("java.sql.SQLException");
        String masterpackage = "jp.jasminesoft.jfc.master";
        ilist.add(masterpackage + ".app.AbstractMasterTable");
        ilist.add("jp.jasminesoft.jfc.ActionParameter");
        ilist.add("org.apache.logging.log4j.Logger");
        ilist.add("org.apache.logging.log4j.LogManager");
        return ilist.toArray(new String[0]);
    }

    @Override
    public String gClassDeclaration() {
        StringBuilder sb = new StringBuilder();
        sb.append("public class ");
        sb.append(this.getClassname());
        sb.append(" extends AbstractMasterTable");
        sb.append(CR);
        return sb.toString();
    }

    @Override
    protected String gVariableDefinition() {
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("/** ");
        sb.append(rman.getValue("master.comment.myinstance"));
        sb.append(" */");
        sb.append(CR);
        sb.append("    ");
        sb.append("private static ");
        sb.append(this.getClassname());
        sb.append(" instance;");
        sb.append(CR);
        sb.append(CR);
        sb.append(this.gLoggerReady(this.getClassname()));
        return sb.toString();
    }

    @Override
    protected String gMasterBeanMethod() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.gGetInstanceMethod());
        sb.append(CR);
        sb.append(this.gGetTablenameMethod());
        sb.append(CR);
        sb.append(this.gClearMethod());
        sb.append(this.gGetterMethod());
        return sb.toString();
    }

    protected String gGetInstanceMethod() {
        StringBuilder sb = new StringBuilder();
        String[] param = new String[]{"p ActionParameter"};
        sb.append(CommentGenerator.gComment(rman.getValue("java.comment.getinstance"), param, this.getClassname()));
        sb.append("    ");
        sb.append("public static synchronized ");
        sb.append(this.getClassname());
        sb.append(" getInstance(ActionParameter p) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("if (instance == null)");
        sb.append(CR);
        sb.append("            ");
        sb.append("instance = new ");
        sb.append(this.getClassname());
        sb.append("();");
        sb.append(CR);
        sb.append("        ");
        sb.append("if (!instance.isValid())");
        sb.append(CR);
        sb.append("            ");
        sb.append("instance.init(p);");
        sb.append(CR);
        sb.append("        ");
        sb.append("return instance;");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        return sb.toString();
    }

    protected String gClearMethod() {
        StringBuilder sb = new StringBuilder();
        sb.append(CommentGenerator.gComment(rman.getValue("java.comment.clear"), null, null));
        sb.append("    ");
        sb.append("public static void clear() {");
        sb.append(CR);
        sb.append("        ");
        sb.append("if (instance != null && instance.isValid()) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("instance.release();");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected String gGetTablenameMethod() {
        StringBuilder sb = new StringBuilder();
        sb.append(CommentGenerator.gComment(rman.getValue("master.comment.tablename"), null, rman.getValue("master.comment.tablename.retvalue")));
        sb.append("    ");
        sb.append("public String getTablename() {");
        sb.append(CR);
        sb.append("        ");
        sb.append("return JFCAppTablename.");
        sb.append(TablenameGenerator.createTableVariableName(this.model));
        sb.append(";");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        return sb.toString();
    }
}

