/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.MobileJspBodyGenerator_show;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Displayitem;
import jp.jasminesoft.jfc.gen.appschema.Displayitemgroup;
import jp.jasminesoft.jfc.gen.appschema.Displaymodel;
import jp.jasminesoft.jfc.gen.appschema.IDisplayitemgroupChoice;
import jp.jasminesoft.jfc.gen.appschema.IDisplaymodelChoice;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.Link;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Presentation;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MobileJspBodyGenerator_multi_base
extends MobileJspBodyGenerator_show {
    protected Logger logger = LogManager.getLogger((String)MobileJspBodyGenerator_multi_base.class.getName());
    private static final String ROWSPAN_INNER_ID = "jshparam_rowspan_";

    public MobileJspBodyGenerator_multi_base(Project project, Action action, Presentation presentation, Model pmodel, String idref, Displaymodel displaymodel, boolean isOutputJSTL) {
        super(project, action, presentation, pmodel, idref, displaymodel, isOutputJSTL);
    }

    protected static int createMultiColumnList(Displaymodel displaymodel, List<List<IDisplaymodelChoice>> multiColumnList) {
        int max_column = 0;
        for (IDisplaymodelChoice idmc : displaymodel.getContent()) {
            Displayitemgroup ditemg;
            if (!(idmc instanceof Displayitemgroup) || !(ditemg = (Displayitemgroup)idmc).getUseMultipleLayout()) continue;
            ArrayList<Cloneable> _list = new ArrayList<Cloneable>();
            for (IDisplayitemgroupChoice idmgc : ditemg.getContent()) {
                if (idmgc instanceof Link) {
                    Link link = (Link)idmgc;
                    _list.add(link);
                    continue;
                }
                if (!(idmgc instanceof Displayitem)) continue;
                Displayitem ditem = (Displayitem)idmgc;
                _list.add(ditem);
            }
            max_column = Math.max(max_column, _list.size());
            multiColumnList.add(_list);
        }
        return max_column;
    }

    protected static String[] createLayoutArray(List<List<IDisplaymodelChoice>> multiColumnList, int maxColumn, List<Displayitem> hiddenlist) {
        String[] layoutArray = null;
        if (maxColumn > 0) {
            ArrayList<Object> tmpList = new ArrayList<Object>();
            List<IDisplaymodelChoice> _list = multiColumnList.get(0);
            int size = _list.size();
            for (int i = 0; i < size; ++i) {
                int colspan;
                int rowspan;
                IDisplaymodelChoice idmc = _list.get(i);
                if (idmc instanceof Link) {
                    tmpList.add(null);
                    continue;
                }
                if (!(idmc instanceof Displayitem)) continue;
                Displayitem _ditem = (Displayitem)idmc;
                if (AppSchemaUtil.isHiddenDisplayitem(_ditem)) {
                    hiddenlist.add(_ditem);
                    continue;
                }
                String _label = _ditem.getLabel();
                if (StringUtils.isNotBlank((CharSequence)_label)) {
                    rowspan = _ditem.getRowspan();
                    if (rowspan > 1) {
                        tmpList.add(_label + "+jshparam_rowspan_" + rowspan);
                    } else {
                        tmpList.add(_label);
                    }
                } else {
                    rowspan = _ditem.getRowspan();
                    if (rowspan > 1) {
                        tmpList.add(ROWSPAN_INNER_ID + rowspan);
                    } else {
                        tmpList.add(null);
                    }
                }
                if (colspan <= 1) continue;
                for (colspan = _ditem.getColspan(); colspan > 1; --colspan) {
                    tmpList.add(null);
                }
            }
            layoutArray = tmpList.toArray(new String[0]);
        }
        return layoutArray;
    }

    protected boolean createHeader(IDisplaymodelChoice[] idmc, StringBuilder sb, int insertPoint, StringBuilder fsb, IModelChoice[] pimc, int loopCount, int size) {
        return this.createHeader(idmc, sb, insertPoint, fsb, pimc, loopCount, size, null);
    }

    protected boolean createHeader(IDisplaymodelChoice[] idmc, StringBuilder sb, int insertPoint, StringBuilder fsb, IModelChoice[] pimc, int loopCount, int size, String[] layoutArray) {
        ArrayList<Displayitem> processedDisplayitemList = new ArrayList<Displayitem>();
        int numOfHiddenDisplayitem = 0;
        boolean isOutputBeginForEachElement = false;
        for (int i = 0; i < idmc.length; ++i) {
            if (!(idmc[i] instanceof Displayitem)) continue;
            Displayitem ditem = (Displayitem)idmc[i];
            if (!AppSchemaUtil.isHiddenDisplayitem(ditem)) {
                processedDisplayitemList.add(ditem);
                continue;
            }
            ++numOfHiddenDisplayitem;
        }
        Displayitem[] ditems = this.createLayoutedDisplayitemArray(processedDisplayitemList, layoutArray, loopCount);
        String parentname = this.getParentName(ditems);
        if (parentname != null) {
            if (loopCount == 0) {
                sb.insert(insertPoint, fsb.toString());
                this.gDisplayRowNameContainer(sb, pimc, ditems, this.displaymodel, parentname);
            }
            this.gDisplayRowNameMain(sb, pimc, ditems, this.displaymodel, parentname);
            if (loopCount == size - 1) {
                this.gTemplate2(sb, parentname);
                isOutputBeginForEachElement = true;
            }
        } else if (idmc.length != numOfHiddenDisplayitem) {
            Object[] o = new Object[]{this.pmodel.getId()};
            this.logger.error(this.rman.getValue("jsp.layout.container.multicolumn", o));
        }
        return isOutputBeginForEachElement;
    }

    protected Displayitem[] createLayoutedDisplayitemArray(List<Displayitem> processedDisplayitemList, String[] layoutArray, int loopCount) {
        Displayitem[] ditems = processedDisplayitemList.toArray(new Displayitem[0]);
        ArrayList<Displayitem> tlist = new ArrayList<Displayitem>();
        if (layoutArray != null && this.isNullLayout(layoutArray)) {
            tlist.addAll(Arrays.asList(ditems));
            int tsize = tlist.size();
            if (tsize < layoutArray.length) {
                for (int i = 0; i < layoutArray.length - tsize; ++i) {
                    tlist.add(new Displayitem());
                }
            }
            ditems = tlist.toArray(new Displayitem[0]);
        } else if (layoutArray != null && layoutArray.length != ditems.length) {
            int k = 0;
            int totalCol = 0;
            for (String linfo : layoutArray) {
                Displayitem _pre_ditem;
                if (linfo == null) {
                    if (loopCount == 0) {
                        tlist.add(new Displayitem());
                        continue;
                    }
                    if (k < ditems.length) {
                        if (StringUtils.isEmpty((CharSequence)ditems[k].getLabel())) {
                            tlist.add(ditems[k]);
                            totalCol += ditems[k].getColspan();
                        } else {
                            tlist.add(new Displayitem());
                            ++totalCol;
                        }
                    } else if (k >= totalCol) {
                        tlist.add(new Displayitem());
                    }
                    ++k;
                    continue;
                }
                if (linfo.startsWith(ROWSPAN_INNER_ID)) {
                    int rowspan = NumberUtils.toInt((String)linfo.substring(ROWSPAN_INNER_ID.length()));
                    if (rowspan <= 0 || rowspan >= loopCount + 1) continue;
                    tlist.add(new Displayitem());
                    continue;
                }
                int p = linfo.indexOf("+jshparam_rowspan_");
                if (p > 0) {
                    linfo = linfo.substring(0, p);
                }
                boolean setDisplayitemFlag = false;
                k = 0;
                for (Displayitem _ditem : ditems) {
                    ++k;
                    if (!StringUtils.isNotBlank((CharSequence)_ditem.getLabel()) || !_ditem.getLabel().equals(linfo)) continue;
                    boolean existFlag = false;
                    for (Displayitem __ditem : tlist) {
                        if (__ditem.getName() == null || !__ditem.getName().equals(_ditem.getName())) continue;
                        existFlag = true;
                        break;
                    }
                    if (existFlag) continue;
                    tlist.add(_ditem);
                    setDisplayitemFlag = true;
                    break;
                }
                if (setDisplayitemFlag || p >= 0 || (_pre_ditem = this.checkRowspan(tlist.size(), loopCount)) != null) continue;
                tlist.add(new Displayitem());
            }
            ditems = tlist.toArray(new Displayitem[0]);
        }
        return ditems;
    }

    private boolean isNullLayout(String[] layoutArray) {
        boolean isDefinedLayout = false;
        for (String s : layoutArray) {
            if (!StringUtils.isNotBlank((CharSequence)s)) continue;
            isDefinedLayout = true;
            break;
        }
        return !isDefinedLayout;
    }

    protected String createContent(IDisplaymodelChoice[] idmc, StringBuilder sb, IModelChoice[] pimc, Map<String, Object> attrMap, int loopCount, int size) {
        return this.createContent(idmc, sb, pimc, attrMap, loopCount, size, null);
    }

    protected String createContent(IDisplaymodelChoice[] idmc, StringBuilder sb, IModelChoice[] pimc, Map<String, Object> attrMap, int loopCount, int size, String[] layoutArray) {
        idmc = this.createLayoutedDisplayitemChoiceArray(idmc, layoutArray, loopCount);
        ArrayList<Displayitem> processedDisplayitemList = new ArrayList<Displayitem>();
        StringBuilder tb0 = new StringBuilder();
        this.createContent0(idmc, sb, pimc, attrMap, processedDisplayitemList, tb0);
        Displayitem[] ditems = processedDisplayitemList.toArray(new Displayitem[0]);
        String parentname = this.getParentName(ditems);
        if (parentname != null && this.tplman == null) {
            String _valueClass;
            boolean usePreElement = false;
            for (Displayitem ditem : ditems) {
                if (!ditem.getUsePreTag()) continue;
                usePreElement = true;
                break;
            }
            if (usePreElement) {
                sb.append("<c:choose>");
                sb.append("  <c:when test=\"${__position.index % 2 == 0}\">");
                sb.append("    <c:set var=\"preclass\" value=\"display_field_prewrap\"/>");
                sb.append("  </c:when>");
                sb.append("  <c:otherwise>");
                sb.append("   <c:set var=\"preclass\" value=\"display_field2_prewrap\"/>");
                sb.append("  </c:otherwise>");
                sb.append("</c:choose>");
            }
            if ((_valueClass = (String)attrMap.get("valueClass")) == null || _valueClass.length() == 0) {
                _valueClass = "display_field_center,display_field2_center";
            }
            this.gExpandAttrMap0("tr", "class", _valueClass, "__position.index", sb);
            sb.append(tb0.toString());
            sb.append("</tr>");
        }
        return parentname;
    }

    protected IDisplaymodelChoice[] createLayoutedDisplayitemChoiceArray(IDisplaymodelChoice[] idmc, String[] layoutArray, int loopCount) {
        ArrayList<Displayitem> hiddenlist = new ArrayList<Displayitem>();
        if (layoutArray != null) {
            ArrayList<IDisplaymodelChoice> tlist = new ArrayList<IDisplaymodelChoice>();
            for (IDisplaymodelChoice _item : idmc) {
                if (_item instanceof Link) {
                    tlist.add(_item);
                    continue;
                }
                if (!(_item instanceof Displayitem)) continue;
                Displayitem _ditem = (Displayitem)_item;
                if (AppSchemaUtil.isHiddenDisplayitem(_ditem)) {
                    hiddenlist.add(_ditem);
                    continue;
                }
                tlist.add(_item);
            }
            if (layoutArray.length == tlist.size()) {
                tlist.addAll(hiddenlist);
                idmc = tlist.toArray(new IDisplaymodelChoice[0]);
            } else {
                ArrayList<IDisplaymodelChoice> tlist2 = new ArrayList<IDisplaymodelChoice>();
                if (this.isNullLayout(layoutArray)) {
                    tlist2.addAll(Arrays.asList(idmc));
                    int tsize = tlist2.size();
                    if (tsize < layoutArray.length) {
                        for (int i = 0; i < layoutArray.length - tsize; ++i) {
                            tlist2.add(new Displayitem());
                        }
                    }
                } else {
                    int k = 0;
                    int totalCol = 0;
                    for (String linfo : layoutArray) {
                        Displayitem _pre_ditem;
                        if (linfo == null) {
                            if (loopCount == 0) {
                                tlist2.add(new Displayitem());
                                continue;
                            }
                            if (k < tlist.size()) {
                                IDisplaymodelChoice imc = (IDisplaymodelChoice)tlist.get(k);
                                if (imc instanceof Displayitem) {
                                    Displayitem _ditem = (Displayitem)imc;
                                    if (StringUtils.isEmpty((CharSequence)_ditem.getLabel())) {
                                        tlist2.add(_ditem);
                                        totalCol += _ditem.getColspan();
                                    } else {
                                        tlist2.add(new Displayitem());
                                        ++totalCol;
                                    }
                                } else {
                                    tlist2.add(new Displayitem());
                                    ++totalCol;
                                }
                            } else if (k >= totalCol) {
                                tlist2.add(new Displayitem());
                            }
                            ++k;
                            continue;
                        }
                        if (linfo.startsWith(ROWSPAN_INNER_ID)) {
                            int rowspan = NumberUtils.toInt((String)linfo.substring(ROWSPAN_INNER_ID.length()));
                            if (rowspan <= 0 || rowspan >= loopCount + 1) continue;
                            tlist2.add(new Displayitem());
                            continue;
                        }
                        int p = linfo.indexOf("+jshparam_rowspan_");
                        if (p > 0) {
                            linfo = linfo.substring(0, p);
                        }
                        boolean setDisplayitemFlag = false;
                        k = 0;
                        for (IDisplaymodelChoice _item : tlist) {
                            Displayitem _ditem;
                            ++k;
                            if (_item instanceof Link || !(_item instanceof Displayitem) || !StringUtils.isNotBlank((CharSequence)(_ditem = (Displayitem)_item).getLabel()) || !_ditem.getLabel().equals(linfo)) continue;
                            boolean existFlag = false;
                            for (IDisplaymodelChoice __idc : tlist2) {
                                Displayitem __ditem;
                                if (!(__idc instanceof Displayitem) || (__ditem = (Displayitem)__idc).getName() == null || !__ditem.getName().equals(_ditem.getName())) continue;
                                existFlag = true;
                                break;
                            }
                            if (existFlag) continue;
                            tlist2.add(_ditem);
                            setDisplayitemFlag = true;
                            break;
                        }
                        if (setDisplayitemFlag || p >= 0 || (_pre_ditem = this.checkRowspan(tlist2.size(), loopCount)) != null) continue;
                        tlist2.add(new Displayitem());
                    }
                    tlist2.addAll(hiddenlist);
                }
                idmc = tlist2.toArray(new IDisplaymodelChoice[0]);
            }
        }
        return idmc;
    }

    private Displayitem checkRowspan(int pos, int loopCount) {
        Displayitem ret = null;
        int i = 0;
        for (IDisplaymodelChoice idmc : this.displaymodel.getContent()) {
            if (!(idmc instanceof Displayitemgroup)) continue;
            Displayitemgroup ditemg = (Displayitemgroup)idmc;
            if (ditemg.getUseMultipleLayout() && i < loopCount) {
                int ptr = 0;
                for (IDisplayitemgroupChoice idmgc : ditemg.getContent()) {
                    int rowspan;
                    if (!(idmgc instanceof Displayitem)) continue;
                    Displayitem ditem = (Displayitem)idmgc;
                    if (ptr == pos && (rowspan = ditem.getRowspan()) > 0 && i + rowspan - 1 >= loopCount) {
                        ret = ditem;
                        break;
                    }
                    ++ptr;
                }
            }
            ++i;
        }
        return ret;
    }

    protected void setContainer2Request4getControlTypeMethod(String parentname, StringBuilder sb) {
        sb.append("<c:set var=\"__" + parentname + "\" value=\"${");
        sb.append(parentname);
        sb.append("}\" scope=\"request\"/>");
    }

    protected void gDisplayRowNameMain(StringBuilder sb, IModelChoice[] imc, Displayitem[] ditems, Displaymodel displaymodel, String elementname) {
    }

    protected void gDisplayRowNameContainer(StringBuilder sb, IModelChoice[] imc, Displayitem[] ditems, Displaymodel displaymodel, String elementname) {
    }

    protected void gTemplate2(StringBuilder sb, String elementname) {
    }

    protected void createContent0(IDisplaymodelChoice[] idmc, StringBuilder sb, IModelChoice[] pimc, Map<String, Object> attrMap, List<Displayitem> processedDisplayitemList, StringBuilder tb0) {
    }

    protected String getNthValue(String s, int n, boolean isLast) {
        String[] tokens;
        String content;
        int ptr;
        if (s == null) {
            return null;
        }
        String v = StringUtil.removePreAndPostWhitespaceWithoutInside((String)s);
        if (v != null && v.charAt(0) == '[' && v.charAt(v.length() - 1) == ']' && (ptr = (content = v.substring(1, v.length() - 1)).indexOf("/")) > 0 && (tokens = content.split("/")).length >= n) {
            return tokens[n];
        }
        if (isLast) {
            return s;
        }
        return "";
    }
}

