/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.JFCAppResourceGenerator;
import jp.jasminesoft.jfc.gen.JspGenerator;
import jp.jasminesoft.jfc.gen.JspLayoutManager;
import jp.jasminesoft.jfc.gen.JspLayoutManagerFactory;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Css;
import jp.jasminesoft.jfc.gen.appschema.Csslist;
import jp.jasminesoft.jfc.gen.appschema.Layout;
import jp.jasminesoft.jfc.gen.appschema.Presentation;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;

public abstract class MobileJspGenerator
extends JspGenerator {
    public MobileJspGenerator(Project project, Action action, Presentation presentation) {
        super(project, action, presentation, null);
    }

    public MobileJspGenerator(Project project, Action action, Presentation presentation, String fid) {
        super(project, action, presentation, fid);
    }

    @Override
    public String process0() {
        StringBuilder sb = new StringBuilder();
        String cnt_header1 = this.gHeader1();
        String cnt_header2 = this.gHeader2();
        String cnt_header3 = this.gHeader3();
        String cnt_body = this.gBody();
        sb.append(cnt_header1);
        sb.append(cnt_header2);
        sb.append(cnt_header3);
        sb.append(cnt_body);
        return sb.toString();
    }

    @Override
    protected String gHeader3() {
        boolean isLogonForm = "logon".equals(this.fid);
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append(CR);
        sb.append("<head>");
        sb.append(CR);
        String cnt_javascript = this.gJavaScriptTag();
        if (!this.isRedirectJspFlag && cnt_javascript != null) {
            sb.append(cnt_javascript);
        }
        if (this.isRedirectJspFlag) {
            return sb.toString();
        }
        sb.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"");
        sb.append("css/${sessionScope.");
        sb.append("__jfc_cssfilename");
        sb.append("}.css");
        sb.append("\">");
        sb.append(CR);
        if (isLogonForm) {
            sb.append("<style type=\"text/css\">").append(CR);
            sb.append("@import \"css/").append(this.presentation.getCss()).append(".css").append("\"").append(CR);
            sb.append("</style>").append(CR);
        }
        sb.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"css/common.css\">").append(CR);
        sb.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"css/<c:out value='${sessionScope.__jfc_cssfilename}'/>.css\">").append(CR);
        sb.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"css/<c:out value='${sessionScope.__jfc_cssfilename_with_locale}'/>.css\">").append(CR);
        sb.append("<style type=\"text/css\">");
        sb.append(CR);
        sb.append("<!--");
        sb.append(CR);
        sb.append("${__jfc_csscontent}");
        sb.append(CR);
        sb.append("-->");
        sb.append(CR);
        sb.append("</style>");
        sb.append(CR);
        sb.append("<style type=\"text/css\">");
        sb.append(CR);
        sb.append("  v\\:*{");
        sb.append(CR);
        sb.append("     behavior:url(#default#VML);");
        sb.append(CR);
        sb.append("  }");
        sb.append(CR);
        sb.append("</style>");
        sb.append(CR);
        if (isLogonForm || StringUtils.startsWith((CharSequence)this.fid, (CharSequence)"searchList")) {
            sb.append("<script type=\"text/javascript\" src=\"<fmt:message key='__jfc_common.dojo_webpage_dir'/>/dojo/dojo.js\" data-dojo-config=\"async: true, parseOnLoad: false, paths:{'apphome':'../..'}, locale: '<c:out value='${sessionScope.__jfc_browserLocale}'/>'\"></script>");
            sb.append(CR);
        }
        sb.append("<script type=\"text/javascript\">").append(CR);
        if (!isLogonForm && !this.isRedirectJspFlag) {
            sb.append("  require([\"dojo/parser\", \"dojo/dom-style\", \"dojo/ready\", \"dojo/i18n!apphome/nls/common\"], function(parser, domStyle, ready, res) {").append(CR);
            sb.append("    window.browser_locale = \"<c:out value='${sessionScope.__jfc_browserLocale}'/>\";").append(CR);
            sb.append("    window.res = res;").append(CR);
            sb.append("    parser.parse();").append(CR);
            sb.append("    ready(function() {").append(CR);
            sb.append("      for (i in Initializer.initList) {").append(CR);
            sb.append("        (Initializer.initList[i])();").append(CR);
            sb.append("      }").append(CR);
            sb.append("    });").append(CR);
            sb.append("    dojo.addOnUnload(function(){").append(CR);
            sb.append("      for (i in Initializer.finList) {").append(CR);
            sb.append("        (Initializer.finList[i])();").append(CR);
            sb.append("      }").append(CR);
            sb.append("    });").append(CR);
            sb.append("  });").append(CR);
        }
        sb.append("</script>").append(CR);
        Object title = AppSchemaUtil.getTitle(this.project);
        if (!this.project.getFixedtitle()) {
            String pagetitle = null;
            if (this.action != null) {
                pagetitle = this.action.getDescription();
            }
            if (pagetitle == null || pagetitle.length() == 0) {
                pagetitle = this.presentation.getDescription();
            }
            if (pagetitle != null && pagetitle.length() > 0) {
                title = (String)title + " " + pagetitle;
            }
        }
        String rkey = JFCAppResourceGenerator.createTitleResourceKey("title", StringUtil.escapeStringForXML((String)title), this);
        sb.append("<!-- begin title -->");
        sb.append(CR);
        Csslist csslist = this.presentation.getCsslist();
        if (csslist != null) {
            Css[] css_ary;
            for (Css css : css_ary = csslist.getCss()) {
                String cssfilename = css.getContent();
                String media = css.getMedia();
                sb.append("<link href=\"").append(cssfilename).append("\" rel=\"stylesheet\" type=\"text/css\"");
                if (media != null && media.length() > 0) {
                    sb.append(" media=\"" + media + "\"");
                }
                sb.append("/>").append(CR);
            }
        }
        sb.append("<title>");
        sb.append("<fmt:message key=\"").append(rkey).append("\"/>");
        sb.append("</title>").append(CR);
        sb.append("<!-- end title -->").append(CR);
        sb.append("</head>").append(CR);
        return sb.toString();
    }

    @Override
    protected boolean hasTips() {
        return false;
    }

    @Override
    protected String gBody() {
        StringBuilder sb = new StringBuilder();
        sb.append("<body class=\"tundra\"");
        if ("logon".equals(this.fid) || "logoff".equals(this.fid)) {
            sb.append(" onload=\"init()\"");
        }
        sb.append(">").append(CR);
        sb.append(this.gBody0());
        sb.append(this.gBody1());
        sb.append("<br>").append(CR);
        if (this.isLogonForm || StringUtils.startsWith((CharSequence)this.fid, (CharSequence)"searchList")) {
            sb.append("<script type=\"text/javascript\" src=\"system/mycommon.js?<c:out value='${applicationScope.__jfc_releaseTimestamp}'/>\" charset=\"UTF-8\"></script>").append(CR);
        }
        sb.append("</body>").append(CR);
        sb.append("</html>");
        return sb.toString();
    }

    @Override
    protected String gBody0() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.gComment("gBody0"));
        Layout layout = this.presentation.getLayout();
        if (layout == null) {
            return sb.toString();
        }
        JspLayoutManager lman = JspLayoutManagerFactory.create(layout, this);
        if (lman == null) {
            return "";
        }
        lman.setPagetitle(this.presentation.getDescription());
        String _body = lman.process();
        String _head = lman.getPreparedContent();
        if (_head != null && _head.length() > 0) {
            sb.append(_head);
            sb.append(CR);
        }
        if (_body != null && _body.length() > 0) {
            sb.append(_body);
        }
        return sb.toString();
    }

    @Override
    public boolean isMobile() {
        return true;
    }
}

