/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.HashMap;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.MenuXmlGenerator;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.Menubar;
import jp.jasminesoft.jfc.gen.appschema.Menulinkaction;
import jp.jasminesoft.jfc.gen.appschema.Project;
import org.apache.commons.lang3.StringUtils;

public class MobileMenuXmlGenerator
extends MenuXmlGenerator {
    public MobileMenuXmlGenerator(Project project) {
        super(project);
    }

    @Override
    public String getFilename() {
        return "mobileMenu";
    }

    @Override
    public String process0() {
        Menubar menubar = this.project.getMenubar();
        if (menubar == null) {
            return "";
        }
        HashMap<String, MenuXmlGenerator.MenuNode> menuMap = new HashMap<String, MenuXmlGenerator.MenuNode>();
        MenuXmlGenerator.MenuNode root = this.createMenuNode(menubar, menuMap);
        IProjectChoice[] ipc = this.project.getContent();
        if (ipc == null) {
            return this.createBody(root);
        }
        for (int i = 0; i < ipc.length; ++i) {
            Menulinkaction mactn;
            if (ipc[i] instanceof Action) {
                Action action = (Action)ipc[i];
                if (action.getMenuref() == null || !AppSchemaUtil.isMobile(action, this.project)) continue;
                this.addMenuContent(action, menuMap);
                continue;
            }
            if (!(ipc[i] instanceof Menulinkaction) || !(mactn = (Menulinkaction)ipc[i]).getMobile()) continue;
            if (StringUtils.isBlank((CharSequence)mactn.getMenuref())) {
                this.logger.debug("menulinkaction.menuref is null, skip to add menu. " + mactn.getDescription());
                continue;
            }
            this.addMenuContent(mactn, menuMap);
        }
        return this.createBody(root);
    }

    @Override
    protected String createBody(MenuXmlGenerator.MenuNode root) {
        StringBuilder sb = new StringBuilder();
        String enc = JavaSourceGenerator.getEncoding(this.project);
        sb.append("<?xml version=\"1.0\" encoding=\"").append(enc).append("\" ?>").append(CR);
        sb.append("<menubar>").append(CR);
        MenuXmlGenerator.MenuObject[] menus = root.getAll();
        for (int i = 0; i < menus.length; ++i) {
            if (!this.hasMenuContent(menus[i])) continue;
            this.outputMenuObject(menus[i], "  ", sb);
        }
        sb.append("</menubar>").append(CR);
        return sb.toString();
    }

    protected boolean hasMenuContent(MenuXmlGenerator.MenuObject menuObject) {
        if (menuObject instanceof MenuXmlGenerator.MenuNode) {
            MenuXmlGenerator.MenuObject[] menuObjects = ((MenuXmlGenerator.MenuNode)menuObject).getAll();
            for (int i = 0; i < menuObjects.length; ++i) {
                if (!(menuObjects[i] instanceof MenuXmlGenerator.MenuContent)) continue;
                return true;
            }
        }
        return false;
    }
}

