/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.jasminesoft.jfc.gen.ProcessBeanGenerator;
import jp.jasminesoft.jfc.gen.appschema.Action;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProcessBeanGeneratorMap {
    private static final Logger logger = LogManager.getLogger(ProcessBeanGeneratorMap.class);
    private HashMap<String, Map<String, List<ProcessBeanGenerator>>> pbeanMap = new HashMap();

    public void add(ProcessBeanGenerator pbeangen) {
        String type;
        List<ProcessBeanGenerator> pbeanModelTypeList;
        if (pbeangen == null) {
            return;
        }
        String modelid = pbeangen.getStoreModelId();
        Map<String, List<ProcessBeanGenerator>> pbeanModelMap = this.pbeanMap.get(modelid);
        if (pbeanModelMap == null) {
            pbeanModelMap = new HashMap<String, List<ProcessBeanGenerator>>();
            this.pbeanMap.put(modelid, pbeanModelMap);
        }
        if ((pbeanModelTypeList = pbeanModelMap.get(type = pbeangen.getActionType())) == null) {
            pbeanModelTypeList = new ArrayList<ProcessBeanGenerator>();
            pbeanModelMap.put(type, pbeanModelTypeList);
        }
        pbeanModelTypeList.add(pbeangen);
    }

    public List<ProcessBeanGenerator> getProcessBeanList(String modelid, String type) {
        Map<String, List<ProcessBeanGenerator>> pbeanModelMap = this.pbeanMap.get(modelid);
        if (pbeanModelMap == null) {
            return Collections.emptyList();
        }
        List<ProcessBeanGenerator> pbeanModelTypeList = pbeanModelMap.get(type);
        if (pbeanModelTypeList == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(pbeanModelTypeList);
    }

    public List<ProcessBeanGenerator> getProcessBeanList(String modelid) {
        Map<String, List<ProcessBeanGenerator>> pbeanModelMap = this.pbeanMap.get(modelid);
        if (pbeanModelMap == null) {
            return Collections.emptyList();
        }
        ArrayList<ProcessBeanGenerator> list = new ArrayList<ProcessBeanGenerator>();
        for (List<ProcessBeanGenerator> pbeanModelTypeList : pbeanModelMap.values()) {
            if (pbeanModelTypeList == null) continue;
            list.addAll(pbeanModelTypeList);
        }
        return Collections.unmodifiableList(list);
    }

    public Set<String> getTypeSet(String modelid) {
        Map<String, List<ProcessBeanGenerator>> pbeanModelMap = this.pbeanMap.get(modelid);
        if (pbeanModelMap == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(pbeanModelMap.keySet());
    }

    public Set<String> getModelidSet() {
        return Collections.unmodifiableSet(this.pbeanMap.keySet());
    }

    private void printDebugMessage() {
        for (Map.Entry<String, Map<String, List<ProcessBeanGenerator>>> modelid_entry : this.pbeanMap.entrySet()) {
            String modelid = modelid_entry.getKey();
            logger.info("modelid = " + modelid);
            Map<String, List<ProcessBeanGenerator>> pbeanTypeMap = modelid_entry.getValue();
            for (Map.Entry<String, List<ProcessBeanGenerator>> type_entry : pbeanTypeMap.entrySet()) {
                String type = type_entry.getKey();
                logger.info("    type = " + type);
                for (ProcessBeanGenerator pgen : type_entry.getValue()) {
                    Action action = pgen.getAction();
                    if (action == null) {
                        logger.info("      action is null");
                        continue;
                    }
                    logger.info("      action.id = " + action.getId());
                }
            }
        }
    }
}

