/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.jasminesoft.jfc.appgen.component.StoreModel;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CommentGenerator;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.ProcessBeanGenerator;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.jfc.gen.appschema.Transaction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ProcessBeanGenerator_transactional
extends ProcessBeanGenerator {
    protected Logger logger = LogManager.getLogger((String)ProcessBeanGenerator_transactional.class.getName());
    private boolean isTransactionSupport;
    private boolean isTransactionContainerSupport;

    public ProcessBeanGenerator_transactional(Project project, String id, String type, Action action) {
        super(project, id, type, action);
        Transaction[] transactions = AppSchemaUtil.getTransactionUsingProcessBean(action);
        if (transactions.length > 0) {
            this.isTransactionSupport = true;
            for (Transaction transaction : transactions) {
                String key = transaction.getKey();
                boolean hasChildPart = AppSchemaUtil.hasChildPart(key);
                if (!hasChildPart) continue;
                this.isTransactionContainerSupport = true;
                break;
            }
        }
    }

    protected boolean checkTransactionSupport() {
        return this.isTransactionSupport;
    }

    protected boolean checkTransactionContainerSupprt() {
        return this.isTransactionContainerSupport;
    }

    @Override
    protected void additionalImportSet(Set<String> importSet) {
        Transaction[] transactions = AppSchemaUtil.getTransactionUsingProcessBean(this.action);
        if (transactions.length == 0) {
            return;
        }
        importSet.add("org.apache.commons.lang3.StringUtils");
        for (int i = 0; i < transactions.length; ++i) {
            Transaction transaction = transactions[i];
            Model rmodel = AppSchemaUtil.getModel(this.project, transaction.getContent());
            Object s = AppSchemaUtil.getPackagename(rmodel, this.project);
            if (s == null || ((String)s).length() <= 0) continue;
            s = (String)s + "*";
            importSet.add((String)s);
        }
    }

    protected Map<Transaction, Modelitem> createTransactionMap(Model model) {
        LinkedHashMap<Transaction, Modelitem> transactionMap = new LinkedHashMap<Transaction, Modelitem>();
        Transaction[] transactions = AppSchemaUtil.getTransactionUsingProcessBean(this.action);
        if (transactions.length == 0) {
            return transactionMap;
        }
        for (int i = 0; i < transactions.length; ++i) {
            Transaction transaction = transactions[i];
            String itemname = transaction.getKey();
            String targetmodel = transaction.getContent();
            boolean isFound = false;
            IModelChoice[] imc = model.getContent();
            for (int j = 0; j < imc.length; ++j) {
                Modelitem mitem;
                Relation rel;
                if (!(imc[j] instanceof Modelitem) || (rel = AppSchemaUtil.getRelation(mitem = (Modelitem)imc[j])) == null) continue;
                if (itemname != null && itemname.length() > 0) {
                    if (!mitem.getName().equals(itemname)) continue;
                    transactionMap.put(transaction, mitem);
                    isFound = true;
                    continue;
                }
                if (!targetmodel.equals(rel.getIdref())) continue;
                transaction.setKey(mitem.getName());
                transactionMap.put(transaction, mitem);
                isFound = true;
            }
            if (isFound) continue;
            Object[] o = new Object[]{targetmodel};
            this.logger.warn(rman.getValue("pbean.illegal.transaction.notfound", o));
        }
        return transactionMap;
    }

    protected void gRunMethod4Transaction(Model model, Map<Transaction, Modelitem> transactionMap, StringBuilder sb) {
        sb.append("        ");
        sb.append("// " + rman.getValue("pbean.comment.transaction.beginlock"));
        sb.append(CR);
        sb.append("        ");
        sb.append("LockManager lman = LockManagerFactory.getLockManager(p);");
        sb.append(CR);
        sb.append("        ");
        sb.append("final String CR = System.getProperty(\"line.separator\");").append(CR);
        sb.append("        ");
        sb.append("javax.servlet.http.HttpSession session = p.request.getSession();");
        sb.append(CR);
        sb.append("        ");
        sb.append("String sessionid = \"\";");
        sb.append(CR);
        sb.append("        ");
        sb.append("if (session != null) sessionid = session.getId();");
        sb.append(CR);
        if (this.isTransactionSupport) {
            sb.append(CR);
            sb.append("        ");
            String sessionFactoryBeanId = new StoreModel(model).sessionFactoryBeanId();
            if (!"sessionFactory".equals(sessionFactoryBeanId)) {
                sb.append("org.hibernate.Session session");
                sb.append(CR);
                sb.append("                ");
                sb.append("= HibernateUtil.openSession(\"");
                sb.append(sessionFactoryBeanId);
                sb.append("\", p);");
            } else {
                sb.append("org.hibernate.Session hibernateSession = HibernateUtil.openSession();");
            }
            sb.append(CR);
            sb.append("        ");
            sb.append("Transaction tx = hibernateSession.beginTransaction();");
            sb.append(CR).append(CR);
        }
        StringBuilder sb2 = new StringBuilder();
        StringBuilder sb3 = new StringBuilder();
        int count = 1;
        boolean outputCallRun1 = false;
        String mtab = "";
        Object vid = this.getModelVariableName(model);
        for (Map.Entry<Transaction, Modelitem> entry : transactionMap.entrySet()) {
            int i;
            Transaction transaction = entry.getKey();
            String key = transaction.getKey();
            Modelitem mitem = entry.getValue();
            Relation rel = AppSchemaUtil.getRelation(mitem);
            IRNode node = rel.getIdrefAsIRNode();
            Model rmodel = null;
            if (node != null && node instanceof Model) {
                rmodel = (Model)node;
            }
            String p_mitem_id = null;
            String roleid = AppSchemaUtil.getRoleid(rel, this.project);
            String[] roleids = null;
            String[] types = null;
            String[] ptypes = null;
            String[] pwtypes = null;
            String[] varnames = null;
            Modelitem[] rmitems = null;
            int pkeySize = 1;
            if (AppSchemaUtil.isCompositePrimaryKey(roleid)) {
                roleids = AppSchemaUtil.decompositePrimaryKey(roleid);
                pkeySize = roleids.length;
            } else {
                roleids = new String[]{roleid};
            }
            types = new String[pkeySize];
            ptypes = new String[pkeySize];
            pwtypes = new String[pkeySize];
            varnames = new String[pkeySize];
            rmitems = new Modelitem[pkeySize];
            boolean illegalItemFlag = false;
            for (int i2 = 0; i2 < pkeySize; ++i2) {
                rmitems[i2] = AppSchemaUtil.getModelitem(roleids[i2], rmodel);
                if (rmitems[i2] != null) {
                    types[i2] = AppSchemaUtil.getModelitemType(this.project, rmodel.getId(), rmitems[i2], "roleid");
                    ptypes[i2] = ProcessBeanGenerator_transactional.getProperType(types[i2]);
                    pwtypes[i2] = ProcessBeanGenerator_transactional.getB2wc_method(types[i2]);
                    varnames[i2] = "_" + rmitems[i2].getName() + "_" + count;
                }
                if (rmitems[i2] != null) continue;
                Object[] o = new Object[]{model.getId(), key, rel.getIdref(), roleids[i2]};
                this.logger.warn(rman.getValue("value.null.relation.roleid", o));
                illegalItemFlag = true;
                break;
            }
            if (illegalItemFlag) continue;
            boolean hasChildPart = AppSchemaUtil.hasChildPart(key);
            if (hasChildPart) {
                Modelitem p_mitem = AppSchemaUtil.getContainerItem(mitem, model);
                String p_mitem_classname = AppSchemaUtil.getModelitemClassname(p_mitem);
                p_mitem_id = "_" + AppSchemaUtil.getChildPart(p_mitem.getName());
                String p_mitem_getter = JavaSourceGenerator.getterFullMethod(AppSchemaUtil.getChildPart(p_mitem.getName()));
                sb.append("        ");
                sb.append(p_mitem_classname).append("[] ");
                sb.append(p_mitem_id).append("_ary = ");
                sb.append((String)vid).append(p_mitem_getter).append(";").append(CR);
                sb.append("        ");
                sb.append("if (").append(p_mitem_id).append("_ary == null || ");
                sb.append(p_mitem_id).append("_ary.length == 0) {").append(CR);
                sb.append("            ");
                sb.append("String _ret = run1(");
                for (int i3 = 0; i3 < pkeySize; ++i3) {
                    sb.append(JavaSourceGenerator.getNanValue(types[i3]));
                    if (pkeySize <= 1 || i3 >= pkeySize - 1) continue;
                    sb.append(", ");
                }
                sb.append(", hibernateSession, true);").append(CR);
                sb.append("            ");
                sb.append("if (StringUtils.isNotBlank(_ret)) {").append(CR);
                sb.append("                ");
                sb.append("errmsg.append(_ret).append(CR);").append(CR);
                sb.append("            ");
                sb.append("}").append(CR);
                sb.append("        ");
                sb.append("} else {").append(CR);
                sb.append("            ");
                sb.append("boolean finalFlag = false;").append(CR);
                sb.append("            ");
                sb.append("for (int i=0; i<").append(p_mitem_id).append("_ary.length; i++) {").append(CR);
                sb.append("                ");
                sb.append("if (i == ").append(p_mitem_id).append("_ary.length-1) {").append(CR);
                sb.append("                    ");
                sb.append("finalFlag = true;").append(CR);
                sb.append("                ");
                sb.append("}").append(CR);
                sb.append("                ");
                sb.append("p.request.setAttribute(\"__index").append(p_mitem_id).append("\", i);");
                sb.append(CR);
                sb.append("                ");
                sb.append(p_mitem_classname).append(" ");
                sb.append(p_mitem_id).append(" = ").append(p_mitem_id).append("_ary[i];").append(CR);
                mtab = "        ";
                vid = p_mitem_id;
            }
            PrimaryKey[] r_pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey((Model)rel.getIdrefAsIRNode(), this.project);
            for (i = 0; i < pkeySize; ++i) {
                sb.append("        " + mtab);
                sb.append(ptypes[i]);
                sb.append(" ");
                sb.append(varnames[i]);
                sb.append(" = ");
                sb.append((String)vid);
                if (pkeySize == 1) {
                    sb.append(JavaSourceGenerator.getterFullMethod(AppSchemaUtil.getChildPart(key)));
                } else {
                    PrimaryKey r_pkey = r_pkeys[i];
                    String r_pkey_name = AppSchemaUtil.createFullPrimaryKeyName(r_pkey);
                    String itemname = AppSchemaUtil.getChildPart(key) + "_" + r_pkey_name;
                    sb.append(JavaSourceGenerator.getterFullMethod(itemname));
                }
                sb.append(";");
                sb.append(CR);
                if (sb2.length() > 0) {
                    sb2.append(", ");
                }
                sb2.append(ptypes[i]).append(" ").append(varnames[i]);
                if (sb3.length() > 0) {
                    sb3.append(", ");
                }
                sb3.append(varnames[i]);
            }
            sb.append("        " + mtab);
            sb.append("LockObject ");
            sb.append("lo" + count);
            sb.append(" =");
            sb.append(CR);
            sb.append("            " + mtab);
            sb.append("lman.createLockObject(\"");
            sb.append(transaction.getContent());
            sb.append("\",");
            sb.append(CR);
            sb.append("                " + mtab);
            for (i = 0; i < pkeySize; ++i) {
                sb.append(pwtypes[i]);
                sb.append("(");
                sb.append(varnames[i]);
                sb.append(")");
                if (pkeySize <= 1 || i >= pkeySize - 1) continue;
                sb.append(" + \"$\" + ");
            }
            sb.append(",");
            sb.append(CR);
            sb.append("                " + mtab);
            sb.append("sessionid,");
            sb.append(CR);
            sb.append("                " + mtab);
            sb.append("p);");
            sb.append(CR);
            sb.append(CR);
            sb.append("        " + mtab);
            sb.append("// " + rman.getValue("pbean.comment.transaction.getlock"));
            sb.append(CR);
            sb.append("        " + mtab);
            sb.append("LockObject ");
            sb.append("_lo" + count);
            sb.append(" = null;");
            sb.append(CR);
            sb.append("        " + mtab);
            sb.append("if ((");
            sb.append("_lo" + count);
            sb.append(" = lman.addLockObject(");
            sb.append("lo" + count);
            sb.append(")) != null) {");
            sb.append(CR);
            sb.append("            " + mtab);
            sb.append("errmsg.append(");
            sb.append("\"model ");
            sb.append(transaction.getContent());
            sb.append("(\" + ");
            for (i = 0; i < pkeySize; ++i) {
                sb.append(varnames[i]);
                if (pkeySize <= 1 || i >= pkeySize - 1) continue;
                sb.append(" + PrimaryKeyUtils.PKEY_SEPARATOR() + ");
            }
            sb.append(" + \")");
            sb.append(" has already locked.\").append(CR);");
            sb.append(CR);
            if (hasChildPart) {
                sb.append("            " + mtab);
                sb.append("continue;").append(CR);
            }
            sb.append("        " + mtab);
            sb.append("}");
            sb.append(CR);
            ++count;
            if (!hasChildPart) continue;
            sb.append("        " + mtab);
            sb.append("try {");
            sb.append(CR);
            sb.append("            " + mtab);
            sb.append("String _ret = run1(");
            for (i = 0; i < pkeySize; ++i) {
                sb.append(varnames[i]);
                if (pkeySize <= 1 || i >= pkeySize - 1) continue;
                sb.append(", ");
            }
            sb.append(", hibernateSession");
            sb.append(", finalFlag");
            sb.append(");");
            sb.append(CR);
            sb.append("            " + mtab);
            sb.append("if (StringUtils.isNotBlank(_ret)) {").append(CR);
            sb.append("                " + mtab);
            sb.append("errmsg.append(_ret).append(CR);").append(CR);
            sb.append("            " + mtab);
            sb.append("}").append(CR);
            sb.append("        " + mtab);
            sb.append("} finally {");
            sb.append(CR);
            for (int k = 1; k < count; ++k) {
                sb.append("            " + mtab);
                sb.append("lman.releaseLockObject(");
                sb.append("lo" + k);
                sb.append(");");
                sb.append(CR);
            }
            sb.append("        " + mtab);
            sb.append("}");
            sb.append(CR);
            sb.append("            ").append("}").append(CR);
            sb.append("        ").append("}").append(CR);
            outputCallRun1 = true;
        }
        if (!outputCallRun1) {
            sb.append("        ");
            sb.append("try {");
            sb.append(CR);
            sb.append("            ");
            sb.append("String _ret = run1(");
            sb.append((CharSequence)sb3);
            sb.append(", hibernateSession");
            sb.append(", true");
            sb.append(");");
            sb.append(CR);
            sb.append("            ");
            sb.append("if (StringUtils.isNotBlank(_ret)) {").append(CR);
            sb.append("                ");
            sb.append("errmsg.append(_ret).append(CR);").append(CR);
            sb.append("            ");
            sb.append("}").append(CR);
            sb.append("        ");
            sb.append("} finally {");
            sb.append(CR);
            for (int k = 1; k < count; ++k) {
                sb.append("            ");
                sb.append("lman.releaseLockObject(");
                sb.append("lo" + k);
                sb.append(");");
                sb.append(CR);
            }
            sb.append("        ");
            sb.append("}");
            sb.append(CR);
        }
        if (this.isTransactionSupport) {
            sb.append("        ");
            sb.append("if (errmsg.length() == 0) {").append(CR);
            sb.append("            ");
            sb.append("tx.commit();");
            sb.append(CR);
            sb.append("        ");
            sb.append("}").append(CR);
            sb.append("        ");
            sb.append("// " + rman.getValue("pbean.comment.closesession"));
            sb.append(CR);
            sb.append("        ");
            sb.append("hibernateSession.close();");
            sb.append(CR).append(CR);
        }
        sb.append("        ");
        sb.append("return errmsg.toString();").append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append(CommentGenerator.gComment(rman.getValue("pbean.comment.dopbean.transaction"), null, rman.getValue("pbean.comment.dopbean.reterrormsg")));
        sb.append("    ");
        sb.append("public String run1(");
        sb.append(sb2.toString());
        sb.append(", org.hibernate.Session session, boolean finalFlag) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("StringBuilder errmsg = new StringBuilder();");
        sb.append(CR);
        sb.append(CR);
    }

    protected List<Model> createTransactionList(Model model, Map<Transaction, Modelitem> transactionMap, StringBuilder sb) {
        ArrayList<Model> argList = new ArrayList<Model>();
        argList.add(model);
        if (!this.checkTransactionSupport()) {
            return argList;
        }
        Iterator<Map.Entry<Transaction, Modelitem>> it = transactionMap.entrySet().iterator();
        int pcount = 1;
        while (it.hasNext()) {
            Object[] o;
            Map.Entry<Transaction, Modelitem> entry = it.next();
            Transaction transaction = entry.getKey();
            Model rmodel = AppSchemaUtil.getModel(this.project, transaction.getContent());
            if (rmodel == null) {
                this.logger.error("No model is found, " + transaction.getContent());
                continue;
            }
            String targetmodelid = rmodel.getId();
            Modelitem mitem = entry.getValue();
            Relation rel = AppSchemaUtil.getRelation(mitem);
            IRNode node = rel.getIdrefAsIRNode();
            Model relmodel = null;
            if (node != null && node instanceof Model) {
                relmodel = (Model)node;
            }
            String roleid = AppSchemaUtil.getRoleid(rel, this.project);
            String[] roleids = null;
            String[] types = null;
            String[] pwtypes = null;
            String[] varnames = null;
            Modelitem[] rmitems = null;
            int pkeySize = 1;
            if (AppSchemaUtil.isCompositePrimaryKey(roleid)) {
                roleids = AppSchemaUtil.decompositePrimaryKey(roleid);
                pkeySize = roleids.length;
            } else {
                roleids = new String[]{roleid};
            }
            types = new String[pkeySize];
            pwtypes = new String[pkeySize];
            varnames = new String[pkeySize];
            rmitems = new Modelitem[pkeySize];
            for (int i = 0; i < pkeySize; ++i) {
                rmitems[i] = AppSchemaUtil.getModelitem(roleids[i], rmodel);
                if (rmitems[i] != null) {
                    types[i] = AppSchemaUtil.getModelitemType(this.project, relmodel.getId(), rmitems[i], "roleid");
                    pwtypes[i] = ProcessBeanGenerator_transactional.getB2wc_method(types[i]);
                    varnames[i] = "_" + rmitems[i].getName() + "_" + pcount;
                    continue;
                }
                o = new Object[]{model.getId(), mitem.getName(), transaction.toString(), rel.getIdref(), rmodel.getId(), roleid};
                this.logger.warn(rman.getValue("pbean.illegal.transaction.roleid", o));
            }
            Action _action = AppSchemaUtil.getActionByModelIdAndType(this.project, targetmodelid, "show");
            if (_action == null) {
                o = new Object[]{model.getId(), targetmodelid};
                this.logger.error(rman.getValue("pbean.illegal.transaction.action", o));
                continue;
            }
            String _pbean = AppSchemaUtil.createProcessBeanName(_action, this.project);
            String classname = AppSchemaUtil.getClassname(rmodel);
            sb.append("        ");
            if (pcount == 1) {
                sb.append("ProcessBean ");
            }
            sb.append("_pbean = ");
            sb.append(AppSchemaUtil.createNewProcessBeanInstanceCode(_pbean, null));
            sb.append(";");
            sb.append(CR);
            sb.append("        ");
            sb.append("_pbean.setActionParameter(p);");
            sb.append(CR);
            for (int i = 0; i < pkeySize; ++i) {
                if (rmitems[i] == null) continue;
                sb.append("        ");
                sb.append("_pbean.setParameter(\"");
                sb.append(rmitems[i].getName());
                sb.append("\", ");
                sb.append(pwtypes[i]);
                sb.append("(");
                sb.append(varnames[i]);
                sb.append("));");
                sb.append(CR);
            }
            sb.append("        ");
            sb.append("Object ");
            sb.append("o" + pcount);
            sb.append(" = null;");
            sb.append(CR);
            sb.append("        ");
            sb.append("try {");
            sb.append(CR);
            sb.append("            ");
            sb.append("o" + pcount);
            sb.append(" = _pbean.process();");
            sb.append(CR);
            sb.append("        ");
            sb.append("} finally {");
            sb.append(CR);
            sb.append("            ");
            sb.append("_pbean.release();");
            sb.append(CR);
            sb.append("        ");
            sb.append("}");
            sb.append(CR);
            sb.append("        ");
            sb.append(classname);
            sb.append(" ");
            sb.append("_" + rmodel.getId());
            sb.append(" = ");
            sb.append("(");
            sb.append("o" + pcount);
            sb.append(" != null && ");
            sb.append("o" + pcount);
            sb.append(" instanceof ");
            sb.append(classname);
            sb.append(") ? ");
            sb.append("(");
            sb.append(classname);
            sb.append(")");
            sb.append("o" + pcount);
            sb.append(" : null;");
            sb.append(CR);
            sb.append(CR);
            ++pcount;
            argList.add(rmodel);
        }
        sb.append("        ");
        sb.append("String _errmsg = do_transaction(");
        for (int i = 0; i < argList.size(); ++i) {
            Model rmodel = (Model)argList.get(i);
            String id = rmodel.getId();
            sb.append("_" + id);
            if (i >= argList.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(", session, p);");
        sb.append(CR);
        sb.append("        ");
        sb.append("if (_errmsg != null && _errmsg.length() > 0) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("return _errmsg;");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return argList;
    }
}

