/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.RelaxSchemaBaseGenerator;
import jp.jasminesoft.jfc.gen.appschema.Checkitem;
import jp.jasminesoft.jfc.gen.appschema.Checklist;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.jfc.gen.appschema.Validation;
import jp.jasminesoft.util.WebStringEncodeUtilities;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RelaxSchemaStoreGenerator
extends RelaxSchemaBaseGenerator {
    protected Logger logger = LogManager.getLogger((String)RelaxSchemaStoreGenerator.class.getName());

    public RelaxSchemaStoreGenerator(Project project, Model model) {
        super(project, model);
    }

    @Override
    protected String gRelaxSchemaMethod() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.gStartTopLevelElement(this.model));
        sb.append(this.gRelaxSchemaMethod0(this.model));
        return sb.toString();
    }

    protected String gStartTopLevelElement(Model model) {
        StringBuilder sb = new StringBuilder();
        String refname = model.getId();
        sb.append(this.rsman.gStartTopLevelElement(model, this.getRelaxerObjectExtendClassname()));
        this.registName(refname);
        return sb.toString();
    }

    protected String gRelaxSchemaMethod0(Model smodel) {
        Checklist checklist;
        StringBuilder sb = new StringBuilder();
        IModelChoice[] imc = this.model.getContent();
        IModelChoice[] simc = smodel.getContent();
        if (simc == null || simc.length == 0) {
            sb.append(this.rsman.gFinishTopLevelElement());
            return sb.toString();
        }
        StringBuilder sb0 = new StringBuilder();
        HashMap multiElementMap = new HashMap();
        Object pkey_name = null;
        PrimaryKey[] pkey = AppSchemaUtil.getPrimaryKey(smodel);
        if (pkey != null) {
            for (int i = 0; i < pkey.length; ++i) {
                String name = pkey[i].getName();
                Modelitem _mitem = AppSchemaUtil.getModelitem(name, smodel);
                if (_mitem == null) {
                    Object[] o = new Object[]{smodel.getId(), name};
                    this.logger.error(this.rman.getValue("value.null.pkey.modelitem", o));
                    continue;
                }
                if (_mitem.getHasChild()) {
                    this.logger.error(this.rman.getValue("relax.illegal.haschild.pkey", name));
                    continue;
                }
                if (_mitem.getMultiple()) {
                    this.logger.error(this.rman.getValue("relax.illegal.multiple.pkey", name));
                    continue;
                }
                if (name.indexOf("/") <= 0) continue;
                this.logger.error(this.rman.getValue("relax.illegal.in_haschild.pkey", name));
            }
        }
        Checkitem[] checkitems = null;
        Validation validation = AppSchemaUtil.getValidation(smodel);
        if (validation != null && (checklist = validation.getChecklist()) != null) {
            checkitems = checklist.getCheckitem();
        }
        for (int i = 0; i < imc.length; ++i) {
            if (!(imc[i] instanceof Modelitem)) continue;
            Modelitem item = (Modelitem)imc[i];
            this.gProcess_modelitem(item, pkey, checkitems, multiElementMap, imc, simc, sb, sb0);
        }
        sb.append(this.rsman.gFinishTopLevelElement());
        if (multiElementMap.size() > 0) {
            String pkeyref = null;
            boolean isOutputPrimaryKeyInContainer = this.isOutputPrimaryKeyInContainer(smodel);
            for (String modelitemname : multiElementMap.keySet()) {
                StringBuilder sbm = (StringBuilder)multiElementMap.get(modelitemname);
                String refname = this.getRefnameByModelitemName(modelitemname);
                String elemname = this.getElemnameByModelitemName(modelitemname);
                Modelitem mitem = AppSchemaUtil.getModelitem(modelitemname, this.model);
                String classname = AppSchemaUtil.getModelitemClassname(mitem);
                if (sbm.length() <= 0) continue;
                sb.append(this.rsman.gStartTopLevelElement(refname, elemname, classname, this.getRelaxerObjectExtendClassname(), "Container", this.model.getType()));
                if (isOutputPrimaryKeyInContainer) {
                    if (pkeyref == null) {
                        pkeyref = this.gPrimaryKeyRef(smodel);
                    }
                    sb.append(pkeyref);
                    sb.append(this.rsman.gReference(refname + "jshid", elemname + "jshid"));
                    sb0.append(this.createChildSchema(refname + "jshid", elemname + "jshid", null, "int", false, false, false, false, false, false, null, null, null, false, false));
                }
                sb.append(sbm.toString());
                sb.append(this.rsman.gFinishTopLevelElement());
            }
        }
        sb.append(sb0.toString());
        if (this.project.getDebug()) {
            sb.append(this.listSkippedElementName());
        }
        return sb.toString();
    }

    protected String gPrimaryKeyRef(Model smodel) {
        StringBuilder sb = new StringBuilder();
        IModelChoice[] imc = this.model.getContent();
        IModelChoice[] simc = smodel.getContent();
        if (simc == null || simc.length == 0) {
            sb.append(this.rsman.gFinishTopLevelElement());
            return sb.toString();
        }
        StringBuilder sb0 = new StringBuilder();
        HashMap multiElementMap = new HashMap();
        Object pkey_name = null;
        PrimaryKey[] pkey = AppSchemaUtil.getPrimaryKey(smodel);
        HashSet<String> primarykey_name_set = new HashSet<String>();
        for (int i = 0; i < pkey.length; ++i) {
            primarykey_name_set.add(pkey[i].getName());
        }
        Checkitem[] checkitems = null;
        for (int i = 0; i < imc.length; ++i) {
            Modelitem mitem;
            if (!(imc[i] instanceof Modelitem) || !primarykey_name_set.contains((mitem = (Modelitem)imc[i]).getName())) continue;
            this.gProcess_modelitem(mitem, pkey, checkitems, multiElementMap, imc, simc, sb, sb0);
        }
        return sb.toString();
    }

    protected void gProcess_modelitem(Modelitem item, PrimaryKey[] pkey, Checkitem[] checkitems, Map multiElementMap, IModelChoice[] imc, IModelChoice[] simc, StringBuilder sb, StringBuilder sb0) {
        boolean matchFlag = false;
        Modelitem sitem = null;
        if (!item.getUseRelax()) {
            return;
        }
        if (item.getGeneration()) {
            return;
        }
        if (item.getStandalone()) {
            matchFlag = true;
            sitem = item;
        } else if (simc != null) {
            String elemname = item.getName();
            for (int j = 0; j < simc.length; ++j) {
                if (!(simc[j] instanceof Modelitem) || !elemname.equals((sitem = (Modelitem)simc[j]).getName())) continue;
                matchFlag = true;
                break;
            }
        } else {
            matchFlag = true;
            sitem = item;
        }
        if (matchFlag) {
            sb.append(this.createSchema(item, sitem, pkey, checkitems, multiElementMap, sb0));
        } else {
            sb.append(this.createSchema(item, item, null, null, multiElementMap, sb0));
        }
    }

    protected String createSchema(Modelitem item, Modelitem sitem, PrimaryKey[] pkey, Checkitem[] checkitems, Map multiElementMap, StringBuilder sb0) {
        String type;
        boolean isFormula;
        StringBuilder sb = new StringBuilder();
        StringBuilder backsb = null;
        boolean isPrimarykeyFlag = false;
        boolean isMasterFlag = false;
        boolean isStorerefFlag = false;
        boolean isChildFlag = false;
        boolean isMustFlag = sitem.getMust();
        boolean isMultipleFlag = sitem.getMultiple() & this.getUseMultipleitem();
        boolean isHasChildFlag = sitem.getHasChild();
        boolean isAutodefaultFlag = sitem.getAutodefault();
        boolean isUniqueFlag = sitem.getUnique();
        boolean isZipcode = false;
        boolean isCheckBoxFlag = false;
        String defaultValue = sitem.getDefaultValue();
        String sqlDataType = "";
        Object option = "";
        boolean bl = isFormula = sitem.getTransient() && sitem.getFormula() != null;
        if (isFormula || !AppSchemaUtil.isStoreThismodel(sitem)) {
            option = "sql:transient=\"true\"";
        } else {
            String datatype;
            String columnName = sitem.getRdbcolumnname();
            if (columnName != null && columnName.length() > 0) {
                option = (String)option + "sql:columnName=\"" + WebStringEncodeUtilities.replaceCharEntity((String)columnName) + "\" ";
            }
            if ((datatype = sitem.getRdbdatatype()) != null && datatype.length() > 0) {
                option = (String)option + "sql:datatype=\"" + datatype + "\" ";
            }
        }
        String modelitemname = sitem.getName();
        isChildFlag = this.isChildElementByModelitemName(modelitemname);
        String refname = this.getRefnameByModelitemName(modelitemname);
        String elemname = this.getElemnameByModelitemName(modelitemname);
        String parentmodelitemname = this.getParentModelitemNameByModelitemName(modelitemname);
        String parentrefname = this.getParentRefnameByModelitemName(modelitemname);
        String parentelemname = this.getParentElemnameByModelitemName(modelitemname);
        String string = type = sitem.getType() == null ? "string" : sitem.getType();
        if ("boolean".equals(type)) {
            isMustFlag = true;
            sqlDataType = "varchar";
        } else if ("dateTime".equals(type)) {
            sqlDataType = "dateTime";
        }
        boolean outputContainerDecFlag = false;
        if (this.getUseChilditemContainer() && isChildFlag && !isMultipleFlag && !isHasChildFlag && !multiElementMap.containsKey(parentmodelitemname)) {
            isMultipleFlag = true;
            outputContainerDecFlag = true;
        }
        isMultipleFlag = this.setUnderCondition("multiple", sitem, isMultipleFlag);
        StringBuilder sbm = null;
        Relation relation = null;
        if ("storeref".equals(type)) {
            Modelitem _mitem = AppSchemaUtil.getRelatedModelitemInCaseofTypeRef(this.project, this.model.getId(), sitem);
            type = _mitem != null ? _mitem.getType() : null;
            relation = AppSchemaUtil.getRelationTypeExceptRef(_mitem);
        } else if ("masterref".equals(type)) {
            relation = AppSchemaUtil.getRelationTypeExceptRef(sitem);
        }
        if (relation != null && "check".equals(relation.getType())) {
            isCheckBoxFlag = true;
        }
        if (this.isPrimaryKeyByModelitemName(modelitemname, pkey)) {
            isMustFlag = true;
            isPrimarykeyFlag = true;
        }
        if (isPrimarykeyFlag) {
            isMultipleFlag = false;
        }
        String classname = null;
        if (isMultipleFlag) {
            classname = AppSchemaUtil.getModelitemClassname(sitem);
            sbm = new StringBuilder();
            if (isChildFlag) {
                multiElementMap.put(parentmodelitemname, sbm);
                sb.append(this.rsman.gZeroOrMoreReference(parentrefname, parentelemname, "child node"));
                if (outputContainerDecFlag) {
                    if (isCheckBoxFlag) {
                        sbm.append(this.rsman.gZeroOrMoreReference(refname, elemname, "child node"));
                    } else if (!isMustFlag) {
                        sbm.append(this.rsman.gOptionalReference(refname, elemname));
                    } else {
                        sbm.append(this.rsman.gReference(refname, elemname));
                    }
                }
            } else {
                multiElementMap.put(modelitemname, sbm);
                sb.append(this.rsman.gZeroOrMoreReference(refname, elemname, "child node"));
            }
        } else if (isCheckBoxFlag) {
            classname = AppSchemaUtil.getModelitemClassname(sitem);
            if (isChildFlag) {
                sbm = (StringBuilder)multiElementMap.get(parentmodelitemname);
                if (sbm == null) {
                    sbm = new StringBuilder();
                    multiElementMap.put(parentmodelitemname, sbm);
                }
                sb = sbm;
            } else {
                sbm = (StringBuilder)multiElementMap.get(modelitemname);
                if (sbm == null) {
                    sbm = new StringBuilder();
                    multiElementMap.put(modelitemname, sbm);
                }
            }
            sb.append(this.rsman.gZeroOrMoreReference(refname, elemname, "child node"));
        } else if (isChildFlag && (sbm = (StringBuilder)multiElementMap.get(parentmodelitemname)) != null) {
            backsb = sb = sbm;
        }
        if (isCheckBoxFlag) {
            isMasterFlag = true;
            isMultipleFlag = true;
            isMustFlag = false;
            defaultValue = null;
            sqlDataType = "varchar";
        }
        if ("masterref".equals(type) && !isCheckBoxFlag) {
            isMustFlag = false;
            isMasterFlag = true;
            type = "int";
        }
        if ("storeref".equals(type)) {
            isMustFlag = false;
            isMasterFlag = false;
            isStorerefFlag = true;
            Relation _relation = AppSchemaUtil.getRelationTypeExceptRef(sitem);
            if (_relation == null) {
                _relation = AppSchemaUtil.getRelationTypeIsRef(sitem);
            }
            type = AppSchemaUtil.getRelationRefType(this.model.getId(), sitem.getName(), _relation, this.project);
        }
        if ("zipcode".equals(type)) {
            type = "string";
            isZipcode = true;
            sqlDataType = "varchar";
        }
        if ("masterref".equals(type)) {
            type = "int";
        }
        if (checkitems != null) {
            for (int j = 0; j < checkitems.length; ++j) {
                Checkitem checkitem = checkitems[j];
                if (!elemname.equals(checkitem.getName()) || !"EQ".equals(checkitem.getCond()) || !"null".equals(checkitem.getValue())) continue;
                isMustFlag = true;
                break;
            }
        }
        if ("storeref".equals(type) || "masterref".equals(type)) {
            Object[] o = new Object[]{this.model.getId(), modelitemname};
            this.logger.warn(this.rman.getValue("relax.comment.invalidtype", o));
            type = "string";
        }
        if (isMustFlag && !AppSchemaUtil.isStoreThismodel(sitem)) {
            isMustFlag = false;
        }
        if (!isMultipleFlag && !isHasChildFlag) {
            if (!isMustFlag) {
                sb.append(this.rsman.gOptionalReference(refname, elemname));
            } else {
                sb.append(this.rsman.gReference(refname, elemname));
            }
        }
        if (this.getUseChilditemContainer() && isMultipleFlag && outputContainerDecFlag && backsb != null) {
            if (!isMustFlag) {
                backsb.append(this.rsman.gOptionalReference(refname, elemname));
            } else {
                backsb.append(this.rsman.gReference(refname, elemname));
            }
        }
        boolean isDimension = this.checkDimension(item.getName());
        boolean isMajor = this.checkMajor(item.getName());
        if (!isHasChildFlag) {
            sb0.append(this.createChildSchema(refname, elemname, classname, type, isPrimarykeyFlag, isMasterFlag, isStorerefFlag, isAutodefaultFlag, isMultipleFlag, isUniqueFlag, defaultValue, sqlDataType, (String)option, isDimension, isMajor));
        }
        if (this.getUseChilditemContainer()) {
            if (!isChildFlag || outputContainerDecFlag) {
                return sb.toString();
            }
            return "";
        }
        return sb.toString();
    }

    protected boolean getUseMultipleitem() {
        return true;
    }

    protected boolean getUseChilditemContainer() {
        return true;
    }

    protected boolean checkDimension(String name) {
        return false;
    }

    protected boolean checkMajor(String name) {
        return false;
    }

    protected String createChildSchema(String refname, String elemname, String classname, String type, boolean isPrimarykeyFlag, boolean isMasterFlag, boolean isStorerefFlag, boolean isAutodefaultFlag, boolean isMultipleFlag, boolean isUniqueFlag, String defaultValue, String sqlDataType, String option, boolean isDimension, boolean isMajor) {
        return this.createChildSchema(refname, elemname, classname, type, isPrimarykeyFlag, isMasterFlag, isStorerefFlag, isAutodefaultFlag, isMultipleFlag, isUniqueFlag, defaultValue, sqlDataType, option);
    }

    protected String createChildSchema(String refname, String elemname, String classname, String type, boolean isPrimarykeyFlag, boolean isMasterFlag, boolean isStorerefFlag, boolean isAutodefaultFlag, boolean isMultipleFlag, boolean isUniqueFlag, String defaultValue, String sqlDataType, String option) {
        StringBuilder sb = new StringBuilder();
        if (this.isUsedName(refname)) {
            return sb.toString();
        }
        sb.append(this.rsman.gStoreElement("  ", refname, elemname, classname, type, defaultValue, isMasterFlag, isPrimarykeyFlag, isUniqueFlag, isAutodefaultFlag, isMultipleFlag, this.gSqlDataType(sqlDataType), option));
        return sb.toString();
    }

    protected boolean isOutputPrimaryKeyInContainer(Model smodel) {
        String storage = smodel.getStorage();
        int storagetype = AppSchemaUtil.getStorageType(storage);
        return storagetype == 5;
    }

    protected String getRelaxerObjectExtendClassname() {
        return "jp.jasminesoft.jfc.model.ContainerBase";
    }
}

