/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.SubpackageUtil;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.StringUtil;

public abstract class RelaxerWrapperBaseGenerator
extends JavaSourceGenerator {
    public static final String SUB_PACKAGE_NAME = "app";
    protected Model model;

    public RelaxerWrapperBaseGenerator(Project project, Model model) {
        super(project);
        this.model = model;
    }

    @Override
    public String process0() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.gHeader());
        sb.append(this.gClassDeclaration());
        sb.append(this.gBegin());
        sb.append(this.gVariableDefinition());
        sb.append(this.gConstructor());
        sb.append(this.gBody());
        sb.append(this.gEnd());
        return sb.toString();
    }

    public String gClassDeclaration() {
        StringBuilder sb = new StringBuilder();
        sb.append("public class ");
        sb.append(this.getClassname());
        sb.append(this.getClassDeclarationSuffix());
        sb.append(CR);
        return sb.toString();
    }

    public String getClassExplanation() {
        return this.getClassname();
    }

    @Override
    public abstract String getClassname();

    @Override
    public String getSubpackageName() {
        return SubpackageUtil.createPackageNameDir(SUB_PACKAGE_NAME, this.model);
    }

    @Override
    public String getSubpackageNameAsJavaRule() {
        return SubpackageUtil.createPackageName(SUB_PACKAGE_NAME, this.model);
    }

    public String getClassDeclarationSuffix() {
        return "";
    }

    protected String gHeader() {
        String[] ary;
        StringBuilder sb = new StringBuilder();
        boolean useCVSFlag = this.project.getUseCVS();
        if (useCVSFlag) {
            sb.append("/*");
            sb.append(CR);
            sb.append(" * $Id:$");
            sb.append(CR);
            sb.append(" */");
            sb.append(CR);
            sb.append("");
            sb.append(CR);
        }
        if (this.project.getPackage() != null) {
            sb.append("package ");
            sb.append(this.project.getPackage());
            sb.append(".");
            sb.append(this.getSubpackageNameAsJavaRule());
            sb.append(";");
            sb.append(CR);
            sb.append("");
            sb.append(CR);
        }
        if ((ary = this.getDefaultImport()) != null) {
            for (int i = 0; i < ary.length; ++i) {
                sb.append("import ");
                sb.append(ary[i]);
                sb.append(";");
                sb.append(CR);
            }
        }
        sb.append("");
        sb.append(CR);
        sb.append("/**");
        sb.append(CR);
        sb.append(" * " + AppSchemaUtil.getTitle(this.project));
        sb.append(CR);
        String[] comment_str = StringUtil.separateLine((String)this.getClassExplanation(), (int)72);
        if (comment_str != null) {
            for (int i = 0; i < comment_str.length; ++i) {
                sb.append(" * ");
                sb.append(comment_str[i]);
                sb.append(CR);
            }
        }
        sb.append(" *");
        sb.append(CR);
        if (useCVSFlag) {
            sb.append(" * @version $Revision:$ ");
            sb.append("$Date:$");
            sb.append(CR);
        }
        sb.append(" * @author " + this.project.getAuthor());
        sb.append(CR);
        sb.append(" */");
        sb.append(CR);
        sb.append("");
        sb.append(CR);
        return sb.toString();
    }

    protected abstract String gVariableDefinition();

    protected abstract String gConstructor();

    protected abstract String gBody();
}

