/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.HashMap;
import jp.jasminesoft.jfc.core.util.SystemUtils;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.appschema.Environment;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.JavaVersion;
import jp.jasminesoft.util.StringUtil;
import jp.jasminesoft.util.VelocityUtils;
import org.apache.commons.lang3.StringUtils;

public class ScriptUtils {
    private static final String Rhino = "rhino";
    private static final String Nashorn = "nashorn";
    private static final String Default = "nashorn";
    private static final String CR = System.getProperty("line.separator");

    public static String chooseScriptEngine(Project project) {
        Environment env = project.getEnvironment();
        return ScriptUtils.chooseScriptEngine(AppSchemaUtil.getJavaVersion(env));
    }

    public static String chooseScriptEngine(String javaversion) {
        return ScriptUtils.chooseScriptEngine(SystemUtils.getJavaVersion((String)javaversion));
    }

    public static String chooseScriptEngine(JavaVersion javaversion) {
        if (javaversion == null) {
            return "nashorn";
        }
        if (javaversion.atLeast(JavaVersion.JAVA_1_8)) {
            return "nashorn";
        }
        return "nashorn";
    }

    public static String createProperScript(String scriptEngine, String code) {
        return ScriptUtils.createProperScript(scriptEngine, code, true);
    }

    public static String createProperScript(String scriptEngine, String code, boolean isComplementProcessFunc) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return "";
        }
        boolean isDeclaredProcessFunction = true;
        if (isComplementProcessFunc) {
            isDeclaredProcessFunction = ScriptUtils.isDeclaredProcessFunction(code);
        }
        boolean isAutoCamelNotation = true;
        String tmp = ScriptUtils.removePreSpace(code);
        if (tmp.length() >= 2 && tmp.charAt(0) == '/' && tmp.charAt(1) == '*') {
            tmp = tmp.substring(2);
            if ((tmp = ScriptUtils.removePreSpace(tmp)).startsWith("CAMELCASE")) {
                int ptr;
                tmp = tmp.substring("CAMELCASE".length());
                if ((tmp = ScriptUtils.removePreSpace(tmp)).charAt(0) == '=') {
                    tmp = tmp.substring(1);
                    if ((tmp = ScriptUtils.removePreSpace(tmp)).startsWith("false")) {
                        isAutoCamelNotation = false;
                    }
                }
                if ((ptr = tmp.indexOf("*/")) >= 0) {
                    code = tmp.substring(ptr + 2);
                }
            }
        }
        if (isAutoCamelNotation) {
            int length = code.length();
            StringBuilder sb = new StringBuilder();
            StringBuilder var = null;
            boolean varMode = false;
            boolean isQuote = false;
            for (int i = 0; i < length; ++i) {
                char c = code.charAt(i);
                if (c == '\"') {
                    boolean bl = isQuote = !isQuote;
                }
                if (c == '$' && !isQuote) {
                    if (i + 1 < length) {
                        if (code.charAt(i + 1) == '{') {
                            varMode = true;
                            ++i;
                            continue;
                        }
                        sb.append(c);
                        continue;
                    }
                    sb.append(c);
                    continue;
                }
                if (c == '}' && !isQuote && varMode && var != null) {
                    Object camelExpr;
                    String itemname = var.toString();
                    int ptr = itemname.indexOf(".");
                    if (ptr > 0) {
                        sb.append(itemname.substring(0, ptr)).append(".");
                        itemname = itemname.substring(ptr + 1);
                    }
                    if (((String)(camelExpr = StringUtil.convClassname4Relax((String)itemname))).length() >= 1 && Character.isLowerCase(((String)camelExpr).charAt(0)) && Character.isUpperCase(((String)camelExpr).charAt(1))) {
                        camelExpr = Character.toUpperCase(((String)camelExpr).charAt(0)) + ((String)camelExpr).substring(1);
                    }
                    sb.append((String)camelExpr);
                    varMode = false;
                    var = null;
                    continue;
                }
                if (varMode) {
                    if (var == null) {
                        var = new StringBuilder();
                    }
                    var.append(c);
                    continue;
                }
                sb.append(c);
            }
            code = sb.toString();
        }
        if (StringUtils.isBlank((CharSequence)code)) {
            return "";
        }
        if (!isDeclaredProcessFunction) {
            StringBuilder sb = new StringBuilder();
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("code", code);
            String template = null;
            template = "nashorn".equalsIgnoreCase(scriptEngine) ? "template/javascriptsrc/base_nashorn.vm" : "template/javascriptsrc/base_rhino.vm";
            sb.append(VelocityUtils.mergeContent((String)template, m));
            sb.append(CR);
            code = sb.toString();
        }
        return code;
    }

    protected static boolean isDeclaredProcessFunction(String code) {
        boolean isDeclaredProcessFunction = false;
        int ptr1 = code.indexOf("function ");
        if (ptr1 >= 0) {
            String tmp = code.substring(ptr1 + "function ".length());
            int ptr2 = (tmp = ScriptUtils.removePreSpace(tmp)).indexOf("process");
            if (ptr2 == 0) {
                tmp = tmp.substring(ptr2 + "process".length());
                int ptr3 = (tmp = ScriptUtils.removePreSpace(tmp)).indexOf("(");
                if (ptr3 == 0) {
                    tmp = tmp.substring(ptr3 + "(".length());
                    int ptr4 = (tmp = ScriptUtils.removePreSpace(tmp)).indexOf(")");
                    if (ptr4 == 0) {
                        tmp = tmp.substring(ptr4 + ")".length());
                        int ptr5 = (tmp = ScriptUtils.removePreSpace(tmp)).indexOf("{");
                        if (ptr5 == 0) {
                            isDeclaredProcessFunction = true;
                        }
                    }
                }
            }
        }
        return isDeclaredProcessFunction;
    }

    private static String removePreSpace(String s) {
        int i;
        if (s.charAt(0) != ' ') {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        int len = s.length();
        for (i = 0; i < len && s.charAt(i) == ' '; ++i) {
        }
        sb.append(s.substring(i));
        return sb.toString();
    }

    public static void main(String[] args) {
        String s = " function  process  ( )  {var s=${customer.p_price}; ; println(\"Hello from JavaScript.\");}";
        System.out.println(ScriptUtils.createProperScript("nashorn", s));
    }
}

