/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.File;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.ConfigGenerator;
import jp.jasminesoft.jfc.gen.ServerXmlGenerator;
import jp.jasminesoft.jfc.gen.appschema.Database;
import jp.jasminesoft.jfc.gen.appschema.Environment;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.FileTemplateManager;
import jp.jasminesoft.util.WebStringEncodeUtilities;
import org.apache.commons.lang3.StringUtils;

public class ServerXmlConfGenerator
extends ConfigGenerator {
    public ServerXmlConfGenerator(String tmplatefilename, Project project) {
        super(tmplatefilename, project);
    }

    @Override
    public String getFileSuffix() {
        return ".xml";
    }

    @Override
    public String getFilename() {
        return "context";
    }

    @Override
    public String getSubpackageName() {
        return "webpage" + File.separator + "META-INF" + File.separator;
    }

    @Override
    public String process0() {
        FileTemplateManager tplman = new FileTemplateManager(this.tmplatefilename);
        if (!tplman.isValid()) {
            return "";
        }
        ServerXmlGenerator.addContent(this.project, tplman);
        Environment env = this.project.getEnvironment();
        if (env != null) {
            tplman.addContent("logger_comment_begin", "<!-- ");
            tplman.addContent("logger_comment_end", "-->");
        }
        tplman.addContent("subresources", this.subdatabase(env));
        return tplman.getResult();
    }

    protected String subdatabase(Environment env) {
        StringBuilder sb = new StringBuilder();
        int i = 1;
        for (Database subdatabase : AppSchemaUtil.getSubdatabases(env)) {
            String placeholderheader = "WAGBY_DATASOURCE_SUBDATABASE" + i++;
            sb.append(this.subdatabase(subdatabase, placeholderheader));
        }
        return sb.toString();
    }

    protected String subdatabase(Database subdatabase, String placeholderheader) {
        String validationQuery;
        StringBuilder sb = new StringBuilder().append(CR);
        sb.append("  ").append("<Resource name=\"").append(subdatabase.getName()).append("\" auth=\"Container\"").append(CR);
        sb.append("            ").append("type=\"javax.sql.DataSource\"").append(CR);
        sb.append("            ").append("driverClassName=\"${").append(placeholderheader).append("_DRIVERCLASSNAME}").append("\"").append(CR);
        sb.append("            ").append("url=\"${").append(placeholderheader).append("_URL}").append("\"").append(CR);
        sb.append("            ").append("username=\"${").append(placeholderheader).append("_USERNAME}").append("\"").append(CR);
        sb.append("            ").append("password=\"${").append(placeholderheader).append("_PASSWORD}").append("\"").append(CR);
        sb.append("            ").append("maxTotal=\"${").append(placeholderheader).append("_MAXTOTAL}").append("\"").append(CR);
        sb.append("            ").append("maxIdle=\"${").append(placeholderheader).append("_MAXIDLE}").append("\"").append(CR);
        sb.append("            ").append("maxWaitMillis=\"${").append(placeholderheader).append("_MAXWAITMILLIS}").append("\"").append(CR);
        sb.append("            ").append("defaultAutoCommit=\"false\"");
        String connectionInitSqls = subdatabase.getConnectionInitSqls();
        if (StringUtils.isNotBlank((CharSequence)connectionInitSqls)) {
            sb.append(CR).append("            ").append("connectionInitSqls=\"").append(WebStringEncodeUtilities.replaceCharEntity((String)connectionInitSqls)).append("\"").append(CR);
        }
        if (StringUtils.isNotBlank((CharSequence)(validationQuery = ServerXmlGenerator.createValidationQuery(subdatabase)))) {
            sb.append(CR).append("            ").append(validationQuery).append(CR);
        }
        sb.append("/>").append(CR);
        return sb.toString();
    }
}

