/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.ApplicationContextBean;
import jp.jasminesoft.jfc.gen.ApplicationContextBeanByName;
import jp.jasminesoft.jfc.gen.IGeneratorFactory;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.ServiceLayerGenerator;
import jp.jasminesoft.jfc.gen.SpringApplicationContextContainer;
import jp.jasminesoft.jfc.gen.SubpackageUtil;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Import;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.ResourceManagerFactory;
import jp.jasminesoft.util.StringUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ServiceLayerCoreGenerator
extends JavaSourceGenerator
implements IGeneratorFactory {
    public static final String SUB_PACKAGE_NAME = "app";
    protected static Logger logger = LogManager.getLogger((String)ServiceLayerCoreGenerator.class.getName());
    protected static ResourceManager rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
    protected Action action;
    private String id;
    protected ServiceLayerGenerator slgen;
    private Map<String, Object> methodNameMap;

    public ServiceLayerCoreGenerator(Action action, Project project, ServiceLayerGenerator slgen) {
        super(project);
        this.action = action;
        this.id = action.getIdref();
        this.slgen = slgen;
        this.methodNameMap = new HashMap<String, Object>();
    }

    public String getId() {
        return this.id;
    }

    public boolean hasMethod(String mname) {
        return this.methodNameMap.containsKey(mname);
    }

    public Action getActionByMethod(String mname) {
        return (Action)this.methodNameMap.get(mname);
    }

    public Model getModelByMethod(String mname) {
        return (Model)this.methodNameMap.get(mname);
    }

    @Override
    public String getSubpackageName() {
        return SubpackageUtil.createPackageNameDir(SUB_PACKAGE_NAME, this.getStoreModel());
    }

    @Override
    public String getSubpackageNameAsJavaRule() {
        return SubpackageUtil.createPackageName(SUB_PACKAGE_NAME, this.getStoreModel());
    }

    protected Model getStoreModel() {
        return AppSchemaUtil.getModel(this.project, this.id);
    }

    @Override
    public String[] getDefaultImport() {
        ArrayList<String> importList = new ArrayList<String>();
        importList.add("java.util.*");
        importList.add("java.text.*");
        importList.add("org.apache.logging.log4j.Logger");
        importList.add("org.apache.logging.log4j.LogManager");
        importList.add("org.apache.commons.lang3.StringUtils");
        importList.add("jp.jasminesoft.jfc.controller.BaseController");
        importList.add("jp.jasminesoft.jfc.JFCUtils");
        importList.add("jp.jasminesoft.jfc.ActionParameter");
        importList.add("jp.jasminesoft.jfc.ActionParameter");
        importList.add("jp.jasminesoft.jfc.ResultBean");
        if (this.hasMethod("setJcalendarItem")) {
            importList.add("jp.jasminesoft.jfc.model.jcalendar_l.Item");
            importList.add(AppSchemaUtil.getMyExcelFunctionStaticImport(this.project));
        }
        if (this.hasMethod("findAll")) {
            importList.add("jp.jasminesoft.jfc.dao.DataBindingContext");
        }
        if (this.hasMethod("getCalendarviewFinderContext")) {
            importList.add("jp.jasminesoft.jfc.dao.FinderContext");
        }
        if (this.hasMethod("getEntityService") || this.hasMethod("setEntityService")) {
            importList.add("jp.jasminesoft.jfc.service.JFCEntityService");
            importList.add("java.io.Serializable");
        }
        importList.add("jp.jasminesoft.util.*");
        this.setImportStatement_condition(this.action, importList);
        Model pmodel = AppSchemaUtil.getModel(this.project, this.action.getIdref(), "presentation");
        if (pmodel != null) {
            ServiceLayerCoreGenerator.setImportStatement(pmodel, this.project, importList);
        }
        this.setImportStatement_dataitem_with_refmodel(this.action, importList);
        return importList.toArray(new String[0]);
    }

    public abstract String gClassDeclaration();

    @Override
    public String process0() {
        this.initMethodNameMap();
        if (this.methodNameMap.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.gHeader());
        sb.append(this.gClassDeclaration());
        sb.append(this.gBegin());
        sb.append(this.gVariable());
        sb.append(this.gContent());
        sb.append(this.gEnd());
        return sb.toString();
    }

    private void initMethodNameMap() {
        String[] action_id_ary = this.slgen.getActionId();
        for (int i = 0; i < action_id_ary.length; ++i) {
            String action_id = action_id_ary[i];
            Action action = AppSchemaUtil.getAction(this.project, action_id);
            if (!action.getType().equals("showList") || !"calendar".equals(action.getView())) continue;
            this.methodNameMap.put("findAll", action);
            this.methodNameMap.put("setJcalendarItem", action);
            this.methodNameMap.put("getCalendarviewFinderContext", action);
            this.methodNameMap.put("setEntityService", action);
            this.methodNameMap.put("getEntityService", action);
        }
    }

    protected String gHeader() {
        Model model;
        String _package;
        StringBuilder sb = new StringBuilder();
        boolean useCVSFlag = this.project.getUseCVS();
        if (useCVSFlag) {
            sb.append("/*");
            sb.append(CR);
            sb.append(" * $Id:$");
            sb.append(CR);
            sb.append(" */");
            sb.append(CR);
            sb.append("");
            sb.append(CR);
        }
        if ((_package = this.getPackage()) != null) {
            sb.append("package ");
            sb.append(_package);
            sb.append(";");
            sb.append(CR);
            sb.append("");
            sb.append(CR);
        }
        ArrayList<Object> importList = new ArrayList<Object>();
        String[] ary = this.getDefaultImport();
        if (ary != null) {
            for (int i = 0; i < ary.length; ++i) {
                if (importList.contains(ary[i])) continue;
                importList.add(ary[i]);
            }
        }
        if ((model = this.getStoreModel()) != null) {
            IModelChoice[] imc;
            Object s = AppSchemaUtil.getPackagename(model, this.project);
            if (s != null && ((String)s).length() > 0 && !importList.contains(s = (String)s + "*")) {
                importList.add(s);
            }
            if ((imc = model.getContent()) != null) {
                for (int i = 0; i < imc.length; ++i) {
                    Import _import;
                    if (!(imc[i] instanceof Import) || importList.contains(s = (_import = (Import)imc[i]).getContent())) continue;
                    importList.add(s);
                }
            }
        }
        for (int i = 0; i < importList.size(); ++i) {
            String stmt = (String)importList.get(i);
            sb.append("import ");
            sb.append(stmt);
            sb.append(";");
            sb.append(CR);
        }
        sb.append("import ");
        if (this.project.getPackage() != null) {
            sb.append(this.project.getPackage());
            sb.append(".");
        }
        sb.append(SUB_PACKAGE_NAME);
        sb.append(".*");
        sb.append(";");
        sb.append(CR);
        sb.append("");
        sb.append(CR);
        sb.append("/**");
        sb.append(CR);
        sb.append(" * " + AppSchemaUtil.getTitle(this.project));
        sb.append(CR);
        String[] comment_str = StringUtil.separateLine((String)this.getClassExplanation(), (int)72);
        if (comment_str != null) {
            for (int i = 0; i < comment_str.length; ++i) {
                sb.append(" * ");
                sb.append(comment_str[i]);
                sb.append(CR);
            }
        }
        sb.append(" *");
        sb.append(CR);
        if (useCVSFlag) {
            sb.append(" * @version $Revision:$ ");
            sb.append("$Date:$");
            sb.append(CR);
        }
        sb.append(" * @author " + this.project.getAuthor());
        sb.append(CR);
        sb.append(" */");
        sb.append(CR);
        sb.append("");
        sb.append(CR);
        return sb.toString();
    }

    public String getClassExplanation() {
        return this.getClassname();
    }

    @Override
    public String getClassname() {
        StringBuilder sb = new StringBuilder();
        sb.append(ServiceLayerCoreGenerator.capFirst(this.getId()));
        sb.append("ServiceImpl");
        return sb.toString();
    }

    public String getInterfacename() {
        StringBuilder sb = new StringBuilder();
        sb.append(ServiceLayerCoreGenerator.capFirst(this.getId()));
        sb.append("Service");
        return sb.toString();
    }

    protected abstract String gVariable();

    protected String gContent() {
        Action action;
        if (this.slgen.getSizeOfAction() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (this.methodNameMap.keySet().contains("getCalendarviewFinderContext")) {
            sb.append(this.gMethod_getCalendarviewFinderContext());
            sb.append(CR);
        }
        if (this.methodNameMap.keySet().contains("setEntityService")) {
            sb.append(this.gMethod_setEntityService());
            sb.append(CR);
        }
        if (this.methodNameMap.keySet().contains("getEntityService")) {
            sb.append(this.gMethod_getEntityService());
            sb.append(CR);
        }
        if (this.methodNameMap.keySet().contains("findAll")) {
            action = this.getActionByMethod("findAll");
            sb.append(this.gMethod_findAll(action));
            sb.append(CR);
            sb.append(this.gMethod_find(action));
            sb.append(CR);
            sb.append(this.gMethod_getDataBindingContext(action));
            sb.append(CR);
        }
        if (this.methodNameMap.keySet().contains("setJcalendarItem")) {
            action = this.getActionByMethod("setJcalendarItem");
            Model model = null;
            IRNode node = action.getIdrefAsIRNode();
            if (node != null && node instanceof Model) {
                model = (Model)node;
            }
            sb.append(this.gMethod_createDateMap(model, action));
            sb.append(CR);
            sb.append(this.gMethod_setJcalendarItem(model, action));
            sb.append(CR);
            sb.append(this.gMethod_setIcalendarItem(model, action));
            sb.append(CR);
            sb.append(this.gMethod_setEntityPForCalendaritem(model, action));
            sb.append(CR);
        }
        String serviceName = this.getId() + "Service";
        ApplicationContextBeanByName _bean = new ApplicationContextBeanByName(serviceName, this.project.getPackage() + "." + this.getSubpackageNameAsJavaRule() + "." + this.getClassname() + "Impl", null, true);
        if (this.hasMethod("getCalendarviewFinderContext")) {
            String classname = "CalendarView" + ServiceLayerCoreGenerator.capFirst(this.getId()) + "FinderContext";
            _bean.addLookupMethod("getCalendarviewFinderContext", classname);
        }
        if (this.hasMethod("setEntityService")) {
            String entityServiceId = ServiceLayerCoreGenerator.capFirst(this.getId()) + "EntityService";
            _bean.addProperty("entityService", new ApplicationContextBean.ReferenceElement(entityServiceId));
        }
        if (!SpringApplicationContextContainer.isExistApplicationContextBean(_bean) && _bean.sizeLookupMethod() > 0) {
            SpringApplicationContextContainer.addApplicationContextBean(_bean);
        }
        return sb.toString();
    }

    protected abstract String gMethod_setEntityService();

    protected abstract String gMethod_getEntityService();

    protected abstract String gMethod_getCalendarviewFinderContext();

    protected abstract String gMethod_findAll(Action var1);

    protected abstract String gMethod_find(Action var1);

    protected abstract String gMethod_getDataBindingContext(Action var1);

    protected abstract String gMethod_setJcalendarItem(Model var1, Action var2);

    protected abstract String gMethod_setIcalendarItem(Model var1, Action var2);

    protected abstract String gMethod_setEntityPForCalendaritem(Model var1, Action var2);

    protected abstract String gMethod_createDateMap(Model var1, Action var2);

    protected String gMethod_findAll_declare(Action action) {
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("public ");
        sb.append("Object[] ");
        sb.append("findAll(");
        sb.append("ActionParameter p)");
        return sb.toString();
    }

    protected String gMethod_find_declare(Action action) {
        Model smodel = AppSchemaUtil.getModel(this.project, action.getIdref());
        String sclassname = AppSchemaUtil.getClassname(smodel);
        Model cmodel = AppSchemaUtil.getConditionModel(this.project, action);
        String cclassname = AppSchemaUtil.getClassname(cmodel);
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("public List<");
        sb.append(sclassname);
        sb.append("> ");
        sb.append("find(FinderContext<");
        sb.append(cclassname);
        sb.append("> finderContext, ActionParameter p)");
        return sb.toString();
    }

    protected String gMethod_getDataBindingContext_declare(Action action) {
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("public DataBindingContext getDataBindingContext(ActionParameter p)");
        return sb.toString();
    }

    protected String gMethod_setJcalendarItem_declare(Action action) {
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("public void ");
        sb.append("setJcalendarItem(");
        sb.append(CR);
        sb.append("        ");
        sb.append("int month,");
        sb.append(CR);
        sb.append("        ");
        sb.append("int day,");
        sb.append(CR);
        sb.append("        ");
        sb.append("Object[] data,");
        sb.append(CR);
        sb.append("        ");
        sb.append("List list,");
        sb.append(CR);
        sb.append("        ");
        sb.append("ActionParameter p)");
        return sb.toString();
    }

    protected String gMethod_setIcalendarItem_declare(Action action) {
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("public void ");
        sb.append("setIcalendarItem(");
        sb.append(CR);
        sb.append("        ");
        sb.append("int year,");
        sb.append(CR);
        sb.append("        ");
        sb.append("int month,");
        sb.append(CR);
        sb.append("        ");
        sb.append("int day,");
        sb.append(CR);
        sb.append("        ");
        sb.append("Object[] data,");
        sb.append(CR);
        sb.append("        ");
        sb.append("List list,");
        sb.append(CR);
        sb.append("        ");
        sb.append("ActionParameter p)");
        return sb.toString();
    }

    protected String gMethod_setEntityPForCalendaritem_declare(Action action) {
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("public Object ");
        sb.append("setEntityPForCalendaritem(Object data, Map<String, Object> map)");
        return sb.toString();
    }

    protected String gMethod_createDateMap_declare(Action action) {
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("public void createDateMap(Object[] data, Map map)");
        return sb.toString();
    }

    protected String gMethod_getCalendarviewFinderContext_declare() {
        Model cmodel = AppSchemaUtil.getConditionModel(this.project, this.action);
        String cclassname = AppSchemaUtil.getClassname(cmodel);
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("public FinderContext<" + cclassname + "> getCalendarviewFinderContext()");
        return sb.toString();
    }

    protected String gMethod_setEntityService_declare() {
        Model smodel = AppSchemaUtil.getModel(this.project, this.action.getIdref());
        String sclassname = AppSchemaUtil.getClassname(smodel);
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("public void setEntityService(JFCEntityService<");
        sb.append(sclassname);
        sb.append(", Serializable> entityService)");
        return sb.toString();
    }

    protected String gMethod_getEntityService_declare() {
        Model smodel = AppSchemaUtil.getModel(this.project, this.action.getIdref());
        String sclassname = AppSchemaUtil.getClassname(smodel);
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("public JFCEntityService<");
        sb.append(sclassname);
        sb.append(", Serializable> getEntityService()");
        return sb.toString();
    }
}

