/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.File;
import java.util.Map;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.WebXmlUtils;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.VelocityUtils;

public class SpringBootApplicationPropertiesGenerator
extends SourceGenerator {
    public static final String ENCODE = "UTF8";
    private boolean isFullBuild;

    public SpringBootApplicationPropertiesGenerator(Project project, boolean isFullBuild) {
        super(project);
        this.isFullBuild = isFullBuild;
    }

    @Override
    public String getEncoding() {
        return ENCODE;
    }

    @Override
    public String getFileSuffix() {
        return ".properties." + this.getEncoding();
    }

    public String getFilename() {
        return "application";
    }

    public String getSubpackageName() {
        return "webpage" + File.separator + "WEB-INF" + File.separator + "classes";
    }

    @Override
    public void process() {
        String content = this.process0();
        String filename = this.getFilename();
        String subpackagename = this.getSubpackageName();
        if (content != null) {
            this.createSource(content, filename, subpackagename, false);
        }
    }

    public String process0() {
        WebXmlUtils wxutils = new WebXmlUtils(this.project, this.isFullBuild);
        Map<String, Object> templateMap = wxutils.createTemplateMap();
        return VelocityUtils.mergeContent((String)"template/application.properties.vm", templateMap);
    }
}

