/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.PresentationSourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Presentation;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.ResourceManagerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class StyleSheetManager
extends PresentationSourceGenerator {
    protected String id;
    protected String filename;
    protected Model smodel;
    protected Model pmodel;
    protected Model cmodel;
    protected Model cpmodel;
    protected String actiontype;
    protected static Logger logger = LogManager.getLogger((String)StyleSheetManager.class.getName());
    protected static ResourceManager rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");

    public StyleSheetManager(Project project, Presentation presentation, String id, String filename) {
        super(project, null, presentation);
        this.id = id;
        this.filename = filename;
        this.init();
    }

    protected void init() {
        this.action = AppSchemaUtil.getAction(this.project, this.id);
        if (this.action == null) {
            return;
        }
        String idref = this.action.getIdref();
        this.pmodel = AppSchemaUtil.getModel(this.project, idref, "presentation");
        if (this.pmodel == null) {
            return;
        }
        this.smodel = AppSchemaUtil.getModel(this.project, idref);
        this.actiontype = this.action.getType();
        if ("showList".equals(this.actiontype) || "download".equals(this.actiontype)) {
            this.cmodel = AppSchemaUtil.getConditionModel(this.project, this.action);
            this.cpmodel = AppSchemaUtil.getConditionPModel(this.project, this.action);
        } else {
            this.cmodel = this.smodel;
            this.cpmodel = this.pmodel;
        }
    }

    @Override
    public String getEncoding() {
        return JavaSourceGenerator.getWebEncoding(this.project);
    }

    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getFileSuffix() {
        return ".css";
    }

    @Override
    public void process() {
        if (this.smodel == null) {
            return;
        }
        String content = this.process0();
        String filename = this.addModelidToFilename(this.smodel.getId(), this.getFilename());
        this.createSource(content, filename, this.getPackageName(), false);
    }

    public String process0() {
        StringBuilder sb = new StringBuilder();
        if (this.actiontype == null || "insert".equals(this.actiontype) || "update".equals(this.actiontype) || "showList".equals(this.actiontype) || "download".equals(this.actiontype) || "copy".equals(this.actiontype)) {
            // empty if block
        }
        return sb.toString();
    }
}

