/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.ISourceVariable;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Displayitemgroup;
import jp.jasminesoft.jfc.gen.appschema.Displaymodel;
import jp.jasminesoft.jfc.gen.appschema.IDisplayitemgroupChoice;
import jp.jasminesoft.jfc.gen.appschema.IDisplaymodelChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Panel;
import jp.jasminesoft.jfc.gen.appschema.Panelgroup;
import jp.jasminesoft.jfc.gen.appschema.Presentation;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.ResourceManagerFactory;
import org.apache.commons.lang3.StringUtils;

public class TabSelectCodeGenerator
implements ISourceVariable {
    private Project project;
    private Model model;
    private ResourceManager rman;

    public TabSelectCodeGenerator(Project project, Model model) {
        this.project = project;
        this.model = model;
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
    }

    public String process() {
        Presentation[] presentations;
        if (!"store".equals(this.model.getType()) || StringUtils.isBlank((CharSequence)this.model.getId())) {
            return "";
        }
        Action[] actions = AppSchemaUtil.getActionByModelId(this.project, this.model.getId());
        if (actions == null || actions.length == 0) {
            return "";
        }
        Action action = null;
        for (Action _action : actions) {
            if (!_action.getType().equals("insert") && !_action.getType().equals("update") && !_action.getType().equals("copy")) continue;
            action = _action;
            break;
        }
        if ((presentations = AppSchemaUtil.getPresentation(this.project, action)) == null || presentations.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        this.process_TabSelect_normal(presentations, sb);
        this.process_TabSelect_container(presentations, sb);
        return sb.toString();
    }

    private void process_TabSelect_normal(Presentation[] presentations, StringBuilder sb) {
        ArrayList<String> selectedList = new ArrayList<String>();
        for (Presentation presentation : presentations) {
            Displaymodel[] dmodels;
            Panel panel = AppSchemaUtil.findBodyPanel(presentation);
            if (panel == null || (dmodels = AppSchemaUtil.findDisplaymodel(panel)) == null || dmodels.length == 0) continue;
            for (Displaymodel dmodel : dmodels) {
                for (IDisplaymodelChoice idmc : dmodel.getContent()) {
                    Displayitemgroup ditemg;
                    if (!(idmc instanceof Displayitemgroup) || !(ditemg = (Displayitemgroup)idmc).getUseTab()) continue;
                    this.process_TabSelect_normal(ditemg, selectedList);
                }
            }
        }
        if (selectedList.size() > 0) {
            sb.append(CR);
            sb.append("        ").append("// ").append(this.rman.getValue("helper.tab.selected")).append(CR);
            sb.append("        ").append("StringBuilder _tabbuf = new StringBuilder();").append(CR);
            for (String id : selectedList) {
                sb.append("        ");
                sb.append("_tabbuf.append(\"").append(id).append(" \");").append(CR);
            }
            sb.append("        ").append("p.request.setAttribute(\"");
            sb.append("__jfc_tab_").append(this.model.getId());
            sb.append("\", _tabbuf.toString().trim());").append(CR);
            sb.append(CR);
        }
    }

    private void process_TabSelect_normal(Displayitemgroup ditemg, List<String> selectedList) {
        if (ditemg.getUseTab() && ditemg.getSelected()) {
            selectedList.add(ditemg.getId());
        }
        for (IDisplayitemgroupChoice idgc : ditemg.getContent()) {
            Displayitemgroup c_ditemg;
            if (!(idgc instanceof Displayitemgroup) || !(c_ditemg = (Displayitemgroup)idgc).getUseTab()) continue;
            this.process_TabSelect_normal(c_ditemg, selectedList);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void process_TabSelect_container(Presentation[] presentations, StringBuilder sb) {
        void var6_8;
        ArrayList<Panelgroup> list = new ArrayList<Panelgroup>();
        Presentation[] presentationArray = presentations;
        int n = presentationArray.length;
        boolean bl = false;
        while (var6_8 < n) {
            Presentation presentation = presentationArray[var6_8];
            Panelgroup[] panelgroup = AppSchemaUtil.findPanelgroup(presentation);
            if (panelgroup.length > 0) {
                list.addAll(Arrays.asList(panelgroup));
            }
            ++var6_8;
        }
        LinkedHashMap<String, String> selectedMap = new LinkedHashMap<String, String>();
        block1: for (Panelgroup panelgroup : list) {
            Panel[] panels;
            String pname = panelgroup.getName();
            if (StringUtils.isBlank((CharSequence)pname)) continue;
            for (Panel panel : panels = panelgroup.getPanel()) {
                if (!panel.getSelected()) continue;
                selectedMap.put(pname, panel.getId());
                continue block1;
            }
        }
        if (selectedMap.size() > 0) {
            sb.append(CR);
            sb.append("        ").append("// ").append(this.rman.getValue("helper.tab.selected")).append(CR);
            for (Map.Entry entry : selectedMap.entrySet()) {
                sb.append("        ");
                sb.append("p.request.setAttribute(\"");
                sb.append("__jfc_tab_").append((String)entry.getKey());
                sb.append("\", \"");
                sb.append((String)entry.getValue());
                sb.append("\");").append(CR);
            }
            sb.append(CR);
        }
    }
}

