/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import jp.jasminesoft.jfc.InitLoaderFormInfoUtil;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.JFCAppResourceGenerator;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.ServiceLayerGenerator;
import jp.jasminesoft.jfc.gen.ServiceLayerImplGenerator;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.WorkflowGeneratorManager;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.StringUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TablenameGenerator
extends JavaSourceGenerator {
    public static final String SUB_PACKAGE_NAME = "app";
    protected Logger logger = LogManager.getLogger((String)TablenameGenerator.class.getName());
    protected String[] defaultImportStatement = new String[]{"java.util.*", "jp.jasminesoft.jfc.*"};

    public TablenameGenerator(Project project) {
        super(project);
    }

    @Override
    public String process0() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.gHeader());
        sb.append(this.gClassDeclaration());
        sb.append(this.gBegin());
        sb.append(this.gTablename());
        sb.append(this.gEnd());
        return sb.toString();
    }

    public String gClassDeclaration() {
        StringBuilder sb = new StringBuilder();
        sb.append("public class ");
        sb.append(this.getClassname());
        sb.append(CR);
        return sb.toString();
    }

    public String getClassExplanation() {
        return rman.getValue("tablename.comment.explanation");
    }

    @Override
    public String getClassname() {
        return "JFCAppTablename";
    }

    @Override
    public String getSubpackageName() {
        return SUB_PACKAGE_NAME;
    }

    @Override
    public String getSubpackageNameAsJavaRule() {
        return this.getSubpackageName();
    }

    @Override
    public String[] getDefaultImport() {
        ArrayList<String> importList = new ArrayList<String>();
        for (int i = 0; i < this.defaultImportStatement.length; ++i) {
            importList.add(this.defaultImportStatement[i]);
        }
        return importList.toArray(new String[0]);
    }

    protected String gHeader() {
        String[] ary;
        StringBuilder sb = new StringBuilder();
        boolean useCVSFlag = this.project.getUseCVS();
        if (useCVSFlag) {
            sb.append("/*");
            sb.append(CR);
            sb.append(" * $Id:$");
            sb.append(CR);
            sb.append(" */");
            sb.append(CR);
            sb.append("");
            sb.append(CR);
        }
        if (this.project.getPackage() != null) {
            sb.append("package ");
            sb.append(this.project.getPackage());
            sb.append(".");
            sb.append(this.getSubpackageNameAsJavaRule());
            sb.append(";");
            sb.append(CR);
            sb.append("");
            sb.append(CR);
        }
        if ((ary = this.getDefaultImport()) != null) {
            for (int i = 0; i < ary.length; ++i) {
                sb.append("import ");
                sb.append(ary[i]);
                sb.append(";");
                sb.append(CR);
            }
        }
        sb.append(CR);
        sb.append("/**");
        sb.append(CR);
        sb.append(" * " + AppSchemaUtil.getTitle(this.project));
        sb.append(CR);
        String[] comment_str = StringUtil.separateLine((String)this.getClassExplanation(), (int)72);
        if (comment_str != null) {
            for (int i = 0; i < comment_str.length; ++i) {
                sb.append(" * ");
                sb.append(comment_str[i]);
                sb.append(CR);
            }
        }
        sb.append(" *");
        sb.append(CR);
        if (useCVSFlag) {
            sb.append(" * @version $Revision:$ ");
            sb.append("$Date:$");
            sb.append(CR);
        }
        sb.append(" * @author " + this.project.getAuthor());
        sb.append(CR);
        sb.append(" */");
        sb.append(CR);
        sb.append("");
        sb.append(CR);
        return sb.toString();
    }

    protected String gTablename() {
        StringBuilder sb = new StringBuilder();
        IProjectChoice[] ipc = this.project.getContent();
        if (ipc == null || ipc.length == 0) {
            return sb.toString();
        }
        TreeMap<String, Model> storeMap = new TreeMap<String, Model>();
        TreeMap<String, Model> masterMap = new TreeMap<String, Model>();
        TreeMap<String, Model> workflowModelMap = new TreeMap<String, Model>();
        TreeMap<String, Model> userModelMap = new TreeMap<String, Model>();
        for (int i = 0; i < ipc.length; ++i) {
            String storage;
            int storagetype;
            Model model;
            String type;
            if (!(ipc[i] instanceof Model) || !"store".equals(type = (model = (Model)ipc[i]).getType()) && !"master".equals(type) || (storagetype = AppSchemaUtil.getStorageType(storage = model.getStorage())) == 3) continue;
            String tablename = TablenameGenerator.createInitdbXmlTableName(model);
            String variablename = TablenameGenerator.createTableVariableName(model);
            if ("store".equals(type)) {
                if (!AppSchemaUtil.isListStoreModel(model)) {
                    storeMap.put(variablename, model);
                }
            } else {
                masterMap.put(variablename, model);
            }
            WorkflowGeneratorManager.getInstance();
            if (WorkflowGeneratorManager.isWorkflowModel(model)) {
                workflowModelMap.put(variablename, model);
            }
            if (InitLoaderFormInfoUtil.isOnlyUserDefinedTable((String)variablename)) {
                userModelMap.put(variablename, model);
            }
            sb.append("    ");
            sb.append("/** " + model.getId() + " */");
            sb.append(CR);
            sb.append("    ");
            sb.append("public static final String ");
            sb.append(variablename);
            sb.append(" = ");
            sb.append("\"" + StringUtil.convertJavaString((String)tablename) + "\";");
            sb.append(CR);
            String desc = model.getDescription();
            if (desc == null || desc.length() == 0) {
                desc = model.getId();
            }
            String rkeyvariablename = TablenameGenerator.createResourceKeyVariableName(model);
            String rkey = JFCAppResourceGenerator.createTablenameResourceKey(variablename, desc);
            JFCAppResourceGenerator.put(rkey, desc);
            sb.append("    ");
            sb.append("public static final String ");
            sb.append(rkeyvariablename);
            sb.append(" = ");
            sb.append("\"" + StringUtil.convertJavaString((String)rkey) + "\";");
            sb.append(CR);
            if (i >= ipc.length - 1) continue;
            sb.append(CR);
        }
        sb.append(CR);
        sb.append("    ");
        sb.append("/** tableList */");
        sb.append(CR);
        sb.append("    ");
        sb.append("public static final String[][] getTableList(String locale) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("return new String[][]{");
        sb.append(CR);
        this.createTableList(sb, storeMap, masterMap, true);
        sb.append(CR);
        sb.append("        ");
        sb.append("};");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append("    ");
        sb.append("/** InitLoader tableList */");
        sb.append(CR);
        sb.append("    ");
        sb.append("public static final String[][] getInitLoaderTableList(String locale) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("return new String[][]{");
        sb.append(CR);
        this.createTableList(sb, storeMap, masterMap, false);
        sb.append(CR);
        sb.append("        ");
        sb.append("};");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append("    ");
        sb.append("/** workflow modelname map */");
        sb.append(CR);
        sb.append("    ");
        sb.append("public static final Map<String, String> getWorkflowModelNames(String locale) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("TreeMap<String, String> workflowModels = new TreeMap<String, String>();");
        sb.append(CR);
        sb.append(TablenameGenerator.getModelValue("workflowModels", workflowModelMap));
        sb.append("        ");
        sb.append("return workflowModels;");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append("    ");
        sb.append("/** user defined table list */");
        sb.append(CR);
        sb.append("    ");
        sb.append("public static final Map<String, String> getUserModelNames(String locale) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("TreeMap<String, String> userModels = new TreeMap<String, String>();");
        sb.append(CR);
        sb.append(TablenameGenerator.getModelValue("userModels", userModelMap));
        sb.append("        ");
        sb.append("return userModels;");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append("    ");
        sb.append("public static String getShowurl(String modelname, ActionParameter p) {");
        sb.append(CR);
        String variablename2 = null;
        for (String variablename2 : storeMap.keySet()) {
            Model model = (Model)storeMap.get(variablename2);
            Action action = AppSchemaUtil.getActionByModelIdAndType(this.project, model.getId(), "show");
            if (action == null) continue;
            ServiceLayerGenerator slg = new ServiceLayerGenerator(action, this.project);
            ServiceLayerImplGenerator slig = new ServiceLayerImplGenerator(action, this.project, slg);
            sb.append("        ");
            sb.append("if (" + variablename2 + ".equals(modelname)) {");
            sb.append(CR);
            sb.append("            ");
            sb.append("String __showurl = null;");
            sb.append(CR);
            sb.append(slig._createUrl4item(action, "            ", "show"));
            sb.append("            ");
            sb.append("return __showurl;");
            sb.append(CR);
            sb.append("        ");
            sb.append("}");
            sb.append(CR);
        }
        sb.append("        ");
        sb.append("return null;");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append("    ");
        sb.append("private final static String[][] modelpkeynameArray = new String[][] {");
        sb.append(CR);
        variablename2 = null;
        Iterator it = storeMap.keySet().iterator();
        boolean isFirst = true;
        while (it.hasNext()) {
            variablename2 = (String)it.next();
            Model model = (Model)storeMap.get(variablename2);
            PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(model, this.project);
            String pkeyname = null;
            pkeyname = pkeys.length != 1 ? AppSchemaUtil.compositePrimaryKey(pkeys) : AppSchemaUtil.createFullPrimaryKeyName(pkeys[0]);
            if (!isFirst) {
                sb.append(",");
                sb.append(CR);
            }
            sb.append("        ");
            sb.append("{ ");
            sb.append(variablename2);
            sb.append(", \"");
            sb.append(StringUtil.convertJavaString((String)pkeyname));
            sb.append("\" }");
            isFirst = false;
        }
        sb.append(CR);
        sb.append("    ");
        sb.append("};");
        sb.append(CR);
        sb.append(CR);
        sb.append("    ");
        sb.append("private final static Map<String,String> modelpkeynameMap;");
        sb.append(CR);
        sb.append(CR);
        sb.append("    ");
        sb.append("static {");
        sb.append(CR);
        sb.append("        ");
        sb.append("Map<String,String> _modelpkeynameMap = new HashMap<String,String>();");
        sb.append(CR);
        sb.append("        ");
        sb.append("for (String[] sa : modelpkeynameArray) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("_modelpkeynameMap.put(sa[0], sa[1]);");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append("        ");
        sb.append("modelpkeynameMap = _modelpkeynameMap;");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append("    ");
        sb.append("public static String getModelpkeyname(String modelname) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("return modelpkeynameMap.get(modelname);");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        return sb.toString();
    }

    private void createTableItem(StringBuilder sb, String variablename, String rkeyvariablename, boolean isFirst) {
        if (!isFirst) {
            sb.append(",");
            sb.append(CR);
        }
        sb.append("            ");
        sb.append("{ ");
        sb.append(variablename);
        sb.append(", ");
        sb.append("JFCUtils.getRValue(" + rkeyvariablename + ", locale)");
        sb.append(" }");
    }

    private void createTableList(StringBuilder sb, Map<String, Model> storeMap, Map<String, Model> masterMap, boolean isAllInclude) {
        this.createTableList(sb, storeMap, masterMap, isAllInclude, false);
    }

    private void createTableList(StringBuilder sb, Map<String, Model> storeMap, Map<String, Model> masterMap, boolean isAllInclude, boolean isOnlyUserDefined) {
        Model model;
        boolean isFirst = true;
        String variablename2 = null;
        String rkeyvariablename = null;
        for (String variablename2 : storeMap.keySet()) {
            if (!InitLoaderFormInfoUtil.isOnlyUserDefinedTable((String)variablename2)) continue;
            model = storeMap.get(variablename2);
            if (!isAllInclude && !AppSchemaUtil.isGenerateInitLoader(model)) continue;
            rkeyvariablename = TablenameGenerator.createResourceKeyVariableName(model);
            this.createTableItem(sb, variablename2, rkeyvariablename, isFirst);
            isFirst = false;
        }
        for (String variablename2 : masterMap.keySet()) {
            if (!InitLoaderFormInfoUtil.isOnlyUserDefinedTable((String)variablename2)) continue;
            model = masterMap.get(variablename2);
            if (!isAllInclude && !AppSchemaUtil.isGenerateInitLoader(model)) continue;
            rkeyvariablename = TablenameGenerator.createResourceKeyVariableName(model);
            this.createTableItem(sb, variablename2, rkeyvariablename, isFirst);
            isFirst = false;
        }
        if (isOnlyUserDefined) {
            return;
        }
        for (String variablename2 : storeMap.keySet()) {
            String mid;
            if (InitLoaderFormInfoUtil.isOnlyUserDefinedTable((String)variablename2)) continue;
            model = storeMap.get(variablename2);
            if (!isAllInclude && !AppSchemaUtil.isGenerateInitLoader(model) || "jfcmodel".equals(mid = model.getId()) || "jfcmodel4dm".equals(mid) || "jfclicenseholder".equals(mid) || "jfclockobject".equals(mid)) continue;
            rkeyvariablename = TablenameGenerator.createResourceKeyVariableName(model);
            this.createTableItem(sb, variablename2, rkeyvariablename, isFirst);
            isFirst = false;
        }
        for (String variablename2 : masterMap.keySet()) {
            if (InitLoaderFormInfoUtil.isOnlyUserDefinedTable((String)variablename2)) continue;
            model = masterMap.get(variablename2);
            if (!isAllInclude && !AppSchemaUtil.isGenerateInitLoader(model)) continue;
            rkeyvariablename = TablenameGenerator.createResourceKeyVariableName(model);
            this.createTableItem(sb, variablename2, rkeyvariablename, isFirst);
            isFirst = false;
        }
    }

    public static String createInitdbXmlTableName(Model model) {
        String storage = model.getStorage();
        int storagetype = AppSchemaUtil.getStorageType(storage);
        if (storagetype == 3) {
            return null;
        }
        String tablename = storagetype == 5 ? model.getId() : TablenameGenerator.createTableName(model);
        return tablename;
    }

    public static String createTableName(Model model) {
        Model mainmodel = AppSchemaUtil.getMainModel(model);
        if (mainmodel != null) {
            return TablenameGenerator.createTableName(mainmodel);
        }
        String ret = model.getTablename();
        if (ret == null || ret.length() == 0) {
            ret = "master".equals(model.getType()) ? SourceGenerator.convMasterID(model.getId()) : model.getId();
        }
        return ret;
    }

    public static String createTableVariableName(Model model) {
        String id = model.getId();
        String ret = "master".equals(model.getType()) ? SourceGenerator.convMasterID(id) : id;
        String storage = model.getStorage();
        int storagetype = AppSchemaUtil.getStorageType(storage);
        if (storagetype == 5) {
            return SourceGenerator.capFirst(ret) + "ModelId";
        }
        return SourceGenerator.capFirst(ret) + "Table";
    }

    public static String createResourceKeyVariableName(Model model) {
        String id = model.getId();
        String ret = "master".equals(model.getType()) ? SourceGenerator.convMasterID(id) : id;
        String storage = model.getStorage();
        int storagetype = AppSchemaUtil.getStorageType(storage);
        if (storagetype == 5) {
            return SourceGenerator.capFirst(ret) + "ModelResourceKey";
        }
        return SourceGenerator.capFirst(ret) + "TableResourceKey";
    }

    private static String getModelValue(String mapName, Map<String, Model> modelMap) {
        String variablename2 = null;
        StringBuilder sb = new StringBuilder();
        for (String variablename2 : modelMap.keySet()) {
            Model model = modelMap.get(variablename2);
            String rkeyvariablename = TablenameGenerator.createResourceKeyVariableName(model);
            sb.append("        ");
            sb.append(mapName);
            sb.append(".put(");
            sb.append(variablename2);
            sb.append(", ");
            sb.append("JFCUtils.getRValue(" + rkeyvariablename + ", locale));");
            sb.append(CR);
        }
        return sb.toString();
    }
}

