/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Autocalc;
import jp.jasminesoft.jfc.gen.appschema.Column;
import jp.jasminesoft.jfc.gen.appschema.Displaycondition;
import jp.jasminesoft.jfc.gen.appschema.Displayitem;
import jp.jasminesoft.jfc.gen.appschema.Displayitemgroup;
import jp.jasminesoft.jfc.gen.appschema.Displaymodel;
import jp.jasminesoft.jfc.gen.appschema.Displaymodelgroup;
import jp.jasminesoft.jfc.gen.appschema.IDisplayconditionChoice;
import jp.jasminesoft.jfc.gen.appschema.IDisplayitemgroupChoice;
import jp.jasminesoft.jfc.gen.appschema.IDisplaymodelChoice;
import jp.jasminesoft.jfc.gen.appschema.IDisplaymodelgroupChoice;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IPanelChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Layout;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Panel;
import jp.jasminesoft.jfc.gen.appschema.Panelgroup;
import jp.jasminesoft.jfc.gen.appschema.Presentation;
import jp.jasminesoft.jfc.gen.appschema.Project;
import org.apache.commons.lang3.StringUtils;

public class TargetitemGenerator {
    private Action action;

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    protected boolean isSkipPresentationItem(IRNode node) {
        return false;
    }

    protected String[] createTargetitems(Presentation presentation) {
        if (presentation == null) {
            return null;
        }
        TreeSet<String> itemSet = new TreeSet<String>();
        Layout layout = presentation.getLayout();
        if (layout == null) {
            return null;
        }
        Panel[] panels = layout.getPanel();
        if (panels == null || panels.length == 0) {
            return null;
        }
        for (int i = 0; i < panels.length; ++i) {
            Panel panel = panels[i];
            this.setItemSet(itemSet, panel);
        }
        return itemSet.toArray(new String[0]);
    }

    private void setItemSet(Set<String> itemSet, Panel panel) {
        IPanelChoice[] ipc = panel.getContent();
        if (ipc == null) {
            return;
        }
        boolean permitOnlyDisplayconditionFlag = false;
        for (int j = 0; j < ipc.length; ++j) {
            Panel[] _panels;
            if (this.isSkipPresentationItem(ipc[j])) continue;
            if (ipc[j] instanceof Displaycondition) {
                this.setItemSet(itemSet, (Displaycondition)ipc[j]);
                permitOnlyDisplayconditionFlag = true;
                continue;
            }
            if (ipc[j] instanceof Displaymodelgroup && !permitOnlyDisplayconditionFlag) {
                this.setItemSet(itemSet, (Displaymodelgroup)ipc[j]);
                continue;
            }
            if (ipc[j] instanceof Displaymodel && !permitOnlyDisplayconditionFlag) {
                this.setItemSet(itemSet, (Displaymodel)ipc[j]);
                continue;
            }
            if (ipc[j] instanceof Column) {
                this.setItemSet(itemSet, (Column)ipc[j]);
                continue;
            }
            if (ipc[j] instanceof Panel) {
                this.setItemSet(itemSet, (Panel)ipc[j]);
                continue;
            }
            if (!(ipc[j] instanceof Panelgroup)) continue;
            Panelgroup panelgroup = (Panelgroup)ipc[j];
            for (Panel _panel : _panels = panelgroup.getPanel()) {
                this.setItemSet(itemSet, _panel);
            }
        }
    }

    private void setItemSet(Set<String> itemSet, Column column) {
        Panel[] panels = column.getPanel();
        if (panels == null || panels.length == 0) {
            return;
        }
        for (int j = 0; j < panels.length; ++j) {
            Panel panel = panels[j];
            if (this.isSkipPresentationItem(panel)) continue;
            this.setItemSet(itemSet, panel);
        }
    }

    private void setItemSet(Set<String> itemSet, Displaycondition dcond) {
        IDisplayconditionChoice[] idc = dcond.getContent();
        if (idc != null) {
            for (int k = 0; k < idc.length; ++k) {
                if (this.isSkipPresentationItem(idc[k])) continue;
                if (idc[k] instanceof Displayitemgroup) {
                    this.setItemSet(itemSet, (Displayitemgroup)idc[k]);
                    continue;
                }
                if (!(idc[k] instanceof Displayitem)) continue;
                this.setItemSet(itemSet, (Displayitem)idc[k]);
            }
        }
    }

    private void setItemSet(Set<String> itemSet, Displaymodelgroup dmg) {
        IDisplaymodelgroupChoice[] idgc = dmg.getContent();
        if (idgc != null) {
            for (int k = 0; k < idgc.length; ++k) {
                if (this.isSkipPresentationItem(idgc[k])) continue;
                if (idgc[k] instanceof Displaymodel) {
                    this.setItemSet(itemSet, (Displaymodel)idgc[k]);
                    continue;
                }
                if (!(idgc[k] instanceof Panelgroup)) continue;
                Panelgroup panelgroup = (Panelgroup)idgc[k];
                for (Panel _panel : panelgroup.getPanel()) {
                    this.setItemSet(itemSet, _panel);
                }
            }
        }
    }

    private void setItemSet(Set<String> itemSet, Displaymodel dm) {
        if (!this.isIncludeForeignModel() && StringUtils.isNotBlank((CharSequence)dm.getForeignKeyIdref())) {
            return;
        }
        IDisplaymodelChoice[] idc = dm.getContent();
        if (idc != null) {
            for (int k = 0; k < idc.length; ++k) {
                if (this.isSkipPresentationItem(idc[k])) continue;
                if (idc[k] instanceof Displayitemgroup) {
                    this.setItemSet(itemSet, (Displayitemgroup)idc[k]);
                    continue;
                }
                if (!(idc[k] instanceof Displayitem)) continue;
                this.setItemSet(itemSet, (Displayitem)idc[k]);
            }
        }
    }

    private void setItemSet(Set<String> itemSet, Displayitemgroup dig) {
        IDisplayitemgroupChoice[] idig = dig.getContent();
        if (idig != null) {
            for (int k = 0; k < idig.length; ++k) {
                if (this.isSkipPresentationItem(idig[k])) continue;
                if (idig[k] instanceof Displayitemgroup) {
                    this.setItemSet(itemSet, (Displayitemgroup)idig[k]);
                    continue;
                }
                if (!(idig[k] instanceof Displayitem)) continue;
                this.setItemSet(itemSet, (Displayitem)idig[k]);
            }
        }
    }

    private void setItemSet(Set<String> itemSet, Displayitem ditem) {
        String endname;
        IRNode node;
        String dname = ditem.getName();
        if (ditem.getReadonly() && AppSchemaUtil.isAllReadonlytype(ditem)) {
            return;
        }
        if (!this.isIncludeTargetItemSet(ditem)) {
            return;
        }
        this.setItemSet(itemSet, dname);
        IRNode iRNode = node = this.action != null ? this.action.getIdrefAsIRNode() : null;
        if (node != null && node instanceof Model) {
            Modelitem refsitem;
            Model smodel = (Model)node;
            Modelitem sitem = AppSchemaUtil.getModelitem(dname, smodel);
            String copyRolecontent = AppSchemaUtil.getCopyRolecontent(sitem);
            this.setItemSet(itemSet, copyRolecontent);
            String mitemFooter = smodel.getRealFilenameRefModelitemFooter();
            if ("file".equals(ditem.getType()) && mitemFooter != null && mitemFooter.length() > 0 && (refsitem = AppSchemaUtil.getModelitem(dname + mitemFooter, smodel)) != null) {
                this.setItemSet(itemSet, refsitem.getName());
            }
        }
        if ((endname = ditem.getSelectinputOnerangeEndName()) != null) {
            this.setItemSet(itemSet, endname);
        }
    }

    protected boolean isIncludeTargetItemSet(Displayitem ditem) {
        return true;
    }

    protected boolean isIncludeForeignModel() {
        return true;
    }

    private void setItemSet(Set<String> itemSet, String dname) {
        if (dname != null && dname.length() > 0) {
            if (AppSchemaUtil.isGenerationModelitem(dname, (Model)this.action.getIdrefAsIRNode())) {
                return;
            }
            if (dname.indexOf("/") >= 0) {
                String dname1;
                String dname0 = SourceGenerator.getElementNameByNestLevel(dname, 0);
                if (!itemSet.contains(dname0)) {
                    itemSet.add(dname0);
                }
                if (!itemSet.contains(dname1 = dname.substring(dname.indexOf("/") + 1))) {
                    itemSet.add(dname1);
                }
            } else if (!itemSet.contains(dname)) {
                itemSet.add(dname);
            }
        }
    }

    public Set<String> createListTargetitems(Project project, Model model) {
        Model lmodel = this.getTargetModel4gSetTargetItem(project, model);
        return this.createListTargetitems(project, model, lmodel);
    }

    public Set<String> createListTargetitems(Project project, Model model, Model lmodel) {
        Model smodel = AppSchemaUtil.getStoreModel(model);
        LinkedHashSet<String> targetItemSet = new LinkedHashSet<String>();
        if (lmodel != null) {
            IModelChoice[] limc = lmodel.getContent();
            for (int k = 0; k < limc.length; ++k) {
                Modelitem lmitem;
                String name;
                Modelitem smitem;
                if (!(limc[k] instanceof Modelitem) || (smitem = AppSchemaUtil.getModelitem(name = (lmitem = (Modelitem)limc[k]).getName(), smodel)).getGeneration()) continue;
                targetItemSet.add(name);
                Autocalc autocalc = AppSchemaUtil.getAutocalc(smitem);
                if (autocalc == null) continue;
                this.setTargetItem0(project, smodel, autocalc, targetItemSet);
            }
        }
        return targetItemSet;
    }

    protected Model getTargetModel4gSetTargetItem(Project project, Model model) {
        return AppSchemaUtil.getModel(project, model.getId(), "list");
    }

    private void setTargetItem0(Project project, Model model, Autocalc autocalc, Set<String> targetItemSet) {
        HashSet<String> set = new HashSet<String>();
        AppSchemaUtil.setAutocalcReferenceModelitemName(project, model, autocalc, set);
        this.mergeTargetItemSet(targetItemSet, set);
    }

    private void mergeTargetItemSet(Set<String> targetItemSet, Set<String> set) {
        for (String name : set) {
            String cpart = AppSchemaUtil.getChildPart(name);
            int ptr = cpart.indexOf(",");
            if (ptr > 0) {
                cpart = cpart.substring(0, ptr);
            }
            targetItemSet.add(cpart);
        }
    }
}

