/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import jp.jasminesoft.jfc.repgen.JfcreporttemplateUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public abstract class TemplateExcelReportGenerator {
    private static Logger logger = LogManager.getLogger(TemplateExcelReportGenerator.class);
    private static final String TYPE_XLS = "xls";
    private static final String TYPE_XLSX = "xlsx";
    private static final String DEFAULT_TYPE = "xlsx";
    private String filename;
    private String type;
    private static String basedir = ".." + File.separator + "xls-report" + File.separator + "template";

    public TemplateExcelReportGenerator(String filename) {
        filename = JfcreporttemplateUtil.getPrintlayoutTemplateFileName((String)filename);
        int ptr = filename.lastIndexOf(".");
        if (ptr > 0) {
            String _suffix1 = "xlsx";
            if (filename.length() > ptr + 1) {
                _suffix1 = filename.substring(ptr + 1).toLowerCase();
            }
            if (_suffix1.equals(TYPE_XLS) || _suffix1.equals("xlsx")) {
                this.type = _suffix1;
                this.filename = filename.substring(0, ptr) + "." + this.type;
            }
        }
        if (this.filename == null) {
            this.type = "xlsx";
            this.filename = filename + "." + this.type;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(List list) {
        String path;
        File f;
        File dir = new File(basedir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if ((f = new File(path = basedir + File.separator + this.filename)).exists()) {
            f.delete();
        }
        Object wb = this.type.equals(TYPE_XLS) ? new HSSFWorkbook() : new XSSFWorkbook();
        try {
            this.process(list, f, (Workbook)wb);
        }
        finally {
            try {
                wb.close();
            }
            catch (IOException e) {
                logger.debug("IOException at workbook close", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(List list, File f, Workbook wb) {
        Font font = wb.createFont();
        font.setFontHeightInPoints((short)11);
        CellStyle style = wb.createCellStyle();
        Sheet sheet = wb.createSheet("template");
        this.process0(list, sheet, style);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(f);
            wb.write((OutputStream)out);
        }
        catch (IOException e) {
            logger.error("Write error has occured, " + f);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                logger.debug("IOException at outputstream close", (Throwable)e);
            }
        }
    }

    protected abstract void process0(List var1, Sheet var2, CellStyle var3);
}

