/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.ControllerGenerator2;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.TextSearchGeneratorModule_base;
import jp.jasminesoft.jfc.gen.TextSearchUtil;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.VelocityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextSearchGeneratorModule_Model2Map
extends TextSearchGeneratorModule_base {
    private static Logger logger = LogManager.getLogger(TextSearchGeneratorModule_Model2Map.class);
    public static final String JSHFILENAME = "_jshfilename";
    public static final String ITEM_USERIDJSHPARAM = "useridjshparam";
    public static final String ITEM_JGROUPIDJSHPARAM = "jgroupidjshparam";
    private List<ItemChecker> itemCheckers;

    public TextSearchGeneratorModule_Model2Map(Model model, Project project) {
        super(model, project);
        this.checkGenCondition(model, project);
    }

    void checkGenCondition(Model model, Project project) {
        if (model == null) {
            throw new RuntimeException("model is null");
        }
        if (project == null) {
            throw new RuntimeException("project is null");
        }
    }

    @Override
    public String getClassname() {
        return TextSearchUtil.createModel2MapClassname(this.model);
    }

    @Override
    protected String getTemplateFile() {
        return "Model2Map.vm";
    }

    @Override
    protected void createContentsCode(Map<String, Object> map) {
        map.put("createMapCode", this.getContentsMapCode(map));
        map.put("createValueCode", this.getContentsValueCode(map));
    }

    static String getPrimaryKeyGetter(String name, String type) {
        StringBuilder sb = new StringBuilder();
        if (JavaSourceGenerator.isStringType(type)) {
            sb.append("src.");
            sb.append(JavaSourceGenerator.getterMethod(name));
            sb.append("()");
        } else {
            sb.append(JavaSourceGenerator.getterFullMethodAsObject("src", name, "string"));
        }
        return sb.toString();
    }

    String getContentsMapCode(Map<String, Object> map) {
        StringBuilder sb = new StringBuilder();
        PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKey(this.model);
        if (pkeys == null) {
            throw new RuntimeException("no pkeys for model " + this.model.getId() + " ");
        }
        StringBuilder sb2 = new StringBuilder();
        sb.append(this.gPutUniqueKey(pkeys));
        for (PrimaryKey pkey : pkeys) {
            String name = pkey.getName();
            Modelitem mitem = AppSchemaUtil.getModelitem(name, this.model);
            if (mitem == null) {
                logger.warn("modelitem for " + name + " is not found");
                continue;
            }
            String type = AppSchemaUtil.getModelitemType(this.project, this.model.getId(), mitem, "roleid");
            if (type == null) {
                logger.warn("type for " + name + " is not found");
                continue;
            }
            sb.append(TextSearchGeneratorModule_Model2Map.gPut(name, TextSearchGeneratorModule_Model2Map.getPrimaryKeyGetter(name, type)));
            sb.append(CR);
            sb.append(TextSearchGeneratorModule_Model2Map.gPutUrlEncoded(name, TextSearchGeneratorModule_Model2Map.getPrimaryKeyGetter(name, type)));
        }
        sb.append((CharSequence)sb2);
        sb.append(CR);
        sb.append("        ");
        sb.append("// string");
        sb.append(CR);
        sb.append(CR);
        sb.append(this.getContentsMapCodeString());
        sb.append(CR);
        sb.append("        ");
        sb.append("// file");
        sb.append(CR);
        sb.append(CR);
        sb.append(this.getContentsMapCodeJshfilename());
        return sb.toString();
    }

    private String gPutUniqueKey(PrimaryKey[] pkeys) {
        StringBuilder sb = new StringBuilder();
        String id = "src";
        String classname = AppSchemaUtil.getClassname(this.model);
        String retvar = null;
        retvar = pkeys.length == 1 ? AppSchemaUtil.createFullPrimaryKeyName(pkeys[0]) : AppSchemaUtil.createPrimaryKeyName(pkeys);
        sb.append("        ");
        sb.append("String ").append(retvar).append(" = null;").append(CR);
        String cnt = ControllerGenerator2.gDeclarePrimaryKey(classname, this.model, pkeys, "        ", id, this.project);
        sb.append(cnt);
        sb.append("        ");
        sb.append("ret.put(Indexer.UNIQUE_KEY, " + retvar + ");");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    String traceItems(Map<ItemChecker, Snippet> snippetMap) {
        StringBuilder sb = new StringBuilder();
        block0: for (ModelitemEntry miEntry : this.getModelitems4Textsearch()) {
            Modelitem mitem = miEntry.item;
            Model theModel = miEntry.model;
            String name = mitem.getName();
            String type = AppSchemaUtil.getModelitemType(this.project, theModel.getId(), mitem, "roleid");
            for (Map.Entry<ItemChecker, Snippet> entry : snippetMap.entrySet()) {
                if (!entry.getKey().isTarget(this.project, theModel, mitem, name, type)) continue;
                sb.append(entry.getValue().getText(theModel, name, type));
                continue block0;
            }
        }
        return sb.toString();
    }

    List<ModelitemEntry> getModelitems4Textsearch() {
        ArrayList<ModelitemEntry> items = new ArrayList<ModelitemEntry>();
        for (IModelChoice imc : this.model.getContent()) {
            if (!(imc instanceof Modelitem)) continue;
            Modelitem mitem = (Modelitem)imc;
            if (this.isModelitem4Textsearch(mitem, this.model)) {
                items.add(new ModelitemEntry(mitem, this.model));
                continue;
            }
            ModelitemEntry mEntry = null;
            Model mainModel = TextSearchUtil.getMainmodel(this.project, this.model);
            if (mainModel != null && (mEntry = this.getModelitemEntry(mitem, mainModel)) == null) {
                mEntry = this.getModelitemEntryFromSubmodel(mitem, mainModel);
            }
            if (mEntry == null) {
                mEntry = this.getModelitemEntryFromSubmodel(mitem, this.model);
            }
            if (mEntry == null) continue;
            items.add(mEntry);
        }
        return items;
    }

    private ModelitemEntry getModelitemEntryFromSubmodel(Modelitem mitem, Model theModel) {
        ModelitemEntry mEntry = null;
        Model[] subModels = TextSearchUtil.getSubmodelTextsearchReady(this.project, theModel);
        if (subModels != null) {
            Model subModel;
            Model[] modelArray = subModels;
            int n = modelArray.length;
            for (int i = 0; i < n && (mEntry = this.getModelitemEntry(mitem, subModel = modelArray[i])) == null; ++i) {
            }
        }
        return mEntry;
    }

    private ModelitemEntry getModelitemEntry(Modelitem mitem, Model theModel) {
        ModelitemEntry mEntry = null;
        Modelitem m = this.getModelitem4Textsearch(mitem.getName(), theModel);
        if (m != null) {
            mEntry = new ModelitemEntry(m, theModel);
        }
        return mEntry;
    }

    private Modelitem getModelitem4Textsearch(String name, Model theModel) {
        if (theModel == null) {
            return null;
        }
        Modelitem mitem = AppSchemaUtil.getModelitem(name, theModel);
        if (mitem != null && this.isModelitem4Textsearch(mitem, theModel)) {
            return mitem;
        }
        return null;
    }

    private boolean isModelitem4Textsearch(Modelitem mitem, Model theModel) {
        if (!mitem.getTextsearch()) {
            return false;
        }
        String name = mitem.getName();
        String type = AppSchemaUtil.getModelitemType(this.project, theModel.getId(), mitem, "roleid");
        if (name == null || type == null) {
            return false;
        }
        for (ItemChecker ic : this.getItemCheckerList()) {
            if (!ic.isTarget(this.project, theModel, mitem, name, type)) continue;
            return true;
        }
        return false;
    }

    String getContentsMapCodeString() {
        Map<ItemChecker, Snippet> snippetMap = this.getSnippetMap4CodeString();
        return this.traceItems(snippetMap);
    }

    private Map<ItemChecker, Snippet> getSnippetMap4CodeString() {
        HashMap<ItemChecker, Snippet> snippetMap = new HashMap<ItemChecker, Snippet>();
        snippetMap.put(new ItemCheckerUseridjshparam(), new Snippet(){

            @Override
            public String getText(Model theModel, String name, String type) {
                return TextSearchGeneratorModule_Model2Map.gPut(name, TextSearchGeneratorModule_Model2Map.gStringValueNoCount(name));
            }
        });
        snippetMap.put(new ItemCheckerJgroupidjshparam(), new Snippet(){

            @Override
            public String getText(Model theModel, String name, String type) {
                return TextSearchGeneratorModule_Model2Map.gPut(name, "createJgroupidjshparam(src)");
            }
        });
        snippetMap.put(new ItemCheckerRepItem(), new Snippet(){

            @Override
            public String getText(Model theModel, String name, String type) {
                return TextSearchGeneratorModule_Model2Map.gPut(AppSchemaUtil.getChildPart(name), TextSearchGeneratorModule_Model2Map.gCreateRepitemStrCall(name));
            }
        });
        snippetMap.put(new ItemCheckerRepconItem(), new Snippet(){

            @Override
            public String getText(Model theModel, String name, String type) {
                return TextSearchGeneratorModule_Model2Map.gPut(AppSchemaUtil.getChildPart(name), TextSearchGeneratorModule_Model2Map.gCreateRepconStrCall(name));
            }
        });
        snippetMap.put(new ItemCheckerSingleItem(), new Snippet(){

            @Override
            public String getText(Model theModel, String name, String type) {
                return TextSearchGeneratorModule_Model2Map.gPut(name, TextSearchGeneratorModule_Model2Map.gStringValue(name));
            }
        });
        return snippetMap;
    }

    String getContentsMapCodeJshfilename() {
        Map<ItemChecker, Snippet> snippetMap = this.getSnippetMap4CodeJshfilename();
        return this.traceItems(snippetMap);
    }

    private Map<ItemChecker, Snippet> getSnippetMap4CodeJshfilename() {
        HashMap<ItemChecker, Snippet> snippetMap = new HashMap<ItemChecker, Snippet>();
        snippetMap.put(new ItemCheckerRepconItemJshfilename(), new Snippet(){

            @Override
            public String getText(Model theModel, String name, String type) {
                return TextSearchGeneratorModule_Model2Map.gPut(AppSchemaUtil.getChildPart(name), TextSearchGeneratorModule_Model2Map.gCreateRepconStrCall(name));
            }
        });
        snippetMap.put(new ItemCheckerSingleItemJshfilename(), new Snippet(){

            @Override
            public String getText(Model theModel, String name, String type) {
                return TextSearchGeneratorModule_Model2Map.gPut(name, TextSearchGeneratorModule_Model2Map.gStringValueJshfilename(name));
            }
        });
        return snippetMap;
    }

    private List<ItemChecker> getItemCheckerList() {
        if (this.itemCheckers == null) {
            this.itemCheckers = new ArrayList<ItemChecker>();
            for (Map.Entry<ItemChecker, Snippet> entry : this.getSnippetMap4CodeString().entrySet()) {
                this.itemCheckers.add(entry.getKey());
            }
            for (Map.Entry<ItemChecker, Snippet> entry : this.getSnippetMap4CodeJshfilename().entrySet()) {
                this.itemCheckers.add(entry.getKey());
            }
        }
        return this.itemCheckers;
    }

    String getContentsValueCode(Map<String, Object> map) {
        HashMap<ItemChecker, Snippet> snippetMap = new HashMap<ItemChecker, Snippet>();
        snippetMap.put(new ItemCheckerRepItem(), new Snippet(){

            @Override
            public String getText(Model theModel, String name, String type) {
                return TextSearchGeneratorModule_Model2Map.gCreateRepitemStrMethod(TextSearchGeneratorModule_Model2Map.this.model, theModel, name, type);
            }
        });
        snippetMap.put(new ItemCheckerRepconItem(), new Snippet(){

            @Override
            public String getText(Model theModel, String name, String type) {
                return TextSearchGeneratorModule_Model2Map.gCreateRepconStrMethod(TextSearchGeneratorModule_Model2Map.this.model, theModel, name, type);
            }
        });
        snippetMap.put(new ItemCheckerRepconItemJshfilename(), new Snippet(){

            @Override
            public String getText(Model theModel, String name, String type) {
                return TextSearchGeneratorModule_Model2Map.gCreateRepconStrMethodItemJshfilename(TextSearchGeneratorModule_Model2Map.this.model, theModel, name, type);
            }
        });
        snippetMap.put(new ItemCheckerJgroupidjshparam(), new Snippet(){

            @Override
            public String getText(Model theModel, String name, String type) {
                return TextSearchGeneratorModule_Model2Map.gCreateJgroupidjshparam(TextSearchGeneratorModule_Model2Map.this.model, theModel, name, type);
            }
        });
        return this.traceItems(snippetMap);
    }

    static String gPut(String name, String methodCall) {
        StringBuilder sb = new StringBuilder();
        sb.append("        ");
        sb.append("ret.put(\"");
        sb.append(name);
        sb.append("\",");
        sb.append(methodCall);
        sb.append(");");
        sb.append(CR);
        return sb.toString();
    }

    static String gPutUrlEncoded(String name, String methodCall) {
        StringBuilder sb = new StringBuilder();
        sb.append("        ");
        sb.append("ret.put(Indexer.URLENCODED_HEADER + \"");
        sb.append(name);
        sb.append("\", ");
        sb.append(methodCall);
        sb.append(");");
        sb.append(CR);
        return sb.toString();
    }

    static String getMethodCreateRepitemStr(String name) {
        return "createRepitemStr4" + AppSchemaUtil.getChildPart(name);
    }

    static String gCreateRepitemStrCall(String name) {
        return TextSearchGeneratorModule_Model2Map.getMethodCreateRepitemStr(name) + "(src)";
    }

    static String gCreateRepitemStrMethod(Model model, Model theModel, String name, String type) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("method", TextSearchGeneratorModule_Model2Map.getMethodCreateRepitemStr(name));
        params.put("classname", AppSchemaUtil.getClassname(model));
        params.put("repconClassname", SourceGenerator.capFirst(name));
        return VelocityUtils.mergeContent((String)"template/javasrc/textsearch/Model2Map_createRepitemStr.vm", params);
    }

    static String getMethodCreateRepconStr(String name) {
        return "createRepconStr4" + AppSchemaUtil.getChildPart(name);
    }

    static String gCreateRepconStrCall(String name) {
        return TextSearchGeneratorModule_Model2Map.getMethodCreateRepconStr(name) + "(src)";
    }

    static String gCreateRepconStrMethod(Model model, Model theModel, String name, String type) {
        StringBuilder sb = new StringBuilder();
        sb.append("cc.countChar(");
        sb.append("repcon");
        sb.append(JavaSourceGenerator.getterFullMethod(AppSchemaUtil.getChildPart(name)));
        sb.append(")");
        return TextSearchGeneratorModule_Model2Map.gCreateRepconStrMethodInternal(model, theModel, name, type, sb.toString());
    }

    static String gCreateRepconStrMethodItemJshfilename(Model model, Model theModel, String name, String type) {
        String filename = "repcon" + JavaSourceGenerator.getterFullMethod(AppSchemaUtil.getChildPart(AppSchemaUtil.getJshfilenameBase(name)));
        String jshfilename = "repcon" + JavaSourceGenerator.getterFullMethod(AppSchemaUtil.getChildPart(name));
        StringBuilder sb = new StringBuilder();
        sb.append("RepconFileStringUtil.getFilenameAttachedString(");
        sb.append(filename);
        sb.append(",");
        sb.append(jshfilename);
        sb.append(",");
        sb.append("extract(");
        sb.append(filename);
        sb.append(",");
        sb.append(jshfilename);
        sb.append(")");
        sb.append(")");
        return TextSearchGeneratorModule_Model2Map.gCreateRepconStrMethodInternal(model, theModel, name, type, sb.toString());
    }

    static String gCreateRepconStrMethodInternal(Model model, Model theModel, String name, String type, String repconExpression) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("method", TextSearchGeneratorModule_Model2Map.getMethodCreateRepconStr(name));
        params.put("classname", AppSchemaUtil.getClassname(model));
        params.put("repConClassname4Variable", TextSearchGeneratorModule_Model2Map.getRepConClassname4Variable(theModel, name));
        params.put("repConClassname4Method", TextSearchGeneratorModule_Model2Map.getRepConClassname4Method(name));
        params.put("childpart", JavaSourceGenerator.getterFullMethod(AppSchemaUtil.getChildPart(name)));
        params.put("repconExpression", repconExpression);
        return VelocityUtils.mergeContent((String)"template/javasrc/textsearch/Model2Map_createRepconStr.vm", params);
    }

    static String getRepConClassname4Variable(Model model, String name) {
        String repConClassname4Variable = AppSchemaUtil.getModelitem(AppSchemaUtil.getParentPart(name), model).getClassname();
        if (repConClassname4Variable == null) {
            repConClassname4Variable = TextSearchGeneratorModule_Model2Map.getRepConClassname4Method(name);
        }
        return repConClassname4Variable;
    }

    static String getRepConClassname4Method(String name) {
        String repConClassname4Method = SourceGenerator.capFirst(AppSchemaUtil.getParentPart(name));
        return repConClassname4Method;
    }

    static String gCreateJgroupidjshparam(Model model, Model theModel, String name, String type) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("classname", AppSchemaUtil.getClassname(model));
        return VelocityUtils.mergeContent((String)"template/javasrc/textsearch/Model2Map_createjgroupidjshparam.vm", params);
    }

    static String gStringValue(String name) {
        StringBuilder sb = new StringBuilder();
        sb.append("cc.countChar(");
        sb.append(TextSearchGeneratorModule_Model2Map.gStringValueNoCount(name));
        sb.append(")");
        return sb.toString();
    }

    static String gStringValueNoCount(String name) {
        StringBuilder sb = new StringBuilder();
        sb.append("src" + JavaSourceGenerator.getterFullMethod(name));
        return sb.toString();
    }

    static String gStringValueJshfilename(String name) {
        StringBuilder sb = new StringBuilder();
        String filename = "src" + JavaSourceGenerator.getterFullMethod(AppSchemaUtil.getJshfilenameBase(name));
        String jshfilename = "src" + JavaSourceGenerator.getterFullMethod(name);
        sb.append("RepconFileStringUtil.getFilenameAttachedString(");
        sb.append(filename);
        sb.append(",");
        sb.append(jshfilename);
        sb.append(",");
        sb.append("extract(");
        sb.append(filename);
        sb.append(",");
        sb.append(jshfilename);
        sb.append(")");
        sb.append(")");
        return sb.toString();
    }

    private class ModelitemEntry {
        Modelitem item;
        Model model;

        ModelitemEntry(Modelitem item, Model model) {
            this.item = item;
            this.model = model;
        }
    }

    static interface ItemChecker {
        public boolean isTarget(Project var1, Model var2, Modelitem var3, String var4, String var5);
    }

    static interface Snippet {
        public String getText(Model var1, String var2, String var3);
    }

    class ItemCheckerUseridjshparam
    implements ItemChecker {
        ItemCheckerUseridjshparam() {
        }

        @Override
        public boolean isTarget(Project theProject, Model theModel, Modelitem mitem, String name, String type) {
            return !AppSchemaUtil.isPrimaryKey(theModel, mitem.getName()) && TextSearchGeneratorModule_Model2Map.ITEM_USERIDJSHPARAM.equals(mitem.getName());
        }
    }

    class ItemCheckerJgroupidjshparam
    implements ItemChecker {
        ItemCheckerJgroupidjshparam() {
        }

        @Override
        public boolean isTarget(Project theProject, Model theModel, Modelitem mitem, String name, String type) {
            return !AppSchemaUtil.isPrimaryKey(theModel, mitem.getName()) && TextSearchGeneratorModule_Model2Map.ITEM_JGROUPIDJSHPARAM.equals(mitem.getName());
        }
    }

    class ItemCheckerRepItem
    implements ItemChecker {
        ItemCheckerRepItem() {
        }

        @Override
        public boolean isTarget(Project theProject, Model theModel, Modelitem mitem, String name, String type) {
            return !AppSchemaUtil.isPrimaryKey(theModel, mitem.getName()) && TextSearchUtil.isModelitemForTextSearch(theProject, mitem) && !TextSearchUtil.isHiddenByPermissionWithCondition(mitem, theProject, theModel) && !TextSearchUtil.isHiddenOnShowList(mitem, theProject, theModel) && mitem.getMultiple() && !mitem.getHasChild() && !AppSchemaUtil.hasChildPart(mitem.getName()) && !AppSchemaUtil.isJshfilename(name) && TextSearchUtil.isStringType(theProject, mitem);
        }
    }

    class ItemCheckerRepconItem
    implements ItemChecker {
        ItemCheckerRepconItem() {
        }

        @Override
        public boolean isTarget(Project theProject, Model theModel, Modelitem mitem, String name, String type) {
            return !AppSchemaUtil.isPrimaryKey(theModel, mitem.getName()) && TextSearchUtil.isModelitemForTextSearch(theProject, mitem) && !TextSearchUtil.isHiddenByPermissionWithCondition(mitem, theProject, theModel) && !TextSearchUtil.isHiddenOnShowList(mitem, theProject, theModel) && !mitem.getMultiple() && !mitem.getHasChild() && AppSchemaUtil.hasChildPart(mitem.getName()) && !AppSchemaUtil.isJshfilename(name) && TextSearchUtil.isStringType(theProject, mitem);
        }
    }

    class ItemCheckerSingleItem
    implements ItemChecker {
        ItemCheckerSingleItem() {
        }

        @Override
        public boolean isTarget(Project theProject, Model theModel, Modelitem mitem, String name, String type) {
            return !AppSchemaUtil.isPrimaryKey(theModel, mitem.getName()) && TextSearchUtil.isModelitemForTextSearch(theProject, mitem) && !TextSearchUtil.isHiddenByPermissionWithCondition(mitem, theProject, theModel) && !TextSearchUtil.isHiddenOnShowList(mitem, theProject, theModel) && !mitem.getMultiple() && !mitem.getHasChild() && !AppSchemaUtil.hasChildPart(mitem.getName()) && !AppSchemaUtil.isJshfilename(name) && TextSearchUtil.isStringType(theProject, mitem);
        }
    }

    class ItemCheckerRepconItemJshfilename
    implements ItemChecker {
        ItemCheckerRepconItemJshfilename() {
        }

        @Override
        public boolean isTarget(Project theProject, Model theModel, Modelitem mitem, String name, String type) {
            return !AppSchemaUtil.isPrimaryKey(theModel, mitem.getName()) && TextSearchUtil.isModelitemForTextSearch(theProject, mitem) && !TextSearchUtil.isHiddenByPermissionWithCondition(mitem, theProject, theModel) && !TextSearchUtil.isHiddenOnShowList(mitem, theProject, theModel) && !mitem.getMultiple() && !mitem.getHasChild() && AppSchemaUtil.hasChildPart(mitem.getName()) && AppSchemaUtil.isJshfilename(name) && TextSearchUtil.isStringType(theProject, mitem);
        }
    }

    class ItemCheckerSingleItemJshfilename
    implements ItemChecker {
        ItemCheckerSingleItemJshfilename() {
        }

        @Override
        public boolean isTarget(Project theProject, Model theModel, Modelitem mitem, String name, String type) {
            return !AppSchemaUtil.isPrimaryKey(theModel, mitem.getName()) && TextSearchUtil.isModelitemForTextSearch(theProject, mitem) && !TextSearchUtil.isHiddenByPermissionWithCondition(mitem, theProject, theModel) && !TextSearchUtil.isHiddenOnShowList(mitem, theProject, theModel) && !mitem.getMultiple() && !mitem.getHasChild() && !AppSchemaUtil.hasChildPart(mitem.getName()) && AppSchemaUtil.isJshfilename(name) && TextSearchUtil.isStringType(theProject, mitem);
        }
    }
}

