/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.ClassnameConstant;
import jp.jasminesoft.jfc.gen.VariableValidator;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.ResourceManagerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VariableValidator_classname {
    protected static Logger logger = LogManager.getLogger(VariableValidator_classname.class);
    protected ResourceManager rman;
    private Project project;
    private Set<String> modelClassnameSet;

    public VariableValidator_classname(Project project) {
        this.project = project;
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
        this.modelClassnameSet = new HashSet<String>();
    }

    public void check(Model model) {
        IModelChoice[] imc;
        TreeSet<Object> classnameSet = new TreeSet<Object>(new IgnoreCaseStringComparator());
        classnameSet.addAll(Arrays.asList(ClassnameConstant.ReservedClassname));
        boolean isStoreModel = "store".equals(model.getType());
        String srcclassname = AppSchemaUtil.getClassname(model);
        Object classname = srcclassname;
        int cnt = 1;
        while (classnameSet.contains(classname) || isStoreModel && this.modelClassnameSet.contains(classname)) {
            classname = srcclassname + cnt;
            ++cnt;
        }
        if (!srcclassname.equals(classname)) {
            model.setClassname((String)classname);
            logger.debug(this.rman.getValue("validator.classname.model.change", (String)classname));
        }
        if (isStoreModel) {
            this.modelClassnameSet.add((String)classname);
        }
        classnameSet.add(classname);
        if ("store".equals(model.getType()) || "master".equals(model.getType()) || "total".equals(model.getType())) {
            classnameSet.add("RDomBuilder");
            classnameSet.add("RJDBCList");
            classnameSet.add("USQL");
        }
        if ((imc = model.getContent()) == null) {
            return;
        }
        for (int j = 0; j < imc.length; ++j) {
            if (!(imc[j] instanceof Modelitem)) continue;
            Modelitem mitem = (Modelitem)imc[j];
            srcclassname = AppSchemaUtil.getModelitemClassname(mitem);
            classname = srcclassname;
            cnt = 1;
            while (true) {
                if (!classnameSet.contains(classname)) break;
                classname = srcclassname + cnt;
                ++cnt;
            }
            classnameSet.add(classname);
            if (srcclassname.equals(classname)) continue;
            mitem.setClassname((String)classname);
            logger.debug(this.rman.getValue("validator.classname.modelitem.change", (String)classname));
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.exit(1);
        }
        VariableValidator vv = new VariableValidator(null);
        System.out.println(args[0] + " is " + VariableValidator.isValidId(args[0]));
    }

    private static class IgnoreCaseStringComparator
    implements Comparator {
        private IgnoreCaseStringComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((String)o1).compareToIgnoreCase((String)o2);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof IgnoreCaseStringComparator;
        }
    }
}

