/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.DbTypeManager;
import jp.jasminesoft.jfc.gen.TablenameGenerator;
import jp.jasminesoft.jfc.gen.appschema.Database;
import jp.jasminesoft.jfc.gen.appschema.Environment;
import jp.jasminesoft.jfc.gen.appschema.HibernateParameterModelitem;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IModelitemChoice;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.ResourceManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VariableValidator_database {
    protected static Logger logger = LogManager.getLogger(VariableValidator_database.class);
    private Project project;
    private Environment environment;
    private Database database;
    private HashSet<String> tablenameSet;
    private HashSet<String> indexnameSet;
    private HashMap<Model, String> model_oldtablename_map;
    private HashMap<Modelitem, String> modelitem_oldcolumnname_map;
    protected ResourceManager rman;

    public VariableValidator_database(Project project) {
        this.project = project;
        this.environment = project.getEnvironment();
        this.database = AppSchemaUtil.getDatabase(this.environment);
        this.tablenameSet = new HashSet();
        this.indexnameSet = new HashSet();
        this.model_oldtablename_map = new HashMap();
        this.modelitem_oldcolumnname_map = new HashMap();
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
    }

    public void check() {
        String mainmodelidref;
        String idref;
        Model model;
        String type;
        int i;
        IProjectChoice[] ipc = this.project.getContent();
        if (ipc == null) {
            return;
        }
        for (i = 0; i < ipc.length; ++i) {
            if (!(ipc[i] instanceof Model) || !(type = (model = (Model)ipc[i]).getType()).equals("store") && !type.equals("master")) continue;
            idref = model.getIdref();
            mainmodelidref = model.getMainmodelidref();
            if (idref != null && idref.length() > 0 || mainmodelidref != null && mainmodelidref.length() > 0) continue;
            this.check(model);
        }
        for (i = 0; i < ipc.length; ++i) {
            if (!(ipc[i] instanceof Model) || !(type = (model = (Model)ipc[i]).getType()).equals("store") && !type.equals("master")) continue;
            idref = model.getIdref();
            mainmodelidref = model.getMainmodelidref();
            if (idref != null && idref.length() > 0) {
                this.checkWithIdref(model);
                continue;
            }
            if (mainmodelidref == null || mainmodelidref.length() <= 0) continue;
            this.checkWithMainmodelidref(model);
        }
    }

    public void checkWithIdref(Model model) {
        Model refmodel = AppSchemaUtil.getModel(this.project, model.getIdref());
        if (refmodel == null) {
            Object[] o = new Object[]{model.getIdref(), model.getId()};
            logger.error(this.rman.getValue("validator.refmodel.null", o));
            return;
        }
        if (model.getTablename() == null) {
            model.setTablename(refmodel.getTablename());
        } else {
            String refmodel_old_tablename;
            String tablename = TablenameGenerator.createTableName(model);
            if (tablename.equals(refmodel_old_tablename = this.model_oldtablename_map.get(refmodel))) {
                tablename = refmodel.getTablename();
                model.setTablename(tablename);
                Object[] o = new Object[]{model.getId(), refmodel.getId(), tablename};
                logger.debug(this.rman.getValue("validator.tablename.invalid", o));
            } else {
                this.check(model);
                return;
            }
        }
        IModelChoice[] imc = model.getContent();
        if (imc == null) {
            return;
        }
        HashSet<String> columnnameSet = new HashSet<String>();
        ArrayList<Modelitem> modelitemList = new ArrayList<Modelitem>();
        for (int j = 0; j < imc.length; ++j) {
            HibernateParameterModelitem refhp;
            HibernateParameterModelitem hp;
            String refmitem_old_columnname;
            if (!(imc[j] instanceof Modelitem)) continue;
            Modelitem mitem = (Modelitem)imc[j];
            Modelitem refmitem = AppSchemaUtil.getModelitem(mitem.getName(), refmodel);
            if (refmitem == null) {
                Object[] o = new Object[]{refmodel.getId(), mitem.getName()};
                logger.error(this.rman.getValue("validator.refmodel.modelitem.null", o));
                continue;
            }
            String columnname = AppSchemaUtil.getProperColumnName(this.project, model, mitem);
            if (!columnname.equals(refmitem_old_columnname = this.modelitem_oldcolumnname_map.get(refmitem))) {
                modelitemList.add(mitem);
                continue;
            }
            columnname = refmitem.getRdbcolumnname();
            mitem.setRdbcolumnname(columnname);
            columnnameSet.add(columnname);
            String datatype = mitem.getRdbdatatype();
            String refdatatype = refmitem.getRdbdatatype();
            if (datatype != refdatatype) {
                if (datatype == null) {
                    mitem.setRdbdatatype(refdatatype);
                } else if (!datatype.equals(refdatatype)) {
                    mitem.setRdbdatatype(refdatatype);
                    Object[] o = new Object[]{model.getId(), refmodel.getId(), datatype};
                    logger.debug(this.rman.getValue("validator.refmodel.invalid.datatype", o));
                }
            }
            if ((hp = AppSchemaUtil.getHibernateParameterModelitem(mitem)) == (refhp = AppSchemaUtil.getHibernateParameterModelitem(refmitem))) continue;
            if (hp == null) {
                if (refhp == null) continue;
                mitem.addContent(refhp);
                continue;
            }
            if (hp.equals(refhp)) continue;
            Object[] o = new Object[]{model.getId(), refmodel.getId()};
            logger.debug(this.rman.getValue("validator.hibernateparam.invalid", o));
            mitem.removeContent(hp);
            if (refhp == null) continue;
            mitem.addContent(refhp);
        }
        IModelChoice[] imc2 = modelitemList.toArray(new IModelChoice[modelitemList.size()]);
        this.checkIModelChoices(model, imc2);
    }

    public void checkWithMainmodelidref(Model model) {
        int j;
        IRNode node = model.getMainmodelidrefAsIRNode();
        if (node == null || !(node instanceof Model)) {
            Object[] o = new Object[]{model.getMainmodelidref(), model.getId()};
            logger.error(this.rman.getValue("validator.mainmodel.null", o));
            return;
        }
        Model refmodel = (Model)model.getMainmodelidrefAsIRNode();
        model.setTablename(refmodel.getTablename());
        IModelChoice[] imc = model.getContent();
        this.checkIModelChoices(model, imc);
        PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(model, this.project);
        PrimaryKey[] refmodel_pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(refmodel, this.project);
        HashSet<String> pkeynameSet = new HashSet<String>();
        for (int j2 = 0; j2 < pkeys.length; ++j2) {
            pkeynameSet.add(pkeys[j2].getName());
        }
        HashSet<String> refmodel_pkeynameSet = new HashSet<String>();
        for (j = 0; j < refmodel_pkeys.length; ++j) {
            refmodel_pkeynameSet.add(refmodel_pkeys[j].getName());
        }
        if (!pkeynameSet.equals(refmodel_pkeynameSet)) {
            Object[] o = new Object[]{model.getId(), refmodel.getId()};
            logger.error(this.rman.getValue("validator.pkeymismatch.submodel", o));
        }
        for (j = 0; j < imc.length; ++j) {
            Relation _rel;
            Modelitem mitem;
            Modelitem refmodel_mitem;
            if (!(imc[j] instanceof Modelitem) || (refmodel_mitem = AppSchemaUtil.getModelitem((mitem = (Modelitem)imc[j]).getName(), refmodel)) != null || (_rel = AppSchemaUtil.getRelationTypeIsRef(mitem)) != null && "refmodel".equals(_rel.getRefstoretype()) || mitem.getTransient()) continue;
            Object[] o = new Object[]{mitem.getName(), model.getId(), refmodel.getId()};
            logger.error(this.rman.getValue("validator.modelitem.null.submodel", o));
        }
    }

    public void check(Model model) {
        String tablename_new;
        boolean isquote = VariableValidator_database.isQuote(model, this.database);
        String tablename = TablenameGenerator.createTableName(model);
        if (model.getCreatetable() && !tablename.equals(tablename_new = this.createUniqueTablename(tablename, isquote))) {
            model.setTablename(tablename_new);
            Object[] o = new Object[]{tablename, tablename_new, model.getId()};
            logger.info(this.rman.getValue("validator.tablename.change", o));
        }
        this.model_oldtablename_map.put(model, tablename);
        IModelChoice[] imc = model.getContent();
        this.checkIModelChoices(model, imc);
    }

    private void checkIModelChoices(Model model, IModelChoice[] imc) {
        if (imc == null || imc.length == 0) {
            return;
        }
        HashSet<String> columnnameSet = new HashSet<String>();
        HashMap<String, String> olduniquekey_map = new HashMap<String, String>();
        HashMap<String, Set<String>> uniquekey_mitemname_map = new HashMap<String, Set<String>>();
        for (int j = 0; j < imc.length; ++j) {
            if (imc[j] instanceof PrimaryKey) {
                this.checkPrimaryKey(model, (PrimaryKey)imc[j]);
                continue;
            }
            if (!(imc[j] instanceof Modelitem)) continue;
            Modelitem mitem = (Modelitem)imc[j];
            this.checkModelitem(model, mitem, columnnameSet, olduniquekey_map, uniquekey_mitemname_map);
        }
    }

    private void checkModelitem(Model model, Modelitem mitem, HashSet<String> columnnameSet, HashMap<String, String> olduniquekey_map, HashMap<String, Set<String>> uniquekey_mitemname_map) {
        String storage = model.getStorage();
        int storagetype = AppSchemaUtil.getStorageType(storage);
        if (storagetype == 0) {
            this.checkModelitem_jdbc(model, mitem, columnnameSet, olduniquekey_map, uniquekey_mitemname_map);
        } else if (storagetype == 5) {
            this.checkModelitem_hibernate(model, mitem, columnnameSet, olduniquekey_map, uniquekey_mitemname_map);
        }
    }

    public static boolean isQuote(Model model, Database database) {
        if (!model.getUseQuoteid()) {
            return false;
        }
        String storage = model.getStorage();
        int storagetype = AppSchemaUtil.getStorageType(storage);
        return VariableValidator_database.isQuote(storagetype, database);
    }

    public static boolean isQuote(int storagetype, Database database) {
        String quoteid = null;
        if (storagetype == 0) {
            quoteid = database.getQuoteid();
        } else if (storagetype == 5) {
            quoteid = database.getQuoteidForHibernate();
        }
        boolean isquote = false;
        if (quoteid != null && quoteid.length() > 0) {
            isquote = true;
        }
        return isquote;
    }

    private void checkPrimaryKey(Model model, PrimaryKey pkey) {
        String tablename_footer;
        String tablename_header;
        int seqstoragetype = DbTypeManager.getSequenceStorageType(this.environment, model);
        if (seqstoragetype != 1) {
            return;
        }
        boolean isquote = VariableValidator_database.isQuote(0, this.database);
        String mainmodelidref = model.getMainmodelidref();
        if (mainmodelidref != null && mainmodelidref.length() > 0) {
            IRNode node = model.getMainmodelidrefAsIRNode();
            if (node == null || !(node instanceof Model)) {
                Object[] o = new Object[]{model.getMainmodelidref(), model.getId()};
                logger.error(this.rman.getValue("validator.mainmodel.null", o));
                return;
            }
            Model refmodel = (Model)model.getMainmodelidrefAsIRNode();
            PrimaryKey refpkey = null;
            IModelChoice[] refimc = refmodel.getContent();
            if (refimc == null) {
                return;
            }
            for (int j = 0; j < refimc.length; ++j) {
                if (!(refimc[j] instanceof PrimaryKey)) continue;
                refpkey = (PrimaryKey)refimc[j];
                if (pkey.getName().equals(refpkey.getName())) break;
                refpkey = null;
            }
            if (refpkey == null) {
                Object[] o = new Object[]{model.getMainmodelidref(), pkey.getName(), model.getId()};
                logger.error(this.rman.getValue("validator.pkey.null.mainmodel", o));
                return;
            }
            pkey.setUseseq(refpkey.getUseseq());
            return;
        }
        String tablename = pkey.getUseseq();
        if (tablename == null) {
            return;
        }
        String sequence_footer = "_seq";
        if (tablename.endsWith("_seq")) {
            tablename_header = tablename.substring(0, tablename.length() - "_seq".length());
            tablename_footer = "_seq";
        } else {
            tablename_header = tablename;
            tablename_footer = "";
        }
        String tablename_new = this.createUniqueTablename(tablename_header, tablename_footer, isquote);
        if (!tablename.equals(tablename_new)) {
            pkey.setUseseq(tablename_new);
            Object[] o = new Object[]{tablename, tablename_new, model.getId()};
            logger.info(this.rman.getValue("validator.seq.change", o));
        }
    }

    private void checkModelitem_common(Model model, Modelitem mitem, HashSet<String> columnnameSet, HashMap<String, String> olduniquekey_map, HashMap<String, Set<String>> uniquekey_mitemname_map) {
        String mainmodelidref = model.getMainmodelidref();
        if (mainmodelidref != null && mainmodelidref.length() > 0) {
            Relation _rel;
            IRNode node = model.getMainmodelidrefAsIRNode();
            if (node == null || !(node instanceof Model)) {
                Object[] o = new Object[]{model.getMainmodelidref(), model.getId()};
                logger.error(this.rman.getValue("validator.mainmodel.null", o));
                return;
            }
            Model refmodel = (Model)model.getMainmodelidrefAsIRNode();
            Modelitem refmitem = AppSchemaUtil.getModelitem(mitem.getName(), refmodel);
            if (!(refmitem != null || (_rel = AppSchemaUtil.getRelationTypeIsRef(mitem)) != null && "refmodel".equals(_rel.getRefstoretype()) || mitem.getTransient())) {
                Object[] o = new Object[]{mitem.getName(), model.getId(), refmodel.getId()};
                logger.error(this.rman.getValue("validator.modelitem.null.submodel", o));
                return;
            }
            if (!mitem.getTransient() && refmitem != null) {
                mitem.setRdbcolumnname(refmitem.getRdbcolumnname());
            }
        } else {
            boolean isquote;
            String columnname_new;
            String columnname = AppSchemaUtil.getProperColumnName(this.project, model, mitem);
            if (!(mitem.getAutokey() && AppSchemaUtil.hasChildPart(mitem.getName()) && columnnameSet.contains(mitem.getRdbcolumnname()) || StringUtils.isNotBlank((CharSequence)columnname) && columnname.startsWith("__jfc_formula=") || columnname.equals(columnname_new = this.createUniqueColumnname(columnname, isquote = VariableValidator_database.isQuote(model, this.database), columnnameSet)))) {
                mitem.setRdbcolumnname(columnname_new);
                Object[] o = new Object[]{columnname, columnname_new, model.getId()};
                logger.info(this.rman.getValue("validator.columnname.change", o));
            }
            this.modelitem_oldcolumnname_map.put(mitem, columnname);
        }
        String datatype = mitem.getRdbdatatype();
        if (StringUtils.isNotBlank((CharSequence)datatype)) {
            if ("jshparam:MaxLengthString".equals(datatype)) {
                datatype = DbTypeManager.getMaxLengthStringDataType(this.environment);
            } else if ("jshparam:CharacterLargeObject".equals(datatype)) {
                datatype = DbTypeManager.getCharacterLargeObjectDataType(this.environment);
            }
            mitem.setRdbdatatype(datatype);
        }
        this.checkUniqueKeys(model, mitem, olduniquekey_map, uniquekey_mitemname_map);
    }

    private void checkUniqueKeys(Model model, Modelitem mitem, HashMap<String, String> olduniquekey_map, HashMap<String, Set<String>> uniquekey_mitemname_map) {
        String uniquekeys = mitem.getUniqueKey();
        if (!StringUtils.isNotBlank((CharSequence)uniquekeys)) {
            return;
        }
        String containername = AppSchemaUtil.hasChildPart(mitem.getName()) ? AppSchemaUtil.getParentPart(mitem.getName()) : "";
        String uniquekeys_new = Stream.of(uniquekeys.split(",")).map(uniquekey -> this.checkUniqueKey(model, mitem, olduniquekey_map, uniquekey_mitemname_map, containername, (String)uniquekey)).collect(Collectors.joining(",")).trim();
        mitem.setUniqueKey(uniquekeys_new);
    }

    private String checkUniqueKey(Model model, Modelitem mitem, HashMap<String, String> olduniquekey_map, HashMap<String, Set<String>> uniquekey_mitemname_map, String containername, String uniquekey) {
        String uniquekey_new;
        if (olduniquekey_map.containsKey(uniquekey)) {
            uniquekey_new = olduniquekey_map.get(uniquekey);
        } else {
            boolean isquote = VariableValidator_database.isQuote(model, this.database);
            uniquekey_new = this.createUniqueIndexname(uniquekey, isquote);
            if (!uniquekey.equals(uniquekey_new)) {
                Object[] o = new Object[]{uniquekey, uniquekey_new, model.getId()};
                logger.info(this.rman.getValue("validator.uniquekey.change", o));
            }
            olduniquekey_map.put(uniquekey, uniquekey_new);
        }
        Set<String> mitemnameset = uniquekey_mitemname_map.get(uniquekey_new);
        if (mitemnameset == null) {
            mitemnameset = new HashSet<String>();
            uniquekey_mitemname_map.put(uniquekey_new, mitemnameset);
        }
        for (String mitemname : mitemnameset) {
            String cname = AppSchemaUtil.hasChildPart(mitemname) ? AppSchemaUtil.getParentPart(mitemname) : "";
            if (containername.equals(cname)) continue;
            Object[] o = new Object[]{mitemname, uniquekey_new, mitem.getName(), model.getId()};
            logger.error(this.rman.getValue("validator.uniquekey.duplicate_container", o));
        }
        mitemnameset.add(mitem.getName());
        return uniquekey_new;
    }

    private void checkModelitem_jdbc(Model model, Modelitem mitem, HashSet<String> columnnameSet, HashMap<String, String> olduniquekey_map, HashMap<String, Set<String>> uniquekey_mitemname_map) {
        this.checkModelitem_common(model, mitem, columnnameSet, olduniquekey_map, uniquekey_mitemname_map);
    }

    private void checkModelitem_hibernate(Model model, Modelitem mitem, HashSet<String> columnnameSet, HashMap<String, String> olduniquekey_map, HashMap<String, Set<String>> uniquekey_mitemname_map) {
        Object[] o;
        this.checkModelitem_common(model, mitem, columnnameSet, olduniquekey_map, uniquekey_mitemname_map);
        String mainmodelidref = model.getMainmodelidref();
        if (mainmodelidref != null && mainmodelidref.length() > 0) {
            Relation _rel;
            IRNode node = model.getMainmodelidrefAsIRNode();
            if (node == null || !(node instanceof Model)) {
                Object[] o2 = new Object[]{model.getMainmodelidref(), model.getId()};
                logger.error(this.rman.getValue("validator.mainmodel.null", o2));
                return;
            }
            Model refmodel = (Model)model.getMainmodelidrefAsIRNode();
            Modelitem refmitem = AppSchemaUtil.getModelitem(mitem.getName(), refmodel);
            if (!(refmitem != null || (_rel = AppSchemaUtil.getRelationTypeIsRef(mitem)) != null && "refmodel".equals(_rel.getRefstoretype()) || mitem.getTransient())) {
                Object[] o3 = new Object[]{mitem.getName(), model.getId(), refmodel.getId()};
                logger.error(this.rman.getValue("validator.modelitem.null.submodel", o3));
                return;
            }
            if (!mitem.getTransient() && refmitem != null) {
                HibernateParameterModelitem refhp = AppSchemaUtil.getHibernateParameterModelitem(refmitem);
                IModelitemChoice[] imic = mitem.getContent();
                for (int i = 0; i < imic.length; ++i) {
                    if (!(imic[i] instanceof HibernateParameterModelitem)) continue;
                    mitem.removeContent((HibernateParameterModelitem)imic[i]);
                }
                if (refhp != null) {
                    mitem.addContent(refhp);
                }
            }
            return;
        }
        boolean isquote = VariableValidator_database.isQuote(model, this.database);
        HibernateParameterModelitem hp = AppSchemaUtil.getHibernateParameterModelitem(mitem);
        if (hp == null) {
            hp = new HibernateParameterModelitem();
            mitem.addContent(hp);
        }
        if (mitem.getHasChild() || mitem.getMultiple() || AppSchemaUtil.isCheckRelation(mitem)) {
            String list_tablename_orig = hp.getListTablename();
            String list_tablename = list_tablename_orig;
            if (list_tablename == null) {
                String tablename = TablenameGenerator.createTableName(model);
                String mitemname = mitem.getName();
                String footer = "$" + mitemname.replace('/', '$');
                list_tablename = this.getDbname(tablename, footer, isquote);
            }
            if (!model.getCreatetable()) {
                if (list_tablename_orig == null) {
                    hp.setListTablename(list_tablename);
                }
            } else {
                String list_tablename_new = this.createUniqueTablename(list_tablename, isquote);
                if (list_tablename_orig == null) {
                    hp.setListTablename(list_tablename_new);
                    o = new Object[]{list_tablename_new, model.getId()};
                    logger.debug(this.rman.getValue("validator.tablename.set", o));
                } else if (!list_tablename_orig.equals(list_tablename_new)) {
                    hp.setListTablename(list_tablename_new);
                    o = new Object[]{list_tablename_orig, list_tablename_new, model.getId()};
                    logger.info(this.rman.getValue("validator.tablename.change", o));
                }
            }
        }
        if (mitem.getHasChild() || mitem.getMultiple() || AppSchemaUtil.isCheckRelation(mitem)) {
            String list_index_columnname_orig = hp.getListIndexColumnname();
            String list_index_columnname = list_index_columnname_orig;
            if (list_index_columnname == null) {
                Modelitem cont_jshid_mitem_def;
                list_index_columnname = AppSchemaUtil.getProperColumnName(this.project, model, mitem);
                list_index_columnname = mitem.getHasChild() ? ((cont_jshid_mitem_def = AppSchemaUtil.getContainerAutokeyModelitem(mitem.getName(), model)) != null ? this.getDbname(cont_jshid_mitem_def.getRdbcolumnname(), "", isquote) : this.getDbname(list_index_columnname, "jshid", isquote)) : this.getDbname(list_index_columnname, "jshid", isquote);
            }
            String list_index_columnname_new = this.createUniqueColumnname(list_index_columnname, isquote, columnnameSet);
            if (list_index_columnname_orig == null) {
                hp.setListIndexColumnname(list_index_columnname_new);
                o = new Object[]{list_index_columnname_new, model.getId()};
                logger.debug(this.rman.getValue("validator.indexcolumnname.set", o));
            } else if (!list_index_columnname_orig.equals(list_index_columnname_new) && hp.getListIndexColumnameDuplicatecheck()) {
                hp.setListIndexColumnname(list_index_columnname_new);
                o = new Object[]{list_index_columnname_orig, list_index_columnname_new, model.getId()};
                logger.info(this.rman.getValue("validator.indexcolumnname.change", o));
            }
        }
    }

    private String createUniqueTablename(String tablename, boolean isquote) {
        return this.createUniqueTablename(tablename, "", isquote);
    }

    private String createUniqueTablename(String tablename, String tablename_footer, boolean isquote) {
        String encoding = DbTypeManager.getDatabaseCharEncoding(this.environment);
        int length = DbTypeManager.getMaxTableNameLength(this.environment);
        return VariableValidator_database.createUniqueName(tablename, tablename_footer, length, encoding, isquote, this.tablenameSet, this.rman, logger);
    }

    private String createUniqueColumnname(String columnname, boolean isquote, HashSet<String> columnnameSet) {
        String encoding = DbTypeManager.getDatabaseCharEncoding(this.environment);
        int length = DbTypeManager.getMaxColumnNameLength(this.environment);
        return VariableValidator_database.createUniqueName(columnname, "", length, encoding, isquote, columnnameSet, this.rman, logger);
    }

    private String createUniqueIndexname(String indexname, boolean isquote) {
        String encoding = DbTypeManager.getDatabaseCharEncoding(this.environment);
        int length = DbTypeManager.getMaxIndexNameLength(this.environment);
        return VariableValidator_database.createUniqueName(indexname, "", length, encoding, isquote, this.indexnameSet, this.rman, logger);
    }

    public static String createUniqueName(String name, String name_footer, int length, String encoding, boolean isquote, HashSet<String> nameset, ResourceManager rman, Logger logger) {
        return VariableValidator_database.createUniqueName(name, name_footer, length, encoding, isquote, nameset, rman, logger, true);
    }

    public static String createUniqueName(String name, String name_footer, int length, String encoding, boolean isquote, HashSet<String> nameset, ResourceManager rman, Logger logger, boolean isconvert) {
        String name_new = VariableValidator_database.checkNameLength(name, name_footer, length, encoding, rman, logger);
        String name_cmp = isquote ? name_new : name_new.toUpperCase();
        if (isconvert) {
            int cnt = 0;
            while (nameset.contains(name_cmp)) {
                String name_footer_new = Integer.toString(++cnt) + name_footer;
                name_new = VariableValidator_database.checkNameLength(name, name_footer_new, length, encoding, rman, logger);
                if (isquote) {
                    name_cmp = name_new;
                    continue;
                }
                name_cmp = name_new.toUpperCase();
            }
        }
        nameset.add(name_cmp);
        return name_new;
    }

    public static String checkNameLength(String name_header, String name_footer, int length, String encoding, ResourceManager rman, Logger logger) {
        int strlen;
        int maxbalen;
        byte[] ba;
        String default_encoding = "UTF-8";
        String name = name_header + name_footer;
        try {
            ba = name.getBytes(encoding);
            maxbalen = ba.length;
            if (maxbalen <= length) {
                return name;
            }
            ba = "".getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            if (encoding.equals("UTF-8")) {
                if (rman != null && logger != null) {
                    Object[] o = new Object[]{encoding, e};
                    logger.error(rman.getValue("validator.database.encoding.unsupported", o));
                }
                return name;
            }
            if (rman != null && logger != null) {
                Object[] o = new Object[]{encoding, "UTF-8", e};
                logger.error(rman.getValue("validator.database.encoding.usedefault", o));
            }
            return VariableValidator_database.checkNameLength(name_header, name_footer, length, "UTF-8", rman, logger);
        }
        int minstrlen = 0;
        int maxstrlen = name_header.length();
        do {
            block13: {
                strlen = minstrlen + (maxstrlen - minstrlen) / 2;
                name = name_header.substring(0, strlen) + name_footer;
                try {
                    ba = name.getBytes(encoding);
                }
                catch (UnsupportedEncodingException e) {
                    if (encoding.equals("UTF-8")) {
                        if (rman != null && logger != null) {
                            Object[] o = new Object[]{encoding, e};
                            logger.error(rman.getValue("validator.database.encoding.unsupported", o));
                        }
                        return name;
                    }
                    if (rman == null || logger == null) break block13;
                    Object[] o = new Object[]{encoding, "UTF-8", e};
                    logger.error(rman.getValue("validator.database.encoding.usedefault", o));
                    return VariableValidator_database.checkNameLength(name_header, name_footer, length, encoding, rman, logger);
                }
            }
            int balen = ba.length;
            if (balen == length) {
                return name;
            }
            if (balen > length) {
                maxbalen = balen;
                maxstrlen = strlen;
                continue;
            }
            minstrlen = strlen;
        } while (maxstrlen - minstrlen > 1);
        strlen = minstrlen + (maxstrlen - minstrlen) / 2;
        return name_header.substring(0, strlen) + name_footer;
    }

    private String getDbname(String name, String footer, boolean isquote) {
        if (isquote) {
            if (footer != null) {
                name = (String)name + footer;
            }
            return name;
        }
        char quoteforce = this.removeQuote((String)name);
        if (quoteforce != '\u0000') {
            int namelen = ((String)name).length();
            name = ((String)name).substring(1, namelen - 1);
            if (footer != null) {
                name = (String)name + footer;
            }
            String namewithquote = quoteforce + (String)name + quoteforce;
            return namewithquote;
        }
        if (footer != null) {
            name = (String)name + footer;
        }
        return name;
    }

    private char removeQuote(String name) {
        char[] quotelist = new char[]{'\"', '\'', '`'};
        int namelen = name.length();
        if (namelen < 3) {
            return '\u0000';
        }
        char startchar = name.charAt(0);
        char endchar = name.charAt(namelen - 1);
        for (int i = 0; i < quotelist.length; ++i) {
            char quote = quotelist[i];
            if (startchar != quote || endchar != quote) continue;
            return quote;
        }
        return '\u0000';
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.exit(1);
        }
    }
}

