/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jp.jasminesoft.jfc.gen.ConfigGenerator;
import jp.jasminesoft.jfc.gen.WebXmlUtils;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.FileTemplateManager;
import jp.jasminesoft.util.StringUtil;
import jp.jasminesoft.util.VelocityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WebXmlGenerator
extends ConfigGenerator {
    protected static Logger logger = LogManager.getLogger(WebXmlGenerator.class);
    private boolean isFullBuild;

    public WebXmlGenerator(String tmplatefilename, Project project, boolean isFullBuild) {
        super(tmplatefilename, project);
        this.isFullBuild = isFullBuild;
    }

    @Override
    public String getFileSuffix() {
        return ".xml";
    }

    @Override
    public String getFilename() {
        return "web";
    }

    @Override
    public String getSubpackageName() {
        return "webpage" + File.separator + "WEB-INF";
    }

    @Override
    public String process0() {
        FileTemplateManager tplman = new FileTemplateManager(this.tmplatefilename);
        if (!tplman.isValid()) {
            return "";
        }
        WebXmlUtils wxutils = new WebXmlUtils(this.project, this.isFullBuild);
        Map<String, Object> templateMap = wxutils.createTemplateMap();
        for (Map.Entry<String, Object> e : templateMap.entrySet()) {
            if (!(e.getValue() instanceof String)) continue;
            tplman.addContent(e.getKey(), (String)e.getValue());
        }
        Map ctxparamMap = (Map)templateMap.get("contextParamMap");
        tplman.addContent("context-param", this.createContextParamString(ctxparamMap));
        Map paramMap = (Map)templateMap.get("paramMap");
        StringBuilder sb = new StringBuilder();
        StringBuilder sbContentParamSpringMVC = new StringBuilder();
        this.createInitParamString(paramMap, sb, sbContentParamSpringMVC);
        tplman.addContent("initparam", sb.toString());
        tplman.addContent("context-param-sprinvmvc", sbContentParamSpringMVC.toString());
        HashSet<String> listenerSet = new HashSet<String>();
        if (templateMap.get("hsqldbListener") != null) {
            listenerSet.add(this.createHsqldbListener());
        }
        if (templateMap.get("contextLoaderListener") != null) {
            listenerSet.add(this.createContextLoaderListener());
        }
        tplman.addContent("listener", this.getCode(listenerSet));
        if (templateMap.get("CASFilterForLDAP") != null) {
            Map settingMap = (Map)templateMap.get("CASFilterForLDAPSetting");
            tplman.addContent("filter", this.getCASFilterCodeForLDAP(settingMap));
        } else {
            tplman.addContent("filter", "");
        }
        if (templateMap.get("conint_enable") != null) {
            tplman.addContent("conint_comment_begin", "");
            tplman.addContent("conint_comment_end", "");
        } else {
            tplman.addContent("conint_comment_begin", "<!--");
            tplman.addContent("conint_comment_end", "-->");
        }
        if (templateMap.get("maketextindexservlet_enable") != null) {
            tplman.addContent("maketextindexservlet_comment_begin", "");
            tplman.addContent("maketextindexservlet_comment_end", "");
        } else {
            tplman.addContent("maketextindexservlet_comment_begin", "<!--");
            tplman.addContent("maketextindexservlet_comment_end", "-->");
        }
        if (templateMap.get("browserCacheMaxAge_enable") != null) {
            tplman.addContent("browserCacheMaxAge_comment_begin", "");
            tplman.addContent("browserCacheMaxAge_comment_end", "");
        } else {
            tplman.addContent("browserCacheMaxAge_comment_begin", "<!--");
            tplman.addContent("browserCacheMaxAge_comment_end", "-->");
        }
        return tplman.getResult();
    }

    private void createInitParamString(Map<String, String> paramMap, StringBuilder sb, StringBuilder sbContentParamSpringMVC) {
        Set<String> keySet = paramMap.keySet();
        int size = keySet.size();
        int count = 0;
        for (String key : keySet) {
            String value = paramMap.get(key);
            sb.append("    ");
            sb.append("<init-param>");
            sb.append(CR);
            sb.append("      ");
            sb.append("<param-name>");
            sb.append(key);
            sb.append("</param-name>");
            sb.append(CR);
            sb.append("      ");
            sb.append("<param-value>");
            sb.append(value);
            sb.append("</param-value>");
            sb.append(CR);
            sb.append("    ");
            sb.append("</init-param>");
            sbContentParamSpringMVC.append("    ");
            sbContentParamSpringMVC.append("<context-param>");
            sbContentParamSpringMVC.append(CR);
            sbContentParamSpringMVC.append("      ");
            sbContentParamSpringMVC.append("<param-name>");
            sbContentParamSpringMVC.append(key);
            sbContentParamSpringMVC.append("</param-name>");
            sbContentParamSpringMVC.append(CR);
            sbContentParamSpringMVC.append("      ");
            sbContentParamSpringMVC.append("<param-value>");
            sbContentParamSpringMVC.append(value);
            sbContentParamSpringMVC.append("</param-value>");
            sbContentParamSpringMVC.append(CR);
            sbContentParamSpringMVC.append("    ");
            sbContentParamSpringMVC.append("</context-param>");
            if (++count >= size) continue;
            sb.append(CR);
            sbContentParamSpringMVC.append(CR);
        }
    }

    private String createContextParamString(Map<String, String> ctxparamMap) {
        StringBuilder sb = new StringBuilder();
        Set<String> keySet = ctxparamMap.keySet();
        int size = keySet.size();
        int count = 0;
        for (String key : keySet) {
            String value = ctxparamMap.get(key);
            sb.append("  ");
            sb.append("<context-param>");
            sb.append(CR);
            sb.append("    ");
            sb.append("<param-name>");
            sb.append(StringUtil.escapeStringForXML((String)key));
            sb.append("</param-name>");
            sb.append(CR);
            sb.append("    ");
            sb.append("<param-value>");
            sb.append(StringUtil.escapeStringForXML((String)value));
            sb.append("</param-value>");
            sb.append(CR);
            sb.append("  ");
            sb.append("</context-param>");
            if (++count >= size) continue;
            sb.append(CR);
        }
        return sb.toString();
    }

    String getCASFilterCodeForLDAP(Map<String, Object> m) {
        return VelocityUtils.mergeContent((String)"template/cas_client/web_xml_filter.vm", m);
    }

    protected String createContextLoaderListener() {
        StringBuilder sb = new StringBuilder();
        sb.append("  ");
        sb.append("<!-- for Spring Framework -->");
        sb.append(CR);
        sb.append("  ");
        sb.append("<listener>");
        sb.append(CR);
        sb.append("    ");
        sb.append("<listener-class>org.springframework.web.context.ContextLoaderListener</listener-class>");
        sb.append(CR);
        sb.append("  ");
        sb.append("</listener>");
        sb.append(CR);
        sb.append("  ");
        sb.append("<listener>");
        sb.append(CR);
        sb.append("    ");
        sb.append("<listener-class>org.springframework.web.context.request.RequestContextListener</listener-class>");
        sb.append(CR);
        sb.append("  ");
        sb.append("</listener>");
        return sb.toString();
    }

    protected String createHsqldbListener() {
        StringBuilder sb = new StringBuilder();
        sb.append("  ");
        sb.append("<!-- for shutdown hsqldb -->");
        sb.append(CR);
        sb.append("  ");
        sb.append("<listener>");
        sb.append(CR);
        sb.append("    ");
        sb.append("<listener-class>jp.jasminesoft.jfc.HsqldbServletContextListener</listener-class>");
        sb.append(CR);
        sb.append("  ");
        sb.append("</listener>");
        return sb.toString();
    }

    private String getCode(Collection<String> collection) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = collection.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            sb.append(CR);
        }
        return sb.toString();
    }
}

