/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CompatibilityManager;
import jp.jasminesoft.jfc.gen.JFCAppResourceGenerator;
import jp.jasminesoft.jfc.gen.JavaScriptManager;
import jp.jasminesoft.jfc.gen.JavaScriptManagerFactory;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.JspPanelContentBase;
import jp.jasminesoft.jfc.gen.TabBuffer;
import jp.jasminesoft.jfc.gen.XslElementNameManager;
import jp.jasminesoft.jfc.gen.XslGenerator_showList;
import jp.jasminesoft.jfc.gen.XslSourceGenerator;
import jp.jasminesoft.jfc.gen.XslTagGenerator;
import jp.jasminesoft.jfc.gen.XslTagGeneratorFactory;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Displaycondition;
import jp.jasminesoft.jfc.gen.appschema.Displayimage;
import jp.jasminesoft.jfc.gen.appschema.Displayitem;
import jp.jasminesoft.jfc.gen.appschema.Displayitemgroup;
import jp.jasminesoft.jfc.gen.appschema.Displaymodel;
import jp.jasminesoft.jfc.gen.appschema.Displaymodelgroup;
import jp.jasminesoft.jfc.gen.appschema.Displaytext;
import jp.jasminesoft.jfc.gen.appschema.IDisplayconditionChoice;
import jp.jasminesoft.jfc.gen.appschema.IDisplayitemgroupChoice;
import jp.jasminesoft.jfc.gen.appschema.IDisplaymodelChoice;
import jp.jasminesoft.jfc.gen.appschema.IDisplaymodelgroupChoice;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IPanelChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Layout;
import jp.jasminesoft.jfc.gen.appschema.Link;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Panel;
import jp.jasminesoft.jfc.gen.appschema.Presentation;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.util.FileTemplateManager;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.ResourceManagerFactory;
import jp.jasminesoft.util.StringUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class XslGenerator
extends XslSourceGenerator {
    protected Presentation presentation;
    protected Displaymodel displaymodel;
    protected Model pmodel;
    protected String idref;
    protected Logger logger = LogManager.getLogger((String)XslGenerator.class.getName());
    protected ResourceManager rman;
    protected JavaScriptManager jsman;
    protected XslElementNameManager xslnman;
    protected List<Displayitem> hiddenlist;
    protected Map<String, String> attrNameMap;
    protected XslTagGenerator xtgen;

    public XslGenerator(Project project, Action action, Presentation presentation, Model pmodel, String idref, Displaymodel displaymodel) {
        super(project, action);
        this.presentation = presentation;
        this.displaymodel = displaymodel;
        this.pmodel = pmodel;
        this.idref = idref;
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
        if (action != null) {
            this.jsman = JavaScriptManagerFactory.getInstance(project, presentation, action);
        } else if (idref != null) {
            this.jsman = JavaScriptManagerFactory.getInstance(project, presentation, idref);
        }
        this.xslnman = XslElementNameManager.getInstance();
        this.hiddenlist = new ArrayList<Displayitem>();
        this.attrNameMap = new HashMap<String, String>();
        this.attrNameMap.put("valueClass", "class");
        this.attrNameMap.put("labelClass", "class");
        this.attrNameMap = Collections.unmodifiableMap(this.attrNameMap);
        this.xtgen = XslTagGeneratorFactory.newInstance(project);
    }

    @Override
    public String process0() {
        TabBuffer sb = new TabBuffer();
        sb.setIndentSize(2);
        this.gHeader(sb);
        this.gBody(sb);
        this.gFinish(sb);
        return sb.toString();
    }

    public String gElemTag(String elemname) {
        return this.xtgen.gElemTag(elemname);
    }

    public String gAttrTag(String attrname) {
        return this.xtgen.gAttrTag(attrname);
    }

    public String gAttrTag(String attrname, int value) {
        return this.xtgen.gAttrTag(attrname, value);
    }

    public final String gAttrTag(String attrname, String value) {
        return this.xtgen.gAttrTag(attrname, value);
    }

    protected String comment(String comment) {
        return this.comment(comment, true);
    }

    protected String comment(String comment, boolean b) {
        if (!this.project.getDebug()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<!-- ");
        if (b) {
            sb.append(this.getClass().getName() + "::");
        }
        sb.append(comment);
        sb.append(" -->");
        return sb.toString();
    }

    @Override
    public String getEncoding() {
        return "UTF-8";
    }

    protected void gHeader(TabBuffer sb) {
        String enc = JavaSourceGenerator.getWebEncoding(this.project);
        Model model = AppSchemaUtil.getStoreModel(this.pmodel);
        CompatibilityManager compatibilityManager = CompatibilityManager.getInstance();
        Object _key = "jp.jasminesoft.jfc.gen.XslGenerator_showTotal2.useCache";
        _key = (String)_key + "." + model.getId();
        boolean _useCache = compatibilityManager.getBooleanValue((String)_key);
        sb.append("<?xml version=\"1.0\" encoding=\"");
        sb.append(this.getEncoding());
        sb.append("\" ?>");
        sb.cr();
        sb.append(this.comment("gHeader"));
        sb.append_cr("<xsl:stylesheet version=\"1.0\"");
        sb.append_cr("                xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"");
        sb.append_cr("                xmlns:lxslt=\"http://xml.apache.org/xslt\"");
        sb.append_cr("                xmlns:jfcutils=\"JFCUtils\"");
        sb.append_cr("                xmlns:dtutils=\"DateTimeUtil\"");
        sb.append_cr("                xmlns:xmlutils=\"XMLUtil\"");
        sb.append_cr("                extension-element-prefixes=\"jfcutils dtutils xmlutils\">");
        sb.append_cr("<lxslt:component prefix=\"jfcutils\"");
        sb.append_cr("                 functions=\"encodePrimaryKey\">");
        sb.append_cr("  <lxslt:script lang=\"javaclass\" src=\"xalan://jp.jasminesoft.jfc.JFCUtils\"/>");
        sb.append_cr("</lxslt:component>");
        sb.append_cr("<lxslt:component prefix=\"jfcutils\"");
        sb.append_cr("                 functions=\"getRValue\">");
        sb.append_cr("  <lxslt:script lang=\"javaclass\" src=\"xalan://jp.jasminesoft.jfc.JFCUtils\"/>");
        sb.append_cr("</lxslt:component>");
        sb.append_cr("<lxslt:component prefix=\"dtutils\"");
        sb.append_cr("                 functions=\"parseDate\">");
        sb.append_cr("  <lxslt:script lang=\"javaclass\" src=\"xalan://jp.jasminesoft.util.DateTimeUtil\"/>");
        sb.append_cr("</lxslt:component>");
        if (_useCache) {
            sb.append_cr("<lxslt:component prefix=\"xmlutils\"");
            sb.append_cr("                 functions=\"count\">");
            sb.append_cr("  <lxslt:script lang=\"javaclass\" src=\"xalan://jp.jasminesoft.util.XMLUtil\"/>");
            sb.append_cr("</lxslt:component>");
            sb.append_cr("<lxslt:component prefix=\"xmlutils\"");
            sb.append_cr("                 functions=\"sum\">");
            sb.append_cr("  <lxslt:script lang=\"javaclass\" src=\"xalan://jp.jasminesoft.util.XMLUtil\"/>");
            sb.append_cr("</lxslt:component>");
        }
        this.gHeader_option(sb);
        sb.append("<xsl:output indent=\"yes\" method=\"html\" ");
        sb.append("encoding=\"");
        sb.append(enc);
        sb.append("\"/>");
        sb.cr();
        sb.append("<xsl:param name=\"__jfc_locale\"/>");
        sb.cr();
        this.gHeader_option2(sb);
    }

    protected void gHeader_option(TabBuffer sb) {
    }

    protected void gHeader_option2(TabBuffer sb) {
    }

    protected abstract String getActionType();

    protected String getFilenamePrefix() {
        return this.getActionType();
    }

    @Override
    public String getFilename() {
        String filename = XslGenerator.getXsltFilename(this.getFilenamePrefix(), this.idref, this.displaymodel);
        if (filename.endsWith(".xsl")) {
            filename = filename.substring(0, filename.length() - ".xsl".length());
        }
        return filename;
    }

    protected void gTemplate(TabBuffer sb) {
        sb.indent();
        sb.append(this.comment("gTemplate"));
        sb.append("<xsl:template match=\"");
        sb.append(this.getMatchTarget());
        sb.append("\">");
        sb.cr();
    }

    protected void gBeforeTemplate(TabBuffer sb) {
        sb.append(this.comment("gBeforeTemplate"));
    }

    protected void gAfterTemplate(TabBuffer sb) {
        sb.append(this.comment("gAfterTemplate"));
    }

    protected void gBeginTable(TabBuffer sb, Map<String, Object> attrMap) {
        String[] attrs = new String[]{"class", "width", "cellspacing", "cellpadding"};
        sb.indent();
        sb.append(this.comment("gBeginTable"));
        sb.append_cr(this.gElemTag("table"));
        sb.forward();
        this.gExpandAttrMap(attrMap, attrs, sb);
        this.gTableTitle(sb);
    }

    protected void gEndTable(TabBuffer sb) {
        sb.back();
        sb.append(this.comment("gEndTable"));
        sb.append_cr(this.gElemTag("/table"));
        sb.back();
    }

    protected void gTableTitle(TabBuffer sb) {
    }

    protected void gTableTitle0(String title, TabBuffer sb, int colnum) {
        this.gTableTitle0(title, sb, colnum, "__jfc_common.tabletitle.ichiran");
    }

    protected void gTableTitle0(String title, TabBuffer sb, int colnum, String deftitlekey) {
        if (title != null && title.length() > 0) {
            deftitlekey = this.createResourceKey(title);
            JFCAppResourceGenerator.put(deftitlekey, title);
        } else if (deftitlekey == null || deftitlekey.length() == 0) {
            title = null;
        }
        if (title != null) {
            sb.forward();
            sb.append_cr(this.gElemTag("tr"));
            sb.forward();
            sb.append_cr(this.gElemTag("th"));
            sb.forward();
            sb.append_cr(this.gAttrTag("class", "table_title"));
            sb.indent();
            sb.append_cr(this.gAttrTag("colspan", colnum));
            sb.indent();
            sb.append(this.createRValueStatement(deftitlekey));
            sb.cr();
            sb.back();
            sb.append(this.gElemTag("/th"));
            sb.cr();
            sb.back();
            sb.append(this.gElemTag("/tr"));
            sb.cr();
        }
    }

    protected void gBeforeActionLink(TabBuffer sb) {
        sb.append(this.comment("gBeforeActionLink"));
    }

    protected void gAfterActionLink(TabBuffer sb) {
        sb.append(this.comment("gAfterActionLink"));
    }

    protected void gActionLink(TabBuffer sb) {
        this.gActionLink(sb, null);
    }

    protected void gActionLink(TabBuffer sb, FileTemplateManager tplman) {
        if (this.displaymodel == null) {
            Object[] o = new Object[]{this.action.getId(), this.idref};
            this.logger.error(this.rman.getValue("value.null.displaymodel.xsl", o));
            return;
        }
    }

    protected void gActionLink0(TabBuffer sb, Link link) {
        PrimaryKey[] pkeys;
        IRNode node;
        String label;
        sb.indent();
        sb.append_cr(this.comment("gActionLink0"));
        String laction = link.getAction();
        if (laction == null) {
            laction = "";
        }
        if ((label = link.getLabel()) == null || label.length() == 0) {
            label = "Button";
        }
        Model smodel = null;
        if (this.pmodel != null && (node = this.pmodel.getIdrefAsIRNode()) != null && node instanceof Model && "list".equals((smodel = (Model)node).getType()) && (node = smodel.getIdrefAsIRNode()) != null && node instanceof Model) {
            smodel = (Model)node;
        }
        HashSet<String> hiddenSet = new HashSet<String>();
        if (link.getHidden() != null) {
            StringTokenizer st = new StringTokenizer(link.getHidden(), ", ");
            while (st.hasMoreTokens()) {
                hiddenSet.add(st.nextToken());
            }
        }
        if ((pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(smodel, this.project)) != null) {
            for (int i = 0; i < pkeys.length; ++i) {
                PrimaryKey pkey = pkeys[i];
                hiddenSet.add(pkey.getName());
            }
        }
        Object forward = link.getForward();
        String confirm = link.getConfirm();
        String rkey_confirm = null;
        if (forward != null && ((String)forward).startsWith("delete")) {
            if (confirm == null || confirm.length() == 0) {
                rkey_confirm = "__jfc_common.confirm";
            } else {
                rkey_confirm = this.createResourceKey(laction, confirm);
                JFCAppResourceGenerator.put(rkey_confirm, confirm);
            }
        }
        sb.indent();
        sb.append(this.gElemTag("td"));
        sb.forward();
        sb.append(this.gAttrTag("class", "navigation_field"));
        sb.indent();
        sb.append(this.gAttrTag("valign", "top"));
        sb.indent();
        if (forward != null && ((String)forward).length() > 0) {
            Object submitcnt = null;
            submitcnt = confirm != null && confirm.length() > 0 && !StringUtil.isFullOf((String)confirm, (char)' ') ? "return doConfirm(this, '" + this.createRValueStatement(rkey_confirm) + "');" : "buttonOff(); return true;";
            if (!(((String)forward).endsWith(".html") || ((String)forward).endsWith(".htm") || ((String)forward).endsWith(".jsp"))) {
                forward = (String)forward + ".do";
            }
            sb.append(this.gElemTag("form"));
            sb.forward();
            sb.append(this.gAttrTag("name", "Nav" + (String)forward));
            sb.indent();
            sb.append(this.gAttrTag("action", (String)forward));
            sb.indent();
            sb.append(this.gAttrTag("method", "post"));
            sb.indent();
            sb.append(this.gAttrTag("onSubmit", (String)submitcnt));
            sb.indent();
            sb.append(this.gElemTag("input"));
            sb.forward();
            sb.append(this.gAttrTag("type", "hidden"));
            sb.indent();
            sb.append(this.gAttrTag("name", "SENDACTION"));
            sb.back();
            sb.append(this.gElemTag("/input"));
            confirm = null;
        }
        for (String name : hiddenSet) {
            IModelChoice[] imc;
            Modelitem mitem = null;
            if (smodel != null && (imc = smodel.getContent()) != null) {
                int i;
                for (i = 0; !(i >= imc.length || imc[i] instanceof Modelitem && name.equals((mitem = (Modelitem)imc[i]).getName())); ++i) {
                }
                if (i >= imc.length) {
                    mitem = null;
                }
            }
            if (mitem == null) {
                Object[] o = new Object[]{this.action.getId(), name};
                this.logger.error(this.rman.getValue("value.null.hiddenlist", o));
            }
            sb.indent();
            sb.append(this.gElemTag("input"));
            sb.forward();
            sb.append(this.gAttrTag("type", "hidden"));
            sb.indent();
            sb.append(this.gAttrTag("name", name));
            sb.indent();
            sb.append(this.gAttrTag("value"));
            sb.forward();
            sb.append("<xsl:value-of select=\"");
            sb.append(name);
            if (mitem != null && (mitem.getType().equals("masterref") || mitem.getType().equals("storeref"))) {
                sb.append("[1]/@id");
            }
            sb.append_cr("\"/>");
            sb.back();
            sb.append(this.gAttrTag("/value"));
            sb.back();
            sb.append(this.gElemTag("/input"));
        }
        if (this.hiddenlist.size() == 0) {
            sb.forward();
        } else {
            sb.indent();
        }
        this.gActionLink0_inputfield(sb, laction, label, confirm, link);
        if (forward != null && ((String)forward).length() > 0) {
            sb.back();
            sb.append(this.gElemTag("/form"));
        }
        sb.back();
        sb.append(this.gElemTag("/td"));
    }

    protected void gActionLink0_inputfield(TabBuffer sb, String name, String label, String confirm, Link link) {
        sb.indent();
        sb.append(this.gElemTag("input"));
        sb.forward();
        sb.append(this.gAttrTag("type", "submit"));
        if (name != null && name.length() > 0) {
            StringBuilder code = new StringBuilder();
            code.append("SENDACTION.name='action_");
            code.append(name);
            code.append("';");
            if (confirm != null && confirm.length() > 0) {
                code.insert(0, "var ret = doConfirm(this, '" + confirm + "');if (ret) { ");
                code.append("this.form.submit(); } else return false;");
            }
            sb.indent();
            sb.append(this.gAttrTag("name", "btn" + name));
            sb.indent();
            sb.append(this.gAttrTag("onClick", code.toString()));
        }
        sb.indent();
        String linkClass = link.getLinkClass();
        if (linkClass != null && linkClass.length() > 0) {
            sb.append_cr(this.gAttrTag("class", linkClass));
            sb.indent();
        }
        sb.append(this.gAttrTag("value", label));
        sb.back();
        sb.append(this.gElemTag("/input"));
        sb.cr();
    }

    protected String getMatchTarget() {
        return this.idref;
    }

    public String getInputForm() {
        String ret = this.presentation.getIdref();
        if (this.action.getWizard() && this.presentation.getFilename() != null) {
            ret = this.presentation.getFilename();
        }
        return ret + ".do";
    }

    protected void gFinish(TabBuffer sb) {
        sb.back();
        sb.append_cr(this.comment("gFinish"));
        sb.indent();
        sb.append("</xsl:template>");
        sb.cr();
        sb.cr();
        sb.back();
        sb.append("</xsl:stylesheet>");
        sb.cr();
    }

    protected void gHiddenlist(TabBuffer sb) {
        int size = this.hiddenlist.size();
        if (size > 0) {
            sb.indent();
            sb.append_cr("<!-- Hidden item process started. -->");
            String id = this.getMatchTarget();
            for (int i = 0; i < size; ++i) {
                Displayitem ditem = this.hiddenlist.get(i);
                String name = ditem.getName();
                sb.indent();
                sb.append(this.gElemTag("input"));
                sb.cr();
                sb.forward();
                sb.append(this.gAttrTag("type", "hidden"));
                sb.cr();
                sb.indent();
                sb.append(this.gAttrTag("name", XslGenerator.convertJavaVariableString(id + "/" + name)));
                sb.cr();
                sb.indent();
                sb.append(this.gAttrTag("value"));
                sb.cr();
                sb.forward();
                sb.append("<xsl:value-of select=\"");
                sb.append(name);
                sb.append("\"/>");
                sb.cr();
                sb.back();
                sb.append(this.gAttrTag("/value"));
                sb.cr();
                sb.back();
                sb.append(this.gElemTag("/input"));
                sb.cr();
            }
            sb.indent();
            sb.append_cr("<!-- Hidden item process finished. -->");
        }
    }

    protected Map<String, Object> createAttrMap(Link link) {
        return this.createAttrMap(link, new HashMap<String, Object>());
    }

    protected Map<String, Object> createAttrMap(Link link, Map<String, Object> map) {
        HashMap<String, Object> cmap = new HashMap<String, Object>(map);
        String classname = link.getValueClass();
        if (classname != null && classname.length() >= 0) {
            cmap.put("valueClass", classname);
        }
        return cmap;
    }

    protected Map<String, Object> createAttrMap(Displaycondition displaycondition) {
        return this.createAttrMap(displaycondition, new HashMap<String, Object>());
    }

    protected Map<String, Object> createAttrMap(Displaycondition displaycondition, Map<String, Object> map) {
        HashMap<String, Object> cmap = new HashMap<String, Object>(map);
        String s = displaycondition.getWidth();
        if (s != null && s.length() > 0) {
            cmap.put("width", s);
        }
        return cmap;
    }

    protected Map<String, Object> createAttrMap(Displaymodel displaymodel) {
        return this.createAttrMap(displaymodel, new HashMap<String, Object>());
    }

    protected Map<String, Object> createAttrMap(Displaymodel displaymodel, Map<String, Object> map) {
        HashMap<String, Object> cmap = new HashMap<String, Object>(map);
        String s = displaymodel.getWidth();
        if (s != null && s.length() >= 0) {
            cmap.put("width", s);
        }
        if ((s = displaymodel.getValueClass()) != null && s.length() >= 0) {
            cmap.put("valueClass", s);
        }
        if ((s = displaymodel.getLabelClass()) != null && s.length() >= 0) {
            cmap.put("labelClass", s);
        }
        boolean b = displaymodel.getAutoalignment();
        cmap.put("autoalignment", b);
        return cmap;
    }

    protected Map<String, Object> createAttrMap(Displayitem ditem) {
        return this.createAttrMap(ditem, new HashMap<String, Object>());
    }

    protected Map<String, Object> createAttrMap(Displayitem ditem, Map<String, Object> map) {
        boolean b;
        HashMap<String, Object> cmap = new HashMap<String, Object>(map);
        String s = ditem.getValueClass();
        if (s != null && s.length() >= 0) {
            cmap.put("valueClass", s);
        }
        if ((s = ditem.getLabelClass()) != null && s.length() >= 0) {
            cmap.put("labelClass", s);
        }
        if ((s = ditem.getWidth()) != null && s.length() >= 0) {
            cmap.put("width", s);
        }
        if ((s = ditem.getAlign()) != null && s.length() >= 0) {
            cmap.put("align", s);
        }
        if ((s = ditem.getValign()) != null && s.length() >= 0) {
            cmap.put("valign", s);
        }
        if (b = ditem.getNowrap()) {
            cmap.put("nowrap", "nowrap");
        }
        return cmap;
    }

    protected Map<String, Object> createAttrMap(Displaytext dtext) {
        return this.createAttrMap(dtext, new HashMap<String, Object>());
    }

    protected Map<String, Object> createAttrMap(Displaytext dtext, Map<String, Object> map) {
        boolean b;
        HashMap<String, Object> cmap = new HashMap<String, Object>(map);
        String s = dtext.getValueClass();
        if (s != null && s.length() >= 0) {
            cmap.put("valueClass", s);
        }
        if ((s = dtext.getWidth()) != null && s.length() >= 0) {
            cmap.put("width", s);
        }
        if ((s = dtext.getAlign()) != null && s.length() >= 0) {
            cmap.put("align", s);
        }
        if ((s = dtext.getValign()) != null && s.length() >= 0) {
            cmap.put("valign", s);
        }
        if (b = dtext.getNowrap()) {
            cmap.put("nowrap", "nowrap");
        }
        return cmap;
    }

    protected Map<String, Object> createAttrMap(Displayimage dimage) {
        return this.createAttrMap(dimage, new HashMap<String, Object>());
    }

    protected Map<String, Object> createAttrMap(Displayimage dimage, Map<String, Object> map) {
        HashMap<String, Object> cmap = new HashMap<String, Object>(map);
        String s = dimage.getContent();
        if (s != null && s.length() >= 0) {
            cmap.put("src", s);
        }
        if ((s = dimage.getWidth()) != null && s.length() >= 0) {
            cmap.put("width", s);
        }
        if ((s = dimage.getHeight()) != null && s.length() >= 0) {
            cmap.put("height", s);
        }
        if ((s = dimage.getHspace()) != null && s.length() >= 0) {
            cmap.put("hspace", s);
        }
        if ((s = dimage.getVspace()) != null && s.length() >= 0) {
            cmap.put("vspace", s);
        }
        if ((s = dimage.getAlt()) != null && s.length() >= 0) {
            cmap.put("alt", s);
        }
        return cmap;
    }

    protected Map<String, Object> createAttrMap(Displayitemgroup ditemg) {
        return this.createAttrMap(ditemg, new HashMap<String, Object>());
    }

    protected Map<String, Object> createAttrMap(Displayitemgroup ditemg, Map<String, Object> map) {
        boolean b;
        HashMap<String, Object> cmap = new HashMap<String, Object>(map);
        String s = ditemg.getWidth();
        if (s != null && s.length() >= 0) {
            cmap.put("width", s);
        }
        if ((s = ditemg.getValueClass()) != null && s.length() >= 0) {
            cmap.put("valueClass", s);
        }
        if ((s = ditemg.getLabelClass()) != null && s.length() >= 0) {
            cmap.put("labelClass", s);
        }
        if (b = ditemg.getNowrap()) {
            cmap.put("nowrap", "nowrap");
        }
        b = ditemg.getAutoalignment();
        cmap.put("autoalignment", b);
        return cmap;
    }

    protected void gExpandAttrMap(Map<String, Object> attrMap, TabBuffer sb) {
        this.gExpandAttrMap(attrMap, null, sb);
    }

    protected void gExpandAttrMap(Map<String, Object> attrMap, String[] attrs, TabBuffer sb) {
        this.gExpandAttrMap(attrMap, attrs, "position()", sb, true);
    }

    protected void gExpandAttrMap(Map<String, Object> attrMap, String[] attrs, String posname, TabBuffer sb) {
        this.gExpandAttrMap(attrMap, attrs, posname, sb, true);
    }

    protected void gExpandAttrMap(Map<String, Object> attrMap, String[] attrs, TabBuffer sb, boolean forceIndentFlag) {
        this.gExpandAttrMap(attrMap, attrs, "position()", sb, forceIndentFlag);
    }

    protected void gExpandAttrMap(Map<String, Object> attrMap, String[] attrs, String posname, TabBuffer sb, boolean forceIndentFlag) {
        HashSet<String> set = new HashSet<String>();
        if (attrs != null) {
            for (int i = 0; i < attrs.length; ++i) {
                set.add(attrs[i]);
            }
        }
        if (attrMap != null && attrMap.size() > 0) {
            for (String key : attrMap.keySet()) {
                String value;
                if (attrs != null && !set.contains(key) || (value = (String)attrMap.get(key)) == null || value.length() <= 0) continue;
                key = this.convertAttrKey(key);
                this.gExpandAttrMap0(key, value, posname, sb);
            }
        }
        if (forceIndentFlag) {
            sb.indent();
        }
    }

    protected void gExpandAttrMap0(String key, String value, TabBuffer sb) {
        this.gExpandAttrMap0(key, null, value, "position()", sb);
    }

    protected void gExpandAttrMap0(String key, String value, String posname, TabBuffer sb) {
        this.gExpandAttrMap0(key, null, value, posname, sb);
    }

    protected void gExpandAttrMap0(String key, String prevalue, String value, String posname, TabBuffer sb) {
        sb.indent();
        String[] values = null;
        StringTokenizer st = new StringTokenizer(value, ", ");
        ArrayList<String> l = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            l.add(st.nextToken());
        }
        values = l.toArray(new String[0]);
        if (values.length == 1) {
            sb.append_cr(this.gAttrTag(key, values[0]));
        } else {
            this.gExpandAttrMap_choose_when(key, prevalue, values, posname, sb);
        }
    }

    protected void gExpandAttrMap_choose_when(String key, String prevalue, String[] values, String posname, TabBuffer sb) {
        int size = values.length;
        sb.append_cr("<xsl:choose>");
        sb.forward();
        String elemname = "when";
        for (int k = 0; k < size; ++k) {
            if (k == size - 1) {
                elemname = "otherwise";
            }
            Object _value = null;
            _value = prevalue != null && prevalue.length() > 0 ? prevalue + "='" + values[k] + "'" : values[k];
            sb.indent();
            sb.append("<xsl:");
            sb.append(elemname);
            if (k < size - 1) {
                sb.append(" test=\"" + posname + " mod ");
                sb.append(size);
                sb.append(" = ");
                sb.append(k);
                sb.append("\"");
            }
            sb.append(">");
            sb.cr();
            sb.forward();
            sb.append(this.gAttrTag(key, (String)_value));
            sb.cr();
            sb.back();
            sb.append("</xsl:");
            sb.append(elemname);
            sb.append(">");
            sb.cr();
        }
        sb.back();
        sb.append_cr("</xsl:choose>");
    }

    protected String convertAttrKey(String key) {
        if (this.attrNameMap.keySet().contains(key)) {
            return this.attrNameMap.get(key);
        }
        return key;
    }

    protected String createValueOfName(Displayitem ditem, Modelitem mitem) {
        String name0;
        String name = name0 = mitem == null ? ditem.getName() : mitem.getName();
        int ptr = name0.indexOf("/");
        if (ptr >= 0) {
            StringBuilder buf = new StringBuilder();
            buf.append(XslGenerator.convertJavaVariableString(name0.substring(0, ptr)));
            buf.append(XslGenerator.convertJavaVariableString("["));
            buf.append("<xsl:value-of select=\"$pos\"/>");
            buf.append(XslGenerator.convertJavaVariableString("]/"));
            buf.append(XslGenerator.convertJavaVariableString(name0.substring(ptr + 1)));
            name = buf.toString();
        } else {
            name = XslGenerator.convertJavaVariableString(name0);
        }
        return name;
    }

    protected String createSelectName(Displayitem ditem, Modelitem sitem) {
        Relation rel;
        String name0 = sitem == null ? ditem.getName() : sitem.getName();
        int ptr = name0.indexOf("/");
        if (this instanceof XslGenerator_showList && sitem != null && ptr > 0 && "masterref".equals(sitem.getType()) && "radio".equals((rel = AppSchemaUtil.getRelation(sitem)).getType())) {
            return name0;
        }
        return ptr >= 0 ? name0.substring(ptr + 1) : name0;
    }

    protected String getParentName() {
        Displayitem ditem = null;
        IDisplaymodelChoice[] idmc = this.displaymodel.getContent();
        for (int i = 0; i < idmc.length && (!(idmc[i] instanceof Displayitem) || "hidden".equals((ditem = (Displayitem)idmc[i]).getType())); ++i) {
        }
        return this.getParentName(ditem);
    }

    protected String getParentName(Displayitem ditem) {
        String parentname = "";
        if (ditem != null) {
            String _name = ditem.getName();
            int idx = _name.indexOf("/");
            parentname = idx > 0 ? _name.substring(0, _name.indexOf("/")) : _name;
        }
        return parentname;
    }

    protected Object getParentNode(Displayitem ditem) {
        if (this.presentation == null) {
            return null;
        }
        Layout layout = this.presentation.getLayout();
        if (layout == null) {
            return null;
        }
        Panel[] panels = layout.getPanel();
        if (panels == null || panels.length == 0) {
            return null;
        }
        Panel panel = null;
        Object ret = null;
        for (int i = 0; i < panels.length && ((panel = panels[i]) == null || (ret = this.getParentNode0(panel, ditem)) == null); ++i) {
        }
        return ret;
    }

    protected Object getParentNode0(Panel panel, Displayitem ditem) {
        Object ret = null;
        IPanelChoice[] ipc = panel.getContent();
        if (ipc == null || ipc.length == 0) {
            return ret;
        }
        block0: for (int j = 0; j < ipc.length; ++j) {
            Displaymodel dm;
            if (ipc[j] instanceof Panel) {
                Panel panel2 = (Panel)ipc[j];
                ret = this.getParentNode0(panel2, ditem);
                if (ret == null) continue;
                break;
            }
            if (ipc[j] instanceof Displaycondition) {
                Displaycondition dc = (Displaycondition)ipc[j];
                ret = this.getParentNode0(dc, ditem);
                continue;
            }
            if (ipc[j] instanceof Displaymodelgroup) {
                Displaymodelgroup dmg = (Displaymodelgroup)ipc[j];
                IDisplaymodelgroupChoice[] idmgc = dmg.getContent();
                if (idmgc == null || idmgc.length == 0) continue;
                for (int k = 0; k < idmgc.length; ++k) {
                    Displaymodel dm2;
                    if (idmgc[k] instanceof Displaymodel && (ret = this.getParentNode0(dm2 = (Displaymodel)idmgc[k], ditem)) != null) break block0;
                }
                continue;
            }
            if (ipc[j] instanceof Displaymodel && (ret = this.getParentNode0(dm = (Displaymodel)ipc[j], ditem)) != null) break;
        }
        return ret;
    }

    protected Object getParentNode0(Displaycondition dc, Displayitem ditem) {
        Object ret = null;
        IDisplayconditionChoice[] idc = dc.getContent();
        for (int i = 0; i < idc.length; ++i) {
            Displayitem di;
            if (idc[i] instanceof Displayitemgroup) {
                Displayitemgroup dig = (Displayitemgroup)idc[i];
                ret = this.getParentNode1(dig, ditem);
                if (ret == null) continue;
                break;
            }
            if (!(idc[i] instanceof Displayitem) || !(di = (Displayitem)idc[i]).getName().equals(ditem.getName())) continue;
            ret = dc;
            break;
        }
        return ret;
    }

    protected Object getParentNode0(Displaymodel dm, Displayitem ditem) {
        Object ret = null;
        IDisplaymodelChoice[] idc = dm.getContent();
        for (int i = 0; i < idc.length; ++i) {
            Displayitem di;
            if (idc[i] instanceof Displayitemgroup) {
                Displayitemgroup dig = (Displayitemgroup)idc[i];
                ret = this.getParentNode1(dig, ditem);
                if (ret == null) continue;
                break;
            }
            if (!(idc[i] instanceof Displayitem) || !(di = (Displayitem)idc[i]).getName().equals(ditem.getName())) continue;
            ret = dm;
            break;
        }
        return ret;
    }

    protected Object getParentNode1(Displayitemgroup dig, Displayitem ditem) {
        Object ret = null;
        IDisplayitemgroupChoice[] idc = dig.getContent();
        for (int i = 0; i < idc.length; ++i) {
            Displayitem di;
            if (idc[i] instanceof Displayitemgroup) {
                Displayitemgroup dig2 = (Displayitemgroup)idc[i];
                ret = this.getParentNode1(dig2, ditem);
                if (ret == null) continue;
                break;
            }
            if (!(idc[i] instanceof Displayitem) || !(di = (Displayitem)idc[i]).getName().equals(ditem.getName())) continue;
            ret = dig;
            break;
        }
        return ret;
    }

    protected void gBody(TabBuffer sb) {
        sb.indent();
        sb.append(this.comment("gBody"));
        this.gTemplate(sb);
    }

    protected String getDataType(Modelitem item) {
        String mname;
        String _type;
        IRNode node;
        String type = "number";
        if (item == null) {
            return type;
        }
        Model smodel = null;
        if (this.pmodel != null && (node = this.pmodel.getIdrefAsIRNode()) != null && node instanceof Model) {
            smodel = (Model)node;
        }
        if (!JavaSourceGenerator.isBasicType(_type = AppSchemaUtil.getModelitemType(this.project, mname = smodel != null ? smodel.getId() : "", item))) {
            type = "text";
        }
        return type;
    }

    protected static String convertJavaVariableString(String s) {
        return StringUtil.convertHtmlIdString((String)s);
    }

    protected String createActionId() {
        return JspPanelContentBase.createActionId(this.action, this.idref);
    }

    protected static String createNameAttributeValue(String id, String name) {
        String vname = XslGenerator.convertJavaVariableString(id + "/") + name;
        return vname;
    }

    protected static String createNameAttributeValue_anorm(String id, String name) {
        String vname = XslGenerator.convertJavaVariableString(id + "/") + name + XslGenerator.convertJavaVariableString("/@anorm");
        return vname;
    }

    protected static String createNameAttributeValue_id(String id, String name) {
        String vname = XslGenerator.convertJavaVariableString(id + "/") + name + XslGenerator.convertJavaVariableString("[1]/@id");
        return vname;
    }

    protected static String createNameAttributeValue_content(String id, String name) {
        String vname = "_" + XslGenerator.convertJavaVariableString(id + "/") + name + XslGenerator.convertJavaVariableString("[1]/@id") + "_content";
        return vname;
    }

    public String createResourceKey(String content) {
        return this.createResourceKey("_total_group.1", content);
    }

    public String createResourceKey(String name, String content) {
        String id = null;
        Model smodel = AppSchemaUtil.getStoreModel(this.pmodel);
        if (smodel != null) {
            id = smodel.getId();
        }
        return JFCAppResourceGenerator.createModelResourceKey(id, name, content);
    }

    public final String createRValueStatement(String rkey) {
        StringBuilder sb = new StringBuilder();
        sb.append("<xsl:value-of select=\"jfcutils:getRValue('");
        sb.append(rkey);
        sb.append("', $__jfc_locale)\"/>");
        return sb.toString();
    }
}

