/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CompatibilityManager;
import jp.jasminesoft.jfc.gen.TabBuffer;
import jp.jasminesoft.jfc.gen.XslGenerator_showTotal;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Displayitem;
import jp.jasminesoft.jfc.gen.appschema.Displaymodel;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Item;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Presentation;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XslGenerator_showTotal2
extends XslGenerator_showTotal {
    protected Logger logger = LogManager.getLogger((String)XslGenerator_showTotal2.class.getName());
    private boolean _useCache = false;

    public XslGenerator_showTotal2(Project project, Action action, Presentation presentation, Model pmodel, String idref, Displaymodel displaymodel) {
        super(project, action, presentation, pmodel, idref, displaymodel);
        CompatibilityManager compatibilityManager = CompatibilityManager.getInstance();
        Object _key = "jp.jasminesoft.jfc.gen.XslGenerator_showTotal2.useCache";
        _key = (String)_key + "." + this.model.getId();
        this._useCache = compatibilityManager.getBooleanValue((String)_key);
    }

    @Override
    protected void gHeader_option2(TabBuffer sb) {
        if (this._useCache) {
            sb.append("<xsl:param name=\"__jfc_temporaryid\"/>");
            sb.cr();
        }
    }

    @Override
    protected void gTemplate2(TabBuffer sb) {
        int i;
        int dimension_size = this.dimensions.length;
        sb.indent();
        sb.append(this.comment("gTemplate2"));
        sb.append_cr("<xsl:for-each select=\"item\">");
        sb.forward();
        for (i = 0; i < this.dimensions.length; ++i) {
            if (i == 0) {
                sb.forward();
            } else {
                sb.indent();
            }
            String itemname = this.dimensions[i].getContent();
            Modelitem mitem = AppSchemaUtil.getModelitem(itemname, this.model);
            if (mitem == null) {
                Object[] o = new Object[]{this.action.getId(), this.model.getId(), itemname};
                this.logger.error(this.rman.getValue("xslt.total.modelitem.null", o));
                continue;
            }
            this.gOutputSortRule(mitem, i, sb);
        }
        sb.indent();
        sb.append_cr("<xsl:apply-templates select=\".\">");
        sb.forward();
        sb.append_cr("<xsl:with-param name=\"loop1_pos\" select=\"position()\"/>");
        sb.back();
        sb.append_cr("</xsl:apply-templates>");
        sb.back();
        sb.append_cr("</xsl:for-each>");
        if (this.isRowTotal || this.isColumnTotal) {
            sb.indent();
            sb.append_cr(this.gElemTag("tr"));
            if (this.isRowTotal) {
                sb.forward();
                sb.append_cr(this.gElemTag("th"));
                sb.forward();
                sb.append_cr(this.gAttrTag("colspan", Integer.toString(dimension_size)));
                sb.indent();
                sb.append_cr(this.gAttrTag("class", "display_label_total"));
                sb.indent();
                sb.append_cr(this.createRValueStatement(this.getResourceKeyAsRowTotal(this.majors)));
                sb.back();
                sb.append_cr(this.gElemTag("/th"));
            }
            if (this.majors != null) {
                if (this.isRowTotal) {
                    for (i = 0; i < this.majors.length; ++i) {
                        Item _item = this.majors[i];
                        if (this.masterItemSet.contains(_item.getContent()) || this.uncalculatableMajorItemSet.contains(_item.getContent())) {
                            String target = null;
                            if (this.masterItemSet.contains(_item.getContent())) {
                                target = "/@content";
                            } else if (this.uncalculatableMajorItemSet.contains(_item.getContent())) {
                                target = "";
                            }
                            this.gRowTotal_masterref(sb, _item, target);
                            continue;
                        }
                        this.gRowTotal_normal(sb, _item);
                    }
                }
                if (this.isColumnTotal && this.isRowTotal) {
                    sb.indent();
                    sb.append_cr(this.gElemTag("td"));
                    sb.forward();
                    sb.append_cr(this.gAttrTag("class", "display_field_total"));
                    sb.indent();
                    boolean isOutputStyle = false;
                    String style = AppSchemaUtil.getCommonStyleInAllDisplayitems(this.presentation);
                    if (StringUtils.isNotBlank((CharSequence)style)) {
                        sb.indent();
                        sb.append_cr("<xsl:element name=\"span\">");
                        sb.forward();
                        sb.append_cr("<xsl:attribute name=\"style\">" + style + "</xsl:attribute>");
                        sb.indent();
                        isOutputStyle = true;
                    }
                    sb.append("<xsl:value-of select=\"format-number(");
                    for (int i2 = 0; i2 < this.majors.length; ++i2) {
                        Item _item = this.majors[i2];
                        String _type = _item.getType();
                        sb.append("$");
                        sb.append(StringUtil.convertXslVariableString((String)(_type + "_" + _item.getContent())));
                        if (i2 >= this.majors.length - 1) continue;
                        sb.append("+");
                    }
                    sb.append(", '" + this.total_numberformat + "')\"/>");
                    sb.cr();
                    if (isOutputStyle) {
                        sb.back();
                        sb.append_cr("</xsl:element><!-- span -->");
                    }
                    sb.back();
                    sb.append_cr(this.gElemTag("/td"));
                }
            }
            sb.back();
            sb.append_cr(this.gElemTag("/tr"));
        }
    }

    @Override
    protected void gBeforeItem(TabBuffer sb) {
        String _type;
        Item _item;
        int i;
        Item dimension = this.dimensions[0];
        String itemname = dimension.getContent();
        Modelitem mitem = AppSchemaUtil.getModelitem(itemname, this.model);
        String sname = this.createNowValueName(mitem);
        String snamecontent = this.createNowValueName(mitem, "/@content");
        Item dimension2 = this.dimensions[1];
        String itemname2 = dimension2.getContent();
        Modelitem mitem2 = AppSchemaUtil.getModelitem(itemname2, this.model);
        String sname2 = this.createNowValueName(mitem2);
        String toplevel = "/" + this.idref + "/item";
        sb.append_cr("<xsl:param name=\"loop1_pos\"/>");
        sb.indent();
        sb.append("<xsl:variable name=\"now_value\" select=\"");
        sb.append(sname);
        sb.append_cr("\"/>");
        sb.indent();
        sb.append("<xsl:variable name=\"now_value_content\" select=\"");
        sb.append(snamecontent);
        sb.append_cr("\"/>");
        sb.indent();
        sb.append("<xsl:variable name=\"now_value2\" select=\"");
        sb.append(sname2);
        sb.append_cr("\"/>");
        if (this._useCache) {
            sb.indent();
            sb.append("<xsl:variable name=\"__count\" select=\"");
            sb.append("xmlutils:count($__jfc_temporaryid, '");
            sb.append(sname);
            sb.append_cr("', $now_value)\"/>");
        } else {
            sb.indent();
            sb.append("<xsl:variable name=\"__count\" select=\"");
            sb.append("count(");
            sb.append(toplevel);
            sb.append("[");
            sb.append(sname);
            sb.append_cr("=$now_value])\"/>");
        }
        if (this.majors != null && (this.isColumnTotal || this.isRowTotal)) {
            for (i = 0; i < this.majors.length; ++i) {
                _item = this.majors[i];
                _type = _item.getType();
                sb.indent();
                sb.append("<xsl:variable name=\"");
                sb.append(StringUtil.convertXslVariableString((String)("__" + _type + "_" + _item.getContent())));
                sb.append("\" ");
                sb.append("select=\"");
                if (this._useCache && "sum".equals(_type)) {
                    sb.append("xmlutils:sum($__jfc_temporaryid, '");
                    sb.append(_item.getContent());
                    sb.append_cr("', $now_value_content)\"/>");
                    continue;
                }
                sb.append(this.getProperFunction(_item));
                sb.append("(");
                sb.append(toplevel);
                sb.append("[");
                sb.append(sname);
                sb.append("=$now_value]");
                sb.append("/");
                sb.append(_item.getContent());
                if (this.masterItemSet.contains(_item.getContent()) && !this.uncalculatableMajorItemSet.contains(_item.getContent())) {
                    sb.append("/@content");
                }
                sb.append_cr(")\"/>");
            }
        }
        sb.indent();
        sb.append("<xsl:for-each select=\"");
        sb.append(toplevel);
        sb.append("[");
        sb.append(sname);
        sb.append("=$now_value]");
        sb.append_cr("\">");
        sb.forward();
        for (i = 0; i < this.dimensions.length; ++i) {
            if (i == 0) {
                sb.forward();
            } else {
                sb.indent();
            }
            String _itemname = this.dimensions[i].getContent();
            Modelitem _mitem = AppSchemaUtil.getModelitem(_itemname, this.model);
            this.gOutputSortRule(_mitem, i, sb);
        }
        sb.indent();
        sb.append_cr("<xsl:variable name=\"ptr\">");
        sb.forward();
        sb.append_cr("<xsl:call-template name=\"findPosition\">");
        sb.forward();
        sb.append_cr("<xsl:with-param name=\"now_value\" select=\"$now_value\"/>");
        sb.indent();
        sb.append_cr("<xsl:with-param name=\"now_value2\" select=\"$now_value2\"/>");
        sb.indent();
        sb.append("<xsl:with-param name=\"c_value\" select=\"");
        sb.append(sname);
        sb.append_cr("\"/>");
        sb.indent();
        sb.append("<xsl:with-param name=\"c_value2\" select=\"");
        sb.append(sname2);
        sb.append_cr("\"/>");
        sb.indent();
        sb.append_cr("<xsl:with-param name=\"loop2_pos\" select=\"position()\"/>");
        sb.back();
        sb.append_cr("</xsl:call-template>");
        sb.back();
        sb.append_cr("</xsl:variable>");
        sb.indent();
        sb.append_cr("<xsl:if test=\"$ptr &gt; 0 and position() = 1\">");
        sb.forward();
        sb.append_cr("<xsl:call-template name=\"displayFirstRow\">");
        sb.forward();
        sb.append_cr("<xsl:with-param name=\"now_value\" select=\"$now_value\"/>");
        sb.indent();
        sb.append_cr("<xsl:with-param name=\"__count\" select=\"$__count\"/>");
        if (this.isRowTotal || this.isColumnTotal) {
            for (i = 0; i < this.majors.length; ++i) {
                _item = this.majors[i];
                _type = _item.getType();
                sb.indent();
                sb.append("<xsl:with-param name=\"");
                sb.append(StringUtil.convertXslVariableString((String)("__" + _type + "_" + _item.getContent())));
                sb.append("\" select=\"$");
                sb.append(StringUtil.convertXslVariableString((String)("__" + _type + "_" + _item.getContent())));
                sb.append("\"/>");
                sb.cr();
            }
        }
        sb.back();
        sb.append_cr("</xsl:call-template>");
        sb.back();
        sb.append_cr("</xsl:if>");
        sb.back();
        sb.append_cr("</xsl:for-each>");
        sb.indent();
        sb.cr();
    }

    private String createNowValueName(Modelitem mitem) {
        return this.createNowValueName(mitem, "/@id");
    }

    private String createNowValueName(Modelitem mitem, String postfix) {
        Relation _rel;
        Object sname = mitem.getName();
        String type = mitem.getType();
        boolean isRefRelationType = false;
        if ("storeref".equals(type) && (_rel = AppSchemaUtil.getRelationTypeIsRef(mitem)) != null) {
            isRefRelationType = true;
            IRNode _node = _rel.getIdrefAsIRNode();
            if (_node != null && _node instanceof Model) {
                Model _refmodel = (Model)_node;
                Modelitem _refmodelitem = AppSchemaUtil.getModelitem(_rel.getName(), _refmodel);
                Relation _rel_refmodelitem = AppSchemaUtil.getRelationTypeExceptRef(_refmodelitem);
                if (_rel_refmodelitem != null) {
                    isRefRelationType = false;
                }
            }
        }
        if ("masterref".equals(type) || "storeref".equals(type) && !isRefRelationType) {
            sname = (String)sname + postfix;
        }
        return sname;
    }

    protected void gBeforeItem_masterref(TabBuffer sb, String sname, Item item) {
        this.gBeforeItem_masterref(sb, sname, item, "/@content");
    }

    protected void gBeforeItem_masterref(TabBuffer sb, String sname, Item item, String target) {
        String name = item.getContent();
        String numberformat = this.searchNumberFormat(name);
        sb.indent();
        sb.append("<xsl:for-each select=\"");
        sb.append(name);
        sb.append_cr("\">");
        sb.forward();
        sb.append_cr("<xsl:variable name=\"p\" select=\"position()\"/>");
        sb.indent();
        sb.append_cr(this.gElemTag("td"));
        sb.forward();
        sb.append_cr(this.gAttrTag("class", "middle_total_value"));
        boolean isOutputStyle = false;
        String style = AppSchemaUtil.getCommonStyleInAllDisplayitems(this.presentation);
        if (StringUtils.isNotBlank((CharSequence)style)) {
            sb.indent();
            sb.append_cr("<xsl:element name=\"span\">");
            sb.forward();
            sb.append_cr("<xsl:attribute name=\"style\">" + style + "</xsl:attribute>");
            sb.indent();
            isOutputStyle = true;
        }
        sb.indent();
        sb.append("<xsl:value-of select=\"format-number(sum(");
        sb.append("/");
        sb.append(this.idref);
        sb.append("/item[");
        sb.append(sname);
        sb.append("=$now_value]");
        sb.append("/");
        sb.append(name);
        sb.append("[position() = $p]");
        sb.append(target);
        sb.append("), ");
        sb.append("'" + numberformat + "')\"/>");
        sb.cr();
        if (isOutputStyle) {
            sb.back();
            sb.append_cr("</xsl:element><!-- span -->");
        }
        sb.back();
        sb.append_cr(this.gElemTag("/td"));
        sb.back();
        sb.append_cr("</xsl:for-each>");
        sb.indent();
    }

    protected void gBeforeItem_normal(TabBuffer sb, Item item) {
        String style;
        String name = item.getContent();
        String type = item.getType();
        String numberformat = this.searchNumberFormat(name);
        sb.indent();
        sb.append_cr(this.gElemTag("td"));
        sb.forward();
        sb.append_cr(this.gAttrTag("class", "middle_total_value"));
        sb.indent();
        boolean isOutputStyle = false;
        Displayitem ditem = AppSchemaUtil.getDisplayitem(name, this.presentation);
        if (ditem != null && StringUtils.isNotBlank((CharSequence)(style = ditem.getStyle()))) {
            sb.append_cr("<xsl:element name=\"span\">");
            sb.forward();
            sb.append_cr("<xsl:attribute name=\"style\">" + style + "</xsl:attribute>");
            sb.indent();
            isOutputStyle = true;
        }
        sb.append("<xsl:value-of select=\"format-number(");
        sb.append("$");
        sb.append(StringUtil.convertXslVariableString((String)("__" + type + "_" + name)));
        sb.append_cr(", '" + numberformat + "')\"/>");
        if (isOutputStyle) {
            sb.back();
            sb.append_cr("</xsl:element><!-- span -->");
        }
        sb.back();
        sb.append_cr(this.gElemTag("/td"));
    }

    @Override
    protected void gAddOtherTemplate(TabBuffer sb) {
        String _type;
        int i;
        Item dimension = this.dimensions[0];
        String itemname = dimension.getContent();
        Modelitem mitem = AppSchemaUtil.getModelitem(itemname, this.model);
        String snamecontent = this.createNowValueName(mitem, "/@content");
        String type = mitem.getType();
        Displayitem ditem = AppSchemaUtil.getDisplayitem(itemname, this.presentation);
        String style = ditem.getStyle();
        sb.back();
        sb.append_cr("</xsl:template>");
        sb.indent();
        sb.append_cr("<xsl:template name=\"displayFirstRow\">");
        sb.forward();
        sb.append_cr("<xsl:param name=\"now_value\"/>");
        sb.indent();
        sb.append_cr("<xsl:param name=\"__count\"/>");
        for (i = 0; i < this.majors.length; ++i) {
            Item _item = this.majors[i];
            _type = _item.getType();
            sb.indent();
            sb.append("<xsl:param name=\"");
            sb.append(StringUtil.convertXslVariableString((String)("__" + _type + "_" + _item.getContent())));
            sb.append("\"/>");
            sb.cr();
        }
        sb.indent();
        sb.append_cr(this.gElemTag("tr"));
        sb.forward();
        sb.append_cr(this.gElemTag("td"));
        sb.forward();
        sb.append_cr(this.gAttrTag("rowspan", "<xsl:value-of select=\"$__count + 1\"/>"));
        sb.indent();
        sb.append_cr(this.gAttrTag("class", "middle_total_label"));
        sb.indent();
        if (StringUtils.isNotBlank((CharSequence)style)) {
            sb.append_cr("<xsl:element name=\"span\">");
            sb.forward();
            sb.append_cr("<xsl:attribute name=\"style\">" + style + "</xsl:attribute>");
            sb.indent();
        }
        sb.append("<xsl:value-of select=\"");
        if ("masterref".equals(type)) {
            sb.append(itemname + "/@label");
        } else if ("storeref".equals(type)) {
            boolean needsContentSearch = false;
            boolean needsLabelSearch = false;
            Relation _rel = AppSchemaUtil.getRelationTypeExceptRef(mitem);
            if (_rel != null) {
                needsContentSearch = true;
            } else {
                Modelitem _rritem = AppSchemaUtil.getRelatedModelitemInCaseofTypeRef(this.project, this.model.getId(), mitem);
                if ("storeref".equals(_rritem.getType())) {
                    needsContentSearch = true;
                } else if ("masterref".equals(_rritem.getType())) {
                    needsLabelSearch = true;
                }
            }
            if (needsContentSearch) {
                sb.append(itemname + "/@content");
            } else if (needsLabelSearch) {
                sb.append(itemname + "/@label");
            } else {
                sb.append(itemname);
            }
        } else {
            sb.append(itemname);
        }
        sb.append_cr("\"/>");
        sb.back();
        if (StringUtils.isNotBlank((CharSequence)style)) {
            sb.append_cr("</xsl:element><!-- span -->");
            sb.back();
        }
        sb.append_cr(this.gElemTag("/td"));
        sb.indent();
        sb.append_cr(this.gElemTag("td"));
        sb.forward();
        sb.append_cr(this.gAttrTag("class", "middle_total_value"));
        sb.back();
        sb.append_cr(this.gElemTag("/td"));
        if (this.majors != null) {
            for (i = 0; i < this.majors.length; ++i) {
                Item _item = this.majors[i];
                if (this.masterItemSet.contains(_item.getContent()) || this.uncalculatableMajorItemSet.contains(_item.getContent())) {
                    String target = null;
                    if (this.masterItemSet.contains(_item.getContent())) {
                        target = "/@content";
                    } else if (this.uncalculatableMajorItemSet.contains(_item.getContent())) {
                        target = "";
                    }
                    this.gBeforeItem_masterref(sb, snamecontent, _item, target);
                    continue;
                }
                this.gBeforeItem_normal(sb, _item);
            }
        }
        if (this.isColumnTotal) {
            sb.indent();
            sb.append_cr(this.gElemTag("td"));
            sb.forward();
            sb.append_cr(this.gAttrTag("class", "display_field_total"));
            sb.indent();
            sb.append("<xsl:value-of select=\"format-number(");
            for (i = 0; i < this.majors.length; ++i) {
                Item _item = this.majors[i];
                _type = _item.getType();
                sb.append("$");
                sb.append(StringUtil.convertXslVariableString((String)("__" + _type + "_" + _item.getContent())));
                if (i >= this.majors.length - 1) continue;
                sb.append("+");
            }
            sb.append_cr(", '" + this.total_numberformat + "')\"/>");
            sb.back();
            sb.append_cr(this.gElemTag("/td"));
        }
        sb.back();
        sb.append_cr(this.gElemTag("/tr"));
        sb.back();
        sb.append_cr("</xsl:template>");
        sb.indent();
        sb.append_cr("<xsl:template name=\"findPosition\">");
        sb.forward();
        sb.append_cr("<xsl:param name=\"now_value\"/>");
        sb.indent();
        sb.append_cr("<xsl:param name=\"now_value2\"/>");
        sb.indent();
        sb.append_cr("<xsl:param name=\"c_value\"/>");
        sb.indent();
        sb.append_cr("<xsl:param name=\"c_value2\"/>");
        sb.indent();
        sb.append_cr("<xsl:param name=\"loop2_pos\"/>");
        sb.indent();
        sb.append_cr("<xsl:choose>");
        sb.forward();
        sb.append_cr("<xsl:when test=\"$now_value = $c_value and $now_value2 = $c_value2\">");
        sb.forward();
        sb.append_cr("<xsl:value-of select=\"$loop2_pos\"/>");
        sb.back();
        sb.append_cr("</xsl:when>");
        sb.indent();
        sb.append_cr("<xsl:when test=\"string-length($now_value2) = 0\">");
        sb.forward();
        sb.append_cr("<xsl:value-of select=\"$loop2_pos\"/>");
        sb.back();
        sb.append_cr("</xsl:when>");
        sb.indent();
        sb.append_cr("<xsl:otherwise>");
        sb.forward();
        sb.append_cr("<xsl:value-of select=\"0\"/>");
        sb.back();
        sb.append_cr("</xsl:otherwise>");
        sb.back();
        sb.append_cr("</xsl:choose>");
        sb.back();
    }

    @Override
    protected boolean isIgnoreItem(Displayitem ditem) {
        return this.dimensions != null && this.dimensions.length > 0 && ditem.getName().equals(this.dimensions[0].getContent());
    }
}

